/*!
 * Copyright (c) 2021, 2024, Oracle and/or its affiliates.
 */
/*!
 * Markdown Editor - APEX widget for markdown editors.
 * @fileOverview
 *
 * General To Do
 *
 * Open Questions
 *
 * Documentation
 *
 * - The markdown editor exposes the follow function used
 * parse and render the text content of elements in the DOM:
 *
 *  apex.widget.markdown.render( <jquery selector> {string} );
 *
 * will replace the content of the elemenents selected by
 * <selector> and parse its text using marked.js api.
 *
 * - It is posible to customize the markdown editor instances
 * in the page designer using the Initialization JavaScript Function
 * and passing a 'function(options){}' expression where
 *
 * options: {
 *  toolbar: {
 *      data:
 *          controls {array}:[
 *              {
 *                  type {string},
 *                  label {string},
 *                  action {string}: name of the action.
 *              }
 *              ...
 *          ]
 *      }
 *  }
 * }

 * See: widget.toolbar.js for more details.
 *
 * Inside the Initialization JavaScript expression, 'this' object is bound to
 * the actual instance of the markdown editor. It is also posible to modify
 * the text before it is previewed using the below function:
 *
 * MarkdownEditor.onBeforePreviewText: function(text){
 *  return text;
 * }
 *
 * Example:
 *
 * Initialization JavaScript (Page Designer):
 * ------------------------------------------------------------------------
 * function(options){
 *  var markdownInstance = this;
 *
 *  // overrides the default onBeforePreviewText behaviour.
 *
 *  markdownInstance.onBeforePreviewText = function(text){
 *
 *      // removes all the '*' chars from the current text in the editor
 *      // bofore sending it to the preview function.
 *      //
 *      // this won't change the current value of the editor.
 *      // it will only change the value sent to the preview function.
 *      return text.replace('*', '');
 *  }
 * }
 * ------------------------------------------------------------------------
 *
 * Assumptions
 *
 * Depends:
 * marked.js
 * DOMPurify.js
 * prism.js
 */
!function(e,t,n,i,o,r){"use strict";var a={C_RENDERED_CLASS:"is-markdownified",C_EVENT_NAME:"markdownified",C_BASIC_HTML_ESCAPE_MODE:"B",C_EXTENDED_HTML_ESCAPE_MODE:"E"},l=navigator.appVersion.indexOf("Mac")>=0;function s(t,n){var i=function(e){var t=[];return"BASIC"===e.whitelist?t=["b","i","u","em","strong","p","br"]:"IMAGE"===e.whitelist&&(t=["img"]),{preview:{parsing:{escapeInputHtml:"NONE"!==e.escapeInputHtml,htmlEscapeMode:a.C_EXTENDED_HTML_ESCAPE_MODE,htmlTagsWhitelisting:{enabled:"ALLOW_WHITELIST"===e.escapeInputHtml,allowAttributes:!0,whitelist:t},markedOptions:{gfm:!0,breaks:!0}},rendering:{highlightFencedCodeBlocks:!1}},designerOptions:e}}(n),o=this;o.onBeforePreviewText=function(e){return e};var r=e.extend({designerOptions:n,markDownEditor:o},i);o.editor=new a.Editor(t,r),o.getPreviewMode=function(){return o.editor.showingPreview},o.setPreviewMode=function(e){u(o.editor,o.onBeforePreviewText)(e)},o.itemize=function(){return function(e,t){var n={setValue:function(n){t.val(n).trigger("input"),e.getPreviewMode()&&g(!0,e.editor,e.onBeforePreviewText)},reinit:function(n){t.val(n).trigger("input"),e.getPreviewMode()&&g(!1,e.editor,e.onBeforePreviewText)}};return n}(o,t)}}a.C_HTML_TAGS_WHITELIST=["b","strong","i","em","p","span","hr","h1","h2","h3","h4","h5","h6"],a.htmlEscapeMode=a.C_EXTENDED_HTML_ESCAPE_MODE,marked.setOptions({gfm:!0,breaks:!0,mangle:!1}),t.markdown=function(t,n){n=e.extend(!0,{initJavascriptCode:function(){}},n);var o=e(t),r=new s(o,n),a=o.attr("id");return i.create(a,r.itemize()),r},t.markdown.render=function(t){p(e(t))},a.parserOptions={escapeInputHtml:!0,htmlEscapeMode:a.htmlEscapeMode,htmlTagsWhitelisting:{enabled:!1,allowAttributes:!1,whitelist:a.C_HTML_TAGS_WHITELIST},markedOptions:{gfm:!0,breaks:!0}};var c=new marked.Renderer,d=c.link;function p(t){t.each((function(){var t=e(this);t.html(a.parse(t.text())).addClass(a.C_RENDERED_CLASS),e(document).trigger(a.C_EVENT_NAME,t.get(0))}))}function u(e,t){return function(n){g(n,e,t)}}function g(t,n,i){var o,r,l,s=n.options.toolbar.actionsContext;n.showingPreview=t,s.list().forEach((({name:e})=>{"preview"!==e&&(n.showingPreview?s.disable(e):s.enable(e))})),n.toolbar$.toolbar("refresh"),o=n.editorContainer.textarea$.val(),l=n.editorContainer.textarea$.parent(),r=e(l).outerHeight();var c="";if(n.showingPreview){var d=i(o);if(d.length>0)c=a.parse(d);else c='<p style="color: #959595">'+n.getPreviewEmptyMessage()+"</p>"}n.previewPanel$.html(c).css("height",n.showingPreview?r:"").toggleClass("a-MDEditor-previewPanel--hide",!n.showingPreview).toggleClass(a.C_RENDERED_CLASS,n.showingPreview),n.showingPreview?n.editorContainer.textarea$.css("visibility","hidden"):n.editorContainer.textarea$.css("visibility","initial").trigger("focus")}function h(e){return e.getSelectionProperties().selectedText}function f(e,t,n){var i=function(e,t,n){n=n||t;var i=!1,o=h(e);return 0===o.indexOf(t)&&o.lastIndexOf(n)===o.length-n.length&&(i=!0),i}(e,t,n=n||t);if(i){n=n||t;var o=h(e),r=o.substring(t.length,o.length-n.length);e.replaceSelection(r)}else e.wrapSelection(t,n)}function E(t){var n=e(t.target);setTimeout((function(){n.find("input").first().trigger("focus")}),1)}function v(t,n){return[{name:"bold",action:function(){f(t.editorContainer,"**")},shortcut:l?"Meta+B":"Ctrl+B"},{name:"italics",action:function(){f(t.editorContainer,"_")},shortcut:l?"Meta+I":"Ctrl+I"},{name:"strikethrough",action:function(){f(t.editorContainer,"~~")},shortcut:l?"Meta+Shift+X":"Ctrl+Shift+X"},{name:"inline-code",action:function(){f(t.editorContainer,"```\n","\n```")}},{name:"addHeader",action:function(){t.editorContainer.prefixLines((t.editorContainer.getSelectionProperties().selectionStartsInZero?"":"\n")+"# ")}},{name:"unorderedList",action:function(){t.editorContainer.prefixLines((t.editorContainer.getSelectionProperties().selectionStartsInZero?"":"\n")+"- ")}},{name:"orderedList",action:function(){t.editorContainer.prefixLines((t.editorContainer.getSelectionProperties().selectionStartsInZero?"":"\n")+"1. ",!0)}},{name:"codeBlock",action:function(){var e=t.editorContainer.getSelectionProperties();t.editorContainer.wrapSelection((e.selectionStartsInZero?"":"\n\n")+"```\n","\n```")}},{name:"blockquote",action:function(){t.editorContainer.prefixLines((t.editorContainer.getSelectionProperties().selectionStartsInZero?"":"\n")+"> ")}},{name:"link",action:function(){var n=t.editorContainer.getSelectionProperties(),i=a.Editor.createTextInput({id:"MARKDOWNIFY_EDITOR_LINK_TEXT",label:"Text",placeholder:"Link Description"}),o=a.Editor.createTextInput({id:"MARKDOWNIFY_EDITOR_LINK_URL",label:"URL",placeholder:"https://..."}),r=e("<form></form>").append(i.field).append(o.field);if(n.selectedText.match(/^[a-z]+:\/\//))t.editorContainer.wrapSelection("[](",")");else if(n.selectionLength>0)t.editorContainer.wrapSelection("[","]()");else{var l=function(){var e=i.input.val().trim(),n=o.input.val().trim();t.editorContainer.wrapSelection("["+e,"]("+n+")"),s.dialog("close").remove()},s=r.dialog({autoOpen:!0,height:"auto",width:350,modal:!0,title:w("INSERT_LINK"),buttons:{Cancel:function(){s.dialog("close").remove()},OK:l},focus:function(e){E(e)},close:function(){r.get(0).reset()},create:function(){e(this).parents(".ui-dialog").find(".ui-button:contains(OK)").addClass("ui-button--hot")}});C(s,l),s.parent().addClass("ui-dialog--markdown")}}},{name:"image",action:function(){var n,i=t.editorContainer.getSelectionProperties(),o=a.Editor.createTextInput({id:"MARKDOWNIFY_EDITOR_IMAGE_TEXT",label:"Text",placeholder:"Image Description"}),r=a.Editor.createTextInput({id:"MARKDOWNIFY_EDITOR_IMAGE_URL",label:"URL",placeholder:"http://..."}),l=e("<form></form>").append(o.field).append(r.field);function s(){var i,a,l="ORIGINAL",s=e("<img>").attr({src:r.input.val(),alt:o.input.val()});switch(l){case"SMALL":s.css({width:"30%"});break;case"MEDIUM":s.css({width:"50%"});break;case"LARGE":s.css({width:"100%"})}i="!["+o.input.val(),a="]("+r.input.val()+")",t.editorContainer.wrapSelection(i,a),n.dialog("close").remove()}i.selectedText.match(/^[a-z]+:\/\//)?t.editorContainer.wrapSelection("![](",")"):i.selectionLength>0?t.editorContainer.wrapSelection("![","]()"):(C(n=l.dialog({autoOpen:!0,height:"auto",width:400,modal:!0,title:w("INSERT_IMAGE"),buttons:{Cancel:function(){n.dialog("close").remove()},OK:s},close:function(){l.get(0).reset()},focus:function(e){E(e)},create:function(){e(this).parents(".ui-dialog").find(".ui-button:contains(OK)").addClass("ui-button--hot")}}),s),n.parent().addClass("ui-dialog--markdown"))}},{name:"preview",get:function(){return t.showingPreview},set:u(t,n.onBeforePreviewText),shortcut:l?"Meta+P":"Ctrl+P"}]}function C(t,n){t.on("keydown",(function(t){if(t.keyCode===e.ui.keyCode.ENTER)n()}))}function m(e){return"APEX.MARKDOWN."+e}function w(e){return o.getMessage(m(e))}function T(e,t){var n=[{type:"BUTTON",labelKey:m("LINK"),iconOnly:!0,icon:"icon-link",action:"link"},{type:"BUTTON",labelKey:m("IMAGE"),iconOnly:!0,icon:"icon-picture",action:"image"}],i=[{groupTogether:!0,controls:[{type:"BUTTON",labelKey:m("BOLD"),iconOnly:!0,icon:"icon-bold",action:"bold"},{type:"BUTTON",labelKey:m("ITALIC"),iconOnly:!0,icon:"icon-italic",action:"italics"},{type:"BUTTON",labelKey:m("INLINE_CODE"),iconOnly:!0,icon:"icon-code",action:"inline-code"}]},{groupTogether:!0,controls:[{type:"BUTTON",labelKey:m("UNORDERED_LIST"),iconOnly:!0,icon:"icon-list-ul",action:"unorderedList"},{type:"BUTTON",labelKey:m("ORDERED_LIST"),iconOnly:!0,icon:"icon-list-ol",action:"orderedList"}]},{groupTogether:!0,controls:[{type:"BUTTON",label:"Blockquote",iconOnly:!0,icon:"icon-quote",action:"blockquote"}]},{groupTogether:!0,controls:n}];i.push({groupTogether:!1,align:"end",controls:[r()]});var o=t.designerOptions.toolbar;function r(){return{type:"TOGGLE",labelKey:m("PREVIEW"),action:"preview"}}return"SIMPLE"!==o&&o?"NONE"===o&&(i=[]).push({groupTogether:!1,align:"end",controls:[r()]}):n.pop(),i}c.link=function(...e){return d.call(c,...e).replace(/^<a /,'<a target="_blank" ')},a.parse=function(e){var t=marked.parse(e,{renderer:c});return r.sanitizeHtml(t)},a.render=function(t){p(e(t).filter(':not([data-markdown]), [data-markdown="true"]').filter(":not( ."+a.C_RENDERED_CLASS+" )"))},a.EditorContainer=function(t,n){var i=this;i.textarea$=e(t).filter("textarea").eq(0),i.id=i.textarea$.attr("id"),n&&function(t){const n="a-MDEditor-live",i=n+"--enabled",o=t.wrap("<div>").parent().addClass([n,i]),r=e("<pre>").addClass("language-markdown no-whitespace-normalization is-syntax-highlighted").attr("tabindex","-1"),a=e("<code>");r.append(a),r.insertBefore(t);const l=()=>{let e=t[0].value;e.length>4e3?o.removeClass(i):(o.addClass(i),/\n$/.test(e)&&(e+="​"),a[0].textContent=e,Prism.highlightElement(a[0]))};t.on("input propertychange change",l),t[0].addEventListener("scroll",(()=>{r.scrollTop(t.scrollTop())}),{passive:!0}),l()}(i.textarea$),i.textarea$.removeClass("is-placeholder")},a.EditorContainer.prototype.getSelectionProperties=function(){var e=this.textarea$[0],t=e.selectionStart,n=e.selectionEnd,i=e.value.substring(t,n);return{selectedText:i,selectionLength:i.length,selectionStartsInZero:0===t,selectionStart:t,selectionEnd:n}},a.EditorContainer.prototype.replaceSelection=function(e,t="all"){var n=this.textarea$[0],i=n.value,o=n.selectionStart,r=n.selectionEnd;n.value=i.substring(0,o)+e+i.substring(r,i.length),this.textarea$.trigger("change"),setTimeout((()=>{this.textarea$.trigger("focus"),"all"===t?n.setSelectionRange(o,o+e.length):"end"===t&&n.setSelectionRange(o+e.length,o+e.length)}),1)},a.EditorContainer.prototype.wrapSelection=function(e,t){this.replaceSelection((e||"")+this.getSelectionProperties().selectedText+(t||""))},a.EditorContainer.prototype.prefixLines=function(e){var t=this.getSelectionProperties(),n=this;t.selectionLength>0&&(t.selectedText=t.selectedText.split("\n").join("\n"+e)),this.replaceSelection((e||"")+t.selectedText,"end"),setTimeout((function(){n.textarea$.trigger("focus")}),1)},a.Editor=function(t,i){var o,r,l=this,s=i.markDownEditor;l.getPreviewEmptyMessage=function(){var e=i.designerOptions.previewEmptyMessage;return e.length>1&&(e=(e=e.substring(1)).substring(0,e.length-1)),e},l.options=e.extend(!0,{preview:{parsing:a.parserOptions},toolbar:(o=l,r=i,{data:T(o,r),actions:v(o,r.markDownEditor),cursorKeyNavigation:!1})},i),i.designerOptions.initJavascriptCode.call(s,l.options),l.showingPreview=!1,l.editor$=e("<div></div>").addClass("a-MDEditor apex-item-markdown-editor"),l.toolbar$=e("<div></div>").addClass("a-MDEditor-toolbar"),l.options.toolbar.actionsContext=n.createContext("apex.markdown.Editor",l.editor$.get(0)),l.options.toolbar.actionsContext.add(l.options.toolbar.actions),l.previewPanel$=e("<div></div>").addClass("a-MDEditor-previewPanel a-MDEditor-previewPanel--hide"),l.content$=e("<div></div>").addClass("a-MDEditor-content"),l.editorContainer$=l.content$,l.content$=e(t).filter("textarea").wrap(l.content$).parent().wrap(l.editor$).before(l.toolbar$).prepend(l.previewPanel$),l.editorContainer=new a.EditorContainer(t,l.options.designerOptions.syntaxHighlighting),l.toolbar$.toolbar(l.options.toolbar)},a.Editor.createTextInput=function(t){var n=e("<input />").addClass("text_field apex-item-text").attr({type:"text",id:t.id,name:t.id}),i=e("<div></div>").addClass("u-Form-itemWrapper").append(n),o=e("<div></div>").addClass("u-Form-inputContainer col col-null").append(i),r=e("<label></label>").addClass("u-Form-label").attr("for",t.id).text(t.label),a=e("<div></div>").addClass("u-Form-labelContainer col col-null").append(r),l=e("<div></div>").addClass("u-Form-fieldContainer rel-col apex-item-wrapper apex-item-wrapper--text-field").append(a).append(o);return"placeholder"in t&&o.attr("placeholder",t.placeholder),{field:l,label:r,input:n}}}(apex.jQuery,apex.widget,apex.actions,apex.item,apex.lang,apex.util);