/*!
 Date Picker - APEX component for picking dates. Supports rendering as date/datetimepicker or native date form controls
 Copyright (c) 2022, 2024, Oracle and/or its affiliates.
 */
!function(e,t,a,n,r,l,s,o,i){"use strict";const d=a.getTopApex().jQuery,c="dayFormatter",u="apex_disabled",p="apex-item-datepicker",m="a-DatePicker",f="a-Icon",_="u-vh",D="ui-dialog-datepicker",g="is-selected",v="is-disabled",h="icon-calendar-time",y="icon-calendar",C=m+"-actions",b="ALL",T="DAY",w="HOUR",E="MINUTE",M="YYYY-MM-DD",A='YYYY-MM-DD"T"HH24:MI',S='YYYY-MM-DD"T"HH24:MI:SS',I="YYYYMMDDHH24MI",N="change",x="click",k="id",V="size",$="placeholder",O="valid-example",Y="required",U="maxlength",B="minlength",L="disabled",H="aria-label",P="aria-haspopup",R="tabindex",F="aria-labelledby",K="aria-controls",q="aria-hidden",W="role",j="value",z="name",Q="type",X="title",J="readonly",G="autofocus",Z="autocomplete",ee="aria-describedby",te="aria-expanded",ae="aria-disabled",ne="aria-selected",re="region",le="none",se="link",oe="inline",ie="selectable",de="popup",ce="native",ue="focus",pe="click",me="number",fe="number-of-month",_e="one-month",De="visible",ge="hidden",ve=n.getMessage,he="APEX.DATEPICKER.",ye=he+"SELECT_DATE_AND_TIME",Ce=he+"SELECT_DATE",be=he+"SELECT_DAY",Te=he+"ISO_WEEK",we=he+"ISO_WEEK_ABBR",Ee=he+"SELECT_TIME",Me=he+"HOUR",Ae=he+"MINUTES",Se=he+"AM_PM",Ie=he+"ACTIONS",Ne=he+"MONTH",xe=he+"YEAR",ke=he+"PREVIOUS_MONTH",Ve=he+"NEXT_MONTH",$e=he+"DONE",Oe=he+"TODAY",Ye=he+"CLEAR",Ue=he+"SELECT_MONTH_AND_YEAR",Be=he+"VISUALLY_HIDDEN_EDIT",Le=he+"POPUP",He=he+"VALUE_MUST_BE_BETWEEN",Pe=he+"VALUE_MUST_BE_ON_OR_AFTER",Re=he+"VALUE_MUST_BE_ON_OR_BEFORE",Fe=he+"VALUE_INVALID",Ke="ArrowRight",qe="ArrowLeft",We={getNumberOfDays:function(e,t){let a=e+t;for(;a%7!=0;)a+=1;return a},setMonth:function(e,t){let a=e.getDate();return e.setMonth(t),e.getDate()!==a&&e.setDate(0),e},getMinuteOptions:function(e){let t=e;(e<1||e>60)&&(t=1);const a=Math.ceil(60/t),n=[];for(let e=0;e<a;e++){const a=e*t;n.push(a)}return n},getYearDifference:function(e,t){let a=(e.getTime()-t.getTime())/1e3;return a/=86400,Math.ceil(Math.abs(a/365.25))},findClosestMinute:function(e,t){let a=We.getMinuteOptions(e);return a.push(60),a.reduce(((e,a)=>{const n=Math.abs(e-t),r=Math.abs(a-t);return n===r?e>a?e:a:r<n?a:e}))},checkMinMax:function(e,t,a=r.UNIT.SECOND){return e.minDate&&e.maxDate?r.isSameOrAfter(t,e.minDate,a)&&r.isSameOrBefore(t,e.maxDate,a):e.minDate?r.isSameOrAfter(t,e.minDate,a):!e.maxDate||r.isSameOrBefore(t,e.maxDate,a)},parseMinMax:function(e,t){try{return r.parse(e,t)}catch(e){}try{return r.parse(e,S)}catch(e){}try{return r.parse(e,A)}catch(e){}try{return r.parse(e,M)}catch(e){}try{return r.parse(e,I)}catch(e){}return null},updateMinMax:function(e){e.min?(e.minDate=We.parseMinMax(e.min,e.format),null===e.minDate&&l.error(`Min must (${e.min}) match the following formats:`,[e.format,S,I])):e.minDate=null,e.max?(e.maxDate=We.parseMinMax(e.max,e.format),null===e.maxDate&&l.error(`Max must (${e.max}) match the following formats:`,[e.format,S,I])):e.maxDate=null},moveCalendarView:function(e,t,n,l){let s=n;if(We.render(e,t),!s){const n=r.format(We.calcCurrentCalendarDate(e,t,l)||e._currentCalendarDate,M);s="td[data-date='"+a.escapeCSS(n)+"']"}queueMicrotask((function(){d(e._calendar).find(s).trigger("focus")}))},calcCurrentCalendarDate:function(e,t,a){let n=null;if(!a)return n;e._currentCalendarDate&&(n=r.clone(e._currentCalendarDate)),We.checkMinMax(t,a,r.UNIT.DAY)?n=r.clone(a):t.minDate&&r.isBefore(a,t.minDate,r.UNIT.DAY)?n=r.clone(t.minDate):t.maxDate&&r.isAfter(a,t.maxDate,r.UNIT.DAY)&&(n=r.clone(t.maxDate));const l=We.findClosestMinute(t.timeIncrementMinute,n.getMinutes());if(60===l){const e=l-n.getMinutes();n=r.add(n,e,r.UNIT.MINUTE)}else n.setMinutes(l);return n},commitValue:function(e,t){let a;e._pendingValue&&(e._pendingValue.setSeconds(0),a=r.format(e._pendingValue,t.format)),e.setValue(a)},setDateToValue:function(e,t,a,n,r){let l=e._pendingValue||e._currentCalendarDate||new Date;a?([T,b].includes(n)&&(l=new Date(a.getFullYear(),a.getMonth(),a.getDate(),l.getHours(),l.getMinutes(),l.getSeconds(),0)),[w,b].includes(n)&&l.setHours(a.getHours()),[E,b].includes(n)&&l.setMinutes(a.getMinutes())):l=null,e._pendingValue=l,r||e.showTime&&t.displayAs!==oe||We.commitValue(e,t)},elements:{getActive:function(e){return d(e._calendar).find(".is-selected")},getSelectable:function(e){return d(e._calendar).find("td[data-date]")},getFocusElement:function(e){const t=We.elements.getActive(e);return t.length?t:We.elements.getSelectable(e).first()}},addKeyBoardNavigation:function(e,n){We.elements.getSelectable(e).off("keydown.document"+e._elementIDSafe),n.disabled||We.elements.getSelectable(e).on("keydown.document"+e._elementIDSafe,(function(l){const s=r.parse(t(l.currentTarget).attr("data-date"),M);let o,i,c,u="td[data-date='#DATADATE#']",p=n.previousNextDistanceSteps,m=r.UNIT.MONTH;switch(l.code){case"Home":l.preventDefault(),c=d(l.currentTarget).closest("tr").find("td[data-date]").first(),c.trigger("focus");break;case"End":l.preventDefault(),c=d(l.currentTarget).closest("tr").find("td[data-date]").last(),c.trigger("focus");break;case"PageDown":l.preventDefault(),!0===l.shiftKey&&(m=r.UNIT.YEAR,p=1),o=r.add(r.clone(s),1,m),i=r.format(o,M),c=d(e._calendar).find(u.replace("#DATADATE#",a.escapeCSS(i))).first(),c.length?c.trigger("focus"):(e._currentCalendarDate=We.calcCurrentCalendarDate(e,n,r.add(r.clone(e._currentCalendarDate),p,m)),We.moveCalendarView(e,n,null,o));break;case"PageUp":l.preventDefault(),!0===l.shiftKey&&(m=r.UNIT.YEAR,p=1),o=r.subtract(r.clone(s),1,m),i=r.format(o,M),c=d(e._calendar).find(u.replace("#DATADATE#",a.escapeCSS(i))).first(),c.length?c.trigger("focus"):(e._currentCalendarDate=We.calcCurrentCalendarDate(e,n,r.subtract(r.clone(e._currentCalendarDate),p,m)),We.moveCalendarView(e,n,null,o));break;case e._backwardkey:l.preventDefault(),o=r.subtract(r.clone(s),1,r.UNIT.DAY),i=r.format(o,M),c=d(e._calendar).find(u.replace("#DATADATE#",a.escapeCSS(i))).last(),c.length?c.trigger("focus"):(e._currentCalendarDate=We.calcCurrentCalendarDate(e,n,r.lastOfMonth(r.subtract(r.clone(e._currentCalendarDate),p,r.UNIT.MONTH))),We.moveCalendarView(e,n,null,o));break;case e._forwardKey:l.preventDefault(),o=r.add(r.clone(s),1,r.UNIT.DAY),i=r.format(o,M),c=d(e._calendar).find(u.replace("#DATADATE#",a.escapeCSS(i))).first(),c.length?c.trigger("focus"):(e._currentCalendarDate=We.calcCurrentCalendarDate(e,n,r.firstOfMonth(r.add(r.clone(e._currentCalendarDate),p,r.UNIT.MONTH))),We.moveCalendarView(e,n,null,o));break;case"ArrowDown":l.preventDefault(),o=r.add(r.clone(s),7,r.UNIT.DAY),i=r.format(o,M),c=d(e._calendar).find(u.replace("#DATADATE#",a.escapeCSS(i))).first(),c.length?c.trigger("focus"):(e._currentCalendarDate=We.calcCurrentCalendarDate(e,n,r.add(r.clone(e._currentCalendarDate),p,r.UNIT.MONTH)),We.moveCalendarView(e,n,null,o));break;case"ArrowUp":l.preventDefault(),o=r.subtract(r.clone(s),7,r.UNIT.DAY),i=r.format(o,M),c=d(e._calendar).find(u.replace("#DATADATE#",a.escapeCSS(i))).first(),c.length?c.trigger("focus"):(e._currentCalendarDate=We.calcCurrentCalendarDate(e,n,r.subtract(r.clone(e._currentCalendarDate),p,r.UNIT.MONTH)),We.moveCalendarView(e,n,null,o));break;case"Enter":case"Space":l.preventDefault(),l.stopPropagation(),d(this).click();break;case"Escape":n.displayAs===de&&(l.preventDefault(),l.stopPropagation(),We.dialog.close(e))}}))},dialog:{show:function(e){if(!e._dialogOpen){const t={id:e._elementIDSafe+"_dialog",title:n.formatMessageNoEscape(Le,e._elementLabelSafe),isPopup:!0,parentElement:e,returnFocusTo:e._wrappedElement$,noOverlay:!0,draggable:!0,resizable:!1,width:"auto",height:"auto",okButton:!1,dialogClass:D,notification:!1,callback:function(){e._skipFocus=!0,e._popupButton$.removeClass(u),e._popupButton$.attr(te,"false"),e._wrappedElement$.attr(te,"false"),e._dialogOpen=!1,queueMicrotask((function(){e._skipFocus=!1}))},init:function(t){t.empty(),t.append('<input type="hidden" autofocus="autofocus" />'),t.append(e._calendar)},open:function(t){e._dialog$=d(t.target);e._dialog$.closest("."+D).find(".ui-dialog-titlebar").addClass(_),e._popupButton$.addClass(u),e._popupButton$.attr(te,"true"),e._wrappedElement$.attr(te,"true"),e._dialogOpen=!0}};e._dialog$=o.showDialog("",t)}},close:function(e){e._dialog$&&e._dialog$.popup("close")},destroy:function(e){e._dialog$&&(e._dialog$.popup("close"),e._dialog$.closest("."+D).remove(),e._dialog$=null)}},setCalendarHours:function(e,t,a,n){let r=parseInt(a.val(),10);e._ampm&&n&&("PM"===n.val()&&12!==r&&(r+=12),"AM"===n.val()&&12===r&&(r=0));const l=(new Date).setHours(r);We.setDateToValue(e,t,new Date(l),w)},addOrRemoveAttributes:function(e,t,a){"boolean"==typeof a?e.prop(t,a):a?e.attr(t,a):e.removeAttr(t)},createOrUpdateInput:function(e,a){e._wrappedElement$||(e._wrappedElement$=e.element.find("input")),0===e._wrappedElement$.length&&(e._wrappedElement$=t("<input>"),e.element.append(e._wrappedElement$),e._wrappedElement$.val(e.element.val())),e._wrappedElement$.off("change."+e._elementID),e._wrappedElement$.on("change."+e._elementID,(function(){e.refresh()})),e._wrappedElement$.attr(k,e._inputIDSafe),e._wrappedElement$.addClass("apex-item-text"),e._wrappedElement$.addClass("apex-item-datepicker"),e._wrappedElement$.addClass(p),a.displayAs===ce?(e.element.addClass(p+"-"+ce),e.element.removeClass(p+"-"+de),e.element.removeClass(p+"-"+oe),a.minDate&&We.addOrRemoveAttributes(e._wrappedElement$,"min",a.min),a.maxDate&&We.addOrRemoveAttributes(e._wrappedElement$,"max",a.max),a.showTime?(e._wrappedElement$.attr(Q,"datetime-local"),a.format=A):(e._wrappedElement$.attr(Q,"date"),a.format=M)):e._wrappedElement$.attr(Q,"text"),a.displayAs===oe?(e._wrappedElement$.prop(J,!0),e._wrappedElement$.attr(R,"-1"),e._wrappedElement$.attr("aria-roledescription",ve(Be)),e._wrappedElement$.addClass(_)):(e._wrappedElement$.prop(J,a.readonly),a.tabindex||""+a.tabindex=="0"?e._wrappedElement$.attr(R,a.tabindex):e._wrappedElement$.removeAttr(R,a.tabindex),e._wrappedElement$.removeAttr("aria-roledescription"),e._wrappedElement$.removeClass(_)),a.displayAs===de?(e._wrappedElement$.attr(P,"dialog"),e._wrappedElement$.attr(W,"combobox")):e._wrappedElement$.removeAttr(P,"dialog"),e._wrappedElement$.prop(L,a.disabled),e._wrappedElement$.prop(Y,a.required),e._inputRegistered||([ue,pe].includes(a.showOn)&&e._wrappedElement$.on(a.showOn,(function(){a.displayAs!==de||e._dialogOpen||e._skipFocus||queueMicrotask((()=>{e.isConnected&&e._wrappedElement$.is(":focus")&&We.dialog.show(e)})),e._skipFocus=!1})),e._wrappedElement$.on("keydown",(function(t){a.displayAs===de&&(["ArrowDown","ArrowUp"].includes(t.key)?(We.dialog.show(e),We.elements.getFocusElement(e).trigger("focus")):["Tab","Escape"].includes(t.key)&&(We.dialog.close(e),"Escape"===t.key&&(t.preventDefault(),t.stopPropagation())))})),e._inputRegistered=!0)},createUpdateOrDeletePopupButton:function(e,a){if(e._popupButton$||(e._popupButton$=e.element.find("button.a-Button--calendar")),a.displayAs===de){if(0===e._popupButton$.length&&(e._popupButton$=je.defaultElements.button(e,a,null,"a-Button--calendar ui-datepicker-trigger"),e.element.append(e._popupButton$)),e._popupButtonRegistered||(e._popupButton$.on(x,(function(t){a.displayAs===de&&(We.dialog.show(e),We.elements.getFocusElement(e).trigger("focus")),t.preventDefault()})),e._popupButtonRegistered=!0),0===e._popupButton$.find("span").length){const a=t("<span>");a.addClass("a-Icon"),e.showTime?a.addClass("icon-calendar-time"):a.addClass("icon-calendar"),e._popupButton$.append(a)}e._elementLabelIDSafe&&e._popupButton$.attr(ee,e._elementLabelIDSafe),a.disabled?e._popupButton$.addClass(u):e._dialogOpen||e._popupButton$.removeClass(u),e._popupButton$.attr("aria-controls",e._inputIDSafe),e._popupButton$.attr(P,"dialog"),a.showOn===ue?e._popupButton$.attr(R,"-1"):e._popupButton$.removeAttr(R),a.showTime?(e._popupButton$.attr(X,ve(ye)),e._popupButton$.attr(H,ve(ye)),e._popupButton$.find("span").addClass(h),e._popupButton$.find("span").removeClass(y)):(e._popupButton$.attr(X,ve(Ce)),e._popupButton$.attr(H,ve(Ce)),e._popupButton$.find("span").removeClass(h),e._popupButton$.find("span").addClass(y))}else e._popupButton$&&e._popupButton$.remove(),e._popupButton$=null,e._popupButtonRegistered=null},render:function(e,t){if(e._calendar&&e._calendar.empty(),t.displayAs!==ce){t.displayAs===de&&(e.element.addClass(p+"--"+de),e.element.removeClass(p+"--"+oe),e.element.removeClass(p+"--"+ce)),t.displayAs===oe&&(e.element.addClass(p+"--"+oe),e.element.removeClass(p+"--"+de),e.element.removeClass(p+"--"+ce)),e._calendar||(e._calendar=je.calendar(e,t));const a=je.container(e,t);e._calendar.append(a),t.displayAs===oe&&(e.element.append(e._calendar),t.disabled?e.element.addClass(u):e.element.removeClass(u)),We.addKeyBoardNavigation(e,t)}}},je={defaultElements:{button:function(e,a,n,r,l,s,o){const i=t("<button>");if(i.addClass("a-Button"),i.attr(Q,"button"),l){i.attr(X,n);const e=t("<span>");e.addClass(f),e.addClass(l),e.attr(q,"true"),i.append(e),i.attr(H,n)}else i.text(n);return i.addClass(r),s&&i.attr(R,s),o&&i.attr(K,o),a.displayAs!==de&&e._elementLabelIDSafe&&i.attr(ee,e._elementLabelIDSafe),i},label:function(e,a){const n=t("<label>");return n.addClass(_),n.attr("for",a),n.text(e),n}},calendar:function(e,a){const n=t("<div>");n.addClass(m),n.attr(W,re);const r=a.showTime?ve(ye):ve(Ce);return e._elementLabelSafe?n.attr(H,e._elementLabelSafe+" - "+r):n.attr(H,r),a.displayAs===oe?n.addClass(m+"-"+oe):n.removeClass(m+"-"+oe),n},container:function(e,a){const n=e._calendar,l=je.header();n.append(l);const s=je.monthYearSelection.container();l.append(s),s.append(je.monthYearSelection.monthSelection(e,a)),s.append(je.monthYearSelection.yearSelection(e,a)),l.append(je.buttons.prevMonth(e,a)),l.append(je.buttons.nextMonth(e,a));const o=t("<div>");o.attr(k,e._calendarTableIDSafe),o.addClass(m+"-calendars"),o.attr(W,re),o.attr(H,ve(be)),n.append(o);for(let n=0;n<a.numberOfMonths;n++){let l=r.clone(e._currentCalendarDate);if(a.numberOfMonths>1){const t=a.numberOfMonths-Math.trunc(a.numberOfMonths/2)-1;l=r.add(l,-t+n,r.UNIT.MONTH),e._calendar.addClass(m+"--multiple")}else e._calendar.removeClass(m+"--multiple");const s=e._elementIDSafe+"_"+r.format(l,"month_YYYY")+"_header",i=t("<div>");i.addClass(m+"-calendarContainer"),i.attr(W,re),i.attr(F,s),o.append(i);const d=t("<div>");d.addClass(m+"-calendarTitle"),d.text(r.format(l,"Month YYYY")),d.attr(k,s),d.attr("aria-live","polite"),i.append(d);const c=je.table.container(l,s);i.append(c),c.append(je.table.head(a)),c.append(je.table.body(e,a,l))}if(a.showTime||a.todayButton||!a.required&&a.displayAs===oe){const t=je.footer.container();if(a.showTime){const n=je.footer.timePicker(e,a);t.append(n)}const r=je.footer.actions(e,a);""!==r.html()&&t.append(r),""!==t.html()&&n.append(t)}return n},header:function(){const e=t("<div>");return e.addClass(m+"-header"),e.attr(H,ve(Ue)),e.attr(W,"navigation"),e},table:{container:function(e,a){const n=t("<table>");return n.addClass(m+"-calendar"),n.attr(F,a),n.attr(W,"grid"),n},head:function(e){const a=t("<thead>");a.attr(W,"rowgroup");const n=t("<tr>");if(n.attr(W,"row"),a.append(n),e.displayWeeks===me){const e=t("<th>");n.append(e),e.attr(W,"columnheader"),e.addClass(m+"-weekColumn");const a=t("<span>");a.attr(q,"true"),a.text(ve(we)),e.append(a);const r=t("<span>");r.addClass(_),r.text(ve(Te)),e.append(r)}for(let e=0;e<=6;e++){const a=t("<th>");n.append(a),a.attr(W,"columnheader");const r=t("<span>");r.attr(q,"true"),r.text(s.getAbbrevDayNames()[e]),a.append(r);const l=t("<span>");l.addClass(_),l.text(s.getDayNames()[e]),a.append(l)}return a},body:function(e,a,n){const s=r.firstOfMonth(n),o=r.localeDayOfWeek(s),i=r.daysInMonth(s),u=We.getNumberOfDays(o,i),p=e._pendingValue,f=new Date,_=t("<tbody>");let D=!0,h=!0,y=t("<tr>");_.attr(W,"rowgroup");for(let C=0;C<u;C++){const u=r.add(r.clone(s),C-o,r.UNIT.DAY),b=parseInt(r.format(u,"DD"),10),w=r.format(u,M);let E=!0,A={disabled:!1,class:null,tooltip:null};if((C%7==0||0===C)&&(y=t("<tr>"),y.attr(W,"row"),_.append(y),a.displayWeeks===me)){const e=r.add(r.clone(u),1,r.UNIT.DAY),a=r.ISOWeek(e),n=t("<th>");y.append(n),n.attr(R,"-1"),n.attr(W,"rowheader"),n.addClass(m+"-weekColumn"),n.text(a),n.attr("abbr",ve(Te)+" "+a),n.attr(H,ve(Te)+" "+a)}const S=t("<td>");y.append(S);const I=t("<span>");if(I.text(b),I.attr(W,se),S.append(I),(a.showDaysOutsideMonth!==ge||C>=o&&C<o+i)&&e[c]){let a=0;try{if("function"==typeof e[c]){const n=e[c](w);n&&"object"==typeof n?(t.extend(A,n),A.class&&S.addClass(A.class),A.tooltip&&S.attr(X,A.tooltip)):a=1}else a=2;a>0&&D&&(1===a?l.trace("dayFormatter function must return as valid JSON object in format { disabled: false, class: null, tooltip: null }."):l.error("dFormatter must be a function (apex.items.P1_DATE_PICKER.dayFormatter = function () {...};) that returns as valid JSON object."),D=!1)}catch(e){h&&l.error("dayFormatter function returned with an error",e),h=!1}}p&&n&&r.isSame(We.calcCurrentCalendarDate(e,a,p),p,r.UNIT.DAY)&&r.isSame(p,u,r.UNIT.DAY)&&r.isSame(n,u,r.UNIT.MONTH)&&!a.disabled&&!A.disabled&&(e.getValue()||e._pendingValue)?(S.attr(ne,"true"),S.attr(R,"0"),S.addClass(g)):S.attr(R,"-1"),r.isSame(f,u,r.UNIT.DAY)&&(a.showDaysOutsideMonth===ie||r.isSame(n,u,r.UNIT.MONTH))&&(S.attr("aria-current","date"),S.addClass("is-current")),We.checkMinMax(a,u,r.UNIT.DAY)?(C<o||C>=o+i)&&a.showDaysOutsideMonth!==ie?(a.showDaysOutsideMonth===De?(E=!1,S.addClass(v),I.removeAttr(W,se)):a.showDaysOutsideMonth===ge&&(E=!1,S.addClass(v),S.text("")),S.attr(ae,"true")):(S.attr("data-date",w),S.attr(W,"gridcell"),S.on("keydown",(function(t){"Tab"===t.key&&t.shiftKey&&(t.preventDefault(),d(e._calendar).find("."+m+"-nav--next").trigger("focus"))})),a.disabled||A.disabled||!E||S.on(x,(function(){const t=_.closest("."+m+"-calendars").find("td");t.attr(ne,"false"),t.removeClass(g),t.attr(R,"-1"),S.attr(ne,"true"),S.attr(R,"0"),S.addClass(g),a.displayAs===oe&&(e._skipRender=!0),a.showTime||a.displayAs!==de||We.dialog.close(e),We.setDateToValue(e,a,u,T)}))):(E=!1,S.addClass(v),S.attr(ae,"true"),I.removeAttr(W,se)),A.disabled&&(S.addClass(v),S.attr(ae,"true"),I.removeAttr(W,se))}return _}},footer:{container:function(){const e=t("<div>");return e.addClass(m+"-footer"),e},timePicker:function(e,a){const n=t("<div>");n.attr(H,ve(Ee)),n.addClass(m+"-timePicker"),n.attr(W,re);const l=t("<span>");l.addClass(f+" icon-time"),l.attr(q,"true"),n.append(l),!a.disabled&&e._initialValueDate&&l.on(x,(function(t){t.stopPropagation(),e._currentCalendarDate=We.calcCurrentCalendarDate(e,a,e._initialValueDate),We.setDateToValue(e,a,r.clone(e._currentCalendarDate),b),We.moveCalendarView(e,a,null,r.clone(e._currentCalendarDate))}));const o=e._elementIDSafe+"_hours",i=t("<div>");i.addClass(m+"-timeHours"),n.append(i),i.append(je.defaultElements.label(ve(Me),o));const c=t("<select>");c.attr(k,o),e._elementLabelIDSafe&&c.attr(ee,e._elementLabelIDSafe),c.attr(K,e._calendarTableIDSafe),c.prop(L,a.disabled),i.append(c),a.disabled||c.on("keydown",(function(t){"Tab"===t.key&&t.shiftKey&&(t.preventDefault(),We.elements.getFocusElement(e).trigger("focus"))}));const u=e._pendingValue||e._currentCalendarDate,p=u.getHours();if(e._ampm){let e=p%12;e=e||12;for(let a=1;a<=12;a++){const n=t("<option>");n.text(a),n.attr(j,a),e===a&&n.prop("selected",!0),c.append(n)}}else for(let e=0;e<24;e++){const a=t("<option>");a.text(("0"+e).slice(-2)),a.attr(j,e),p===e&&a.prop("selected",!0),c.append(a)}const _=e._elementIDSafe+"_minutes",D=t("<div>");D.addClass(m+"-timeMinutes"),n.append(D),D.append(je.defaultElements.label(ve(Ae),_));const g=t("<select>");g.attr(k,_),e._elementLabelIDSafe&&g.attr(ee,e._elementLabelIDSafe),g.attr(K,e._calendarTableIDSafe),D.append(g);if(We.getMinuteOptions(a.timeIncrementMinute).forEach((function(e){const a=t("<option>");a.text(("0"+e).slice(-2)),a.attr(j,e),e===u.getMinutes()&&a.prop("selected",!0),g.append(a)})),g.on(N,(function(){const t=parseInt(g.val(),10),n=(new Date).setMinutes(t);We.setDateToValue(e,a,new Date(n),E),a.displayAs===oe&&queueMicrotask((function(){d("#"+_).trigger("focus")}))})),g.prop(L,a.disabled),e._ampm){const r=e._elementIDSafe+"_ampm",l=t("<div>");l.addClass(m+"-timeAmPm"),n.append(l),l.append(je.defaultElements.label(ve(Se),r));const i=t("<select>");i.attr(k,r),e._elementLabelIDSafe&&i.attr(ee,e._elementLabelIDSafe),i.attr(K,e._calendarTableIDSafe),i.prop(L,a.disabled),l.append(i);const u=t("<option>");u.text(s.getSettings().calendar.amFormat),u.attr(j,"AM"),i.append(u);const f=t("<option>");f.text(s.getSettings().calendar.pmFormat),f.attr(j,"PM"),i.append(f),p>=12?f.prop("selected",!0):u.prop("selected",!0),i.on(N,(function(){We.setCalendarHours(e,a,c,i),a.displayAs===oe&&queueMicrotask((function(){d("#"+r).trigger("focus")}))})),c.on(N,(function(){We.setCalendarHours(e,a,c,i),a.displayAs===oe&&queueMicrotask((function(){d("#"+o).trigger("focus")}))}))}else c.on(N,(function(){We.setCalendarHours(e,a,c),a.displayAs===oe&&queueMicrotask((function(){d("#"+o).trigger("focus")}))}));return n},actions:function(e,a){const n=t("<div>");n.addClass(C),n.attr(W,re),n.attr(H,ve(Ie));let l=r.UNIT.DAY;return a.showTime&&(l=r.UNIT.MINUTE),We.checkMinMax(a,new Date,l)&&a.todayButton&&n.append(je.buttons.today(e,a)),a.required||a.displayAs!==oe||n.append(je.buttons.clear(e,a)),a.showTime&&a.displayAs===de&&n.append(je.buttons.close(e,a)),n}},monthYearSelection:{container:function(){const e=t("<div>");return e.attr("aria-live","polite"),e.addClass(m+"-monthPicker"),e},monthSelection:function(e,a){const n=e._elementIDSafe+"_month",l=t("<div>");l.addClass(m+"-month"),l.append(je.defaultElements.label(ve(Ne),n));const o=t("<select>");o.attr(k,n),e._elementLabelIDSafe&&o.attr(ee,e._elementLabelIDSafe),o.attr(K,e._calendarTableIDSafe),l.append(o),!a.disabled&&a.changeMonth||(o.prop(L,!0),o.addClass(v));const i=r.clone(e._currentCalendarDate);return s.getMonthNames().forEach((function(n,l){if(We.setMonth(i,l),We.checkMinMax(a,i,r.UNIT.MONTH)){const a=t("<option>");a.text(n),a.attr(j,l),e._currentCalendarDate&&l===e._currentCalendarDate.getMonth()&&a.prop("selected",!0),o.append(a)}})),a.disabled||(o.on(N,(function(){const t=parseInt(o.val(),10);e._currentCalendarDate=We.calcCurrentCalendarDate(e,a,new Date(We.setMonth(e._currentCalendarDate,t))),We.moveCalendarView(e,a,"#"+n)})),a.changeYear||o.on("keydown",(function(t){"Tab"!==t.key||t.shiftKey||(d(e._calendar).find("."+m+"-nav--prev").trigger("focus"),t.preventDefault())}))),l},yearSelection:function(e,a){const n=e._elementIDSafe+"_year",l=t("<div>");l.addClass(m+"-year"),l.append(je.defaultElements.label(ve(xe),n));const s=t("<select>");s.attr(k,n),e._elementLabelIDSafe&&s.attr(ee,e._elementLabelIDSafe),s.attr(K,e._calendarTableIDSafe),l.append(s),!a.disabled&&a.changeYear||(s.prop(L,!0),s.addClass(v));let o=e._currentCalendarDate.getFullYear(),i=r.clone(e._currentCalendarDate),c=3*a.yearSelectionRange,u=a.yearSelectionRange;a.minDate&&r.isBefore(a.minDate,i,r.UNIT.YEAR)&&(c=We.getYearDifference(a.minDate,i)),a.maxDate&&r.isAfter(a.maxDate,i,r.UNIT.YEAR)&&(u=We.getYearDifference(a.maxDate,i));for(let e=-c;e<=u;e++){const n=o+e;if(i.setFullYear(n),We.checkMinMax(a,i,r.UNIT.YEAR)){const e=t("<option>");e.text(n),o===n&&e.prop("selected",!0),s.prepend(e)}}return a.disabled||(s.on(N,(function(){const t=parseInt(s.val(),10);e._currentCalendarDate=We.calcCurrentCalendarDate(e,a,new Date(e._currentCalendarDate.setFullYear(t))),We.moveCalendarView(e,a,"#"+n)})),s.on("keydown",(function(t){"Tab"!==t.key||t.shiftKey||(t.preventDefault(),d(e._calendar).find("."+m+"-nav--prev").trigger("focus"))}))),l}},buttons:{prevMonth:function(e,t){let a="-1";t.displayAs!==oe||t.changeMonth||t.changeYear||(a=null);const n=je.defaultElements.button(e,t,ve(ke),m+"-nav "+m+"-nav--prev","icon-prev",a,e._calendarTableIDSafe);return t.disabled||(n.on("keydown",(function(a){a.key===e._backwardkey?(e._currentCalendarDate=We.calcCurrentCalendarDate(e,t,r.subtract(r.clone(e._currentCalendarDate),t.previousNextDistanceSteps,r.UNIT.MONTH)),We.moveCalendarView(e,t,"."+m+"-nav--prev")):"Tab"!==a.key||a.shiftKey?"Tab"!==a.key||!a.shiftKey||t.changeMonth||t.changeYear||t.displayAs!==de||(d(e._calendar).find("."+C).children().last().trigger("focus"),a.preventDefault()):(a.preventDefault(),d(e._calendar).find("."+m+"-nav--next").trigger("focus"))})),n.on(x,(function(a){a.preventDefault(),a.stopPropagation(),e._currentCalendarDate=We.calcCurrentCalendarDate(e,t,r.subtract(r.clone(e._currentCalendarDate),t.previousNextDistanceSteps,r.UNIT.MONTH)),We.moveCalendarView(e,t,"."+m+"-nav--prev")}))),n},nextMonth:function(e,t){const a=je.defaultElements.button(e,t,ve(Ve),m+"-nav "+m+"-nav--next","icon-next","-1",e._calendarTableIDSafe);return t.disabled||(a.on("keydown",(function(a){"Tab"!==a.key||a.shiftKey?"Tab"===a.key&&a.shiftKey?(a.preventDefault(),d(e._calendar).find("."+m+"-nav--prev").trigger("focus")):a.key===e._forwardKey&&(e._currentCalendarDate=We.calcCurrentCalendarDate(e,t,r.add(r.clone(e._currentCalendarDate),t.previousNextDistanceSteps,r.UNIT.MONTH)),We.moveCalendarView(e,t,"."+m+"-nav--next")):(a.preventDefault(),We.elements.getFocusElement(e).trigger("focus"))})),a.on(x,(function(a){a.preventDefault(),a.stopPropagation(),e._currentCalendarDate=We.calcCurrentCalendarDate(e,t,r.add(r.clone(e._currentCalendarDate),t.previousNextDistanceSteps,r.UNIT.MONTH)),We.moveCalendarView(e,t,"."+m+"-nav--next")}))),a},close:function(e,t){const a=je.defaultElements.button(e,t,ve($e),m+"--close",null,null,e._inputIDSafe);return t.disabled||(a.on(x,(function(a){a.preventDefault(),a.stopPropagation(),We.dialog.close(e),We.commitValue(e,t)})),t.changeMonth||t.changeYear||a.on("keydown",(function(a){"Tab"!==a.key||a.shiftKey||(a.preventDefault(),d(e._calendar).find("."+m+"-nav--prev").trigger("focus")),"Tab"!==a.key||!a.shiftKey||t.showTime||t.todayButton||(a.preventDefault(),We.elements.getFocusElement(e).trigger("focus"))}))),a},today:function(e,t){const a="--today",n=je.defaultElements.button(e,t,ve(Oe),m+a,null,t.disabled?"-1":null,e._inputIDSafe);return t.disabled||(n.on(x,(function(n){n.preventDefault(),n.stopPropagation(),e._currentCalendarDate=We.calcCurrentCalendarDate(e,t,new Date),e._pendingValue=e._currentCalendarDate,We.setDateToValue(e,t,r.clone(e._currentCalendarDate),b),t.showTime?We.moveCalendarView(e,t,"."+m+a,r.clone(e._currentCalendarDate)):We.dialog.close(e)})),n.on("keydown",(function(a){"Tab"!==a.key||a.shiftKey||t.changeMonth||t.changeYear||t.showTime&&t.displayAs!==oe||(a.preventDefault(),d(e._calendar).find("."+m+"-nav--prev").trigger("focus")),"Tab"===a.key&&a.shiftKey&&!t.showTime&&(a.preventDefault(),We.elements.getFocusElement(e).trigger("focus"))}))),n},clear:function(e,t){const a="--clear",n=je.defaultElements.button(e,t,ve(Ye),m+a,null,t.disabled?"-1":null,e._inputIDSafe);return t.disabled||(n.on(x,(function(n){n.preventDefault(),n.stopPropagation(),We.setDateToValue(e,t,null,b),queueMicrotask((function(){d(e._calendar).find("."+m+a).trigger("focus")}))})),n.on("keydown",(function(a){"Tab"!==a.key||a.shiftKey||t.changeMonth||t.changeYear||t.todayButton||t.showTime||(a.preventDefault(),d(e._calendar).find("."+m+"-nav--prev").trigger("focus")),"Tab"!==a.key||!a.shiftKey||t.showTime||t.todayButton||(a.preventDefault(),We.elements.getFocusElement(e).trigger("focus"))}))),n}}},ze={name:{type:i.dataTypes.string,reactive:!0},type:{type:i.dataTypes.string,reactive:!0},value:{type:i.dataTypes.string,reactive:!0},tabindex:{type:i.dataTypes.number,reactive:!0},showTime:{type:i.dataTypes.boolean,defaultValue:!1,reactive:!0},todayButton:{type:i.dataTypes.boolean,defaultValue:!0,reactive:!0},changeMonth:{type:i.dataTypes.boolean,defaultValue:!0,reactive:!0},changeYear:{type:i.dataTypes.boolean,defaultValue:!0,reactive:!0},displayWeeks:{type:i.dataTypes.enum,defaultValue:le,enumValues:[me,le],reactive:!0},format:{type:i.dataTypes.string,defaultValue:s.getDateFormat(),reactive:!0},displayAs:{type:i.dataTypes.enum,defaultValue:de,enumValues:[oe,de,ce],reactive:!0},showOn:{type:i.dataTypes.enum,defaultValue:ue,enumValues:[ue,pe,"image"]},showDaysOutsideMonth:{type:i.dataTypes.enum,enumValues:[De,ge,"selectable"],defaultValue:De,reactive:!0},numberOfMonths:{type:i.dataTypes.number,defaultValue:1,range:{min:0,max:5},reactive:!0},timeIncrementMinute:{type:i.dataTypes.number,defaultValue:1,range:{min:1,max:60},reactive:!0},yearSelectionRange:{type:i.dataTypes.number,defaultValue:5,range:{min:1},reactive:!0},disabled:{type:i.dataTypes.boolean,defaultValue:!1,reactive:!0},required:{type:i.dataTypes.boolean,defaultValue:!1},previousNextDistance:{type:i.dataTypes.enum,defaultValue:_e,enumValues:[fe,_e],reactive:!0},min:{type:i.dataTypes.string,reactive:!0},max:{type:i.dataTypes.string,reactive:!0},placeholder:{type:i.dataTypes.string,reactive:!0},autofocus:{type:i.dataTypes.boolean,reactive:!0},readonly:{type:i.dataTypes.boolean,reactive:!0,defaultValue:!1},autocomplete:{type:i.dataTypes.string,reactive:!0},size:{type:i.dataTypes.number,range:{min:1},reactive:!0},maxlength:{type:i.dataTypes.number,range:{min:1},reactive:!0},minlength:{type:i.dataTypes.number,range:{min:1},reactive:!0},ariaDescribedby:{type:i.dataTypes.string,reactive:!0},ariaLabelledby:{type:i.dataTypes.string,reactive:!0}};i._addHyphenCaseAttrNames(ze);const Qe=i._configObservedAttributes(ze);class Xe extends e.ItemComponent{item_type="DATE_PICKER";#e={};constructor(){super(),this._configPrivateState(this.#e)}_render(e){const n=this;if(n._skipRender)n._skipRender=!1;else{if(n._rendered||(n._elementID=n.getAttribute(k),n._elementIDSafe=a.escapeCSS(n._elementID),n._inputIDSafe=n._elementIDSafe+"_input",n._calendarTableIDSafe=n._elementIDSafe+"_calendar"),We.updateMinMax(n.#e),n._elementLabelIDSafe=a.escapeCSS(n.element.attr(F)),n._elementLabelIDSafe&&(n._elementLabelSafe=t("#"+n._elementLabelIDSafe).text()),n.getAttribute("previous-next-distance")===fe?n.#e.previousNextDistanceSteps=n.#e.numberOfMonths:n.#e.previousNextDistanceSteps=1,n._ampm=!1,n._ampm||(n.#e.format.toLowerCase().includes("pm")||n.#e.format.toLowerCase().includes("am"))&&(n._ampm=!0),n._rendered||(We.createOrUpdateInput(n,n.#e),n._initialValueDate=n.getNativeValue()),We.createUpdateOrDeletePopupButton(n,n.#e),n._currentCalendarDate||(n._currentCalendarDate=We.calcCurrentCalendarDate(n,n.#e,n.getNativeValue()||new Date),n._pendingValue=We.calcCurrentCalendarDate(n,n.#e,n.getNativeValue())),n._rendered||[z,F,Q,$,Z,V,U,B,ee,G,R,H].forEach((e=>{n._moveAttribute(e,n._wrappedElement$)})),e)for(const t of e)switch(t.attributeName){case j:n._wrappedElement$&&n._wrappedElement$.val(t.newValue),n._currentCalendarDate=We.calcCurrentCalendarDate(n,n.#e,n.getNativeValue()||new Date),n._pendingValue=We.calcCurrentCalendarDate(n,n.#e,n.getNativeValue());break;case z:case ee:case Q:case F:case $:case Z:case V:case U:case B:case G:case R:case H:n._moveAttribute(t.attributeName,n._wrappedElement$);break;case Y:case L:case J:n._wrappedElement$.prop(t.attributeName,n.#e[t.attributeName]);break;case"min":case"max":n._currentCalendarDate=We.calcCurrentCalendarDate(n,n.#e,n.getNativeValue()||new Date),n._pendingValue=We.calcCurrentCalendarDate(n,n.#e,n.getNativeValue());break;case"display-as":We.createOrUpdateInput(n,n.#e),n._calendar&&(n._calendar.remove(),n._calendar=void 0),We.dialog.destroy(n)}"rtl"===n.element.css("direction")?(n._backwardkey=Ke,n._forwardKey=qe):(n._backwardkey=qe,n._forwardKey=Ke),n._rendered&&!e||We.render(n,n.#e),n._rendered=!0}}disconnectedCallback(){queueMicrotask((()=>{this.isConnected||We.dialog.destroy(this)}))}getNativeValue(){const e=this.getValue();if(!e)return null;try{return r.parse(e,this.#e.format)}catch(e){return l.info("The date must match the format "+this.#e.format,e),null}}hasDisplayValue(){if([oe,ce].includes(this.#e.displayAs))return!0;if(this._wrappedElement$.val().length)return!0;{const e=this._wrappedElement$.attr($);return!(!e||!e.length)}}getValidity(){let e,t={valid:!0,valueMissing:!1,rangeOverflow:!1,rangeUnderflow:!1};if(this.#e.required&&this.isEmpty())return t.valid=!1,t.valueMissing=!0,t;if(this.isEmpty())return t;try{e=r.parse(this.getValue(),this.#e.format)}catch(e){return l.trace(e),t.valid=!1,t}return this.#e.minDate&&r.isBefore(e,this.#e.minDate,r.UNIT.SECOND)?(t.rangeUnderflow=!0,t.valid=!1,t):this.#e.maxDate&&r.isAfter(e,this.#e.maxDate,r.UNIT.SECOND)?(t.rangeOverflow=!0,t.valid=!1,t):t}_getValidationMessage(){let e="",t=this.getValidity();if(!t.valid)if(t.valueMissing)e=ve("APEX.PAGE_ITEM_IS_REQUIRED");else if(this.#e.minDate&&this.#e.maxDate&&(t.rangeOverflow||t.rangeUnderflow))e=n.formatMessageNoEscape(He,r.format(this.#e.minDate,this.#e.format),r.format(this.#e.maxDate,this.#e.format));else if(t.rangeUnderflow)e=n.formatMessageNoEscape(Pe,r.format(this.#e.minDate,this.#e.format));else if(t.rangeOverflow)e=n.formatMessageNoEscape(Re,r.format(this.#e.maxDate,this.#e.format));else{const t=this.element.attr(O)?this.element.attr(O):r.format(new Date,this.#e.format);e=n.formatMessageNoEscape(Fe,t)}return e}displayValueFor(e){return r.isValid(e)?r.format(e,this.#e.format):e}getPopupSelector(){return this.#e.displayAs===oe?null:"."+D}setFocusTo(){return this.#e.displayAs===oe?We.elements.getFocusElement(this):this._wrappedElement$}refresh(){const e=this;e._currentCalendarDate=We.calcCurrentCalendarDate(e,e.#e,e.getNativeValue()||new Date),e._pendingValue=We.calcCurrentCalendarDate(e,e.#e,e.getNativeValue()),We.render(e,e.#e),e.#e.displayAs===de&&e._dialogOpen&&queueMicrotask((function(){We.elements.getFocusElement(e).trigger("focus")}))}setValue(e,t,a){this._wrappedElement$&&(this._wrappedElement$.val(e),this.refresh()),a||this.element.trigger(N)}static get observedAttributes(){return i._configObservedAttributes(ze,Qe)}static get componentMetaData(){return ze}}customElements.define("a-date-picker",Xe)}(apex.item,apex.jQuery,apex.util,apex.lang,apex.date,apex.debug,apex.locale,apex.message,apex.WebComponent);