/*!
 Copyright (c) 2022, 2023, Oracle and/or its affiliates.
*/
!function(e,t,r,a,n,i,o,l){"use strict";const s=function(){const e="(?:[-\\+]?\\d*\\.\\d+%?)|(?:[-\\+]?\\d+%?)",t="[\\s|\\(]+("+e+")[,|\\s]+("+e+")[,|\\s]+("+e+")\\s*\\)?",r="[\\s|\\(]+("+e+")[,|\\s]+("+e+")[,|\\s]+("+e+")[,|\\s]+("+e+")\\s*\\)?";return{CSS_UNIT:new RegExp(e),rgb:new RegExp("rgb"+t),rgba:new RegExp("rgba"+r),hsl:new RegExp("hsl"+t),hsla:new RegExp("hsla"+r),hsv:new RegExp("hsv"+t),hsva:new RegExp("hsva"+r),hex3:/^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,hex6:/^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/}}(),u={isValidCSSUnit:function(e){return!!s.CSS_UNIT.exec(e)},isOnePointZero:function(e){return"string"==typeof e&&-1!==e.indexOf(".")&&1===parseFloat(e)},parseIntFromHex:function(e){return parseInt(e,16)},isPercentage:function(e){return"string"==typeof e&&-1!==e.indexOf("%")},convertToPercentage:function(e){let t=e;return t<=1&&(t=100*t+"%"),t},boundAlpha:function(e){let t=parseFloat(e);return(isNaN(t)||t<0||t>1)&&(t=1),t},bound01:function(e,t){let r=e;u.isOnePointZero(r)&&(r="100%");const a=u.isPercentage(r);return r=Math.min(t,Math.max(0,parseFloat(r))),a&&(r=parseInt(r*t,10)/100),Math.abs(r-t)<1e-6?1:r%t/parseFloat(t)},toRgbString:function(e){const t=e._a<1;return"rgb"+(t?"a(":"(")+Math.round(e._r)+", "+Math.round(e._g)+", "+Math.round(e._b)+(t?", "+e._a:"")+")"},toHslString:function(e){const t=e.getHSLA(),r=t.a<1;return"hsl"+(r?"a(":"(")+Math.round(360*t.h)+", "+Math.round(100*t.s)+"%, "+Math.round(100*t.l)+"%"+(r?", "+t.a:"")+")"},toHsvString:function(e){const t=e.getHSVA(),r=t.a<1;return"hsv"+(r?"a(":"(")+Math.round(360*t.h)+", "+Math.round(100*t.s)+"%, "+Math.round(100*t.v)+"%"+(r?", "+t.a:"")+")"},toHexString:function(e){function t(e){const t=Math.round(e).toString(16);return 1===t.length?"0"+t:t}return"#"+t(e._r)+t(e._g)+t(e._b)},rgbaToHsla:function(e){const t=u.bound01(e.r,255),r=u.bound01(e.g,255),a=u.bound01(e.b,255),n=u.boundAlpha(e.a),i=Math.max(t,r,a),o=Math.min(t,r,a);let l,s,c=(i+o)/2;if(i===o)l=0,s=0;else{let e=i-o;switch(s=c>.5?e/(2-i-o):e/(i+o),i){case t:l=(r-a)/e+(r<a?6:0);break;case r:l=(a-t)/e+2;break;case a:l=(t-r)/e+4}l/=6}return{h:l,s:s,l:c,a:n}},rgbaToHsva:function(e){const t=u.bound01(e.r,255),r=u.bound01(e.g,255),a=u.bound01(e.b,255),n=u.boundAlpha(e.a),i=Math.max(t,r,a),o=Math.min(t,r,a),l=i,s=i-o,c=0===i?0:s/i;let d;if(i===o)d=0;else{switch(i){case t:d=(r-a)/s+(r<a?6:0);break;case r:d=(a-t)/s+2;break;case a:d=(t-r)/s+4}d/=6}return{h:d,s:c,v:l,a:n}},rgbToRgb:function(e,t,r){return{r:255*u.bound01(e,255),g:255*u.bound01(t,255),b:255*u.bound01(r,255)}},hslToRgb:function(e,t,r){let a,n,i;function o(e,t,r){return r<0&&(r+=1),r>1&&(r-=1),r<1/6?e+6*(t-e)*r:r<.5?t:r<2/3?e+(t-e)*(2/3-r)*6:e}if(e=u.bound01(e,360),t=u.bound01(t,100),r=u.bound01(r,100),0===t)a=r,n=r,i=r;else{const l=r<.5?r*(1+t):r+t-r*t,s=2*r-l;a=o(s,l,e+1/3),n=o(s,l,e),i=o(s,l,e-1/3)}return{r:255*a,g:255*n,b:255*i}},hsvToRgb:function(e,t,r){e=6*u.bound01(e,360),t=u.bound01(t,100),r=u.bound01(r,100);const a=Math.floor(e),n=e-a,i=r*(1-t),o=r*(1-n*t),l=r*(1-(1-n)*t),s=a%6;return{r:255*[r,o,i,i,l,r][s],g:255*[l,r,r,o,i,i][s],b:255*[i,i,l,r,r,o][s]}},stringInputToObject:function(e){if("transparent"===(e=e.replace(/^\s*(.*?)\s*$/,"$1").toLowerCase()))return{r:0,g:0,b:0,a:0};let t=s.rgb.exec(e);return t?{r:t[1],g:t[2],b:t[3]}:(t=s.rgba.exec(e),t?{r:t[1],g:t[2],b:t[3],a:t[4]}:(t=s.hsl.exec(e),t?{h:t[1],s:t[2],l:t[3]}:(t=s.hsla.exec(e),t?{h:t[1],s:t[2],l:t[3],a:t[4]}:(t=s.hsv.exec(e),t?{h:t[1],s:t[2],v:t[3]}:(t=s.hsva.exec(e),t?{h:t[1],s:t[2],v:t[3],a:t[4]}:(t=s.hex6.exec(e),t?{r:u.parseIntFromHex(t[1]),g:u.parseIntFromHex(t[2]),b:u.parseIntFromHex(t[3])}:(t=s.hex3.exec(e),!!t&&{r:u.parseIntFromHex(t[1]+""+t[1]),g:u.parseIntFromHex(t[2]+""+t[2]),b:u.parseIntFromHex(t[3]+""+t[3])})))))))},inputToRGB:function(e){let t={r:0,g:0,b:0},r=1,a=null,n=null,i=null,o=!1;if("string"==typeof(e=e||t)&&(e=u.stringInputToObject(e)),"object"==typeof e&&(u.isValidCSSUnit(e.r)&&u.isValidCSSUnit(e.g)&&u.isValidCSSUnit(e.b)?(t=u.rgbToRgb(e.r,e.g,e.b),o=!0):u.isValidCSSUnit(e.h)&&u.isValidCSSUnit(e.s)&&u.isValidCSSUnit(e.v)?(a=u.convertToPercentage(e.s),n=u.convertToPercentage(e.v),t=u.hsvToRgb(e.h,a,n),o=!0):u.isValidCSSUnit(e.h)&&u.isValidCSSUnit(e.s)&&u.isValidCSSUnit(e.l)&&(a=u.convertToPercentage(e.s),i=u.convertToPercentage(e.l),t=u.hslToRgb(e.h,a,i),o=!0),void 0!==e.a&&(r=e.a)),!o)throw new Error("Invalid Color format");return r=u.boundAlpha(r),{r:Math.min(255,Math.max(t.r,0)),g:Math.min(255,Math.max(t.g,0)),b:Math.min(255,Math.max(t.b,0)),a:r}}},c=function(e){let t=this;const r=e||"",a=u.inputToRGB(r);t._r=a.r,t._g=a.g,t._b=a.b,t._a=Math.round(100*a.a)/100,Object.defineProperty(t,"rgba",{writable:!1,value:{r:a.r,g:a.g,b:a.b,a:t._a}}),Object.defineProperty(t,"hsla",{writable:!1,value:u.rgbaToHsla(t.rgba)}),Object.defineProperty(t,"hsva",{writable:!1,value:u.rgbaToHsva(t.rgba)})};c.prototype.getRGBA=function(){return this.rgba},c.prototype.getHSLA=function(){return this.hsla},c.prototype.getHSVA=function(){return this.hsva},c.prototype.getRed=function(e){return e?this._r:Math.round(this._r)},c.prototype.getGreen=function(e){return e?this._g:Math.round(this._g)},c.prototype.getBlue=function(e){return e?this._b:Math.round(this._b)},c.prototype.getAlpha=function(){return this._a},c.prototype.toString=function(){return u.toRgbString(this)},c.prototype.toHslString=function(){return u.toHslString(this)},c.prototype.toHsvString=function(){return u.toHsvString(this)},c.prototype.toHexString=function(){return u.toHexString(this)},c.prototype.isEqual=function(e){let t=!1;return e instanceof c&&(t=this._r===e._r&&this._g===e._g&&this._b===e._b&&this._a===e._a),t},Object.defineProperty(c,"ALICEBLUE",{writable:!1,value:new c("f0f8ff")}),Object.defineProperty(c,"ANTIQUEWHITE",{writable:!1,value:new c("faebd7")}),Object.defineProperty(c,"AQUA",{writable:!1,value:new c("0ff")}),Object.defineProperty(c,"AQUAMARINE",{writable:!1,value:new c("7fffd4")}),Object.defineProperty(c,"AZURE",{writable:!1,value:new c("f0ffff")}),Object.defineProperty(c,"BEIGE",{writable:!1,value:new c("f5f5dc")}),Object.defineProperty(c,"BISQUE",{writable:!1,value:new c("ffe4c4")}),Object.defineProperty(c,"BLACK",{writable:!1,value:new c("000")}),Object.defineProperty(c,"BLANCHEDALMOND",{writable:!1,value:new c("ffebcd")}),Object.defineProperty(c,"BLUE",{writable:!1,value:new c("00f")}),Object.defineProperty(c,"BLUEVIOLET",{writable:!1,value:new c("8a2be2")}),Object.defineProperty(c,"BROWN",{writable:!1,value:new c("a52a2a")}),Object.defineProperty(c,"BURLYWOOD",{writable:!1,value:new c("deb887")}),Object.defineProperty(c,"CADETBLUE",{writable:!1,value:new c("5f9ea0")}),Object.defineProperty(c,"CHARTREUSE",{writable:!1,value:new c("7fff00")}),Object.defineProperty(c,"CHOCOLATE",{writable:!1,value:new c("d2691e")}),Object.defineProperty(c,"CORAL",{writable:!1,value:new c("ff7f50")}),Object.defineProperty(c,"CORNFLOWERBLUE",{writable:!1,value:new c("6495ed")}),Object.defineProperty(c,"CORNSILK",{writable:!1,value:new c("fff8dc")}),Object.defineProperty(c,"CRIMSON",{writable:!1,value:new c("dc143c")}),Object.defineProperty(c,"CYAN",{writable:!1,value:new c("0ff")}),Object.defineProperty(c,"DARKBLUE",{writable:!1,value:new c("00008b")}),Object.defineProperty(c,"DARKCYAN",{writable:!1,value:new c("008b8b")}),Object.defineProperty(c,"DARKGOLDENROD",{writable:!1,value:new c("b8860b")}),Object.defineProperty(c,"DARKGRAY",{writable:!1,value:new c("a9a9a9")}),Object.defineProperty(c,"DARKGREY",{writable:!1,value:new c("a9a9a9")}),Object.defineProperty(c,"DARKGREEN",{writable:!1,value:new c("006400")}),Object.defineProperty(c,"DARKKHAKI",{writable:!1,value:new c("bdb76b")}),Object.defineProperty(c,"DARKMAGENTA",{writable:!1,value:new c("8b008b")}),Object.defineProperty(c,"DARKOLIVEGREEN",{writable:!1,value:new c("556b2f")}),Object.defineProperty(c,"DARKORANGE",{writable:!1,value:new c("ff8c00")}),Object.defineProperty(c,"DARKORCHID",{writable:!1,value:new c("9932cc")}),Object.defineProperty(c,"DARKRED",{writable:!1,value:new c("8b0000")}),Object.defineProperty(c,"DARKSALMON",{writable:!1,value:new c("e9967a")}),Object.defineProperty(c,"DARKSEAGREEN",{writable:!1,value:new c("8fbc8f")}),Object.defineProperty(c,"DARKSLATEBLUE",{writable:!1,value:new c("483d8b")}),Object.defineProperty(c,"DARKSLATEGRAY",{writable:!1,value:new c("2f4f4f")}),Object.defineProperty(c,"DARKSLATEGREY",{writable:!1,value:new c("2f4f4f")}),Object.defineProperty(c,"DARKTURQUOISE",{writable:!1,value:new c("00ced1")}),Object.defineProperty(c,"DARKVIOLET",{writable:!1,value:new c("9400d3")}),Object.defineProperty(c,"DEEPPINK",{writable:!1,value:new c("ff1493")}),Object.defineProperty(c,"DEEPSKYBLUE",{writable:!1,value:new c("00bfff")}),Object.defineProperty(c,"DIMGRAY",{writable:!1,value:new c("696969")}),Object.defineProperty(c,"DIMGREY",{writable:!1,value:new c("696969")}),Object.defineProperty(c,"DODGERBLUE",{writable:!1,value:new c("1e90ff")}),Object.defineProperty(c,"FIREBRICK",{writable:!1,value:new c("b22222")}),Object.defineProperty(c,"FLORALWHITE",{writable:!1,value:new c("fffaf0")}),Object.defineProperty(c,"FORESTGREEN",{writable:!1,value:new c("228b22")}),Object.defineProperty(c,"FUCHSIA",{writable:!1,value:new c("f0f")}),Object.defineProperty(c,"GAINSBORO",{writable:!1,value:new c("dcdcdc")}),Object.defineProperty(c,"GHOSTWHITE",{writable:!1,value:new c("f8f8ff")}),Object.defineProperty(c,"GOLD",{writable:!1,value:new c("ffd700")}),Object.defineProperty(c,"GOLDENROD",{writable:!1,value:new c("daa520")}),Object.defineProperty(c,"GRAY",{writable:!1,value:new c("808080")}),Object.defineProperty(c,"GREY",{writable:!1,value:new c("808080")}),Object.defineProperty(c,"GREEN",{writable:!1,value:new c("008000")}),Object.defineProperty(c,"GREENYELLOW",{writable:!1,value:new c("adff2f")}),Object.defineProperty(c,"HONEYDEW",{writable:!1,value:new c("f0fff0")}),Object.defineProperty(c,"HOTPINK",{writable:!1,value:new c("ff69b4")}),Object.defineProperty(c,"INDIANRED",{writable:!1,value:new c("cd5c5c")}),Object.defineProperty(c,"INDIGO",{writable:!1,value:new c("4b0082")}),Object.defineProperty(c,"IVORY",{writable:!1,value:new c("fffff0")}),Object.defineProperty(c,"KHAKI",{writable:!1,value:new c("f0e68c")}),Object.defineProperty(c,"LAVENDER",{writable:!1,value:new c("e6e6fa")}),Object.defineProperty(c,"LAVENDERBLUSH",{writable:!1,value:new c("fff0f5")}),Object.defineProperty(c,"LAWNGREEN",{writable:!1,value:new c("7cfc00")}),Object.defineProperty(c,"LEMONCHIFFON",{writable:!1,value:new c("fffacd")}),Object.defineProperty(c,"LIGHTBLUE",{writable:!1,value:new c("add8e6")}),Object.defineProperty(c,"LIGHTCORAL",{writable:!1,value:new c("f08080")}),Object.defineProperty(c,"LIGHTCYAN",{writable:!1,value:new c("e0ffff")}),Object.defineProperty(c,"LIGHTGOLDENRODYELLOW",{writable:!1,value:new c("fafad2")}),Object.defineProperty(c,"LIGHTGRAY",{writable:!1,value:new c("d3d3d3")}),Object.defineProperty(c,"LIGHTGREY",{writable:!1,value:new c("d3d3d3")}),Object.defineProperty(c,"LIGHTGREEN",{writable:!1,value:new c("90ee90")}),Object.defineProperty(c,"LIGHTPINK",{writable:!1,value:new c("ffb6c1")}),Object.defineProperty(c,"LIGHTSALMON",{writable:!1,value:new c("ffa07a")}),Object.defineProperty(c,"LIGHTSEAGREEN",{writable:!1,value:new c("20b2aa")}),Object.defineProperty(c,"LIGHTSKYBLUE",{writable:!1,value:new c("87cefa")}),Object.defineProperty(c,"LIGHTSLATEGRAY",{writable:!1,value:new c("789")}),Object.defineProperty(c,"LIGHTSLATEGREY",{writable:!1,value:new c("789")}),Object.defineProperty(c,"LIGHTSTEELBLUE",{writable:!1,value:new c("b0c4de")}),Object.defineProperty(c,"LIGHTYELLOW",{writable:!1,value:new c("ffffe0")}),Object.defineProperty(c,"LIME",{writable:!1,value:new c("0f0")}),Object.defineProperty(c,"LIMEGREEN",{writable:!1,value:new c("32cd32")}),Object.defineProperty(c,"LINEN",{writable:!1,value:new c("faf0e6")}),Object.defineProperty(c,"MAGENTA",{writable:!1,value:new c("f0f")}),Object.defineProperty(c,"MAROON",{writable:!1,value:new c("800000")}),Object.defineProperty(c,"MEDIUMAQUAMARINE",{writable:!1,value:new c("66cdaa")}),Object.defineProperty(c,"MEDIUMBLUE",{writable:!1,value:new c("0000cd")}),Object.defineProperty(c,"MEDIUMORCHID",{writable:!1,value:new c("ba55d3")}),Object.defineProperty(c,"MEDIUMPURPLE",{writable:!1,value:new c("9370db")}),Object.defineProperty(c,"MEDIUMSEAGREEN",{writable:!1,value:new c("3cb371")}),Object.defineProperty(c,"MEDIUMSLATEBLUE",{writable:!1,value:new c("7b68ee")}),Object.defineProperty(c,"MEDIUMSPRINGGREEN",{writable:!1,value:new c("00fa9a")}),Object.defineProperty(c,"MEDIUMTURQUOISE",{writable:!1,value:new c("48d1cc")}),Object.defineProperty(c,"MEDIUMVIOLETRED",{writable:!1,value:new c("c71585")}),Object.defineProperty(c,"MIDNIGHTBLUE",{writable:!1,value:new c("191970")}),Object.defineProperty(c,"MINTCREAM",{writable:!1,value:new c("f5fffa")}),Object.defineProperty(c,"MISTYROSE",{writable:!1,value:new c("ffe4e1")}),Object.defineProperty(c,"MOCCASIN",{writable:!1,value:new c("ffe4b5")}),Object.defineProperty(c,"NAVAJOWHITE",{writable:!1,value:new c("ffdead")}),Object.defineProperty(c,"NAVY",{writable:!1,value:new c("000080")}),Object.defineProperty(c,"OLDLACE",{writable:!1,value:new c("fdf5e6")}),Object.defineProperty(c,"OLIVE",{writable:!1,value:new c("808000")}),Object.defineProperty(c,"OLIVEDRAB",{writable:!1,value:new c("6b8e23")}),Object.defineProperty(c,"ORANGE",{writable:!1,value:new c("ffa500")}),Object.defineProperty(c,"ORANGERED",{writable:!1,value:new c("ff4500")}),Object.defineProperty(c,"ORCHID",{writable:!1,value:new c("da70d6")}),Object.defineProperty(c,"PALEGOLDENROD",{writable:!1,value:new c("eee8aa")}),Object.defineProperty(c,"PALEGREEN",{writable:!1,value:new c("98fb98")}),Object.defineProperty(c,"PALETURQUOISE",{writable:!1,value:new c("afeeee")}),Object.defineProperty(c,"PALEVIOLETRED",{writable:!1,value:new c("db7093")}),Object.defineProperty(c,"PAPAYAWHIP",{writable:!1,value:new c("ffefd5")}),Object.defineProperty(c,"PEACHPUFF",{writable:!1,value:new c("ffdab9")}),Object.defineProperty(c,"PERU",{writable:!1,value:new c("cd853f")}),Object.defineProperty(c,"PINK",{writable:!1,value:new c("ffc0cb")}),Object.defineProperty(c,"PLUM",{writable:!1,value:new c("dda0dd")}),Object.defineProperty(c,"POWDERBLUE",{writable:!1,value:new c("b0e0e6")}),Object.defineProperty(c,"PURPLE",{writable:!1,value:new c("800080")}),Object.defineProperty(c,"REBECCAPURPLE",{writable:!1,value:new c("663399")}),Object.defineProperty(c,"RED",{writable:!1,value:new c("f00")}),Object.defineProperty(c,"ROSYBROWN",{writable:!1,value:new c("bc8f8f")}),Object.defineProperty(c,"ROYALBLUE",{writable:!1,value:new c("4169e1")}),Object.defineProperty(c,"SADDLEBROWN",{writable:!1,value:new c("8b4513")}),Object.defineProperty(c,"SALMON",{writable:!1,value:new c("fa8072")}),Object.defineProperty(c,"SANDYBROWN",{writable:!1,value:new c("f4a460")}),Object.defineProperty(c,"SEAGREEN",{writable:!1,value:new c("2e8b57")}),Object.defineProperty(c,"SEASHELL",{writable:!1,value:new c("fff5ee")}),Object.defineProperty(c,"SIENNA",{writable:!1,value:new c("a0522d")}),Object.defineProperty(c,"SILVER",{writable:!1,value:new c("c0c0c0")}),Object.defineProperty(c,"SKYBLUE",{writable:!1,value:new c("87ceeb")}),Object.defineProperty(c,"SLATEBLUE",{writable:!1,value:new c("6a5acd")}),Object.defineProperty(c,"SLATEGRAY",{writable:!1,value:new c("708090")}),Object.defineProperty(c,"SLATEGREY",{writable:!1,value:new c("708090")}),Object.defineProperty(c,"SNOW",{writable:!1,value:new c("fffafa")}),Object.defineProperty(c,"SPRINGGREEN",{writable:!1,value:new c("00ff7f")}),Object.defineProperty(c,"STEELBLUE",{writable:!1,value:new c("4682b4")}),Object.defineProperty(c,"TAN",{writable:!1,value:new c("d2b48c")}),Object.defineProperty(c,"TEAL",{writable:!1,value:new c("008080")}),Object.defineProperty(c,"THISTLE",{writable:!1,value:new c("d8bfd8")}),Object.defineProperty(c,"TOMATO",{writable:!1,value:new c("ff6347")}),Object.defineProperty(c,"TURQUOISE",{writable:!1,value:new c("40e0d0")}),Object.defineProperty(c,"VIOLET",{writable:!1,value:new c("ee82ee")}),Object.defineProperty(c,"WHEAT",{writable:!1,value:new c("f5deb3")}),Object.defineProperty(c,"WHITE",{writable:!1,value:new c("fff")}),Object.defineProperty(c,"WHITESMOKE",{writable:!1,value:new c("f5f5f5")}),Object.defineProperty(c,"YELLOW",{writable:!1,value:new c("ff0")}),Object.defineProperty(c,"YELLOWGREEN",{writable:!1,value:new c("9acd32")}),Object.defineProperty(c,"TRANSPARENT",{writable:!1,value:new c("rgba(0,0,0,0)")}),window.aColor=c;const d="disabled",p="value",f={template:`<div class="a-ColorSpectrum-spectrum" role="slider"\n                        aria-label="${t.escapeHTMLAttr(r.getMessage("APEX.COLOR_PICKER.SPECTRUM.COLOR_SPECTRUM"))}" tabindex="0">\n                       <div class="a-ColorSpectrum-dragHandler"></div>\n                   </div>\n                   <div class="a-ColorSpectrum-slider a-ColorSpectrum-slider--hue" role="slider"\n                        aria-valuemin="0" aria-valuemax="360" aria-orientation="vertical"\n                        aria-label="${t.escapeHTMLAttr(r.getMessage("APEX.COLOR_PICKER.SPECTRUM.HUE_SLIDER"))}" tabindex="0">\n                       <div class="a-ColorSpectrum-dragHandler"></div>\n                   </div>\n                   {if SHOW_ALPHA/}\n                   <div class="a-ColorSpectrum-slider a-ColorSpectrum-slider--alpha" role="slider"\n                        aria-valuemin="0" aria-valuemax="1" aria-orientation="horizontal"\n                        aria-label="${t.escapeHTMLAttr(r.getMessage("APEX.COLOR_PICKER.SPECTRUM.ALPHA_SLIDER"))}" tabindex="0">\n                       <div class="a-ColorSpectrum-dragHandler"></div>\n                   </div>\n                   {endif/}`,isColor:function(e){return e&&e instanceof c},render:function(e){const r=i(e);r&&r.html(t.applyTemplate(f.template,{extraSubstitutions:{SHOW_ALPHA:e._showAlpha?"Y":""}}))},initSliders:function(e){e._hueSlider$.css("background","linear-gradient(0deg, #ff0000 0%, #ffff00 17%, #00ff00 33%, #00ffff 50%, #0000ff 67%, #ff00ff 83%, #ff0000 100%)")},initHandlers:function(e){e._spectrum$.click((function(t){f.spectrumClick(e,t)})),e._spectrum$.on("keydown",(function(t){f.handleSpectrumKeys(e,t)})),e._spectrumPointer$.draggable({addClasses:!1,cursor:"pointer",drag:function(t,r){f.spectrumDrag(e,t,r)},stop:function(t,r){f.spectrumDrag(e,t,r)}}),e._hueSlider$.click((function(t){f.hueClick(e,t)})),e._hueSlider$.on("keydown",(function(t){f.handleHueKeys(e,t)})),e._huePointer$.draggable({addClasses:!1,cursor:"pointer",containment:"parent",axis:"y",drag:function(){f.hueDrag(e,this)}}),e._showAlpha&&(e._alphaSlider$.click((function(t){f.alphaClick(e,t)})),e._alphaSlider$.on("keydown",(function(t){f.handleAlphaKeys(e,t)})),e._alphaPointer$.draggable({addClasses:!1,cursor:"pointer",containment:"parent",axis:"x",drag:function(){f.alphaDrag(e,this)}}))},setElementVars:function(e){const t=i(e);e._element$=t,e._spectrum$=t.find(".a-ColorSpectrum-spectrum"),e._spectrumPointer$=t.find(".a-ColorSpectrum-spectrum > .a-ColorSpectrum-dragHandler"),e._spectrumWidth=e._spectrum$.width(),e._spectrumHeight=e._spectrum$.height(),e._pointerX=0,e._pointerY=0,e._spectrumPointerRadius=e._spectrumPointer$[0].offsetWidth/2,e._spectrumPointerRadius<=0&&(e._spectrumPointerRadius=e._spectrumPointer$.width()/2),e._hueSlider$=t.find(".a-ColorSpectrum-slider--hue"),e._huePointer$=t.find(".a-ColorSpectrum-slider--hue > .a-ColorSpectrum-dragHandler"),e._hueSliderLength=e._hueSlider$.height(),e._showAlpha&&(e._alphaSlider$=t.find(".a-ColorSpectrum-slider--alpha"),e._alphaPointer$=t.find(".a-ColorSpectrum-slider--alpha > .a-ColorSpectrum-dragHandler"),e._alphaSliderLength=e._alphaSlider$.width())},setColorVars:function(e,t){let r=t||c.BLACK;f.isColor(t)||(r=new c(t)),e._value=r,e._hsla=r.getHSLA(),e._hue=Math.round(360*e._hsla.h),e._sat=Math.round(100*e._hsla.s),e._lum=Math.round(100*e._hsla.l),e._alpha=e._hsla.a},setColorHue:function(e,t){const r={h:t||0,s:e._hsla.s||1,l:e._hsla.l||.5,a:e._hsla.a};e.value=new c(r)},setColorSatLum:function(e,t,r){const a={h:e._hue,s:t,l:r,a:e._hsla.a};e.value=new c(a)},setColorAlpha:function(e,t){const r={h:e._hue,s:e._hsla.s,l:e._hsla.l,a:t};e.value=new c(r)},getSatLumSpectrumPosition:function(e){const t=e._sat,r=e._lum;let a=Math.min(t/100*e._spectrumWidth,e._spectrumWidth),n=e._spectrumHeight-Math.min(r/100*e._spectrumHeight,e._spectrumHeight);return{x:Math.round(a),y:Math.round(n)}},getSatLumFromPosition:function(e,t,r){return{s:t/(e._spectrumWidth-1)*100,l:100-r/(e._spectrumHeight-1)*100}},spectrumDrag:function(e,t,r){if(e._disabled)return;const a=e._spectrumPointerRadius,n=e._spectrumWidth,i=e._spectrumHeight;let o,l,s,u;r.position.left<-a?(r.position.left=-a,o=0):r.position.left+a>=n&&(r.position.left=n-1-a,l=n-1),r.position.top<-a?(r.position.top=-a,l=0):r.position.top+a>=i&&(r.position.top=i-1-a,l=i-1),s=e._spectrumPointer$.offset(),u=e._spectrum$.offset(),0!==o&&(o=s.left+a-u.left),0!==l&&(l=s.top+a-u.top),"dragstop"!==t.type&&e._pointerX===o&&e._pointerY===l||("drag"===t.type?(e._pointerX=o,e._pointerY=l):(o=e._pointerX,l=e._pointerY),f.pointerMoved(e,o,l),e._spectrum$.is(":focus")||e._spectrum$.focus())},hueDrag:function(e,t){if(e._disabled)return;const r=e._spectrumPointerRadius,a=e._hueSliderLength-2*r,n=e._hueSlider$.offset().top+r,o=n+a-r,l=i(t).offset().top;let s;s=l>=o?360:l<=n?0:Math.round((o-l)/a*360),f.setColorHue(e,s),e._hueSlider$.is(":focus")||e._hueSlider$.focus()},alphaDrag:function(e,t){if(e._disabled)return;const r=e._spectrumPointerRadius,a=e._alphaSliderLength-2*r,n=e._alphaSlider$.offset().left+r,o=n+a-r,l=i(t).offset().left;let s;s=l>=o?1:l<=n?0:Math.round(100*(1-(o-l)/a))/100,f.setColorAlpha(e,s),e._alphaSlider$.is(":focus")||e._alphaSlider$.focus()},setPointerPosition:function(e,t,r){isNaN(t)||(e._pointerX=t),e._pointerY=r,f.movePointer(e,0,0)},movePointer:function(e,t,r){let a=e._pointerX+t,n=e._pointerY+r;a<0&&(a=0),n<0&&(n=0),a>=e._spectrumWidth&&(a=e._spectrumWidth-1),n>=e._spectrumHeight&&(n=e._spectrumHeight-1),e._pointerX=a,e._pointerY=n,a=a-e._spectrumPointerRadius+"px",n=n-e._spectrumPointerRadius+"px",e._spectrumPointer$[0].style.left=a,e._spectrumPointer$[0].style.top=n},setSpectrumHue:function(e,t){const r=e._hue||0,a=new c({h:r,s:1,l:.5,a:1});if(e._spectrum$.css("background-color",a.toHslString()),t){const t=f.getSatLumSpectrumPosition(e);f.setPointerPosition(e,t.x,t.y)}e._spectrum$.attr("aria-valuetext",e._value.toHslString())},setHueSlider:function(e){const t=e._spectrumPointerRadius,r=e._hueSliderLength-2*t,a=e._hsla.h;let n=Math.round(r-a*r);n<0&&(n=0),n>=r&&(n=r),n+="px",e._huePointer$[0].style.top=n,e._hueSlider$.attr("aria-valuenow",e._hue)},setAlphaSlider:function(e){const t=e._spectrumPointerRadius,r=e._alphaSliderLength-2*t,a=e._value.getRGBA(),n=e._alpha;let i=Math.round(n*r);i<0&&(i=0),i>=r&&(i=r),i+="px",e._alphaPointer$[0].style.left=i,e._alphaSlider$.attr("aria-valuenow",n),e._alphaSlider$.css("background",`linear-gradient(90deg, rgba(${a.r}, ${a.g}, ${a.b}, 0), rgb(${a.r}, ${a.g}, ${a.b})) repeat scroll 0% 0%, rgba(${a.r}, ${a.g}, ${a.b}, 0) repeat scroll 0% 0%`)},spectrumClick:function(e,t){if(e._disabled)return;const r=e._spectrum$.offset();let a,n,i,o=t.pageX-r.left,l=t.pageY-r.top;o=Math.round(o),l=Math.round(l),i=f.getSatLumFromPosition(e,o,l),a=i.s,n=i.l,f.setColorSatLum(e,a,n),e._spectrum$.is(":focus")||e._spectrum$.focus()},hueClick:function(e,t){if(e._disabled)return;const r=e._spectrumPointerRadius,a=e._hueSliderLength-2*r,n=e._hueSlider$.offset().top+r,i=n+a-r,o=t.pageY;let l;l=o>=i?360:o<=n?0:Math.round((i-o)/a*360),f.setColorHue(e,l),e._hueSlider$.is(":focus")||e._hueSlider$.focus()},alphaClick:function(e,t){if(e._disabled)return;const r=e._spectrumPointerRadius,a=e._alphaSliderLength-2*r,n=e._alphaSlider$.offset().left+r,i=n+a-r,o=t.pageX;let l;l=o>=i?1:o<=n?0:Math.round(100*(1-(i-o)/a))/100,f.setColorAlpha(e,l),e._alphaSlider$.is(":focus")||e._alphaSlider$.focus()},pointerMoved:function(e,t,r){let a=f.getSatLumFromPosition(e,t,r),n=a.s,i=a.l;f.setColorSatLum(e,n,i),e._spectrumPointer$.focus()},handleSpectrumKeys:function(e,t){if(e._disabled)return;const r=e._spectrumPointerRadius,a=1+Math.round(r/2),n=i.ui.keyCode;let o=0,l=0;switch(t.keyCode){case n.LEFT:o-=a;break;case n.UP:l-=a;break;case n.RIGHT:o+=a;break;case n.DOWN:l+=a}[n.LEFT,n.UP,n.RIGHT,n.DOWN].includes(t.keyCode)&&t.preventDefault(),f.movePointer(e,o,l),f.pointerMoved(e,e._pointerX,e._pointerY)},handleHueKeys:function(e,t){if(e._disabled)return;const r=e._spectrumPointerRadius,a=e._hueSliderLength-2*r,n=e._hueSlider$.offset().top+r,o=n+a-r,l=1+Math.round(r/2),s=i.ui.keyCode;let u,c=e._huePointer$.offset().top;switch(t.keyCode){case s.LEFT:case s.UP:c-=l;break;case s.RIGHT:case s.DOWN:c+=l}[s.LEFT,s.UP,s.RIGHT,s.DOWN].includes(t.keyCode)&&t.preventDefault(),u=c>=o?360:c<=n?0:Math.round((o-c)/a*360),f.setColorHue(e,u)},handleAlphaKeys:function(e,t){if(e._disabled)return;const r=e._spectrumPointerRadius,a=e._alphaSliderLength-2*r,n=e._alphaSlider$.offset().left+r,o=n+a-r,l=1+Math.round(r/2),s=i.ui.keyCode;let u,c=e._alphaPointer$.offset().left;switch(t.keyCode){case s.LEFT:case s.UP:c-=l;break;case s.RIGHT:case s.DOWN:c+=l}[s.LEFT,s.UP,s.RIGHT,s.DOWN].includes(t.keyCode)&&t.preventDefault(),u=c>=o?1:c<=n?0:Math.round(100*(1-(o-c)/a))/100,f.setColorAlpha(e,u)},handleDisable(e,t=!1){!0===t?(e._disabled=!0,e._element$.addClass("apex_disabled"),e._spectrum$.attr("tabindex","-1"),e._hueSlider$.attr("tabindex","-1"),e._alphaSlider$.attr("tabindex","-1")):(e._disabled=!1,e._element$.removeClass("apex_disabled"),e._spectrum$.attr("tabindex","0"),e._hueSlider$.attr("tabindex","0"),e._alphaSlider$.attr("tabindex","0"))},updateUI:function(e){f.setSpectrumHue(e,!0),f.setHueSlider(e),e._showAlpha&&f.setAlphaSlider(e)}},b={showAlpha:{type:o.dataTypes.boolean,defaultValue:!0,reactive:!1}};o._addHyphenCaseAttrNames(b);const h=o._configObservedAttributes(b,[d,p]);let w;class v extends o{#e={showAlpha:void 0};constructor(){super(),this._configPrivateState(this.#e),w=this.constructor}get value(){return this._value}set value(e){const t=this;function r(e){const r=t._value||c.BLACK;let a;a=f.isColor(e)?e:new c(e),r.isEqual(a)||(f.setColorVars(t,a),f.updateUI(t),t._element$.trigger("spectrumValueChanged",{value:a}))}t.rendered?r(e):queueMicrotask((()=>{r(e)}))}get disabled(){return this._disabled}set disabled(e){f.handleDisable(this,e)}_render(){const e=this;if(!e.rendered){let t=c.BLACK;e.hasAttribute(p)&&(t=e.getAttribute(p),t=new c(t)),e._disabled=!1,e._showAlpha=e.#e.showAlpha,f.render(e),queueMicrotask((()=>{f.setElementVars(e),f.initSliders(e),f.initHandlers(e),f.setColorVars(e,t),f.updateUI(e),e.hasAttribute(d)&&f.handleDisable(e,!0)}))}}attributeChangedCallback(e,t,r){super.attributeChangedCallback(e,t,r);const a=this;a.rendered&&(e===d&&f.handleDisable(a,r===d),e===p&&t!==r&&(f.setColorVars(a,new c(r)),f.updateUI(a)))}disconnectedCallback(){super.disconnectedCallback()}adoptedCallback(){this instanceof v||Object.setPrototypeOf(this,w.prototype)}static get observedAttributes(){return h}static get componentMetaData(){return b}}customElements.define("a-color-spectrum",v);const m="click",g="change",C=i.ui.keyCode,P=navigator.appVersion.includes("Mac"),_="INLINE",O="POPUP",y="COLOR_ONLY",E="NATIVE",S="FULL",A="SIMPLE",$="HEX",R="RGB",L="RGBA",I="HSL",j="HSLA",H="CSS",M={HEX:"#3caf85",RGB:"rgb(60, 175, 133)",RGBA:"rgba(60, 175, 133, 0.5)",HSL:"hsl(158, 49%, 46%)",HSLA:"hsla(158, 49%, 46%, 0.5)",CSS:"#3caf85"},T="u-hidden",k="icon-check",x="icon-warning",D="u-success-text",N="u-warning-text",G="aria-expanded",V="000000",U="apex-item-wrapper--color-picker",B="a-ColorPicker",K=B+"-preview",F=K+"--current",W=K+"--initial",Y=K+"-value",q=B+"-contrast",X=q+"Icon",Q=q+"Result",z=q+"Rating",Z=q+"Color1",J=q+"Color2",ee="apex-item-color-picker-preview",te=ee+"--noPreview",re=B+"-detail",ae=re+"--rgb",ne=re+"--hsl",ie=re+"--hex",oe=re+"Item",le=oe+"--r",se=oe+"--g",ue=oe+"--b",ce=oe+"--h",de=oe+"--s",pe=oe+"--l",fe=oe+"--a",be=oe+"--hex",he=re+"Label",we=re+"Input",ve=B+"-detailsToggle",me=B+"-preset",ge=me+"MenuButton",Ce=me+"Menu",Pe="background-color",_e="\\s*(-?\\d+|-?\\d*\\.\\d+)",Oe=new RegExp(`hsla?\\(${_e}\\s*,${_e}%\\s*,${_e}%\\s*(?:,${_e}\\s*)?\\)`),ye=/^(#)?([a-f0-9]{3}|[a-f0-9]{6})$/i,Ee=/^([01]?[0-9]{1,2}|2[0-4][0-9]|25[0-5])$/i,Se=/^([0-9]*\.)?[0-9]{1,2}$/i,Ae=/^([012]?[0-9]{1,2}|3[0-5][0-9])$/i,$e=/^([0]?[0-9]{1,2}|100)$/i;function Re(e){return r.getMessage("APEX.COLOR_PICKER."+e)}function Le(e){const t=window.getComputedStyle(document.documentElement);return t?t.getPropertyValue(e.trim()):""}function Ie(e,t){e.css(Pe,t.toString())}function je(e){return`<div ${e?'id="'+e+'"':""} class="${q}"><span class="a-ColorPicker-contrastText">${t.escapeHTML(Re("CONTRAST"))}</span><div class="a-ColorPicker-contrastColorCheck"><span class="${Z}"></span><span class="${J}"></span></div><span class="${Q}"></span><span class="${z}"></span><span aria-hidden="true" class="${X} a-Icon"></span></div>`}function He(e,t){let r,a,n="",i=!1;e.children().toggle(!!t),t?(t.aaa_small?(r=`${k} ${D}`,n="AAA"):t.aa_small?(r=`${k} ${D}`,n="AA"):(r=`${x} ${N}`,i=!0),a=Math.round(100*(t.ratio+Number.EPSILON))/100,e.toggleClass("is-warning",i).find("."+X).removeClass(`${k} ${x} ${D} ${N}`).addClass(r),e.find("."+Q).text(a),e.find("."+z).text(n),Ie(e.find("."+Z),t.color_1),Ie(e.find("."+J),t.color_2)):e.removeClass("is-warning")}function Me(e,r,a,n){let i=[],o=null,l=[],s=";";if(e.markup(`<div id="${r}presets" class="a-ColorPicker-presets">`),"THEME"===a){i=["#000000","#ffffff"];for(let e=0;e<15;e++){let t=Le("--a-color-picker-preset-"+(e+1));t&&i.push(t)}}else s=a.includes(":")?":":(a.includes(";"),";"),i=a.split(s);let u=i.slice(0,n),c=i.slice(n);for(let r=0;r<u.length;r++){let a=t.escapeHTML(u[r].trim()),n=De.getValidColor(a);if(n){let t=Pe+":"+n.toString()+";";e.markup(`<button type="button" class="a-Button ${me}" aria-label="${a}"`).optionalAttr("style",t).attr("data-color-value",a).markup("></button>")}}if(c.length){o=r+"presetMenu",e.markup(`<button type="button" data-menu="${o}"class="a-Button ${me} ${ge}" aria-label="${t.escapeHTMLAttr(Re("MORE_PRESET_COLORS"))}"><span aria-hidden="true" class="a-Icon icon-down-chevron"></span></button>\n<div id="${o}" class="${Ce}"></div>`);for(let e=0;e<c.length;e++){let t=c[e];l.push({type:"action",iconType:"a-Icon",icon:"icon-color-preview",iconStyle:"color:"+De.getValidColor(t)+";",value:t,label:t})}}return e.markup("</div>"),l}function Te(e,t,r,a){let n=e.find("#"+t+"presets"),o=n.find("."+me).not("."+ge),l=n.find("."+ge),s=e.find("#"+t+"presetMenu");o.on(m,(function(){let e=i(this).attr("data-color-value");a(e)})),l&&(r.forEach((e=>{e.action=function(){a(e.value)}})),s.menu({items:r}))}l.colorPicker={renderColorContrastReport:je,updateColorContrastReport:He};const ke={render:function(){return this.colorSpectrumContent$=i(this._render()),this.colorSpectrumContent$.find("a-color-spectrum")[0]},initialize:function(){let e,t,r,a;const n=()=>{let e=t.find("."+re),r=e.not("."+T),a=r.next("."+re),n=t.find("."+ve),i="";if(!r.length){let t=this.returnAs.substr(0,3).toLowerCase();["hex","rgb","hsl"].includes(t)||(t="hex"),a=e.filter("."+re+"--"+t)}r.addClass(T),a.length?(a.removeClass(T),i=a.attr("data-format")):(e.eq(0).removeClass(T),i=e.eq(0).attr("data-format")),n.attr("aria-valuetext",i)},o=e=>{let t=De.getValidColor(e);null!==t&&(this.colorSpectrum$[0].value=t)},l=e=>{let t,r=i(e.target);if(r[0]===this.colorSpectrum$[0])t=r[0].value,this._setColorDetailRGB(t),this._setColorDetailHSL(t),this._setColorDetailHex(t);else if(r.hasClass(we)){let e=r.closest("."+re);if(e.hasClass(ie)){if(t=this._getHexDetailColor(),null===t)return void this._setColorDetailHex(this.aColorCurrent)}else if(e.hasClass(ne)){if(t=this._getHSLDetailColor(),null===t)return void this._setColorDetailHSL(this.aColorCurrent)}else if(t=this._getRGBDetailColor(),null===t)return void this._setColorDetailRGB(this.aColorCurrent);this.colorSpectrum$[0].value=t}Ie(this.colorPreviewCurrent$,t),this.aColorCurrent=t,this.valueChanged(t),this.contrastCheck&&this.updateColorContrast()};e=this.element$,t=this.colorSpectrumContent$,e.empty().append(t),this.colorSpectrum$=t.find("a-color-spectrum"),this.colorPreviewCurrent$=t.find("."+F+" ."+Y),this.colorPreviewInitial$=t.find("."+W+" ."+Y),this.colorSpectrumContrast$=t.find("."+q),r=t.find("."+we),a=t.find("."+ve),this.colorSpectrum$.on("spectrumValueChanged",l),r.on(g,l),a.on(m,n),n(),this.presetColors&&Te(e,this.idPrefix,this.colorPresetsMenuItems,o),t.closest(".ui-dialog,.a-ColorPicker-inlineWrap").on("keydown",(e=>{let t=e.which;(90===t&&(!P&&e.ctrlKey||P&&e.metaKey)||t===C.BACKSPACE)&&"INPUT"!==e.target.nodeName&&(e.preventDefault(),this.revert())})),t.find(".a-ColorPicker-preview--initial .a-ColorPicker-preview-value").on(m,(()=>{this.revert()}))},setColor:function(e,t=!1){let r=De.getValidColor(e);r||(r=De.makeColor(V)),this.aColorCurrent=r,t&&(this.aColorInitial=r),this.showAlpha||this.aColorInitial&&1!==this.aColorInitial.getAlpha()&&(this.aColorInitial._a=1),this.ignoreChangeEvent=t,this.colorSpectrum$[0].value=r,this.ignoreChangeEvent=!1,Ie(this.colorPreviewCurrent$,r),t&&Ie(this.colorPreviewInitial$,r),this._setColorDetailRGB(r),this._setColorDetailHSL(r),this._setColorDetailHex(r),this.updateColorContrast()},revert:function(){this.colorSpectrum$[0].value=this.aColorInitial},getColor:function(){return this.aColorCurrent},getCurrentFormat:function(){return this.colorSpectrumContent$.find("."+re).not("."+T).attr("data-format")},updateColorContrast:function(){let e=this.getContrast();He(this.colorSpectrumContrast$,e)},_setColorDetailRGB:function(e){let t=this.colorSpectrumContent$.find("."+ae+" input");t.eq(0).val(e.getRed()),t.eq(1).val(e.getGreen()),t.eq(2).val(e.getBlue()),this.showAlpha&&t.eq(3).val(e.getAlpha())},_setColorDetailHSL:function(e){let t=this.colorSpectrumContent$.find("."+ne+" input"),r=De.colorToHSL(e);t.eq(0).val(r.h),t.eq(1).val(r.s),t.eq(2).val(r.l),this.showAlpha&&t.eq(3).val(r.a)},_setColorDetailHex:function(e){let t=this.colorSpectrumContent$.find("."+ie+" input"),r=e.toHexString();t.val(r.replace("#",""))},_getHexDetailColor:function(){let e=this.colorSpectrumContent$.find("."+ie+" input").val();return ye.test(e)?De.makeColor(e):null},_getHSLDetailColor:function(){let e,t=this.colorSpectrumContent$.find("."+ne+" input"),r=t.eq(0).val(),a=t.eq(1).val(),n=t.eq(2).val(),i=this.showAlpha?t.eq(3).val():"1";return Ae.test(r)&&$e.test(a)&&$e.test(n)?(e=parseFloat(i),this.showAlpha&&(!Se.test(i)||e<0||e>1)?null:De.makeColor({h:r,s:a,l:n,a:i})):null},_getRGBDetailColor:function(){let e,t=this.colorSpectrumContent$.find("."+ae+" input"),r=t.eq(0).val(),a=t.eq(1).val(),n=t.eq(2).val(),i=this.showAlpha?t.eq(3).val():"1";return Ee.test(r)&&Ee.test(a)&&Ee.test(n)?(e=parseFloat(i),this.showAlpha&&(!Se.test(i)||e<0||e>1)?null:De.makeColor({r:r,g:a,b:n,a:i})):null},_render:function(){let e,r,a=this.idPrefix,n=B+"--simple",i=t.htmlBuilder(),o=this.aColorCurrent||De.makeColor(V);const l=(e,t,r=!0)=>{i.markup(`<div class="${K} ${t}"><div class="${Y}"`).attr("title",e).optionalAttr("role",r?"button":null).optionalAttr("aria-label",r?e:null).markup("></div></div>")},s=(e,t,r,n,o,l,s,u=1)=>{let c=a+"colorPickerDetail_"+e;i.markup(`<div class="${oe} ${o}"><label for="${c}" class="${he}">${t}</label><input id="${c}" type="${n?"number":"text"}"`).optionalAttr("min",n?l:null).optionalAttr("max",n?s:null).optionalAttr("step",n?u:null).markup(`maxlength="${r}" size="5" class="apex-item-text ${we}"></div>`)},u=(e,t,r,a,n,i=1)=>{s(e,t,4,!0,r,a,n,i)};return this.displayMode===S&&(n=B+"--full"),i.markup(`<div class="${B} ${n}"><div class="${B}-spectrum"><a-color-spectrum id="${a}colorSpectrum" show-alpha="${this.showAlpha}"      value="${o.toString()}"></a-color-spectrum></div><div class="${B}-previews">`),l(Re("CURRENT"),F,!1),l(Re("INITIAL"),W),e=re+" "+T,i.markup(`</div><div class="${B}-details"><div class="${e} ${ae}" data-format="${this.showAlpha?L:R}">`),u("RGB_R","R",le,"0","255"),u("RGB_G","G",se,"0","255"),u("RGB_B","B",ue,"0","255"),this.showAlpha&&u("RGB_A","A",fe,"0","1","0.01"),i.markup(`</div><div class="${e} ${ne}" data-format="${this.showAlpha?j:I}">`),u("HSL_H","H",ce,"0","360"),u("HSL_S","S",de,"0","100"),u("HSL_L","L",pe,"0","100"),this.showAlpha&&u("HSL_A","A",fe,"0","1","0.01"),i.markup(`</div><div class="${e} ${ie}" data-format="${$}">`),s("HEX","Hex",7,!1,be),r=t.escapeHTMLAttr(Re("TOGGLE_TITLE")),i.markup(`</div><button type="button" title="${r}" aria-label="${r}"class="a-Button ${ve}"><span aria-hidden="true" class="a-Icon icon-colorpicker-select"></span></button></div>`),this.contrastCheck&&i.markup(je()),this.presetColors&&(this.colorPresetsMenuItems=Me(i,this.idPrefix,this.presetColors,this.maxPresetColors)),i.markup("</div>"),i.toString()}};function xe(e){const t=Object.create(ke);return i.extend(t,e),t.aColorInitial=null,t.aColorCurrent=null,t}const De={makeColor:function(e){return new c(e)},getValidColor:function(e){let t;if(!e)return;const r=e.toUpperCase(),a=Le(e);if(c[r])t=c[r];else{a.length&&(e=a);try{t=new c(e)}catch(e){t=null}}return t},getSingleColorLuminance:function(e){let t=e/255;return t<=.03928?t/12.92:Math.pow((t+.055)/1.055,2.4)},getRelativeLuminance:function(e){const t=e.getRed(),r=e.getGreen(),a=e.getBlue();return.2126*this.getSingleColorLuminance(t)+.7152*this.getSingleColorLuminance(r)+.0722*this.getSingleColorLuminance(a)},getColorContrast:function(e,t){if(!e||!t)return null;const r=this.getValidColor(e),a=this.getValidColor(t);if(!r||!a)return null;const n=this.getRelativeLuminance(r),i=this.getRelativeLuminance(a);let o=n>i?(n+.05)/(i+.05):(i+.05)/(n+.05);return{color_1:r.toString(),color_2:a.toString(),ratio:o,aa_large:o>3,aa_small:o>4.5,aaa_large:o>4.5,aaa_small:o>7}},getReturnColorString:function(e,t){let r;if(!(t&&t instanceof c))return"";switch([$,R,I].includes(e)&&(t._a=1),e){case $:r=t.toHexString();break;case R:case L:r=t.toString();break;case I:case j:r=t.toHslString();break;case H:r=t.toString()}return r},colorToHSL:function(e){const t=e.toHslString(),r=Oe.exec(t)||[];return{h:r[1],s:r[2],l:r[3],a:r[4]||"1"}}},Ne={getOptions:function(e){let t=i.extend({},e);return t.contrastCheck=!!t.contrastColor,t.showAlpha=[L,j].includes(t.returnValueAs),[$,L,j,R,I,H].includes(t.returnValueAs)||(n.warn("Color Picker invalid return value as: ",t.returnValueAs),t.returnValueAs=$),[S,A].includes(t.displayMode)||(n.warn("Color Picker invalid display mode: ",t.displayMode),t.displayMode),t.maxPresetColors?(t.maxPresetColors=parseInt(t.maxPresetColors,10),isNaN(t.maxPresetColors)&&(t.maxPresetColors=5)):t.maxPresetColors=5,t},getItemMarkup:function(e,r){const a=t.escapeCSS(e.element.attr("id")+"_input"),i=t.escapeHTMLAttr(e._initValue);let o;switch(r.displayAs){case O:o=`<span class="${ee}"></span>\n                        <input type="text" id="${a}" class="color_picker apex-item-text apex-item-color-picker" value="${i}">\n                        <button aria-hidden="true" type="button" class="a-Button a-Button--colorPicker" aria-label="${t.escapeHTMLAttr(Re("OPEN"))} "tabindex="-1">\n                            <span class="a-Icon icon-color-picker"></span>\n                        </button>`;break;case y:o=`<input type="hidden" id="${a}" class="color_picker apex-item-color-picker" value="${i}">\n                        <button type="button" class="a-Button a-Button--colorPicker a-Button--colorPickerOnly" aria-label="${t.escapeHTMLAttr(Re("OPEN"))}">\n                            <span class="${ee}"></span>\n                        </button>`;break;case _:o=`<input type="hidden" id="${a}" class="color_picker apex-item-color-picker" value="${i}">\n                        <div class="a-ColorPicker-inlineWrap"></div>`;break;case E:o=`<input type="color" id="${a}" class="color_picker apex-item-color-picker apex-item-color-picker-native" value="${i}">`;break;default:n.error("Color Picker invalid display-as ",r.displayAs)}return o},getElements:function(e){return{input$:e.element.find("input.apex-item-color-picker"),button$:e.element.find("button.a-Button--colorPicker"),inline$:e.element.find("div.a-ColorPicker-inlineWrap")}},addItemBehavior:function(e,r,a){let n=t.escapeCSS(e.element.attr("id"))+"_",o=!1,l=!1;function s(){o=!0,e._dialogId=Ne.openPopupColorPicker(e,{idPrefix:n,presetColors:r.colorsInline?"":r.presetColors,maxPresetColors:r.maxPresetColors,popupClass:r.popupClass,returnAs:r.returnValueAs,showAlpha:r.showAlpha,displayMode:r.displayMode,contrastCheck:r.contrastCheck},(()=>{o=!1}))}function u(e){e.on(m,(function(){l||s(),l=!1})).mousedown((function(){o&&(l=!0)}))}switch(Ne.updateItemLabelMapping(e),r.displayAs){case O:if(e._wrappedElement$.keydown((function(e){let t=e.which;t===C.DOWN||t===C.UP?(s(),e.preventDefault()):t===C.ENTER&&e.preventDefault()})),e._wrappedElement$.on(g,(()=>{e._preventChangeHandler?e._preventChangeHandler=!1:Ne.setCheckFormat(e,r,e._wrappedElement$.val())})),u(a.button$),a.button$.on("focus",(function(){e._wrappedElement$.trigger("focus")})),r.colorsInline&&r.presetColors){const o=t.htmlBuilder(),l=Me(o,n,r.presetColors,r.maxPresetColors),s=i(`#${e._dialogId}`);a.button$.after(o.toString()),e._wrappedElement$.parent().addClass("a-ColorPicker--hasPresets"),Te(s,n,l,(function(t){e.setValue(t)}))}break;case y:u(a.button$);break;case _:{const t=xe({element$:a.inline$,idPrefix:n,presetColors:r.presetColors,maxPresetColors:r.maxPresetColors,returnAs:r.returnValueAs,showAlpha:r.showAlpha,displayMode:r.displayMode,contrastCheck:r.contrastCheck,ignoreChangeEvent:!1,getContrast:function(){return e.contrastWith()},valueChanged:function(t){this.ignoreChangeEvent||(e.setValue(De.getReturnColorString(r.returnValueAs,t),null,!0),e.element.trigger(g))}});t.render(),t.initialize(),queueMicrotask((()=>{t.setColor(e.getValue(),!0)}));const i=e.setValue;e.setValue=function(r,a,n){i.call(this,r,a,n),t.setColor(e.getValue())},e._csp=t;break}}},openPopupColorPicker:function(e,t,r){let n,o,l,s=e.element;const u=t.idPrefix+"ColorPickerDlg";function c(e){let r=t.returnAs;return r===H&&(r=n.getCurrentFormat()||$),De.getReturnColorString(r,e)}let d=i("#"+u);if(s.attr(G,"true"),d[0])d.popup("open");else{let p=i.extend({},t,{getContrast:function(){return e.contrastWith()},valueChanged:function(t){this.ignoreChangeEvent||(e.setValue(c(t),null,!0),e.element.trigger("transientchange"))}});const f={id:u,title:Re("TITLE"),isPopup:!0,parentElement:s.parent(),returnFocusTo:s,noOverlay:!0,draggable:!0,resizable:!1,width:"auto",height:"auto",okButton:!1,dialogClass:"ui-dialog-color-picker"+(t.popupClass?" "+t.popupClass:""),notification:!1,callback:function(){let a,i=n.getColor();t.returnAs===H&&i.isEqual(l)?e.setValue(o,null,!0):(a=c(i),a!==o&&e.setValue(a)),s.attr(G,"false"),r(a)},init:function(e){p.element$=e,n=xe(p),n.render(),n.initialize(),e.closest(".ui-dialog").on("keydown",(t=>{t.which===C.ENTER&&"BUTTON"!==t.target.nodeName&&(t.preventDefault(),e.popup("close"))}))},open:function(){queueMicrotask((()=>{o=e.getValue(),n.setColor(o,!0),l=n.getColor()}))}};d=a.showDialog((function(){return`<div id="${u}" class='a-ColorPicker-dialog'></div>`}),f),e._csp=n}return u},setCheckFormat:function(e,t,a){let n,i,o=e._wrappedElement$;if(!o||0===o.length)return;if(i=a=a?.trim()||"",e._color=n=De.getValidColor(a),e._value=n?De.getReturnColorString(t.returnValueAs,n):a,!De||t.displayAs===E)return void o.val(a);t.returnValueAs!==H&&n&&(i=De.getReturnColorString(t.returnValueAs,n));let l=e.element.find("."+ee);if(n?(l.removeClass(te).css(Pe,n.toString()),l.attr("aria-label",i)):(l.addClass(te).css(Pe,""),l.removeAttr("aria-label")),o[0].setCustomValidity(""),""===a)o.val(a);else{let e,a=t.returnValueAs===H||null!==n;o.val(i),a||(e=r.formatMessage("APEX.COLOR_PICKER.INVALID_COLOR",M[t.returnValueAs]),o[0].setCustomValidity(e))}},removePopup:function(e){e._dialogId&&i(`#${e._dialogId}`).popup("destroy").closest(".ui-dialog--popup").remove()},rerenderItem:function(e){e.rendered=!1,Ne.removePopup(e),e._initValue=e.getValue(),e.element.attr(p,e._initValue),e._render(),Ne.syncOriginalAttributes(e),e.rendered=!0},updateItemLabelMapping:function(e){const t=e.element.attr("id"),r=t+"_input";e.element.closest(`.${U}`).find(`label#${t}_LABEL`).attr("for",r)},getElementAttributes(e,t){let r=[];const a=e.attributes,n=t||[];if(!a||0===a.length)return[];for(let e=0;e<a.length;e++){const t=a.item(e);n&&n.length>0?n.includes(t.name)&&r.push({name:t.name,value:t.value}):r.push({name:t.name,value:t.value})}return r},syncOriginalAttributes:function(e){e._originalAttributes&&e._originalAttributes.length>0&&e._originalAttributes.forEach((t=>{t.value?e._wrappedElement$.attr(t.name,t.value):e._wrappedElement$.removeAttr(t.name)}))}},Ge={contrastColor:{type:o.dataTypes.string,reactive:!0},colorsInline:{type:o.dataTypes.boolean,defaultValue:!1,reactive:!0},displayAs:{type:o.dataTypes.enum,defaultValue:O,enumValues:[y,_,E,O],reactive:!0},displayMode:{type:o.dataTypes.enum,defaultValue:A,enumValues:[A,S],reactive:!0},maxPresetColors:{type:o.dataTypes.number,defaultValue:5,reactive:!0},popupClass:{type:o.dataTypes.string,reactive:!0},presetColors:{type:o.dataTypes.string,reactive:!0},returnValueAs:{type:o.dataTypes.enum,defaultValue:$,enumValues:[H,$,I,j,R,L],reactive:!0}},Ve=["required","disabled","size","maxlength","placeholder","minlength","tabindex","name","aria-labelledby","aria-describedby"];e.ItemComponent._addCommonAttributes(Ve,Ge),o._addHyphenCaseAttrNames(Ge);const Ue=o._configObservedAttributes(Ge,Ve);class Be extends e.ItemComponent{_wrappedElement$;_value;_color;#e={contrastColor:void 0,colorsInline:void 0,displayAs:void 0,displayMode:void 0,maxPresetColors:void 0,popupClass:void 0,presetColors:void 0,returnValueAs:void 0};constructor(){super(),this._configPrivateState(this.#e)}_render(e){const t=this;if(t.rendered){if(e)for(const r of e)Ve.includes(r.attributeName)&&t._moveAttribute(r.attributeName,t._wrappedElement$),Ge[r.propertyName]&&r.attributeName===Ge[r.propertyName].attrName&&Ne.rerenderItem(t)}else{const e=Ne.getOptions(t.#e);t._initValue=t.element.attr(p)||"";const r=Ne.getItemMarkup(t,e);t.element.empty().append(r);const a=Ne.getElements(t);t._wrappedElement$=a.input$,t._originalAttributes||(t._originalAttributes=Ne.getElementAttributes(t,Ve)),Ve.forEach((e=>{t._moveAttribute(e,t._wrappedElement$)})),Ne.addItemBehavior(t,e,a),Ne.setCheckFormat(t,e,t._initValue)}}item_type="COLOR_PICKER";enable(){this.element.prop(d,!1),this.element.find("input, button, a-color-spectrum").prop(d,!1),this.element.removeClass("apex_disabled")}disable(){this.element.prop(d,!0),this.element.find("input, button, a-color-spectrum").prop(d,!0),this.element.addClass("apex_disabled")}isDisabled(){return this.element.prop(d)}show(){this.element.closest(`.${U}`).show()}hide(){this.element.closest(`.${U}`).hide()}getValue(){return this._value}setValue(e,t,r){const a=Ne.getOptions(this.#e);Ne.setCheckFormat(this,a,e),r||(this._preventChangeHandler=!0,this.element.trigger(g))}isChanged(){return this.node.value!==this._initValue}displayValueFor(e){let r,a="",n="";const i=De.getValidColor(e);return i&&(r=i.toString()),r?n=Pe+":"+t.escapeHTMLAttr(r)+";":a=" "+te,`<div class="apex-item-group apex-item-group--color-picker">\n<span class="${ee}${a}" style="${n}"></span>\n<span class="apex-item-color-picker-value">${t.escapeHTML(e)}</span></div>`}setFocusTo(){const e=Ne.getOptions(this.#e);let t=this._wrappedElement$;return e.displayAs===_?t=t.find("a-color-spectrum"):e.displayAs===y&&(t=this.element.find(".a-Button--colorPicker")),t}getPopupSelector(){return".ui-dialog-color-picker"}getNativeValue(){return this._color}contrastWith(e){const t=Ne.getOptions(this.#e);return e||t.contrastColor&&(e=t.contrastColor),De.getColorContrast(this.getValue(),e)}disconnectedCallback(){super.disconnectedCallback(),queueMicrotask((()=>{this.isConnected||Ne.removePopup(this)}))}static get observedAttributes(){return Ue}static get componentMetaData(){return Ge}}customElements.define("a-color-picker",Be)}(apex.item,apex.util,apex.lang,apex.message,apex.debug,apex.jQuery,apex.WebComponent,apex.widget.util);