/*!
 Copyright (c) 2022, Oracle and/or its affiliates. All rights reserved.
 */
apex.date={},function(e,t,r,n){"use strict";function a(t,r){let n;return r===e.UNIT.YEAR?n=new Date(t.getFullYear(),0,1,0,0,0,0):r===e.UNIT.MONTH?n=new Date(t.getFullYear(),t.getMonth(),1,0,0,0,0):r===e.UNIT.WEEK||r===e.UNIT.DAY?n=new Date(t.getFullYear(),t.getMonth(),t.getDate(),0,0,0,0):r===e.UNIT.HOUR?n=new Date(t.getFullYear(),t.getMonth(),t.getDate(),t.getHours(),0,0,0):r===e.UNIT.MINUTE?n=new Date(t.getFullYear(),t.getMonth(),t.getDate(),t.getHours(),t.getMinutes(),0,0):r===e.UNIT.SECOND?n=new Date(t.getFullYear(),t.getMonth(),t.getDate(),t.getHours(),t.getMinutes(),t.getSeconds(),0):r===e.UNIT.MILLISECOND&&(n=new Date(t.getFullYear(),t.getMonth(),t.getDate(),t.getHours(),t.getMinutes(),t.getSeconds(),t.getMilliseconds())),n}e.UNIT={MILLISECOND:"millisecond",SECOND:"second",MINUTE:"minute",HOUR:"hour",DAY:"day",WEEK:"week",MONTH:"month",YEAR:"year"},e.isValid=function(e){return e instanceof Date&&!isNaN(e)},e.isValidString=function(e){return!isNaN(Date.parse(e))},e.clone=function(e){return new Date(e.getTime())},e.add=function(t,r,n){let a=t||new Date;return n===e.UNIT.YEAR?a.setFullYear(a.getFullYear()+r):n===e.UNIT.MONTH?a=function(e,t){let r=e.getDate();return e.setMonth(e.getMonth()+t),e.getDate()!==r&&e.setDate(0),e}(a,r):n===e.UNIT.WEEK?a.setDate(a.getDate()+7*r):n===e.UNIT.DAY?a.setDate(a.getDate()+r):n===e.UNIT.HOUR?a.setHours(a.getHours()+r):n===e.UNIT.MINUTE?a.setTime(a.getTime()+6e4*r):n===e.UNIT.SECOND?a.setTime(a.getTime()+1e3*r):n===e.UNIT.MILLISECOND&&a.setTime(a.getTime()+r),a},e.subtract=function(t,r,n){let a=t||new Date;return a=e.add(a,-r,n),a},e.ISOWeek=function(t){let r,n=e.clone(t||new Date),a=(n.getDay()+6)%7;return n.setDate(n.getDate()-a+3),r=n.valueOf(),n.setMonth(0,1),4!==n.getDay()&&n.setMonth(0,1+(4-n.getDay()+7)%7),1+Math.ceil((r-n)/6048e5)},e.weekOfMonth=function(t){let r=e.clone(t||new Date);return r.setDate(r.getDate()-r.getDay()+1),Math.ceil(r.getDate()/7)},e.daysInMonth=function(e){let t=e||new Date;return new Date(t.getFullYear(),t.getMonth()+1,0).getDate()},e.dayOfWeek=function(e){let t=e||new Date;return 0===t.getDay()?7:t.getDay()},e.localeDayOfWeek=function(e){let r=e||new Date,n=t.getDayNames(),a="sunday"===t.getSettings().calendar.startOfWeek?0:-1;return r.getDay()+a===-1?n.length+a:r.getDay()+a},e.getDayOfYear=function(e){let t=e||new Date,r=new Date(t.getFullYear(),0,0),n=t-r;return Math.floor(n/864e5)},e.setDayOfYear=function(e,t){(e||new Date).setMonth(0,t)},e.secondsPastMidnight=function(t){let r=e.clone(t||new Date);return Math.round((e.clone(r)-r.setHours(0,0,0,0))/1e3,0)},e.firstOfMonth=function(e){let t=e||new Date;return new Date(t.getFullYear(),t.getMonth(),1)},e.lastOfMonth=function(e){let t=e||new Date;return new Date(t.getFullYear(),t.getMonth()+1,0)},e.startOfDay=function(e){let t=e||new Date;return new Date(t.getFullYear(),t.getMonth(),t.getDate(),0,0,0,0)},e.endOfDay=function(e){let t=e||new Date;return new Date(t.getFullYear(),t.getMonth(),t.getDate(),23,59,59,999)},e.monthsBetween=function(e,t){let r;return r=12*(t.getFullYear()-e.getFullYear()),r-=e.getMonth(),r+=t.getMonth(),Math.abs(r)},e.min=function(...e){let t=e||[new Date];return new Date(Math.min.apply(null,t))},e.max=function(...e){let t=e||[new Date];return new Date(Math.max.apply(null,t))},e.isBefore=function(t,r,n){let o=!1,s=n||e.UNIT.MILLISECOND,i=a(t,s),g=a(r,s);return o=s===e.UNIT.MILLISECOND?i.getTime()<g.getTime():i<e.add(e.subtract(g,1,s),1,e.UNIT.MILLISECOND),o},e.isAfter=function(t,r,n){let o=!1,s=n||e.UNIT.MILLISECOND,i=a(t,s),g=a(r,s);return o=s===e.UNIT.MILLISECOND?i.getTime()>g.getTime():i>e.subtract(e.add(g,1,s),1,e.UNIT.MILLISECOND),o},e.isSame=function(t,r,n){let o=!1,s=n||e.UNIT.MILLISECOND,i=a(t,s),g=a(r,s);return o=i.getTime()===g.getTime(),o},e.isSameOrBefore=function(t,r,n){let o=!1,s=n||e.UNIT.MILLISECOND,i=a(t,s),g=a(r,s);return o=s===e.UNIT.MILLISECOND?i.getTime()<=g.getTime():e.isSame(i,g)||i<e.add(e.subtract(g,1,s),1,e.UNIT.MILLISECOND),o},e.isSameOrAfter=function(t,r,n){let o=!1,s=n||e.UNIT.MILLISECOND,i=a(t,s),g=a(r,s);return o=s===e.UNIT.MILLISECOND?i.getTime()>=g.getTime():e.isSame(i,g)||i>e.subtract(e.add(g,1,s),1,e.UNIT.MILLISECOND),o},e.isBetween=function(t,r,n,o){let s=!1,i=o||e.UNIT.MILLISECOND,g=a(t,i),l=a(r,i),u=a(n,i);return s=g>l&&g<u,s},e.isLeapYear=function(e){let t=e||new Date;return 29===new Date(t.getFullYear(),1,29).getDate()},e.toISOString=function(t){let r=e.clone(t||new Date);return e.add(r,-1*r.getTimezoneOffset(),e.UNIT.MINUTE),r.toISOString().split(".")[0]},e.since=function(t,n=!1){let a=t||new Date,o=new Date,s=(o-a)/1e3,i=(a-o)/1e3,g=n,l="",u=r.formatMessage,D={secondsAgo:u(g?"APEX.SINCE.SHORT.SECONDS_AGO":"SINCE_SECONDS_AGO","#time#"),minutesAgo:u(g?"APEX.SINCE.SHORT.MINUTES_AGO":"SINCE_MINUTES_AGO","#time#"),hoursAgo:u(g?"APEX.SINCE.SHORT.HOURS_AGO":"SINCE_HOURS_AGO","#time#"),daysAgo:u(g?"APEX.SINCE.SHORT.DAYS_AGO":"SINCE_DAYS_AGO","#time#"),weeksAgo:u(g?"APEX.SINCE.SHORT.WEEKS_AGO":"SINCE_WEEKS_AGO","#time#"),monthsAgo:u(g?"APEX.SINCE.SHORT.MONTHS_AGO":"SINCE_MONTHS_AGO","#time#"),yearsAgo:u(g?"APEX.SINCE.SHORT.YEARS_AGO":"SINCE_YEARS_AGO","#time#"),secondsFromNow:u(g?"APEX.SINCE.SHORT.SECONDS_FROM_NOW":"SINCE_SECONDS_FROM_NOW","#time#"),minutesFromNow:u(g?"APEX.SINCE.SHORT.MINUTES_FROM_NOW":"SINCE_MINUTES_FROM_NOW","#time#"),hoursFromNow:u(g?"APEX.SINCE.SHORT.HOURS_FROM_NOW":"SINCE_HOURS_FROM_NOW","#time#"),daysFromNow:u(g?"APEX.SINCE.SHORT.DAYS_FROM_NOW":"SINCE_DAYS_FROM_NOW","#time#"),weeksFromNow:u(g?"APEX.SINCE.SHORT.WEEKS_FROM_NOW":"SINCE_WEEKS_FROM_NOW","#time#"),monthsFromNow:u(g?"APEX.SINCE.SHORT.MONTHS_FROM_NOW":"SINCE_MONTHS_FROM_NOW","#time#"),yearsFromNow:u(g?"APEX.SINCE.SHORT.YEARS_FROM_NOW":"SINCE_YEARS_FROM_NOW","#time#"),now:u("SINCE_NOW")};if(!e.isValid(a))throw new Error("Not a valid date");return e.isSame(o,a,e.UNIT.SECOND)?l=D.now:s>0&&s<60?l=D.secondsAgo.replace("#time#",Math.round(s)):i>0&&i<60?l=D.secondsFromNow.replace("#time#",Math.round(i)):s>=60&&s<3600?l=D.minutesAgo.replace("#time#",Math.round(s/60)):i>=60&&i<3600?l=D.minutesFromNow.replace("#time#",Math.round(i/60)):s>=3600&&s<172800?l=D.hoursAgo.replace("#time#",Math.round(s/60/60)):i>=3600&&i<172800?l=D.hoursFromNow.replace("#time#",Math.round(i/60/60)):s>=172800&&s<1209600?l=D.daysAgo.replace("#time#",Math.round(s/60/60/24)):i>=172800&&i<1209600?l=D.daysFromNow.replace("#time#",Math.round(i/60/60/24)):s>=1209600&&s<5184e3?l=D.weeksAgo.replace("#time#",Math.round(s/60/60/24/7)):i>=1209600&&i<5184e3?l=D.weeksFromNow.replace("#time#",Math.round(i/60/60/24/7)):s>=5184e3&&s<31536e3?l=D.monthsAgo.replace("#time#",Math.round(e.monthsBetween(a,o))):i>=5184e3&&i<31536e3?l=D.monthsFromNow.replace("#time#",Math.round(e.monthsBetween(o,a))):s>=31536e3?l=D.yearsAgo.replace("#time#",(e.monthsBetween(a,o)/12).toFixed(1)):i>=31536e3&&(l=D.yearsFromNow.replace("#time#",(e.monthsBetween(o,a)/12).toFixed(1))),l},e.format=function(r,a,o){let s,i,g,l,u=r||new Date,D=o||t.getLanguage()||"default",M=a||t.getDateFormat(),c=M.toUpperCase(),p=t.getSettings().calendar.amFormat,m=t.getSettings().calendar.pmFormat,N=[],h="",E=[],d="",S=[];function w(e,t){let r=(e.toUpperCase().match(/".*?"/g)||[]).join(" "),n=t.toUpperCase(),a=r.indexOf(n);return r.substr(0,a).includes('"')&&r.substr(a+1,r.length).includes('"')}function f(e=""){return e.toUpperCase().startsWith("FM")?e.replace(new RegExp("FM","ig"),""):e}function O(e=""){let t=f(e);return t===t.toUpperCase()}function I(e=""){let t=f(e);return t===t.toLowerCase()}function Y(e=""){let t=f(e);return t.charAt(0)===t.charAt(0).toUpperCase()&&t.substr(1)===t.substr(1).toLowerCase()}function F(e=""){return e.charAt(0).toUpperCase()+e.substr(1).toLowerCase()}function C(e){let r=t.getAbbrevMonthNames(),n="";if(!D.startsWith("en")&&D!==t.getLanguage())throw new Error("Only english & current application language are supported for 'MON' format");return n=D.startsWith("en")&&D!==t.getLanguage()?e.toLocaleString(D,{month:"short"}):r[e.getMonth()],n.toUpperCase()}function R(e){let r=t.getMonthNames(),n="";if(!D.startsWith("en")&&D!==t.getLanguage())throw new Error("Only english & current application language are supported for 'MONTH' format");return n=D.startsWith("en")&&D!==t.getLanguage()?e.toLocaleString(D,{month:"long"}):r[e.getMonth()],n.toUpperCase()}function H(r){let n=t.getAbbrevDayNames(),a="";if(!D.startsWith("en")&&D!==t.getLanguage())throw new Error("Only english & current application language are supported for 'DY' format");return a=D.startsWith("en")&&D!==t.getLanguage()?r.toLocaleString(D,{weekday:"short"}):n[e.localeDayOfWeek(r)],a.toUpperCase()}function T(r){let n=t.getDayNames(),a="";if(!D.startsWith("en")&&D!==t.getLanguage())throw new Error("Only english & current application language are supported for 'DAY' format");return a=D.startsWith("en")&&D!==t.getLanguage()?r.toLocaleString(D,{weekday:"long"}):n[e.localeDayOfWeek(r)],a.toUpperCase()}function A(t,r){return{YYYY:e=>("0000"+e.getFullYear()).slice(-4),FMYYYY:e=>("0000"+e.getFullYear()).slice(-4),YY:e=>("0000"+e.getFullYear()).slice(-2),RRRR:e=>("0000"+e.getFullYear()).slice(-4),FMRRRR:e=>("0000"+e.getFullYear()).slice(-4),RR:e=>("0000"+e.getFullYear()).slice(-2),MONTH:e=>R(e),FMMONTH:e=>R(e),MON:e=>C(e),FMMON:e=>C(e),MM:e=>("0"+(e.getMonth()+1)).slice(-2),FMMM:e=>(e.getMonth()+1).toString(),IW:t=>("0"+e.ISOWeek(t)).slice(-2),WW:t=>("0"+e.ISOWeek(t)).slice(-2),W:t=>e.weekOfMonth(t),DAY:e=>T(e),FMDAY:e=>T(e),DDD:t=>("0"+e.dayOfYear(t)).slice(-3),DD:e=>("0"+e.getDate()).slice(-2),FMDD:e=>e.getDate().toString(),DY:e=>H(e),FMDY:e=>H(e),D:e=>e.getDay()+1,HH24:e=>("0"+e.getHours()).slice(-2),HH12:e=>e.toLocaleString("en-US",{hour:"2-digit",hour12:!0}).substr(0,2),HH:e=>e.toLocaleString("en-US",{hour:"2-digit",hour12:!0}).substr(0,2),AM:e=>e.getHours()<12?p:m,PM:e=>e.getHours()<12?p:m,MI:e=>("0"+e.getMinutes()).slice(-2),SSSSS:t=>e.secondsPastMidnight(t),SS:e=>("0"+e.getSeconds()).slice(-2)}[r](t)}if(!e.isValid(u))throw new Error("Not a valid date");if("SINCE"===c)return e.since(u);for(/\bDS\b/g.test(c)&&(M=M.replace(/\bDS\b/gi,t.getDSDateFormat()),c=M.toUpperCase()),/\bDL\b/g.test(c)&&(M=M.replace(/\bDL\b/gi,t.getDLDateFormat()),c=M.toUpperCase()),n.trace("apex.date.format: date",e.toISOString(u)),n.trace("apex.date.format: formatMask",M),N="FMMONTH|FMYYYY|FMRRRR|MONTH|FMMON|FMDAY|SSSSS|FMDY|FMDD|FMMM|HH12|HH24|RRRR|YYYY|DAY|DDD|MON|AM|DD|DL|DS|DY|HH|IW|MI|MM|PM|RR|SS|WW|YY|D|W".split("|"),l=0;l<N.length;l++)h=N[l],c.includes(h)&&(w(M,h)||(S.push({id:l,name:h,textCase:"DS"===h||"DL"===h?"original":O(M.substr(M.toUpperCase().indexOf(h),h.length))?"upper":I(M.substr(M.toUpperCase().indexOf(h),h.length))?"lower":Y(M.substr(M.toUpperCase().indexOf(h),h.length))?"init":"upper"}),M=M.replace(new RegExp(h,"ig"),"~#"+l+"#~")),c=c.replace(new RegExp(h,"g"),""));for(E="SYEAR|SYYYY|IYYY|YEAR|IYY|SCC|TZD|TZH|TZM|TZR|AD|BC|CC|EE|FF|FX|IY|RM|TS|E|I|J|Q|X".split("|"),l=0;l<E.length;l++)if(d=E[l],c.includes(d)&&!w(c,d))throw new Error("Format not supported: "+d,{cause:d});for(g=M,l=0;l<S.length;l++){switch(i=S[l],s=A(u,i.name).toString(),i.textCase){case"upper":s=s.toUpperCase();break;case"lower":s=s.toLowerCase();break;case"init":s=F(s)}n.message(n.LOG_LEVEL.ENGINE_TRACE,"apex.date.format: getDatePart","value:",s,"format:",i.name),g=g.replace(new RegExp("~#"+i.id+"#~","g"),s)}return g.includes('"')&&(g=g.replace(new RegExp('"',"g"),"")),g},e.parse=function(r,a){let o,s,i,g,l,u,D,M=new Date(2020,0,1),c=r||"",p=a||t.getDateFormat(),m=p.toUpperCase(),N=t.getSettings().calendar.amFormat,h=t.getSettings().calendar.pmFormat,E=[],d="",S=[],w="",f=[],O=!1,I=0,Y=0,F=0,C=!1,R=["~","*","#","<",">","|","§","^","°","=","$","&","%","@","€"],H="";function T(e,r=!1){let n,a=r?t.getAbbrevMonthNames():t.getMonthNames();return n=(r?t.getSettings().calendar.rawAbbrMonthNames:t.getSettings().calendar.rawMonthNames).findIndex((t=>t.toLowerCase()===e.toLowerCase())),-1===n&&(n=a.findIndex((t=>t.toLowerCase()===e.toLowerCase()))),n}function A(e,r=!1){let n=r?t.getAbbrevMonthNames():t.getMonthNames(),a=r?t.getSettings().calendar.rawAbbrMonthNames:t.getSettings().calendar.rawMonthNames,o=!1,s="";for(let t=0;t<a.length;t++){if(s=a[t],e.toLowerCase().includes(s.toLowerCase())){o=!0;break}s=""}if(!o)for(let t=0;t<n.length&&(s=n[t],!e.toLowerCase().includes(s.toLowerCase()));t++)s="";return s}function L(e,r=!1){let n=r?t.getAbbrevDayNames():t.getDayNames(),a=r?t.getSettings().calendar.rawAbbrDayNames:t.getSettings().calendar.rawDayNames,o=!1,s="";for(let t=0;t<a.length;t++){if(s=a[t],e.toLowerCase().includes(s.toLowerCase())){o=!0;break}s=""}if(!o)for(let t=0;t<n.length&&(s=n[t],!e.toLowerCase().includes(s.toLowerCase()));t++)s="";return s}function U(e){let t="";return e.toLowerCase().includes(N.toLowerCase())&&(t=N),t||e.toLowerCase().includes(h.toLowerCase())&&(t=h),t}function b(e,t,r){return((e.substring(t,r)||"").match(/\d{1,2}/)||[]).join()}function _(e,t,r){e=e.filter((function(e){return e.start>t})).forEach((function(e){e.start=e.start+r,e.end=e.end+r}))}function y(e=""){return e.replace(/[.*+?^${}()|[\]\\]/g,"\\$&")}function W(t,r,a){n.message(n.LOG_LEVEL.ENGINE_TRACE,"apex.date.parse: setDatePart","value:",r,"format:",a);const o={YYYY:(e,t)=>{if(!/^\d{4}$/.test(t))throw new Error("Date Parsing Error: YYYY not valid.");e.setFullYear(t),g=parseInt(t,10)},FMYYYY:(e,t)=>{if(!/^\d{4}$/.test(t))throw new Error("Date Parsing Error: FMYYYY not valid.");e.setFullYear(t),g=parseInt(t,10)},YY:(e,t)=>{if(!/^\d{2}$/.test(t))throw new Error("Date Parsing Error: YY not valid.");const r=e.getFullYear().toString().substr(0,2)+t;e.setFullYear(r),g=parseInt(r,10)},RRRR:(e,t)=>{if(!/^\d{4}$/.test(t))throw new Error("Date Parsing Error: RRRR not valid.");e.setFullYear(t),g=parseInt(t,10)},FMRRRR:(e,t)=>{if(!/^\d{4}$/.test(t))throw new Error("Date Parsing Error: FMRRRR not valid.");e.setFullYear(t),g=parseInt(t,10)},RR:(e,t)=>{if(!/^\d{2}$/.test(t))throw new Error("Date Parsing Error: RR not valid.");const r=e.getFullYear().toString().substr(0,2)+t;e.setFullYear(r),g=parseInt(r,10)},MONTH:(e,t)=>{const r=T(t,!1);if(-1===r)throw new Error("Date Parsing Error: MONTH not valid.");e.setMonth(r),l=r},FMMONTH:(e,t)=>{const r=T(t,!1);if(-1===r)throw new Error("Date Parsing Error: FMMONTH not valid.");e.setMonth(r),l=r},MON:(e,t)=>{const r=T(t,!0);if(-1===r)throw new Error("Date Parsing Error: MON not valid.");e.setMonth(r),l=r},FMMON:(e,t)=>{const r=T(t,!0);if(-1===r)throw new Error("Date Parsing Error: FMMON not valid.");e.setMonth(r),l=r},MM:(e,t)=>{const r=parseInt(t,10);if(!/^\d+$/.test(r)||r<1||r>12)throw new Error("Date Parsing Error: MM not valid.");e.setMonth(r-1),l=r-1},FMMM:(e,t)=>{const r=parseInt(t,10);if(!/^\d+$/.test(r)||r<1||r>12)throw new Error("Date Parsing Error: FMMM not valid.");e.setMonth(r-1),l=r-1},DDD:(t,r)=>{const n=parseInt(r,10);if(!/^\d+$/.test(n)||n<1||n>366)throw new Error("Date Parsing Error: DDD not valid.");e.setDayOfYear(t,n)},DD:(e,t)=>{const r=parseInt(t,10);if(!/^\d+$/.test(r)||r<1||r>31)throw new Error("Date Parsing Error: DD not valid.");e.setDate(r),u=r},FMDD:(e,t)=>{const r=parseInt(t,10);if(!/^\d+$/.test(r)||r<1||r>31)throw new Error("Date Parsing Error: FMDD not valid.");e.setDate(r),u=r},D:(e,t)=>{const r=parseInt(t,10);if(!/^\d+$/.test(r)||r<1||r>7)throw new Error("Date Parsing Error: D not valid.");!function(e,t){const r=t-(e.getDay()+1);e.setDate(e.getDate()+r)}(e,r)},HH24:(e,t)=>{const r=parseInt(t,10);if(!/^\d+$/.test(r)||r<0||r>23)throw new Error("Date Parsing Error: HH24 not valid.");e.setHours(r)},HH12:(e,t)=>{const r=parseInt(t,10);if(!/^\d+$/.test(r)||r<1||r>12)throw new Error("Date Parsing Error: HH12 not valid.");e.setHours(r)},HH:(e,t)=>{const r=parseInt(t,10);if(!/^\d+$/.test(r)||r<1||r>12)throw new Error("Date Parsing Error: HH not valid.");e.setHours(r)},AM:(e,t)=>{if(![N,h].includes(t.toUpperCase()))throw new Error("Date Parsing Error: AM not valid.");t.toUpperCase()===N&&12===e.getHours()?e.setHours(0):t.toUpperCase()===h&&0===e.getHours()?e.setHours(12):t.toUpperCase()===N&&e.getHours()>12?e.setHours(e.getHours()-12):t.toUpperCase()===h&&e.getHours()<12&&e.setHours(e.getHours()+12)},PM:(e,t)=>{if(![N,h].includes(t.toUpperCase()))throw new Error("Date Parsing Error: PM not valid.");t.toUpperCase()===N&&12===e.getHours()?e.setHours(0):t.toUpperCase()===h&&0===e.getHours()?e.setHours(12):t.toUpperCase()===N&&e.getHours()>12?e.setHours(e.getHours()-12):t.toUpperCase()===h&&e.getHours()<12&&e.setHours(e.getHours()+12)},MI:(e,t)=>{const r=parseInt(t,10);if(!/^\d+$/.test(r)||r<0||r>59)throw new Error("Date Parsing Error: MI not valid.");e.setMinutes(r)},SS:(e,t)=>{const r=parseInt(t,10);if(!/^\d+$/.test(r)||r<0||r>59)throw new Error("Date Parsing Error: SS not valid.");e.setSeconds(r)}};o[a](t,r)}if(c){for(M.setHours(0,0,0,0),/\bDS\b/g.test(m)&&(p=p.replace(/\bDS\b/gi,t.getDSDateFormat()),m=p.toUpperCase()),/\bDL\b/g.test(m)&&(p=p.replace(/\bDL\b/gi,t.getDLDateFormat()),m=p.toUpperCase()),m.includes('"')&&(p=p.replace(/".*?"/g,(function(e){return" ".repeat(e.length-2)})),m=p.toUpperCase()),/[\u{0080}-\u{FFFF}]/u.test(m)&&(p=p.replace(/[\u{0080}-\u{FFFF}]/gu," "),m=p.toUpperCase()),n.trace("apex.date.parse: dateString",c),n.trace("apex.date.parse: formatMask",p),E="FMMONTH|FMYYYY|FMRRRR|MONTH|FMMON|FMDAY|FMDY|FMDD|FMMM|HH12|HH24|RRRR|YYYY|DAY|DDD|MON|AM|DD|DL|DS|DY|HH|MI|MM|PM|RR|SS|YY|D".split("|"),D=0;D<E.length;D++)d=E[D],m.includes(d)&&(I=p.toUpperCase().indexOf(d),Y=p.toUpperCase().indexOf(d)+d.length,"FMYYYY"!==d&&"FMRRRR"!==d||(Y-=2,F=I,O=!0),f.push({id:D,name:d,start:I,end:Y}),m=m.replace(d,new Array(d.length+1).join(D)));for(O&&_(f,F,-2),S="SSSSS|SYEAR|SYYYY|IYYY|YEAR|IYY|SCC|TZD|TZH|TZM|TZR|AD|BC|CC|EE|FF|FX|IW|IY|RM|TS|WW|E|I|J|Q|W|X".split("|"),D=0;D<S.length;D++)if(w=S[D],m.includes(w))throw new Error("Format not supported: "+w,{cause:w});for(f.sort((function(e,t){return e.start-t.start})),D=0;D<f.length;D++)H=R[D]||"~",o=f[D],C=p.toUpperCase().includes(o.name+" "),i="","MONTH"!==o.name&&"FMMONTH"!==o.name||(i=A(c,!1),i&&(c=c.replace(new RegExp(i,"ig"),H.repeat(o.name.length)+(C?" ":"")),W(M,i,o.name),f.splice(D,1),D-=1)),"MON"!==o.name&&"FMMON"!==o.name||(i=A(c,!0),i&&(c=c.replace(new RegExp(i,"ig"),H.repeat(o.name.length)+(C?" ":"")),W(M,i,o.name),f.splice(D,1),D-=1)),"MM"!==o.name&&"DD"!==o.name&&"FMMM"!==o.name&&"FMDD"!==o.name||(4===o.name.length&&(o.end=o.end-2),i=c.substring(o.start,o.end),i&&(/^\d+$/.test(i)?W(M,i,o.name):(i=b(c,o.start,o.end),i&&W(M,i,o.name)),o.end=4===o.name.length?o.end-(o.name.length-i.length)+2:o.end-(o.name.length-i.length),_(f,o.start,-(o.name.length-i.length)),f.splice(D,1),D-=1)),"DAY"!==o.name&&"FMDAY"!==o.name||(i=L(c,!1),i&&(c=c.replace(new RegExp(i,"ig"),H.repeat(o.name.length)+(C?" ":""))),f.splice(D,1),D-=1),"DY"!==o.name&&"FMDY"!==o.name||(i=L(c,!0),i&&(c=c.replace(new RegExp(i,"ig"),H.repeat(o.name.length)+(C?" ":""))),f.splice(D,1),D-=1),"HH"!==o.name&&"HH12"!==o.name&&"HH24"!==o.name||(4===o.name.length&&(o.end=o.end-2),i=c.substring(o.start,o.end),i&&(/^\d+$/.test(i)?W(M,i,o.name):(i=b(c,o.start,o.end),i&&W(M,i,o.name)),o.end=4===o.name.length?o.end-(o.name.length-i.length)+2:o.end-(o.name.length-i.length),_(f,o.start,-(o.name.length-i.length)),f.splice(D,1),D-=1)),"AM"!==o.name&&"PM"!==o.name||(i=U(c),i&&(c=c.replace(new RegExp(i,"ig"),H.repeat(o.name.length)+(C?" ":"")),W(M,i,o.name),f.splice(D,1),D-=1)),i&&C&&(c=c.replace(new RegExp(y(H)+"  ","ig"),H+" "));for(f.sort((function(e,t){return e.start-t.start})),D=0;D<f.length;D++)o=f[D],s=c.substring(o.start,o.end),s=s.replace(/[^a-zA-Z0-9]/gi,(function(e){return _(f,o.start,-e.length),""})),W(M,s,o.name);if(!e.isValid(M))throw new Error("Date Parsing Error");if(g&&l&&u&&(M.getFullYear()!==g||M.getMonth()!==l||M.getDate()!==u))throw new Error("Date Parsing Error");return M}},e.getAbbrevMonthNames=function(){return t.getAbbrevMonthNames()},e.getMonthNames=function(){return t.getMonthNames()},e.getAbbrevDayNames=function(){return t.getAbbrevDayNames()},e.getDayNames=function(){return t.getDayNames()},e.getDSDateFormat=function(){return t.getDSDateFormat()},e.getDLDateFormat=function(){return t.getDLDateFormat()}}(apex.date,apex.locale,apex.lang,apex.debug);