/*!
 * Copyright (c) 2013, 2024, Oracle and/or its affiliates.
 */
!function(e,t,o,n,i,a,s,r,l,c){"use strict";const d=e=>o.getMessage("CODE_EDITOR."+e),u=function(){i.trace("Code Editor:",...arguments)},g=function(){i.warn("Code Editor:",...arguments)},m=function(){i.error("Code Editor:",...arguments)},p="is-active",h="a-Button--toolbarOutline",f="sql",_="plsql",b="javascript",E="mle-javascript-snippet",C="mle-javascript-module",S="quicksql",T="file-urls-javascript",A="file-urls-css",I="html",y="plaintext",v="javascript",N=[b,E,C],M=[f,_,b,"css",I,E,C],L="validate",x="dbHint",O="save-page",k="save-and-run-page",w="ai-enable-assistant",P="ai-mode-selector",R="ai-nl2sql-assistant",D="ai-general-assistance",V="ai-send-selection",q="ai-send-code-message",B="ai-clear-history",U=d("CLOSE"),H=d("FIND"),$=d("HINT"),G=d("INDENTATION"),F=d("INDENT_SIZE"),K=d("INDENT_WITH_TABS"),z=d("MINIMAP"),W=d("MINIMAP_CONDITIONAL"),j=d("QUERY_BUILDER"),Q=d("REDO"),X=d("SETTINGS"),J=d("SHOW_LINE_NUMBERS"),Z=d("SHOW_RULER"),Y=d("SUGGESTIONS"),ee=d("TAB_SIZE"),te=d("THEMES"),oe=d("THEME_AUTOMATIC"),ne=d("THEME_LIGHT"),ie=d("THEME_DARK"),ae=d("THEME_HIGH_CONTRAST_DARK"),se=d("TRANSFORM_CODE_CASE"),re=d("UNDO"),le=d("UTIL_OFF"),ce=d("UTIL_ON"),de=d("VALIDATE"),ue=d("VALIDATION_SUCCESS"),ge=d("WHITESPACE"),me=d("BRACKET_PAIR_COLORIZATION"),pe=d("ROLE_DESCRIPTION"),he=d("ROLE_DESCRIPTION_READONLY"),fe=d("PREVIOUS_CHANGE"),_e=d("NEXT_CHANGE"),be=d("CHAT.IMPROVE_SELECTION"),Ee=d("CHAT.IMPROVE"),Ce=d("CHAT.IMPROVE_MSG"),Se=d("CHAT.EXPLAIN_SELECTION"),Te=d("CHAT.EXPLAIN"),Ae=d("CHAT.EXPLAIN_MSG"),Ie=d("CHAT.USE_SELECTION"),ye=d("CHAT.QUICK_ACTION_QUESTION"),ve=d("CHAT.USE_THIS_WARNING"),Ne=d("CHAT.GENERAL_WELCOME"),Me=d("CHAT.QUERY_BUILDER_WELCOME"),Le=d("CHAT.AI_DEBUG_MESSAGE"),xe=d("CHAT.GENERAL_ASSISTANCE"),Oe=d("CHAT.QUERY_BUILDER"),ke=d("CHAT.INSERT"),we=d("CHAT.INSERTED"),Pe=d("CHAT.APEX_ASSISTANT"),Re=d("CHAT.DISCLAIMER"),De=d("CHAT.DEBUG_HELP_LABEL"),Ve=d("CHAT.DEBUG_MESSAGE"),qe=d("CHAT.CONTENT_TOO_LONG"),Be=d("CHAT.ERROR_CODE_MESSAGE"),Ue=d("CHAT.WARNING_CODE_MESSAGE"),He=d("CHAT.NEW_CONVERSATION"),$e=d("CHAT.CLEAR_CHAT"),Ge=o.getMessage("PD.SAVE_AND_RUN_PAGE"),Fe=o.getMessage("PD.SAVE");let Ke,ze=!1,We=null,je=!1,Qe=!1,Xe=!1,Je=!1;const Ze={THEME:"theme",TABS_INSERT_SPACES:"tabsInsertSpaces",INDENT_SIZE:"indentSize",TAB_SIZE:"tabSize",RULER:"ruler",MINIMAP:"minimap",LINE_NUMBERS:"lineNumbers",WHITESPACE:"whitespace",SHOW_SUGGESTIONS:"showSuggestions",BRACKET_PAIR_COLORIZATION:"bracketPairColorization"},Ye=[{label:oe,value:"automatic"},{label:ne,value:"vs"},{label:ie,value:"vs-dark"},{label:ae,value:"hc-black"}],et="conditional",tt=[{label:ce,value:"on"},{label:le,value:"off"},{label:W,value:et}],ot=[{label:"2",value:"2"},{label:"3",value:"3"},{label:"4",value:"4"},{label:"8",value:"8"}],nt=[{label:"2",value:"2"},{label:"3",value:"3"},{label:"4",value:"4"},{label:"8",value:"8"}],it=i.getLevel()===i.LOG_LEVEL.OFF?".min":"",at=(()=>{const e=window.location,t=r.APEX_FILES[0];return"/"===t?e.protocol+"//"+e.host+r.APEX_FILES:"."===t?e.href.slice(0,e.href.lastIndexOf("/")+1)+r.APEX_FILES:r.APEX_FILES})(),st=at+`libraries/monaco-editor/${apex.libVersions.monacoEditor}/min`,rt=at+"libraries/monaco-editor-apex/custom-languages",lt=`${at}libraries/monaco-editor-apex/quicksql${it}.js?v=${r.APEX_VERSION}`,ct="minimap",dt={ITEM:{NATIVE_NUMBER_FIELD:"numberFieldItem"},REGION:{NATIVE_FACETED_SEARCH:"facetsRegion",NATIVE_SMART_FILTERS:"facetsRegion",NATIVE_MAP_REGION:"mapRegion",NATIVE_CARDS:"cardsRegion",NATIVE_TEMPLATE_COMPONENT:"templateReportRegion"}},ut=(()=>{const e={GLOBAL:{}};return{existsGlobally:t=>void 0!==e.GLOBAL[t],registerGlobally:(t,o)=>{e.GLOBAL[t]=o},disposeGlobally:t=>{e.GLOBAL[t]&&(e.GLOBAL[t].dispose(),delete e.GLOBAL[t])},deregisterEditor:t=>{if(e[t]){for(let o of Object.keys(e[t]))e[t][o].dispose(),delete e[t][o];delete e[t]}},existsForEditor:(t,o)=>e[t]&&void 0!==e[t][o],registerForEditor:(t,o,n)=>{e[t]=e[t]||{},e[t][o]&&e[t][o].dispose(),e[t][o]=n},disposeForEditor:(t,o)=>{e[t]&&e[t][o]&&(e[t][o].dispose(),delete e[t][o])}}})(),gt=(()=>{const e=(()=>{const e={};let t;const o=e=>{if(!N.includes(e))throw new Error("Only JavaScript and MLE JavaScript are supported")};return{setContext:(n,i,a)=>{o(a),e[n]||(e[n]={code:null,model:null,lang:a}),e[n].code=i,t===a&&(e[n].model?e[n].model.setValue(i):e[n].model=monaco.editor.createModel(i,v)),u("CONTEXT_MANAGER added context",n)},dropContext:t=>{e[t]&&(e[t].model&&(e[t].model.dispose(),e[t].model=null),e[t]=void 0),u("CONTEXT_MANAGER dropped context",t)},_reevaluate:n=>{o(n),t=n,Object.keys(e).forEach((o=>{const n=e[o];t!==n.lang?n.model&&(n.model.dispose(),n.model=null):n.model?n.model.setValue(n.code):n.model=monaco.editor.createModel(e[o].code,v)})),u("CONTEXT_MANAGER contexts reevaluated")}}})(),t="once",o="fresh";let n;const i={[b]:{contexts:[{key:"DTS_JS",contentPath:at+"libraries/monaco-editor-apex/types/browser/types.d.ts?v="+r.APEX_VERSION,load:t,isLoaded:!1},{key:"JS_EXTRAS",contentFunction:e=>e?`\n                        declare namespace apex {\n                            var items: {\n                                ${e.items.map((e=>{let t="item";return dt.ITEM[e.type]&&(t=dt.ITEM[e.type]),`${JSON.stringify(e.name)}: ${t};`})).join("\n")}\n                            };\n                            var regions: {\n                                ${e.regions.map((e=>{let t="region";return dt.REGION[e.type]?t=dt.REGION[e.type]:e.type.startsWith("TMPL_")&&(t=dt.REGION.NATIVE_TEMPLATE_COMPONENT),`${JSON.stringify(e.staticId)}: ${t};`})).join("\n")}\n                            };\n                        }`:null,load:o}]},[E]:{contexts:[{key:"DTS_JS_MLE_SNIPPET_1",condition:r.DB_VERSION>=21,contentPath:`${at}libraries/monaco-editor-apex/types/mle/${r.DB_VERSION}/types.d.ts?v=${r.APEX_VERSION}`,load:t,isLoaded:!1},{key:"DTS_JS_MLE_SNIPPET_2",condition:r.DB_VERSION>=23,content:'\n                        import { defaultConnection, default as oracledb } from "mle-js-oracledb";\n                        globalThis.apex = {\n                            db: oracledb,\n                            conn: oracledb.defaultConnection(),\n                            env: {}\n                        };\n                    ',load:t,isLoaded:!1}]},[C]:{contexts:[{key:"DTS_JS_MLE_MODULE",condition:r.DB_VERSION>=23,contentPath:`${at}libraries/monaco-editor-apex/types/mle/${r.DB_VERSION}/types.d.ts?v=${r.APEX_VERSION}`,load:t,isLoaded:!1}]}};return{reevaluate:(a,s)=>{i[a].contexts.forEach((n=>{(void 0===n.condition||n.condition)&&(n.load===t&&!n.isLoaded||n.load===o)&&((async()=>{let t;if(n.content)t=n.content;else if(n.contentPath){const e=await fetch(n.contentPath);if(!e.ok)return void m("Could not fetch file",e);t=await e.text()}else n.contentFunction&&(t=n.contentFunction(s));e.setContext(n.key,t,a)})(),n.load===t&&(n.isLoaded=!0))})),n!==a&&(n=a,monaco.languages.typescript.javascriptDefaults.setCompilerOptions({target:monaco.languages.typescript.ScriptTarget.Latest,allowJs:!0,allowNonTsExtensions:!0,noLib:[E,C].includes(a)}),monaco.languages.typescript.javascriptDefaults.setDiagnosticsOptions({diagnosticCodesToIgnore:[1003]}),e._reevaluate(a))},setContext:e.setContext,dropContext:e.dropContext}})();function mt(e,t){return new Promise((o=>{N.includes(e)?(gt.reevaluate(e,t.pageInfo),o()):e===S?monaco.languages.getEncodedLanguageId(S)?o():s.loadScript({path:lt},o):o()}))}function pt(){monaco.languages.getLanguages().filter((e=>"sql"===e.id))[0].loader=()=>new Promise(((e,t)=>{require([`custom-languages/sql${it}`],e,t)})),monaco.editor.defineTheme("apex-vs",{inherit:!0,base:"vs",rules:[{token:"string.sql",foreground:"b26100"},{token:"keyword.sql",foreground:"c74634"},{token:"predefined.sql",foreground:"7e5e8a"},{token:"operator.sql",foreground:"000000"},{token:"atom.sql",foreground:"398459"},{token:"function.sql",foreground:"795E26"},{token:"pageitem.sql",foreground:"008080",fontStyle:"bold"},{token:"table.quicksql",foreground:"1E84BF",fontStyle:"bold"},{token:"view.quicksql",foreground:"008855",fontStyle:"bold"},{token:"list.quicksql",foreground:"b26100"},{token:"keywords.quicksql",foreground:"c74634"},{token:"types.quicksql",foreground:"398459"}],colors:{"editorBracketHighlight.foreground1":"#0431FA","editorBracketHighlight.foreground2":"#008000","editorBracketHighlight.foreground3":"#7B3814"}}),monaco.editor.defineTheme("apex-vs-dark",{inherit:!0,base:"vs-dark",rules:[{token:"string.sql",foreground:"ecbb76"},{token:"keyword.sql",foreground:"f14840"},{token:"predefined.sql",foreground:"a687b3"},{token:"operator.sql",foreground:"D4D4D4"},{token:"atom.sql",foreground:"259856"},{token:"function.sql",foreground:"DCDCAA"},{token:"pageitem.sql",foreground:"3dc9b0",fontStyle:"bold"},{token:"table.quicksql",foreground:"1E84BF",fontStyle:"bold"},{token:"view.quicksql",foreground:"259856",fontStyle:"bold"},{token:"list.quicksql",foreground:"ecbb76"},{token:"keywords.quicksql",foreground:"f14840"},{token:"types.quicksql",foreground:"A3CDFF"}],colors:{"editorBracketHighlight.foreground1":"#ffd700","editorBracketHighlight.foreground2":"#da70d6","editorBracketHighlight.foreground3":"#179fff"}}),monaco.editor.defineTheme("apex-hc-black",{inherit:!0,base:"hc-black",rules:[{token:"string.sql",foreground:"ecbb76"},{token:"keyword.sql",foreground:"f14840"},{token:"predefined.sql",foreground:"a687b3"},{token:"operator.sql",foreground:"D4D4D4"},{token:"atom.sql",foreground:"259856"},{token:"function.sql",foreground:"DCDCAA"},{token:"pageitem.sql",foreground:"3dc9b0",fontStyle:"bold"},{token:"table.quicksql",foreground:"1E84BF",fontStyle:"bold"},{token:"view.quicksql",foreground:"259856",fontStyle:"bold"},{token:"list.quicksql",foreground:"ecbb76"},{token:"keywords.quicksql",foreground:"f14840"},{token:"types.quicksql",foreground:"259856"}],colors:{"editorBracketHighlight.foreground1":"#ffd700","editorBracketHighlight.foreground2":"#da70d6","editorBracketHighlight.foreground3":"#87cefa"}}),[T,A].forEach((e=>{monaco.languages.register({id:e}),monaco.languages.setLanguageConfiguration(e,{comments:{lineComment:"--",blockComment:["/*","*/"]},brackets:[["[","]"]]}),monaco.languages.setMonarchTokensProvider(e,{tokenizer:{root:[{include:"@whitespace"},[/^\[.+?\]/,"variable"]],whitespace:[[/\/\*/,"comment","@comment"],[/^--.*$/,"comment"],[/#(MIN|MIN_DIRECTORY)#/,"string"],[/#(APEX|APP|WORKSPACE|PLUGIN|THEME|THEME_DB)_FILES#/,"string"],[/#APP_VERSION#/,"string"]],comment:[[/[^\/\*]+/,"comment"],[/\*\//,"comment","@pop"],[/[\/\*]/,"comment"]]}}),monaco.languages.registerCompletionItemProvider(e,{triggerCharacters:["#"],provideCompletionItems:function(e,t,o){if("#"===o.triggerCharacter){const o=e.getWordUntilPosition(t);return{suggestions:["#MIN#","#MIN_DIRECTORY#","#APEX_FILES#","#APP_FILES#","#WORKSPACE_FILES#","#PLUGIN_FILES#","#THEME_FILES#","#THEME_DB_FILES#","#APP_VERSION#"].map((e=>({label:e,insertText:e,kind:monaco.languages.CompletionItemKind.Keyword,range:{startLineNumber:t.lineNumber,endLineNumber:t.lineNumber,startColumn:o.startColumn-1,endColumn:o.endColumn}})))}}}}),monaco.languages.registerCompletionItemProvider(e,{triggerCharacters:["[",","," "],provideCompletionItems:function(t,o){const n=t.getLineContent(o.lineNumber),i=t.getWordUntilPosition(o);if(n.slice(0,o.column-1).startsWith("[")&&n.slice(o.column-1).includes("]")){if(e===T){let e=[];const t=n.match(/^\[(.*)\].*/);return t&&(e=t[1].split(",").map((e=>e.trim()))),{suggestions:[{label:"module",insertText:"module"},{label:"async",insertText:"async"},{label:"defer",insertText:"defer"},{label:"require requirejs",insertText:"require requirejs"},{label:"require jet",insertText:"require jet"},{label:"define",insertText:"define ${1:moduleName}=${2:globalObject}"}].filter((t=>!e.includes(t.label))).map((e=>({label:e.label,insertText:e.insertText,kind:monaco.languages.CompletionItemKind.Keyword,insertTextRules:e.insertText.includes("${")?monaco.languages.CompletionItemInsertTextRule.InsertAsSnippet:void 0,range:{startLineNumber:o.lineNumber,endLineNumber:o.lineNumber,startColumn:i.startColumn,endColumn:i.endColumn}})))}}return e===A?{suggestions:[{label:"media",insertText:'media="${1}"',kind:monaco.languages.CompletionItemKind.Keyword,insertTextRules:monaco.languages.CompletionItemInsertTextRule.InsertAsSnippet,range:{startLineNumber:o.lineNumber,endLineNumber:o.lineNumber,startColumn:i.startColumn,endColumn:i.endColumn}}]}:void 0}}})}))}const ht=new Promise((e=>{new Promise((e=>{void 0===window.require?s.loadScript({path:st+"/vs/loader.js"},e):e()})).then((()=>{!function(){window.MonacoEnvironment={getWorkerUrl:function(){return"data:text/javascript;charset=utf-8,"+encodeURIComponent(`\n                    self.MonacoEnvironment = {\n                        baseUrl: "${st}"\n                    };\n                    importScripts("${st}/vs/base/worker/workerMain.js");\n                `)}},require.config({paths:{vs:st+"/vs","custom-languages":rt},waitSeconds:0});let e,t=n.getLanguage().toLowerCase();["zh-tw","zh-cn"].includes(t)?e=t:(t=t.split("-")[0],["de","es","fr","it","ja","ko","ru"].includes(t)&&(e=t)),e&&require.config({"vs/nls":{availableLanguages:{"*":e}}})}(),require(["vs/editor/editor.main"],(()=>{pt(),e()}))}))}));function ft(){return apex.builder?apex.builder.isBuilderDarkMode()?"vs-dark":"vs":window.matchMedia&&window.matchMedia("(prefers-color-scheme: dark)").matches?"vs-dark":"vs"}function _t(e){let t;Ke=e,"automatic"===e?t=ft():["vs","vs-dark","hc-black"].includes(e)?t=e:(t=ft(),u(e+" is not a valid Monaco theme. Using automatic instead.")),ht.then((()=>{monaco.editor.setTheme("apex-"+t)}))}function bt(){return/(Mac|iPhone|iPod|iPad)/i.test(navigator.platform)}function Et(){return bt()?monaco.KeyMod.WinCtrl:monaco.KeyMod.CtrlCmd}function Ct(e){if(!e)return e;function t(t,o){let i,a,s,r="";for(i=0;i<n.length;i++)a=n[i],s=e.slice(a.start,a.end+1),r+=a.ignore?s:o(s);return r}let o=function(e){let t=[],o=e.matchAll(/('|")[\s\S]*?(\1)/gm);for(let e of o)t.push({start:e.index,end:e.index+e[0].length,ignore:!0});return t}(e),n=function(e,t){let o=[],n=0;function i(e,t,n){o.push({start:e,end:t,ignore:n})}if(0===e.length)i(0,t,!1);else{for(let t=0;t<e.length;t++){let o=e[t];n<o.start&&i(n,o.start-1,!1),i(o.start,o.end,!0),n=o.end+1}n<t-1&&i(n,t,!1)}return o}(o,e.length-1),i=t(0,(function(e){return e.toLocaleLowerCase()}));return e!==i?i:t(0,(function(e){return e.toLocaleUpperCase()}))}apex.builder?e("body").on("apex-builder-theme-changed",(()=>{"automatic"===Ke&&_t("automatic")})):window.matchMedia&&window.matchMedia("(prefers-color-scheme: dark)").addListener((()=>{"automatic"===Ke&&_t("automatic")}));const St=e=>e===_?f:N.includes(e)?v:e,Tt=(()=>{let t;const o=()=>["font-family","font-size","line-height","word-spacing","letter-spacing"].map((t=>e("body").css(t))).join("-");return t=o(),()=>{const e=o();t!==e&&(t=e,u("New font values detected. Remeasuring Monaco fonts."),monaco.editor.remeasureFonts())}})();e.widget("apex.codeEditor",{widgetEventPrefix:"codeEditor",options:{language:v,value:"",readOnly:!1,autofocus:!1,ariaLabel:"",errors:[],warnings:[],suggestions:null,pageInfo:{pageId:null,isPageDesigner:!0,isGlobalPage:!1,isDialogPage:!1,applicationMessages:null,shortMsgSyntaxSupported:!1,items:[],regions:[]},showSuggestions:!0,validatePageItems:!1,minimap:et,lineNumbers:!0,wordWrap:!1,scrollBeyondLastLine:!0,wordBasedSuggestions:!1,toolbar:!0,whitespace:!1,theme:"automatic",tabsInsertSpaces:!0,indentSize:"4",tabSize:"4",ruler:!1,bracketPairColorization:!1,onInitialized:null,codeComplete:null,validateCode:null,queryBuilder:null,heightFn:null,dialogSave:null,preferencesChanged:null,lazyLoad:!1,diffEditor:!1,ai:null},_create:function(){const o=this,n=this.options,i=e(o.element[0]).addClass("a-MonacoEditor"),s=St(n.language);i.append(e(`\n                <div class="a-MonacoEditorContent">\n                    <div class="a-MonacoEditorContent-left">\n                        <div class="a-MonacoEditor-toolbar"></div>\n                        <div class="a-MonacoEditor-notification" style="display:none;">\n                            <div class="a-MonacoEditor-message"></div>\n                            <button title="${t.escapeHTMLAttr(U)}" aria-label="${t.escapeHTMLAttr(U)}" class="a-Button a-Button--noLabel a-Button--withIcon a-Button--small a-CodeEditor-searchBar-closeButton" type="button">\n                                <span class="a-Icon ui-icon-closethick" aria-hidden="true"></span>\n                            </button>\n                        </div>\n                        <div class="a-MonacoEditor-editor" dir="ltr"></div>\n                    </div>\n                </div>\n            `)),o.baseId=o.element[0].id,o._editor$=i,o._toolbar$=i.find(".a-MonacoEditor-toolbar").first(),o._notification$=i.find(".a-MonacoEditor-notification").first(),o._monacoEditor$=i.find(".a-MonacoEditor-editor").first(),o._container$=i.find(".a-MonacoEditorContent"),o._leftPanel$=i.find(".a-MonacoEditorContent-left"),n.ai&&(o._container$.append(e('\n                    <div class="a-MonacoEditorContent-right">\n                        <div class="a-MonacoEditor-toolbar"></div>\n                        <div class="a-MonacoEditor-ai"></div>\n                    </div>\n                ')),o._rightPanel$=i.find(".a-MonacoEditorContent-right"),o._chatEl$=o._rightPanel$.find(".a-MonacoEditor-ai"),o._chatToolbar$=o._rightPanel$.find(".a-MonacoEditor-toolbar"),o._rightPanelId=t.getTopApex().jQuery({}).uniqueId()[0].id,o._rightPanel$.attr("id",o._rightPanelId),o._aiEnabled=!1,o._currentAssistant=D),(async()=>{n.lazyLoad&&(u("Loading halted",i),await new Promise((e=>{i.one("load-resume",(()=>{u("Loading resumed",i),e()}))}))),await ht,await mt(o.options.language,o.options),o._notification$.find("button").on("click",(()=>{o.resetNotification()})),_t(n.theme);const e={detectIndentation:!1,insertSpaces:n.tabsInsertSpaces,indentSize:n.indentSize,tabSize:n.tabSize,rulers:n.ruler?[80]:[],scrollBeyondLastLine:n.scrollBeyondLastLine,lineNumbers:n.lineNumbers,lineNumbersMinChars:4,scrollbar:{alwaysConsumeMouseWheel:!1},stickyScroll:{enabled:!1},fixedOverflowWidgets:!0,ariaLabel:n.ariaLabel,wordBasedSuggestions:n.wordBasedSuggestions?"currentDocument":"off",quickSuggestions:n.showSuggestions,accessibilitySupport:"on",accessibilityVerbose:!1,inlineCompletionsAccessibilityVerbose:!1,renderWhitespace:n.whitespace?"all":"none",copyWithSyntaxHighlighting:!1,"bracketPairColorization.enabled":n.bracketPairColorization,mouseWheelZoom:!0,automaticLayout:!0,...o._getLanguageDependentMonacoOptions()};let r,l,c,d;if(n.diffEditor){const t=monaco.editor.createDiffEditor(o._monacoEditor$[0],{...e,renderSideBySide:!0,renderGutterMenu:!1}),i=monaco.editor.createModel(n.value.original,s),a=monaco.editor.createModel(n.value.modified,s);t.setModel({original:i,modified:a}),t.revealFirstDiff(),r=t.getModifiedEditor(),c=i,l=a,this._diffEditor=t}else l=monaco.editor.createModel(n.value,s),r=monaco.editor.create(o._monacoEditor$[0],e),r.setModel(l);r.updateOptions({ariaLabel:e.ariaLabel}),o._model=l,o._modelOriginal=c,o._modelId=l.id,o._editor=r,o._editorId=r.getId(),o._setReadOnly(!!n.readOnly),r.onDidDispose((()=>{o._disposeAllDisposables(),l.dispose(),c?.dispose()})),o._evaluateContextKeys(n.language),n.toolbar&&(o._context=a.createContext("codeEditor",this.element[0]),o._populateContext(),o._initToolbar(o._toolbar$),o._updateNotifications()),window.addEventListener("resize",t.debounce((()=>{o.resize()}),200)),i.on("resize",(function(e){o.resize(),e.stopPropagation()})),n.autofocus&&o.focus(),r.onKeyDown((e=>{o.element.children("textarea").trigger("keypress",e)})),r.onDidFocusEditorWidget((function(){d=l.getValue()})),r.onDidBlurEditorWidget((function(){let e=o.element.children("textarea"),t=l.getValue();e.trigger("blur"),d!==t&&e.val(t).trigger("change")})),n.validatePageItems&&n.pageInfo.pageId&&o._initializeItemValidator(),o._configureCustomSuggestionProvider(),o._initializeCustomActions(),o._setupMinimap(),o._monacoEditor$.on("change",(function(e){e.stopPropagation()})),void 0!==o._tempValue&&(o.setValue(o._tempValue),o._tempValue=void 0),r.onDidFocusEditorWidget((()=>{N.includes(n.language)&&gt.reevaluate(n.language,n.pageInfo),Tt()})),o._on(o._eventHandlers),o.resetUndoRedoStack(),n.onInitialized&&n.onInitialized(r)})()},_eventHandlers:{resize:function(e){this.resize(),e.stopPropagation()},focusin:function(){this.element.addClass(p)},focusout:function(){this.element.removeClass(p)}},_destroy:function(){this._editor&&this._editor.dispose(),this._chat&&(this._chat.destroy(),this._chat=null),this._chatView&&(this._chatView.destroy(),this._chatView=null),ze=!1,We=null,Qe=!1,je=!1,Xe=!1},_setOption:function(e,t){let o=this,n=o.options,i=o._editor;if(o._super(e,t),"readOnly"===e)o._setReadOnly(!!t);else if(["errors","warnings"].includes(e))o._updateNotifications();else if("language"===e)o._setLanguage(t);else if("tabsInsertSpaces"===e)i.updateOptions({insertSpaces:t});else if("ruler"===e)i.updateOptions({rulers:t?[80]:[]});else if("theme"===e)n.theme=t,_t(t);else if("minimap"===e)o._setupMinimap();else if("lineNumbers"===e)i.updateOptions({lineNumbers:!!t});else if("whitespace"===e)i.updateOptions({renderWhitespace:t?"all":"none"});else if("showSuggestions"===e)i.updateOptions({quickSuggestions:!!t});else if("bracketPairColorization"===e)i.updateOptions({"bracketPairColorization.enabled":!!t});else if("diffEditor"===e)throw new Error("Switching between regular editor and diffEditor is not supported.")},setValue:function(e){this.options.diffEditor&&this._modelOriginal&&this._model?(this._modelOriginal.setValue(e.original),this._model.setValue(e.modified),this._diffEditor.revealFirstDiff()):!this.options.diffEditor&&this._model?this._model.setValue(e):this._tempValue=e},getValue:function(){return this.options.diffEditor&&this._modelOriginal&&this._model?{original:this._modelOriginal.getValue(),modified:this._model.getValue()}:!this.options.diffEditor&&this._model?this._model.getValue():void 0!==this._tempValue?this._tempValue:this.options.value},getValidity(){const e={valid:!0,valueMissing:!1,tooLong:!1},t=this.getValue();return this.options.required&&""===t?(e.valid=!1,e.valueMissing=!0,e):this.options.maxLength&&t.length>this.options.maxLength?(e.valid=!1,e.tooLong=!0,e):e},getValidationMessage(){const e=this.getValidity();return e.valueMissing?o.getMessage("APEX.PAGE_ITEM_IS_REQUIRED"):e.tooLong?o.formatMessage("APEX.CODE_EDITOR.MAXIMUM_LENGTH_EXCEEDED",this.getValue().length,this.options.maxLength):""},getEditor:function(){return this._editor},resize:function(){let e=this;if(e.options.ai&&e._aiEnabled){let t=e._editor$.width();e._leftPanel$.width(.6*t),e._rightPanel$.width(.4*t)}e.options.heightFn&&e._editor$.outerHeight(e.options.heightFn())},getSelection:function(){return this._model.getValueInRange(this._editor.getSelection())},showNotification:function(o){let n=this._notification$.show().children().first().empty();if("string"==typeof o)n.html(o);else if("object"==typeof o&&o instanceof jQuery){n.empty();const i=this._hasSQLErrors();if(this.options.ai&&i&&this.options.language===f){let n=e(`<button class="apex-assistant-link">\n                                        <span aria-hidden="true" class="a-Icon icon-apex-assistant"></span>\n                                        <span class="a-Button-label">${t.escapeHTML(De)}</span>\n                                    </button>`);n.on("click keyup",(e=>{e.preventDefault(),("click"===e.type||"keyup"===e.type&&"Enter"===e.code)&&(this._aiEnabled?this._sendDebugMessage():this._context.set(w,!0))})),o.find("li").append(n)}n.append(o)}else m("The notification message must be a string or a jQuery object");this.resize()},resetNotification:function(){this.errors=[],this.warnings=[],this._notification$.hide().children().first().empty(),this.resize()},showSuccessNotification:function(e){this.showNotification(`<ul><li role="alert" class="is-success">${e}</li></ul>`)},focus:function(){this.element.addClass(p),this._editor.focus()},setCursor:function(e,t){this._editor.setPosition({lineNumber:e,column:t})},setCursorToEnd:function(e){let t=this._editor,o=this._model,n=o.getLineCount(),i=o.getLineMaxColumn(n);this.setCursor(n,i),e&&t.revealLine(n)},changeGeneration:function(){return this._model.getAlternativeVersionId()},isClean:function(e){return this._model.getAlternativeVersionId()===e},getPreferencesString:function(){let e=this.options,t={},o=Object.values(Ze);for(let n=0;n<o.length;n++){let i=o[n];t[i]=e[i]}return JSON.stringify(t)},_undoRedoDisposable:void 0,resetUndoRedoStack:function(){const e=this,t=e._editor,o=e._model,n=e._context;e._undoRedoDisposable&&(e._undoRedoDisposable.dispose(),e._undoRedoDisposable=void 0),n?.disable("undo"),n?.disable("redo");let i=o.getAlternativeVersionId(),a=i,s=i;e._undoRedoDisposable=t.onDidChangeModelContent((()=>{const e=o.getAlternativeVersionId();e<a?(n?.enable("redo"),e===i&&n?.disable("undo")):(e<=s?e===s&&n?.disable("redo"):(n?.disable("redo"),a>s&&(s=a)),n?.enable("undo")),a=e}))},diffPrevious:function(){this._diffEditor.goToDiff("previous")},diffNext:function(){this._diffEditor.goToDiff("next")},_setReadOnly:function(e){const t=this._editor;if(t){t.updateOptions({readOnly:e});const o=t.getDomNode().querySelector("textarea.inputarea");o&&(o.ariaReadOnly=e,o.ariaRoleDescription=e?he:pe)}},_disposableExists:function(e){return ut.existsForEditor(this._editorId,e)},_registerDisposable:function(e,t){ut.registerForEditor(this._editorId,e,t)},_disposeDisposable:function(e){ut.disposeForEditor(this._editorId,e)},_disposeAllDisposables:function(){ut.deregisterEditor(this._editorId)},_triggerMonacoAction:function(e){const t=this._editor;this.focus(),t.trigger(null,e)},_configureCustomSuggestionProvider:function(){let e,t,o=this,n=o._editor,i=o.options,a=St(i.language),s=i.suggestions;if(s){if(Array.isArray(s))e=s;else{if("function"!=typeof s)return void m("Suggestions type not supported");e=s(a)}if(e=e.map((e=>(e.insertText=e.insertText||e.label,e))),o._registerDisposable("global-suggestions",monaco.languages.registerCompletionItemProvider(a,{provideCompletionItems:function(o,i){if(n.hasTextFocus()){t=o.getWordUntilPosition(i);const n=e.map((e=>(e.range={startLineNumber:i.lineNumber,endLineNumber:i.lineNumber,startColumn:t.startColumn,endColumn:t.endColumn},e.kind=monaco.languages.CompletionItemKind.Constructor,e)));return n.length?{suggestions:n}:void 0}}})),"function"==typeof i.pageInfo?.applicationMessages){const t=["$","{","("];i.pageInfo.applicationMessages().then((s=>{e=s,o._registerDisposable("message-suggestions",monaco.languages.registerCompletionItemProvider(a,{triggerCharacters:t,provideCompletionItems:function(o,s,r){let l=[];if(!n.hasTextFocus()||![I,y,b].includes(a)||r.triggerKind!==monaco.languages.CompletionTriggerKind.TriggerCharacter||!t.includes(r.triggerCharacter))return;const c=e.map((e=>({...e,range:{startLineNumber:s.lineNumber,endLineNumber:s.lineNumber,startColumn:s.column,endColumn:s.column},kind:monaco.languages.CompletionItemKind.Keyword}))),d=o.getLineContent(s.lineNumber),u=o.getWordUntilPosition({column:s.column-1,lineNumber:s.lineNumber});if("$"===r.triggerCharacter){if(a===b||"APP_TEXT"!==u.word||"&"!==d.charAt(u.startColumn-2))return;l=c.map((e=>(e.insertText.includes(".")?(e.additionalTextEdits=[{text:'&"APP_TEXT',range:{startLineNumber:s.lineNumber,startColumn:u.startColumn-1,endLineNumber:s.lineNumber,endColumn:u.endColumn}}],e.insertText=e.insertText+'".'):e.insertText=e.insertText+".",e)))}else if(i.pageInfo.shortMsgSyntaxSupported&&"{"===r.triggerCharacter){let e=d.charAt(u.startColumn-2);if(a===b||"&"!==e)return;l=c.map((e=>(e.insertTextRules=monaco.languages.CompletionItemInsertTextRule.InsertAsSnippet,e.placeholders?.forEach(((t,o)=>{e.insertText=`${e.insertText} ${t[1]}=\${${o+1}:""}`})),"}"===d.charAt(u.startColumn)?e.additionalTextEdits=[{text:".",range:{startLineNumber:s.lineNumber,startColumn:u.startColumn+e.insertText.length+1,endLineNumber:s.lineNumber,endColumn:u.endColumn+e.insertText.length+1}}]:e.insertText+="}.",e)))}else if("("===r.triggerCharacter){let e=d.substring(0,s.column-2);if(a!==b||!["apex.lang.getMessage","apex.lang.formatMessage","apex.lang.formatMessageNoEscape"].some((t=>e.endsWith(t))))return;l=c.flatMap((e=>e.isJS?(e.insertText=`"${e.insertText}"`,"getMessage"!==u.word&&(e.insertTextRules=monaco.languages.CompletionItemInsertTextRule.InsertAsSnippet,e.placeholders?.forEach(((t,o)=>{e.insertText=`${e.insertText}, "\${${o+1}:${t[0]}}"`}))),[e]):[]))}return l.length?{suggestions:l}:void 0}}))}))}i.language===E&&o._registerDisposable("mle-env",monaco.languages.registerCompletionItemProvider(v,{triggerCharacters:["."],provideCompletionItems:function(o,i,a){if(n.hasTextFocus()&&a.triggerKind===monaco.languages.CompletionTriggerKind.TriggerCharacter&&"."===a.triggerCharacter&&o.getLineContent(i.lineNumber).substr(0,i.column-2).endsWith("apex.env")){t=o.getWordUntilPosition(i);const n=e.map((e=>(e.range={startLineNumber:i.lineNumber,endLineNumber:i.lineNumber,startColumn:t.startColumn,endColumn:t.endColumn},e.kind=monaco.languages.CompletionItemKind.Constructor,e)));return n.length?{suggestions:n}:void 0}}}))}},_setupMinimap:function(){const e=this,o=e.options,n=e._editor,i=e._model;function a(){n&&i&&!i.isDisposed()&&n.updateOptions({minimap:{enabled:"on"===o.minimap||o.minimap===et&&i.getLineCount()>=100}})}e._disposableExists(ct)&&e._disposeDisposable(ct),o.minimap===et&&e._registerDisposable(ct,i.onDidChangeContent(t.debounce(a,1e3))),a()},_normalizeNotificationObject:function(e){if("object"==typeof e)return e;if("string"==typeof e){const t={message:e},o=t.message.indexOf("ORA-06550");if(o>-1){const e=t.message.slice(o).match(/\d{1,}/g),n=parseInt(e[1],10),i=parseInt(e[2],10);isNaN(n)||(t.lineNumber=n),isNaN(i)||(t.columnNumber=i)}return t}throw new Error("error/warning must be an object or a string")},gotoPosition:function(e,t,o=!0){let n=this._editor;n&&(n.revealLineInCenter(e),n.setPosition({lineNumber:e,column:t}),o&&setTimeout((function(){n&&n.focus()}),100))},_updateNotifications:function(){let t=this,o=t.options,n=e("<ul/>");function i(o,i){const a=t._normalizeNotificationObject(o),s=e(`<li role="alert" class="${i}" style="cursor: pointer;"></li>`);a.lineNumber&&a.columnNumber?s.append(e(`<a data-line="${a.lineNumber}" data-column="${a.columnNumber}"></a>`).text(a.message)):s.text(a.message),n.append(s)}o.errors.forEach((e=>{i(e,"is-error")})),o.warnings.forEach((e=>{i(e,"is-warning")})),n.children().length?(t.showNotification(n),e("a[data-line]",n).on("click",(function(){t.gotoPosition(e(this).data("line"),e(this).data("column"))}))):t.resetNotification(),t._updateInlineMessages()},_updateInlineMessages:function(){let e=this,o=e.options,n=e._model,i=[];function a(o,n){const a=e._normalizeNotificationObject(o);var s;a.lineNumber&&a.columnNumber&&i.push({startLineNumber:a.lineNumber,endLineNumber:a.lineNumber,startColumn:a.columnNumber,endColumn:1e3,message:(s=a.message,t.stripHTML(s.match(/.*(ORA|PLS)-\d+:(?<msg>.*)/s)?.groups?.msg||s).trim()),severity:n})}o.errors.forEach((e=>{a(e,monaco.MarkerSeverity.Error)})),o.warnings.forEach((e=>{a(e,monaco.MarkerSeverity.Warning)})),monaco.editor.setModelMarkers(n,"lineMessages",i),i.length&&e.gotoPosition(i[0].startLineNumber,i[0].startColumn)},_queryBuilder:function(){let e=this.options.queryBuilder;e&&e(this,this.getValue())},_codeComplete:function(){if(!this.options.codeComplete||![f,_,E].includes(this.options.language))return;let e,o,n,i,a,s,r=this,l=r.options.language,c=r._editor,d=r._model,u=c.getPosition(),g=d.getLineContent(u.lineNumber),m=!1,h=r.element[0];if(e=function(e,t){for(;" "===e[t];)t-=1;t=e.lastIndexOf(" ",t)+1;let o=e.indexOf(" ",t);return-1===o&&(o=e.length),e.substring(t,o)}(g,u.column-1),o=e.split("."),[f,_].includes(l))1===o.length&&[":","&"].includes(e.charAt(0))?(m=!0,n=e.slice(1)):(i=o[o.length-2],a=o[o.length-3]);else if(l===E){if(3!==o.length||"apex"!==o[0]||"env"!==o[1])return void r._triggerMonacoAction("editor.action.triggerSuggest");m=!0,n=o[2],i=void 0,a=void 0}t.delayLinger.start("autocompleteSpinner",(function(){s=t.showSpinner(h)})),r.options.codeComplete({type:m?"item":"",search:m?n:o[o.length-1],parent:i,grantParent:a},(function(e){apex.util.delayLinger.finish("autocompleteSpinner",(function(){s&&(s.remove(),s=null)}));let t,o,n=monaco.languages.CompletionItemKind,i={template:n.Constructor,application_item:n.Constructor,page_item:n.Constructor,package:n.Constructor,procedure:n.Method,function:n.Function,constant:n.Constructor,variable:n.Constructor,type:n.Constructor,table:n.Constructor,view:n.Constructor,keyword:n.Constructor,sequence:n.Constructor},a=[];for(let n=0;n<e.length;n++){t=e[n];for(let e=0;e<t.completions.length;e++){o=t.completions[e];let n=o.r||o;a.push({label:o.d||o,insertText:n,detail:t.title,kind:i[t.type]})}}let l=!1;r._registerDisposable("ajax-suggestions",monaco.languages.registerCompletionItemProvider(d.getLanguageId(),{provideCompletionItems:function(){return r.element.hasClass(p)&&!l?(l=!0,a.length?{suggestions:a}:void 0):void 0}})),r._triggerMonacoAction("editor.action.triggerSuggest")}))},validateCode:function(){if(!this.options.validateCode)return;let o=this;o.options.validateCode(o.getValue(),(function(n){n=e.extend({},{errors:[],warnings:[]},n),o._setOption("errors",n.errors),o._setOption("warnings",n.warnings),Je||0!==n.errors.length||0!==n.warnings.length||o.showSuccessNotification(t.escapeHTML(ue))})),Je=!1},_notifyPreferenceChange:function(){let t=this.element[0];this._trigger("preferencesChanged",e.Event("click",{target:t}))},_populateContext:function(){let e=this,t=e.options,n=t.language,i=e._editor,a=e._model,s=e._context;function r(){a.updateOptions({insertSpaces:t.tabsInsertSpaces,tabSize:t.tabSize,indentSize:t.indentSize})}s.add([{name:"undo",action:function(){e._triggerMonacoAction("undo")}},{name:"redo",action:function(){e._triggerMonacoAction("redo")}},{name:"find",action:function(){e._triggerMonacoAction(t.readOnly?"actions.find":"editor.action.startFindReplaceAction")}},{name:"theme",get:function(){return t.theme},set:function(o){t.theme=o,_t(o),e._notifyPreferenceChange()},choices:Ye},{name:"minimap",get:function(){return t.minimap},set:function(o){t.minimap=o,e._setupMinimap(),e._notifyPreferenceChange()},choices:tt},{name:"tabs-insert-spaces",label:K,get:function(){return t.tabsInsertSpaces},set:function(o){t.tabsInsertSpaces=o,r(),e._notifyPreferenceChange()}},{name:"tab-size",get:function(){return t.tabSize},set:function(o){t.tabSize=o,r(),e._notifyPreferenceChange()},choices:ot},{name:"indent-size",get:function(){return t.indentSize},set:function(o){t.indentSize=o,r(),e._notifyPreferenceChange()},choices:nt},{name:"show-ruler",label:Z,get:function(){return t.ruler},set:function(t){e._setOption("ruler",t),e._notifyPreferenceChange()}},{name:"line-numbers",label:J,get:function(){return t.lineNumbers},set:function(t){e._setOption("lineNumbers",t),e._notifyPreferenceChange()}},{name:"whitespace",label:ge,get:function(){return t.whitespace},set:function(t){e._setOption("whitespace",t),e._notifyPreferenceChange()}},{name:"show-suggestions",label:Y,get:function(){return t.showSuggestions},set:function(t){e._setOption("showSuggestions",t),e._notifyPreferenceChange()}},{name:"bracket-pair-colorization",label:me,get:function(){return t.bracketPairColorization},set:function(t){e._setOption("bracketPairColorization",t),e._notifyPreferenceChange()}}]),t.queryBuilder&&s.add({name:"query-builder",hide:![f,_].includes(n),action:function(){e._queryBuilder()}}),t.codeComplete&&(s.add({name:"code-complete",hide:![f,_,E].includes(n),action:function(){e._codeComplete()}}),i.addAction({id:"apex-code-complete",label:$,keybindings:[Et()|monaco.KeyCode.Space],precondition:x,run:function(){e._codeComplete()}})),t.validateCode&&(s.add({name:"validate",hide:!this._hasValidate(),action:function(){e.validateCode()}}),i.addAction({id:"apex-code-validate",label:de,keybindings:[Et()|monaco.KeyMod.Alt|monaco.KeyCode.KeyV],precondition:L,run:function(){e.validateCode()}})),t.diffEditor&&s.add([{name:"diff-previous",action:function(){e.diffPrevious()},title:fe,label:fe,shortcut:"Alt+Shift+F5"},{name:"diff-next",action:function(){e.diffNext()},title:_e,label:_e,shortcut:"Alt+F5"}]),t.dialogSave&&((t.pageInfo.isGlobalPage||t.pageInfo.isDialogPage)&&t.pageInfo.isPageDesigner||!t.pageInfo.isPageDesigner?(s.add({name:O,action:function(e,o){Je=!0,t.dialogSave(e,o)}}),i.addAction({id:"apex-"+O,label:o.format(Fe,[]),keybindings:[monaco.KeyMod.Alt|monaco.KeyCode.F8,monaco.KeyMod.Alt|monaco.KeyCode.F7],run:function(e){Je=!0,t.dialogSave({},e.getDomNode())}})):(s.add({name:k,action:function(e,o){Je=!0,t.dialogSave(e,o,!0)}}),i.addAction({id:"apex-"+k,label:o.format(Ge,[]),keybindings:[monaco.KeyMod.Alt|monaco.KeyCode.F7,monaco.KeyMod.Alt|monaco.KeyCode.F8],run:function(e){Je=!0,t.dialogSave({},e.getDomNode(),!0)}}))),t.ai&&(s.add({name:w,label:Pe,ariaControls:e._rightPanelId,get:()=>e._aiEnabled,set:t=>{e._aiEnabled=t,t?e._chat?(e._chatView.show(),e.resize(),e._chatToolbar$.css("visibility","visible"),e._toggleQuickActions(),e._context.enable(V)):this._aiCallback():e._chat&&(e._chatView.hide(),e._rightPanel$.width(0),e._chatToolbar$.css("visibility","hidden"),e.resize(),e._editor.focus(),e._context.disable(V),e._chatView.removeQuickActions())}}),s.add({name:V,action:(t,o,{showAiMessage:n=!0,isNewConversation:i=!0}={})=>{if(ze=this._hasSelection(),ze){if(Qe=!1,i){const t=e._chat.getHistory().messages;(t.length>2||2===t.length&&!t[1].excludeFromCommits)&&e._expireConversation()}e._chatContext.invoke(q,null,null,e.getSelection()),n&&e._chat.addAiMessage({content:ye}),e._currentAssistant===D&&e._chat.setViewQuickActions(e._chatView,[{title:Ee,message:Ce},{title:Te,message:Ae}]),e._toggleQuickActions(),Qe=!0}else e._chat.addAiMessage({content:ve});return!0}}),s.add({name:"switch-pane-focus",shortcut:"F6",action:()=>{if(e._aiEnabled)return e._editor.hasTextFocus()?e._chatView.el.querySelector("textarea").focus():e.focus(),!0}}))},_expireConversation(){this._chat.expireMessages(),this._chat.addAiMessage({content:He,excludeFromCommits:!0,cssClasses:"a-ChatItem-row--context"});const e=this._chat.getViews()[0].getMessageViews();e[e.length-1].el.classList.remove("a-ChatItem-row--inbound"),this.sendLanguageMessage()},_toggleQuickActions(){if(!this._aiEnabled||je||Xe)return void(Xe=!1);if(Qe)return Qe=!1,void this._addSelectionQuickActions();const e=this._chat.getAllViewsQuickActionsButtons().get(this._chatView);e?.length&&(this._hasSelection()?e[0].button.disabled&&(this._scrollToBottom=this._chatView.isTranscriptScrolledToBottom(),e.forEach((e=>e.button.disabled=!1))):e.forEach((e=>e.button.disabled=!0)))},_addSelectionQuickActions(){const e=this,t=!this._hasSelection(),o=[{title:Ie,disabled:t,action:function(){e._context.invoke(V,null,null,{showAiMessage:e._currentAssistant===D})}}];e._currentAssistant===D&&o.push({title:be,disabled:t,action:function(){e._context.invoke(V,null,null,{showAiMessage:!1}),ze&&(e._chatView.removeQuickActions(),e._chat.addUserMessage({content:Ce}),e._chat.commit())}},{title:Se,disabled:t,action:function(){e._context.invoke(V,null,null,{showAiMessage:!1}),ze&&(e._chatView.removeQuickActions(),e._chat.addUserMessage({content:Ae}),e._chat.commit())}}),e._chat.setViewQuickActions(e._chatView,o)},_hasSQLErrors(){let{errors:e,warnings:t}=this.options;return e=e.filter((e=>e!==o.getMessage("PD.PE.IS_REQUIRED"))),!!e.length||!!t.length},_hasSelection(){return""!==this.getSelection().trim()},_getChatInitMessage:e=>e===D?Ne:Me,_aiCallback:function(){const e=this,n=this.getValue();let i,s=this._hasSelection();e._currentAssistant=e.options.language===f?R:D;const r=()=>{const e=this.options.language;return M.includes(e)?e:y},d=(e,t)=>{let n=t||r();return n!==_&&(n=St(n)),o.formatNoEscape("```%0\n%1\n```",n,e)},u=()=>{let t=r();e._currentAssistant===R&&(t="sql-query"),e._chat.addUserMessage({content:t,hidden:!0})};e.sendLanguageMessage=u;const m=(t,o=!1)=>{e._chat.addUserMessage({content:d(t),type:e._chat.constructor.messageTypes.MARKDOWN,cssClasses:"a-ChatItem-row--context",hidden:o});const n=e._chat.getViews()[0].getMessageViews();n[n.length-1].el.classList.remove("a-ChatItem-row--outbound")},p=(t,o)=>{if(t.getCurrentUser()===o.user)return{};const n=[t.constructor.actions.COPY];return e._editor.getOption(monaco.editor.EditorOption.readOnly)||n.push({label:ke,iconClasses:"icon-clipboard",action:(t,o,n,i,a,s)=>{const r="is-inserted",l="ui-icon-check",c="insertTimeoutId",{iconClasses:d}=i,u=a.querySelector(".a-ChatItem-buttonLabel"),g=a.querySelector(".a-ChatItem-buttonIcon");parseInt(a.dataset[c],10)||(a.classList.add(r),u.innerText=we,Xe=!0,e._editor.pushUndoStop(),e._editor.executeEdits("",[{range:e._editor.getSelection(),text:s.innerText.trim().replaceAll(/\u00A0/g," ")}]),e._editor.pushUndoStop(),g&&(d&&g.classList.toggle(...d.split(" ")),l&&g.classList.toggle(...l.split(" "))),a.dataset[c]=setTimeout((()=>{delete a.dataset[c],a.classList.remove(r),u&&(u.innerText=ke),g&&(d&&g.classList.toggle(...d.split(" ")),l&&g.classList.toggle(...l.split(" ")))}),3e3))}}),{codeBlockQuickActions:n}},b=()=>e._currentAssistant===D?xe:Oe,E=()=>{const t=[];return[f,_].includes(e.options.language)&&t.push({id:"chatModeControls",align:"start",groupTogether:!1,customCSS:h,controls:[{type:"MENU",id:"chatModeSelector",title:b(),label:b(),menu:{items:[{type:"radioGroup",action:P}]}}]}),t.push({id:"chatControls",align:"end",groupTogether:!1,customCSS:h,controls:[{type:"BUTTON",title:$e,label:$e,iconOnly:!1,iconBeforeLabel:!0,action:B}]}),t};e._sendDebugMessage=()=>{const t=e.getSelection(),n=e.getValue(),i=""!==t?t:n;je||(e._chatContext.set(P,D,!0),e._chat.addAiMessage(Le),(()=>{let t,n,{errors:i,warnings:a}=e.options;i=i.filter((e=>e!==o.getMessage("PD.PE.IS_REQUIRED"))),i.length>0?(t=i.join(", "),n=Be):(t=a.join(", "),n=Ue);const s=o.format(n,d(t,y));e._chat.addUserMessage({content:s,type:e._chat.constructor.messageTypes.MARKDOWN,hidden:!0})})(),m(i,!0),e._chat.addUserMessage({content:Ve,type:e._chat.constructor.messageTypes.MARKDOWN,hidden:!0}),e._chatView.removeQuickActions(),e._chat.commit())},i&&!s&&n.length>4e3?c.alert(qe):l.getUserConsent().then((o=>{if(o){if(e._chat=new l.Chat({...e.options.ai.ajax,processMessage:p}),e._chatView=e._chat.createInlineView({el:e._chatEl$[0],disclaimer:Re,highlightCode:(e,t,o,n)=>{n.getAttribute("data-lang")===_&&n.setAttribute("data-lang",f),monaco.editor.colorizeElement(n,{theme:this._editor._themeService._theme.themeName})}}),e._chatContext=a.createContext("chatEditor",e.element[0]),e._chatContext.add([{name:P,get:()=>e._currentAssistant,set:(t,o)=>{[R,D].includes(t)&&(e._currentAssistant=t,e._chatContext.invoke(B),Qe=!1,o||(e._hasSelection()?(e._currentAssistant===R&&e._chatView.removeQuickActions(),e._context.invoke(V,null,null,{showAiMessage:!1})):e._chat.addAiMessage({content:e._getChatInitMessage(t),excludeFromCommits:!0})),e._chatToolbar$.toolbar("option","data",E()),e._chatToolbar$.toolbar("findElement","chatModeSelector").focus())},choices:[{label:Oe,value:R},{label:xe,value:D}]},{name:B,action:()=>{e._chat.clearMessages(),e._addSelectionQuickActions(),u()}},{name:q,action:(e,t,o)=>{m(o)}}]),e._chatToolbar$.toolbar({actionsContext:e._chatContext,simple:!0,data:E()}),e.resize(),u(),e._chat.on("chatlocked",(()=>{je=!0,Qe=!0,We=e.getSelection(),e._chatToolbar$.find("button").attr("disabled",!0)})),e._chat.on("chatunlocked",(()=>{je=!1,e._chatToolbar$.find("button").attr("disabled",!1),setTimeout((()=>{e.getSelection()!==We&&e._addSelectionQuickActions()}),1)})),e._currentAssistant===R)if(i=this._hasSQLErrors(),i)e._sendDebugMessage();else if(""!==n&&!s){const t=e._editor.getModel().getFullModelRange();e._editor.setSelection(t),s=!0}e._editor.onDidChangeCursorSelection(t.debounce(e._toggleQuickActions.bind(e)),250),e._chatEl$[0].addEventListener("transitionend",(t=>{t.target.classList.contains("a-ChatActions-quickPicks")&&e._scrollToBottom&&(e._chatView.scrollTranscriptToBottom(),e._scrollToBottom=!1)})),i||(s?e._context.invoke(V,null,null,{showAiMessage:!1,isNewConversation:!1}):setTimeout((()=>{e._chat.addAiMessage({content:e._getChatInitMessage(e._currentAssistant),excludeFromCommits:!0}),e._addSelectionQuickActions()}),1))}else g("The User has not consented to the use of AI."),e._context.set(w,!1)}))},_initToolbar:function(e){let t,n=this.options,i={actionsContext:this._context,simple:!0,data:[],label:pe};function a(e){return bt()?e.replace("Alt","Option").replace("Ctrl","Control"):e}let s=[];s.push({type:"BUTTON",title:re,label:re,iconOnly:!0,icon:"icon-undo",action:"undo"}),s.push({type:"BUTTON",title:Q,label:Q,iconOnly:!0,icon:"icon-redo",action:"redo"}),i.data.push({id:"undoControls",align:"start",groupTogether:!0,controls:s});let r=[];if(r.push({type:"BUTTON",title:H,label:H,iconOnly:!0,icon:"icon-cm-find",action:"find"}),i.data.push({id:"searchControls",align:"start",groupTogether:!0,controls:r}),n.queryBuilder||n.codeComplete||n.validateCode||n.ai){let e={id:"helperControls",align:"start",groupTogether:!0,controls:[]};n.queryBuilder&&e.controls.push({type:"BUTTON",title:j,label:j,iconOnly:!0,icon:"icon-cm-query-builder",action:"query-builder"}),n.codeComplete&&(t=$+" - "+a("Ctrl+Space"),e.controls.push({type:"BUTTON",title:t,label:t,iconOnly:!0,icon:"icon-cm-autocomplete",action:"code-complete"})),n.validateCode&&(t=de+" - "+a("Ctrl+Alt+V"),e.controls.push({type:"BUTTON",title:t,label:t,iconOnly:!0,icon:"icon-cm-validate",action:"validate"}));let o={id:"aiControls",align:"start",groupTogether:!0,controls:[]};n.ai&&o.controls.push({type:"TOGGLE",title:Pe,label:Pe,iconOnly:!1,iconBeforeLabel:!0,icon:"icon-apex-assistant",action:w}),i.data.push(e),i.data.push(o)}if(n.diffEditor){const e={id:"diffControls",align:"end",groupTogether:!0,controls:[]};e.controls.push({type:"BUTTON",action:"diff-previous",icon:"icon-prev-change",iconOnly:!0}),e.controls.push({type:"BUTTON",action:"diff-next",icon:"icon-next-change",iconOnly:!0}),i.data.push(e)}if(n.dialogSave){let e=[];(n.pageInfo.isGlobalPage||n.pageInfo.isDialogPage)&&n.pageInfo.isPageDesigner||!n.pageInfo.isPageDesigner?(t=o.format(Fe,"- "+a("Alt+F7")),e.push({type:"BUTTON",title:t,label:o.format(Fe,[]),iconOnly:!!n.ai,action:O})):(t=o.format(Ge,"- "+a("Alt+F8")),e.push({type:"BUTTON",title:t,label:o.format(Ge,[]),iconOnly:!!n.ai,iconBeforeLabel:!0,icon:"icon-run-page",action:k})),i.data.push({id:"saveControls",align:"end",groupTogether:!1,customCSS:h,controls:e})}i.data.push({id:"menuControls",align:"end",groupTogether:!1,controls:[{type:"MENU",title:X,label:X,iconOnly:!0,icon:"icon-gear",menu:{items:[{type:"subMenu",label:G,menu:{items:[{type:"toggle",action:"tabs-insert-spaces"},{type:"subMenu",label:ee,menu:{items:[{type:"radioGroup",action:"tab-size"}]}},{type:"subMenu",label:F,menu:{items:[{type:"radioGroup",action:"indent-size"}]}}]}},{type:"subMenu",label:te,menu:{items:[{type:"radioGroup",action:"theme"}]}},{type:"subMenu",label:z,menu:{items:[{type:"radioGroup",action:"minimap"}]}},{type:"toggle",action:"line-numbers"},{type:"toggle",action:"show-ruler"},{type:"toggle",action:"show-suggestions"},{type:"toggle",action:"whitespace"},{type:"toggle",action:"bracket-pair-colorization"}]}}]}),e.toolbar(i),n.diffEditor&&e.find("button[data-action*='diff']").removeAttr("data-no-update")},_evaluateContextKeys:function(e){this._contextKeys||(this._contextKeys={});const t=this._contextKeys,o=this._editor;t[L]||(t[L]=o.createContextKey(L,!0)),t[x]||(t[x]=o.createContextKey(x,!0)),t[L].set(this._hasValidate()),t[x].set([f,_,E].includes(e))},_setLanguage:function(e){let t=this,o=t._model,n=t._editor,i=t.options,a=t._context,s=St(e);function r(e){a.lookup(e)&&a.hide(e)}function l(e){a.lookup(e)&&a.show(e)}monaco.editor.setModelMarkers(o,"lineMessages",[]),t.resetNotification(),t._configureCustomSuggestionProvider(),[f,_,E].includes(e)?l("code-complete"):r("code-complete"),[f,_].includes(e)?l("query-builder"):r("query-builder"),this._hasValidate()?l("validate"):r("validate"),t._chatContext&&t._chatContext.set(P,D),t._evaluateContextKeys(e),mt(e,i),monaco.editor.setModelLanguage(o,s),n.updateOptions(t._getLanguageDependentMonacoOptions())},_hasValidate:function(){const e=this.options,t=e.language;return[f,_,I,E].includes(t)&&void 0!==e.validateCode},_initializeItemValidator:function(){let e=this._model,n=this.options,i=n.pageInfo.pageId,a=new RegExp("P("+i+"|0)_[A-Z0-9_]*","gi"),s=[],r=n.pageInfo.items.map((e=>e.name.toLowerCase())),l=t.debounce((function(){if(s=[],e&&!e.isDisposed()){const t=e.getLineCount();for(let n=1;n<=t;n++){const t=e.getLineContent(n).matchAll(a);for(let e of t){let t=e[0].toLowerCase(),i=e.index+1;r.includes(t)||s.push({startLineNumber:n,endLineNumber:n,startColumn:i,endColumn:i+t.length,message:o.formatMessage("CODE_EDITOR.ITEM_DOES_NOT_EXIST",t.toUpperCase()),severity:monaco.MarkerSeverity.Warning})}}monaco.editor.setModelMarkers(e,"itemValidations",s)}}),100);e.onDidChangeContent(l),l()},_initializeCustomActions:function(){let e=this,t=e._editor,o=e._model,n=Et();function i(e,o){let n=t.getAction(e);t.addAction({id:e,label:n.label,alias:n.alias,keybindings:[o],run:function(){n.run()}})}i("editor.action.transformToUppercase",n|monaco.KeyMod.Alt|monaco.KeyCode.KeyU),i("editor.action.transformToLowercase",n|monaco.KeyMod.Alt|monaco.KeyCode.KeyL),e.options.diffEditor&&(delete t._actions["editor.action.diffReview.prev"],delete t._actions["editor.action.diffReview.next"]),t.addAction({id:"editor.action.toggleSmartCase",label:se,alias:se,keybindings:[n|monaco.KeyMod.Alt|monaco.KeyCode.KeyC],run:function(){let e=t.getSelections();if(!e.length)return;if(!o)return;let n=[];for(let t=0;t<e.length;t++){let i=e[t];if(!i.isEmpty()){let e=Ct(o.getValueInRange(i));n.push({range:i,text:e})}}t.pushUndoStop(),t.executeEdits(null,n),t.pushUndoStop()}}),t.addCommand(monaco.KeyMod.CtrlCmd|monaco.KeyMod.Shift|monaco.KeyCode.KeyP,(()=>{e._triggerMonacoAction("editor.action.quickCommand")}))},_getLanguageDependentMonacoOptions:function(){const e=this.options,t=St(e.language);return{wordWrap:e.language===y||(e.wordWrap?"on":"off"),useTabStops:![f,_].includes(e.language),suggest:t===v?{showFiles:!1}:void 0}}}),e.apex.codeEditor=e.apex.codeEditor||{},e.apex.codeEditor.LANG_SQL=f,e.apex.codeEditor.LANG_PLSQL=_,e.apex.codeEditor.LANG_JAVASCRIPT=b,e.apex.codeEditor.LANG_JAVASCRIPT_MLE_SNIPPET=E,e.apex.codeEditor.LANG_JAVASCRIPT_MLE_MODULE=C,e.apex.codeEditor.LANG_CSS="css",e.apex.codeEditor.LANG_FILE_URLS_JAVASCRIPT=T,e.apex.codeEditor.LANG_FILE_URLS_CSS=A,e.apex.codeEditor.LANG_HTML=I,e.apex.codeEditor.LANG_XML="xml",e.apex.codeEditor.LANG_QUICKSQL=S,e.apex.codeEditor.LANG_PLAINTEXT=y,e.apex.codeEditor.LANG_YAML="yaml",e.apex.codeEditor.registerJavaScriptContextCode=gt.setContext,e.apex.codeEditor.deregisterJavaScriptContextCode=gt.dropContext,e.apex.codeEditor.preferencesObjectFromString=function(e){let t,o={};if(!e)return{};try{t=JSON.parse(e)}catch(e){return g("Could not parse optionsString"),{}}return Object.values(Ze).forEach((e=>{let n=t[e],i=e;if(i===Ze.THEME){if(!Ye.map((e=>e.value)).includes(n))return void g("Bad theme ignored: "+n)}else if([Ze.INDENT_SIZE,Ze.TAB_SIZE].includes(i)){if(!["2","3","4","8"].includes(n))return void g("Bad number ignored: "+n)}else if("minimap"===i){if(!tt.map((e=>e.value)).includes(n))return void g("Bad minimap ignored: "+n)}else{if(![Ze.TABS_INSERT_SPACES,Ze.RULER,Ze.LINE_NUMBERS,Ze.WHITESPACE,Ze.SHOW_SUGGESTIONS,Ze.BRACKET_PAIR_COLORIZATION].includes(i))return void g("Unknown preference: "+i);n=!!n}o[i]=n})),o}}(apex.jQuery,apex.util,apex.lang,apex.locale,apex.debug,apex.actions,apex.server,apex.env,apex.ai,apex.message);