/*!
 * Copyright (c) 2022, 2023, Oracle and/or its affiliates.
 */
window.sw=function(e,t,n){"use strict";let E={preview:{}};return E.preview.functions={},E.preview.install={},E.preview.activate={},E.preview.fetch={},E.preview.sync={},E.preview.push={},E.preview.notificationclick={},E.preview.notificationclose={},E.preview.canmakepayment={},E.preview.paymentrequest={},E.preview.functions.hooks=()=>{const E="#PreviewFunctions code";e(E).text(`let apex = {};\napex.sw = {};\napex.sw.CORE_CACHE_MATCHER = '#APEX_FILES#';\napex.sw.CORE_CACHE_PREFIX = "APEX-CORE-";\napex.sw.CORE_CACHE_NAME = apex.sw.CORE_CACHE_PREFIX + '#APEX_VERSION#';\n\napex.sw.APP_CACHE_MATCHER = "&FB_FLOW_ID./files/static/v";\napex.sw.APP_CACHE_PREFIX = "APEX-APP-&FB_FLOW_ID.-v";\n\napex.sw.appCacheNeedsCleanup = true;\n\napex.sw.cleanAPEXCaches = () => {\n  caches.keys().then(cacheNames => Promise.all(\n    cacheNames.map(cacheName => {\n      if (cacheName.startsWith(apex.sw.CORE_CACHE_PREFIX) && cacheName !== apex.sw.CORE_CACHE_NAME) {\n        return caches.delete(cacheName);\n      }\n    })\n  ));\n};\n\napex.sw.cleanAppCaches = (appCacheName) => {\n  if (appCacheNeedsCleanup) {\n    appCacheNeedsCleanup = false;\n    caches.keys().then(cacheNames => Promise.all(\n      cacheNames.map(cacheName => {\n        if (cacheName.startsWith(apex.sw.APP_CACHE_PREFIX) && cacheName !== appCacheName) {\n          return caches.delete(cacheName);\n        }\n      })\n    ));\n  }\n};\n\n// ${n.formatMessage("PWA.SW.PREVIEW.HOOK.STARTS",e("#P507_SW_FUNCTION_VARIABLE_LABEL").text())}\n${t.P507_SW_FUNCTION_VARIABLE.value}\n// ${n.formatMessage("PWA.SW.PREVIEW.HOOK.ENDS",e("#P507_SW_FUNCTION_VARIABLE_LABEL").text())}\n`),Prism.highlightElement(document.querySelector(E))},E.preview.install.hooks=()=>{const E="#PreviewInstallEvent code";e(E).text(`self.addEventListener("install", (event) => {\n  // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.STARTS",e("#P507_SW_INSTALL_BEFORE_LABEL").text())}\n  ${t.P507_SW_INSTALL_BEFORE.value}\n  // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.ENDS",e("#P507_SW_INSTALL_BEFORE_LABEL").text())}\n\n  self.skipWaiting();\n\n  // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.STARTS",e("#P507_SW_INSTALL_AFTER_LABEL").text())}\n  ${t.P507_SW_INSTALL_AFTER.value}\n  // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.ENDS",e("#P507_SW_INSTALL_AFTER_LABEL").text())}\n});`),Prism.highlightElement(document.querySelector(E))},E.preview.install.custom=()=>{const E="#PreviewInstallEvent code";e(E).text(`self.addEventListener("install", (event) => {\n  // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.STARTS",e("#P507_SW_INSTALL_LABEL").text())}\n  ${t.P507_SW_INSTALL.value}\n  // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.ENDS",e("#P507_SW_INSTALL_LABEL").text())}\n});`),Prism.highlightElement(document.querySelector(E))},E.preview.activate.hooks=()=>{const E="#PreviewActivateEvent code";e(E).text(`self.addEventListener("activate", (event) => {\n  // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.STARTS",e("#P507_SW_ACTIVATE_BEFORE_LABEL").text())}\n  ${t.P507_SW_ACTIVATE_BEFORE.value}\n  // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.ENDS",e("#P507_SW_ACTIVATE_BEFORE_LABEL").text())}\n\n  apex.sw.cleanAPEXCaches();\n\n  // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.STARTS",e("#P507_SW_ACTIVATE_AFTER_LABEL").text())}\n  ${t.P507_SW_ACTIVATE_AFTER.value}\n  // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.ENDS",e("#P507_SW_ACTIVATE_AFTER_LABEL").text())}\n});`),Prism.highlightElement(document.querySelector(E))},E.preview.activate.custom=()=>{const E="#PreviewActivateEvent code";e(E).text(`self.addEventListener("activate", (event) => {\n  // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.STARTS",e("#P507_SW_ACTIVATE_LABEL").text())}\n  ${t.P507_SW_ACTIVATE.value}\n  // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.ENDS",e("#P507_SW_ACTIVATE_LABEL").text())}\n});`),Prism.highlightElement(document.querySelector(E))},E.preview.fetch.hooks=()=>{const E="#PreviewFetchEvent code";e(E).text(`self.addEventListener("fetch", (event) => {\n\n  // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.STARTS",e("#P507_SW_FETCH_BEFORE_LABEL").text())}\n  ${t.P507_SW_FETCH_BEFORE.value}\n  // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.ENDS",e("#P507_SW_FETCH_BEFORE_LABEL").text())}\n\n  if ( event.request.method !== "GET" ) { return; }\n\n  event.respondWith(\n    (async () => {\n      let cacheName;\n\n      if (event.request && event.request.url && event.request.url.indexOf(apex.sw.CORE_CACHE_MATCHER) >= 0) {\n        cacheName = apex.sw.CORE_CACHE_NAME;\n      } else if (event.request && event.request.url && event.request.url.indexOf(apex.sw.APP_CACHE_MATCHER) >= 0) {\n        const fileVersion = event.request.url.split(apex.sw.APP_CACHE_MATCHER).pop().split("/")[0];\n        cacheName = apex.sw.APP_CACHE_PREFIX + fileVersion;\n        apex.sw.cleanAppCaches(cacheName);\n      }\n\n      // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.STARTS",e("#P507_SW_FETCH_CACHE_DEFINITION_LABEL").text())}\n      ${t.P507_SW_FETCH_CACHE_DEFINITION.value}\n      // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.ENDS",e("#P507_SW_FETCH_CACHE_DEFINITION_LABEL").text())}\n\n      let cache;\n\n      // Try to get from the cache first\n      if (cacheName) {\n        cache = await caches.open(cacheName);\n        const response = await cache.match(event.request);\n\n        // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.STARTS",e("#P507_SW_FETCH_CACHE_RESPONSE_LABEL").text())}\n        ${t.P507_SW_FETCH_CACHE_RESPONSE.value}\n        // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.ENDS",e("#P507_SW_FETCH_CACHE_RESPONSE_LABEL").text())}\n\n        if (response) {\n          return response;\n        }\n      }\n      \n      // Then get from network\n      try {\n        const response = await fetch(event.request);\n\n        // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.STARTS",e("#P507_SW_FETCH_NETWORK_RESP_SUC_LABEL").text())}\n        ${t.P507_SW_FETCH_NETWORK_RESP_SUC.value}\n        // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.ENDS",e("#P507_SW_FETCH_NETWORK_RESP_SUC_LABEL").text())}\n\n        // Clone response to put in cache\n        if (response.ok && cacheName) {\n          try {\n            const resClone = response.clone();\n            cache.put(event.request, resClone);\n          } catch (error) {\n            console.warn(error);\n          }\n        }\n        \n        // Return ressource from network\n        return response;\n      } catch (error) {\n\n        // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.STARTS",e("#P507_SW_FETCH_NETWORK_RESP_ERR_LABEL").text())}\n        ${t.P507_SW_FETCH_NETWORK_RESP_ERR.value}\n        // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.ENDS",e("#P507_SW_FETCH_NETWORK_RESP_ERR_LABEL").text())}\n\n        if (event.request.mode === "navigate") {\n          const offlinePage = 'APEX.PWA.OFFLINE';\n          \n          // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.STARTS",e("#P507_SW_FETCH_OFFLINE_PAGE_LABEL").text())}\n          ${t.P507_SW_FETCH_OFFLINE_PAGE.value}\n          // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.ENDS",e("#P507_SW_FETCH_OFFLINE_PAGE_LABEL").text())}\n\n          return new Response(offlinePage, {\n            headers: { "Content-Type": "text/html" }\n          });\n        } else {\n          // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.STARTS",e("#P507_SW_FETCH_NETWORK_FALLBACK_LABEL").text())}\n          ${t.P507_SW_FETCH_NETWORK_FALLBACK.value}\n          // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.ENDS",e("#P507_SW_FETCH_NETWORK_FALLBACK_LABEL").text())}\n          return new Response();\n        }\n      }\n    })()\n  );\n});`),Prism.highlightElement(document.querySelector(E))},E.preview.fetch.custom=()=>{const E="#PreviewFetchEvent code";e(E).text(`self.addEventListener("fetch", (event) => {\n  // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.STARTS",e("#P507_SW_FETCH_LABEL").text())}\n  ${t.P507_SW_FETCH.value}\n  // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.ENDS",e("#P507_SW_FETCH_LABEL").text())}\n});`),Prism.highlightElement(document.querySelector(E))},E.preview.sync.custom=()=>{const E="#PreviewSyncEvent code";e(E).text(`self.addEventListener("sync", (event) => {\n  // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.STARTS",e("#P507_SW_SYNC_LABEL").text())}\n  ${t.P507_SW_SYNC.value}\n  // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.ENDS",e("#P507_SW_SYNC_LABEL").text())}\n});`),Prism.highlightElement(document.querySelector(E))},E.preview.push.hooks=()=>{const E="#PreviewPushEvent code";e(E).text(`self.addEventListener("push", (event) => {\n  // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.STARTS",e("#P507_SW_PUSH_BEFORE_LABEL").text())}\n  ${t.P507_SW_PUSH_BEFORE.value}\n  // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.ENDS",e("#P507_SW_PUSH_BEFORE_LABEL").text())}\n\n  const notification = event.data.json();\n  self.registration.showNotification( notification.title, notification );\n\n  // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.STARTS",e("#P507_SW_PUSH_AFTER_LABEL").text())}\n  ${t.P507_SW_PUSH_AFTER.value}\n  // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.ENDS",e("#P507_SW_PUSH_AFTER_LABEL").text())}\n});`),Prism.highlightElement(document.querySelector(E))},E.preview.push.custom=()=>{const E="#PreviewPushEvent code";e(E).text(`self.addEventListener("push", (event) => {\n  // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.STARTS",e("#P507_SW_PUSH_LABEL").text())}\n  ${t.P507_SW_PUSH.value}\n  // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.ENDS",e("#P507_SW_PUSH_LABEL").text())}\n});`),Prism.highlightElement(document.querySelector(E))},E.preview.notificationclick.hooks=()=>{const E="#PreviewNotificationclickEvent code";e(E).text(`self.addEventListener("notificationclick", (event) => {\n  // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.STARTS",e("#P507_SW_NOTIFICATIONCLICK_BEF_LABEL").text())}\n  ${t.P507_SW_NOTIFICATIONCLICK_BEF.value}\n  // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.ENDS",e("#P507_SW_NOTIFICATIONCLICK_BEF_LABEL").text())}\n\n    event.notification.close();\n    const baseUrl = location.pathname.replace("/sw.js", "");\n    const targetUrl = event.notification?.data?.targetUrl || baseUrl;\n\n    // Get all browser tabs\n    event.waitUntil( clients.matchAll( {\n      includeUncontrolled: true,\n      type: "window"\n    } ).then( ( clientList ) => {\n      // Loop through browser tabs\n      for ( let client of clientList ) {\n        // If a tab matches the app, use that to open the notification\n        if ( client.url.includes( baseUrl ) && "focus" in client ) {\n          return client.navigate( targetUrl ).then( client => client.focus() );\n        }\n      }\n      // If not open a new window\n      if ( clients.openWindow ) {\n        return clients.openWindow( targetUrl );\n      }\n    } ) );\n\n  // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.STARTS",e("#P507_SW_NOTIFICATIONCLICK_AFT_LABEL").text())}\n  ${t.P507_SW_NOTIFICATIONCLICK_AFT.value}\n  // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.ENDS",e("#P507_SW_NOTIFICATIONCLICK_AFT_LABEL").text())}\n});`),Prism.highlightElement(document.querySelector(E))},E.preview.notificationclick.custom=()=>{const E="#PreviewNotificationclickEvent code";e(E).text(`self.addEventListener("notificationclick", (event) => {\n  // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.STARTS",e("#P507_SW_NOTIFICATIONCLICK_LABEL").text())}\n  ${t.P507_SW_NOTIFICATIONCLICK.value}\n  // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.ENDS",e("#P507_SW_NOTIFICATIONCLICK_LABEL").text())}\n});`),Prism.highlightElement(document.querySelector(E))},E.preview.notificationclose.custom=()=>{const E="#PreviewNotificationcloseEvent code";e(E).text(`self.addEventListener("notificationclose", (event) => {\n  // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.STARTS",e("#P507_SW_NOTIFICATIONCLOSE_LABEL").text())}\n  ${t.P507_SW_NOTIFICATIONCLOSE.value}\n  // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.ENDS",e("#P507_SW_NOTIFICATIONCLOSE_LABEL").text())}\n});`),Prism.highlightElement(document.querySelector(E))},E.preview.canmakepayment.custom=()=>{const E="#PreviewCanmakepaymentEvent code";e(E).text(`self.addEventListener("canmakepayment", (event) => {\n  // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.STARTS",e("#P507_SW_CANMAKEPAYMENT_LABEL").text())}\n  ${t.P507_SW_CANMAKEPAYMENT.value}\n  // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.ENDS",e("#P507_SW_CANMAKEPAYMENT_LABEL").text())}\n});`),Prism.highlightElement(document.querySelector(E))},E.preview.paymentrequest.custom=()=>{const E="#PreviewPaymentrequestEvent code";e(E).text(`self.addEventListener("paymentrequest", (event) => {\n  // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.STARTS",e("#P507_SW_PAYMENTREQUEST_LABEL").text())}\n  ${t.P507_SW_PAYMENTREQUEST.value}\n  // ${n.formatMessage("PWA.SW.PREVIEW.HOOK.ENDS",e("#P507_SW_PAYMENTREQUEST_LABEL").text())}\n});`),Prism.highlightElement(document.querySelector(E))},E}($,apex.items,apex.lang);