set define '^' verify off
prompt ...wwv_flow_advisor_dev
create or replace package wwv_flow_advisor_dev as
--------------------------------------------------------------------------------
--
--  Copyright (c) 2009, 2023, Oracle and/or its affiliates.
--
--    NAME
--      wwv_flow_advisor_dev.sql
--
--    DESCRIPTION
--      This package checks the integrity of an Oracle APEX application.
--      eg. if all item references are valid, target page numbers exist, ...
--
--    RUNTIME DEPLOYMENT: NO
--
--    MODIFIED   (MM/DD/YYYY)
--    pawolf      03/27/2009 - Created
--
--------------------------------------------------------------------------------
--
c_empty_page_id_list wwv_flow_global.n_arr;
--
--==============================================================================
-- Checks an application based on the specified checks which should be performed.
-- The page id list is optional.
-- p_check_list contains as value wwv_flow_advisor_check_msgs.code to define
-- which checks should be performed.
--==============================================================================
procedure check_application (
    p_application_id in number,
    p_page_id_list   in wwv_flow_global.n_arr default c_empty_page_id_list,
    p_check_list     in wwv_flow_global.vc_arr2 );
--
--==============================================================================
-- The following procedures/functions have to be public because they are called
-- from dynamic SQL which is generated by check_application.
-- NOTE: They are for internal use only!
--==============================================================================
function get_type (
    p_view_name              in varchar2,
    p_column_name            in varchar2,
    p_column_json_key        in varchar2,
    p_depending_column_value in varchar2 )
  return varchar2;
--
procedure verify_varchar2_property (
    p_view_name         in varchar2,
    p_primary_key_value in varchar2,
    p_column_name       in varchar2,
    p_column_json_key   in varchar2,
    p_value             in varchar2,
    p_type              in varchar2 := null,
    p_page_id           in number );
--
procedure verify_clob_property (
    p_view_name         in varchar2,
    p_primary_key_value in varchar2,
    p_column_name       in varchar2,
    p_column_json_key   in varchar2,
    p_value             in clob,
    p_type              in varchar2 := null,
    p_page_id           in number );
--
procedure verify_number_property (
    p_view_name         in varchar2,
    p_primary_key_value in varchar2,
    p_column_name       in varchar2,
    p_column_json_key   in varchar2,
    p_value             in number,
    p_type              in varchar2 := null,
    p_page_id           in number );
--
procedure check_target_page_auth (
    p_view_name            in varchar2,
    p_primary_key_value    in varchar2,
    p_column_name          in varchar2,
    p_value                in varchar2,
    p_authorization_scheme in varchar2,
    p_page_id              in number );
--
end wwv_flow_advisor_dev;
/
show errors
