prompt --application/set_environment
set define off verify off feedback off
--------------------------------------------------------------------------------
--
-- Oracle APEX export file
--
-- You should run this script using a SQL client connected to the database as
-- the owner (parsing schema) of the application or as a database user with the
-- APEX_ADMINISTRATOR_ROLE role.
--
-- This export file has been automatically generated. Modifying this file is not
-- supported by Oracle and can lead to unexpected application and/or instance
-- behavior now or in the future.
--
-- NOTE: Calls to apex_application_install override the defaults below.
--
--------------------------------------------------------------------------------
begin
wwv_flow_imp.import_begin (
 p_version_yyyy_mm_dd=>'2024.11.30'
,p_release=>'24.2.0'
,p_default_workspace_id=>10
,p_default_application_id=>4500
,p_default_id_offset=>0
,p_default_owner=>'APEX_240200'
);
end;
/
 
prompt APPLICATION 4500 - Oracle APEX SQL Workshop
--
-- Application Export:
--   Application:     4500
--   Name:            Oracle APEX SQL Workshop
--   Exported By:     APEX_240200
--   Flashback:       0
--   Export Type:     Application Export
--     Pages:                    168
--       Items:                  933
--       Computations:            96
--       Validations:            162
--       Processes:              313
--       Regions:                778
--       Buttons:                416
--       Dynamic Actions:        276
--     Shared Components:
--       Logic:
--         Items:                 20
--         Processes:             28
--         Computations:           3
--         Build Options:          9
--       Navigation:
--         Lists:                 41
--         Breadcrumbs:            2
--           Entries:            116
--         NavBar Entries:         3
--       Security:
--         Authentication:         1
--         Authorization:         23
--       User Interface:
--         Themes:                 1
--         Templates:
--           Page:                16
--           Region:              39
--           Label:               13
--           List:                25
--           Popup LOV:            1
--           Calendar:             1
--           Breadcrumb:           2
--           Button:               8
--           Report:              23
--         LOVs:                 182
--         Shortcuts:              7
--         Plug-ins:              20
--       PWA:
--       Globalization:
--         Messages:             555
--       Reports:
--       E-Mail:
--     Supporting Objects:  Included
--   Version:         24.2.0
--   Instance ID:     1000199029436341
--

prompt --application/delete_application
begin
wwv_flow_imp.remove_flow(wwv_flow.g_flow_id);
end;
/
prompt --application/create_application
begin
wwv_imp_workspace.create_flow(
 p_id=>wwv_flow.g_flow_id
,p_owner=>nvl(wwv_flow_application_install.get_schema,'APEX_240200')
,p_name=>nvl(wwv_flow_application_install.get_application_name,'Oracle APEX SQL Workshop')
,p_alias=>nvl(wwv_flow_application_install.get_application_alias,'SQL-WORKSHOP')
,p_application_group=>wwv_flow_imp.id(91050719712959059)
,p_application_group_name=>'APEX Product'
,p_application_group_comment=>'Applications shipped with the APEX product distribution'
,p_page_view_logging=>'YES'
,p_charset=>'utf-8'
,p_page_protection_enabled_y_n=>'Y'
,p_checksum_salt_last_reset=>'20250422164159'
,p_bookmark_checksum_function=>'SH1'
,p_compatibility_mode=>'24.2'
,p_session_state_commits=>'IMMEDIATE'
,p_flow_language=>'en'
,p_flow_language_derived_from=>'SESSION'
,p_date_format=>'&G_USER_DEFAULT_DATE_FORMAT.'
,p_direction_right_to_left=>'N'
,p_flow_image_prefix => nvl(wwv_flow_application_install.get_image_prefix,'')
,p_publish_yn=>'Y'
,p_documentation_banner=>'Oracle APEX database object development user interface.  SQL Workshop provides database object and data browsing, query building, SQL command processor, and SQL Scripts.'
,p_authentication_id=>wwv_flow_imp.id(539837904309662819)
,p_populate_roles=>'A'
,p_application_tab_set=>1
,p_logo_type=>'C'
,p_logo=>'<img src="#IMAGE_PREFIX#apex_ui/apexlogo.png" width="282" height="20" alt="&PRODUCT_NAME." />'
,p_public_user=>'APEX_PUBLIC_USER'
,p_proxy_server=>nvl(wwv_flow_application_install.get_proxy,'')
,p_no_proxy_domains=>nvl(wwv_flow_application_install.get_no_proxy_domains,'')
,p_flow_version=>'&PRODUCT_NAME. 24.2.0'
,p_flow_status=>'AVAILABLE_W_EDIT_LINK'
,p_flow_unavailable_text=>'This application is currently unavailable.'
,p_exact_substitutions_only=>'Y'
,p_browser_cache=>'N'
,p_browser_frame=>'S'
,p_runtime_api_usage=>'O:W'
,p_pass_ecid=>'N'
,p_authorize_public_pages_yn=>'Y'
,p_rejoin_existing_sessions=>'N'
,p_csv_encoding=>'Y'
,p_auto_time_zone=>'N'
,p_error_handling_function=>'wwv_flow_error_dev.internal_error_handler'
,p_substitution_string_01=>'PRODUCT_NAME'
,p_substitution_value_01=>'Oracle APEX'
,p_substitution_string_02=>'LOGOUT'
,p_substitution_value_02=>'Logout'
,p_substitution_string_03=>'MSG_COMPANY'
,p_substitution_value_03=>'Workspace: &COMPANY.'
,p_substitution_string_04=>'MSG_LANGUAGE'
,p_substitution_value_04=>'Language'
,p_substitution_string_05=>'MSG_COPYRIGHT'
,p_substitution_value_05=>'Copyright &copy; 1999, 2024, Oracle and/or its affiliates.'
,p_substitution_string_06=>'MSG_USER'
,p_substitution_value_06=>'User'
,p_substitution_string_07=>'MSG_JSCRIPT'
,p_substitution_value_07=>'You must run this product with JavaScript enabled.'
,p_substitution_string_08=>'MSG_TBL_SUMMARY'
,p_substitution_value_08=>'Page Layout Table'
,p_substitution_string_09=>'EDIT'
,p_substitution_value_09=>'Edit'
,p_substitution_string_10=>'DONE'
,p_substitution_value_10=>'Done'
,p_substitution_string_11=>'TOP'
,p_substitution_value_11=>'Top'
,p_substitution_string_12=>'CLOSE'
,p_substitution_value_12=>'Close'
,p_substitution_string_13=>'DATE_FORMAT'
,p_substitution_value_13=>'DS'
,p_substitution_string_14=>'LONG_DATE_FORMAT'
,p_substitution_value_14=>'DL'
,p_substitution_string_15=>'TIME_FORMAT'
,p_substitution_value_15=>'TS'
,p_substitution_string_16=>'DATE_TIME_FORMAT'
,p_substitution_value_16=>'DS TS'
,p_substitution_string_17=>'RETURN_TO_APPLICATION'
,p_substitution_value_17=>'Return to Application'
,p_substitution_string_18=>'HELP'
,p_substitution_value_18=>'Help'
,p_substitution_string_19=>'MSG_WORKSPACE'
,p_substitution_value_19=>'Workspace'
,p_file_prefix => nvl(wwv_flow_application_install.get_static_app_file_prefix,'')
,p_version_scn=>2483339
,p_print_server_type=>'INSTANCE'
,p_file_storage=>'DB'
,p_is_pwa=>'N'
);
end;
/
prompt --application/user_interfaces
begin
wwv_flow_imp_shared.create_user_interface(
 p_id=>wwv_flow_imp.id(4500)
,p_theme_id=>3
,p_home_url=>'f?p=4100:1:&SESSION.'
,p_login_url=>'f?p=4550:1:&SESSION.'
,p_theme_style_by_user_pref=>false
,p_global_page_id=>0
,p_nav_list_template_options=>'#DEFAULT#'
,p_css_file_urls=>'#IMAGE_PREFIX#css/apex_builder#MIN#.css'
,p_include_legacy_javascript=>'PRE18:18'
,p_nav_bar_type=>'NAVBAR'
);
end;
/
prompt --application/shared_components/navigation/lists/sql_command_tabs
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(996508348031635)
,p_name=>'SQL Command Tabs'
,p_list_status=>'PUBLIC'
,p_version_scn=>75558087
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(996930166037917)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Results'
,p_list_item_link_target=>'#'
,p_list_text_01=>'id="result_tab" onclick="html_TabClick(this,''resultsHolder'');return false;"'
,p_list_item_current_type=>'ALWAYS'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(997202592039442)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Explain'
,p_list_item_link_target=>'#'
,p_list_text_01=>'id="explain_tab" onclick="sc_getPlan();html_TabClick(this,''explainHolder'');return false;"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(22157207203570630)
,p_list_item_display_sequence=>25
,p_list_item_link_text=>'Describe'
,p_list_item_link_target=>'#'
,p_list_text_01=>'id="describe_tab" onclick="sc_getDesc();html_TabClick(this,''describeHolder'');return false;"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'139'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(997509865041519)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Saved SQL'
,p_list_item_link_target=>'#'
,p_list_text_01=>'id="savedsql_tab" onclick="sc_getSavedSQL();html_TabClick(this,''SavedSQLHolder'');return false;"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(23661510949786902)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'History'
,p_list_item_link_target=>'#'
,p_list_text_01=>'id="history_tab" onclick="sc_DisplayHist();html_TabClick(this,''historyHolder'');return false;"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/qb_sub_tabs
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(1390719147195878)
,p_name=>'QB_SUB_TABS'
,p_list_status=>'PUBLIC'
,p_version_scn=>75558089
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1391928151198404)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Conditions'
,p_list_item_link_target=>'#'
,p_list_text_01=>'id="cond_tab" onclick="html_TabClick(this,''conditionsHolder'');return false;"'
,p_list_item_current_type=>'ALWAYS'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1395101055209596)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'SQL'
,p_list_item_link_target=>'#'
,p_list_text_01=>'id="sql_tab" onclick="qb_postState();qb_genSql();html_TabClick(this,''queryText_table'');return false;"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1395705903210915)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Results'
,p_list_item_link_target=>'#'
,p_list_text_01=>'id="result_tab" onclick="qb_genSql();html_TabClick(this,''queryResults_table'');qb_checkQuery();return false;"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(159965504417193520)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Saved SQL'
,p_list_item_link_target=>'#'
,p_list_text_01=>'id="SavedSql_tab" onclick="qb_getSavedSQL();html_TabClick(this,''SavedSQLHolder'');return false;"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/p2000_ob_tree_menu
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(1600109635671564)
,p_name=>'P2000_OB_TREE_MENU'
,p_list_status=>'PUBLIC'
,p_version_scn=>75558089
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2209583665942618)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Create %0'
,p_list_item_link_target=>'#action$create-current-object-type'
,p_list_text_01=>'create-current-object-type'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1602136956548295)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1600327266671611)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Refresh'
,p_list_item_link_target=>'#action$objects-refresh'
,p_list_item_current_for_pages=>'#action$objects-refresh'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1600708408671612)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Expand All'
,p_list_item_link_target=>'#action$objects-expand-all'
,p_list_item_current_for_pages=>'#action$objects-expand-all'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1601168944671613)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Collapse All'
,p_list_item_link_target=>'#action$objects-collapse-all'
,p_list_item_current_for_pages=>'#action$objects-collapse-all'
);
end;
/
prompt --application/shared_components/navigation/lists/sql_workshop_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(1819372123291186)
,p_name=>'SQL Workshop Tasks'
,p_list_status=>'PUBLIC'
,p_version_scn=>128696255
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1819580750291177)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>'Create Data Model Using AI'
,p_list_item_link_target=>'f?p=&APP_ID.:1600:&SESSION.::&DEBUG.:1600:::'
,p_list_item_disp_cond_type=>'EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_ai_api.is_enabled'
,p_list_item_disp_condition2=>'PLSQL'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/query_builder_link_menu
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(1993413324492056)
,p_name=>'Query_Builder_Link_Menu'
,p_list_status=>'PUBLIC'
,p_version_scn=>75558089
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1994208260500093)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Delete Join'
,p_list_item_link_target=>'javascript:qb_delLinkClick();'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1994516571502453)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Set Left Outer Join'
,p_list_item_link_target=>'javascript:qb_outer(''L'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1994823151504371)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Set Right Outer Join'
,p_list_item_link_target=>'javascript:qb_outer(''R'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1993900988497974)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Unset Outer Join'
,p_list_item_link_target=>'javascript:qb_outer(''E'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/extension_links_menu
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(2200356137180721)
,p_name=>'Extension Links Menu'
,p_list_type=>'SQL_QUERY'
,p_list_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select lev,',
'       label,',
'       target,',
'       null     as is_current,',
'       null     as image,',
'       null     as image_attrib,',
'       null     as image_alt_attribute,',
'       null     as attribute1,',
'       null     as attribute2,',
'       null     as attribute3,',
'       null     as attribute4,',
'       null     as attribute5,',
'       ''_blank'' as attribute6,',
'       null     as attribute7,',
'       null     as attribute8,',
'       null     as attribute9,',
'       null     as attribute10',
'  from (',
'          select 1                          as lev,',
'                 name                       as label,',
'                 wwv_extension.get_url(url) as target,',
'                 null                       as wsname,',
'                 display_sequence',
'            from wwv_extension_links',
'           where security_group_id = :workspace_id',
'          union all',
'          select 1                                           as lev,',
'                 nvl(eg.menu_label, initcap(c.display_name)) as label,',
'                 null                                        as target,',
'                 c.display_name                              as wsname,',
'                 0                                           as display_sequence',
'            from wwv_extension_grants eg, wwv_flow_companies c',
'           where eg.security_group_id           = :workspace_id',
'             and eg.extension_security_group_id = c.provisioning_company_id',
'             and c.is_extension_yn in (''Y'', ''A'')',
'             and exists (',
'                   select 1',
'                     from wwv_extension_links l',
'                    where l.security_group_id = eg.extension_security_group_id',
'                      and is_public           = ''Y'' )',
'          union all',
'          select 2                             as lev,',
'                 name                          as label,',
'                 wwv_extension.get_url(el.url) as target,',
'                 eg.wsname                     as wsname,',
'                 el.display_sequence',
'            from (',
'                    select eg.*,',
'                           c.display_name as wsname',
'                      from wwv_extension_grants eg, wwv_flow_companies c',
'                     where eg.security_group_id           = :workspace_id',
'                       and eg.extension_security_group_id = c.provisioning_company_id',
'                       and c.is_extension_yn in (''Y'', ''A'')',
'                 )                         eg, wwv_extension_links el',
'           where el.security_group_id = eg.extension_security_group_id',
'             and el.is_public         = ''Y''',
'       )',
' order by wsname nulls first, lev, display_sequence, label'))
,p_list_status=>'PUBLIC'
,p_reference_id=>2000133062045966
,p_version_scn=>73375486
);
end;
/
prompt --application/shared_components/navigation/lists/dg_bp_datasources_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(2500895807659729)
,p_name=>'DG_BP_DATASOURCES_TASKS'
,p_list_status=>'PUBLIC'
,p_version_scn=>75558089
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2501049036659732)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Blueprint Details'
,p_list_item_link_target=>'f?p=&APP_ID.:4001:&SESSION.::&DEBUG.::P4001_BLUEPRINT_ID:&P4015_BLUEPRINT_ID.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/p2000_ob_create_menu
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(2686914575823204)
,p_name=>'P2000_OB_CREATE_MENU'
,p_list_status=>'PUBLIC'
,p_version_scn=>75558089
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2690717953823212)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Table'
,p_list_item_link_target=>'f?p=&APP_ID.:2020:&SESSION.::&DEBUG.:2020,2022,TBL_WIZ_COLUMNS,TBL_WIZ_FKS,TBL_WIZ_CONS:P2020_PARSING_SCHEMA:~PARSING_SCHEMA~:'
,p_list_text_01=>'create-table'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2691106004823212)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'View'
,p_list_item_link_target=>'f?p=&APP_ID.:2015:&SESSION.::&DEBUG.:2015:P2015_PARSING_SCHEMA:~PARSING_SCHEMA~:'
,p_list_text_01=>'create-view'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2691523551823212)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Index'
,p_list_item_link_target=>'f?p=&APP_ID.:2025:&SESSION.::&DEBUG.:2025,2026,2027:P2025_PARSING_SCHEMA:~PARSING_SCHEMA~:'
,p_list_text_01=>'create-index'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2691925468823213)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Sequence'
,p_list_item_link_target=>'f?p=&APP_ID.:2030:&SESSION.::&DEBUG.:2030:P2030_PARSING_SCHEMA:~PARSING_SCHEMA~:'
,p_list_text_01=>'create-sequence'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2692366703823213)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Type'
,p_list_item_link_target=>'f?p=&APP_ID.:2035:&SESSION.::&DEBUG.:2035:P2035_PARSING_SCHEMA:~PARSING_SCHEMA~:'
,p_list_text_01=>'create-type'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2692721994823213)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Package'
,p_list_item_link_target=>'f?p=&APP_ID.:2040:&SESSION.::&DEBUG.:2040:P2040_PARSING_SCHEMA,P2040_OBJECT_TYPE:~PARSING_SCHEMA~,PACKAGE:'
,p_list_text_01=>'create-package'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2693192078823213)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Procedure'
,p_list_item_link_target=>'f?p=&APP_ID.:2040:&SESSION.::&DEBUG.:2040:P2040_PARSING_SCHEMA,P2040_OBJECT_TYPE:~PARSING_SCHEMA~,PROCEDURE:'
,p_list_text_01=>'create-procedure'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2693535147823214)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'Function'
,p_list_item_link_target=>'f?p=&APP_ID.:2040:&SESSION.::&DEBUG.:2040:P2040_PARSING_SCHEMA,P2040_OBJECT_TYPE:~PARSING_SCHEMA~,FUNCTION:'
,p_list_text_01=>'create-function'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2693993448823214)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>'Trigger'
,p_list_item_link_target=>'f?p=&APP_ID.:2055:&SESSION.::&DEBUG.:2055:P2055_PARSING_SCHEMA:~PARSING_SCHEMA~:'
,p_list_text_01=>'create-trigger'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2694329810823214)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'Database Link'
,p_list_item_link_target=>'f?p=&APP_ID.:2070:&SESSION.::&DEBUG.:2070:P2070_PARSING_SCHEMA:~PARSING_SCHEMA~:'
,p_list_item_disp_cond_type=>'EXPRESSION'
,p_list_item_disp_condition=>'not wwv_flow_global.g_cloud'
,p_list_item_disp_condition2=>'PLSQL'
,p_list_text_01=>'create-database-link'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2694714530823214)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>'Materialized View'
,p_list_item_link_target=>'f?p=&APP_ID.:2060:&SESSION.::&DEBUG.:2060:P2060_PARSING_SCHEMA:~PARSING_SCHEMA~:'
,p_list_text_01=>'create-materialized-view'
,p_required_patch=>wwv_flow_imp.id(1080926199001296276)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2695150394823215)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>'Synonym'
,p_list_item_link_target=>'f?p=&APP_ID.:2010:&SESSION.::&DEBUG.:2010:P2010_PARSING_SCHEMA:~PARSING_SCHEMA~:'
,p_list_text_01=>'create-synonym'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2695514336823215)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>'SODA Collection'
,p_list_item_link_target=>'f?p=&APP_ID.:3150:&SESSION.::&DEBUG.:3150,3151:P3150_PARSING_SCHEMA,P3150_OB_FLAG:~PARSING_SCHEMA~,Y:'
,p_list_text_01=>'create-soda-collection'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2695974354823215)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>'MLE Environment'
,p_list_item_link_target=>'f?p=&APP_ID.:5005:&SESSION.::&DEBUG.:5005:P5005_PARSING_SCHEMA:~PARSING_SCHEMA~:'
,p_list_item_disp_cond_type=>'EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_db_version.c_has_mle_with_modules'
,p_list_item_disp_condition2=>'PLSQL'
,p_list_text_01=>'create-mle-environment'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2696327021823215)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>'MLE Module - JavaScript'
,p_list_item_link_target=>'f?p=&APP_ID.:5015:&SESSION.::&DEBUG.:5015:P5015_PARSING_SCHEMA:~PARSING_SCHEMA~:'
,p_list_item_disp_cond_type=>'EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_db_version.c_has_mle_with_modules'
,p_list_item_disp_condition2=>'PLSQL'
,p_list_text_01=>'create-mle-module'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/dg_bp_table_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(2800695231074419)
,p_name=>'DG_BP_TABLE_TASKS'
,p_list_status=>'PUBLIC'
,p_version_scn=>75558089
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2801229597074438)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'View Data Sources'
,p_list_item_link_target=>'f?p=&APP_ID.:4015:&SESSION.::&DEBUG.::P4015_BLUEPRINT_ID,P4015_BLUEPRINT_NAME:&P4001_BLUEPRINT_ID.,&P4001_BLUEPRINT_NAME.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/dg_bp_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(3001483965708067)
,p_name=>'DG_BP_TASKS'
,p_list_status=>'PUBLIC'
,p_version_scn=>75558089
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(3001622697708068)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'View Built Ins'
,p_list_item_link_target=>'f?p=&APP_ID.:4011:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/qb_query_quick_results_pg_111
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(3531801850564253)
,p_name=>'QB Query Quick Results (pg 111)'
,p_list_status=>'PUBLIC'
,p_version_scn=>75558089
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(3532824014570648)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'SQL'
,p_list_item_link_target=>'#'
,p_list_text_01=>'id="sql_tab" onclick="html_TabClick(this,''QuerySQL'');return false;"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/dg_bp_create_wizard
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(7502006538093520)
,p_name=>'DG_BP_CREATE_WIZARD'
,p_list_status=>'PUBLIC'
,p_version_scn=>75558089
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(7503005490093539)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>'Use Existing Tables'
,p_list_item_link_target=>'f?p=&APP_ID.:4020:&SESSION.::&DEBUG.:4020:::'
,p_list_item_icon=>'gi-icon-create-app-websheet '
,p_list_text_01=>'Select existing tables from your schema to quickly build a blueprint that allow fast inserts of generated data into them.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(7502239389093537)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'From Scratch'
,p_list_item_link_target=>'f?p=&APP_ID.:4007:&SESSION.::&DEBUG.:4007:::'
,p_list_item_icon=>'gi-icon-app-builder-create-app'
,p_list_text_01=>'Create a new blueprint from scratch, based on a sample table with provided columns that allows you to quickly generate sample data.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(7502691410093539)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>'Import JSON File'
,p_list_item_link_target=>'f?p=&APP_ID.:4010:&SESSION.::&DEBUG.:4010:::'
,p_list_item_icon=>'gi-icon-app-builder-import-app'
,p_list_text_01=>'Upload a valid blueprint from a JSON file, or copy paste your JSON data with the required fields.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/p4100_menu
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(8537282234307541)
,p_name=>'P4100_MENU'
,p_list_status=>'PUBLIC'
,p_version_scn=>75558089
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(8537863224307545)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Export Blueprint'
,p_list_item_link_target=>'f?p=&APP_ID.:4009:&SESSION.::&DEBUG.:4009:P4009_BLUEPRINT_NAME,P4009_BLUEPRINT_ID:&P4100_BLUEPRINT_NAME.,&P4100_BLUEPRINT_ID.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(8539572238319250)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(8537421724307543)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Delete Blueprint'
,p_list_item_link_target=>'f?p=&APP_ID.:4015:&SESSION.::&DEBUG.:4015:P4015_BLUEPRINT_ID,P4015_BLUEPRINT_NAME:&P4100_BLUEPRINT_ID.,&P4100_BLUEPRINT_NAME.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/quicksql_actions
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(8612181654398721)
,p_name=>'QuickSQL Actions'
,p_list_status=>'PUBLIC'
,p_version_scn=>75558089
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(8612394212398723)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Load'
,p_list_item_link_target=>'f?p=&APP_ID.:1103:&APP_SESSION.::&DEBUG.:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(8614643735404527)
,p_list_item_display_sequence=>11
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(8612792255398725)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Save Model'
,p_list_item_link_target=>'f?p=&APP_ID.:1105:&SESSION.::&DEBUG.:1105:::'
,p_list_text_01=>'saveModel'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2049250879798103)
,p_list_item_display_sequence=>25
,p_list_item_link_text=>'Update Model'
,p_list_item_link_target=>'f?p=&APP_ID.:1105:&SESSION.::&DEBUG.:1105:::'
,p_list_text_01=>'updateModel'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(8613138533398725)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Save Model As'
,p_list_item_link_target=>'f?p=&APP_ID.:1105:&SESSION.:SAVE_AS:&DEBUG.::::'
,p_list_text_01=>'saveModelAs'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(8614988779404528)
,p_list_item_display_sequence=>32
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2216410897200565)
,p_list_item_display_sequence=>51
,p_list_item_link_text=>'Reset'
,p_list_item_link_target=>'javascript:apex.page.submit(''RESET'');'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2218861666262225)
,p_list_item_display_sequence=>51
,p_list_item_link_text=>'Reset'
,p_list_item_link_target=>'javascript:apex.event.trigger(document, ''clear'');'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(8617042317437219)
,p_list_item_display_sequence=>59
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(8613586112398725)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Properties'
,p_list_item_link_target=>'f?p=&APP_ID.:1108:&SESSION.::&DEBUG.::::'
,p_list_text_01=>'properties'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/sql_script_actions
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(8839831299543497)
,p_name=>'SQL Script Actions'
,p_list_status=>'PUBLIC'
,p_version_scn=>75558091
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(8840805178543498)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Save SQL Script'
,p_list_item_link_target=>'f?p=&APP_ID.:1104:&SESSION.::&DEBUG.::::'
,p_list_text_01=>'saveScript'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(8841666360543498)
,p_list_item_display_sequence=>32
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(8842008580543498)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Download'
,p_list_item_link_target=>'javascript:QuickSQL.download();'
,p_list_text_01=>'download'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/table_reports
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(11239830706238313)
,p_name=>'Table Reports'
,p_list_status=>'PUBLIC'
,p_version_scn=>75558093
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11129306899761893)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Table Columns'
,p_list_item_link_target=>'f?p=&APP_ID.:1047:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11252702534296443)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Table Comments'
,p_list_item_link_target=>'f?p=&APP_ID.:701:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11253122273302192)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Table Constraints'
,p_list_item_link_target=>'f?p=&APP_ID.:706:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11286227355445574)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Table Statistics'
,p_list_item_link_target=>'f?p=&APP_ID.:1052:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11215531943727735)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Table Storage Sizes'
,p_list_item_link_target=>'f?p=&APP_ID.:1048:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/exception_reports
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(11254208206307506)
,p_name=>'Exception Reports'
,p_list_status=>'PUBLIC'
,p_version_scn=>75558093
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11247001795267858)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>'Tables without Primary Keys'
,p_list_item_link_target=>'f?p=&APP_ID.:702:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11257003273325012)
,p_list_item_display_sequence=>2
,p_list_item_link_text=>'Tables without Indexes'
,p_list_item_link_target=>'f?p=&APP_ID.:707:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11247315993271938)
,p_list_item_display_sequence=>3
,p_list_item_link_text=>'Unindexed Foreign Keys'
,p_list_item_link_target=>'f?p=&APP_ID.:704:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(69176903649450759)
,p_list_item_display_sequence=>4
,p_list_item_link_text=>'Tables without Triggers'
,p_list_item_link_target=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/security_reports
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(11271128516379623)
,p_name=>'Security Reports'
,p_list_status=>'PUBLIC'
,p_version_scn=>75558093
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11122717588736506)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Object Grants'
,p_list_item_link_target=>'f?p=&APP_ID.:1401:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_security.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(8953808698289635)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>'Column Privileges'
,p_list_item_link_target=>'f?p=&APP_ID.:1402:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_security.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(240016507458722563)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Role Privileges'
,p_list_item_link_target=>'f?p=&APP_ID.:1502:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_security.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(240018327890728456)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'System Privileges'
,p_list_item_link_target=>'f?p=&APP_ID.:1404:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_security.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/pl_sql_reports
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(11319530060616601)
,p_name=>'PL/SQL Reports'
,p_list_status=>'PUBLIC'
,p_version_scn=>75558093
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11134009370790923)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>'Program Unit Arguments'
,p_list_item_link_target=>'f?p=&APP_ID.:1046:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11323926167634444)
,p_list_item_display_sequence=>2
,p_list_item_link_text=>'Unit Line Counts'
,p_list_item_link_target=>'f?p=&APP_ID.:1054:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(163506601642923359)
,p_list_item_display_sequence=>3
,p_list_item_link_text=>'Search PL/SQL Source Code'
,p_list_item_link_target=>'f?p=&APP_ID.:27:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/recycle_bin
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(11401232423499912)
,p_name=>'Recycle Bin'
,p_list_status=>'PUBLIC'
,p_version_scn=>75558093
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11401613160503840)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>'Dropped Objects'
,p_list_item_link_target=>'f?p=&APP_ID.:400:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_page.png'
,p_list_item_icon_attributes=>'height="20" width="20"  alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11404101994519551)
,p_list_item_display_sequence=>4
,p_list_item_link_text=>'Purge Recycle Bin'
,p_list_item_link_target=>'f?p=&APP_ID.:403:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_process.png'
,p_list_item_icon_attributes=>'height="20" width="20"  alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/sql_developer_web_schemas
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(11631195554192189)
,p_name=>'SQL Developer Web Schemas'
,p_list_type=>'SQL_QUERY'
,p_list_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'with schema_list as (',
' select *',
'   from wwv_flow_collections',
'  where collection_name = ''SDW_SCHEMAS''',
'  order by c002, c001)',
'select null, ',
'       c001 label, ',
'       c003 target, ',
'       ''NO'' is_current_list_entry, ',
'       ''a-Icon icon-rest-services'' || case when c002 = ''Y'' then '' u-success-text'' else '' u-opacity-50'' end image, ',
'       '''' image_attrib, ',
'       null image_alt,',
'       case when c002 = ''Y'' then ''<!-- &APP_TEXT$SDW_REST_ENABLED. -->''',
'            else ''<span>&APP_TEXT$SDW_NOT_REST_ENABLED.</span>''',
'       end a01,  -- description',
'       case when c002 = ''Y'' then ''<span id="link''||rownum||''_new_window" aria-hidden="true" class="u-vh">&APP_TEXT$SDW_OPEN_NEW_WINDOW.</span>&APP_TEXT$SDW_CONNECT.''',
'       end a02,',
'       case when c002 = ''Y'' then ''aria-describedby="link''||rownum||''_new_window"''',
'       end a03',
'  from schema_list'))
,p_list_status=>'PUBLIC'
,p_version_scn=>75558093
);
end;
/
prompt --application/shared_components/navigation/lists/ob_table_subtab
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(11739111107829730)
,p_name=>'OB_TABLE_SUBTAB'
,p_list_status=>'PUBLIC'
,p_version_scn=>75558093
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11744500680874063)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Data'
,p_list_item_link_target=>'f?p=&APP_ID.:TABLE_DATA:&SESSION.:T:&DEBUG.:RP:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2101:42:46:47'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11747316180897446)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>'SQL'
,p_list_item_link_target=>'f?p=&APP_ID.:TABLE_DDL:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(243327690322706018)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>'REST'
,p_list_item_link_target=>'f?p=&APP_ID.:OBJECT_REST:&SESSION.::&DEBUG.:2111:::'
,p_security_scheme=>wwv_flow_imp.id(802775228359756685)
,p_required_patch=>wwv_flow_imp.id(256109433659228165)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(565810533598211906)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>'Sample Queries'
,p_list_item_link_target=>'f?p=&APP_ID.:OBJECT_SAMPLE_QUERIES:&SESSION.::&DEBUG.:2112:::'
,p_security_scheme=>wwv_flow_imp.id(802775228359756685)
,p_required_patch=>wwv_flow_imp.id(256109433659228165)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/ob_object_types
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(23674222199102465)
,p_name=>'OB_OBJECT_TYPES'
,p_list_status=>'PUBLIC'
,p_version_scn=>75558093
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(23674801898106075)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Tables'
,p_list_item_icon=>'table_s.gif'
,p_list_text_01=>'TABLE'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1001'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(23675208132107838)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Views'
,p_list_item_icon=>'view_s.gif'
,p_list_text_01=>'VIEW'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(23676115750110093)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Indexes'
,p_list_item_icon=>'index_s.gif'
,p_list_text_01=>'INDEX'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(23677731334114549)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Sequences'
,p_list_item_icon=>'sequence_s.gif'
,p_list_text_01=>'SEQUENCE'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(23678808609117400)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Types'
,p_list_item_icon=>'type_s.gif'
,p_list_text_01=>'TYPE'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(23676924062112497)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Packages'
,p_list_item_icon=>'package_s.gif'
,p_list_text_01=>'PACKAGE'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(23677327871113573)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Procedures'
,p_list_item_icon=>'procedure_s.gif'
,p_list_text_01=>'PROCEDURE'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(23675611595108895)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'Functions'
,p_list_item_icon=>'function_s.gif'
,p_list_text_01=>'FUNCTION'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(23678405146116460)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>'Triggers'
,p_list_item_icon=>'trigger_s.gif'
,p_list_text_01=>'TRIGGER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(23679113457118846)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'Database Links'
,p_list_item_icon=>'dblink_s.gif'
,p_list_item_disp_cond_type=>'EXPRESSION'
,p_list_item_disp_condition=>'not wwv_flow_global.g_cloud'
,p_list_item_disp_condition2=>'PLSQL'
,p_list_text_01=>'DATABASE_LINK'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(23676520945111591)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>'Materialized Views'
,p_list_item_icon=>'materialized_view_s.gif'
,p_list_text_01=>'MATERIALIZED_VIEW'
,p_required_patch=>wwv_flow_imp.id(240247031763163202)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(23678002029115528)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>'Synonyms'
,p_list_item_icon=>'synonym_s.gif'
,p_list_text_01=>'SYNONYM'
,p_required_patch=>wwv_flow_imp.id(240237502901130926)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(3310563180268546)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>'SODA Collections'
,p_list_item_icon=>'table_s.gif'
,p_list_text_01=>'SODA_COLLECTION'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1001'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1689228451536108)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>'MLE Environments'
,p_list_item_icon=>'table_s.gif'
,p_list_item_disp_cond_type=>'EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_db_version.c_has_mle_with_modules'
,p_list_item_disp_condition2=>'PLSQL'
,p_list_text_01=>'MLE_ENVIRONMENT'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1001'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1689580569541319)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>'MLE Modules - JavaScript'
,p_list_item_icon=>'table_s.gif'
,p_list_item_disp_cond_type=>'EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_db_version.c_has_mle_with_modules'
,p_list_item_disp_condition2=>'PLSQL'
,p_list_text_01=>'MLE_MODULE_JAVASCRIPT'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1001'
);
end;
/
prompt --application/shared_components/navigation/lists/ui_default_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(40650212014681045)
,p_name=>'ui default tasks'
,p_list_status=>'PUBLIC'
,p_version_scn=>75558093
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(40758212349422677)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>'Create Column Group'
,p_list_item_link_target=>'f?p=&APP_ID.:804:&SESSION.::&DEBUG.:804:P804_TABLE_ID:&P802_TABLE_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(40841914817552027)
,p_list_item_display_sequence=>4
,p_list_item_link_text=>'Manage Column Groups'
,p_list_item_link_target=>'f?p=&APP_ID.:805:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(429084627870179449)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>'Synchronize with Database'
,p_list_item_link_target=>'f?p=&APP_ID.:807:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(201476126054569515)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Migrate to Attribute Dictionary'
,p_list_item_link_target=>'f?p=&APP_ID.:33:&SESSION.::&DEBUG.::P32_SCHEMA,P33_TABLE_ID:&P800_SCHEMA.,&P802_TABLE_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(40819416727890341)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Remove from Table Dictionary'
,p_list_item_link_target=>'f?p=&APP_ID.:830:&SESSION.::&DEBUG.::P830_TABLE_ID:&P802_TABLE_ID.:'
,p_list_item_disp_cond_type=>'ITEM_IS_NOT_NULL'
,p_list_item_disp_condition=>'P802_TABLE_ID'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/table_dictionary_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(40848526002687735)
,p_name=>'table dictionary tasks'
,p_list_status=>'PUBLIC'
,p_version_scn=>75558093
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(201458325044096158)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Attribute Dictionary Migration'
,p_list_item_link_target=>'f?p=&APP_ID.:32:&SESSION.::&DEBUG.::P32_SCHEMA:&P800_SCHEMA.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(40876113946214023)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Export'
,p_list_item_link_target=>'f?p=&APP_ID.:841:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(40876316370214768)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Import'
,p_list_item_link_target=>'f?p=&APP_ID.:842:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/sql_workshop_home_list_apex_4_0
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(46900227098494683)
,p_name=>'SQL Workshop Home List - APEX 4.0'
,p_list_status=>'PUBLIC'
,p_version_scn=>75558093
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(46900407490498504)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Object Browser'
,p_list_item_link_target=>'f?p=&APP_ID.:2000:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'sql-workshop-object-browser'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(46900613377500241)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'SQL Commands'
,p_list_item_link_target=>'f?p=&APP_ID.:1003:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'sql-workshop-commands'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(46900819264501864)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'SQL Scripts'
,p_list_item_link_target=>'f?p=&APP_ID.:1004:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'apex-sql-script'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(46901026191503941)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Query Builder'
,p_list_item_link_target=>'f?p=&APP_ID.:1002:&SESSION.::&DEBUG.:1002:::'
,p_list_item_icon=>'qb'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(47583907412198107)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Utilities'
,p_list_item_link_target=>'f?p=&APP_ID.:1005:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'apex-utilities'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(325069319924256588)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'RESTful Services'
,p_list_item_link_target=>'f?p=4850:100:&SESSION.'
,p_list_item_icon=>'sql-workshop-rest'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_security_scheme=>wwv_flow_imp.id(802775228359756685)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/ddl_wizard
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(87134126220568115)
,p_name=>'DDL Wizard'
,p_list_status=>'PUBLIC'
,p_version_scn=>75558093
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(87135922338569906)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Schema'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'18'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(87136718887571537)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Object Type'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'43'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(87137516731572565)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Object Name'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'44'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(87138313496573982)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Script'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'29:45'
);
end;
/
prompt --application/shared_components/navigation/lists/4500_24_tablescolums
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(98332317887807047)
,p_name=>'4500_24_TablesColums'
,p_list_status=>'PUBLIC'
,p_version_scn=>75558093
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(98332922735808489)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Tables'
,p_list_item_link_target=>'javascript:void($d_TabClick(''tabletab'',''tablereport'',''tabcurrent'',p24Tabs))'||wwv_flow.LF||
''
,p_list_text_01=>'id="tabletab"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(98333326198809479)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'Columns'
,p_list_item_link_target=>'javascript:void($d_TabClick(''columntab'',''columnreport'',''tabcurrent'',p24Tabs))'
,p_list_item_disp_cond_type=>'ITEM_IS_NOT_NULL'
,p_list_item_disp_condition=>'P24_TABLE_NAME'
,p_list_text_01=>'id="columntab"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/database_monitor
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(133792932105421631)
,p_name=>'database monitor'
,p_list_status=>'PUBLIC'
,p_version_scn=>75558093
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(133794915960426480)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Sessions'
,p_list_item_link_target=>'f?p=&APP_ID.:540:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(173640005872718109)
,p_list_item_display_sequence=>11
,p_list_item_link_text=>'System Statistics'
,p_list_item_link_target=>'f?p=&APP_ID.:560:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(134580728113951404)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Top SQL'
,p_list_item_link_target=>'f?p=&APP_ID.:21:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(137498619860396665)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Long Operations'
,p_list_item_link_target=>'f?p=&APP_ID.:34:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/create_package_progress
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(149957726913651895)
,p_name=>'create package progress'
,p_list_status=>'PUBLIC'
,p_version_scn=>75558093
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1080739923278204088)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Confirm'
,p_list_item_link_target=>'f?p=&APP_ID.:125:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P117_CREATE_PACKAGE'
,p_list_item_disp_condition2=>'TABLE'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/recyclebin
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(151000331198918456)
,p_name=>'recyclebin'
,p_list_status=>'PUBLIC'
,p_version_scn=>75558093
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(151001418516924257)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Purge Recycle Bin'
,p_list_item_link_target=>'f?p=&FLOW_ID.:403:&SESSION.::&DEBUG.:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/session_tabs
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(159562414490322899)
,p_name=>'session tabs'
,p_list_status=>'PUBLIC'
,p_version_scn=>75558093
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(159564908042330521)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>'Sessions'
,p_list_item_link_target=>'f?p=&APP_ID.:540:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'540'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(159565421201334330)
,p_list_item_display_sequence=>2
,p_list_item_link_text=>'Locks'
,p_list_item_link_target=>'f?p=&APP_ID.:541:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'541'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(162017426458197138)
,p_list_item_display_sequence=>2.1
,p_list_item_link_text=>'Waits'
,p_list_item_link_target=>'f?p=&APP_ID.:548:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'548'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(159588009305397176)
,p_list_item_display_sequence=>2.2
,p_list_item_link_text=>'I/O'
,p_list_item_link_target=>'f?p=&APP_ID.:545:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'545'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(159566527088336046)
,p_list_item_display_sequence=>3
,p_list_item_link_text=>'SQL'
,p_list_item_link_target=>'f?p=&APP_ID.:542:&SESSION.::&DEBUG.::::'
,p_list_item_current_for_pages=>'542'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(159567803324338684)
,p_list_item_display_sequence=>4
,p_list_item_link_text=>'Open Cursors'
,p_list_item_link_target=>'f?p=&APP_ID.:543:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'543,546'
);
end;
/
prompt --application/shared_components/navigation/lists/script_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(163470423703447178)
,p_name=>'Script Tasks'
,p_list_status=>'PUBLIC'
,p_version_scn=>75558093
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(164091703714775079)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>'Manage Results'
,p_list_item_link_target=>'f?p=&APP_ID.:1220:&SESSION.::&DEBUG.:1220:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(150027319743782244)
,p_list_item_display_sequence=>2
,p_list_item_link_text=>'Show Quotas'
,p_list_item_link_target=>'f?p=&APP_ID.:31:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(221300505462590355)
,p_list_item_display_sequence=>3
,p_list_item_link_text=>'Export'
,p_list_item_link_target=>'f?p=&APP_ID.:65:&SESSION.::&DEBUG.:SCRIPTS_TO_EXPORT:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(221300908233591110)
,p_list_item_display_sequence=>4
,p_list_item_link_text=>'Import'
,p_list_item_link_target=>'f?p=&APP_ID.:112:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/utilities_line_1
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(169562905299954428)
,p_name=>'Utilities line 1'
,p_list_status=>'PUBLIC'
,p_version_scn=>80135989
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(169563123101954428)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Data Workshop'
,p_list_item_link_target=>'f?p=4300:1:&SESSION.'
,p_list_item_icon=>'icon-utilities-data-workshop'
,p_list_text_01=>'Load and unload data using CSV, XLSX, XML or JSON files.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1680531624716286)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>'Data Generator'
,p_list_item_link_target=>'f?p=&APP_ID.:4000:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-utilities-generate-ddl'
,p_list_text_01=>'Create blueprints to populate tables with randomly generated data.'
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_imp.id(1753335990774646)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(686840721222033340)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Query Builder'
,p_list_item_link_target=>'f?p=&APP_ID.:1002:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-utilities-query-builder'
,p_list_text_01=>'Build queries graphically by adding tables into a panel, and selecting columns to return.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(713107322646978455)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Quick SQL'
,p_list_item_link_target=>'f?p=&APP_ID.:1100:&SESSION.::&DEBUG.:RP,1100:::'
,p_list_item_icon=>'a-Icon icon-utilities-query-builder'
,p_list_text_01=>'Generate SQL using shorthand syntax'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(165295291982048923)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Sample Datasets'
,p_list_item_link_target=>'f?p=4300:100:&SESSION.'
,p_list_item_icon=>'icon-sc-files'
,p_list_text_01=>'Install, refresh, or remove sample datasets.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(621480553521527744)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Generate DDL'
,p_list_item_link_target=>'f?p=&APP_ID.:12:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-utilities-generate-ddl'
,p_list_text_01=>'Generate scripts for all or selected database objects within a schema.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(169564017816954429)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'UI Defaults'
,p_list_item_link_target=>'f?p=&APP_ID.:813:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-db-ui-defaults'
,p_list_text_01=>'UI Defaults allow AI interactions to understand the contents of your tables and populate initial labels for forms and reports.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(862293371954895810)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Schema Comparison'
,p_list_item_link_target=>'f?p=&APP_ID.:1350:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-utilites-schema-comparison'
,p_list_text_01=>'Show differences between database objects in two different schemas.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1463338733490347)
,p_list_item_display_sequence=>75
,p_list_item_link_text=>'Data Dictionary Cache'
,p_list_item_link_target=>'f?p=4350:800:&SESSION.::&DEBUG.:800:::'
,p_list_item_icon=>'icon-database-object'
,p_list_text_01=>'View and refresh cached statistics and data analysis of workspace schema tables.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(169563411461954429)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'Methods on Tables'
,p_list_item_link_target=>'f?p=&APP_ID.:120:&SESSION.::&DEBUG.:124,125:::'
,p_list_item_icon=>'icon-utilities-methods-tables'
,p_list_text_01=>'Generate API scripts for DML operations on specified tables.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(862292771917895809)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>'Recycle Bin'
,p_list_item_link_target=>'f?p=&APP_ID.:1070:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-utilites-recycle-bin'
,p_list_text_01=>'Restore database objects that have been dropped.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1379793096144889954)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'Object Reports'
,p_list_item_link_target=>'f?p=&APP_ID.:1042:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-utilities-object-reports'
,p_list_text_01=>'Access numerous reports on tables, exceptions, security, objects and PL/SQL code.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(862293694522895810)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>'About Database'
,p_list_item_link_target=>'f?p=&APP_ID.:36:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-utilities-about-database'
,p_list_item_disp_cond_type=>'EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''ALLOW_DB_MONITOR'') = ''Y'''
,p_list_item_disp_condition2=>'PLSQL'
,p_list_text_01=>'Review database details. Note: A Database account granted the DBA role is required.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1144637580332327672)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>'Database Monitor'
,p_list_item_link_target=>'f?p=&APP_ID.:11:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-utilities-database-monitor'
,p_list_item_disp_cond_type=>'EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''ALLOW_DB_MONITOR'') = ''Y'''
,p_list_item_disp_condition2=>'PLSQL'
,p_list_text_01=>'Run database activity reports. Note: A Database account granted the DBA role is required.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(7203034990594913)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>'Create Data Model Using AI'
,p_list_item_link_target=>'f?p=&APP_ID.:1600:&SESSION.::&DEBUG.:1600:::'
,p_list_item_icon=>'icon-utilities-apex-assistant'
,p_list_item_disp_cond_type=>'EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_ai_api.is_enabled'
,p_list_item_disp_condition2=>'PLSQL'
,p_list_text_01=>'Enter a natural language prompt to generate your data model.'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/sql_workshop_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(170601318269466378)
,p_name=>'sql workshop navigation'
,p_list_status=>'PUBLIC'
,p_version_scn=>75558095
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(170601819280466388)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'SQL Commands'
,p_list_item_link_target=>'f?p=&APP_ID.:1003:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/sqlcmd.gif'
,p_list_text_01=>'commandLine'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(170602114146466388)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'SQL Scripts'
,p_list_item_link_target=>'f?p=&APP_ID.:1004:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/sqlscrpt.gif'
,p_list_text_01=>'file'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(170602413280466389)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Query Builder'
,p_list_item_link_target=>'f?p=&APP_ID.:1002:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/qbuilder.gif'
,p_list_text_01=>'queryBuilder'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(170628208161633707)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Utilities'
,p_list_item_link_target=>'f?p=&APP_ID.:1005:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/shared_comp_small.gif'
,p_list_text_01=>'utilities'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(872825001018813755)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'RESTful Services'
,p_list_item_link_target=>'f?p=4850:1:&SESSION.'
,p_list_item_icon=>'htmldb/icons/dbservice.png'
,p_list_text_01=>'restfulServices'
,p_security_scheme=>wwv_flow_imp.id(802775228359756685)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/ui_defaults_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(194504915759237345)
,p_name=>'UI Defaults Navigation'
,p_list_status=>'PUBLIC'
,p_version_scn=>75558096
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(421011030860726171)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Dashboard'
,p_list_item_link_target=>'f?p=&APP_ID.:813:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'813'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(194505202972237349)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Table Dictionary'
,p_list_item_link_target=>'f?p=&APP_ID.:800:&SESSION.::&DEBUG.::P800_SCHEMA:&P813_SCHEMA.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'800'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(194505603010237353)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Attribute Dictionary'
,p_list_item_link_target=>'f?p=&APP_ID.:6:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'6:17'
);
end;
/
prompt --application/shared_components/navigation/lists/all_object_reports
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(276235426866859669)
,p_name=>'All Object Reports'
,p_list_status=>'PUBLIC'
,p_version_scn=>75558096
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(276237431846870512)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>'All Objects'
,p_list_item_link_target=>'f?p=&APP_ID.:500:&SESSION.::&DEBUG.:500:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(276237707735873072)
,p_list_item_display_sequence=>2
,p_list_item_link_text=>'Invalid Objects'
,p_list_item_link_target=>'f?p=&APP_ID.:1040:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(276238015700875357)
,p_list_item_display_sequence=>3
,p_list_item_link_text=>'Object Creation Calendar'
,p_list_item_link_target=>'f?p=&APP_ID.:1055:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_session.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(276238320549876791)
,p_list_item_display_sequence=>4
,p_list_item_link_text=>'Object Counts by Type'
,p_list_item_link_target=>'f?p=&APP_ID.:1059:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(65214035632967721)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Data Dictionary'
,p_list_item_link_target=>'f?p=&APP_ID.:13:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_disp_cond_type=>'EXPRESSION'
,p_list_item_disp_condition=>'not wwv_flow_global.g_cloud'
,p_list_item_disp_condition2=>'PLSQL'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/attribute_dictionary_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(442022106915434689)
,p_name=>'attribute dictionary tasks'
,p_list_status=>'PUBLIC'
,p_version_scn=>75558096
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(442022828528434694)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Export'
,p_list_item_link_target=>'f?p=&APP_ID.:39:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(442023208094434695)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Import'
,p_list_item_link_target=>'f?p=&APP_ID.:41:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_administration_header
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(697546799309390664)
,p_name=>'APEX 5 - Administration (Header)'
,p_list_status=>'PUBLIC'
,p_version_scn=>75558096
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697546976894390664)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Administration'
,p_list_item_link_target=>'f?p=4350:1:&APP_SESSION.'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697547235161390665)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'------'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697547501968390665)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Manage Service'
,p_security_scheme=>wwv_flow_imp.id(12520119493499631)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697547855490390665)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'Manage Service'
,p_list_item_link_target=>'f?p=4350:21:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(697547501968390665)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697548157703390665)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>'------'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_imp.id(697547501968390665)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(322769288632400743)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'Make a Service Request'
,p_list_item_link_target=>'f?p=4350:96:&SESSION.::NO:49::'
,p_list_item_disp_cond_type=>'EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''SERVICE_REQUESTS_ENABLED'') = ''Y'''
,p_list_item_disp_condition2=>'PLSQL'
,p_parent_list_item_id=>wwv_flow_imp.id(697547501968390665)
,p_security_scheme=>wwv_flow_imp.id(12520119493499631)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697548721548390666)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>'Set Workspace Preferences'
,p_list_item_link_target=>'f?p=4350:17:&SESSION.::NO:RP::'
,p_parent_list_item_id=>wwv_flow_imp.id(697547501968390665)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697549084529390666)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>'Define Workspace Message'
,p_list_item_link_target=>'f?p=4350:35:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(697547501968390665)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(180642720025555459)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>'Define Environment Banner'
,p_list_item_link_target=>'f?p=4350:105:&SESSION.:::105:P105_LAST_APP_ID,P105_LAST_PAGE_ID:&APP_ID.,&APP_PAGE_ID.'
,p_parent_list_item_id=>wwv_flow_imp.id(697547501968390665)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697549313943390666)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>'Workspace Utilization'
,p_list_item_link_target=>'f?p=4350:101:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(697547501968390665)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2400223137184492)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>'Manage Extension Links'
,p_list_item_link_target=>'f?p=4350:110:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(697547501968390665)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697549654493390666)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Manage Users and Groups'
,p_list_item_link_target=>'f?p=4350:55:&SESSION.'
,p_security_scheme=>wwv_flow_imp.id(12520119493499631)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697549971815390666)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Monitor Activity'
,p_list_item_link_target=>'f?p=4350:22:&SESSION.'
,p_security_scheme=>wwv_flow_imp.id(10590808779171805)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697550297696390667)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Dashboards'
,p_list_item_link_target=>'f?p=4350:33:&SESSION.'
,p_security_scheme=>wwv_flow_imp.id(10590808779171805)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1250750521916198591)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Change My Password'
,p_list_item_link_target=>'f?p=4350:3:&SESSION.::&DEBUG.:3#pwd'
,p_list_item_disp_cond_type=>'EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_authentication_dev.can_edit_builder_users'
,p_list_item_disp_condition2=>'PLSQL'
,p_security_scheme=>wwv_flow_imp.id(10590808779171805)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_help
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(697551745129395610)
,p_name=>'APEX 5 - Help'
,p_list_status=>'PUBLIC'
,p_version_scn=>75558097
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697551976020395610)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Documentation'
,p_list_item_link_target=>'&SYSTEM_HELP_URL.'
,p_list_text_01=>'helpLinkDocLib'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2105955016147042297)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Discussion Forum'
,p_list_item_link_target=>'https://apex.oracle.com/forum'
,p_list_text_01=>'helpLinkForum'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2185349560170378007)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Learn More about Oracle APEX'
,p_list_item_link_target=>'https://apex.oracle.com'
,p_list_text_01=>'helpLinkOTN'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697552813369395610)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697553124884395611)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'About'
,p_list_item_link_target=>'f?p=4350:9:&SESSION.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_shared_navigation_menu
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(718942723406995455)
,p_name=>'APEX Shared Navigation Menu'
,p_list_status=>'PUBLIC'
,p_reference_id=>2206460728364447
,p_version_scn=>117449631
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2281176336227509)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'App Builder'
,p_list_item_link_target=>'f?p=4000:1500:&SESSION.::&DEBUG.::::'
,p_list_item_icon_alt_attribute=>'App Builder Drill Down'
,p_list_text_01=>'tab-app-builder'
,p_security_scheme=>wwv_flow_imp.id(178922732459641711)
,p_list_item_current_type=>'EXPRESSION'
,p_list_item_current_for_pages=>':APP_ID in ( 4000, 4020 )'
,p_list_item_current_language=>'PLSQL'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2281529366227509)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Create'
,p_list_item_link_target=>'f?p=4000:56:&SESSION.::&DEBUG.:56,103,104,106,130,131,35,227,3020,3000,3001:FB_FLOW_ID,FB_FLOW_PAGE_ID::'
,p_parent_list_item_id=>wwv_flow_imp.id(2281176336227509)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2281966107227510)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Import'
,p_list_item_link_target=>'f?p=4000:460:&SESSION.::&DEBUG.:460:P460_FILE_TYPE:FLOW_EXPORT:'
,p_parent_list_item_id=>wwv_flow_imp.id(2281176336227509)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2282317893227510)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Export'
,p_list_item_link_target=>'f?p=4000:4900:&SESSION.::&DEBUG.:4900:FB_FLOW_ID,FB_FLOW_PAGE_ID::'
,p_parent_list_item_id=>wwv_flow_imp.id(2281176336227509)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2282742991227510)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_imp.id(2281176336227509)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2283179858227510)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>'Workspace Utilities'
,p_parent_list_item_id=>wwv_flow_imp.id(2281176336227509)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2283552474227510)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'All Workspace Utilities'
,p_list_item_link_target=>'f?p=4000:182:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_imp.id(2283179858227510)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2283976448227510)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_imp.id(2283179858227510)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2284381095227510)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>'Workspace Themes'
,p_list_item_link_target=>'f?p=4000:763:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_imp.id(2283179858227510)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2284708593227510)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>'Application Groups'
,p_list_item_link_target=>'f?p=4000:722:&SESSION.::&DEBUG.:RP'
,p_parent_list_item_id=>wwv_flow_imp.id(2283179858227510)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2285188419227510)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>'&PRODUCT_NAME. Views'
,p_list_item_link_target=>'f?p=4000:714:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_imp.id(2283179858227510)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2285510701227511)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>'Cross Application Reports'
,p_list_item_link_target=>'f?p=4000:9009:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_imp.id(2283179858227510)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2285973276227511)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'SQL Workshop'
,p_list_item_link_target=>'f?p=4500:3002:&SESSION.'
,p_list_item_icon_alt_attribute=>'SQL Workshop Drill Down'
,p_list_text_01=>'tab-sql-workshop'
,p_security_scheme=>wwv_flow_imp.id(178925305824656679)
,p_list_item_current_type=>'EXPRESSION'
,p_list_item_current_for_pages=>'( :APP_ID = 4500 and :APP_PAGE_ID not in ( ''1000'',''8000'',''35'', ''900'' ) ) or :APP_ID in ( 4850, 4300 )'
,p_list_item_current_language=>'PLSQL'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2286391488227511)
,p_list_item_display_sequence=>160
,p_list_item_link_text=>'Object Browser'
,p_list_item_link_target=>'f?p=4500:2000:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(2285973276227511)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2286757633227511)
,p_list_item_display_sequence=>170
,p_list_item_link_text=>'SQL Commands'
,p_list_item_link_target=>'f?p=4500:1003:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(2285973276227511)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2287148099227511)
,p_list_item_display_sequence=>180
,p_list_item_link_text=>'SQL Scripts'
,p_list_item_link_target=>'f?p=4500:1004:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(2285973276227511)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2287543490227511)
,p_list_item_display_sequence=>190
,p_list_item_link_text=>'Utilities'
,p_parent_list_item_id=>wwv_flow_imp.id(2285973276227511)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2287911448227511)
,p_list_item_display_sequence=>220
,p_list_item_link_text=>'All Utilities'
,p_list_item_link_target=>'f?p=4500:1005:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(2287543490227511)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2288356609227511)
,p_list_item_display_sequence=>230
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_imp.id(2287543490227511)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2288757841227512)
,p_list_item_display_sequence=>240
,p_list_item_link_text=>'Data Workshop'
,p_list_item_link_target=>'f?p=4300:1:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(2287543490227511)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2289158337227512)
,p_list_item_display_sequence=>250
,p_list_item_link_text=>'Data Generator'
,p_list_item_link_target=>'f?p=4500:4000:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(2287543490227511)
,p_security_scheme=>wwv_flow_imp.id(1753335990774646)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2289538381227512)
,p_list_item_display_sequence=>260
,p_list_item_link_text=>'Query Builder'
,p_list_item_link_target=>'f?p=4500:1002:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(2287543490227511)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2289995332227512)
,p_list_item_display_sequence=>270
,p_list_item_link_text=>'Quick SQL'
,p_list_item_link_target=>'f?p=4500:1100:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(2287543490227511)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2290370922227512)
,p_list_item_display_sequence=>280
,p_list_item_link_text=>'Sample Datasets'
,p_list_item_link_target=>'f?p=4300:100:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(2287543490227511)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2290775826227512)
,p_list_item_display_sequence=>290
,p_list_item_link_text=>'Generate DDL'
,p_list_item_link_target=>'f?p=4500:12:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(2287543490227511)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2291100604227512)
,p_list_item_display_sequence=>300
,p_list_item_link_text=>'UI Defaults'
,p_list_item_link_target=>'f?p=4500:813:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(2287543490227511)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2291590562227512)
,p_list_item_display_sequence=>310
,p_list_item_link_text=>'Schema Comparison'
,p_list_item_link_target=>'f?p=4500:1350:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(2287543490227511)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2291927493227512)
,p_list_item_display_sequence=>320
,p_list_item_link_text=>'Methods on Tables'
,p_list_item_link_target=>'f?p=4500:120:&SESSION.:'
,p_parent_list_item_id=>wwv_flow_imp.id(2287543490227511)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2292358796227513)
,p_list_item_display_sequence=>330
,p_list_item_link_text=>'Recycle Bin'
,p_list_item_link_target=>'f?p=4500:1070:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(2287543490227511)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2292743506227513)
,p_list_item_display_sequence=>340
,p_list_item_link_text=>'Object Reports'
,p_list_item_link_target=>'f?p=4500:1042:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(2287543490227511)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2293184926227513)
,p_list_item_display_sequence=>350
,p_list_item_link_text=>'About Database'
,p_list_item_link_target=>'f?p=4500:36:&SESSION.'
,p_list_item_disp_cond_type=>'EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''ALLOW_DB_MONITOR'') = ''Y'''
,p_list_item_disp_condition2=>'PLSQL'
,p_parent_list_item_id=>wwv_flow_imp.id(2287543490227511)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2293504983227513)
,p_list_item_display_sequence=>360
,p_list_item_link_text=>'Database Monitor'
,p_list_item_link_target=>'f?p=4500:11:&SESSION.'
,p_list_item_disp_cond_type=>'EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''ALLOW_DB_MONITOR'') = ''Y'''
,p_list_item_disp_condition2=>'PLSQL'
,p_parent_list_item_id=>wwv_flow_imp.id(2287543490227511)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2293911352227513)
,p_list_item_display_sequence=>200
,p_list_item_link_text=>'RESTful Services'
,p_list_item_link_target=>'f?p=4850:100:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(2285973276227511)
,p_security_scheme=>wwv_flow_imp.id(802775228359756685)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2294323788227513)
,p_list_item_display_sequence=>210
,p_list_item_link_text=>'SQL Developer Web'
,p_list_item_link_target=>'f?p=4500:64:&SESSION.::&DEBUG.:64:::'
,p_parent_list_item_id=>wwv_flow_imp.id(2285973276227511)
,p_security_scheme=>wwv_flow_imp.id(11403377390021811)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2294744941227513)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Team Development'
,p_list_item_link_target=>'f?p=4600:1:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon_alt_attribute=>'Team Development Drill Down'
,p_list_text_01=>'tab-team-dev'
,p_security_scheme=>wwv_flow_imp.id(173297929258927869)
,p_list_item_current_type=>'EXPRESSION'
,p_list_item_current_for_pages=>':APP_ID in ( 4600, 4650 )'
,p_list_item_current_language=>'PLSQL'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2295108913227513)
,p_list_item_display_sequence=>370
,p_list_item_link_text=>'Labels'
,p_list_item_link_target=>'f?p=4600:300:&SESSION.::&DEBUG.:RP:::'
,p_parent_list_item_id=>wwv_flow_imp.id(2294744941227513)
,p_security_scheme=>wwv_flow_imp.id(12506407035221692)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2295561187227514)
,p_list_item_display_sequence=>380
,p_list_item_link_text=>'Milestones'
,p_list_item_link_target=>'f?p=4600:200:&SESSION.::&DEBUG.:RP:::'
,p_parent_list_item_id=>wwv_flow_imp.id(2294744941227513)
,p_security_scheme=>wwv_flow_imp.id(12506407035221692)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2295918887227514)
,p_list_item_display_sequence=>390
,p_list_item_link_text=>'Templates'
,p_list_item_link_target=>'f?p=4600:1000:&SESSION.::&DEBUG.:RP:::'
,p_parent_list_item_id=>wwv_flow_imp.id(2294744941227513)
,p_security_scheme=>wwv_flow_imp.id(12506407035221692)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2296375043227514)
,p_list_item_display_sequence=>400
,p_list_item_link_text=>'Utilities'
,p_list_item_link_target=>'f?p=4600:2000:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_imp.id(2294744941227513)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2296743536227514)
,p_list_item_display_sequence=>410
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_imp.id(2294744941227513)
,p_security_scheme=>wwv_flow_imp.id(12506407035221692)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2297148070227514)
,p_list_item_display_sequence=>420
,p_list_item_link_text=>'Feedback'
,p_list_item_link_target=>'f?p=4650:8012:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_imp.id(2294744941227513)
,p_security_scheme=>wwv_flow_imp.id(12506407035221692)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2297500359227514)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Gallery'
,p_list_item_link_target=>'f?p=4750:50:&SESSION.'
,p_list_text_01=>'tab-apps'
,p_security_scheme=>wwv_flow_imp.id(12506407035221692)
,p_list_item_current_type=>'EXPRESSION'
,p_list_item_current_for_pages=>':APP_ID = 4750'
,p_list_item_current_language=>'PLSQL'
);
end;
/
prompt --application/shared_components/navigation/listentry
begin
null;
end;
/
prompt --application/plugin_settings
begin
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(940455082467897)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_STAR_RATING'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'default_icon', 'fa-star',
  'tooltip', '#VALUE#')).to_clob
,p_version_scn=>7007818
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(1302660976451618)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_SELECT_MANY'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'display_values_as', 'separated')).to_clob
,p_version_scn=>7007816
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(1308824809778855)
,p_plugin_type=>'DYNAMIC ACTION'
,p_plugin=>'NATIVE_OPEN_AI_ASSISTANT'
,p_version_scn=>16259796
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(1333306021185226)
,p_plugin_type=>'WEB SOURCE TYPE'
,p_plugin=>'NATIVE_BOSS'
,p_version_scn=>243439799
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(3221592352137505)
,p_plugin_type=>'PROCESS TYPE'
,p_plugin=>'NATIVE_GEOCODING'
,p_attribute_01=>'RELAX_HOUSE_NUMBER'
,p_version_scn=>117643320
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(14848715049940930)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_YES_NO'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'display_style', 'SWITCH_CB',
  'off_value', 'N',
  'on_value', 'Y')).to_clob
,p_version_scn=>6539585
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(99821386660888928)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_GEOCODED_ADDRESS'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'background', 'default',
  'display_as', 'LIST',
  'map_preview', 'POPUP:ITEM',
  'match_mode', 'RELAX_HOUSE_NUMBER',
  'show_coordinates', 'N')).to_clob
,p_version_scn=>7021930
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(118451017525833014)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_MAP_REGION'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'use_vector_tile_layers', 'Y')).to_clob
,p_version_scn=>1088662546
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(123182641277478451)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_DATE_PICKER_APEX'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'appearance_behavior', 'MONTH-PICKER:YEAR-PICKER',
  'days_outside_month', 'VISIBLE',
  'show_on', 'FOCUS',
  'time_increment', '15')).to_clob
,p_version_scn=>7007821
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(124362361029989292)
,p_plugin_type=>'WEB SOURCE TYPE'
,p_plugin=>'NATIVE_ADFBC'
,p_version_scn=>37165931336888
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(176118118407506807)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_SINGLE_CHECKBOX'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'checked_value', 'Y',
  'unchecked_value', 'N')).to_clob
,p_version_scn=>7007823
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(1272782587538879395)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_COM.ORACLE.APEX.SPLITTER'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'attribute_01', 'Y')).to_clob
,p_reference_id=>174677809582024970
,p_version_scn=>37165931336884
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(1765072762112712055)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_DISPLAY_SELECTOR'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'include_slider', 'N')).to_clob
,p_version_scn=>1088662546
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(1831722742580993878)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_IR'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'actions_menu_structure', 'IG')).to_clob
,p_version_scn=>1088662546
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(1917693824782940193)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_COLOR_PICKER'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'display_as', 'POPUP',
  'mode', 'FULL')).to_clob
,p_version_scn=>7007824
);
end;
/
prompt --application/shared_components/security/authorizations/flow_data_generator
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(1753335990774646)
,p_name=>'Flow: DATA_GENERATOR'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'DATA_GENERATOR'
,p_error_message=>'You are not authorized to use Data Generator in SQL Workshop'
,p_reference_id=>2200672316280271
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/extension_links_exist
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(4200240113971948)
,p_name=>'Extension Links Exist'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from wwv_extension_links',
' where security_group_id = :workspace_id',
'union all',
'select 1',
'  from wwv_extension_links el, wwv_extension_grants eg, wwv_flow_companies cp',
' where eg.security_group_id           = :workspace_id',
'   and eg.extension_security_group_id = el.security_group_id',
'   and el.is_public                   = ''Y''',
'   and el.security_group_id           = cp.provisioning_company_id',
'   and cp.is_extension_yn in (''Y'', ''A'')'))
,p_reference_id=>2801004939760399
,p_version_scn=>87913674
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/quicksql_ords_allowed
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(4806801565557841)
,p_name=>'QUICKSQL_ORDS_ALLOWED'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_qs_dev.is_minimum_version ',
'  and wwv_flow_authorization.is_authorized_developer(',
'    p_developer_authorization => ''EDIT'' );'))
,p_error_message=>'QuickSQL is not available. This is likely due to an insufficient version of ORDS. Minimum ORDS version required is 23.3.'
,p_version_scn=>75558103
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_sql_and_not_cloudy
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(7676404413799609)
,p_name=>'Flow: SQL and not cloudy'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_authorization.is_authorized_developer (',
'           p_developer_authorization => ''SQL'' ) ',
'       and not wwv_flow_global.g_cloud;',
''))
,p_error_message=>'This feature is not available.'
,p_reference_id=>786930698123107979
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/dashboard_access
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(10590808779171805)
,p_name=>'Dashboard access'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return',
'    wwv_flow_authorization.is_authorized_developer(',
'        p_developer_authorization => ''ADMIN''',
'    )',
'    or wwv_flow_authorization.is_authorized_developer(',
'        p_developer_authorization => ''EDIT''',
'    );'))
,p_error_message=>'You are not authorized to access Dashboards and Monitor Activity.'
,p_reference_id=>786936829326142579
,p_caching=>'BY_USER_BY_SESSION'
,p_comments=>'Used to control access to Dashboards and Monitor Activity under Administration. Developers will have access when Builder is enabled, while Admins will always have access. Prompted by Bug 13859631.'
);
end;
/
prompt --application/shared_components/security/authorizations/sso_authentication
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(11007909946539925)
,p_name=>'SSO authentication'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return wwv_flow_authentication_dev.get_internal_authentication not in (''APEX'',''CLOUD_IDM'',''LDAP'',''DB'');'
,p_error_message=>'Builder SSO is not enabled'
,p_reference_id=>6738410669854771
,p_caching=>'BY_USER_BY_SESSION'
,p_comments=>wwv_flow_string.join(wwv_flow_t_varchar2(
'This authorization scheme checks whether the builder authentication can be used for single sign-on to workspaces. This includes SSO, header-based and LDAP authentication, but not',
'',
'  - APEX: login requires a workspace name',
'  - CLOUD_IDM: external login to IDM, but switching workspaces is not allowed, since the login is for a single tenant only'))
);
end;
/
prompt --application/shared_components/security/authorizations/sql_developer_web_enabled
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(11403377390021811)
,p_name=>'SQL Developer Web enabled'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'    return wwv_flow_listener.sql_developer_web_enabled;',
'end;'))
,p_error_message=>'SQL Developer Web link is not enabled for this instance.'
,p_reference_id=>11401467991562895
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/sql_scripts_supported
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(11650706329157488)
,p_name=>'SQL_SCRIPTS Supported'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return true;'
,p_error_message=>'SQL Script functionality is not supported in this configuration.'
,p_reference_id=>786931734190107980
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/sql_scripts_not_supported
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(11800412655616562)
,p_name=>'SQL_SCRIPTS NOT Supported'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return false;'
,p_error_message=>'DDL view in line is not supported.'
,p_reference_id=>786931461585107980
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_edit
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(12506407035221692)
,p_name=>'Flow: EDIT'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'EDIT'
,p_error_message=>'You are not authorized to edit applications'
,p_reference_id=>12480509677812756
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_admin
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(12520119493499631)
,p_name=>'Flow: ADMIN'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'ADMIN'
,p_error_message=>'You are not authorized to administer applications'
,p_reference_id=>12511219858301010
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_sql
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(12524102140541924)
,p_name=>'Flow: SQL'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'SQL'
,p_error_message=>'You are not authorized to use SQL Workshop'
,p_reference_id=>12523823826538734
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/ui_def_exists_for_object
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(20416908986150096)
,p_name=>'UI_DEF_EXISTS_FOR_OBJECT'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select table_id',
'  from wwv_flow_hnt_table_info',
' where schema     = :OBJECT_OWNER',
'   and table_name = :OBJECT_NAME'))
,p_error_message=>'Error.'
,p_reference_id=>786932671432107981
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_data_loader
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(46496411771574510)
,p_name=>'Flow: DATA_LOADER'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'DATA_LOADER'
,p_error_message=>'You are not authorized for data loader'
,p_reference_id=>786941042784190072
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_edit_or_sql
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(46619710624049700)
,p_name=>'Flow: EDIT or SQL'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'EDIT:SQL'
,p_error_message=>'You are not authorized to edit applications or use SQL Workshop'
,p_reference_id=>46618038002026587
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_team_development_enabled
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(173297929258927869)
,p_name=>'APEX 5.0 Team development enabled'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'from wwv_flow_companies w, ',
'        wwv_flow_fnd_user u',
'where nvl(w.ALLOW_TEAM_DEVELOPMENT_YN,''Y'') = ''Y'' and ',
'      w.PROVISIONING_COMPANY_ID = :flow_security_group_id and',
'      u.security_group_id = :flow_security_group_id and',
'      u.USER_NAME = upper(:app_user) and',
'      nvl(u.ALLOW_TEAM_DEVELOPMENT_YN,''Y'') = ''Y'''))
,p_error_message=>'Team development not enabled for this workspace'
,p_reference_id=>786516861027697723
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_app_builder_enabled
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(178922732459641711)
,p_name=>'APEX 5.0 App Builder Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'EDIT'
,p_error_message=>'No privilege for attempted operation'
,p_reference_id=>786516029127697713
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_sql_workshop_enabled
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(178925305824656679)
,p_name=>'APEX 5.0 SQL Workshop Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'SQL'
,p_error_message=>'You are not authorized to use SQL Workshop'
,p_reference_id=>786516265251697717
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/registered_dba_login_and_db_monitor_enabled
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(206059717799303330)
,p_name=>'REGISTERED_DBA_LOGIN and DB Monitor Enabled'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if nvl(wwv_flow_platform.get_preference(''ALLOW_DB_MONITOR''), ''N'') = ''N'' then',
'    wwv_flow_debug.trace(''ALLOW_DB_MONITOR disabled'');',
'    return false;',
'elsif :APP_PAGE_ALIAS=''DBA_LOGIN'' then',
'    if not wwv_flow_authorization.is_authorized_developer(''SQL'') then',
'        wwv_flow_debug.trace(''must have SQL privs on DBA_LOGIN page'');',
'        return false;',
'    else',
'        return true;',
'    end if;',
'end if;',
'    ',
'if wwv_flow_security.user_is_dba (p_username => :DBA_USERNAME ) then',
'    return true;',
'end if;',
'',
':F4500_DBA_LOGIN := ''N'';',
'',
'wwv_flow_utilities.redirect_url (',
'    p_url => wwv_flow_utilities.prepare_url ( ''f?p=''||:APP_ID||'':DBA_LOGIN:''||:SESSION||'':''||:APP_ID||'',''||:APP_PAGE_ID||'':''||:DEBUG ) );',
'',
'return true;'))
,p_error_message=>'DBA pages are disabled.'
,p_version_scn=>1949778306
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/db_10_2_or_higher
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(239225402734254498)
,p_name=>'db 10.2 or higher'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'   from sys.dba_objects',
' where object_name = ''SYS_PLSQL_SQL_INJECT_TAB''',
' and owner = ''SYS'''))
,p_error_message=>'SQL Injection analysis is not supported with your current database version or configuration. It is only available for Oracle release 10.2 or higher with SQL Injection packages installed.'
,p_reference_id=>786933222298107982
,p_caching=>'BY_USER_BY_SESSION'
,p_comments=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from ',
'( select to_number(substr(banner,instr(substr(banner,0,l.p),'' '',-1)+1,',
'                    l.p-instr(substr(banner,0,l.p),'' '',-1)+1)) version',
'from v$version,',
'  ( select instr(banner,''.'') p',
'         from v$version',
'         where banner like ''Oracle%''  ) l',
'  where banner like ''Oracle%''  )',
'where version >= 10.2'))
);
end;
/
prompt --application/shared_components/security/authorizations/db_10_1_or_higher
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(240648913515910366)
,p_name=>'db 10.1 or higher'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>'select 1 from sys.dual'
,p_error_message=>'Your database must be release 10.1 for this feature to be supported.'
,p_reference_id=>786932968525107981
,p_caching=>'BY_USER_BY_SESSION'
,p_comments=>'for release 2.0, used to protect Recycle Bin'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_restful
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(802775228359756685)
,p_name=>'Flow: RESTFUL'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'RESTFUL'
,p_error_message=>'No privilege for attempted operation'
,p_reference_id=>786519856057734816
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/service_requests_enabled
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(916236223411830688)
,p_name=>'Service Requests Enabled'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_platform.get_preference(''SERVICE_REQUESTS_ENABLED'') = ''Y'' then',
'    return TRUE;',
'else',
'    return FALSE;',
'end if;'))
,p_error_message=>'No privilege for attempted operation.'
,p_reference_id=>786932326296107981
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/navigation/navigation_bar
begin
wwv_flow_imp_shared.create_icon_bar_item(
 p_id=>wwv_flow_imp.id(767165102345220885)
,p_icon_sequence=>10
,p_icon_subtext=>'Workspace &COMPANY.'
,p_icon_target=>'#'
,p_icon_image_alt=>'Workspace &COMPANY.'
,p_nav_entry_is_feedback_yn=>'N'
,p_begins_on_new_line=>'NO'
,p_cell_colspan=>1
);
wwv_flow_imp_shared.create_icon_bar_item(
 p_id=>wwv_flow_imp.id(331786907421617643)
,p_icon_sequence=>20
,p_icon_subtext=>'( <span style="text-decoration:underline;">Switch Workspace</span> )'
,p_icon_target=>'f?p=4550:20'
,p_icon_image_alt=>'Switch Workspace'
,p_nav_entry_is_feedback_yn=>'N'
,p_begins_on_new_line=>'NO'
,p_cell_colspan=>1
,p_security_scheme=>wwv_flow_imp.id(11007909946539925)
);
wwv_flow_imp_shared.create_icon_bar_item(
 p_id=>wwv_flow_imp.id(160707630779049420)
,p_icon_sequence=>30
,p_icon_image=>'Logout'
,p_icon_subtext=>'( <span style="text-decoration:underline;">Logout</span> )'
,p_icon_target=>'&LOGOUT_URL.'
,p_icon_image_alt=>'Logout'
,p_nav_entry_is_feedback_yn=>'N'
,p_begins_on_new_line=>'NO'
,p_cell_colspan=>1
);
end;
/
prompt --application/shared_components/logic/application_processes/load_prism_js_file
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(8010001659675724)
,p_process_sequence=>1
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Load Prism JS file'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_javascript.add_3rd_party_library_file( ',
'    p_library => wwv_flow_cdn.c_library_prismjs,',
'    p_attributes => ''data-manual'' );'))
,p_process_clob_language=>'PLSQL'
,p_process_when=>'2000,2010,2016,2022,2025,2027,2030,2035,2040,2055,2061,2065,2070'
,p_process_when_type=>'CURRENT_PAGE_IN_CONDITION'
,p_process_comment=>'Loads Prism JS file for highlighting syntax. This is used in "Object Browser > Create Object Wizard" pages. Please refer server side condition for list of pages.'
,p_version_scn=>37165770887418
);
end;
/
prompt --application/shared_components/logic/application_processes/qb_poststate
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(1504518033640244)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'qb_postState'
,p_process_sql_clob=>':P1002_OWNER := :APP_USER;'
,p_process_clob_language=>'PLSQL'
,p_process_error_message=>'DO_NOT_TRANSLATE'
,p_security_scheme=>wwv_flow_imp.id(12524102140541924)
,p_process_comment=>'created 10-JAN-2005 17:03:31'
,p_version_scn=>37165770887418
);
end;
/
prompt --application/shared_components/logic/application_processes/qb_rendertable
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(1916013849479713)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'qb_renderTable'
,p_process_sql_clob=>'wwv_flow_query_builder.renderTableV2(:P1002_ID,:P1002_COUNT);'
,p_process_clob_language=>'PLSQL'
,p_process_error_message=>'DO_NOT_TRANSLATE'
,p_security_scheme=>wwv_flow_imp.id(12524102140541924)
,p_process_comment=>'created 11-JAN-2005 09:16:46'
,p_version_scn=>37165770887418
);
end;
/
prompt --application/shared_components/logic/application_processes/ajax_set_ui_mode
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(2609556949513377)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'ajax_set_ui_mode'
,p_process_sql_clob=>'wwv_flow_4000_ui.ajax_set_ui_mode;'
,p_process_clob_language=>'PLSQL'
,p_security_scheme=>'MUST_NOT_BE_PUBLIC_USER'
,p_version_scn=>7800143
);
end;
/
prompt --application/shared_components/logic/application_processes/qb_object_feed
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(3934212967688584)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'qb_object_feed'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_sw_object_feed.getmoreObjects(',
'p_type    =>'';TABLE;VIEW'',',
'p_owner   =>:P1002_SCHEMA,',
'p_display =>''DIV'',',
'p_session   =>:SESSION,',
'p_onclick =>:P1002_ONCLICK,',
'p_Start   =>1,',
'p_stop    =>50000,',
'p_class   =>''ob_Object'');',
'wwv_flow.debug(''End'');'))
,p_process_clob_language=>'PLSQL'
,p_process_error_message=>'DO_NOT_TRANSLATE'
,p_security_scheme=>wwv_flow_imp.id(12524102140541924)
,p_process_comment=>'created 13-JAN-2005 19:11:46'
,p_version_scn=>37165770887418
);
end;
/
prompt --application/shared_components/logic/application_processes/sc_posthistory
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(6231903825594156)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'sc_posthistory'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_buffer varchar2(32767) := null;',
'  l_amount number;',
'  l_offset number;',
'begin',
'  for c1 in (select command',
'             from wwv_flow_sw_sql_cmds',
'             where id = :P1201_HISTORY_ID',
'             and security_group_id = :flow_security_group_id)',
'  loop',
'      if c1.command is not null and sys.dbms_lob.getlength( c1.command ) > 0 then',
'          l_amount := 8000;',
'          l_offset := 1;',
'          begin',
'              loop',
'                  sys.dbms_lob.read( c1.command, l_amount, l_offset, l_buffer );',
'                  sys.htp.prn( l_buffer );',
'                  l_offset := l_offset + l_amount;',
'                  l_amount := 8000;',
'              end loop;',
'          exception',
'              when others then',
'                  null;',
'          end;',
'      end if;    ',
'      exit;',
'  end loop;',
'end;'))
,p_process_clob_language=>'PLSQL'
,p_process_error_message=>'Unable to get history.'
,p_security_scheme=>wwv_flow_imp.id(12524102140541924)
,p_process_comment=>'created 18-JAN-2005 12:49:22'
,p_version_scn=>37165770887418
);
end;
/
prompt --application/shared_components/logic/application_processes/sc_postsavedsql
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(7139200190149482)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'sc_postSavedSQL'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_buffer varchar2(32767) := null;',
'  l_amount number;',
'  l_offset number;',
'begin',
'  for c1 in (select qb_sql, id, title, description',
'               from wwv_flow_qb_saved_query',
'              where id = :P1003_QUERY_ID',
'                and security_group_id = :flow_security_group_id)',
'',
'  loop',
'      :P1003_QUERY_ID := c1.id;',
'      :P1003_SAVE_NAME := c1.title;',
'      :P1003_SAVE_DESC := c1.description;',
'      if c1.qb_sql is not null and sys.dbms_lob.getlength( c1.qb_sql ) > 0 then',
'          l_amount := 8000;',
'          l_offset := 1;',
'          begin',
'              loop',
'                  sys.dbms_lob.read( c1.qb_sql, l_amount, l_offset, l_buffer );',
'                  sys.htp.prn( l_buffer );',
'                  l_offset := l_offset + l_amount;',
'                  l_amount := 8000;',
'              end loop;',
'          exception',
'              when others then',
'                  null;',
'          end;',
'      end if;    ',
'      exit;',
'  end loop;',
'end;'))
,p_process_clob_language=>'PLSQL'
,p_process_error_message=>'Unable to get saved SQL.'
,p_security_scheme=>wwv_flow_imp.id(12524102140541924)
,p_process_comment=>'created 19-JAN-2005 12:35:15'
,p_version_scn=>37165770887418
);
end;
/
prompt --application/shared_components/logic/application_processes/qb_get_saved_query
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(7276531262852173)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'qb_get_saved_query'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.owa_util.mime_header(''text/javascript'', FALSE );',
'sys.htp.p(''Cache-Control: no-cache'');',
'sys.htp.p(''Pragma: no-cache'');',
'sys.owa_util.http_header_close;',
'sys.htp.p(''var fUser ="''||:APP_USER||''";'');',
'wwv_flow_query_builder.loadQuery;'))
,p_process_clob_language=>'PLSQL'
,p_process_error_message=>'#SQLERRM#'
,p_security_scheme=>wwv_flow_imp.id(12524102140541924)
,p_process_comment=>'created 19-JAN-2005 17:19:02'
,p_version_scn=>37165770887418
);
end;
/
prompt --application/shared_components/logic/application_processes/ob_get_object_feed
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(11551302098165190)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'OB_GET_OBJECT_FEED'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_sw_object_feed.getmoreObjects(',
'p_type    =>:P2001_FEED_TYPE,',
'p_owner   =>:P2001_FEED_OWNER,',
'p_Start   =>:P2001_FEED_START,',
'p_stop    =>:P2001_FEED_STOP,',
'p_display =>:P2001_FEED_DISPLAY,',
'p_session   =>:SESSION,',
'p_include =>:P2001_FEED_INCLUDE,',
'p_onclick =>:P2001_FEED_ONCLICK,',
'p_class  =>:P2001_FEED_CLASS);'))
,p_process_clob_language=>'PLSQL'
,p_process_error_message=>'DO_NOT_TRANSLATE'
,p_security_scheme=>wwv_flow_imp.id(12524102140541924)
,p_process_comment=>'This is for the Object Browser please do not change'
,p_version_scn=>37165770887417
);
end;
/
prompt --application/shared_components/logic/application_processes/sc_getbind
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(21627908860597925)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'sc_getBind'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'l_new_binds varchar2(32700);',
'l_old_binds varchar2(32700);',
'begin',
'  l_new_binds := wwv_flow_sw_api.get_binds(',
'                     p_stmt     => :P1003_SQL_COMMAND2,',
'                     p_language => :P1003_CMD_LANGUAGE );',
'  l_old_binds := v(''P1200_BINDS''); ',
'',
'  if (l_new_binds is null) then',
'    return;',
'  else',
'    sys.htp.p(''l_new_binds ''||l_new_binds);',
'  end if;',
'  if l_new_binds = l_old_binds then ',
'    return;',
'  else',
'    wwv_flow.update_cache_with_write (',
'      p_name   => ''P1200_BINDS'',',
'      p_value  => l_new_binds );',
'    wwv_flow.update_cache_with_write (',
'      p_name   => ''P1200_BIND_VALS'',',
'      p_value  => '''');',
'  end if;',
'end;'))
,p_process_clob_language=>'PLSQL'
,p_process_error_message=>'Unable to get binds'
,p_security_scheme=>wwv_flow_imp.id(12524102140541924)
,p_process_comment=>'created 14-FEB-2005 19:57:28'
,p_version_scn=>37165770887417
);
end;
/
prompt --application/shared_components/logic/application_processes/sc_buildsql
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(22896611795429544)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'sc_buildSql'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'-- used by sc_core.js/sc_getSQL',
'declare ',
'  i number := 0;',
'  l_owner  varchar2(128) := wwv_flow_sw_api.valid_workspace_schema(v(''P139_OWNER''));',
'  l_object varchar2(128) := v(''P139_OBJECT'');',
'begin',
'  sys.htp.p(l_owner||''.''||l_object||'' ('');',
'  for c in ( select argument_name',
'               from sys.dba_arguments',
'              where owner = l_owner',
'                and (package_name||''.''||object_name = l_object',
'                     or object_name = l_object)',
'                and argument_name is not null',
'                and data_level = 0',
'                and nvl(overload,1) = 1',
'              order by position )',
'  loop',
'    if (i < 1) then',
'      sys.htp.p(c.argument_name ||'' => '');',
'      i := i+1;',
'    else',
'      sys.htp.p('',''||c.argument_name ||'' => '');',
'    end if;',
'  end loop;',
'  sys.htp.p('')'');',
'end;'))
,p_process_clob_language=>'PLSQL'
,p_process_error_message=>'Error'
,p_security_scheme=>wwv_flow_imp.id(12524102140541924)
,p_process_comment=>'created 15-FEB-2005 20:29:24'
,p_version_scn=>37165770887417
);
end;
/
prompt --application/shared_components/logic/application_processes/sr_parsing
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(28056921387126354)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'sr_parsing'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_status varchar2(255) := null;',
'begin',
'  wwv_flow_sw_parser.parse_file(p_file_id => :P1023_FILE_ID);',
'  if wwv_flow_sw_script.invalid_script(p_file_id => :P1023_FILE_ID) = 1 then',
'    l_status := ''FAILURE'';',
'  else',
'    l_status := ''SUCCESS'';',
'  end if;',
'  sys.htp.p(l_status);',
'end;'))
,p_process_clob_language=>'PLSQL'
,p_process_error_message=>'Unable to parse the script.'
,p_security_scheme=>wwv_flow_imp.id(12524102140541924)
,p_process_comment=>'created 21-FEB-2005 15:36:28'
,p_version_scn=>37165770887417
);
end;
/
prompt --application/shared_components/logic/application_processes/returnnothing
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(77984007292719402)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'ReturnNothing'
,p_process_sql_clob=>'null;'
,p_process_clob_language=>'PLSQL'
,p_security_scheme=>'MUST_NOT_BE_PUBLIC_USER'
,p_version_scn=>37165770887417
);
end;
/
prompt --application/shared_components/logic/application_processes/sr_save_script
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(106683007949808585)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'sr_save_script'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (select clob001 script, c001 file_id, c002 name                   ',
'           from htmldb_collections',
'           where collection_name = ''SR_SCRIPT_SOURCE'') loop',
'    wwv_flow_sw_script.update_script_file (',
'     p_file_id     => c1.file_id,',
'     p_script_name => c1.name,',
'     p_script      => c1.script);',
'end loop;'))
,p_process_clob_language=>'PLSQL'
,p_process_error_message=>'Unable to update script.'
,p_security_scheme=>wwv_flow_imp.id(12524102140541924)
,p_process_comment=>'created 23-FEB-2005 15:37:51'
,p_version_scn=>37165770887417
);
end;
/
prompt --application/shared_components/logic/application_processes/sr_create_script
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(108492501270666096)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'sr_create_script'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (select clob001 script, c001 file_id, c002 name                   ',
'             from htmldb_collections',
'             where collection_name = ''SR_SCRIPT_SOURCE'') loop',
'    wwv_flow_sw_script.create_script_from_clob (        ',
'     p_script_name => c1.name,',
'     p_script      => c1.script);   ',
'end loop;'))
,p_process_clob_language=>'PLSQL'
,p_process_error_message=>'Unable to create script.'
,p_security_scheme=>wwv_flow_imp.id(12524102140541924)
,p_process_comment=>'created 25-FEB-2005 10:54:13'
,p_version_scn=>37165770887417
);
end;
/
prompt --application/shared_components/logic/application_processes/sr_dup_name
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(112585108113201529)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'sr_dup_name'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_cnt          number := 0;  ',
'  l_current_id   number := null;',
'  l_new_filename varchar2(4000) := null;',
'  l_old_filename varchar2(4000) := null;',
'  l_existing_id  number := null;',
'  l_created_by   varchar2(255) := null;',
'  ',
'  l_flag         varchar2(255) := null;',
'begin',
'  l_new_filename := lower(v(''P60_SCRIPT_NAME''));',
'  l_old_filename := lower(v(''P60_OLD_SCRIPT_NAME''));',
'  l_current_id := v(''P60_FILE_ID'');',
'	',
'  if l_new_filename = nvl(l_old_filename,'''') then',
'     l_flag := ''SUCCESS'';	   ',
'  else',
'     for c1 in (select id, created_by',
'                from wwv_flow_files',
'                where lower(filename) = l_new_filename)',
'     loop',
'       l_cnt := l_cnt + 1;    ',
'       l_existing_id := c1.id;',
'       l_created_by := c1.created_by;',
'       exit;    ',
'     end loop;',
'     if l_cnt > 0 then',
'       if l_existing_id = nvl(l_current_id,0) then',
'         l_flag := ''SAVE_NEW'';',
'       else       	 ',
'         l_flag := ''FAIL'';',
'       end if;',
'       if upper(l_created_by) != upper(v(''APP_USER'')) then    	 ',
'           l_flag := ''FAIL_RENAME'';         ',
'       end if;       ',
'     else',
'     	l_flag := ''SAVE_NEW'';',
'     end if;',
'  end if;',
'  sys.htp.p(l_flag);',
'end;'))
,p_process_clob_language=>'PLSQL'
,p_process_error_message=>'Unable to get duplicate script name.'
,p_security_scheme=>wwv_flow_imp.id(12524102140541924)
,p_process_comment=>'created 03-MAR-2005 22:12:36'
,p_version_scn=>37165770887417
);
end;
/
prompt --application/shared_components/logic/application_processes/sc_create_job
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(136604317027747819)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'sc_create_job'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P1003_JOBID := wwv_flow_sc_transactions.sc_create_job(:P1003_LANGUAGE);',
':P1003_AUTOCOMMIT := ''Y'';'))
,p_process_clob_language=>'PLSQL'
,p_process_error_message=>'Unable to create job '
,p_security_scheme=>wwv_flow_imp.id(12524102140541924)
,p_process_comment=>'created 15-MAR-2005 19:03:39'
,p_version_scn=>37165770887417
);
end;
/
prompt --application/shared_components/logic/application_processes/sc_remove_job
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(136605514734756665)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'sc_remove_job'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'l_tid number ;',
'begin',
'  l_tid := wwv_flow_sc_transactions.add_trans(:SESSION, :FLOW_USER, ',
'                :P1003_SCHEMA,''STOP'', 0, '''', ''exit'');',
'  :P1003_JOBID := '''';',
' :P1003_AUTOCOMMIT := '''';',
'end;'))
,p_process_clob_language=>'PLSQL'
,p_process_error_message=>'Unable to remove job'
,p_security_scheme=>wwv_flow_imp.id(12524102140541924)
,p_process_comment=>'created 15-MAR-2005 19:05:07'
,p_version_scn=>37165770887417
);
end;
/
prompt --application/shared_components/logic/application_processes/sc_read_out
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(137030824141880927)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'sc_read_out'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_out   clob;',
'  l_tid   number;',
'  lob_length     integer;',
'  read_amount    integer;',
'  read_offset    integer := 1;',
'  buffer         varchar2(32700);',
'begin',
'   l_tid := v(''P1200_STMT'');',
'   select transaction_result into l_out ',
'    from wwv_flow_sc_trans ',
'    where session_id = (select nv(''SESSION'') x from sys.dual)',
'    and transaction_id = l_tid;',
'   if (length(l_out) > 0) then',
'     lob_length := length(l_out);',
'     while (lob_length > 0) loop',
'       if (lob_length > 32000) then',
'         read_amount := 32000;',
'       else ',
'         read_amount := lob_length;',
'       end if;',
'       sys.dbms_lob.read(l_out,read_amount,read_offset,buffer);',
'       sys.htp.p(wwv_flow_escape.noop(buffer));',
'       read_offset := read_offset+read_amount;',
'       lob_length := lob_length-read_amount;',
'     end loop;',
'   else',
'     sys.htp.p(''HTMLDB:NONE'');',
'   end if;',
'',
'exception when others then',
' sys.htp.p(''HTMLDB:NONE ERROR ''||wwv_flow_escape.html(SQLERRM));',
' sys.htp.p(''HTMLDB:NONE ERROR ''||wwv_flow_escape.html(SQLERRM));',
'end;'))
,p_process_clob_language=>'PLSQL'
,p_process_error_message=>'Unable to read output'
,p_security_scheme=>wwv_flow_imp.id(12524102140541924)
,p_process_comment=>'created 16-MAR-2005 09:19:10'
,p_version_scn=>37165770887417
);
end;
/
prompt --application/shared_components/logic/application_processes/sr_replace_script
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(138449522524133557)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'sr_replace_script'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_file_id number := null;',
'begin',
'  for c1 in (select clob001 script, c001 file_id, c002 name                   ',
'             from htmldb_collections',
'             where collection_name = ''SR_SCRIPT_SOURCE'') loop',
'      for c2 in (select id',
'                 from wwv_flow_files',
'                 where lower(filename) = lower(c1.name)',
'                 and file_type = ''SCRIPT'')',
'      loop',
'          l_file_id := c2.id;',
'          exit;',
'      end loop; ',
'      if l_file_id is not null then          	',
'        wwv_flow_sw_script.update_script_file (',
'         p_file_id     => l_file_id,',
'         p_script_name => c1.name,',
'         p_script      => c1.script);',
'      end if;',
'  end loop;',
'end;  '))
,p_process_clob_language=>'PLSQL'
,p_process_error_message=>'Unable to replace script.'
,p_security_scheme=>wwv_flow_imp.id(12524102140541924)
,p_process_comment=>'created 17-MAR-2005 16:34:36'
,p_version_scn=>37165770887418
);
end;
/
prompt --application/shared_components/logic/application_processes/sc_read_dbms
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(140873708217846868)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'sc_read_dbms'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_out   clob;',
'  l_tid   number;',
'begin',
'   l_tid := v(''P1200_STMT'');',
'   select transaction_output into l_out from wwv_flow_sc_trans ',
'   where session_id = :SESSION and transaction_id = l_tid;',
'   if length(l_out) > 0 then',
'     sys.htp.p(wwv_flow_escape.noop(l_out));',
'   else',
'     sys.htp.p(''HTMLDB:NONE'');',
'   end if;',
'exception when others then',
' sys.htp.p(''HTMLDB:NONE'');',
'end;'))
,p_process_clob_language=>'PLSQL'
,p_process_error_message=>'Unable to read output'
,p_security_scheme=>wwv_flow_imp.id(12524102140541924)
,p_process_comment=>'created 21-MAR-2005 17:00:09'
,p_version_scn=>37165770887418
);
end;
/
prompt --application/shared_components/logic/application_processes/sc_sql_trans
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(141051327945527301)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'sc_sql_trans'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_tid number;',
'begin',
'l_tid := wwv_flow_sc_transactions.add_trans (',
'    p_session => :SESSION,',
'    p_user    => :FLOW_USER,',
'    p_schema  => wwv_flow_sw_api.valid_workspace_schema(:P1003_SCHEMA),',
'    p_type    => :P1200_TYPE,',
'    p_rows    => :P1003_ROWS,',
'    p_binds   => :P1200_BIND_VALS,',
'    p_sql     => wwv_flow_sw_api.to_sql_command(wwv_flow.g_f01) );',
'sys.htp.prn(l_tid);',
'end;'))
,p_process_clob_language=>'PLSQL'
,p_process_error_message=>'Unable to load SQL trans'
,p_security_scheme=>wwv_flow_imp.id(12524102140541924)
,p_process_comment=>'created 21-MAR-2005 21:40:14'
,p_version_scn=>37165770887418
);
end;
/
prompt --application/shared_components/logic/application_processes/sc_savequery
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(158194723674245313)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'sc_saveQuery'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_sw_api.sc_savequery (',
'    p_name     => :P1003_SAVE_NAME,',
'    p_desc     => :P1003_SAVE_DESC,',
'    p_query_id => :P1003_QUERY_ID,',
'    p_schema   => :P1003_SCHEMA,',
'    p_sql_command => :P1003_SQL_COMMAND2 );'))
,p_process_clob_language=>'PLSQL'
,p_process_error_message=>'Unable to save Query'
,p_security_scheme=>wwv_flow_imp.id(12524102140541924)
,p_process_comment=>'created 04-APR-2005 16:26:34'
,p_version_scn=>37165770887418
);
end;
/
prompt --application/shared_components/logic/application_processes/check_avail_jobs
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(192446004690296352)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'check_avail_jobs'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_jobs number;',
'begin',
'  select value-(select count(*) from sys.dba_jobs) into l_jobs  ',
'  from v$parameter ',
'  where name = ''job_queue_processes'';',
'  sys.htp.prn(l_jobs);',
'end;'))
,p_process_clob_language=>'PLSQL'
,p_process_error_message=>'Unable to get job status'
,p_security_scheme=>wwv_flow_imp.id(12524102140541924)
,p_process_comment=>'created 10-MAY-2005 16:28:24'
,p_version_scn=>37165770887418
);
end;
/
prompt --application/shared_components/logic/application_processes/spotlightindex
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(233722337928545821)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'spotlightIndex'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_spotlight_dev.emit_spotlight_search_index(',
'    p_app_id          => wwv_flow.g_x01,',
'    p_advanced_search => wwv_flow.g_x02);'))
,p_process_clob_language=>'PLSQL'
,p_security_scheme=>'MUST_NOT_BE_PUBLIC_USER'
,p_version_scn=>36494215
);
end;
/
prompt --application/shared_components/logic/application_processes/check_job_queue
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(251183224917806135)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'check_job_queue'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_jobs number;',
'begin',
'  select value into l_jobs  ',
'  from v$parameter ',
'  where name = ''job_queue_processes'';',
'  sys.htp.prn(l_jobs);',
'end;'))
,p_process_clob_language=>'PLSQL'
,p_process_error_message=>'Unable to check jobs'
,p_security_scheme=>wwv_flow_imp.id(12524102140541924)
,p_process_comment=>'created 23-MAY-2005 11:26:42'
,p_version_scn=>37165770887418
);
end;
/
prompt --application/shared_components/logic/application_processes/get_message
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(251509908846066406)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'get_message'
,p_process_sql_clob=>'sys.htp.p(wwv_flow_lang.system_message(:SYSTEM_MESSAGE));'
,p_process_clob_language=>'PLSQL'
,p_process_error_message=>'Unable to get message.'
,p_security_scheme=>'MUST_NOT_BE_PUBLIC_USER'
,p_process_comment=>'created 23-MAY-2005 12:10:05'
,p_version_scn=>37165770887418
);
end;
/
prompt --application/shared_components/logic/application_processes/qb_check_unique
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(266120031373725934)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'qb_check_unique'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_counter number;',
'begin',
'',
'  select count(*) into l_counter ',
'  from wwv_flow_qb_saved_query ',
'  where title = v(''P1002_QUERY_NAME'') ',
'   and created_by = v(''FLOW_USER'')',
'   and security_group_id = wwv_flow_security.g_security_group_id;',
'',
'  if (l_counter > 0) then',
'   sys.htp.p(''<div class="htmldbNotification"><ul><li>'');',
'   sys.htp.p(wwv_flow_lang.system_message(''QB_DUPLICATE_QUERY''));',
'   sys.htp.p(''</li></ul></div>'');',
'  else',
'    sys.htp.prn(''0'');',
'  end if;',
'',
'end;'))
,p_process_clob_language=>'PLSQL'
,p_process_error_message=>'Unable to validate save'
,p_security_scheme=>wwv_flow_imp.id(12524102140541924)
,p_process_comment=>'created 20-JUN-2005 14:13:20'
,p_version_scn=>37165770887418
);
end;
/
prompt --application/shared_components/logic/application_items/company
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(5086354147)
,p_name=>'COMPANY'
,p_scope=>'GLOBAL'
,p_escape_on_http_output=>'N'
,p_version_scn=>37165770887405
);
end;
/
prompt --application/shared_components/logic/application_items/current_object_id
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(63888631031213062)
,p_name=>'CURRENT_OBJECT_ID'
,p_escape_on_http_output=>'N'
,p_version_scn=>37165770887405
);
end;
/
prompt --application/shared_components/logic/application_items/datagen_schema
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(2301647445959345)
,p_name=>'DATAGEN_SCHEMA'
,p_protection_level=>'I'
,p_item_comment=>'Stores the schema used by the data generator UI'
,p_version_scn=>37165770887405
);
end;
/
prompt --application/shared_components/logic/application_items/dba_username
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(25966015567654518)
,p_name=>'DBA_USERNAME'
,p_protection_level=>'I'
,p_escape_on_http_output=>'N'
,p_version_scn=>37165770887405
);
end;
/
prompt --application/shared_components/logic/application_items/f4500_dba_login
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(206052124417257915)
,p_name=>'F4500_DBA_LOGIN'
,p_protection_level=>'I'
,p_escape_on_http_output=>'N'
,p_version_scn=>37165770887405
);
end;
/
prompt --application/shared_components/logic/application_items/f4500_last_view
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(48602367732370754)
,p_name=>'F4500_LAST_VIEW'
,p_data_type=>'NUMBER'
,p_escape_on_http_output=>'N'
,p_version_scn=>37165770887405
);
end;
/
prompt --application/shared_components/logic/application_items/f4500_p502_object_type
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(240551529397730482)
,p_name=>'F4500_P502_OBJECT_TYPE'
,p_protection_level=>'N'
,p_escape_on_http_output=>'N'
,p_version_scn=>37165770887405
);
end;
/
prompt --application/shared_components/logic/application_items/fsp_after_login_url
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(22437001853024837)
,p_name=>'FSP_AFTER_LOGIN_URL'
,p_escape_on_http_output=>'N'
,p_item_comment=>'Used by Custom2 authentication for deep linking support'
,p_version_scn=>37165770887405
);
end;
/
prompt --application/shared_components/logic/application_items/g_ctrl_file_id
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(34319320571482284)
,p_name=>'G_CTRL_FILE_ID'
,p_data_type=>'NUMBER'
,p_escape_on_http_output=>'N'
,p_version_scn=>37165770887405
);
end;
/
prompt --application/shared_components/logic/application_items/g_user_default_date_format
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(367331519540068469)
,p_name=>'G_USER_DEFAULT_DATE_FORMAT'
,p_protection_level=>'I'
,p_escape_on_http_output=>'N'
,p_version_scn=>37165770887405
);
end;
/
prompt --application/shared_components/logic/application_items/last_selected_parse_as
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(101416805412462518)
,p_name=>'LAST_SELECTED_PARSE_AS'
,p_escape_on_http_output=>'N'
,p_item_comment=>'This is used to support public synonyms.  Supporting public synonym is on hold until R2.'
,p_version_scn=>37165770887405
);
end;
/
prompt --application/shared_components/logic/application_items/last_step
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(48607820040821755)
,p_name=>'LAST_STEP'
,p_escape_on_http_output=>'N'
,p_version_scn=>37165770887405
);
end;
/
prompt --application/shared_components/logic/application_items/object_id
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(12255104688621266)
,p_name=>'OBJECT_ID'
,p_escape_on_http_output=>'N'
,p_version_scn=>37165770887405
);
end;
/
prompt --application/shared_components/logic/application_items/object_locker
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(12255530314628639)
,p_name=>'OBJECT_LOCKER'
,p_escape_on_http_output=>'N'
,p_version_scn=>37165770887405
);
end;
/
prompt --application/shared_components/logic/application_items/object_name
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(12255902395630078)
,p_name=>'OBJECT_NAME'
,p_escape_on_http_output=>'N'
,p_version_scn=>37165770887405
);
end;
/
prompt --application/shared_components/logic/application_items/object_owner
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(12256308628631835)
,p_name=>'OBJECT_OWNER'
,p_protection_level=>'I'
,p_escape_on_http_output=>'N'
,p_version_scn=>37165770887405
);
end;
/
prompt --application/shared_components/logic/application_items/object_type
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(12258200626676850)
,p_name=>'OBJECT_TYPE'
,p_escape_on_http_output=>'N'
,p_version_scn=>37165770887405
);
end;
/
prompt --application/shared_components/logic/application_items/ob_object_id
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(171514813299244598)
,p_name=>'OB_OBJECT_ID'
,p_protection_level=>'N'
,p_escape_on_http_output=>'N'
,p_version_scn=>37165770887405
);
end;
/
prompt --application/shared_components/logic/application_items/success_msg
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(106656207167489750)
,p_name=>'SUCCESS_MSG'
,p_escape_on_http_output=>'N'
,p_item_comment=>'This application item is used to display success message for certain SQL Workshop regions. (Used from SQL Command Processor page 3 and page 1)'
,p_version_scn=>37165770887406
);
end;
/
prompt --application/shared_components/logic/application_items/system_message
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(251508117719059591)
,p_name=>'SYSTEM_MESSAGE'
,p_protection_level=>'N'
,p_escape_on_http_output=>'N'
,p_item_comment=>'Message displayed while running commands in SQL Commands. Message is retrieved using on-demand process "get_message".'
,p_version_scn=>37165770887406
);
end;
/
prompt --application/shared_components/logic/application_computations/company
begin
wwv_flow_imp_shared.create_flow_computation(
 p_id=>wwv_flow_imp.id(5088358914)
,p_computation_sequence=>10
,p_computation_item=>'COMPANY'
,p_computation_point=>'AFTER_LOGIN'
,p_computation_type=>'EXPRESSION'
,p_computation_language=>'PLSQL'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'wwv_flow.get_company_name'
,p_compute_when=>'COMPANY'
,p_compute_when_type=>'ITEM_IS_NULL'
,p_computation_error_message=>'Unable to compute workspace name.'
,p_version_scn=>37165770887460
);
end;
/
prompt --application/shared_components/logic/application_computations/datagen_schema
begin
wwv_flow_imp_shared.create_flow_computation(
 p_id=>wwv_flow_imp.id(2304233968021720)
,p_computation_sequence=>10
,p_computation_item=>'DATAGEN_SCHEMA'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'EXPRESSION'
,p_computation_language=>'PLSQL'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'upper(wwv_flow_user_api.get_default_schema)'
,p_compute_when=>':DATAGEN_SCHEMA is null and :APP_PAGE_ID between 4000 and 4200'
,p_compute_when_text=>'PLSQL'
,p_compute_when_type=>'EXPRESSION'
,p_version_scn=>37165770887460
);
end;
/
prompt --application/shared_components/logic/application_computations/g_user_default_date_format
begin
wwv_flow_imp_shared.create_flow_computation(
 p_id=>wwv_flow_imp.id(367332002718076269)
,p_computation_sequence=>10
,p_computation_item=>'G_USER_DEFAULT_DATE_FORMAT'
,p_computation_point=>'ON_NEW_INSTANCE'
,p_computation_type=>'FUNCTION_BODY'
,p_computation_language=>'PLSQL'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_date_format varchar2(255);',
'begin',
'    for c1 in (select default_date_format',
'                 from wwv_flow_fnd_user',
'                where user_name = :APP_USER',
'                  and security_group_id = :flow_security_group_id',
'                  and trim(default_date_format) is not null) loop',
'        return c1.default_date_format;',
'        exit;',
'    end loop;',
'    --',
'    return :DATE_FORMAT;',
'end;'))
,p_version_scn=>37165770887460
);
end;
/
prompt --application/shared_components/logic/application_settings
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/standard
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/parent
begin
null;
end;
/
prompt --application/shared_components/user_interface/lovs/accessibility_mode
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(582053521006435152)
,p_lov_name=>'ACCESSIBILITY_MODE'
,p_lov_query=>'.'||wwv_flow_imp.id(582053521006435152)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558105
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(582053811202435157)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Screen Reader'
,p_lov_return_value=>'SCREEN_READER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/access_restrictions
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(21837016666086569)
,p_lov_name=>'ACCESS_RESTRICTIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(21837016666086569)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558107
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(21837217288086572)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Available only from local server'
,p_lov_return_value=>'N'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(21837410790086575)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Available from local server and remote clients'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/active_inactive
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(133833120564560201)
,p_lov_name=>'ACTIVE INACTIVE'
,p_lov_query=>'.'||wwv_flow_imp.id(133833120564560201)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558107
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(133833301814560204)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Active'
,p_lov_return_value=>'ACTIVE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(133833501889560209)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Inactive'
,p_lov_return_value=>'INACTIVE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/alignment_left_right
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(40606619495197864)
,p_lov_name=>'ALIGNMENT LEFT RIGHT'
,p_lov_query=>'.'||wwv_flow_imp.id(40606619495197864)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558107
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(40606830354197883)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Left'
,p_lov_return_value=>'L'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(40607009987197887)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Right'
,p_lov_return_value=>'R'
);
end;
/
prompt --application/shared_components/user_interface/lovs/all_or_varchar2_column_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(88068725864843110)
,p_lov_name=>'ALL.OR.VARCHAR2.COLUMN.TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(88068725864843110)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558107
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88068924929843115)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'All Column Types'
,p_lov_return_value=>'1'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88069124491843115)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'VARCHAR Column Types'
,p_lov_return_value=>'0'
);
end;
/
prompt --application/shared_components/user_interface/lovs/all_selected_cols
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(88062000322816814)
,p_lov_name=>'ALL.SELECTED.COLS'
,p_lov_query=>'.'||wwv_flow_imp.id(88062000322816814)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558107
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88062216112816814)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'All Columns'
,p_lov_return_value=>'ALL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88062421264816815)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Selected Columns'
,p_lov_return_value=>'SELECTED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/apex_dictionary_query_conditions
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(14480503854514923)
,p_lov_name=>'APEX DICTIONARY QUERY CONDITIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(14480503854514923)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558107
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(14480728931514923)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'='
,p_lov_return_value=>'='
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(14480909767514923)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'!='
,p_lov_return_value=>'!='
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(14481110010514923)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'LIKE'
,p_lov_return_value=>'LIKE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(14493818099547338)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'NOT LIKE'
,p_lov_return_value=>'NOT LIKE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(14482210780516882)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'>'
,p_lov_return_value=>'>'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(14482613551517732)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'<'
,p_lov_return_value=>'<'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(14608723770258677)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'BETWEEN'
,p_lov_return_value=>'BETWEEN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(14609025848259268)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'IS'
,p_lov_return_value=>'IS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/apex_dictionary_view_modes
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(14392800214125907)
,p_lov_name=>'APEX DICTIONARY VIEW MODES'
,p_lov_query=>'.'||wwv_flow_imp.id(14392800214125907)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558107
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(14393015881125907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Icons'
,p_lov_return_value=>'ICONS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(14393201164125907)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Tree'
,p_lov_return_value=>'TREE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(14393419313125907)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Report'
,p_lov_return_value=>'REPORT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/apex_view_names
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(14454808001440421)
,p_lov_name=>'APEX VIEW NAMES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct apex_view_name d,',
'       apex_view_name r',
' from apex_dictionary ',
'where column_id=0',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
,p_version_scn=>75558107
);
end;
/
prompt --application/shared_components/user_interface/lovs/asc_desc_returns_asc_desc
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(88023114905423598)
,p_lov_name=>'ASC.DESC.RETURNS.ASC.DESC'
,p_lov_query=>'.'||wwv_flow_imp.id(88023114905423598)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558107
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88023312120423599)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Ascending'
,p_lov_return_value=>'ASC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88023515635423599)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Descending'
,p_lov_return_value=>'DESC'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ascdesc
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(23484408692637977)
,p_lov_name=>'ASCDESC'
,p_lov_query=>'.'||wwv_flow_imp.id(23484408692637977)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558107
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(23484707046637977)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Ascending'
,p_lov_return_value=>'A'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(23484911662637978)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Descending'
,p_lov_return_value=>'D'
);
end;
/
prompt --application/shared_components/user_interface/lovs/before_or_after
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(10601629460223677)
,p_lov_name=>'BEFORE_OR_AFTER'
,p_lov_query=>'.'||wwv_flow_imp.id(10601629460223677)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558107
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(10601955947223700)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Before'
,p_lov_return_value=>'before'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(10602352125223701)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'After'
,p_lov_return_value=>'after'
);
end;
/
prompt --application/shared_components/user_interface/lovs/cascade_checkbox
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(6527926084636289)
,p_lov_name=>'CASCADE CHECKBOX'
,p_lov_query=>'.'||wwv_flow_imp.id(6527926084636289)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558107
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(6528129949636292)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'&nbsp'
,p_lov_return_value=>'CASCADE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/cascade_constraints
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(88063516252821367)
,p_lov_name=>'CASCADE.CONSTRAINTS'
,p_lov_query=>'.'||wwv_flow_imp.id(88063516252821367)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558107
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88063706191821368)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Cascade Constraints?'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/case_sensitive_y
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(88013722767293437)
,p_lov_name=>'CASE.SENSITIVE.Y'
,p_lov_query=>'.'||wwv_flow_imp.id(88013722767293437)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558107
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88013930765293438)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Case Sensitive'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/constraint_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(8657002398372817)
,p_lov_name=>'CONSTRAINT TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(8657002398372817)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558107
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(8657206568372817)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Check'
,p_lov_return_value=>'C'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(8657415834372818)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Primary Key'
,p_lov_return_value=>'P'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(8657606976372818)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Unique'
,p_lov_return_value=>'U'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(8657818917372818)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Referential'
,p_lov_return_value=>'R'
);
end;
/
prompt --application/shared_components/user_interface/lovs/constraint_status
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(11518010813871302)
,p_lov_name=>'CONSTRAINT.STATUS'
,p_lov_query=>'.'||wwv_flow_imp.id(11518010813871302)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558107
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(11518205871871344)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Enabled'
,p_lov_return_value=>'ENABLED'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(11518415817871364)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Disabled'
,p_lov_return_value=>'DISABLED'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(11518621543871364)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'All'
,p_lov_return_value=>'ALL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/constraint_types_002
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(88046920202557653)
,p_lov_name=>'CONSTRAINT.TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(88046920202557653)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558107
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88047118047557654)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Check'
,p_lov_return_value=>'CHECK'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88047308153557654)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Foreign Key'
,p_lov_return_value=>'FK'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88047511353557655)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Primary Key'
,p_lov_return_value=>'PK'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88047724693557655)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Unique'
,p_lov_return_value=>'UNIQUE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/contraint_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(270341627024745223)
,p_lov_name=>'CONTRAINT TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(270341627024745223)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558107
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(270341802062745225)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Check'
,p_lov_return_value=>'C'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(270342021056745226)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Unique'
,p_lov_return_value=>'U'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_index_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(16028009107759017)
,p_lov_name=>'CREATE INDEX TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(16028009107759017)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558107
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16028212649759018)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Normal'
,p_lov_return_value=>'N'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16028407362759020)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Text'
,p_lov_return_value=>'T'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1800436823219905)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Spatial'
,p_lov_return_value=>'S'
,p_lov_disp_cond_type=>'EXPRESSION'
,p_lov_disp_cond=>'wwv_flow_db_version.c_has_locator'
,p_lov_disp_cond2=>'PLSQL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_user_privileges
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(164684400772980444)
,p_lov_name=>'CREATE USER PRIVILEGES'
,p_lov_query=>'.'||wwv_flow_imp.id(164684400772980444)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558107
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(164684601746980447)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'CONNECT'
,p_lov_return_value=>'CONNECT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(164684816646980450)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'RESOURCE'
,p_lov_return_value=>'RESOURCE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(164685019181980451)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'DBA'
,p_lov_return_value=>'DBA'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_mle_module_javascript_how
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(3091085801966871)
,p_lov_name=>'CREATE.MLE_MODULE_JAVASCRIPT.HOW'
,p_lov_query=>'.'||wwv_flow_imp.id(3091085801966871)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558107
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(3091335489967017)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Upload File'
,p_lov_return_value=>'FILE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(3091744026967018)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Source Code'
,p_lov_return_value=>'TEXT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2629444467250033)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'URL'
,p_lov_return_value=>'URL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_package_how
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(88084232331986937)
,p_lov_name=>'CREATE.PACKAGE.HOW'
,p_lov_query=>'.'||wwv_flow_imp.id(88084232331986937)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558107
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88084409721986937)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Build a package from scratch'
,p_lov_return_value=>'SCRATCH'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88084631917986937)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Build a package with methods on database table(s)'
,p_lov_return_value=>'TABLE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_table_how
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(88092414548047979)
,p_lov_name=>'CREATE.TABLE.HOW'
,p_lov_query=>'.'||wwv_flow_imp.id(88092414548047979)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558107
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88092609025047979)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'From scratch'
,p_lov_return_value=>'SCRATCH'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88092810507047980)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'As a copy and paste from a spreadsheet (this will take you into the Data Workshop)'
,p_lov_return_value=>'SPREADSHEET'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_table_now_script
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(88093424937050988)
,p_lov_name=>'CREATE.TABLE.NOW.SCRIPT'
,p_lov_query=>'.'||wwv_flow_imp.id(88093424937050988)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558107
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88093602555050989)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Create table now'
,p_lov_return_value=>'RUN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88093808384050989)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Create a script to edit SQL'
,p_lov_return_value=>'EDIT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_table_fk_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(111182618715174982)
,p_lov_name=>'CREATE_TABLE_FK_TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(111182618715174982)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558107
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(245703827624645868)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Disallow Delete'
,p_lov_return_value=>'D'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(111183005880174986)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Cascade Delete'
,p_lov_return_value=>'C'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(111182804604174985)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Set Null on Delete'
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_load_csv_col_delimiter
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(3927422505659936)
,p_lov_name=>'DATA.LOAD.CSV_COL_DELIMITER'
,p_lov_query=>'.'||wwv_flow_imp.id(3927422505659936)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558107
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(3927758348659940)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>','
,p_lov_return_value=>','
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(3928144847659940)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>';'
,p_lov_return_value=>';'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(3928530804659940)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'|'
,p_lov_return_value=>'|'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4182031389753526)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'#'
,p_lov_return_value=>'#'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(3928907085659940)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'tab'
,p_lov_return_value=>'tab'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_load_csv_enclosed_by
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(3931221323686172)
,p_lov_name=>'DATA.LOAD.CSV_ENCLOSED_BY'
,p_lov_query=>'.'||wwv_flow_imp.id(3931221323686172)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558108
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4083926401630096)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'None'
,p_lov_return_value=>'None'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(3931589877686177)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'"'
,p_lov_return_value=>'"'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(3931843915686177)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>''''
,p_lov_return_value=>''''
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_load_data_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84321549291630718)
,p_lov_name=>'DATA.LOAD.DATA_TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(84321549291630718)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558108
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84321869333630699)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'VARCHAR2'
,p_lov_return_value=>'VARCHAR2'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84322205066630696)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'NUMBER'
,p_lov_return_value=>'NUMBER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84322661858630696)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'DATE'
,p_lov_return_value=>'DATE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84323012454630696)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'TIMESTAMP'
,p_lov_return_value=>'TIMESTAMP'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84323403277630695)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'TIMESTAMP WITH LOCAL TIME ZONE'
,p_lov_return_value=>'TIMESTAMP WITH LOCAL TIME ZONE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84323862951630695)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'TIMESTAMP WITH TIME ZONE'
,p_lov_return_value=>'TIMESTAMP WITH TIME ZONE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84324206688630695)
,p_lov_disp_sequence=>16
,p_lov_disp_value=>'CLOB'
,p_lov_return_value=>'CLOB'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_load_first_line
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(3934090607812623)
,p_lov_name=>'DATA.LOAD.FIRST_LINE'
,p_lov_query=>'.'||wwv_flow_imp.id(3934090607812623)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558108
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(3934379444812623)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'First line contains headers'
,p_lov_return_value=>'HEADERS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_load_force_sysguid
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(325824092198610958)
,p_lov_name=>'DATA.LOAD.FORCE_SYSGUID'
,p_lov_query=>'.'||wwv_flow_imp.id(325824092198610958)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558108
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(325824367791610958)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'SYS_GUID'
,p_lov_return_value=>'Y'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(325824735376610959)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Identity Column'
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_load_max_row_range
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(3867907456164412)
,p_lov_name=>'DATA.LOAD.MAX_ROW_RANGE'
,p_lov_query=>'.'||wwv_flow_imp.id(3867907456164412)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558108
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(3868668632164428)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'200'
,p_lov_return_value=>'200'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(3870258934164431)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'1000'
,p_lov_return_value=>'1000'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(3870691602164431)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'5000'
,p_lov_return_value=>'5000'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(3925900413184232)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'All Rows'
,p_lov_return_value=>'0'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_load_source_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(212732804335774230)
,p_lov_name=>'DATA.LOAD.SOURCE_TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(212732804335774230)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558109
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(212733137832774240)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Upload a File'
,p_lov_return_value=>'FILE'
,p_lov_template=>'<span class="a-Icon icon-file-upload" aria-hidden="true"></span> #DISPLAY_VALUE#'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(212733551391774249)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Copy and Paste'
,p_lov_return_value=>'COPY_PASTE'
,p_lov_template=>'<span class="a-Icon icon-clipboard" aria-hidden="true"></span> #DISPLAY_VALUE#'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_load_status
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(3891423527523942)
,p_lov_name=>'DATA.LOAD.STATUS'
,p_lov_query=>'.'||wwv_flow_imp.id(3891423527523942)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558109
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(3891740585523942)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Running'
,p_lov_return_value=>'RUNNING'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(3892162613523943)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Finished'
,p_lov_return_value=>'FINISHED'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(3924280979996980)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Failed'
,p_lov_return_value=>'FAILED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_upload_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(1643936135665207)
,p_lov_name=>'DATA.UPLOAD.TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(1643936135665207)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558109
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1644247579665210)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Upload a File'
,p_lov_return_value=>'FILE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1644613825665214)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Copy and Paste'
,p_lov_return_value=>'COPY_PASTE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(21015224563508746)
,p_lov_name=>'DATA_TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(21015224563508746)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558109
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(21015508059508749)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'NUMBER'
,p_lov_return_value=>'NUMBER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(21015722350508750)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'VARCHAR2'
,p_lov_return_value=>'VARCHAR2'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(21015902475508751)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'DATE'
,p_lov_return_value=>'DATE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(21016106513508751)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'TIMESTAMP'
,p_lov_return_value=>'TIMESTAMP'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(21016525754508751)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'CLOB'
,p_lov_return_value=>'CLOB'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(21016725005508751)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'BLOB'
,p_lov_return_value=>'BLOB'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(24123119765584645)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'BFILE'
,p_lov_return_value=>'BFILE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(21016327140508751)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'CHAR'
,p_lov_return_value=>'CHAR'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(24128605267608850)
,p_lov_disp_sequence=>85
,p_lov_disp_value=>'FLOAT'
,p_lov_return_value=>'FLOAT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(24122330370578271)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'INTERVAL YEAR TO MONTH'
,p_lov_return_value=>'INTERVAL YEAR TO MONTH'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(24122503489579932)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'INTERVAL DAY TO SECOND'
,p_lov_return_value=>'INTERVAL DAY TO SECOND'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(24121914440573626)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>'TIMESTAMP WITH TIME ZONE'
,p_lov_return_value=>'TIMESTAMP WITH TIME ZONE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(24122121020575524)
,p_lov_disp_sequence=>120
,p_lov_disp_value=>'TIMESTAMP WITH LOCAL TIME ZONE'
,p_lov_return_value=>'TIMESTAMP WITH LOCAL TIME ZONE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(21019413051524343)
,p_lov_disp_sequence=>130
,p_lov_disp_value=>'BINARY_FLOAT'
,p_lov_return_value=>'BINARY_FLOAT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(21019722401527136)
,p_lov_disp_sequence=>140
,p_lov_disp_value=>'BINARY_DOUBLE'
,p_lov_return_value=>'BINARY_DOUBLE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(24122707991581257)
,p_lov_disp_sequence=>150
,p_lov_disp_value=>'RAW'
,p_lov_return_value=>'RAW'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(24128400765607550)
,p_lov_disp_sequence=>170
,p_lov_disp_value=>'NCHAR'
,p_lov_return_value=>'NCHAR'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(21016914224508752)
,p_lov_disp_sequence=>180
,p_lov_disp_value=>'NVARCHAR2'
,p_lov_return_value=>'NVARCHAR2'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(24138600492263086)
,p_lov_disp_sequence=>190
,p_lov_disp_value=>'NCLOB'
,p_lov_return_value=>'NCLOB'
);
end;
/
prompt --application/shared_components/user_interface/lovs/db_session_status
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(1225013363619314377)
,p_lov_name=>'DB SESSION STATUS'
,p_lov_query=>'.'||wwv_flow_imp.id(1225013363619314377)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558109
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1225013668008314381)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Current Session'
,p_lov_return_value=>'C'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1225013946804314386)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Long Transaction'
,p_lov_return_value=>'L'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1225014259544314386)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Active Session'
,p_lov_return_value=>'A'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1225014590119314386)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Idle Session'
,p_lov_return_value=>'I'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1225014814217314386)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Blocking Session'
,p_lov_return_value=>'B'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1225015134770314386)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Blocked Session'
,p_lov_return_value=>'D'
);
end;
/
prompt --application/shared_components/user_interface/lovs/db_parm_non_default
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(244335514951659559)
,p_lov_name=>'DB_PARM_NON_DEFAULT'
,p_lov_query=>'.'||wwv_flow_imp.id(244335514951659559)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558109
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(244335715591659561)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'All'
,p_lov_return_value=>'ALL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(244335932066659565)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Non-Default'
,p_lov_return_value=>'CUSTOM'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ddl_actions
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(88039608166535203)
,p_lov_name=>'DDL.ACTIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(88039608166535203)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558109
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88039800819535204)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Add Column'
,p_lov_return_value=>'ADD'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88040002165535204)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Add Constraint'
,p_lov_return_value=>'ADD_CONSTRAINT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88040231651535205)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Analyze'
,p_lov_return_value=>'ANALYZE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88040417249535205)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Copy'
,p_lov_return_value=>'COPY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88040624827535205)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'Create Index'
,p_lov_return_value=>'INDEX'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88040822124535205)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'Create Text Index'
,p_lov_return_value=>'TEXT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88041012331535206)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'Create Trigger'
,p_lov_return_value=>'CREATE_TRIGGER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88041229308535206)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'Disable Constraint'
,p_lov_return_value=>'DISABLE_CONSTRAINT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88041400926535206)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'Disable Trigger'
,p_lov_return_value=>'DISABLE_TRIGGER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88041603607535208)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'Drop Column'
,p_lov_return_value=>'REMOVE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88041815176535208)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>'Drop Constraint'
,p_lov_return_value=>'DROP_CONSTRAINT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88042009088535208)
,p_lov_disp_sequence=>120
,p_lov_disp_value=>'Drop Index'
,p_lov_return_value=>'DROP_INDEX'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88042226760535209)
,p_lov_disp_sequence=>130
,p_lov_disp_value=>'Drop Table'
,p_lov_return_value=>'DROP'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88042406323535209)
,p_lov_disp_sequence=>140
,p_lov_disp_value=>'Drop Trigger'
,p_lov_return_value=>'DROP_TRIGGER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88042607701535209)
,p_lov_disp_sequence=>150
,p_lov_disp_value=>'Enable Constraint'
,p_lov_return_value=>'ENABLE_CONSTRAINT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88042803313535209)
,p_lov_disp_sequence=>160
,p_lov_disp_value=>'Enable Trigger'
,p_lov_return_value=>'ENABLE_TRIGGER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88043019072535210)
,p_lov_disp_sequence=>170
,p_lov_disp_value=>'Modify Column'
,p_lov_return_value=>'MODIFY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88043204776535210)
,p_lov_disp_sequence=>180
,p_lov_disp_value=>'Rename Column'
,p_lov_return_value=>'RENAME_COLUMN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88043422512535210)
,p_lov_disp_sequence=>190
,p_lov_disp_value=>'Rename Table'
,p_lov_return_value=>'RENAME'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88043603529535211)
,p_lov_disp_sequence=>200
,p_lov_disp_value=>'Truncate'
,p_lov_return_value=>'TRUNCATE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/describe_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(22153924949556802)
,p_lov_name=>'DESCRIBE_TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(22153924949556802)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558110
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(22154111837556805)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'TABLE'
,p_lov_return_value=>'TABLE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(22517827091787523)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'VIEW'
,p_lov_return_value=>'VIEW'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(22518130554788590)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'PROCEDURE'
,p_lov_return_value=>'PROCEDURE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(22518404019790369)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'FUNCTION'
,p_lov_return_value=>'FUNCTION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(22518909907792079)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'PACKAGE'
,p_lov_return_value=>'PACKAGE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dg_builtins_options
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(2447835114213405)
,p_lov_name=>'DG_BUILTINS_OPTIONS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(p_name => ''ODG.BUILTINS.'' || upper(friendly_name) ) d,',
'       friendly_name r,',
'       native_datatype d_type,',
'       wwv_flow_lang.system_message(p_name => ''ODG.BUILTINS.'' || upper( builtin_category ) ) b_cat',
'  from apex_dg_builtins'))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_use_local_sync_table=>false
,p_return_column_name=>'R'
,p_display_column_name=>'R'
,p_group_column_name=>'B_CAT'
,p_group_sort_direction=>'ASC'
,p_default_sort_column_name=>'D'
,p_default_sort_direction=>'ASC'
,p_version_scn=>75558110
);
wwv_flow_imp_shared.create_list_of_values_cols(
 p_id=>wwv_flow_imp.id(14730280756101914)
,p_query_column_name=>'B_CAT'
,p_heading=>'Category'
,p_display_sequence=>10
,p_data_type=>'VARCHAR2'
);
wwv_flow_imp_shared.create_list_of_values_cols(
 p_id=>wwv_flow_imp.id(14730501129101915)
,p_query_column_name=>'D'
,p_heading=>'Built In'
,p_display_sequence=>20
,p_data_type=>'VARCHAR2'
);
wwv_flow_imp_shared.create_list_of_values_cols(
 p_id=>wwv_flow_imp.id(14730986839101916)
,p_query_column_name=>'D_TYPE'
,p_heading=>'Type'
,p_display_sequence=>30
,p_data_type=>'VARCHAR2'
);
wwv_flow_imp_shared.create_list_of_values_cols(
 p_id=>wwv_flow_imp.id(14731324215101916)
,p_query_column_name=>'R'
,p_display_sequence=>40
,p_data_type=>'VARCHAR2'
,p_is_visible=>'N'
,p_is_searchable=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dg_create_bp_from_options
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(1691026444286284)
,p_lov_name=>'DG_CREATE_BP_FROM_OPTIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(1691026444286284)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558110
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1691380660286293)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Select from list'
,p_lov_return_value=>'SELECT'
,p_lov_template=>'<span class="a-Icon icon-item-native-select-list" aria-hidden="true"></span> #DISPLAY_VALUE#'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1691779030286294)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Copy and Paste'
,p_lov_return_value=>'COPY_PASTE'
,p_lov_template=>'<span class="a-Icon icon-clipboard" aria-hidden="true"></span> #DISPLAY_VALUE#'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dg_custom_data_sources
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(3401014796445463)
,p_lov_name=>'DG_CUSTOM_DATA_SOURCES'
,p_lov_query=>'.'||wwv_flow_imp.id(3401014796445463)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558110
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(3401363667445485)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Table'
,p_lov_return_value=>'TABLE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(3401708566445486)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'SQL Query'
,p_lov_return_value=>'SQL_QUERY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dg_data_source_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(1720919255102185)
,p_lov_name=>'DG_DATA_SOURCE_TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(1720919255102185)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558110
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1721265182102185)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Data Source'
,p_lov_return_value=>'DATA_SOURCE'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'  from wwv_dg_blueprint_data_sources',
' where blueprint_id = :P4004_BLUEPRINT_ID',
'   and security_group_id = :flow_security_group_id;'))
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1721632335102186)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Built In'
,p_lov_return_value=>'BUILTIN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1722059389102186)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Blueprint'
,p_lov_return_value=>'BLUEPRINT'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from wwv_dg_blueprint_tables t,',
'       wwv_dg_blueprints b',
' where ( :APP_PAGE_ID != ''4004''',
'         or ( b.id = t.blueprint_id',
'              and b.name = :P4004_BLUEPRINT_NAME',
'              and t.seq < :P4004_BLUEPRINT_TABLE_SEQ ) )',
'    and ( :APP_PAGE_ID != ''4100''',
'         or ( b.id = t.blueprint_id',
'              and b.name = :P4100_BLUEPRINT_NAME',
'              and t.seq < :P4100_BLUEPRINT_TABLE_SEQ ) )',
'    and b.security_group_id = :flow_security_group_id'))
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1722449832102186)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Inline'
,p_lov_return_value=>'INLINE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1722832097102186)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Sequence'
,p_lov_return_value=>'SEQUENCE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1723262358102186)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Formula'
,p_lov_return_value=>'FORMULA'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dg_file_output_formats
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(1710780100785805)
,p_lov_name=>'DG_FILE_OUTPUT_FORMATS'
,p_lov_query=>'.'||wwv_flow_imp.id(1710780100785805)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558110
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1711001076785837)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'JavaScript Object Notation (JSON)'
,p_lov_return_value=>'PRETTY JSON'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1711435829785838)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Comma Separated Values (CSV)'
,p_lov_return_value=>'CSV'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1711802215785838)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'SQL Insert'
,p_lov_return_value=>'SQL INSERT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dg_generated_data_options
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(1701812462624498)
,p_lov_name=>'DG_GENERATED_DATA_OPTIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(1701812462624498)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558110
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1702122524624504)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'File Export'
,p_lov_return_value=>'FILE_EXPORT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1702518857624504)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Insert Into Database'
,p_lov_return_value=>'INSERT_INTO_DATABASE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dg_insert_data_methods
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(2000148335668303)
,p_lov_name=>'DG_INSERT_DATA_METHODS'
,p_lov_query=>'.'||wwv_flow_imp.id(2000148335668303)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558110
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2001657267668307)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Insert Into'
,p_lov_return_value=>'INSERT INTO'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2002079039668308)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Fast Insert Into'
,p_lov_return_value=>'FAST INSERT INTO'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dg_languages
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(1787978077426546)
,p_lov_name=>'DG_LANGUAGES'
,p_lov_query=>'.'||wwv_flow_imp.id(1787978077426546)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558110
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1788244153426552)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'English'
,p_lov_return_value=>'en'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1788676820426553)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'German'
,p_lov_return_value=>'de'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1789016778426553)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Spanish'
,p_lov_return_value=>'es'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dg_scaling_options
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(1716336235087650)
,p_lov_name=>'DG_SCALING_OPTIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(1716336235087650)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558111
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1716607858087677)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'.25x'
,p_lov_return_value=>'25'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1717093746087677)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'.5x'
,p_lov_return_value=>'50'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1717482340087677)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'.75x'
,p_lov_return_value=>'75'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1717866167087678)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'1x'
,p_lov_return_value=>'100'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1718239401087678)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'2x'
,p_lov_return_value=>'200'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1718655207087678)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'3x'
,p_lov_return_value=>'300'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1719092203087678)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'5x'
,p_lov_return_value=>'500'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1719419850087678)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'10x'
,p_lov_return_value=>'1000'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1719862820087679)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'20x'
,p_lov_return_value=>'2000'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1720276552087679)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'50x'
,p_lov_return_value=>'5000'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1720618018087679)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>'100x'
,p_lov_return_value=>'10000'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dg_source_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(13808340560561616)
,p_lov_name=>'DG_SOURCE_TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(13808340560561616)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558112
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(13808619603561635)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Table'
,p_lov_return_value=>'TABLE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(13809059161561637)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'SQL Query'
,p_lov_return_value=>'SQL_QUERY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/display_inline
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(88029914736461415)
,p_lov_name=>'DISPLAY.INLINE'
,p_lov_query=>'.'||wwv_flow_imp.id(88029914736461415)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558112
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88030128904461415)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Display Inline'
,p_lov_return_value=>'DISPLAY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/display_as_reports
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(285136607862263925)
,p_lov_name=>'DISPLAY_AS_REPORTS'
,p_reference_id=>285506029323635827
,p_lov_query=>'.'||wwv_flow_imp.id(285136607862263925)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108084526445030643)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Standard Report Column (display-only, does not save state)'
,p_lov_return_value=>'WITHOUT_MODIFICATION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108084705562030643)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Display as Text (based on LOV, does not save state)'
,p_lov_return_value=>'TEXT_FROM_LOV'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108084932477030643)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Display as Text (saves state)'
,p_lov_return_value=>'DISPLAY_AND_SAVE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108085112395030643)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Display as Text (escape special characters, does not save state)'
,p_lov_return_value=>'ESCAPE_SC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108085330405030643)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>'Hidden '
,p_lov_return_value=>'HIDDEN'
);
end;
/
prompt --application/shared_components/user_interface/lovs/display_as_tabular_forms
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(173321532130152965)
,p_lov_name=>'DISPLAY_AS_TABULAR_FORMS'
,p_lov_query=>'.'||wwv_flow_imp.id(173321532130152965)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558112
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108070909691016343)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Standard Report Column (display-only, does not save state)'
,p_lov_return_value=>'WITHOUT_MODIFICATION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108071103633016343)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Display as Text (based on LOV, does not save state)'
,p_lov_return_value=>'TEXT_FROM_LOV'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108071320755016343)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Display as Text (saves state)'
,p_lov_return_value=>'DISPLAY_AND_SAVE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108071517893016343)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Display as Text (escape special characters, does not save state)'
,p_lov_return_value=>'ESCAPE_SC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108071726823016343)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Text Field'
,p_lov_return_value=>'TEXT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108071926389016343)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Text Area'
,p_lov_return_value=>'TEXTAREA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108072101156016343)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Select List'
,p_lov_return_value=>'SELECT_LIST_FROM_LOV'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108072319348016343)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Hidden '
,p_lov_return_value=>'HIDDEN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108072523666016343)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Popup LOV'
,p_lov_return_value=>'POPUP'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108072726301016343)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker'
,p_lov_return_value=>'DATE_POPUP'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108072902041016343)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (use application format mask)'
,p_lov_return_value=>'PICK_DATE_USING_APP_FORMAT_MASK'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108073114807016343)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (DD-MON-RR)'
,p_lov_return_value=>'PICK_DATE_DD_MON_RR'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108073320317016344)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (DD-MON-RR HH24:MI)'
,p_lov_return_value=>'PICK_DATE_DD_MON_RR_HH24_MI'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108073505124016344)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (DD-MON-RR HH:MI)'
,p_lov_return_value=>'PICK_DATE_DD_MON_RR_HH_MI'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108073706032016344)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (DD-MON-YY HH24:MI)'
,p_lov_return_value=>'PICK_DATE_DD_MON_YY_HH24_MI'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108073911349016344)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (DD-MON-YY HH:MI)'
,p_lov_return_value=>'PICK_DATE_DD_MON_YY_HH_MI'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108074115783016344)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (DD-MON-YYYY)'
,p_lov_return_value=>'PICK_DATE_DD_MON_YYYY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108074322493016344)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (DD-MON-YYYY HH24:MI)'
,p_lov_return_value=>'PICK_DATE_DD_MON_YYYY_HH24_MI'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108074521430016344)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (DD-MON-YYYY HH:MI)'
,p_lov_return_value=>'PICK_DATE_DD_MON_YYYY_HH_MI'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108074730419016344)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (DD-MON-YY)'
,p_lov_return_value=>'PICK_DATE_DD_MON_YY'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108074911008016344)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (DD/MM/YYYY)'
,p_lov_return_value=>'PICK_DATE_DD_MM_YYYY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108075100812016344)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (DD/MM/YYYY HH24:MI)'
,p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH24_MI'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108075332696016345)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (DD/MM/YYYY HH:MI)'
,p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH_MI'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108075516430016345)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (MM/DD/YYYY)'
,p_lov_return_value=>'PICK_DATE_MM_DD_YYYY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108075700209016345)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (MM/DD/YYYY HH24:MI)'
,p_lov_return_value=>'PICK_DATE_MM_DD_YYYY_HH24_MI'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108075913799016345)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (MM/DD/YYYY HH:MI)'
,p_lov_return_value=>'PICK_DATE_MM_DD_YYYY_HH_MI'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108076125223016345)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (RR-MON-DD)'
,p_lov_return_value=>'PICK_DATE_RR_MON_DD'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108076313464016345)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (RR-MON-DD HH24:MI)'
,p_lov_return_value=>'PICK_DATE_RR_MON_DD_HH24_MI'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108076515529016345)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (RR-MON-DD HH:MI)'
,p_lov_return_value=>'PICK_DATE_RR_MON_DD_HH_MI'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108076725453016345)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (YYYY-MM-DD)'
,p_lov_return_value=>'PICK_DATE_YYYY_MM_DD'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108076913772016345)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (YYYY-MM-DD HH24:MI)'
,p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_HH24_MI'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108077111031016345)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (YYYY-MM-DD HH:MI)'
,p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_HH_MI'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108077331467016345)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (DD-MM-YYYY)'
,p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_DASH'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108077528710016345)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (DD-MM-YYYY HH24:MI)'
,p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH24_MI_DASH'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108077720268016346)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (DD-MM-YYYY HH:MI)'
,p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH_MI_DASH'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108077923098016346)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (DD.MM.YYYY)'
,p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_DOT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108078110678016346)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (DD.MM.YYYY HH24:MI)'
,p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH24_MI_DOT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108078309308016346)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (DD.MM.YYYY HH:MI)'
,p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH_MI_DOT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108078528637016346)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (YYYY.DD.MM)'
,p_lov_return_value=>'PICK_DATE_YYYY_DD_MM_DOT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108078730750016346)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (YYYY.DD.MM HH24:MI)'
,p_lov_return_value=>'PICK_DATE_YYYY_DD_MM_HH24_MI_DOT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108078928693016346)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (YYYY.DD.MM HH:MI)'
,p_lov_return_value=>'PICK_DATE_YYYY_DD_MM_HH_MI_DOT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108079128762016346)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (YYYY/MM/DD)'
,p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_SLASH'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108079326218016346)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (YYYY/MM/DD HH24:MI)'
,p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_HH24_MI_SLASH'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108079524994016346)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (YYYY/MM/DD HH:MI)'
,p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_HH_MI_SLASH'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108079705480016346)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (use Application Date Format)'
,p_lov_return_value=>'PICK_DATE_USING_APP_DATE_FORMAT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/display_or_save
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(88028228457455927)
,p_lov_name=>'DISPLAY_OR_SAVE'
,p_lov_query=>'.'||wwv_flow_imp.id(88028228457455927)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558113
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88028407997455927)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Display Inline'
,p_lov_return_value=>'DISPLAY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88028614614455928)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Save As Script File'
,p_lov_return_value=>'SCRIPT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/distinct_columns
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(102422424410025075)
,p_lov_name=>'DISTINCT_COLUMNS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct :column_name',
'',
'from   :table_name',
'',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
,p_version_scn=>75558113
);
end;
/
prompt --application/shared_components/user_interface/lovs/dynamic_object_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(167453708814513863)
,p_lov_name=>'DYNAMIC OBJECT TYPES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct',
'       object_type d,',
'       object_type r',
' from sys.dba_objects where owner = :F4500_P500_SCHEMA',
'union  select ''DATABASE LINK'' d,''DATABASE LINK'' r from sys.dual',
'union  select ''TABLE'' d,''TABLE'' r from sys.dual',
'union  select ''TRIGGER'' d,''TRIGGER'' r from sys.dual',
'union  select ''JAVA CLASS'' d,''JAVA CLASS'' r from sys.dual',
'union  select ''JAVA SOURCE'' d,''JAVA SOURCE'' r from sys.dual',
'union  select ''INDEX'' d,''INDEX'' r from sys.dual',
'union  select ''SEQUENCE'' d,''SEQUENCE'' r from sys.dual',
'union  select ''FUNCTION'' d,''FUNCTION'' r from sys.dual',
'union  select ''PROCEDURE'' d,''PROCEDURE'' r from sys.dual',
'union  select ''PACKAGE'' d,''PACKAGE'' r from sys.dual',
'union  select ''PACKAGE BODY'' d,''PACKAGE BODY'' r from sys.dual',
'union  select ''XML SCHEMA'' d,''XML SCHEMA'' r from sys.dual',
'union  select ''TYPE'' d,''TYPE'' r from sys.dual',
'union  select ''VIEW'' d,''VIEW'' r from sys.dual',
'union  select ''MATERIALIZED VIEW'' d,''MATERIALIZED VIEW'' r from sys.dual',
'union  select ''SYNONYM'' d,''SYNONYM'' r from sys.dual',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
,p_version_scn=>75558113
);
end;
/
prompt --application/shared_components/user_interface/lovs/expire_password
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(7461015136055036)
,p_lov_name=>'EXPIRE PASSWORD'
,p_lov_query=>'.'||wwv_flow_imp.id(7461015136055036)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558113
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7461210075055051)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'&nbsp;'
,p_lov_return_value=>'EXPIRE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/for_each_row
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(88058923955804681)
,p_lov_name=>'FOR.EACH.ROW'
,p_lov_query=>'.'||wwv_flow_imp.id(88058923955804681)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558113
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88059109438804682)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'For Each Row'
,p_lov_return_value=>'for each row'
);
end;
/
prompt --application/shared_components/user_interface/lovs/format_mask_dynamic_from_4000
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(197481124765787930)
,p_lov_name=>'FORMAT_MASK_DYNAMIC (FROM 4000)'
,p_reference_id=>44798420131812391
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r ',
'  from wwv_flow_format_masks'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/format_mask_dynamic_dates_no_since_from_4000
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(460129911419159358)
,p_lov_name=>'FORMAT_MASK_DYNAMIC_DATES_NO_SINCE (FROM 4000)'
,p_reference_id=>170713321121898589
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r ',
'  from wwv_flow_format_masks',
' where t = ''D'''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/format_mask_dynamic_number_from_4000
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(460130116613160765)
,p_lov_name=>'FORMAT_MASK_DYNAMIC_NUMBER (FROM 4000)'
,p_reference_id=>441970320516445261
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r ',
'  from wwv_flow_format_masks',
' where t = ''N''',
''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/form_validation_data_type_from_4000
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(197595525878393704)
,p_lov_name=>'FORM_VALIDATION_DATA_TYPE (FROM 4000)'
,p_reference_id=>197490902498999083
,p_lov_query=>'.'||wwv_flow_imp.id(197595525878393704)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(197596203845396779)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'NUMBER'
,p_lov_return_value=>'NUMBER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(197596425687396780)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'VARCHAR'
,p_lov_return_value=>'VARCHAR'
);
end;
/
prompt --application/shared_components/user_interface/lovs/i18n_iana_charset
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(143356515285702408)
,p_lov_name=>'I18N_IANA_CHARSET'
,p_reference_id=>144796827445692396
,p_lov_query=>'.'||wwv_flow_imp.id(143356515285702408)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9229220048925457)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Arabic ISO-8859-6'
,p_lov_return_value=>'iso-8859-6'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9229405581925457)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Arabic Windows 1256'
,p_lov_return_value=>'windows-1256'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9229628588925457)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Chinese Big5'
,p_lov_return_value=>'big5'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9229827838925457)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Chinese GBK'
,p_lov_return_value=>'gbk'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9230014665925457)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Cyrilic ISO-8859-5'
,p_lov_return_value=>'iso-8859-5'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9230231223925457)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Cyrilic KOI8-R'
,p_lov_return_value=>'koi8-r'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9230421211925457)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Cyrilic KOI8-U'
,p_lov_return_value=>'koi8-u'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9230611952925457)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Cyrilic Windows 1251'
,p_lov_return_value=>'windows-1251'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9230825878925457)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Eastern European ISO-8859-2'
,p_lov_return_value=>'iso-8859-2'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9231020628925457)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Eastern European Windows 1250'
,p_lov_return_value=>'windows-1250'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9231210284925457)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Greek ISO-8859-7'
,p_lov_return_value=>'iso-8859-7'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9231417884925458)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Greek Windows 1253'
,p_lov_return_value=>'windows-1253'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9231628287925458)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Hebrew ISO-8859-8-i'
,p_lov_return_value=>'iso-8859-8-i'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9231830514925458)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Hebrew Windows 1255'
,p_lov_return_value=>'windows-1255'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9232010444925458)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Japanese EUC'
,p_lov_return_value=>'euc-jp'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9232217412925458)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Japanese Shift JIS'
,p_lov_return_value=>'shift_jis'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9232432569925458)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Korean EUC'
,p_lov_return_value=>'euc-kr'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9232618695925458)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Northern European ISO-8859-4'
,p_lov_return_value=>'iso-8859-4'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9232801800925458)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Northern European Windows 1257'
,p_lov_return_value=>'windows-1257'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9233008729925458)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Southern European ISO-8859-3'
,p_lov_return_value=>'iso-8859-3'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9233226333925458)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Thai TIS-620'
,p_lov_return_value=>'tis-620'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9233412235925458)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Turkish ISO-8859-9'
,p_lov_return_value=>'iso-8859-9'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9233629658925458)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Turkish Windows 1254'
,p_lov_return_value=>'windows-1254'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9233803634925458)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Unicode UTF-8'
,p_lov_return_value=>'utf-8'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9234002057925459)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Unicode UTF-16 Big Endian'
,p_lov_return_value=>'utf-16be'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9234209685925459)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Unicode UTF-16 Little Endian'
,p_lov_return_value=>'utf-16le'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9234405813925459)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'US-ASCII'
,p_lov_return_value=>'us-ascii'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9234624781925459)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Vietnamese Windows 1258'
,p_lov_return_value=>'windows-1258'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9234826068925459)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Western European ISO-8859-1'
,p_lov_return_value=>'iso-8859-1'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9235025977925459)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Western European Windows 1252'
,p_lov_return_value=>'windows-1252'
);
end;
/
prompt --application/shared_components/user_interface/lovs/i18n_iana_db_charset
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(143362112016702427)
,p_lov_name=>'I18N_IANA_DB_CHARSET'
,p_reference_id=>144802427115692411
,p_lov_query=>'.'||wwv_flow_imp.id(143362112016702427)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9197525868826969)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabic ISO-8859-6'
,p_lov_return_value=>'AR8ISO8859P6'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9197719499826969)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Arabic Windows 1256'
,p_lov_return_value=>'AR8MSWIN1256'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9197926602826969)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Chinese Big5'
,p_lov_return_value=>'ZHT16MSWIN950'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9198108871826969)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Chinese GBK'
,p_lov_return_value=>'ZHS16GBK'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9198314327826969)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'Cyrilic ISO-8859-5'
,p_lov_return_value=>'CL8ISO8859P5'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9198509701826969)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'Cyrilic KOI8-R'
,p_lov_return_value=>'CL8KOI8R'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9198725529826969)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'Cyrilic KOI8-U'
,p_lov_return_value=>'CL8KOI8U'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9198913491826970)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'Cyrilic Windows 1251'
,p_lov_return_value=>'CL8MSWIN1251'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9199128797826970)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'Eastern European ISO-8859-2'
,p_lov_return_value=>'EE8ISO8859P2'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9199323295826970)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'Eastern European Windows 1250'
,p_lov_return_value=>'EE8MSWIN1250'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9199525603826970)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>'Greek ISO-8859-7'
,p_lov_return_value=>'EL8ISO8859P7'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9199710618826970)
,p_lov_disp_sequence=>120
,p_lov_disp_value=>'Greek Windows 1253'
,p_lov_return_value=>'EL8MSWIN1253'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9199917873826970)
,p_lov_disp_sequence=>130
,p_lov_disp_value=>'Hebrew ISO-8859-8-i'
,p_lov_return_value=>'IW8ISO8859P8'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9200124476826971)
,p_lov_disp_sequence=>140
,p_lov_disp_value=>'Hebrew Windows 1255'
,p_lov_return_value=>'IW8MSWIN1255'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9200304639826971)
,p_lov_disp_sequence=>150
,p_lov_disp_value=>'Japanese EUC'
,p_lov_return_value=>'JA16EUC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9200514410826971)
,p_lov_disp_sequence=>160
,p_lov_disp_value=>'Japanese Shift JIS'
,p_lov_return_value=>'JA16SJIS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9200704239826971)
,p_lov_disp_sequence=>170
,p_lov_disp_value=>'Korean EUC'
,p_lov_return_value=>'KO16MSWIN949'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9200903786826971)
,p_lov_disp_sequence=>180
,p_lov_disp_value=>'Northern European ISO-8859-4'
,p_lov_return_value=>'NEE8ISO8859P4'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9201130515826971)
,p_lov_disp_sequence=>190
,p_lov_disp_value=>'Northern European Windows 1257'
,p_lov_return_value=>'BLT8MSWIN1257'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9201303279826971)
,p_lov_disp_sequence=>200
,p_lov_disp_value=>'Southern European ISO-8859-3'
,p_lov_return_value=>'SE8ISO8859P3'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9201518062826971)
,p_lov_disp_sequence=>210
,p_lov_disp_value=>'Thai TIS-620'
,p_lov_return_value=>'TH8TISASCII'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9201729626826971)
,p_lov_disp_sequence=>220
,p_lov_disp_value=>'Turkish ISO-8859-9'
,p_lov_return_value=>'WE8ISO8859P9'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9201928057826971)
,p_lov_disp_sequence=>230
,p_lov_disp_value=>'Turkish Windows 1254'
,p_lov_return_value=>'TR8MSWIN1254'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9202110863826971)
,p_lov_disp_sequence=>240
,p_lov_disp_value=>'Unicode UTF-8'
,p_lov_return_value=>'AL32UTF8'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9202305353826971)
,p_lov_disp_sequence=>242
,p_lov_disp_value=>'Unicode UTF-16 Big Endian'
,p_lov_return_value=>'AL16UTF16'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9202522080826972)
,p_lov_disp_sequence=>244
,p_lov_disp_value=>'Unicode UTF-16 Little Endian'
,p_lov_return_value=>'AL16UTF16LE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9202732398826972)
,p_lov_disp_sequence=>248
,p_lov_disp_value=>'US-ASCII'
,p_lov_return_value=>'US7ASCII'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9202914568826972)
,p_lov_disp_sequence=>250
,p_lov_disp_value=>'Vietnamese Windows 1258'
,p_lov_return_value=>'VN8MSWIN1258'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9203117480826972)
,p_lov_disp_sequence=>260
,p_lov_disp_value=>'Western European ISO-8859-1'
,p_lov_return_value=>'WE8ISO8859P1'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9203309867826972)
,p_lov_disp_sequence=>270
,p_lov_disp_value=>'Western European Windows 1252'
,p_lov_return_value=>'WE8MSWIN1252'
);
end;
/
prompt --application/shared_components/user_interface/lovs/icon_detail_view_modes
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(144167830179232748)
,p_lov_name=>'ICON DETAIL VIEW MODES'
,p_reference_id=>116048926655714272
,p_lov_query=>'.'||wwv_flow_imp.id(144167830179232748)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(240823626953628604)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Icons'
,p_lov_return_value=>'ICON'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(240823804523628605)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Details'
,p_lov_return_value=>'DETAIL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/identity_options
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(254185527365105468)
,p_lov_name=>'IDENTITY_OPTIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(254185527365105468)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558117
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(254185828755105469)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Always'
,p_lov_return_value=>'A'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(254186111548105469)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Default'
,p_lov_return_value=>'D'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(254186405911105469)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Default on Null'
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/include_args_y
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(88064701145826564)
,p_lov_name=>'INCLUDE.ARGS.Y'
,p_lov_query=>'.'||wwv_flow_imp.id(88064701145826564)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558117
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88064927960826565)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Include Arguments'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/intra_component_navigator
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(1457916849659682)
,p_lov_name=>'INTRA COMPONENT NAVIGATOR'
,p_lov_query=>'.'||wwv_flow_imp.id(1457916849659682)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558117
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1458119331659683)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Object Browser'
,p_lov_return_value=>'1001'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1458304212659683)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'SQL Commands'
,p_lov_return_value=>'1003'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1458524645659683)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'SQL Scripts'
,p_lov_return_value=>'1004'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1458701375659683)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Query Builder'
,p_lov_return_value=>'1002'
);
end;
/
prompt --application/shared_components/user_interface/lovs/item_types_without_plugins
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(29577622544843540)
,p_lov_name=>'ITEM_TYPES (WITHOUT PLUGINS)'
,p_reference_id=>29544521926748713
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_native_plugins varchar2(255);',
'begin',
'    l_native_plugins := '' union all select display_name as d, name_with_prefix as r from wwv_flow_native_plugins where plugin_type = ''''ITEM TYPE'''' order by 1'';',
'',
'    if lower(wwv_flow.g_flow_language) = ''en'' then',
'        return ''select display_name as d, name as r from wwv_flow_standard_item_types''||l_native_plugins;',
'    else',
'        return ''select wwv_flow_lang.system_message(''''ITEM_TYPE.''''||name) as d, name as r from wwv_flow_standard_item_types''||l_native_plugins;',
'    end if;',
'end;'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/language_selector
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(111525828615050878)
,p_lov_name=>'LANGUAGE_SELECTOR'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''en'' d, ''en'' r',
'  from sys.dual',
'union ',
'select flow_language d, flow_language r',
'  from wwv_flows',
' where id in ',
' (select translation_flow_id',
'    from wwv_flow_language_map',
'   where primary_language_flow_id = v(''APP_ID''))',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
,p_version_scn=>75558117
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_all_schemas
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(26396713461308449)
,p_lov_name=>'LIST_ALL_SCHEMAS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select username d, username v',
'from sys.dba_users ',
'where wwv_flow_provisioning.restricted_schema_i(username,:APP_USER) = 0',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
,p_version_scn=>75558117
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_available_schemas
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(64015215313088942)
,p_lov_name=>'LIST_AVAILABLE_SCHEMAS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html( c.schema ) d,',
'       c.schema v ',
'  from wwv_flow_company_schemas c, ',
'       wwv_flow_fnd_user u',
' where c.security_group_id = :FLOW_SECURITY_GROUP_ID',
'   and u.security_group_id = :FLOW_SECURITY_GROUP_ID  ',
'   and u.user_name         = :FLOW_USER   ',
'   and ( u.allow_access_to_schemas is null or ',
'         instr( '':'' || u.allow_access_to_schemas || '':'' , '':'' || c.schema || '':'' ) > 0 )',
' order by 1'))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_use_local_sync_table=>false
,p_return_column_name=>'V'
,p_display_column_name=>'D'
,p_group_sort_direction=>'ASC'
,p_default_sort_direction=>'ASC'
,p_version_scn=>75558117
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_available_schemas_qb
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(14016705748242026)
,p_lov_name=>'LIST_AVAILABLE_SCHEMAS-QB'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html( c.schema ) d,',
'       c.schema v',
'  from wwv_flow_company_schemas c,',
'       wwv_flow_fnd_user u',
' where c.security_group_id = :FLOW_SECURITY_GROUP_ID',
'   and u.security_group_id = :FLOW_SECURITY_GROUP_ID',
'   and u.user_name         = :FLOW_USER',
'   and ( u.allow_access_to_schemas is null or',
'         instr( '':'' || u.allow_access_to_schemas || '':'' , '':'' || c.schema || '':'' ) > 0 )',
'   and nvl( :P1002_POPUP , 0 ) <> 1',
' union all ',
'select wwv_flow_escape.html( :P1002_SCHEMA ) d,',
'       :P1002_SCHEMA v',
'  from sys.dual',
' where :P1002_POPUP = 1',
' order by 1'))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_use_local_sync_table=>false
,p_return_column_name=>'V'
,p_display_column_name=>'D'
,p_group_sort_direction=>'ASC'
,p_default_sort_direction=>'ASC'
,p_version_scn=>75558117
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_available_schemas_sc
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(23001304041139468)
,p_lov_name=>'LIST_AVAILABLE_SCHEMAS-SC'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html( c.schema ) d,',
'       c.schema v',
'  from wwv_flow_company_schemas c,',
'       wwv_flow_fnd_user u',
' where c.security_group_id = :FLOW_SECURITY_GROUP_ID',
'   and u.security_group_id = :FLOW_SECURITY_GROUP_ID',
'   and u.user_name         = :FLOW_USER',
'   and ( u.allow_access_to_schemas is null or',
'         instr( '':'' || u.allow_access_to_schemas || '':'' , '':'' || c.schema || '':'' ) > 0 )',
'   and nvl( :P1003_POPUP , 0 ) <> 1',
' union all ',
'select wwv_flow_escape.html( :P1003_SCHEMA ) d,',
'       :P1003_SCHEMA v',
'  from sys.dual',
' where :P1003_POPUP = 1',
' order by 1'))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_use_local_sync_table=>false
,p_return_column_name=>'V'
,p_display_column_name=>'D'
,p_group_sort_direction=>'ASC'
,p_default_sort_direction=>'ASC'
,p_version_scn=>75558117
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_users
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(96930227515507687)
,p_lov_name=>'LIST_USERS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''- '' || wwv_flow_lang.system_message(''ALL_USERS'') || '' -'' d, ''0'' r',
'  from sys.dual',
' where exists (',
'    select null',
'      from  wwv_flow_developers ',
'     where security_group_id = :flow_security_group_id ',
'       and userid = :flow_user ',
'       and instr(developer_role||'':'',''ADMIN:'') > 0)',
'union all',
'select user_name d, user_name r',
'  from wwv_flow_fnd_user',
' where security_group_id = :flow_security_group_id',
'   and (user_name = :flow_user or exists',
'        (select null from wwv_flow_developers',
'          where security_group_id = :flow_security_group_id',
'            and userid = :flow_user',
'            and instr(developer_role||'':'',''ADMIN:'') > 0))',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
,p_version_scn=>75558117
);
end;
/
prompt --application/shared_components/user_interface/lovs/login_message
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(21459801069722432)
,p_lov_name=>'LOGIN_MESSAGE'
,p_lov_query=>'.'||wwv_flow_imp.id(21459801069722432)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558117
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(21460014390722445)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'No Message'
,p_lov_return_value=>'NONE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(21460423875722448)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Custom Message'
,p_lov_return_value=>'CUSTOM'
);
end;
/
prompt --application/shared_components/user_interface/lovs/lov_objectstore_references
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(2126335033862968)
,p_lov_name=>'LOV_OBJECTSTORE_REFERENCES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id, name, base_url, cloud_credential_name from wwv_remote_servers',
'where security_group_id = :WORKSPACE_ID',
'and server_type = ''CLOUD_OBJECT_STORE'''))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_return_column_name=>'ID'
,p_display_column_name=>'NAME'
,p_group_sort_direction=>'ASC'
,p_default_sort_column_name=>'NAME'
,p_default_sort_direction=>'ASC'
,p_version_scn=>75558117
);
wwv_flow_imp_shared.create_list_of_values_cols(
 p_id=>wwv_flow_imp.id(2127071488865633)
,p_query_column_name=>'ID'
,p_display_sequence=>10
,p_data_type=>'NUMBER'
,p_is_visible=>'N'
,p_is_searchable=>'N'
);
wwv_flow_imp_shared.create_list_of_values_cols(
 p_id=>wwv_flow_imp.id(2127437388865635)
,p_query_column_name=>'NAME'
,p_heading=>'Name'
,p_display_sequence=>20
,p_data_type=>'VARCHAR2'
);
wwv_flow_imp_shared.create_list_of_values_cols(
 p_id=>wwv_flow_imp.id(2127806644865636)
,p_query_column_name=>'BASE_URL'
,p_heading=>'URL'
,p_display_sequence=>30
,p_data_type=>'VARCHAR2'
);
wwv_flow_imp_shared.create_list_of_values_cols(
 p_id=>wwv_flow_imp.id(2128268586865636)
,p_query_column_name=>'CLOUD_CREDENTIAL_NAME'
,p_heading=>'DBMS_CLOUD Credential'
,p_display_sequence=>40
,p_data_type=>'VARCHAR2'
);
end;
/
prompt --application/shared_components/user_interface/lovs/manage_table_constraints
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(165911414842182864)
,p_lov_name=>'MANAGE.TABLE.CONSTRAINTS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(c.constraint_name) d,  c.constraint_name r',
'from sys.dba_constraints c, sys.dba_cons_columns l',
'where c.table_name = :OBJECT_NAME',
'and c.owner = :OBJECT_OWNER',
'and c.constraint_type in (''P'',''U'',''C'',''R'')',
'and c.constraint_name = l.constraint_name ',
'and l.owner = :OBJECT_OWNER',
'and l.table_name = :OBJECT_NAME',
'and (l.position = 1 or l.position is null)',
'and c.status = ''ENABLED''',
'order by c.constraint_name, c.constraint_type, l.position'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
,p_version_scn=>75558117
);
end;
/
prompt --application/shared_components/user_interface/lovs/max_rows_a
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(88005728392276151)
,p_lov_name=>'MAX_ROWS_A'
,p_lov_query=>'.'||wwv_flow_imp.id(88005728392276151)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558117
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88005902539276153)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'10'
,p_lov_return_value=>'10'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88006132674276154)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'15'
,p_lov_return_value=>'15'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88006303849276154)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'20'
,p_lov_return_value=>'20'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88006502528276154)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'30'
,p_lov_return_value=>'30'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88006721789276154)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'50'
,p_lov_return_value=>'50'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88006905692276155)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'100'
,p_lov_return_value=>'100'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88007113392276155)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'200'
,p_lov_return_value=>'200'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88007318997276155)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'500'
,p_lov_return_value=>'500'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88007513744276155)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'1000'
,p_lov_return_value=>'1000'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(182328908607767113)
,p_lov_disp_sequence=>5000
,p_lov_disp_value=>'5000'
,p_lov_return_value=>'5000'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(260332524931295254)
,p_lov_disp_sequence=>10000
,p_lov_disp_value=>'10000'
,p_lov_return_value=>'10000'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(260332828394296254)
,p_lov_disp_sequence=>100000
,p_lov_disp_value=>'100000'
,p_lov_return_value=>'100000'
);
end;
/
prompt --application/shared_components/user_interface/lovs/max_rows_b
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(88008910861280555)
,p_lov_name=>'MAX_ROWS_B'
,p_lov_query=>'.'||wwv_flow_imp.id(88008910861280555)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558117
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(183741320426917019)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'5'
,p_lov_return_value=>'5'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88009125818280556)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'10'
,p_lov_return_value=>'10'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88009318636280556)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'15'
,p_lov_return_value=>'15'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88009527364280557)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'20'
,p_lov_return_value=>'20'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88009708671280557)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'30'
,p_lov_return_value=>'30'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88009918679280557)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'50'
,p_lov_return_value=>'50'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88010107969280558)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'100'
,p_lov_return_value=>'100'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88010312982280558)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'200'
,p_lov_return_value=>'200'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88010525571280558)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'500'
,p_lov_return_value=>'500'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88010713109280558)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'1000'
,p_lov_return_value=>'1000'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88010919618280559)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'5000'
,p_lov_return_value=>'5000'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88011124222280559)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>'10000'
,p_lov_return_value=>'10000'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88011310169280559)
,p_lov_disp_sequence=>120
,p_lov_disp_value=>'50000'
,p_lov_return_value=>'50000'
);
end;
/
prompt --application/shared_components/user_interface/lovs/more_less_columns
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(161595731562973452)
,p_lov_name=>'MORE_LESS_COLUMNS'
,p_lov_query=>'.'||wwv_flow_imp.id(161595731562973452)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558117
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(161595917373973455)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'More Columns'
,p_lov_return_value=>'MORE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(161596108445973460)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Fewer Columns'
,p_lov_return_value=>'LESS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/my_job
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(88020412686337805)
,p_lov_name=>'MY.JOB'
,p_lov_query=>'.'||wwv_flow_imp.id(88020412686337805)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558117
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88020600548337806)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'My Jobs'
,p_lov_return_value=>'my_job'
);
end;
/
prompt --application/shared_components/user_interface/lovs/null_notnull
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(88038204225524574)
,p_lov_name=>'NULL.NOTNULL'
,p_lov_query=>'.'||wwv_flow_imp.id(88038204225524574)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558117
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88038423679524575)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'NOT NULL (require a value)'
,p_lov_return_value=>'NOT NULL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88038631515524575)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'NULL (do not require a value)'
,p_lov_return_value=>'NULL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/object_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(88081132547977521)
,p_lov_name=>'OBJECT.TYPES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select initcap(wwv_flow_lang.system_message(''FUNCTION'')) d, ''98'' r from sys.dual union all',
'select initcap(wwv_flow_lang.system_message(''INDEX'')) d, ''INDEX'' r from sys.dual union all     ',
'select initcap(wwv_flow_lang.system_message(''PACKAGE'')) d, ''117'' r from sys.dual union all     ',
'select initcap(wwv_flow_lang.system_message(''PROCEDURE'')) d, ''121'' r from sys.dual union all     ',
'select initcap(wwv_flow_lang.system_message(''SEQUENCE'')) d, ''97'' r from sys.dual union all     ',
'select initcap(wwv_flow_lang.system_message(''SYNONYM'')) d, ''99'' r from sys.dual union all     ',
'select initcap(wwv_flow_lang.system_message(''TABLE'')) d, ''600'' r from sys.dual union all     ',
'select initcap(wwv_flow_lang.system_message(''TRIGGER'')) d, ''TRIGGER'' r from sys.dual union all     ',
'select initcap(wwv_flow_lang.system_message(''VIEW'')) d, ''48'' r from sys.dual',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
,p_version_scn=>75558117
);
end;
/
prompt --application/shared_components/user_interface/lovs/object_types_with_images2
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(161349613017569311)
,p_lov_name=>'OBJECT.TYPES.WITH.IMAGES2'
,p_lov_query=>'.'||wwv_flow_imp.id(161349613017569311)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558117
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(161349926473569318)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Function'
,p_lov_return_value=>'98'
,p_lov_template=>'#DISPLAY_VALUE#<br /><a style="padding-left:20px;" href="f?p=4500:98:&SESSION.::NO:98,107,100:P81_CREATE_OBJECT_TYPE:98"><img src="#IMAGE_PREFIX#htmldb/builder/function.gif" width="54" height="43" title="#DISPLAY_VALUE#" alt="#DISPLAY_VALUE" /></a>'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(161350104339569322)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Index'
,p_lov_return_value=>'INDEX'
,p_lov_template=>'#DISPLAY_VALUE#<br /><a style="padding-left:20px;" href="f?p=4500:56:&SESSION.:index:NO:57:P70_ACTION,P81_CREATE_OBJECT_TYPE:INDEX,INDEX"><img src="#IMAGE_PREFIX#htmldb/builder/index.gif" width="54" height="43" title="#DISPLAY_VALUE#" alt="#DISPLAY_V'
||'ALUE#" /></a>'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(161350313495569322)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Package'
,p_lov_return_value=>'117'
,p_lov_template=>'#DISPLAY_VALUE#<br /><a style="padding-left:20px;" href="f?p=4500:117:&SESSION.::NO:117,118,120:P81_CREATE_OBJECT_TYPE:117"><img src="#IMAGE_PREFIX#htmldb/builder/package.gif" width="58" height="38" title="#DISPLAY_VALUE#" alt="#DISPLAY_VALUE#" /></a'
||'>'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(161350510273569323)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Procedure'
,p_lov_return_value=>'121'
,p_lov_template=>'#DISPLAY_VALUE#<br /><a style="padding-left:20px;" href="f?p=4500:121:&SESSION.::NO:121,122,123:P81_CREATE_OBJECT_TYPE:121"><img src="#IMAGE_PREFIX#htmldb/builder/procedure.gif" width="58" height="38" title="#DISPLAY_VALUE#" alt="#DISPLAY_VALUE#" /><'
||'/a>'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(161350704929569323)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Sequence'
,p_lov_return_value=>'97'
,p_lov_template=>'#DISPLAY_VALUE#<br /><a style="padding-left:20px;" href="f?p=4500:97:&SESSION.::NO:97:P81_CREATE_OBJECT_TYPE:97"><img src="#IMAGE_PREFIX#htmldb/builder/sequence.gif" width="54" height="43" title="#DISPLAY_VALUE#" alt="#DISPLAY_VALUE#" /></a>'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(161350927921569323)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Synonym'
,p_lov_return_value=>'99'
,p_lov_template=>'#DISPLAY_VALUE#<br /><a style="padding-left:20px;" href="f?p=4500:99:&SESSION.::NO:99:P81_CREATE_OBJECT_TYPE:99"><img src="#IMAGE_PREFIX#htmldb/builder/synonym.gif" width="54" height="43" title="#DISPLAY_VALUE#" alt="#DISPLAY_VALUE#" /></a>'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(161351109256569323)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'Table'
,p_lov_return_value=>'TABLE_CREATE'
,p_lov_template=>'#DISPLAY_VALUE#<br /><a style="padding-left:20px;" href="f?p=4500:TABLE_CREATE:&SESSION.::NO:602,604,612:P81_CREATE_OBJECT_TYPE:600"><img src="#IMAGE_PREFIX#htmldb/builder/table.gif" width="54" height="43" title="#DISPLAY_VALUE#" alt="#DISPLAY_VALUE#'
||'" /></a>'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(161351331481569324)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'Trigger'
,p_lov_return_value=>'TRIGGER'
,p_lov_template=>'#DISPLAY_VALUE#<br /><a style="padding-left:20px;" href="f?p=4500:3:&SESSION.:triger:NO:3::"><img src="#IMAGE_PREFIX#htmldb/builder/trigger.gif" width="54" height="43" title="#DISPLAY_VALUE#" alt="#DISPLAY_VALUE#" /></a>'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(161351517964569324)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'View'
,p_lov_return_value=>'48'
,p_lov_template=>'#DISPLAY_VALUE#<br /><a style="padding-left:20px;" href="f?p=4500:48:&SESSION.::NO:48:P81_CREATE_OBJECT_TYPE:48"><img src="#IMAGE_PREFIX#htmldb/builder/view.gif" width="54" height="43" title="#DISPLAY_VALUE#" alt="#DISPLAY_VALUE#" /></a>'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(161351731977569324)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Database Link'
,p_lov_return_value=>'91'
,p_lov_template=>'#DISPLAY_VALUE#<br /><a style="padding-left:20px;" href="f?p=4500:91:&SESSION.::NO:91:P81_CREATE_OBJECT_TYPE:91"><img src="#IMAGE_PREFIX#htmldb/builder/dblink.gif" width="54" height="43" title="#DISPLAY_VALUE#" alt="#DISPLAY_VALUE#" /></a>'
);
end;
/
prompt --application/shared_components/user_interface/lovs/object_types2
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(88087713200000281)
,p_lov_name=>'OBJECT.TYPES2'
,p_lov_query=>'.'||wwv_flow_imp.id(88087713200000281)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558118
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88087913591000281)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Columns'
,p_lov_return_value=>'Columns'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88088111508000282)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Packages'
,p_lov_return_value=>'Packages'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88088331361000282)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Procedures/Functions'
,p_lov_return_value=>'Procedures/Functions'
);
end;
/
prompt --application/shared_components/user_interface/lovs/object_types3
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(149192410304386529)
,p_lov_name=>'OBJECT.TYPES3'
,p_lov_query=>'.'||wwv_flow_imp.id(149192410304386529)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558118
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(149192703287386532)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Function'
,p_lov_return_value=>'FUNCTION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(149192916678386534)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Index'
,p_lov_return_value=>'INDEX'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(149193104939386534)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Package'
,p_lov_return_value=>'PACKAGE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(149193312103386534)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Procedure'
,p_lov_return_value=>'PROCEDURE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(149193514215386535)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Sequence'
,p_lov_return_value=>'SEQUENCE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(149193711471386535)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Synonym'
,p_lov_return_value=>'SYNONYM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(149193923583386535)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'Table'
,p_lov_return_value=>'TABLE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(149194128979386535)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'Trigger'
,p_lov_return_value=>'TRIGGER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(149194306560386535)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'View'
,p_lov_return_value=>'VIEW'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(106105223193950457)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Database Link'
,p_lov_return_value=>'DATABASE LINK'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(109308316213864971)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>'Type'
,p_lov_return_value=>'TYPE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(109321428942887516)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>'Materialized View'
,p_lov_return_value=>'MATERIALIZED VIEW'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ob_create_table_handler
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(17956529721028277)
,p_lov_name=>'OB_CREATE_TABLE_HANDLER'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select object_name d, object_name r',
'from sys.dba_objects',
'where owner = :P120_PARSING_SCHEMA ',
'and object_type in (''TABLE'')',
'and object_name not like ''BIN$%'' ',
'and object_name not like ''DR$%'' ',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
,p_version_scn=>75558119
);
end;
/
prompt --application/shared_components/user_interface/lovs/ob_cycle
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(276749314239737540)
,p_lov_name=>'OB_CYCLE'
,p_lov_query=>'.'||wwv_flow_imp.id(276749314239737540)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558119
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(276749519233737542)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Cycle'
,p_lov_return_value=>'CYCLE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ob_order
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(276750123935740352)
,p_lov_name=>'OB_ORDER'
,p_lov_query=>'.'||wwv_flow_imp.id(276750123935740352)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558119
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(276750313195740352)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Order'
,p_lov_return_value=>'ORDER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/on_delete_cascade_y
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(88046110159554703)
,p_lov_name=>'ON.DELETE.CASCADE.Y'
,p_lov_query=>'.'||wwv_flow_imp.id(88046110159554703)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558119
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88046324301554704)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'On Delete Cascade'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/order_by
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(88015211732318611)
,p_lov_name=>'ORDER.BY'
,p_lov_query=>'.'||wwv_flow_imp.id(88015211732318611)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558119
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88015409187318612)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Title'
,p_lov_return_value=>'title'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88015624432318612)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
'File Name'))
,p_lov_return_value=>'filename'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88015826924318612)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
'Created Asc'))
,p_lov_return_value=>'created_on'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88016003779318613)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
'Created Desc'))
,p_lov_return_value=>'created_on desc'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88016226006318613)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
'Created By'))
,p_lov_return_value=>'created_by'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88016402368318613)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
'Size Asc'))
,p_lov_return_value=>'doc_size'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88016613155318613)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
'Size Desc'))
,p_lov_return_value=>'doc_size desc'
);
end;
/
prompt --application/shared_components/user_interface/lovs/output_format
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(88012712031290348)
,p_lov_name=>'OUTPUT.FORMAT'
,p_lov_query=>'.'||wwv_flow_imp.id(88012712031290348)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558119
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88012904683290349)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'HTML'
,p_lov_return_value=>'HTML'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88013100776290349)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Excel'
,p_lov_return_value=>'EXCEL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1000_show
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(184589019269022599)
,p_lov_name=>'P1000 SHOW'
,p_lov_query=>'.'||wwv_flow_imp.id(184589019269022599)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558119
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(184589207940022600)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'All'
,p_lov_return_value=>'ALL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(184589426163022602)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'My Assignments'
,p_lov_return_value=>'MINE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(184593723631288771)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'My Open'
,p_lov_return_value=>'MY_OPEN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(184593319129287486)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'All Open'
,p_lov_return_value=>'ALL_OPEN'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1004_show_results
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(179031515879675216)
,p_lov_name=>'P1004_SHOW_RESULTS'
,p_lov_query=>'.'||wwv_flow_imp.id(179031515879675216)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558119
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(179031709094675217)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Show Results'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p101_columns
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(150992731358804903)
,p_lov_name=>'P101_COLUMNS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(t.column_name)||'' - ''||lower(t.data_type) d, ',
'       t.column_name r',
'from   sys.dba_tab_columns t',
'where              ',
'      t.table_name = :P101_TABLE_NAME',
'  and t.owner = :P101_TABLE_OWNER and',
'      (nvl(:P101_SHOW,''1'') = ''1'' or t.data_type in (''VARCHAR'',''VARCHAR2'')) and column_id is not null',
'order by t.column_id'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
,p_version_scn=>75558119
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1101_audit_col_options
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(561151526618018480)
,p_lov_name=>'P1101_AUDIT_COL_OPTIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(561151526618018480)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558119
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(561151855252018480)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Audit Columns'
,p_lov_return_value=>'AUDIT_COLS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(561152288785018481)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Row Version Number'
,p_lov_return_value=>'ROW_VERSION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(561152614552018481)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Row Key'
,p_lov_return_value=>'ROW_KEY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1101_date_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(561155009716075756)
,p_lov_name=>'P1101_DATE_TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(561155009716075756)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558119
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(561155337871075756)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'DATE'
,p_lov_return_value=>'DATE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(561155720392075757)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'TIMESTAMP'
,p_lov_return_value=>'TIMESTAMP'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(561156148788075757)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'TIMESTAMP WITH TIME ZONE'
,p_lov_return_value=>'TIMESTAMP WITH TIME ZONE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(561156516823075757)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'TIMESTAMP WITH LOCAL TIME ZONE'
,p_lov_return_value=>'TIMESTAMP WITH LOCAL TIME ZONE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1101_db_version
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(561159215572120923)
,p_lov_name=>'P1101_DB_VERSION'
,p_lov_query=>'.'||wwv_flow_imp.id(561159215572120923)||'.'
,p_location=>'STATIC'
,p_version_scn=>21913766
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(616271032412133442)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'23ai'
,p_lov_return_value=>'23'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4401205819200657)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'21c'
,p_lov_return_value=>'21c'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(561159550831120924)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'19c'
,p_lov_return_value=>'19c'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1101_length_semantics
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(561157497023099105)
,p_lov_name=>'P1101_LENGTH_SEMANTICS'
,p_lov_query=>'.'||wwv_flow_imp.id(561157497023099105)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558120
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(561157786208099106)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Default'
,p_lov_return_value=>'DEFAULT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(561158557818099106)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'CHAR'
,p_lov_return_value=>'CHAR'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(561158130042099106)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'BYTE'
,p_lov_return_value=>'BYTE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1101_on_delete
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(561149224457990543)
,p_lov_name=>'P1101_ON_DELETE'
,p_lov_query=>'.'||wwv_flow_imp.id(561149224457990543)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558120
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(561149574178990543)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Cascade'
,p_lov_return_value=>'CASCADE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(561149925686990545)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Restrict'
,p_lov_return_value=>'RESTRICT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(561150376364990545)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Set Null'
,p_lov_return_value=>'SET NULL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1101_trigger_method
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(561153525630044678)
,p_lov_name=>'P1101_TRIGGER_METHOD'
,p_lov_query=>'.'||wwv_flow_imp.id(561153525630044678)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558120
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(561153872500044678)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'SYS_GUID'
,p_lov_return_value=>'GUID'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(561154212975044678)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Identity Column'
,p_lov_return_value=>'IDENTITY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(244368349049855044)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Sequence'
,p_lov_return_value=>'SEQ'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(122155829515030912)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'None'
,p_lov_return_value=>'NONE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1220_script_files
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(12563519145254272)
,p_lov_name=>'P1220_SCRIPT_FILES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct f.filename, f.id',
'from wwv_flow_files f, wwv_flow_sw_results r',
'where f.id = r.file_id ',
'and f.file_type = ''SCRIPT''',
'and (nvl(:P1220_SHOW,''0'') = ''0'' or run_by = :P1220_SHOW)',
'order by f.filename'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
,p_version_scn=>75558120
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1301_session_opts
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(26561807054435939)
,p_lov_name=>'P1301_SESSION_OPTS'
,p_lov_query=>'.'||wwv_flow_imp.id(26561807054435939)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558120
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(26562005235435939)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'ALL'
,p_lov_return_value=>'ALL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(26562200440435942)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Successful Sessions'
,p_lov_return_value=>'SUC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(26562427473435942)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Failed Sessions'
,p_lov_return_value=>'FAIL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1302_sesopt
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(26247521414208435)
,p_lov_name=>'P1302_SESOPT'
,p_lov_query=>'.'||wwv_flow_imp.id(26247521414208435)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558120
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(26247711140208437)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'ALL'
,p_lov_return_value=>'ALL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(26247917746208441)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Successful Login'
,p_lov_return_value=>'SUC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(26248104479208441)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Failed Login'
,p_lov_return_value=>'FAIL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p2000_comment_on
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(2382418254873350)
,p_lov_name=>'P2000_COMMENT_ON'
,p_lov_query=>'.'||wwv_flow_imp.id(2382418254873350)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558121
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2382773415873350)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Table'
,p_lov_return_value=>'T'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2383112884873350)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Column'
,p_lov_return_value=>'C'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p2000_constraint_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(6047691541572644)
,p_lov_name=>'P2000_CONSTRAINT_TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(6047691541572644)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558121
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(6047948636572648)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Check'
,p_lov_return_value=>'CHECK'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(6048385917572650)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Foreign Key'
,p_lov_return_value=>'FOREIGN KEY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(6048730362572650)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Primary Key'
,p_lov_return_value=>'PRIMARY KEY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(6049141161572650)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Unique'
,p_lov_return_value=>'UNIQUE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p2000_dummy
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(21051579869086845)
,p_lov_name=>'P2000_DUMMY'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null d, null r',
'  from sys.dual',
' where 1=2'))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_return_column_name=>'R'
,p_display_column_name=>'D'
,p_default_sort_column_name=>'D'
,p_default_sort_direction=>'ASC'
,p_version_scn=>75558121
);
end;
/
prompt --application/shared_components/user_interface/lovs/p2000_filter_operation
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(2377428328828737)
,p_lov_name=>'P2000_FILTER_OPERATION'
,p_lov_query=>'.'||wwv_flow_imp.id(2377428328828737)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558121
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2377792186828738)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'='
,p_lov_return_value=>'EQ'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2378120552828738)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'!='
,p_lov_return_value=>'NEQ'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2378570484828738)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'>'
,p_lov_return_value=>'GT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2378930835828738)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'>='
,p_lov_return_value=>'GTE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2379366639828739)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'<'
,p_lov_return_value=>'LT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2379787769828739)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'<='
,p_lov_return_value=>'LTE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2380150449828739)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'is null'
,p_lov_return_value=>'N'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2380595430828739)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'is not null'
,p_lov_return_value=>'NN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2380918043828740)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'like'
,p_lov_return_value=>'LIKE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p2000_fk_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(6049648636596575)
,p_lov_name=>'P2000_FK_TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(6049648636596575)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558121
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(6049902786596575)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Cascade Delete'
,p_lov_return_value=>'ON DELETE CASCADE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(6050361020596576)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Set Null on Delete'
,p_lov_return_value=>'ON DELETE SET NULL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p2000_redact_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(2372526307115830)
,p_lov_name=>'P2000_REDACT_TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(2372526307115830)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558121
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2372814128115831)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Full'
,p_lov_return_value=>'FULL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2373282436115831)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Partial'
,p_lov_return_value=>'PARTIAL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2373607004115831)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Regular Expression'
,p_lov_return_value=>'REGEXP'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2374064827115831)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Random'
,p_lov_return_value=>'RANDOM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2374436550115831)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'None'
,p_lov_return_value=>'NONE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p2000_remove_redact
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(2371765569098492)
,p_lov_name=>'P2000_REMOVE_REDACT'
,p_lov_query=>'.'||wwv_flow_imp.id(2371765569098492)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558121
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2372024858098492)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Remove redaction policy'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p2000_rem_col_policy
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(2374950879129168)
,p_lov_name=>'P2000_REM_COL_POLICY'
,p_lov_query=>'.'||wwv_flow_imp.id(2374950879129168)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558121
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2375276716129169)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Remove column from policy'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p2000_semantics
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(2383831987893567)
,p_lov_name=>'P2000_SEMANTICS'
,p_lov_query=>'.'||wwv_flow_imp.id(2383831987893567)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558123
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2384188923893567)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Char'
,p_lov_return_value=>'CHAR'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2384516913893567)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Byte'
,p_lov_return_value=>'BYTE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p2000_show_cols
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(2381539388856852)
,p_lov_name=>'P2000_SHOW_COLS'
,p_lov_query=>'.'||wwv_flow_imp.id(2381539388856852)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558123
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2381881328856852)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Show Columns'
,p_lov_return_value=>'X'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p2010_syn_object
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(4601505050190750)
,p_lov_name=>'P2010_SYN_OBJECT'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select table_name object_name,',
'       type object_type',
'  from sys.dba_tab_privs',
' where grantee = :P2010_PARSING_SCHEMA',
'   and grantor = :P2010_SYN_SCHEMA',
' union',
'select object_name object_name,',
'       object_type',
'  from sys.dba_objects',
' where owner             = :P2010_PARSING_SCHEMA',
'   and :P2010_SYN_SCHEMA = :P2010_PARSING_SCHEMA',
'   and object_name not like ''DR$%''',
'   and object_name not like ''BIN$%''',
'   and object_type != ''LOB''',
'   and ( object_type != ''INDEX'' or object_name not like ''SYS_%$$'' )',
' order by 1'))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_use_local_sync_table=>false
,p_return_column_name=>'OBJECT_NAME'
,p_display_column_name=>'OBJECT_NAME'
,p_group_sort_direction=>'ASC'
,p_default_sort_direction=>'ASC'
,p_version_scn=>75558123
);
wwv_flow_imp_shared.create_list_of_values_cols(
 p_id=>wwv_flow_imp.id(4602544630213035)
,p_query_column_name=>'OBJECT_NAME'
,p_heading=>'Object Name'
,p_display_sequence=>10
,p_data_type=>'VARCHAR2'
);
wwv_flow_imp_shared.create_list_of_values_cols(
 p_id=>wwv_flow_imp.id(4602251379213035)
,p_query_column_name=>'OBJECT_TYPE'
,p_heading=>'Object Type'
,p_display_sequence=>30
,p_data_type=>'VARCHAR2'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p2610_users
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(20110029824731114)
,p_lov_name=>'P2610_USERS'
,p_lov_query=>'.'||wwv_flow_imp.id(20110029824731114)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558123
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(20110203670731120)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'All Schemas'
,p_lov_return_value=>'ALL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(20110423350731122)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Internal Schemas'
,p_lov_return_value=>'INTERNAL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(20110606356731122)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Database Schemas'
,p_lov_return_value=>'USER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p2613_locked_unlocked
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(1493723866781789)
,p_lov_name=>'P2613_LOCKED_UNLOCKED'
,p_lov_query=>'.'||wwv_flow_imp.id(1493723866781789)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558123
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1493913666781840)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Locked'
,p_lov_return_value=>'LOCK'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1494107328781852)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Unlocked'
,p_lov_return_value=>'UNLOCK'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p3100_load_to
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(60089930390905970)
,p_lov_name=>'P3100_LOAD_TO'
,p_lov_query=>'.'||wwv_flow_imp.id(60089930390905970)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558124
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(60090216213905982)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'New Table'
,p_lov_return_value=>'NEW'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(60090671533905996)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Existing Table'
,p_lov_return_value=>'EXISTING'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p3100_update_method
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(60103143434104047)
,p_lov_name=>'P3100_UPDATE_METHOD'
,p_lov_query=>'.'||wwv_flow_imp.id(60103143434104047)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558124
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(60103430659104047)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Append'
,p_lov_return_value=>'APPEND'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(60103886752104048)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Replace'
,p_lov_return_value=>'REPLACE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p3120_table_columns
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(60123851090684199)
,p_lov_name=>'P3120_TABLE_COLUMNS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select column_name||'' (''|| initcap(data_type) ||'')'' as d,',
'       column_name as r',
'from sys.dba_tab_columns',
'where owner = :P3100_TABLE_OWNER',
'and table_name = :P3100_EXISTING_TABLE',
'order by column_id'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
,p_version_scn=>75558124
);
end;
/
prompt --application/shared_components/user_interface/lovs/p3142_table_columns
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(2839941212629864)
,p_lov_name=>'P3142_TABLE_COLUMNS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select column_name||'' (''|| initcap(data_type) ||'')'' as d,',
'       column_name as r',
'from sys.dba_tab_columns',
'where owner = :P3140_SCHEMA',
'and table_name = :P3140_EXISTING_TABLE_NAME',
'order by column_id'))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_return_column_name=>'R'
,p_display_column_name=>'D'
,p_version_scn=>75558124
);
end;
/
prompt --application/shared_components/user_interface/lovs/p35_timeframe
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(30574425871912860)
,p_lov_name=>'P35_TIMEFRAME'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, to_char(t) t',
'from (',
'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10 t from sys.dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 60 t from sys.dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5*60 t from sys.dual union all',
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15*60 t from sys.dual union all',
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30*60 t from sys.dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 3600 t from sys.dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 2*3600  t from sys.dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3*3600  t from sys.dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4*3600  t from sys.dual union all',
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6*3600 t from sys.dual union all',
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8*3600 t from sys.dual union all',
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12*3600 t from sys.dual union all',
'select ''18 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 18*3600 t from sys.dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1*24*60*60 t from sys.dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2*24*60*60 t from sys.dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3*24*60*60 t from sys.dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4*24*60*60 t from sys.dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5*24*60*60 t from sys.dual union all',
'select ''6 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 6*24*60*60 t from sys.dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7*24*60*60 t  from sys.dual',
') q'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
,p_version_scn=>75558124
);
end;
/
prompt --application/shared_components/user_interface/lovs/p36_display_options
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(998111353442494)
,p_lov_name=>'P36_DISPLAY_OPTIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(998111353442494)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558124
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(998325750442498)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Version'
,p_lov_return_value=>'VERSION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(998523049442499)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Settings'
,p_lov_return_value=>'DATABASE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(998704170442500)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Options'
,p_lov_return_value=>'OPTIONS'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(999130596442500)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'National Language Support'
,p_lov_return_value=>'NLS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(999327277442500)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'CGI Environment'
,p_lov_return_value=>'CGI'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(5615222230694443)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Parameters'
,p_lov_return_value=>'PARAMETER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p42_order_columns
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(148760022603009971)
,p_lov_name=>'P42.ORDER.COLUMNS'
,p_lov_query=>'select wwv_flow_escape.html(column_name) d, column_name v from sys.dba_tab_columns where owner = :F4500_P42_OBJECT_OWNER and table_name = :F4500_P42_OBJECT_NAME order by column_id'
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
,p_version_scn=>75558124
);
end;
/
prompt --application/shared_components/user_interface/lovs/p64_obj_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(27925820885518618)
,p_lov_name=>'P64_OBJ_TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(27925820885518618)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558124
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(27926020563518626)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Application'
,p_lov_return_value=>'APPLICATION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(27926230018518634)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'CSS Export'
,p_lov_return_value=>'CSS_EXPORT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(27926402670518634)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Application Export'
,p_lov_return_value=>'FLOW_EXPORT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(27926614786518636)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Script'
,p_lov_return_value=>'SCRIPT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(27926803274518636)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Script File Export'
,p_lov_return_value=>'SCRIPT_FILE_EXPORT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(27927031603518636)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Theme'
,p_lov_return_value=>'THEME'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(27927219004518642)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'Static File'
,p_lov_return_value=>'STATIC FILE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p71_columns
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(174553601832855016)
,p_lov_name=>'P71_COLUMNS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(COLUMN_NAME)||'' (''||data_type||'')'' d,  column_name r',
'from sys.dba_tab_columns',
'where owner =  :OBJECT_OWNER',
' and table_name= :OBJECT_NAME and column_id is not null',
'order by column_id'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
,p_version_scn=>75558124
);
end;
/
prompt --application/shared_components/user_interface/lovs/p76_columns
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(174520707223695721)
,p_lov_name=>'P76_COLUMNS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(COLUMN_NAME)||'' (''||data_type||'')'' d,  column_name r',
'from sys.dba_tab_columns',
'where owner =  :OBJECT_OWNER and',
'table_name= :OBJECT_NAME and column_id is not null',
'order by column_id'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
,p_version_scn=>75558124
);
end;
/
prompt --application/shared_components/user_interface/lovs/p82_constraints
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(174431027591821617)
,p_lov_name=>'P82_CONSTRAINTS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(c.constraint_name) d,  c.constraint_name r',
'from sys.dba_constraints c, sys.dba_cons_columns l',
'where c.table_name = :OBJECT_NAME',
'and c.owner = :OBJECT_OWNER',
'and c.constraint_type in (''P'',''U'',''C'',''R'')',
'and c.constraint_name = l.constraint_name ',
'and l.owner = :OBJECT_OWNER',
'and l.table_name = :OBJECT_NAME',
'and c.status = ''DISABLED''',
'order by c.constraint_name, c.constraint_type, l.position'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
,p_version_scn=>75558124
);
end;
/
prompt --application/shared_components/user_interface/lovs/p86_triggers
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(174475310182109956)
,p_lov_name=>'P86_TRIGGERS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(t.trigger_name)||'' (''||t.status||'')'' d, t.trigger_name r',
'from sys.dba_triggers t',
'where t.table_name = :OBJECT_NAME ',
'and t.table_owner = :OBJECT_OWNER',
'order by t.trigger_name'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
,p_version_scn=>75558124
);
end;
/
prompt --application/shared_components/user_interface/lovs/parameter_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(4013634066938059)
,p_lov_name=>'PARAMETER_TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(4013634066938059)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558124
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4013908234938083)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'IN'
,p_lov_return_value=>'IN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4014345637938085)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'OUT'
,p_lov_return_value=>'OUT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4014719077938085)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'IN OUT'
,p_lov_return_value=>'IN OUT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/pl_sql_object_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(9486017492391468)
,p_lov_name=>'PL/SQL OBJECT TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(9486017492391468)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558124
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9486202458391470)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Procedure'
,p_lov_return_value=>'PROCEDURE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9486430806391474)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Function'
,p_lov_return_value=>'FUNCTION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9486609421391475)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Package'
,p_lov_return_value=>'PACKAGE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9486818320391475)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Package Body'
,p_lov_return_value=>'PACKAGE BODY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9487009618391475)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Trigger'
,p_lov_return_value=>'TRIGGER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/privileges_table_show
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(8935311761146039)
,p_lov_name=>'PRIVILEGES.TABLE.SHOW'
,p_lov_query=>'.'||wwv_flow_imp.id(8935311761146039)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558124
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(8935521709146041)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Grants to selected schema'
,p_lov_return_value=>'TO'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(8935711543146043)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Grants from selected schema'
,p_lov_return_value=>'FROM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(8935913844146043)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'All'
,p_lov_return_value=>'ALL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/public_private
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(88067712358839197)
,p_lov_name=>'PUBLIC.PRIVATE'
,p_lov_query=>'.'||wwv_flow_imp.id(88067712358839197)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558124
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88067900572839197)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Private'
,p_lov_return_value=>'PRIVATE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88068127252839198)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Public'
,p_lov_return_value=>'PUBLIC'
);
end;
/
prompt --application/shared_components/user_interface/lovs/query_builder_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(2308814912225605)
,p_lov_name=>'QUERY_BUILDER_TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(2308814912225605)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558124
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2309026164225610)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Private'
,p_lov_return_value=>'P'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2309221064225612)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Public'
,p_lov_return_value=>'R'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2309411169225612)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Public Read/Write'
,p_lov_return_value=>'W'
,p_lov_disp_cond_type=>'NEVER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/query_owners
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(3358317445244033)
,p_lov_name=>'QUERY_OWNERS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r from (',
'select wwv_flow_escape.html(created_by) d, created_by r ',
'  from wwv_flow_qb_saved_query',
'where security_group_id = :flow_security_group_id',
'and exists (     ',
'select 1 ',
'from  wwv_flow_developers ',
'where security_group_id = :flow_security_group_id and ',
'      userid = :flow_user and ',
'      instr(developer_role||'':'',''ADMIN:'') > 0 ',
'union ',
'select 1 ',
'from wwv_flow_fnd_user ',
'where security_group_id = :flow_security_group_id ',
'and user_name = :flow_user ',
'and attribute_01 in (''ORACLE_ADMIN'',''SCHOOL_ADMIN'',''TEACHER'')) ',
'union all  ',
'select v(''APP_USER'') d, v(''APP_USER'') r',
'FROM sys.DUAL) ',
'group by d,r',
''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
,p_version_scn=>75558124
);
end;
/
prompt --application/shared_components/user_interface/lovs/quicksql_data_lang
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(397206437082468486)
,p_lov_name=>'QUICKSQL_DATA_LANG'
,p_lov_query=>'.'||wwv_flow_imp.id(397206437082468486)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558124
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(397206751492468497)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'English'
,p_lov_return_value=>'EN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(397207144316468498)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'German'
,p_lov_return_value=>'DE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(397207548117468498)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Korean'
,p_lov_return_value=>'KO'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(397207927574468498)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Japanese'
,p_lov_return_value=>'JA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(397208363097468498)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Spanish'
,p_lov_return_value=>'ES'
);
end;
/
prompt --application/shared_components/user_interface/lovs/quota_size
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(1589203900827893)
,p_lov_name=>'QUOTA SIZE'
,p_lov_query=>'.'||wwv_flow_imp.id(1589203900827893)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558124
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1589405753827932)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Zero'
,p_lov_return_value=>'NONE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1589832194827937)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Value (MB)'
,p_lov_return_value=>'VALUE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1589631060827937)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Unlimited'
,p_lov_return_value=>'UNLIMITED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/recycle_bin_object_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(165057106281786448)
,p_lov_name=>'RECYCLE BIN OBJECT TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(165057106281786448)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558124
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(165057400753786453)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Index'
,p_lov_return_value=>'INDEX'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(165057605335786456)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Table'
,p_lov_return_value=>'TABLE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(165057800969786457)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Trigger'
,p_lov_return_value=>'TRIGGER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/redaction_enabled
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(7500901536272987)
,p_lov_name=>'REDACTION_ENABLED'
,p_lov_query=>'.'||wwv_flow_imp.id(7500901536272987)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558124
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7501216647272994)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Enabled'
,p_lov_return_value=>'Y'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7501515266272994)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Disabled'
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/redact_expressions
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(7516909805609852)
,p_lov_name=>'REDACT_EXPRESSIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(7516909805609852)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558124
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7517226584609865)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Always'
,p_lov_return_value=>'1=1'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7517506593609865)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Oracle APEX User is'
,p_lov_return_value=>'v(''APP_USER'') = '''' or v(''APP_USER'') is null'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7517804068609865)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Oracle APEX User is not'
,p_lov_return_value=>'v(''APP_USER'') != '''' or v(''APP_USER'') is null'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7518128701609866)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'User Environment Session User is'
,p_lov_return_value=>'SYS_CONTEXT(''USERENV'',''SESSION_USER'') = '''' or SYS_CONTEXT(''USERENV'',''SESSION_USER'') is null'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7518404287609866)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'User Environment Session User is not'
,p_lov_return_value=>'SYS_CONTEXT(''USERENV'',''SESSION_USER'') != '''' or SYS_CONTEXT(''USERENV'',''SESSION_USER'') is null'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7518717668609866)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'User Environment Session Role is'
,p_lov_return_value=>'SYS_CONTEXT(''USERENV'',''SESSION_ROLE'') = '''' or SYS_CONTEXT(''USERENV'',''SESSION_ROLE'') is null'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7519030231609866)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'User Environment Session Role is not'
,p_lov_return_value=>'SYS_CONTEXT(''USERENV'',''SESSION_ROLE'') != '''' or SYS_CONTEXT(''USERENV'',''SESSION_ROLE'') is null'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7519316622609867)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'User Environment Application Module is'
,p_lov_return_value=>'SYS_CONTEXT(''USERENV'',''APPLICATION_MODULE'') = '''' or SYS_CONTEXT(''USERENV'',''APPLICATION_MODULE'') is null'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7519610265609867)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'User Environment Application Module is not'
,p_lov_return_value=>'SYS_CONTEXT(''USERENV'',''APPLICATION_MODULE'') != '''' or SYS_CONTEXT(''USERENV'',''APPLICATION_MODULE'') is null'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7519923103609867)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'User Environment Client Identifier is'
,p_lov_return_value=>'SYS_CONTEXT(''USERENV'',''CLIENT_IDENTIFIER'') = '''' or SYS_CONTEXT(''USERENV'',''CLIENT_IDENTIFIER'') is null'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7520222645609867)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>'User Environment Client Identifier is not'
,p_lov_return_value=>'SYS_CONTEXT(''USERENV'',''CLIENT_IDENTIFIER'') != '''' or SYS_CONTEXT(''USERENV'',''CLIENT_IDENTIFIER'') is null'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7520505568609926)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>'User Environment Client Information is'
,p_lov_return_value=>'SYS_CONTEXT(''USERENV'',''CLIENT_INFORMATION'') = '''' or SYS_CONTEXT(''USERENV'',''CLIENT_INFORMATION'') is null'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7520806771609926)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>'User Environment Client Information is not'
,p_lov_return_value=>'SYS_CONTEXT(''USERENV'',''CLIENT_INFORMATION'') != '''' or SYS_CONTEXT(''USERENV'',''CLIENT_INFORMATION'') is null'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7521121453609926)
,p_lov_disp_sequence=>14
,p_lov_disp_value=>'User Environment Client IP Address is'
,p_lov_return_value=>'SYS_CONTEXT(''USERENV'',''CLIENT_IP_ADDRESS'') = '''' or SYS_CONTEXT(''USERENV'',''CLIENT_IP_ADDRESS'') is null'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7521408264609926)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>'User Environment Client IP Address is not'
,p_lov_return_value=>'SYS_CONTEXT(''USERENV'',''CLIENT_IP_ADDRESS'') != '''' or SYS_CONTEXT(''USERENV'',''CLIENT_IP_ADDRESS'') is null'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7521704157619850)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'User Environment Client Machine Name is'
,p_lov_return_value=>'SYS_CONTEXT(''USERENV'',''CLIENT_MACHINE_NAME'') = '''' or SYS_CONTEXT(''USERENV'',''CLIENT_MACHINE_NAME'') is null'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7522029162623362)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'User Environment Client Machine Name is not'
,p_lov_return_value=>'SYS_CONTEXT(''USERENV'',''CLIENT_MACHINE_NAME'') != '''' or SYS_CONTEXT(''USERENV'',''CLIENT_MACHINE_NAME'') is null'
);
end;
/
prompt --application/shared_components/user_interface/lovs/redact_func_parms
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(7469301964208818)
,p_lov_name=>'REDACT_FUNC_PARMS'
,p_lov_query=>'.'||wwv_flow_imp.id(7469301964208818)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558127
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7469607797208922)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Redact First Five US SSN'
,p_lov_return_value=>'VVVFVVFVVVV,VVV-VV-VVVV,X,1,5'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7469909319209004)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Redact Last Four US SSN'
,p_lov_return_value=>'VVVFVVFVVVV,VVV-VV-VVVV,X,6,9'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7470220279209004)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Redact Entire US SSN'
,p_lov_return_value=>'VVVFVVFVVVV,VVV-VV-VVVV,X,1,9'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7470527551209004)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Redact First Five Numeric US SSN'
,p_lov_return_value=>'9,1,5'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7470809785209004)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Redact Last Four Numeric US SSN'
,p_lov_return_value=>'9,6,9'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7471105134209004)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Redact Entire Numeric US SSN'
,p_lov_return_value=>'9,1,9'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7471430655209004)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'Redact Numeric US ZIP Code'
,p_lov_return_value=>'9,1,5'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7471711236209005)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'Redact First Twelve Credit Card Number'
,p_lov_return_value=>'VVVVFVVVVFVVVVFVVVV,VVVV-VVVV-VVVV-VVVV,*,1,12'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7472009351209006)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'Redact Date Millenium'
,p_lov_return_value=>'m1d1y2000'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7472316128209006)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Redact Date Epoch'
,p_lov_return_value=>'m1d1y1970'
);
end;
/
prompt --application/shared_components/user_interface/lovs/redact_regexp_pattern
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(7472906353351996)
,p_lov_name=>'REDACT_REGEXP_PATTERN'
,p_lov_query=>'.'||wwv_flow_imp.id(7472906353351996)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558127
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7473231345352007)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'US Social Security Number'
,p_lov_return_value=>'(\d\d\d)-(\d\d)-(\d\d\d\d)'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7473505981352008)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Middle of Credit Card with Leading 6 and Trailing 4 digits'
,p_lov_return_value=>'(\d\d\d\d\d\d)(\d\d\d*)(\d\d\d\d)'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7473832380352008)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Any Digit'
,p_lov_return_value=>'\d'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7474122208352008)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'US Phone Number'
,p_lov_return_value=>'(\(\d\d\d\)|\d\d\d)-(\d\d\d)-(\d\d\d\d)'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7474420613352009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Email Address'
,p_lov_return_value=>'([A-Za-z0-9._%+-]+)@([A-Za-z0-9.-]+\.[A-Za-z]{2,4})'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7474702702352009)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'IP Address'
,p_lov_return_value=>'(\d{1,3}\.\d{1,3}\.\d{1,3})\.\d{1,3}'
);
end;
/
prompt --application/shared_components/user_interface/lovs/redact_regexp_repl_str
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(7474914908572203)
,p_lov_name=>'REDACT_REGEXP_REPL_STR'
,p_lov_query=>'.'||wwv_flow_imp.id(7474914908572203)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558127
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7475217540572261)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Redact Middle Credit Card Digits'
,p_lov_return_value=>'\1XXXXXX\3'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7475532017572262)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Redact with Single X'
,p_lov_return_value=>'X'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7475808807572262)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Redact with Single 1'
,p_lov_return_value=>'1'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7476121686572262)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Redact US Phone'
,p_lov_return_value=>'\1-XXX-XXXX'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7476430001572262)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Redact Email Name'
,p_lov_return_value=>'xxxx@\2'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7476702761572263)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Redact Email Domain'
,p_lov_return_value=>'\1 (at) xxxxx.com'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7477004982572263)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'Redact Entire Email'
,p_lov_return_value=>'xxxx (at) xxxxx.com'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7477316416572263)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'Redact IP Address'
,p_lov_return_value=>'\1.999'
);
end;
/
prompt --application/shared_components/user_interface/lovs/regexp_match_param
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(7477530753595662)
,p_lov_name=>'REGEXP_MATCH_PARAM'
,p_lov_query=>'.'||wwv_flow_imp.id(7477530753595662)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558127
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7477819505595662)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Case Sensitive'
,p_lov_return_value=>'c'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7478103965595662)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Case Insensitive'
,p_lov_return_value=>'i'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7478429992595663)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Multiple Lines'
,p_lov_return_value=>'m'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7478728314595663)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Newline Wildcard'
,p_lov_return_value=>'n'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(7479001778595663)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Ignore Whitespace'
,p_lov_return_value=>'x'
);
end;
/
prompt --application/shared_components/user_interface/lovs/row_select
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(88095631994062466)
,p_lov_name=>'ROW.SELECT'
,p_lov_query=>'.'||wwv_flow_imp.id(88095631994062466)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558127
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88095810522062467)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'All Rows'
,p_lov_return_value=>'ALL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88096011165062467)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Selected Rows'
,p_lov_return_value=>'SELECTED'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88096206304062468)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'No Rows'
,p_lov_return_value=>'NONE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/sample_data_spreadsheets
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(217855733246275209)
,p_lov_name=>'SAMPLE.DATA.SPREADSHEETS'
,p_lov_query=>'.'||wwv_flow_imp.id(217855733246275209)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558127
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(217856069642275210)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Academic'
,p_lov_return_value=>'ACADEMIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(217856445509275213)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Classic Departments and Employees'
,p_lov_return_value=>'DEPT_EMP'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(217856856420275213)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Formula 1'
,p_lov_return_value=>'F1'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(217857246380275213)
,p_lov_disp_sequence=>22
,p_lov_disp_value=>'JSON and Structured Test Data'
,p_lov_return_value=>'JSON_TEST'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(217857693606275213)
,p_lov_disp_sequence=>23
,p_lov_disp_value=>'JSON only Test Data'
,p_lov_return_value=>'JSON'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(217858097098275213)
,p_lov_disp_sequence=>25
,p_lov_disp_value=>'Movies'
,p_lov_return_value=>'MOVIE'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(217858447167275214)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Project and Tasks'
,p_lov_return_value=>'PROJECTS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(217858839052275214)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Sales'
,p_lov_return_value=>'SALES'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(217859293900275214)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'Tennis'
,p_lov_return_value=>'TENNIS'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(217859626213275214)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'Vehicle Speed'
,p_lov_return_value=>'SPEED'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(217860008215275214)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'World Cup'
,p_lov_return_value=>'WORLDCUP'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(217860462659275215)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'World Population'
,p_lov_return_value=>'WORLD'
);
end;
/
prompt --application/shared_components/user_interface/lovs/schema_compare_categories
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(14728126072025797)
,p_lov_name=>'SCHEMA COMPARE CATEGORIES'
,p_lov_query=>'.'||wwv_flow_imp.id(14728126072025797)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558127
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(14728314552025797)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Columns Names'
,p_lov_return_value=>'COLUMN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(14728532416025797)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Tables'
,p_lov_return_value=>'TABLE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(14728710300025797)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Column Datatypes'
,p_lov_return_value=>'DATATYPE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(14839906156999563)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Indexes'
,p_lov_return_value=>'INDEX'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(14877305584283250)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Function'
,p_lov_return_value=>'FUNCTION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(14929828730535894)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Sequences'
,p_lov_return_value=>'SEQUENCE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(14932013409550455)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Triggers'
,p_lov_return_value=>'TRIGGER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16908630581731543)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Package'
,p_lov_return_value=>'PACKAGE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16908901622732667)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Package Body'
,p_lov_return_value=>'PACKAGE BODY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16909205432733687)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Procedure'
,p_lov_return_value=>'PROCEDURE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16909507509734338)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Type'
,p_lov_return_value=>'TYPE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(77467331623506913)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'View'
,p_lov_return_value=>'VIEW'
);
end;
/
prompt --application/shared_components/user_interface/lovs/script_output_view_mode
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(11936228645031897)
,p_lov_name=>'SCRIPT_OUTPUT_VIEW_MODE'
,p_lov_query=>'.'||wwv_flow_imp.id(11936228645031897)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558128
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(11936413744031900)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Statement'
,p_lov_return_value=>'STMT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(12078021672086769)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Results'
,p_lov_return_value=>'RESULTS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(11936610007031901)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Feedback'
,p_lov_return_value=>'MSG'
);
end;
/
prompt --application/shared_components/user_interface/lovs/script_result_status
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(16851103836270043)
,p_lov_name=>'SCRIPT_RESULT_STATUS'
,p_lov_query=>'.'||wwv_flow_imp.id(16851103836270043)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558128
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16851311853270045)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Submitted'
,p_lov_return_value=>'SUBMITTED'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16851527617270045)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Executing'
,p_lov_return_value=>'EXECUTING'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16851718446270046)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Complete'
,p_lov_return_value=>'COMPLETE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16851904138270047)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Canceled'
,p_lov_return_value=>'CANCELED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/search_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(246393217654948737)
,p_lov_name=>'SEARCH_TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(246393217654948737)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558129
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(246393407696948737)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Match Case'
,p_lov_return_value=>'CASE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/session_monitoring_status
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(159923116388036162)
,p_lov_name=>'SESSION MONITORING STATUS'
,p_lov_query=>'.'||wwv_flow_imp.id(159923116388036162)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558129
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(159923408566036193)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'All'
,p_lov_return_value=>'ALL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(159923619966036211)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Active'
,p_lov_return_value=>'ACTIVE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/sga_target_lov
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(1417526170798303)
,p_lov_name=>'SGA_TARGET_LOV'
,p_lov_query=>'.'||wwv_flow_imp.id(1417526170798303)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558129
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1417704549798326)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'64'
,p_lov_return_value=>'64M'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1417915382798336)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'128'
,p_lov_return_value=>'128M'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1418109764798336)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'192'
,p_lov_return_value=>'192M'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1418312463798336)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'256'
,p_lov_return_value=>'256M'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1418503267798338)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'320'
,p_lov_return_value=>'320M'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1418716837798338)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'384'
,p_lov_return_value=>'384M'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1418915626798339)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'448'
,p_lov_return_value=>'448M'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1419122341798339)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'512'
,p_lov_return_value=>'512M'
);
end;
/
prompt --application/shared_components/user_interface/lovs/show_tables_with_and_without_comments
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(8639918272273372)
,p_lov_name=>'SHOW TABLES WITH AND WITHOUT COMMENTS'
,p_lov_query=>'.'||wwv_flow_imp.id(8639918272273372)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558131
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(8640124542273376)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Tables with comments'
,p_lov_return_value=>'WITH'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(8640331660273378)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Tables without comments'
,p_lov_return_value=>'WITHOUT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(8640518874273378)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'All Tables'
,p_lov_return_value=>'ALL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/show_hide_y_n
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(88026529019446655)
,p_lov_name=>'SHOW.HIDE.Y.N'
,p_lov_query=>'.'||wwv_flow_imp.id(88026529019446655)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558131
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88026728054446655)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Show'
,p_lov_return_value=>'Y'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88026921198446656)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Hide'
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/sid_service
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(270736905720819349)
,p_lov_name=>'SID_SERVICE'
,p_lov_query=>'.'||wwv_flow_imp.id(270736905720819349)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558131
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(270737132068819350)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Service Name'
,p_lov_return_value=>'SERVICE_NAME'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(270737303121819350)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'SID'
,p_lov_return_value=>'SID'
);
end;
/
prompt --application/shared_components/user_interface/lovs/sql_script_result_view_mode
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(164092723800780852)
,p_lov_name=>'SQL SCRIPT RESULT VIEW MODE'
,p_lov_query=>'.'||wwv_flow_imp.id(164092723800780852)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558131
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(164092906932780860)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Summary'
,p_lov_return_value=>'SUMMARY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(164093123083780865)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Detail'
,p_lov_return_value=>'DETAIL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/sql_filetype
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(88033203570477156)
,p_lov_name=>'SQL.FILETYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(88033203570477156)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558131
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88033427813477157)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Script File (*.sql)'
,p_lov_return_value=>'sql'
);
end;
/
prompt --application/shared_components/user_interface/lovs/sql_txt_filetype
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(88078901941959255)
,p_lov_name=>'SQL.TXT.FILETYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(88078901941959255)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558131
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88079103923959257)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Text File (*.txt)'
,p_lov_return_value=>'txt'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88079307836959257)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Script File (*.sql)'
,p_lov_return_value=>'sql'
);
end;
/
prompt --application/shared_components/user_interface/lovs/synchronize_defaults_p809
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(42723506268079541)
,p_lov_name=>'SYNCHRONIZE DEFAULTS P809'
,p_lov_query=>'.'||wwv_flow_imp.id(42723506268079541)||'.'
,p_location=>'STATIC'
,p_version_scn=>117451426
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(42723726496079548)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Application Attributes to UI Defaults'
,p_lov_return_value=>'FROM_APP'
,p_lov_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#DISPLAY_VALUE#<br />',
'<span style="margin-left:20px;"><img src="#IMAGE_PREFIX#menu/info_64.gif" class="htmldbGreenIcon" alt="#DISPLAY_VALUE#" /></span>'))
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(42723917981079550)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'UI Defaults to Application Attributes'
,p_lov_return_value=>'FROM_DEF'
,p_lov_template=>'#DISPLAY_VALUE#<br /><span style="margin-left:20px;"><img src="#IMAGE_PREFIX#menu/client_64.gif" class="htmldbGreenIcon" alt="#DISPLAY_VALUE#" /></span>'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(42726531464105754)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Database to UI Defaults'
,p_lov_return_value=>'FROM_DB'
,p_lov_template=>'#DISPLAY_VALUE#<br /><span style="margin-left:20px;"><img src="#IMAGE_PREFIX#menu/db_64.gif" class="htmldbGreenIcon" alt="#DISPLAY_VALUE#" /></span>'
);
end;
/
prompt --application/shared_components/user_interface/lovs/syn_db_location
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(2983860617051710)
,p_lov_name=>'SYN_DB_LOCATION'
,p_lov_query=>'.'||wwv_flow_imp.id(2983860617051710)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558134
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2984191751051712)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Local Object'
,p_lov_return_value=>'LOCAL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2984588478051713)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Remote Object'
,p_lov_return_value=>'REMOTE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/system_privileges
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(25560713417668203)
,p_lov_name=>'SYSTEM PRIVILEGES'
,p_lov_query=>'.'||wwv_flow_imp.id(25560713417668203)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558134
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(25560932733668206)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE VIEW'
,p_lov_return_value=>'CREATE VIEW'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(25561118325668208)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE PROCEDURE'
,p_lov_return_value=>'CREATE PROCEDURE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(25561329462668208)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE SYNONYM'
,p_lov_return_value=>'CREATE SYNONYM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(25561509484668208)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE TABLE'
,p_lov_return_value=>'CREATE TABLE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(25561703573668209)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE INDEXTYPE'
,p_lov_return_value=>'CREATE INDEXTYPE'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(25561918387668209)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE SEQUENCE'
,p_lov_return_value=>'CREATE SEQUENCE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(25562101316668209)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE DATABASE LINK'
,p_lov_return_value=>'CREATE DATABASE LINK'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(25562309219668209)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE TYPE'
,p_lov_return_value=>'CREATE TYPE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(25562510373668210)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE MATERIALIZED VIEW'
,p_lov_return_value=>'CREATE MATERIALIZED VIEW'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(25562725532668210)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE CLUSTER'
,p_lov_return_value=>'CREATE CLUSTER'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(25562915030668210)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE TRIGGER'
,p_lov_return_value=>'CREATE TRIGGER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(25563105054668210)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE OPERATOR'
,p_lov_return_value=>'CREATE OPERATOR'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(25563322062668210)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE LIBRARY'
,p_lov_return_value=>'CREATE LIBRARY'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(25563526933668211)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE DIMENSION'
,p_lov_return_value=>'CREATE DIMENSION'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(25563701512668211)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE JOB'
,p_lov_return_value=>'CREATE JOB'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(25563918014668211)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE PROFILE'
,p_lov_return_value=>'CREATE PROFILE'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(25564128815668211)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE PUBLIC DATABASE LINK'
,p_lov_return_value=>'CREATE PUBLIC DATABASE LINK'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(25564332270668211)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE PUBLIC SYNONYM'
,p_lov_return_value=>'CREATE PUBLIC SYNONYM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(25564509385668212)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE ROLE'
,p_lov_return_value=>'CREATE ROLE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(25564707743668213)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE ROLLBACK SEGMENT'
,p_lov_return_value=>'CREATE ROLLBACK SEGMENT'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(25564902366668213)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE RULE'
,p_lov_return_value=>'CREATE RULE'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(25565120530668213)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE RULE SET'
,p_lov_return_value=>'CREATE RULE SET'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(25565300473668214)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE SESSION'
,p_lov_return_value=>'CREATE SESSION'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(25565512486668214)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE TABLESPACE'
,p_lov_return_value=>'CREATE TABLESPACE'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(25565717929668214)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE USER'
,p_lov_return_value=>'CREATE USER'
,p_lov_disp_cond_type=>'NEVER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/table_children
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(3694131248687844)
,p_lov_name=>'TABLE_CHILDREN'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''4500_1002_QB_JOIN'')||',
'       '' ''||wwv_flow_escape.html(p.column_name)||',
'       '' ''||wwv_flow_lang.system_message(''4500_1002_QB_TO'')||',
'       '' ''||wwv_flow_escape.html(c.table_name)||''.''||wwv_flow_escape.html(c.column_name) d , t.cid||''|''||c.column_name||''|''||p.column_name r',
'  from sys.dba_cons_columns c,',
'       sys.dba_cons_columns p,',
'       sys.dba_objects o,',
'       ( select c.r_constraint_name pc, ',
'                c.table_name cn, ',
'                c.constraint_name cc,',
'                oo.object_id cid, ',
'                rownum',
'           from sys.dba_constraints c,',
'                sys.dba_objects oo',
'          where c.constraint_type = ''R''',
'            and c.owner = :P59_SCHEMA',
'            and oo.object_name = c.table_name',
'            and oo.owner = c.owner ) t',
' where t.cc             = c.constraint_name',
'   and c.owner          = :P59_SCHEMA',
'   and t.pc             = p.constraint_name',
'   and p.owner          = :P59_SCHEMA',
'   and p.table_name     = :P59_TNAME ',
'   and o.object_name    = p.table_name',
'   and o.owner          = c.owner'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
,p_version_scn=>75558135
);
end;
/
prompt --application/shared_components/user_interface/lovs/table_parents
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(3693427654677337)
,p_lov_name=>'TABLE_PARENTS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
' select wwv_flow_lang.system_message(''4500_1002_QB_JOIN'')||',
' '' ''||wwv_flow_escape.html(c.column_name)||'' ''||wwv_flow_lang.system_message(''4500_1002_QB_TO'')||',
' '' ''||wwv_flow_escape.html(p.table_name)||''.''||wwv_flow_escape.html(p.column_name) d , o.object_id||''|''||p.column_name||''|''||c.column_name r ',
'from',
'       sys.dba_cons_columns c,',
'       sys.dba_cons_columns p,',
'        sys.dba_objects o,',
'      ( SELECT c.r_constraint_name pc, c.table_name cn , c.constraint_name cc, rownum',
'        FROM sys.dba_constraints c ',
'        WHERE  c.constraint_type = ''R''',
'        AND c.table_name = :P59_TNAME',
'        and c.owner = :P59_SCHEMA ) t',
'where  t.cc = c.constraint_name',
'and c.owner = :P59_SCHEMA',
'and t.pc = p.constraint_name',
'and p.owner = :P59_SCHEMA',
'and o.object_name = p.table_name',
'and o.owner = c.owner'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
,p_version_scn=>75558135
);
end;
/
prompt --application/shared_components/user_interface/lovs/tabular_form_display_types_from_4000
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(197598824193421582)
,p_lov_name=>'TABULAR_FORM_DISPLAY_TYPES (FROM 4000)'
,p_reference_id=>41868019518520883
,p_lov_query=>'.'||wwv_flow_imp.id(197598824193421582)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(197599231811423843)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Standard Report Column'
,p_lov_return_value=>'WITHOUT_MODIFICATION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(197599400226423843)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Display as Text (based on LOV, does not save state)'
,p_lov_return_value=>'TEXT_FROM_LOV'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(197599610663423843)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Display as Text (saves state)'
,p_lov_return_value=>'DISPLAY_AND_SAVE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(197599819865423845)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Display as Text (escape special characters, does not save state)'
,p_lov_return_value=>'ESCAPE_SC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(197600018265423845)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Date Picker'
,p_lov_return_value=>'DATE_POPUP'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(197600224897423845)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Text Field'
,p_lov_return_value=>'TEXT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(197600423450423845)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'Text Area'
,p_lov_return_value=>'TEXTAREA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(197600606669423845)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'Select List (static LOV)'
,p_lov_return_value=>'SELECT_LIST'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(197600805803423845)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'Select List (named LOV)'
,p_lov_return_value=>'SELECT_LIST_FROM_LOV'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(197601002403423845)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Select List (query based LOV)'
,p_lov_return_value=>'SELECT_LIST_FROM_QUERY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(197601201540423846)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>'Radio Group (static LOV)'
,p_lov_return_value=>'RADIOGROUP'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(197601419878423846)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>'Radio Group (named LOV)'
,p_lov_return_value=>'RADIOGROUP_FROM_LOV'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(197601630729423846)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>'Radio Group (query based LOV)	'
,p_lov_return_value=>'RADIOGROUP_FROM_QUERY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(197601813915423846)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>'Hidden '
,p_lov_return_value=>'HIDDEN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(197602006927423846)
,p_lov_disp_sequence=>16
,p_lov_disp_value=>'Popup LOV (named LOV)'
,p_lov_return_value=>'POPUP'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(197602231429423846)
,p_lov_disp_sequence=>17
,p_lov_disp_value=>'Popup LOV (query based LOV)'
,p_lov_return_value=>'POPUP_QUERY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(197602405258423846)
,p_lov_disp_sequence=>18
,p_lov_disp_value=>'Popup Key LOV (named LOV)'
,p_lov_return_value=>'POPUPKEY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(197602612872423846)
,p_lov_disp_sequence=>19
,p_lov_disp_value=>'Popup Key LOV (query based LOV)	'
,p_lov_return_value=>'POPUPKEY_QUERY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/top_sql_by
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(236910808625037522)
,p_lov_name=>'TOP_SQL_BY'
,p_lov_query=>'.'||wwv_flow_imp.id(236910808625037522)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558135
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(236911029447037524)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'CPU Time'
,p_lov_return_value=>'CPU_TIME'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(236911210865037524)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Disk Reads'
,p_lov_return_value=>'DISK_READS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(236911407417037525)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Executions'
,p_lov_return_value=>'EXECUTIONS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(236911618778037525)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Buffer Gets'
,p_lov_return_value=>'BUFFER_GETS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(236911815989037525)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'Buffer Gets / Rows Processed'
,p_lov_return_value=>'EFFICIENCY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(236912011147037525)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'Buffer Gets / Executions'
,p_lov_return_value=>'EFFICIENCY2'
);
end;
/
prompt --application/shared_components/user_interface/lovs/type_collection_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(16529130513602905)
,p_lov_name=>'TYPE_COLLECTION_TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(16529130513602905)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558136
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16529302646602905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'VArray'
,p_lov_return_value=>'V'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16529528167602906)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Nested Table'
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/type_data_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(16534820904659665)
,p_lov_name=>'TYPE_DATA_TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(16534820904659665)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558136
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16535002611659667)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'BFILE'
,p_lov_return_value=>'BFILE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16535213310659667)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'BLOB'
,p_lov_return_value=>'BLOB'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16535418281659667)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'CHAR'
,p_lov_return_value=>'CHAR'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16535626402659668)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'CLOB'
,p_lov_return_value=>'CLOB'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16535817963659668)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'DATE'
,p_lov_return_value=>'DATE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16536022932659668)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'DECIMAL'
,p_lov_return_value=>'DECIMAL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16536213254659668)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'DOUBLE PRECISION'
,p_lov_return_value=>'DOUBLE PRECISION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16536400283659668)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'FLOAT'
,p_lov_return_value=>'FLOAT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16536606880659669)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'INTEGER'
,p_lov_return_value=>'INTEGER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16536824560659669)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'NUMBER'
,p_lov_return_value=>'NUMBER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16547232731688790)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'REAL'
,p_lov_return_value=>'REAL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16547507582690914)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'SMALLINT'
,p_lov_return_value=>'SMALLINT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16547811738692161)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'RAW'
,p_lov_return_value=>'RAW'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16548116240693431)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'VARCHAR2'
,p_lov_return_value=>'VARCHAR2'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16548420395694645)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'REF'
,p_lov_return_value=>'REF'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16548730785697678)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'< Nested Object >'
,p_lov_return_value=>'NEST'
);
end;
/
prompt --application/shared_components/user_interface/lovs/type_of_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(16521502229452853)
,p_lov_name=>'TYPE_OF_TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(16521502229452853)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558136
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16521731440452856)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Collection Type'
,p_lov_return_value=>'C'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16521925201452858)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Object Type'
,p_lov_return_value=>'O'
,p_lov_disp_cond_type=>'NEVER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ui_default_exp_imp_formats
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(40883415986261937)
,p_lov_name=>'UI DEFAULT EXP IMP FORMATS'
,p_lov_query=>'.'||wwv_flow_imp.id(40883415986261937)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558136
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(40883610383262047)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Unix'
,p_lov_return_value=>'UNIX'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(40883829969262053)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'DOS'
,p_lov_return_value=>'DOS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(40884027551262053)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Database'
,p_lov_return_value=>'DB'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ui_def_alignment_left_center_right
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(251500722928507973)
,p_lov_name=>'UI_DEF_ALIGNMENT_LEFT_CENTER_RIGHT'
,p_lov_query=>'.'||wwv_flow_imp.id(251500722928507973)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558136
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251500919515507973)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Left'
,p_lov_return_value=>'LEFT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251501105156507973)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Center'
,p_lov_return_value=>'CENTER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251501300215507973)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Right'
,p_lov_return_value=>'RIGHT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ui_def_alignment_l_c_r
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(260501806598530292)
,p_lov_name=>'UI_DEF_ALIGNMENT_L_C_R'
,p_lov_query=>'.'||wwv_flow_imp.id(260501806598530292)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558136
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(260502019605530294)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Left'
,p_lov_return_value=>'L'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(260502229771530295)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Center'
,p_lov_return_value=>'C'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(260502407085530295)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Right'
,p_lov_return_value=>'R'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ui_def_display_as_tabular_forms
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(251435312257287190)
,p_lov_name=>'UI_DEF_DISPLAY_AS_TABULAR_FORMS'
,p_lov_query=>'.'||wwv_flow_imp.id(251435312257287190)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558136
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(17234522425911770)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Radio Group (named LOV)'
,p_lov_return_value=>'RADIOGROUP_FROM_LOV'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251435518816287190)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Standard Report Column (display-only, does not save state)'
,p_lov_return_value=>'WITHOUT_MODIFICATION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251435707171287190)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Display as Text (based on LOV, does not save state)'
,p_lov_return_value=>'TEXT_FROM_LOV'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251435904461287190)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Display as Text (saves state)'
,p_lov_return_value=>'DISPLAY_AND_SAVE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251436131397287190)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Display as Text (escape special characters, does not save state)'
,p_lov_return_value=>'ESCAPE_SC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251436331018287190)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Text Field'
,p_lov_return_value=>'TEXT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251436513801287190)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Text Area'
,p_lov_return_value=>'TEXTAREA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251436712096287191)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Select List'
,p_lov_return_value=>'SELECT_LIST_FROM_LOV'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251436921215287191)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Hidden '
,p_lov_return_value=>'HIDDEN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251437110722287191)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Popup LOV'
,p_lov_return_value=>'POPUP'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251437316775287191)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (Classic)'
,p_lov_return_value=>'DATE_POPUP'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251437506052287191)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (use application format mask)'
,p_lov_return_value=>'PICK_DATE_USING_APP_FORMAT_MASK'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251437713738287195)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (DD-MON-RR)'
,p_lov_return_value=>'PICK_DATE_DD_MON_RR'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251437928196287195)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (DD-MON-RR HH24:MI)'
,p_lov_return_value=>'PICK_DATE_DD_MON_RR_HH24_MI'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251438122869287195)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (DD-MON-RR HH:MI)'
,p_lov_return_value=>'PICK_DATE_DD_MON_RR_HH_MI'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251438327137287195)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (DD-MON-YY HH24:MI)'
,p_lov_return_value=>'PICK_DATE_DD_MON_YY_HH24_MI'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251438527222287195)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (DD-MON-YY HH:MI)'
,p_lov_return_value=>'PICK_DATE_DD_MON_YY_HH_MI'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251438708379287195)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (DD-MON-YYYY)'
,p_lov_return_value=>'PICK_DATE_DD_MON_YYYY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251438921019287195)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (DD-MON-YYYY HH24:MI)'
,p_lov_return_value=>'PICK_DATE_DD_MON_YYYY_HH24_MI'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251439126695287196)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (DD-MON-YYYY HH:MI)'
,p_lov_return_value=>'PICK_DATE_DD_MON_YYYY_HH_MI'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251439305041287196)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (DD-MON-YY)'
,p_lov_return_value=>'PICK_DATE_DD_MON_YY'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251439508577287196)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (DD/MM/YYYY)'
,p_lov_return_value=>'PICK_DATE_DD_MM_YYYY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251439705601287196)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (DD/MM/YYYY HH24:MI)'
,p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH24_MI'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251439912743287196)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (DD/MM/YYYY HH:MI)'
,p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH_MI'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251440126520287196)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (MM/DD/YYYY)'
,p_lov_return_value=>'PICK_DATE_MM_DD_YYYY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251440332088287196)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (MM/DD/YYYY HH24:MI)'
,p_lov_return_value=>'PICK_DATE_MM_DD_YYYY_HH24_MI'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251440513083287196)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (MM/DD/YYYY HH:MI)'
,p_lov_return_value=>'PICK_DATE_MM_DD_YYYY_HH_MI'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251440720307287196)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (RR-MON-DD)'
,p_lov_return_value=>'PICK_DATE_RR_MON_DD'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251440914527287196)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (RR-MON-DD HH24:MI)'
,p_lov_return_value=>'PICK_DATE_RR_MON_DD_HH24_MI'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251441107529287196)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (RR-MON-DD HH:MI)'
,p_lov_return_value=>'PICK_DATE_RR_MON_DD_HH_MI'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251441327665287197)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (YYYY-MM-DD)'
,p_lov_return_value=>'PICK_DATE_YYYY_MM_DD'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251441519610287197)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (YYYY-MM-DD HH24:MI)'
,p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_HH24_MI'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251441716061287197)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (YYYY-MM-DD HH:MI)'
,p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_HH_MI'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251441922940287197)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (DD-MM-YYYY)'
,p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_DASH'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251442121133287197)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (DD-MM-YYYY HH24:MI)'
,p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH24_MI_DASH'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251442323229287197)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (DD-MM-YYYY HH:MI)'
,p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH_MI_DASH'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251442518523287197)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (DD.MM.YYYY)'
,p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_DOT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251442702648287197)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (DD.MM.YYYY HH24:MI)'
,p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH24_MI_DOT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251442915305287199)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (DD.MM.YYYY HH:MI)'
,p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH_MI_DOT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251443114390287199)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (YYYY.DD.MM)'
,p_lov_return_value=>'PICK_DATE_YYYY_DD_MM_DOT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251443317438287199)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (YYYY.DD.MM HH24:MI)'
,p_lov_return_value=>'PICK_DATE_YYYY_DD_MM_HH24_MI_DOT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251443530076287199)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (YYYY.DD.MM HH:MI)'
,p_lov_return_value=>'PICK_DATE_YYYY_DD_MM_HH_MI_DOT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251443706296287199)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (YYYY/MM/DD)'
,p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_SLASH'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251443923019287199)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (YYYY/MM/DD HH24:MI)'
,p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_HH24_MI_SLASH'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251444119218287199)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (YYYY/MM/DD HH:MI)'
,p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_HH_MI_SLASH'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251444312958287199)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker (use Application Date Format)'
,p_lov_return_value=>'PICK_DATE_USING_APP_DATE_FORMAT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(619426426716882935)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker'
,p_lov_return_value=>'DATE_PICKER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(17235123595921491)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Popup Key LOV (named LOV)'
,p_lov_return_value=>'POPUPKEY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(17235632599924147)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Simple Checkbox'
,p_lov_return_value=>'SIMPLE_CHECKBOX'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ui_def_static_dynamic
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(251523907288749450)
,p_lov_name=>'UI_DEF_STATIC_DYNAMIC'
,p_lov_query=>'.'||wwv_flow_imp.id(251523907288749450)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558137
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251524122983749452)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Static'
,p_lov_return_value=>'S'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(251524330798749453)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Dynamic'
,p_lov_return_value=>'D'
);
end;
/
prompt --application/shared_components/user_interface/lovs/unix_dos
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(88081812938981328)
,p_lov_name=>'UNIX.DOS'
,p_lov_query=>'.'||wwv_flow_imp.id(88081812938981328)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558137
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88082021798981329)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'DOS'
,p_lov_return_value=>'DOS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88082214036981329)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'UNIX'
,p_lov_return_value=>'UNIX'
);
end;
/
prompt --application/shared_components/user_interface/lovs/user_interface_form_defaults_sync_options
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(40766106443619635)
,p_lov_name=>'USER INTERFACE FORM DEFAULTS SYNC OPTIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(40766106443619635)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558137
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(40766308005619649)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Label'
,p_lov_return_value=>'LABEL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(40766500283619653)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Display As'
,p_lov_return_value=>'DISPLAY_AS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(40766713910619654)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Form Display Sequence'
,p_lov_return_value=>'FORM_DISPLAY_SEQUENCE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(40766902092619654)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Element Width'
,p_lov_return_value=>'ELEMENT_WIDTH'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(40767122890619654)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'Element Maximum Width'
,p_lov_return_value=>'ELEMENT_MAX_WIDTH'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(40767319691619654)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'Element Height'
,p_lov_return_value=>'ELEMENT_HEIGHT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(40767510229619654)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'Alignment'
,p_lov_return_value=>'ITEM_ALIGNMENT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(40767731122619654)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'Help Text'
,p_lov_return_value=>'HELP_TEXT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(40767913178619654)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'Column Group'
,p_lov_return_value=>'COLUMN_GROUP'
);
end;
/
prompt --application/shared_components/user_interface/lovs/view_detail_summary
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(183733207435875441)
,p_lov_name=>'VIEW_DETAIL_SUMMARY'
,p_lov_query=>'.'||wwv_flow_imp.id(183733207435875441)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558137
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(183733411221875446)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Detail'
,p_lov_return_value=>'DETAIL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(183733609162875449)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Summary'
,p_lov_return_value=>'SUMMARY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/web_credentials_for_dbms_cloud
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(3034883284660886)
,p_lov_name=>'WEB_CREDENTIALS_FOR_DBMS_CLOUD'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id,',
'       name,',
'       authentication_type,',
'       client_id',
'  from wwv_credentials',
' where security_group_id = :WORKSPACE_ID',
'   and authentication_type in (''OCI'', ''BASIC'')'))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_return_column_name=>'ID'
,p_display_column_name=>'NAME'
,p_group_sort_direction=>'ASC'
,p_default_sort_column_name=>'NAME'
,p_default_sort_direction=>'ASC'
,p_version_scn=>75558137
);
wwv_flow_imp_shared.create_list_of_values_cols(
 p_id=>wwv_flow_imp.id(3035303136662958)
,p_query_column_name=>'ID'
,p_display_sequence=>10
,p_data_type=>'NUMBER'
,p_is_visible=>'N'
,p_is_searchable=>'N'
);
wwv_flow_imp_shared.create_list_of_values_cols(
 p_id=>wwv_flow_imp.id(3035790565662962)
,p_query_column_name=>'NAME'
,p_heading=>'Name'
,p_display_sequence=>20
,p_data_type=>'VARCHAR2'
);
wwv_flow_imp_shared.create_list_of_values_cols(
 p_id=>wwv_flow_imp.id(3036173161662962)
,p_query_column_name=>'AUTHENTICATION_TYPE'
,p_heading=>'Authentication Type'
,p_display_sequence=>30
,p_data_type=>'VARCHAR2'
);
wwv_flow_imp_shared.create_list_of_values_cols(
 p_id=>wwv_flow_imp.id(3036569773662962)
,p_query_column_name=>'CLIENT_ID'
,p_heading=>'User ID'
,p_display_sequence=>40
,p_data_type=>'VARCHAR2'
);
end;
/
prompt --application/shared_components/user_interface/lovs/y_n_returns_y_n
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(88037119678519608)
,p_lov_name=>'Y.N.RETURNS.Y.N'
,p_lov_query=>'.'||wwv_flow_imp.id(88037119678519608)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558137
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88037301694519609)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Yes'
,p_lov_return_value=>'Y'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88037513209519609)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'No'
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/yes_no_true_false
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(550748599416480697)
,p_lov_name=>'YES NO TRUE FALSE'
,p_lov_query=>'.'||wwv_flow_imp.id(550748599416480697)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558137
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(550748896421480698)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Yes'
,p_lov_return_value=>'TRUE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(550749224337480699)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'No'
,p_lov_return_value=>'FALSE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/yes_no_returns_y_n
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(23482928300634173)
,p_lov_name=>'YES.NO.RETURNS.Y.N'
,p_lov_query=>'.'||wwv_flow_imp.id(23482928300634173)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558137
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(23483215241634177)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Yes'
,p_lov_return_value=>'Y'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(23483425275634179)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'No'
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/y_noprompt
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(88018003898325845)
,p_lov_name=>'Y_NOPROMPT'
,p_lov_query=>'.'||wwv_flow_imp.id(88018003898325845)||'.'
,p_location=>'STATIC'
,p_version_scn=>75558137
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88018226427325846)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;',
'',
''))
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/pages/page_groups
begin
wwv_flow_imp_page.create_page_group(
 p_id=>wwv_flow_imp.id(215533113079716670)
,p_group_name=>'Browse Database Object Definitions'
,p_group_desc=>'Browse database objects.'
);
wwv_flow_imp_page.create_page_group(
 p_id=>wwv_flow_imp.id(215538527409730225)
,p_group_name=>'Create / Alter / Drop Database Objects'
,p_group_desc=>'Wizards to create database objects.'
);
wwv_flow_imp_page.create_page_group(
 p_id=>wwv_flow_imp.id(215532403383713875)
,p_group_name=>'DDL Generation'
,p_group_desc=>'Create data definition language SQL scripts.'
);
wwv_flow_imp_page.create_page_group(
 p_id=>wwv_flow_imp.id(215533519659718594)
,p_group_name=>'Data Dicitonary Browsing'
,p_group_desc=>'Query the data dictionary.'
);
wwv_flow_imp_page.create_page_group(
 p_id=>wwv_flow_imp.id(275619009526176844)
,p_group_name=>'Data Dictionary Reporting'
);
wwv_flow_imp_page.create_page_group(
 p_id=>wwv_flow_imp.id(276009919979760075)
,p_group_name=>'Data Dictionary Security Reports'
);
wwv_flow_imp_page.create_page_group(
 p_id=>wwv_flow_imp.id(276037127560809519)
,p_group_name=>'Data Dictionary Table Reports'
);
wwv_flow_imp_page.create_page_group(
 p_id=>wwv_flow_imp.id(109807152552070130)
,p_group_name=>'Data Generator'
);
wwv_flow_imp_page.create_page_group(
 p_id=>wwv_flow_imp.id(206250111084432914)
,p_group_name=>'Database Monitoring'
);
wwv_flow_imp_page.create_page_group(
 p_id=>wwv_flow_imp.id(206341928994677765)
,p_group_name=>'Manage Database Users (Schemas)'
);
wwv_flow_imp_page.create_page_group(
 p_id=>wwv_flow_imp.id(11540120040990569)
,p_group_name=>'Object Browser Iframe Pages'
);
wwv_flow_imp_page.create_page_group(
 p_id=>wwv_flow_imp.id(276002212445738952)
,p_group_name=>'PL/SQL Object Reports'
);
wwv_flow_imp_page.create_page_group(
 p_id=>wwv_flow_imp.id(215663614239000844)
,p_group_name=>'Query By Example'
,p_group_desc=>'Perform query and update of database table data. Includes insert update and delete functionality.'
);
wwv_flow_imp_page.create_page_group(
 p_id=>wwv_flow_imp.id(215661000733996927)
,p_group_name=>'Recycle Bin'
,p_group_desc=>'Facilitate use of 10g recycle bin'
);
wwv_flow_imp_page.create_page_group(
 p_id=>wwv_flow_imp.id(213236325564854129)
,p_group_name=>'SQL Command Processing'
,p_group_desc=>'SQL Command Processing'
);
wwv_flow_imp_page.create_page_group(
 p_id=>wwv_flow_imp.id(213236600761856491)
,p_group_name=>'Script Management'
,p_group_desc=>'All pages related to the definition and management of scripts.'
);
wwv_flow_imp_page.create_page_group(
 p_id=>wwv_flow_imp.id(215628425752985221)
,p_group_name=>'Table Normalization'
,p_group_desc=>'Create a look up table.'
);
wwv_flow_imp_page.create_page_group(
 p_id=>wwv_flow_imp.id(201270629259751113)
,p_group_name=>'UI Defaults'
);
wwv_flow_imp_page.create_page_group(
 p_id=>wwv_flow_imp.id(11093307704620192)
,p_group_name=>'Version 2.0'
,p_group_desc=>'Keep this page in version 2.0'
);
wwv_flow_imp_page.create_page_group(
 p_id=>wwv_flow_imp.id(11539602725985552)
,p_group_name=>'Version 2.0 : Object Browser'
);
end;
/
prompt --application/shared_components/navigation/breadcrumbs/sql_workshop_breadcrumb
begin
wwv_flow_imp_shared.create_menu(
 p_id=>wwv_flow_imp.id(6696510824685479)
,p_name=>'sql.workshop.breadcrumb'
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(772329493998247)
,p_short_name=>'<span class="u-VisuallyHidden">SQL Workshop</span><span class="a-Icon icon-breadcrumb-previous" title="SQL Workshop"></span>'
,p_link=>'f?p=&APP_ID.:3002:&SESSION.::&DEBUG.:::'
,p_page_id=>3002
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(1617280034078536)
,p_parent_id=>wwv_flow_imp.id(1739076704334540)
,p_short_name=>'Blueprint Designer'
,p_link=>'f?p=&APP_ID.:4100:&SESSION.::&DEBUG.:::'
,p_page_id=>4100
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(1739076704334540)
,p_parent_id=>wwv_flow_imp.id(10594829078900305)
,p_short_name=>'Data Generator'
,p_link=>'f?p=&APP_ID.:4000:&SESSION.::&DEBUG.:::'
,p_page_id=>4000
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(1739233835336975)
,p_parent_id=>wwv_flow_imp.id(1739076704334540)
,p_short_name=>'Create Tables Blueprint'
,p_link=>'f?p=&APP_ID.:4001:&SESSION.::&DEBUG.:::'
,p_page_id=>4001
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(1739498683340270)
,p_parent_id=>wwv_flow_imp.id(1739233835336975)
,p_short_name=>'Table: &P4002_BLUEPRINT_TABLE_NAME.'
,p_link=>'f?p=&APP_ID.:4002:&SESSION.::&DEBUG.:::'
,p_page_id=>4002
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(1917207507033256)
,p_parent_id=>wwv_flow_imp.id(772329493998247)
,p_short_name=>'Object Browser'
,p_link=>'f?p=&APP_ID.:2000:&SESSION.::&DEBUG.:::'
,p_page_id=>2000
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(2107388801517405)
,p_parent_id=>wwv_flow_imp.id(10594829078900305)
,p_short_name=>'Load from Object Store'
,p_link=>'f?p=&APP_ID.:3130:&SESSION.::&DEBUG.:3130::'
,p_page_id=>3130
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(2234766158770718)
,p_parent_id=>wwv_flow_imp.id(10594829078900305)
,p_short_name=>'Load from Object Store'
,p_link=>'f?p=&APP_ID.:3132:&SESSION.::&DEBUG.:::'
,p_page_id=>3132
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(2632992076169026)
,p_parent_id=>wwv_flow_imp.id(2107388801517405)
,p_short_name=>'Review External Table'
,p_link=>'f?p=&APP_ID.:3140:&SESSION.::&DEBUG.:::'
,p_page_id=>3140
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(2911233921630113)
,p_parent_id=>wwv_flow_imp.id(1739076704334540)
,p_short_name=>'Built Ins'
,p_link=>'f?p=&APP_ID.:4011:&SESSION.::&DEBUG.:::'
,p_page_id=>4011
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(6705201527713238)
,p_parent_id=>wwv_flow_imp.id(11085502299574373)
,p_short_name=>'Data Dictionary'
,p_link=>'f?p=&APP_ID.:13:&SESSION.::&DEBUG.:::'
,p_page_id=>13
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(6706426100716981)
,p_parent_id=>wwv_flow_imp.id(11085502299574373)
,p_short_name=>'All Objects'
,p_link=>'f?p=&APP_ID.:500:&SESSION.::&DEBUG.:::'
,p_page_id=>500
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(6811015570619086)
,p_parent_id=>wwv_flow_imp.id(10594829078900305)
,p_short_name=>'Generate DDL'
,p_link=>'f?p=&APP_ID.:18:&SESSION.::&DEBUG.:::'
,p_page_id=>18
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(6812109315622008)
,p_parent_id=>wwv_flow_imp.id(10594829078900305)
,p_short_name=>'Generate DDL'
,p_link=>'f?p=&APP_ID.:43:&SESSION.::&DEBUG.:::'
,p_page_id=>43
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(6813302846625021)
,p_parent_id=>wwv_flow_imp.id(10594829078900305)
,p_short_name=>'Generate DDL'
,p_link=>'f?p=&APP_ID.:44:&SESSION.::&DEBUG.:::'
,p_page_id=>44
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(6814424184630342)
,p_parent_id=>wwv_flow_imp.id(10594829078900305)
,p_short_name=>'Generate DDL'
,p_link=>'f?p=&APP_ID.:29:&SESSION.::&DEBUG.:::'
,p_page_id=>29
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(8926117673071967)
,p_parent_id=>wwv_flow_imp.id(11085502299574373)
,p_short_name=>'Object Grants'
,p_link=>'f?p=&APP_ID.:1401:&SESSION.::&DEBUG.:::'
,p_page_id=>1401
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(8952218341276601)
,p_parent_id=>wwv_flow_imp.id(11085502299574373)
,p_short_name=>'Column Privileges'
,p_link=>'f?p=&APP_ID.:1402:&SESSION.::&DEBUG.:::'
,p_page_id=>1402
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(8971325993409812)
,p_parent_id=>wwv_flow_imp.id(11085502299574373)
,p_short_name=>'Role Privileges'
,p_link=>'f?p=&APP_ID.:1502:&SESSION.::&DEBUG.:::'
,p_page_id=>1502
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(10124106014708590)
,p_parent_id=>wwv_flow_imp.id(10593427149886024)
,p_short_name=>'Manage Script Results'
,p_link=>'f?p=&APP_ID.:1220:&SESSION.::&DEBUG.:1220::'
,p_page_id=>1220
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(10592208399879519)
,p_parent_id=>wwv_flow_imp.id(772329493998247)
,p_short_name=>'SQL Commands'
,p_link=>'f?p=&APP_ID.:1003:&SESSION.::&DEBUG.:::'
,p_page_id=>1003
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(10593427149886024)
,p_parent_id=>wwv_flow_imp.id(772329493998247)
,p_short_name=>'SQL Scripts'
,p_link=>'f?p=&APP_ID.:1004:&SESSION.::&DEBUG.:::'
,p_page_id=>1004
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(10594829078900305)
,p_parent_id=>wwv_flow_imp.id(772329493998247)
,p_short_name=>'Utilities'
,p_link=>'f?p=&APP_ID.:1005:&SESSION.::&DEBUG.:::'
,p_page_id=>1005
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(10596216354906213)
,p_parent_id=>wwv_flow_imp.id(10594829078900305)
,p_short_name=>'Query Builder'
,p_link=>'f?p=&APP_ID.:1002:&SESSION.::&DEBUG.:::'
,p_page_id=>1002
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(10992323079081645)
,p_parent_id=>wwv_flow_imp.id(10593427149886024)
,p_short_name=>'Upload Script'
,p_link=>'f?p=&FLOW_ID.:1017:&SESSION.'
,p_page_id=>1017
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(11068702995513360)
,p_parent_id=>wwv_flow_imp.id(11085502299574373)
,p_short_name=>'Invalid Objects'
,p_link=>'f?p=&APP_ID.:1040:&SESSION.::&DEBUG.:::'
,p_page_id=>1040
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(11085502299574373)
,p_parent_id=>wwv_flow_imp.id(10594829078900305)
,p_short_name=>'Object Reports'
,p_link=>'f?p=&APP_ID.:1042:&SESSION.::&DEBUG.:::'
,p_page_id=>1042
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(11149705248454307)
,p_parent_id=>wwv_flow_imp.id(11085502299574373)
,p_short_name=>'PL/SQL Program Unit Arguments'
,p_link=>'f?p=&APP_ID.:1046:&SESSION.::&DEBUG.:::'
,p_page_id=>1046
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(11153616234464356)
,p_parent_id=>wwv_flow_imp.id(11085502299574373)
,p_short_name=>'Table Columns'
,p_link=>'f?p=&APP_ID.:1047:&SESSION.::&DEBUG.:::'
,p_page_id=>1047
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(11217630077734286)
,p_parent_id=>wwv_flow_imp.id(11085502299574373)
,p_short_name=>'Table Storage Sizes'
,p_link=>'f?p=&APP_ID.:1048:&SESSION.::&DEBUG.:::'
,p_page_id=>1048
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(11288509439457981)
,p_parent_id=>wwv_flow_imp.id(11085502299574373)
,p_short_name=>'Table Statistics'
,p_link=>'f?p=&APP_ID.:1052:&SESSION.::&DEBUG.:::'
,p_page_id=>1052
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(11326702174643629)
,p_parent_id=>wwv_flow_imp.id(11085502299574373)
,p_short_name=>'PL/SQL Unit Line Counts'
,p_link=>'f?p=&APP_ID.:1054:&SESSION.::&DEBUG.:::'
,p_page_id=>1054
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(11338430795706423)
,p_parent_id=>wwv_flow_imp.id(11085502299574373)
,p_short_name=>'Object Creation Calendar'
,p_link=>'f?p=&APP_ID.:1055:&SESSION.::&DEBUG.:::'
,p_page_id=>1055
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(11357823604800886)
,p_parent_id=>wwv_flow_imp.id(11085502299574373)
,p_short_name=>'Object Counts by Type'
,p_link=>'f?p=&APP_ID.:1059:&SESSION.::&DEBUG.:::'
,p_page_id=>1059
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(11399029987478216)
,p_parent_id=>wwv_flow_imp.id(10594829078900305)
,p_short_name=>'Recycle Bin'
,p_link=>'f?p=&APP_ID.:1070:&SESSION.::&DEBUG.:::'
,p_page_id=>1070
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(11862912827302953)
,p_parent_id=>wwv_flow_imp.id(10593427149886024)
,p_short_name=>'Results'
,p_link=>'f?p=&APP_ID.:1225:&SESSION.::&DEBUG.:::'
,p_page_id=>1225
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(14636719155541383)
,p_parent_id=>wwv_flow_imp.id(10594829078900305)
,p_short_name=>'Schema Comparison'
,p_link=>'f?p=&FLOW_ID.:1350:&SESSION.'
,p_page_id=>1350
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(17981116039285577)
,p_parent_id=>wwv_flow_imp.id(11085502299574373)
,p_short_name=>'Table Comments'
,p_link=>'f?p=&APP_ID.:701:&SESSION.::&DEBUG.:::'
,p_page_id=>701
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(18641121311026961)
,p_parent_id=>wwv_flow_imp.id(11085502299574373)
,p_short_name=>'Tables without Primary Keys'
,p_link=>'f?p=&APP_ID.:702:&SESSION.::&DEBUG.:::'
,p_page_id=>702
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(18645002872040514)
,p_parent_id=>wwv_flow_imp.id(11085502299574373)
,p_short_name=>'Unindexed Foreign Keys'
,p_link=>'f?p=&APP_ID.:704:&SESSION.::&DEBUG.:::'
,p_page_id=>704
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(20466103415554205)
,p_parent_id=>wwv_flow_imp.id(10594829078900305)
,p_short_name=>'Database Administrator Login'
,p_link=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:::'
,p_page_id=>1
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(21105931218170005)
,p_parent_id=>wwv_flow_imp.id(11085502299574373)
,p_short_name=>'Table Constraints'
,p_link=>'f?p=&APP_ID.:706:&SESSION.::&DEBUG.:::'
,p_page_id=>706
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(22279723159373331)
,p_parent_id=>wwv_flow_imp.id(10593427149886024)
,p_short_name=>'Run Script'
,p_link=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.:::'
,p_page_id=>10
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(22285026166387102)
,p_parent_id=>wwv_flow_imp.id(10593427149886024)
,p_short_name=>'Script Editor'
,p_link=>'f?p=&APP_ID.:60:&SESSION.::&DEBUG.:::'
,p_page_id=>60
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(22511901715091409)
,p_parent_id=>wwv_flow_imp.id(6705201527713238)
,p_short_name=>'Data Dictionary Browser'
,p_link=>'f?p=&FLOW_ID.:14:&SESSION.'
,p_page_id=>14
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(22513030170093436)
,p_parent_id=>wwv_flow_imp.id(6705201527713238)
,p_short_name=>'Data Dictionary Browser'
,p_link=>'f?p=&FLOW_ID.:15:&SESSION.'
,p_page_id=>15
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(27996403095868309)
,p_parent_id=>wwv_flow_imp.id(10593427149886024)
,p_short_name=>'Invalid Script'
,p_link=>'f?p=&APP_ID.:1022:&SESSION.::&DEBUG.:::'
,p_page_id=>1022
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(28034702528035781)
,p_parent_id=>wwv_flow_imp.id(10593427149886024)
,p_short_name=>'Parse Script'
,p_link=>'f?p=&FLOW_ID.:1023:&SESSION.'
,p_page_id=>1023
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(29042426642278445)
,p_parent_id=>wwv_flow_imp.id(11085502299574373)
,p_short_name=>'Tables without Indexes'
,p_link=>'f?p=&APP_ID.:707:&SESSION.::&DEBUG.:::'
,p_page_id=>707
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(40285323892651842)
,p_parent_id=>wwv_flow_imp.id(421010727467722425)
,p_short_name=>'Table Dictionary'
,p_link=>'f?p=&APP_ID.:800:&SESSION.::&DEBUG.:::'
,p_page_id=>800
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(40292805535877838)
,p_parent_id=>wwv_flow_imp.id(40285323892651842)
,p_short_name=>'Create Defaults'
,p_link=>'f?p=&APP_ID.:801:&SESSION.::&DEBUG.:::'
,p_page_id=>801
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(40299503213041788)
,p_parent_id=>wwv_flow_imp.id(40285323892651842)
,p_short_name=>'Table and Column Properties'
,p_link=>'f?p=&APP_ID.:802:&SESSION.::&DEBUG.:::'
,p_page_id=>802
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(40567512492661701)
,p_parent_id=>wwv_flow_imp.id(40299503213041788)
,p_short_name=>'Column Defaults'
,p_link=>'f?p=&APP_ID.:803:&SESSION.::&DEBUG.:::'
,p_page_id=>803
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(40643306074424515)
,p_parent_id=>wwv_flow_imp.id(40299503213041788)
,p_short_name=>'Details'
,p_link=>'f?p=&APP_ID.:804:&SESSION.::&DEBUG.:::'
,p_page_id=>804
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(40820227368905885)
,p_parent_id=>wwv_flow_imp.id(40299503213041788)
,p_short_name=>'Remove'
,p_link=>'f?p=&APP_ID.:830:&SESSION.::&DEBUG.:::'
,p_page_id=>830
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(40837720793349176)
,p_parent_id=>wwv_flow_imp.id(40299503213041788)
,p_short_name=>'Column Groups'
,p_link=>'f?p=&FLOW_ID.:805:&SESSION.'
,p_page_id=>805
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(40849914508722527)
,p_parent_id=>wwv_flow_imp.id(40285323892651842)
,p_short_name=>'Synchronize Defaults'
,p_link=>'f?p=&APP_ID.:840:&SESSION.::&DEBUG.:::'
,p_page_id=>840
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(40878107658219856)
,p_parent_id=>wwv_flow_imp.id(40285323892651842)
,p_short_name=>'Export'
,p_link=>'f?p=&APP_ID.:841:&SESSION.::&DEBUG.:::'
,p_page_id=>841
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(40882008035232666)
,p_parent_id=>wwv_flow_imp.id(40285323892651842)
,p_short_name=>'Import'
,p_link=>'f?p=&APP_ID.:842:&SESSION.::&DEBUG.:::'
,p_page_id=>842
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(40886501144281716)
,p_parent_id=>wwv_flow_imp.id(40285323892651842)
,p_short_name=>'Import'
,p_link=>'f?p=&APP_ID.:843:&SESSION.::&DEBUG.:::'
,p_page_id=>843
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(69179911399462494)
,p_parent_id=>wwv_flow_imp.id(11085502299574373)
,p_short_name=>'Tables without Triggers'
,p_link=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:RP::'
,p_page_id=>2
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(72162217233653931)
,p_parent_id=>wwv_flow_imp.id(11399029987478216)
,p_short_name=>'Dropped Objects'
,p_link=>'f?p=&APP_ID.:400:&SESSION.::&DEBUG.:::'
,p_page_id=>400
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(75123728807801147)
,p_parent_id=>wwv_flow_imp.id(10594829078900305)
,p_short_name=>'Generate DDL'
,p_link=>'f?p=&APP_ID.:45:&SESSION.::&DEBUG.:::'
,p_page_id=>45
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(111995318366763047)
,p_parent_id=>wwv_flow_imp.id(10594829078900305)
,p_short_name=>'Generate DDL'
,p_link=>'f?p=&APP_ID.:12:&SESSION.::&DEBUG.:::'
,p_page_id=>12
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(133761526646244887)
,p_parent_id=>wwv_flow_imp.id(10594829078900305)
,p_short_name=>'Database Monitor'
,p_link=>'f?p=&APP_ID.:11:&SESSION.::&DEBUG.:::'
,p_page_id=>11
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(134582607728955084)
,p_parent_id=>wwv_flow_imp.id(133761526646244887)
,p_short_name=>'Top SQL'
,p_link=>'f?p=&FLOW_ID.:21:&SESSION.'
,p_page_id=>21
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(137474117958285727)
,p_parent_id=>wwv_flow_imp.id(133761526646244887)
,p_short_name=>'Long Operations'
,p_link=>'f?p=&FLOW_ID.:34:&SESSION.'
,p_page_id=>34
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(143179626108764932)
,p_parent_id=>wwv_flow_imp.id(72162217233653931)
,p_short_name=>'Object Details'
,p_link=>'f?p=&APP_ID.:401:&SESSION.::&DEBUG.:::'
,p_page_id=>401
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(143180608231769218)
,p_parent_id=>wwv_flow_imp.id(11399029987478216)
,p_short_name=>'Purge Recycle Bin'
,p_link=>'f?p=&APP_ID.:403:&SESSION.::&DEBUG.:::'
,p_page_id=>403
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(150053105689895122)
,p_parent_id=>wwv_flow_imp.id(10593427149886024)
,p_short_name=>'Script Quotas'
,p_link=>'f?p=&APP_ID.:31:&SESSION.::&DEBUG.:::'
,p_page_id=>31
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(159591503203412870)
,p_parent_id=>wwv_flow_imp.id(133761526646244887)
,p_short_name=>'Sessions'
,p_link=>'f?p=&FLOW_ID.:540:&SESSION.'
,p_page_id=>540
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(159755809418519186)
,p_parent_id=>wwv_flow_imp.id(159591503203412870)
,p_short_name=>'Session Details'
,p_link=>'f?p=&APP_ID.:550:&SESSION.::&DEBUG.:::'
,p_page_id=>550
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(159933105269080223)
,p_parent_id=>wwv_flow_imp.id(159591503203412870)
,p_short_name=>'Kill Session'
,p_link=>'f?p=&APP_ID.:549:&SESSION.::&DEBUG.:::'
,p_page_id=>549
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(160130313889480180)
,p_parent_id=>wwv_flow_imp.id(159591503203412870)
,p_short_name=>'SQL'
,p_link=>'f?p=&APP_ID.:542:&SESSION.::&DEBUG.:::'
,p_page_id=>542
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(160176710875611770)
,p_parent_id=>wwv_flow_imp.id(159591503203412870)
,p_short_name=>'I/O'
,p_link=>'f?p=&APP_ID.:545:&SESSION.::&DEBUG.:::'
,p_page_id=>545
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(160179326112616109)
,p_parent_id=>wwv_flow_imp.id(159591503203412870)
,p_short_name=>'Locks'
,p_link=>'f?p=&APP_ID.:541:&SESSION.::&DEBUG.:::'
,p_page_id=>541
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(160301306026960460)
,p_parent_id=>wwv_flow_imp.id(159591503203412870)
,p_short_name=>'Open Cursors'
,p_link=>'f?p=&APP_ID.:543:&SESSION.::&DEBUG.:::'
,p_page_id=>543
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(160475100044505141)
,p_parent_id=>wwv_flow_imp.id(160130313889480180)
,p_short_name=>'SQL Plan'
,p_link=>'f?p=&FLOW_ID.:551:&SESSION.'
,p_page_id=>551
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(160542529171631000)
,p_parent_id=>wwv_flow_imp.id(160301306026960460)
,p_short_name=>'Cursor Detail'
,p_link=>'f?p=&APP_ID.:546:&SESSION.::&DEBUG.:::'
,p_page_id=>546
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(163508316960932084)
,p_parent_id=>wwv_flow_imp.id(11085502299574373)
,p_short_name=>'Search PL/SQL Source Code'
,p_link=>'f?p=&APP_ID.:27:&SESSION.::&DEBUG.:::'
,p_page_id=>27
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(164008763793256066)
,p_parent_id=>wwv_flow_imp.id(10594829078900305)
,p_short_name=>'Manage Sample Data'
,p_link=>'f?p=&APP_ID.:200:&SESSION.'
,p_page_id=>200
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(164035265026435705)
,p_parent_id=>wwv_flow_imp.id(164008763793256066)
,p_short_name=>'Manage Dataset'
,p_link=>'f?p=&APP_ID.:201:&SESSION.'
,p_page_id=>201
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(168883113098410783)
,p_parent_id=>wwv_flow_imp.id(159591503203412870)
,p_short_name=>'Waits'
,p_link=>'f?p=&APP_ID.:548:&SESSION.::&DEBUG.:::'
,p_page_id=>548
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(171482002943811468)
,p_parent_id=>wwv_flow_imp.id(772329493998247)
,p_short_name=>'Create Package'
,p_link=>'f?p=&APP_ID.:120:&SESSION.::&DEBUG.:::'
,p_page_id=>120
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(171486607219855054)
,p_parent_id=>wwv_flow_imp.id(772329493998247)
,p_short_name=>'Create Package'
,p_link=>'f?p=&APP_ID.:124:&SESSION.::&DEBUG.:::'
,p_page_id=>124
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(171488126185861375)
,p_parent_id=>wwv_flow_imp.id(772329493998247)
,p_short_name=>'Create Package'
,p_link=>'f?p=&APP_ID.:125:&SESSION.::&DEBUG.:::'
,p_page_id=>125
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(172518105625045296)
,p_parent_id=>wwv_flow_imp.id(10594829078900305)
,p_short_name=>'About Database'
,p_link=>'f?p=&APP_ID.:36:&SESSION.::&DEBUG.:::'
,p_page_id=>36
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(182583013828345804)
,p_parent_id=>wwv_flow_imp.id(133761526646244887)
,p_short_name=>'System Statistics'
,p_link=>'f?p=&APP_ID.:560:&SESSION.::&DEBUG.:::'
,p_page_id=>560
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(196241518637196386)
,p_parent_id=>wwv_flow_imp.id(421010727467722425)
,p_short_name=>'Attribute Dictionary'
,p_link=>'f?p=&APP_ID.:6:&SESSION.::&DEBUG.:::'
,p_page_id=>6
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(197565613605290234)
,p_parent_id=>wwv_flow_imp.id(196241518637196386)
,p_short_name=>'Column Details'
,p_link=>'f?p=&APP_ID.:17:&SESSION.::&DEBUG.:::'
,p_page_id=>17
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(200281305325646013)
,p_parent_id=>wwv_flow_imp.id(197565613605290234)
,p_short_name=>'Synonym'
,p_link=>'f?p=&APP_ID.:30:&SESSION.::&DEBUG.:::'
,p_page_id=>30
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(201423513077254455)
,p_parent_id=>wwv_flow_imp.id(40299503213041788)
,p_short_name=>'Table Defaults'
,p_link=>'f?p=&APP_ID.:19:&SESSION.::&DEBUG.:::'
,p_page_id=>19
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(201465410091357808)
,p_parent_id=>wwv_flow_imp.id(40285323892651842)
,p_short_name=>'Migrate'
,p_link=>'f?p=&APP_ID.:32:&SESSION.::&DEBUG.:::'
,p_page_id=>32
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(201468702160374868)
,p_parent_id=>wwv_flow_imp.id(201465410091357808)
,p_short_name=>'Confirm'
,p_link=>'f?p=&APP_ID.:33:&SESSION.::&DEBUG.:::'
,p_page_id=>33
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(221315102551645720)
,p_parent_id=>wwv_flow_imp.id(10593427149886024)
,p_short_name=>'Export SQL Scripts'
,p_link=>'f?p=&FLOW_ID.:65:&SESSION.'
,p_page_id=>65
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(221325920426667820)
,p_parent_id=>wwv_flow_imp.id(10593427149886024)
,p_short_name=>'Import Scripts'
,p_link=>'f?p=&APP_ID.:112:&SESSION.::&DEBUG.:::'
,p_page_id=>112
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(222573212803039290)
,p_parent_id=>wwv_flow_imp.id(10593427149886024)
,p_short_name=>'Import Scripts'
,p_link=>'f?p=&APP_ID.:115:&SESSION.::&DEBUG.:::'
,p_page_id=>115
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(239008520667654108)
,p_parent_id=>wwv_flow_imp.id(11085502299574373)
,p_short_name=>'System Privileges'
,p_link=>'f?p=&APP_ID.:1404:&SESSION.::&DEBUG.:::'
,p_page_id=>1404
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(262136511357898947)
,p_parent_id=>wwv_flow_imp.id(196241518637196386)
,p_short_name=>'Grid Edit'
,p_link=>'f?p=&APP_ID.:28:&SESSION.::&DEBUG.:::'
,p_page_id=>28
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(293412507991016597)
,p_parent_id=>wwv_flow_imp.id(40567512492661701)
,p_short_name=>'Static List of Values'
,p_link=>'f?p=&FLOW_ID.:37:&SESSION.'
,p_page_id=>37
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(421010727467722425)
,p_parent_id=>wwv_flow_imp.id(10594829078900305)
,p_short_name=>'UI Defaults'
,p_link=>'f?p=&APP_ID.:813:&SESSION.::&DEBUG.:::'
,p_page_id=>813
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(428883026446520866)
,p_parent_id=>wwv_flow_imp.id(40567512492661701)
,p_short_name=>'Create Static List of Values'
,p_link=>'f?p=&FLOW_ID.:40:&SESSION.'
,p_page_id=>40
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(429083825310173254)
,p_parent_id=>wwv_flow_imp.id(40299503213041788)
,p_short_name=>'Synchronize with Database'
,p_link=>'f?p=&APP_ID.:807:&SESSION.::&DEBUG.:::'
,p_page_id=>807
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(442018226743378979)
,p_parent_id=>wwv_flow_imp.id(196241518637196386)
,p_short_name=>'Export'
,p_link=>'f?p=&FLOW_ID.:39:&SESSION.'
,p_page_id=>39
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(442035418735604919)
,p_parent_id=>wwv_flow_imp.id(196241518637196386)
,p_short_name=>'Import'
,p_link=>'f?p=&FLOW_ID.:41:&SESSION.'
,p_page_id=>41
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(442061305390114586)
,p_parent_id=>wwv_flow_imp.id(196241518637196386)
,p_short_name=>'Import'
,p_link=>'f?p=&FLOW_ID.:56:&SESSION.'
,p_page_id=>56
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(460475029741643216)
,p_parent_id=>wwv_flow_imp.id(17981116039285577)
,p_short_name=>'Edit'
,p_link=>'f?p=&FLOW_ID.:70:&SESSION.'
,p_page_id=>70
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(1104480510265001727)
,p_parent_id=>wwv_flow_imp.id(772329493998247)
,p_short_name=>'Create Package'
,p_link=>'f?p=&APP_ID.:126:&SESSION.::&DEBUG.:::'
,p_page_id=>126
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(4213233088501710020)
,p_parent_id=>wwv_flow_imp.id(10594829078900305)
,p_short_name=>'Quick SQL'
,p_link=>'f?p=&APP_ID.:1100:&SESSION.::&DEBUG.:::'
,p_page_id=>1100
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(4067704225251042)
,p_parent_id=>wwv_flow_imp.id(1739076704334540)
,p_option_sequence=>20
,p_short_name=>'Blueprint: &P4015_BLUEPRINT_NAME.'
,p_link=>'f?p=&APP_ID.:4015:&SESSION.::&DEBUG.:::'
,p_page_id=>4015
);
end;
/
prompt --application/shared_components/navigation/breadcrumbs/alternative_sql_plan
begin
wwv_flow_imp_shared.create_menu(
 p_id=>wwv_flow_imp.id(238735327519050534)
,p_name=>'Alternative SQL Plan'
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(238744703025100258)
,p_parent_id=>wwv_flow_imp.id(239011303829658740)
,p_short_name=>'Database Monitor'
,p_link=>'f?p=&APP_ID.:11:&SESSION.::&DEBUG.:::'
,p_page_id=>11
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(238747600732109040)
,p_parent_id=>wwv_flow_imp.id(238744703025100258)
,p_short_name=>'Top SQL'
,p_link=>'f?p=&APP_ID.:21:&SESSION.::&DEBUG.:::'
,p_page_id=>21
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(238748709736111653)
,p_parent_id=>wwv_flow_imp.id(238747600732109040)
,p_short_name=>'SQL Plan'
,p_link=>'f?p=&APP_ID.:551:&SESSION.::&DEBUG.:::'
,p_page_id=>551
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(239011303829658740)
,p_parent_id=>wwv_flow_imp.id(467828023586139366)
,p_short_name=>'Utilities'
,p_link=>'f?p=&APP_ID.:1005:&SESSION.::&DEBUG.:::'
,p_page_id=>1005
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(467828023586139366)
,p_parent_id=>wwv_flow_imp.id(238741426181078594)
,p_short_name=>'SQL Workshop'
,p_link=>'f?p=&APP_ID.:3002:&SESSION.::&DEBUG.:::'
,p_page_id=>3002
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(851340608959428999)
,p_short_name=>'Import Scripts'
,p_link=>'f?p=&FLOW_ID.:115:&SESSION.'
,p_page_id=>115
);
end;
/
prompt --application/shared_components/navigation/breadcrumbentry
begin
null;
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_rw_faceted_search
begin
wwv_flow_imp_shared.create_template(
 p_id=>wwv_flow_imp.id(2060528835933702)
,p_theme_id=>3
,p_name=>'APEX RW - Faceted Search'
,p_internal_name=>'APEX_RW_-_FACETED_SEARCH'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES# a-Page--facetedSearch" #ONLOAD#>',
'<!--[if lte IE 9]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'<a href="#main" id="a_Body_skipToContent">&APP_TEXT$UI_PAGE_SKIP_TO_CONTENT.</a>',
'#ENVIRONMENT_BANNER#',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<header>',
'#REGION_POSITION_07#',
'</header>',
'#REGION_POSITION_09#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'#REGION_POSITION_02#',
'  <div id="main" class="a-Body">',
'    <aside class="a-Side">',
'        #REGION_POSITION_03#',
'    </aside>',
'    <main class="a-Main">',
'        #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'        #BODY#',
'    </main>',
'  </div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span role="img" class="a-Icon icon-user" title="&MSG_USER." aria-label="&MSG_USER."><span class="u-vh">&MSG_USER.</span></span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span role="img" class="a-Icon icon-workspace" title="&MSG_WORKSPACE." aria-label="&MSG_WORKSPACE."><span class="u-vh">&MSG_WORKSPACE.</span></span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span role="img" class="a-Icon icon-language" title="&MSG_LANGUAGE." aria-label="&MSG_LANGUAGE."><span class="u-vh">&MSG_LANGUAGE.</span></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#APEX_JAVASCRIPT#',
'#GENERATED_CSS#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg" role="region" aria-labelledby="page_success_id">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon" role="img" aria-label=''&"APP_TEXT$APEXDEV.ICON_LABEL.SUCCESS"!HTML.''></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 id="page_success_id" class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body" role="alert">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" aria-label="#CLOSE_NOTIFICATION#" title="#CLOSE_NOTIFICATION#"><span class="a-Icon '
||'icon-remove" aria-hidden="true"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg" role="region" aria-labelledby="page_warning_id">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon" role="img" aria-label=''&"APP_TEXT$APEXDEV.ICON_LABEL.WARNING"!HTML.''></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 id="page_warning_id" class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body" role="alert">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" aria-label="#CLOSE_NOTIFICATION#" title="#CLOSE_NOTIFICATION#"><span class="a-Icon '
||'icon-remove" aria-hidden="true"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_03'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_09'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>383682332851249713
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3156008623268891)
,p_page_template_id=>wwv_flow_imp.id(2060528835933702)
,p_name=>'Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3156584945268891)
,p_page_template_id=>wwv_flow_imp.id(2060528835933702)
,p_name=>'Page Header (Position 3)'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>false
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3157074495268891)
,p_page_template_id=>wwv_flow_imp.id(2060528835933702)
,p_name=>'Page Header (Position 4)'
,p_placeholder=>'REGION_POSITION_02'
,p_has_grid_support=>false
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3157561784268892)
,p_page_template_id=>wwv_flow_imp.id(2060528835933702)
,p_name=>'Facets'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3158035335268892)
,p_page_template_id=>wwv_flow_imp.id(2060528835933702)
,p_name=>'After Body'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>false
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3158582356268892)
,p_page_template_id=>wwv_flow_imp.id(2060528835933702)
,p_name=>'Page Header (Position 1)'
,p_placeholder=>'REGION_POSITION_07'
,p_has_grid_support=>false
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3159015633268892)
,p_page_template_id=>wwv_flow_imp.id(2060528835933702)
,p_name=>'Page Header (Position 2)'
,p_placeholder=>'REGION_POSITION_08'
,p_has_grid_support=>false
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3159537102268892)
,p_page_template_id=>wwv_flow_imp.id(2060528835933702)
,p_name=>'Control Bar'
,p_placeholder=>'REGION_POSITION_09'
,p_has_grid_support=>false
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_page_designer
begin
wwv_flow_imp_shared.create_template(
 p_id=>wwv_flow_imp.id(8700783499134798)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Page Designer'
,p_internal_name=>'APEX_5.0_PAGE_DESIGNER'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#HEAD#',
'</head>',
'<body #ONLOAD# class="#PAGE_CSS_CLASSES#">',
'<noscript>&MSG_JSCRIPT.</noscript>',
'<a href="#a_PageDesigner" id="a_Body_skipToContent">&APP_TEXT$UI_PAGE_SKIP_TO_CONTENT.</a>',
'#ENVIRONMENT_BANNER#',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_01#',
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" style="display: none;" id="pdNotification">',
' <div class="a-AlertMessages-item">',
'  <div id="pdNotificationState" class="a-MediaBlock a-AlertMessages-message is-success">',
'    <div class="a-MediaBlock-graphic">',
'      <span id="pdNotificationIcon" class="a-Icon a-Icon--medium icon-check"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="pdNotificationMessage">#PD_MESSAGE#</h5>',
'      <button id="pdNotificationClose" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>',
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'',
'',
'<div id="a_PageDesigner" class="a-PageDesigner resize">',
'  #REGION_POSITION_02#',
'  #REGION_POSITION_03#',
'  #REGION_POSITION_04#',
'  #BODY#',
'  <div style="display:none;">',
'  #REGION_POSITION_06#',
'  </div>',
'</div>',
''))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#APEX_JAVASCRIPT#',
'#GENERATED_CSS#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--<div class="aNotification success" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>-->',
'<div style="display: none;" id="successMessage" role="alert">#SUCCESS_MESSAGE#</div>',
''))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>'<div class="apex-container">#ROWS#</div>'
,p_grid_row_template=>'<div class="apex-row">#COLUMNS#</div>'
,p_grid_column_template=>'<div class="apex-col apex-col-#COLUMN_NUMBER# #CSS_CLASSES#">#CONTENT#</div>'
,p_dialog_browser_frame=>'MODAL'
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(8707702767134841)
,p_page_template_id=>wwv_flow_imp.id(8700783499134798)
,p_name=>'Page Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(8708205425134841)
,p_page_template_id=>wwv_flow_imp.id(8700783499134798)
,p_name=>'Page Position 1'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(8708748551134841)
,p_page_template_id=>wwv_flow_imp.id(8700783499134798)
,p_name=>'Page Position 2'
,p_placeholder=>'REGION_POSITION_02'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(8709230306134842)
,p_page_template_id=>wwv_flow_imp.id(8700783499134798)
,p_name=>'Page Position 3'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(8709793241134842)
,p_page_template_id=>wwv_flow_imp.id(8700783499134798)
,p_name=>'Page Position 4'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(8710277851134842)
,p_page_template_id=>wwv_flow_imp.id(8700783499134798)
,p_name=>'Dialog Area'
,p_placeholder=>'REGION_POSITION_06'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>-1
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(8710720911134843)
,p_page_template_id=>wwv_flow_imp.id(8700783499134798)
,p_name=>'Page Position 7'
,p_placeholder=>'REGION_POSITION_07'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/done_minimal_for_ppr_pulls
begin
wwv_flow_imp_shared.create_template(
 p_id=>wwv_flow_imp.id(14599108081253832)
,p_theme_id=>3
,p_name=>'[x] Minimal For PPR Pulls'
,p_internal_name=>'DONE_MINIMAL_FOR_PPR_PULLS'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">',
'',
'<head>',
'',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#HEAD#',
'<title>#TITLE#</title>',
'</head>',
'<body onload="parent.htmldb_PageLoaded(this)">',
'#ENVIRONMENT_BANNER#',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<htmldb:SUCCESS_MESSAGE><div id="SUCCESS_MESSAGE">#SUCCESS_MESSAGE#</div></htmldb:SUCCESS_MESSAGE>',
'<htmldb:NOTIFICATION_MESSAGE><div id="NOTIFICATION_MESSAGE">#NOTIFICATION_MESSAGE#</div></htmldb:NOTIFICATION_MESSAGE>',
'<htmldb:GLOBAL_NOTIFICATION><div id="GLOBAL_NOTIFICATION">#GLOBAL_NOTIFICATION#</div></htmldb:GLOBAL_NOTIFICATION>',
'<htmldb:REGION_POSITION_01><div id="REGION_POSITION_01">#REGION_POSITION_01#</div></htmldb:REGION_POSITION_01>',
'<htmldb:REGION_POSITION_02><div id="REGION_POSITION_02">#REGION_POSITION_02#</div></htmldb:REGION_POSITION_02>',
'<htmldb:REGION_POSITION_03><div id="REGION_POSITION_03">#REGION_POSITION_03#</div></htmldb:REGION_POSITION_03>',
'<htmldb:REGION_POSITION_04><div id="REGION_POSITION_04">#REGION_POSITION_04#</div></htmldb:REGION_POSITION_04>',
'<htmldb:REGION_POSITION_05><div id="REGION_POSITION_05">#REGION_POSITION_05#</div></htmldb:REGION_POSITION_05>',
'<htmldb:REGION_POSITION_06><div id="REGION_POSITION_06">#REGION_POSITION_06#</div></htmldb:REGION_POSITION_06>',
'<htmldb:REGION_POSITION_08><div id="REGION_POSITION_08">#REGION_POSITION_08#</div></htmldb:REGION_POSITION_08>',
'<htmldb:BOX_BODY><div id="BOX_BODY">#BODY#</div></htmldb:BOX_BODY>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#APEX_JAVASCRIPT#',
'#GENERATED_CSS#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden" role="alert">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_theme_class_id=>8
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>14502301802938058
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(72720613825033039)
,p_page_template_id=>wwv_flow_imp.id(14599108081253832)
,p_name=>'Page Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(72721161344033039)
,p_page_template_id=>wwv_flow_imp.id(14599108081253832)
,p_name=>'Page Position 1'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(72721644609033040)
,p_page_template_id=>wwv_flow_imp.id(14599108081253832)
,p_name=>'Page Position 2'
,p_placeholder=>'REGION_POSITION_02'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(72722131917033041)
,p_page_template_id=>wwv_flow_imp.id(14599108081253832)
,p_name=>'Page Position 3'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(72722693387033041)
,p_page_template_id=>wwv_flow_imp.id(14599108081253832)
,p_name=>'Page Position 4'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(72723140320033042)
,p_page_template_id=>wwv_flow_imp.id(14599108081253832)
,p_name=>'Page Position 5'
,p_placeholder=>'REGION_POSITION_05'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(72723686956033042)
,p_page_template_id=>wwv_flow_imp.id(14599108081253832)
,p_name=>'Page Position 6'
,p_placeholder=>'REGION_POSITION_06'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(72724150466033042)
,p_page_template_id=>wwv_flow_imp.id(14599108081253832)
,p_name=>'Page Position 8'
,p_placeholder=>'REGION_POSITION_08'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/done_popup
begin
wwv_flow_imp_shared.create_template(
 p_id=>wwv_flow_imp.id(102479827851590823)
,p_theme_id=>3
,p_name=>'[x] Popup'
,p_internal_name=>'DONE_POPUP'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8">',
'    <title>#TITLE#</title>',
'    <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'    ',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#HEAD#',
'</head>',
'<body #ONLOAD# class="aPopupPage">',
'    <noscript>&MSG_JSCRIPT.</noscript>#FORM_OPEN#<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="htmldbMessageHolder">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div>#REGION_POSITION_02##REGION_POSITION_03##REGION_POSITION_04##REGION_POSITION_05##REGION_POSITION_06##BODY#</div>',
'<div style="text-align:middle;">#REGION_POSITION_08#</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#APEX_JAVASCRIPT#',
'#GENERATED_CSS#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden" role="alert">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>19940022257958945
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(72747837208039244)
,p_page_template_id=>wwv_flow_imp.id(102479827851590823)
,p_name=>'Page Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(72748383231039244)
,p_page_template_id=>wwv_flow_imp.id(102479827851590823)
,p_name=>'Page Position 2'
,p_placeholder=>'REGION_POSITION_02'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(72748845206039245)
,p_page_template_id=>wwv_flow_imp.id(102479827851590823)
,p_name=>'Page Position 3'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(72749324646039245)
,p_page_template_id=>wwv_flow_imp.id(102479827851590823)
,p_name=>'Page Position 4'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(72749812168039246)
,p_page_template_id=>wwv_flow_imp.id(102479827851590823)
,p_name=>'Page Position 5'
,p_placeholder=>'REGION_POSITION_05'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(72750360374039246)
,p_page_template_id=>wwv_flow_imp.id(102479827851590823)
,p_name=>'Page Position 6'
,p_placeholder=>'REGION_POSITION_06'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(72750803591039247)
,p_page_template_id=>wwv_flow_imp.id(102479827851590823)
,p_name=>'Page Position 8'
,p_placeholder=>'REGION_POSITION_08'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_4_2_popup
begin
wwv_flow_imp_shared.create_template(
 p_id=>wwv_flow_imp.id(203703017586195109)
,p_theme_id=>3
,p_name=>'[x] APEX 4.2 - Popup'
,p_internal_name=>'APEX_4.2_POPUP'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title><link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#HEAD#',
'</head><body #ONLOAD# style="min-width:380px;"><noscript>&MSG_JSCRIPT.</noscript>#FORM_OPEN#<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="htmldbMessageHolder">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div>',
'  <div id="RP2">#REGION_POSITION_02#</div>',
'  <div id="RP3">#REGION_POSITION_03#</div>',
'  <div id="RP4">#REGION_POSITION_04#</div>',
'  <div id="RP5">#REGION_POSITION_05#</div>',
'  <div class="popupContent" id="ContentArea">#BODY#</div>',
'</div>',
'<div id="RP8" style="text-align:middle;">#REGION_POSITION_08#</div>',
'<br />',
'<br />',
''))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#APEX_JAVASCRIPT#',
'#GENERATED_CSS#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden" role="alert">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>36144306570651063
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(72523296440978248)
,p_page_template_id=>wwv_flow_imp.id(203703017586195109)
,p_name=>'Page Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(72523702339978248)
,p_page_template_id=>wwv_flow_imp.id(203703017586195109)
,p_name=>'Page Position 2'
,p_placeholder=>'REGION_POSITION_02'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(72524242413978249)
,p_page_template_id=>wwv_flow_imp.id(203703017586195109)
,p_name=>'Page Position 3'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(72524768893978249)
,p_page_template_id=>wwv_flow_imp.id(203703017586195109)
,p_name=>'Page Position 4'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(72525268743978250)
,p_page_template_id=>wwv_flow_imp.id(203703017586195109)
,p_name=>'Page Position 5'
,p_placeholder=>'REGION_POSITION_05'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(72525772106978250)
,p_page_template_id=>wwv_flow_imp.id(203703017586195109)
,p_name=>'Page Position 8'
,p_placeholder=>'REGION_POSITION_08'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_data_generator
begin
wwv_flow_imp_shared.create_template(
 p_id=>wwv_flow_imp.id(255350889127290340)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Data Generator'
,p_internal_name=>'APEX_5.0_DATA_GENERATOR'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 9]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'<a href="#main" id="a_Body_skipToContent">&APP_TEXT$UI_PAGE_SKIP_TO_CONTENT.</a>',
'#ENVIRONMENT_BANNER#',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'#REGION_POSITION_02#',
'  <div id="main" class="a-Body a-DataGen-container" role="main">',
'    <div class="a-Side a-Side--left a-DataGen-tree">#TREE#</div>',
'    <div class="a-Main a-DataGen-pe">',
'        #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'        #BODY#',
'    </div>',
'    <aside class="a-Side a-DataGen-help">#HELP#</aside>',
'  </div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#APEX_JAVASCRIPT#',
'#GENERATED_CSS#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg" role="region" aria-labelledby="page_success_id">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon" role="img" aria-label=''&"APP_TEXT$APEXDEV.ICON_LABEL.SUCCESS"!HTML.''></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 id="page_success_id" class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body" role="alert">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" aria-label="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove" aria-hidden="tru'
||'e"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg" role="region" aria-labelledby="page_warning_id">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon" role="img" aria-label=''&"APP_TEXT$APEXDEV.ICON_LABEL.WARNING"!HTML.''></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 id="page_warning_id" class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body" role="alert">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" aria-label="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove" aria-hidden="tru'
||'e"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(255351268404290374)
,p_page_template_id=>wwv_flow_imp.id(255350889127290340)
,p_name=>'Property Editor'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(255351736860290390)
,p_page_template_id=>wwv_flow_imp.id(255350889127290340)
,p_name=>'Page Header (Position 3)'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>false
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(255352260601290390)
,p_page_template_id=>wwv_flow_imp.id(255350889127290340)
,p_name=>'Page Header (Position 4)'
,p_placeholder=>'REGION_POSITION_02'
,p_has_grid_support=>false
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(255352793458290391)
,p_page_template_id=>wwv_flow_imp.id(255350889127290340)
,p_name=>'Help'
,p_placeholder=>'HELP'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(255353290296290391)
,p_page_template_id=>wwv_flow_imp.id(255350889127290340)
,p_name=>'After Body'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>false
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(255353714187290391)
,p_page_template_id=>wwv_flow_imp.id(255350889127290340)
,p_name=>'Page Header (Position 1)'
,p_placeholder=>'REGION_POSITION_07'
,p_has_grid_support=>false
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(255354268275290392)
,p_page_template_id=>wwv_flow_imp.id(255350889127290340)
,p_name=>'Page Header (Position 2)'
,p_placeholder=>'REGION_POSITION_08'
,p_has_grid_support=>false
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(255355927746326622)
,p_page_template_id=>wwv_flow_imp.id(255350889127290340)
,p_name=>'Tree'
,p_placeholder=>'TREE'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_right_side_bar
begin
wwv_flow_imp_shared.create_template(
 p_id=>wwv_flow_imp.id(385762900697898960)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Right Side Bar'
,p_internal_name=>'APEX_5.0_RIGHT_SIDE_BAR'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 9]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'<a href="#main" id="a_Body_skipToContent">&APP_TEXT$UI_PAGE_SKIP_TO_CONTENT.</a>',
'#ENVIRONMENT_BANNER#',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<header>',
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'</header>',
'#REGION_POSITION_09#',
'#REGION_POSITION_02#',
'  <div id="main" class="a-Body">',
'    <main class="a-Main">',
'        #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'        #BODY#',
'    </main>',
'    <aside class="a-Side">',
'        #REGION_POSITION_03#',
'    </aside>',
'  </div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span role="img" class="a-Icon icon-user" title="&MSG_USER." aria-label="&MSG_USER."></span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span role="img" class="a-Icon icon-workspace" title="&MSG_WORKSPACE." aria-label="&MSG_WORKSPACE."></span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span role="img" class="a-Icon icon-language" title="&MSG_LANGUAGE." aria-label="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#APEX_JAVASCRIPT#',
'#GENERATED_CSS#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg" role="region" aria-labelledby="page_success_id">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon" role="img" aria-label=''&"APP_TEXT$APEXDEV.ICON_LABEL.SUCCESS"!HTML.''></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 id="page_success_id" class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body" role="alert">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" aria-label="#CLOSE_NOTIFICATION#" title="#CLOSE_NOTIFICATION#"><span class="a-Icon '
||'icon-remove" aria-hidden="true"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg" role="region" aria-labelledby="page_warning_id">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon" role="img" aria-label=''&"APP_TEXT$APEXDEV.ICON_LABEL.WARNING"!HTML.''></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 id="page_warning_id" class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body" role="alert">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" aria-label="#CLOSE_NOTIFICATION#" title="#CLOSE_NOTIFICATION#"><span class="a-Icon '
||'icon-remove" aria-hidden="true"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_03'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_09'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>386895861966224222
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1589007079131882)
,p_page_template_id=>wwv_flow_imp.id(385762900697898960)
,p_name=>'Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1589570208131882)
,p_page_template_id=>wwv_flow_imp.id(385762900697898960)
,p_name=>'Page Header (Position 3)'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>false
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1590062410131883)
,p_page_template_id=>wwv_flow_imp.id(385762900697898960)
,p_name=>'Page Header (Position 4)'
,p_placeholder=>'REGION_POSITION_02'
,p_has_grid_support=>false
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1590562672131883)
,p_page_template_id=>wwv_flow_imp.id(385762900697898960)
,p_name=>'Right Side Bar'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1591041385131883)
,p_page_template_id=>wwv_flow_imp.id(385762900697898960)
,p_name=>'After Body'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>false
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1591588760131883)
,p_page_template_id=>wwv_flow_imp.id(385762900697898960)
,p_name=>'Page Header (Position 1)'
,p_placeholder=>'REGION_POSITION_07'
,p_has_grid_support=>false
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1592015836131883)
,p_page_template_id=>wwv_flow_imp.id(385762900697898960)
,p_name=>'Page Header (Position 2)'
,p_placeholder=>'REGION_POSITION_08'
,p_has_grid_support=>false
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1592538395131884)
,p_page_template_id=>wwv_flow_imp.id(385762900697898960)
,p_name=>'Control Bar'
,p_placeholder=>'REGION_POSITION_09'
,p_has_grid_support=>false
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_dialog
begin
wwv_flow_imp_shared.create_template(
 p_id=>wwv_flow_imp.id(690782249755803171)
,p_theme_id=>3
,p_name=>'[x] APEX 5.0 - Dialog'
,p_internal_name=>'APEX_5.0_DIALOG'
,p_is_popup=>true
,p_javascript_code_onload=>'apex.builder.initWizardModal();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#HEAD#',
'</head>',
'<body class="a-Dialog-page #DIALOG_CSS_CLASSES# #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Dialog" role="dialog" aria-label="#TITLE#">',
'  <div class="a-Dialog-wrap">',
'    <div class=" a-Dialog-wizardSteps">',
'      #REGION_POSITION_01#',
'    </div>',
'    <div class="a-Dialog-body">',
'      #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'      #BODY#',
'    </div>',
'    <div class="a-Dialog-footer">',
'      #REGION_POSITION_03#',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#APEX_JAVASCRIPT#',
'#GENERATED_CSS#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg" role="region" aria-labelledby="page_success_id">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon" role="img" aria-label=''&"APP_TEXT$APEXDEV.ICON_LABEL.SUCCESS"!HTML.''></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 id="page_success_id" class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body" role="alert">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" aria-label="#CLOSE_NOTIFICATION#" title="#CLOSE_NOTIFICATION#"><span class="a-Icon '
||'icon-remove" aria-hidden="true"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg" role="region" aria-labelledby="page_warning_id">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon" role="img" aria-label=''&"APP_TEXT$APEXDEV.ICON_LABEL.WARNING"!HTML.''></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 id="page_warning_id" class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body" role="alert">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" aria-label="#CLOSE_NOTIFICATION#" title="#CLOSE_NOTIFICATION#"><span class="a-Icon '
||'icon-remove" aria-hidden="true"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--danger a-Alert--defaultIcons a-Alert--inlineDialog a-Alert--wizard margin-none padding-none">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header u-vh">',
'        <h2 class="a-Alert-title">&APP_TEXT$ERROR!HTML.</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        <p>#MESSAGE# #ADDITIONAL_INFO#</p>',
'        <p><a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a></p>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    <div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>        '))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,baseDialogClass:''a-Dialog--uiDialog'',dialogClass:#DIALOG_CSS_CLASSES#,jsDialogClass:true,#DIALOG'
||'_ATTRIBUTES#},#PAGE_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_height=>'480'
,p_dialog_width=>'800'
,p_dialog_max_width=>'1200'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>120828417372192930
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(293496531310977325)
,p_page_template_id=>wwv_flow_imp.id(690782249755803171)
,p_name=>'Page Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(293497030739977325)
,p_page_template_id=>wwv_flow_imp.id(690782249755803171)
,p_name=>'Page Position 1'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(293497504241977326)
,p_page_template_id=>wwv_flow_imp.id(690782249755803171)
,p_name=>'Page Position 3'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_dialog_grid_layout
begin
wwv_flow_imp_shared.create_template(
 p_id=>wwv_flow_imp.id(690782638016803186)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Dialog (Grid Layout)'
,p_internal_name=>'APEX_5.0_DIALOG_GRID_LAYOUT'
,p_is_popup=>true
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#HEAD#',
'</head>',
'<body class="a-Dialog-page" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#',
'<div class="a-Dialog" role="dialog" aria-label="#TITLE#">'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#SUCCESS_MESSAGE#',
'#NOTIFICATION_MESSAGE#',
'#GLOBAL_NOTIFICATION#',
'#REGION_POSITION_01#',
'#BODY#',
'#REGION_POSITION_02#',
'#REGION_POSITION_03#',
'#REGION_POSITION_04#',
'#REGION_POSITION_05#',
'#REGION_POSITION_06#',
''))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</div>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#APEX_JAVASCRIPT#',
'#GENERATED_CSS#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden" role="alert">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    <div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>        '))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_height=>'400'
,p_dialog_width=>'600'
,p_dialog_max_width=>'1200'
,p_dialog_css_classes=>'a-Dialog--uiDialog'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>561572340071582364
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140071016629349459)
,p_page_template_id=>wwv_flow_imp.id(690782638016803186)
,p_name=>'Page Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140071106516349459)
,p_page_template_id=>wwv_flow_imp.id(690782638016803186)
,p_name=>'Page Position 1'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140071277608349459)
,p_page_template_id=>wwv_flow_imp.id(690782638016803186)
,p_name=>'Page Position 2'
,p_placeholder=>'REGION_POSITION_02'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140071396624349459)
,p_page_template_id=>wwv_flow_imp.id(690782638016803186)
,p_name=>'Page Position 3'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140071454429349459)
,p_page_template_id=>wwv_flow_imp.id(690782638016803186)
,p_name=>'Page Position 4'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140071569367349459)
,p_page_template_id=>wwv_flow_imp.id(690782638016803186)
,p_name=>'Page Position 5'
,p_placeholder=>'REGION_POSITION_05'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140071645904349459)
,p_page_template_id=>wwv_flow_imp.id(690782638016803186)
,p_name=>'Page Position 6'
,p_placeholder=>'REGION_POSITION_06'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_edit_screen
begin
wwv_flow_imp_shared.create_template(
 p_id=>wwv_flow_imp.id(690783120585803188)
,p_theme_id=>3
,p_name=>'[x] APEX 5.0 - Edit Screen'
,p_internal_name=>'APEX_5.0_EDIT_SCREEN'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.builder.initStickyHeader(''a_EditScreen_header'');'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 9]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'<a href="#main" id="a_Body_skipToContent">&APP_TEXT$UI_PAGE_SKIP_TO_CONTENT.</a>',
'#ENVIRONMENT_BANNER#',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<header>',
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'</header>',
'#REGION_POSITION_09#',
'  <div class="a-Body">',
'    <main id="main" class="a-Main">',
'      #REGION_POSITION_02#',
'      <div class="a-EditScreen">',
'        <div class="a-EditScreen-header" id="a_EditScreen_header">',
'          #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'          #REGION_POSITION_04#',
'        </div>',
'        <div class="a-EditScreen-body">',
'          #BODY#',
'        </div>',
'      </div>',
'    </main>',
'    <aside class="a-Side">',
'        #REGION_POSITION_03#',
'        #REGION_POSITION_05#',
'    </aside>',
'  </div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span role="img" class="a-Icon icon-user" title="&MSG_USER." aria-label="&MSG_USER.">',
'        <span class="u-vh">&MSG_USER.</span>',
'      </span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span role="img" class="a-Icon icon-workspace" title="&MSG_WORKSPACE." aria-label="&MSG_WORKSPACE.">',
'        <span class="u-vh">&MSG_WORKSPACE.</span>',
'      </span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span role="img" class="a-Icon icon-language" title="&MSG_LANGUAGE." aria-label="&MSG_LANGUAGE.">',
'        <span class="u-vh">&MSG_LANGUAGE.</span>',
'      </span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#APEX_JAVASCRIPT#',
'#GENERATED_CSS#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg" role="region" aria-labelledby="page_success_id">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon" role="img" aria-label=''&"APP_TEXT$APEXDEV.ICON_LABEL.SUCCESS"!HTML.''></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 id="page_success_id" class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body" role="alert">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" aria-label="#CLOSE_NOTIFICATION#" title="#CLOSE_NOTIFICATION#"><span class="a-Icon '
||'icon-remove" aria-hidden="true"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg" role="region" aria-labelledby="page_warning_id">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon" role="img" aria-label=''&"APP_TEXT$APEXDEV.ICON_LABEL.WARNING"!HTML.''></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 id="page_warning_id" class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body" role="alert">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" aria-label="#CLOSE_NOTIFICATION#" title="#CLOSE_NOTIFICATION#"><span class="a-Icon '
||'icon-remove" aria-hidden="true"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_03'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_09'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>689595297061847770
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2553679133702156)
,p_page_template_id=>wwv_flow_imp.id(690783120585803188)
,p_name=>'Page Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2554149745702156)
,p_page_template_id=>wwv_flow_imp.id(690783120585803188)
,p_name=>'Page Position 1'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2554675246702157)
,p_page_template_id=>wwv_flow_imp.id(690783120585803188)
,p_name=>'Page Position 2'
,p_placeholder=>'REGION_POSITION_02'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2555137342702157)
,p_page_template_id=>wwv_flow_imp.id(690783120585803188)
,p_name=>'Right Side Bar'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2555655182702157)
,p_page_template_id=>wwv_flow_imp.id(690783120585803188)
,p_name=>'Edit Screen Header'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2556177533702157)
,p_page_template_id=>wwv_flow_imp.id(690783120585803188)
,p_name=>'Page Position 5'
,p_placeholder=>'REGION_POSITION_05'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2556622034702158)
,p_page_template_id=>wwv_flow_imp.id(690783120585803188)
,p_name=>'Page Position 7'
,p_placeholder=>'REGION_POSITION_07'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2557187631702158)
,p_page_template_id=>wwv_flow_imp.id(690783120585803188)
,p_name=>'Page Position 8'
,p_placeholder=>'REGION_POSITION_08'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2557638895702158)
,p_page_template_id=>wwv_flow_imp.id(690783120585803188)
,p_name=>'Control Bar'
,p_placeholder=>'REGION_POSITION_09'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_no_side_bar
begin
wwv_flow_imp_shared.create_template(
 p_id=>wwv_flow_imp.id(690783685471803190)
,p_theme_id=>3
,p_name=>'APEX 5.0 - No Side Bar'
,p_internal_name=>'APEX_5.0_NO_SIDE_BAR'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 9]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'<a href="#main" id="a_Body_skipToContent">&APP_TEXT$UI_PAGE_SKIP_TO_CONTENT.</a>',
'#ENVIRONMENT_BANNER#',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<header>',
'    #REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'</header>',
'#REGION_POSITION_09#',
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'#REGION_POSITION_02#',
'#REGION_POSITION_03#',
'  <div id="main" class="a-Body">',
'    <main class="a-Main">',
'        #BODY#',
'    </main>',
'  </div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span role="img" class="a-Icon icon-user" title="&MSG_USER." aria-label="&MSG_USER."><span class="u-vh">&MSG_USER.</span></span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span role="img" class="a-Icon icon-workspace" title=''&"APP_TEXT$APEXDEV.TEMPLATE_WORKSPACE"!HTML.'' aria-label=''&"APP_TEXT$APEXDEV.TEMPLATE_WORKSPACE"!HTML.''><span class="u-vh">&MSG_WORKSPACE.</span></span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span role="img" class="a-Icon icon-language" title="&MSG_LANGUAGE." aria-label="&MSG_LANGUAGE."><span class="u-vh">&MSG_LANGUAGE.</span></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#APEX_JAVASCRIPT#',
'#GENERATED_CSS#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg" role="region" aria-labelledby="page_success_id">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon" role="img" aria-label=''&"APP_TEXT$APEXDEV.ICON_LABEL.SUCCESS"!HTML.''></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 id="page_success_id" class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body" role="alert">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" aria-label="#CLOSE_NOTIFICATION#" title="#CLOSE_NOTIFICATION#"><span class="a-Icon '
||'icon-remove" aria-hidden="true"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg" role="region" aria-labelledby="page_warning_id">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon" role="img" aria-label=''&"APP_TEXT$APEXDEV.ICON_LABEL.WARNING"!HTML.''></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 id="page_warning_id" class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body" role="alert">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" aria-label="#CLOSE_NOTIFICATION#" title="#CLOSE_NOTIFICATION#"><span class="a-Icon '
||'icon-remove" aria-hidden="true"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_09'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--danger a-Alert--wizard a-Alert--defaultIcons">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon #ICON_CSS_CLASSES#"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#MESSAGE#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #ADDITIONAL_INFO#',
'        #TECHNICAL_INFO#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--large a-Button--hot" onclick="#BACK_LINK#" type="button">#RETURN_TO_APPLICATION#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>637437892049443496
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2460611844706114)
,p_page_template_id=>wwv_flow_imp.id(690783685471803190)
,p_name=>'Page Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2461194241706114)
,p_page_template_id=>wwv_flow_imp.id(690783685471803190)
,p_name=>'Page Position 1'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2461645720706114)
,p_page_template_id=>wwv_flow_imp.id(690783685471803190)
,p_name=>'Page Position 2'
,p_placeholder=>'REGION_POSITION_02'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2462106998706115)
,p_page_template_id=>wwv_flow_imp.id(690783685471803190)
,p_name=>'Page Position 3'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2462675784706115)
,p_page_template_id=>wwv_flow_imp.id(690783685471803190)
,p_name=>'Page Position 4'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2463148340706115)
,p_page_template_id=>wwv_flow_imp.id(690783685471803190)
,p_name=>'Page Position 7'
,p_placeholder=>'REGION_POSITION_07'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2463687488706115)
,p_page_template_id=>wwv_flow_imp.id(690783685471803190)
,p_name=>'Page Position 8'
,p_placeholder=>'REGION_POSITION_08'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2464178621706115)
,p_page_template_id=>wwv_flow_imp.id(690783685471803190)
,p_name=>'Control Bar'
,p_placeholder=>'REGION_POSITION_09'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_wizard_dialog
begin
wwv_flow_imp_shared.create_template(
 p_id=>wwv_flow_imp.id(690784265136803192)
,p_theme_id=>3
,p_name=>'[x] APEX 5.0 - Wizard Dialog'
,p_internal_name=>'APEX_5.0_WIZARD_DIALOG'
,p_is_popup=>true
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex.builder.initWizardModal();',
'apex.builder.initWizardProgressBar();'))
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="utf-8">  ',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#HEAD#',
'<meta name="viewport" content="width=device-width,initial-scale=1" />',
'</head>',
'<body class="a-Dialog-page #DIALOG_CSS_CLASSES# #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Dialog a-Dialog--wizard">',
'  <div class="a-Dialog-wrap">',
'    <div class=" a-Dialog-wizardSteps">',
'      #REGION_POSITION_01#',
'    </div>',
'    <div class="a-Dialog-body">',
'      #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'      #BODY#',
'    </div>',
'    <div class="a-Dialog-footer">',
'      #REGION_POSITION_03#',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#APEX_JAVASCRIPT#',
'#GENERATED_CSS#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg" role="region" aria-labelledby="page_success_id">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon" role="img" aria-label=''&"APP_TEXT$APEXDEV.ICON_LABEL.SUCCESS"!HTML.''></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 id="page_success_id" class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body" role="alert">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" aria-label="#CLOSE_NOTIFICATION#" title="#CLOSE_NOTIFICATION#"><span class="a-Icon '
||'icon-remove" aria-hidden="true"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg" role="region" aria-labelledby="page_warning_id">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon" role="img" aria-label=''&"APP_TEXT$APEXDEV.ICON_LABEL.WARNING"!HTML.''></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 id="page_warning_id" class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body" role="alert">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" aria-label="#CLOSE_NOTIFICATION#" title="#CLOSE_NOTIFICATION#"><span class="a-Icon '
||'icon-remove" aria-hidden="true"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--danger a-Alert--defaultIcons a-Alert--inlineDialog a-Alert--wizard margin-none padding-none">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header u-vh">',
'        <h2 class="a-Alert-title">&APP_TEXT$ERROR!HTML.</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        <p>#MESSAGE# #ADDITIONAL_INFO#</p>',
'        <p><a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a></p>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    <div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>        '))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,baseDialogClass:''a-Dialog--wizard'',dialogClass:#DIALOG_CSS_CLASSES#,jsDialogClass:true,#DIALOG_A'
||'TTRIBUTES#},#PAGE_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_height=>'480'
,p_dialog_width=>'800'
,p_dialog_max_width=>'1200'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>689061037088924910
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(293546448026992214)
,p_page_template_id=>wwv_flow_imp.id(690784265136803192)
,p_name=>'Page Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(293546991987992214)
,p_page_template_id=>wwv_flow_imp.id(690784265136803192)
,p_name=>'Page Position 1'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(293547472075992214)
,p_page_template_id=>wwv_flow_imp.id(690784265136803192)
,p_name=>'Page Position 3'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_wizard_page
begin
wwv_flow_imp_shared.create_template(
 p_id=>wwv_flow_imp.id(703368619593851824)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Wizard Page'
,p_internal_name=>'APEX_5.0_WIZARD_PAGE'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.builder.initWizardProgressBar();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#HEAD#',
'</head>',
'<body class="a-Page--wizard #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#ENVIRONMENT_BANNER#',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<header>',
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'</header>',
'#REGION_POSITION_09#',
'<main class="a-Main" id="main">',
'  #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'  <div class="u-Layout u-Layout--centerVertically">',
'    <div class="a-Wizard a-Wizard--default">',
'      #REGION_POSITION_02#',
'      <div class="a-Wizard-controls">#REGION_POSITION_01#</div>',
'      <div class="a-Wizard-body">#BODY#</div>',
'      <div class="a-Wizard-buttons">#REGION_POSITION_03#</div>',
'    </div>',
'  </div>',
'</main>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span role="img" class="a-Icon icon-user" title="&MSG_USER." aria-label="&MSG_USER."><span class="u-vh">&MSG_USER.</span></span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span role="img" class="a-Icon icon-workspace" title="&MSG_WORKSPACE." aria-label="&MSG_WORKSPACE."><span class="u-vh">&MSG_WORKSPACE.</span></span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span role="img" class="a-Icon icon-language" title="&MSG_LANGUAGE." aria-label="&MSG_LANGUAGE."><span class="u-vh">&MSG_LANGUAGE.</span></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#APEX_JAVASCRIPT#',
'#GENERATED_CSS#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" id="sucessMsg">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-success">',
'    <div class="a-MediaBlock-graphic">',
'      <span class="a-Icon a-Icon--medium icon-check"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="sucessMsg-Message" role="alert">#SUCCESS_MESSAGE#</h5>',
'      <button id="sucessMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''sucessMsg'');return false;"><span class="a-I'
||'con icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" id="errorMsg" role="region" aria-labelledby="page_warning_id">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-error">',
'    <div class="a-MediaBlock-graphic" role="img" aria-label=''&"APP_TEXT$APEXDEV.ICON_LABEL.WARNING"!HTML.''>',
'      <span class="a-Icon a-Icon--medium icon-remove"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h2 class="u-vh" id="page_warning_id" class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      <div class="a-AlertMessages-messageTitle" id="errorMsg-Message" role="alert">#MESSAGE#</div>',
'      <button id="errorMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" aria-label="#CLOSE_NOTIFICATION#" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''errorMsg'')'
||';return false;"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_09'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--danger a-Alert--wizard a-Alert--defaultIcons">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon #ICON_CSS_CLASSES#"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'      </div>',
'      <div class="a-Alert-body">',
'        <h2 class="a-Alert-subTitle">#MESSAGE#</h2>',
'        #ADDITIONAL_INFO#',
'        #TECHNICAL_INFO#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--large a-Button--hot" onclick="#BACK_LINK#" type="button">#RETURN_TO_APPLICATION#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>702684260095026477
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1551792836875388)
,p_page_template_id=>wwv_flow_imp.id(703368619593851824)
,p_name=>'Page Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1552260102875389)
,p_page_template_id=>wwv_flow_imp.id(703368619593851824)
,p_name=>'Page Position 1'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1552766607875389)
,p_page_template_id=>wwv_flow_imp.id(703368619593851824)
,p_name=>'Page Position 2'
,p_placeholder=>'REGION_POSITION_02'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1553291965875389)
,p_page_template_id=>wwv_flow_imp.id(703368619593851824)
,p_name=>'Page Position 3'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1553742164875389)
,p_page_template_id=>wwv_flow_imp.id(703368619593851824)
,p_name=>'Page Position 4'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1554283321875390)
,p_page_template_id=>wwv_flow_imp.id(703368619593851824)
,p_name=>'Page Position 7'
,p_placeholder=>'REGION_POSITION_07'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1554715151875390)
,p_page_template_id=>wwv_flow_imp.id(703368619593851824)
,p_name=>'Page Position 8'
,p_placeholder=>'REGION_POSITION_08'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1555223479875392)
,p_page_template_id=>wwv_flow_imp.id(703368619593851824)
,p_name=>'Control Bar'
,p_placeholder=>'REGION_POSITION_09'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_sql_workshop_iframe_page
begin
wwv_flow_imp_shared.create_template(
 p_id=>wwv_flow_imp.id(740688669716062470)
,p_theme_id=>3
,p_name=>'[x] APEX 5.0 - SQL Workshop iFrame Page'
,p_internal_name=>'APEX_5.0_SQL_WORKSHOP_IFRAME_PAGE'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#HEAD#',
'</head>',
'<body class="sql-workshop-iframe-page a-Dialog-page #DIALOG_CSS_CLASSES# #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Dialog" role="dialog" aria-label="#TITLE#">',
'  <div class="a-Dialog-wrap">',
'    <div class=" a-Dialog-wizardSteps">',
'      #REGION_POSITION_01#',
'    </div>',
'    <div class="a-Dialog-body">',
'      #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'      #BODY#',
'    </div>',
'    <div class="a-Dialog-footer">',
'      #REGION_POSITION_03#',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#APEX_JAVASCRIPT#',
'#GENERATED_CSS#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg" role="region" aria-labelledby="page_success_id">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon" role="img" aria-label=''&"APP_TEXT$APEXDEV.ICON_LABEL.SUCCESS"!HTML.''></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 id="page_success_id" class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body" role="alert">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" aria-label="#CLOSE_NOTIFICATION#" title="#CLOSE_NOTIFICATION#"><span class="a-Icon '
||'icon-remove" aria-hidden="true"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg" role="region" aria-labelledby="page_warning_id">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon" role="img" aria-label=''&"APP_TEXT$APEXDEV.ICON_LABEL.WARNING"!HTML.''></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 id="page_warning_id" class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body" role="alert">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" aria-label="#CLOSE_NOTIFICATION#" title="#CLOSE_NOTIFICATION#"><span class="a-Icon '
||'icon-remove" aria-hidden="true"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    <div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>        '))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_height=>'480'
,p_dialog_width=>'800'
,p_dialog_max_width=>'1200'
,p_dialog_css_classes=>'a-Dialog--uiDialog'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>751105067571616073
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(293519859359987029)
,p_page_template_id=>wwv_flow_imp.id(740688669716062470)
,p_name=>'Page Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(293520348879987030)
,p_page_template_id=>wwv_flow_imp.id(740688669716062470)
,p_name=>'Page Position 1'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(293520839261987030)
,p_page_template_id=>wwv_flow_imp.id(740688669716062470)
,p_name=>'Page Position 3'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_query_builder_to_be_deleted
begin
wwv_flow_imp_shared.create_template(
 p_id=>wwv_flow_imp.id(755509294845301750)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Query Builder (to be deleted)'
,p_internal_name=>'APEX_5.0_QUERY_BUILDER_TO_BE_DELETED'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <script src="#IMAGE_PREFIX#sw/minified/htmldb_data.min.js" defer="defer"></script>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#ENVIRONMENT_BANNER#',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'  <div class="a-Body">',
'    <main class="a-Main">     ',
'    <table summary="" cellpadding="0" cellspacing="0" border="0" id="qbTable" width="98%" height="70%">',
'      <tr>',
'        <td id="qbSideBar" valign="top" width="200" style="width:200px;"><div id="qbLeftHeader">#REGION_POSITION_02#</div>',
'          <div id="dbaseObjectsSlider"><br />',
'          </div></td>',
'        <td id="v_slide" class="obSlideBar" valign="middle" width="5" style="width:5px;"><span id="qbSideBartoggle" onclick="qb_toggleSideBar();"><img id="qbSideBar_toggle" src="#IMAGE_PREFIX#qb/close.png" alt="" class="htmldbPseudoButton" /></span><'
||'/td>',
'        <td valign="top" class="qbFrameHolder" id="qbFrameHolder"><div id="qbRightHeader">#REGION_POSITION_03#</div>',
'          <div id="qbTableHolder" class="d1">',
'            <div align="right">',
'              <div id="qbLinkHolder"></div>',
'            </div>',
'          </div>',
'          <div id="h_slide" onmousedown="qb_hPosition(this);">&nbsp;</div>',
'          <div id="qbBottomHolder" class="d2">#REGION_POSITION_04#',
'            <div id="htmlTabHolder" class="qbTabHolder">#REGION_POSITION_05#</div>',
'          </div></td>',
'      </tr>',
'    </table>',
'        #REGION_POSITION_01##BODY#  ',
'    </main>',
'  </div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#APEX_JAVASCRIPT#',
'#GENERATED_CSS#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden" role="alert">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140060983384349476)
,p_page_template_id=>wwv_flow_imp.id(755509294845301750)
,p_name=>'Page Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140061032146349476)
,p_page_template_id=>wwv_flow_imp.id(755509294845301750)
,p_name=>'Page Position 1'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140061193063349476)
,p_page_template_id=>wwv_flow_imp.id(755509294845301750)
,p_name=>'Page Position 2'
,p_placeholder=>'REGION_POSITION_02'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140061226080349476)
,p_page_template_id=>wwv_flow_imp.id(755509294845301750)
,p_name=>'Page Position 3'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140061378064349476)
,p_page_template_id=>wwv_flow_imp.id(755509294845301750)
,p_name=>'Page Position 4'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140061409051349476)
,p_page_template_id=>wwv_flow_imp.id(755509294845301750)
,p_name=>'Page Position 5'
,p_placeholder=>'REGION_POSITION_05'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140061559959349475)
,p_page_template_id=>wwv_flow_imp.id(755509294845301750)
,p_name=>'Page Position 7'
,p_placeholder=>'REGION_POSITION_07'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140061698962349475)
,p_page_template_id=>wwv_flow_imp.id(755509294845301750)
,p_name=>'Page Position 8'
,p_placeholder=>'REGION_POSITION_08'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_query_builder_popup_legacy_to_be_deleted
begin
wwv_flow_imp_shared.create_template(
 p_id=>wwv_flow_imp.id(787616727240016897)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Query Builder Popup (Legacy to be deleted)'
,p_internal_name=>'APEX_5.0_QUERY_BUILDER_POPUP_LEGACY_TO_BE_DELETED'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8">',
'<script src="#IMAGE_PREFIX#sw/minified/htmldb_data.min.js"></script>',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#HEAD#',
'</head>',
'<body #ONLOAD# xmlns:htmldb="http://htmldb.oracle.com"><noscript>&MSG_JSCRIPT.</noscript>#FORM_OPEN#<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="htmldbBreadcrumbTop"><br /></div>',
'<table class="htmldbLayout" cellpadding="0" cellspacing="0" border="0" summary="">',
'<tr>',
'<td class="htmldbBreadcrumbRegion"><br /></td>',
'<td rowspan="2" class="htmldbRunEditRegion">#REGION_POSITION_06#</td></tr>',
'<tr>',
'<td id="htmldbRunEditZag"><img src="#IMAGE_PREFIX#1px_trans.gif" alt="" width="1" height="6" /></td>',
'</tr>',
'</table>',
'<div id="htmldbMessageHolder">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<table summary="" cellpadding="0" cellspacing="0" border="0" id="qbTable" width="98%" height="70%">',
'<tr>',
'<td id="qbSideBar" valign="top" width="200" style="width:200px;"><div id="qbLeftHeader">#REGION_POSITION_02#</div><div id="dbaseObjectsSlider"><br /></div></td>',
'<td id="v_slide" class="obSlideBar" valign="middle" width="5" style="width:5px;"><span id="qbSideBartoggle" onclick="qb_toggleSideBar();"><img id="qbSideBar_toggle" src="#IMAGE_PREFIX#qb/close.png" alt="" class="htmldbPseudoButton" /></span></td>',
'<td valign="top" class="qbFrameHolder" id="qbFrameHolder"><div id="qbRightHeader">#REGION_POSITION_03#</div>',
'<div id="qbTableHolder" class="d1"><div align="right"><div id="qbLinkHolder"></div></div></div>',
'<div id="h_slide" onmousedown="qb_hPosition(this);">&nbsp;</div>',
'<div id="qbBottomHolder" class="d2">#REGION_POSITION_04#<div id="htmlTabHolder" class="qbTabHolder">#REGION_POSITION_05#</div><br /><br /></div></td>',
'</tr>',
'</table><div class="htmldbBodyMargin">#REGION_POSITION_01##BODY#</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'<a name="END"><br /></a>',
'#DEVELOPER_TOOLBAR#',
'#APEX_JAVASCRIPT#',
'#GENERATED_CSS#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden" role="alert">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_top_non_curr_tab_font_attr=>'class="parenttabtextoff"'
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>16
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_template_comment=>'no longer used'
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140093017683349434)
,p_page_template_id=>wwv_flow_imp.id(787616727240016897)
,p_name=>'Page Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140093198174349433)
,p_page_template_id=>wwv_flow_imp.id(787616727240016897)
,p_name=>'Page Position 1'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140093288224349433)
,p_page_template_id=>wwv_flow_imp.id(787616727240016897)
,p_name=>'Page Position 2'
,p_placeholder=>'REGION_POSITION_02'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140093382714349433)
,p_page_template_id=>wwv_flow_imp.id(787616727240016897)
,p_name=>'Page Position 3'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140093468334349433)
,p_page_template_id=>wwv_flow_imp.id(787616727240016897)
,p_name=>'Page Position 4'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140093506426349433)
,p_page_template_id=>wwv_flow_imp.id(787616727240016897)
,p_name=>'Page Position 5'
,p_placeholder=>'REGION_POSITION_05'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140093696461349433)
,p_page_template_id=>wwv_flow_imp.id(787616727240016897)
,p_name=>'Page Position 6'
,p_placeholder=>'REGION_POSITION_06'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/button/html_button_legacy_apex_5_migration
begin
wwv_flow_imp_shared.create_button_templates(
 p_id=>wwv_flow_imp.id(3791826543328)
,p_template_name=>'HTML button (legacy - APEX 5 migration)'
,p_internal_name=>'HTML_BUTTON_LEGACY_APEX_5_MIGRATION'
,p_template=>'<input type="button" value="#LABEL!ATTR#" onclick="#JAVASCRIPT#" id="#BUTTON_ID#" class="#BUTTON_CSS_CLASSES#" #BUTTON_ATTRIBUTES#/>'
,p_hot_template=>'<input type="button" value="#LABEL!ATTR#" onclick="#JAVASCRIPT#" id="#BUTTON_ID#" class="#BUTTON_CSS_CLASSES#" #BUTTON_ATTRIBUTES#/>'
,p_translate_this_template=>'N'
,p_theme_class_id=>13
,p_template_comment=>'5.0 upgrade'
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_4_1_button
begin
wwv_flow_imp_shared.create_button_templates(
 p_id=>wwv_flow_imp.id(300313006293429763)
,p_template_name=>'APEX 4.1 - Button'
,p_internal_name=>'APEX_4.1_BUTTON'
,p_template=>'<button class="aButton" onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" type="button"><span>#LABEL!HTML#</span></button> '
,p_hot_template=>'<button class="aButton hotButton" onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" type="button"><span>#LABEL!HTML#</span></button> '
,p_reference_id=>275775519061831382
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="button-gray" role="button" title="#LABEL#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span>#LABEL#</span></a> ',
'',
'',
'<a href="#LINK#" class="button-orange" role="button" title="#LABEL#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span>#LABEL#</span></a> '))
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_button
begin
wwv_flow_imp_shared.create_button_templates(
 p_id=>wwv_flow_imp.id(385765234519963355)
,p_template_name=>'APEX 5.0 - Button'
,p_internal_name=>'APEX_5.0_BUTTON'
,p_template=>'<button onclick="#JAVASCRIPT#" class="a-Button #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_hot_template=>'<button onclick="#JAVASCRIPT#" class="a-Button a-Button--hot #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_reference_id=>174750904387485475
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_menu_button
begin
wwv_flow_imp_shared.create_button_templates(
 p_id=>wwv_flow_imp.id(385765690470963369)
,p_template_name=>'APEX 5.0 - Icon Menu Button'
,p_internal_name=>'APEX_5.0_ICON_MENU_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_'
||'CSS_CLASSES#" aria-hidden="true"></span><span class="a-Icon icon-menu-drop-down" aria-hidden="true"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span class='
||'"a-Icon #ICON_CSS_CLASSES#" aria-hidden="true"></span><span class="a-Icon  icon-menu-drop-down" aria-hidden="true"></span></button>'
,p_reference_id=>3705338883615
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_only_button
begin
wwv_flow_imp_shared.create_button_templates(
 p_id=>wwv_flow_imp.id(385765860428963371)
,p_template_name=>'APEX 5.0 - Icon Only Button'
,p_internal_name=>'APEX_5.0_ICON_ONLY_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel a-Button--withIcon #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" aria-label="#LABEL!ATTR#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CLASSES#" aria-h'
||'idden="true"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel a-Button--withIcon #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" aria-label="#LABEL!ATTR#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CL'
||'ASSES#" aria-hidden="true"></span></button>'
,p_reference_id=>353820721334283301
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_button_with_icon
begin
wwv_flow_imp_shared.create_button_templates(
 p_id=>wwv_flow_imp.id(690706750701136097)
,p_template_name=>'APEX 5.0 - Button with Icon'
,p_internal_name=>'APEX_5.0_BUTTON_WITH_ICON'
,p_template=>'<button class="a-Button a-Button--iconTextButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#>#LABEL!HTML#<span class="a-Icon #ICON_CSS_CLASSES#"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--iconTextButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#>#LABEL!HTML#<span class="a-Icon #ICON_CSS_CLASSES#"></span></button>'
,p_reference_id=>404889142313786233
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_badge_button
begin
wwv_flow_imp_shared.create_button_templates(
 p_id=>wwv_flow_imp.id(717395744009796543)
,p_template_name=>'APEX 5.0 - Icon Badge Button'
,p_internal_name=>'APEX_5.0_ICON_BADGE_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CLASSES#"></span><span class="a-But'
||'ton-badge"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CLASSES#"></span><spa'
||'n class="a-Button-badge"></span></button>'
,p_reference_id=>631020282344854024
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_badge_menu_button
begin
wwv_flow_imp_shared.create_button_templates(
 p_id=>wwv_flow_imp.id(717395999962796580)
,p_template_name=>'APEX 5.0 - Icon Badge Menu Button'
,p_internal_name=>'APEX_5.0_ICON_BADGE_MENU_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_'
||'CSS_CLASSES#"></span><span class="a-Button-badge"></span><span class="a-Icon icon-menu-drop-down"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span class='
||'"a-Icon #ICON_CSS_CLASSES#"></span><span class="a-Button-badge"></span><span class="a-Icon icon-menu-drop-down"></span></button>'
,p_reference_id=>631020159860848910
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/region/4500_results_region_template
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(4569137138)
,p_layout=>'TABLE'
,p_template=>'<table cellspacing="2" cellpadding="2" border="0" width="100%" bgcolor="#C5D5C5" summary="" id="#REGION_STATIC_ID#"><tr><td align=left bgcolor="#C5D5C5"><font class="regionheader" face=aria color=white>&nbsp;<h2>#TITLE#</h2></font></td><td width="1%"'
||' align="right"  bgcolor="#C5D5C5">#EXPAND#</td><td width="1%" align="right"  bgcolor="#C5D5C5">#CLOSE#</td></tr></table>#BODY#<p/>'
,p_page_plug_template_name=>'[x] (4500) results_region_template'
,p_internal_name=>'4500_RESULTS_REGION_TEMPLATE'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_reference_id=>354972725853931304
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60375372175005690)
,p_plug_template_id=>wwv_flow_imp.id(4569137138)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60375895122005690)
,p_plug_template_id=>wwv_flow_imp.id(4569137138)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60376317531005691)
,p_plug_template_id=>wwv_flow_imp.id(4569137138)
,p_name=>'Expand'
,p_placeholder=>'EXPAND'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60376842086005691)
,p_plug_template_id=>wwv_flow_imp.id(4569137138)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/popup_dialog
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(2315729644343442)
,p_layout=>'TABLE'
,p_template=>'<table style="display:none;position:absolute;background-color:#EEEEEE;border:#000000 solid 1px;padding:0px;text-align:center;font-size:12px;color:#000000;" summary="" cellpadding="0" cellspacing="0" border="0" id="#REGION_STATIC_ID#"><tr><td class="h'
||'tmldbWizardHeader"><h2>#TITLE#</h2></td><td class="htmldbWizardHeader" align="right"><span onClick="dhtml_CloseDialog(this);"><img src="#IMAGE_PREFIX#qb/vertical_close.png" /></span></td></tr><tr><td colspan="2" class="htmldbWizardBody">#BODY#</td></'
||'tr><tr><td colspan="2" align="right">#CLOSE#&nbsp;&nbsp;&nbsp;#DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#</td></tr></table>'
,p_page_plug_template_name=>'Popup Dialog'
,p_internal_name=>'POPUP_DIALOG'
,p_theme_id=>3
,p_theme_class_id=>7
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>140626130059891289
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140568594196344440)
,p_plug_template_id=>wwv_flow_imp.id(2315729644343442)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140568698711344440)
,p_plug_template_id=>wwv_flow_imp.id(2315729644343442)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140568704569344440)
,p_plug_template_id=>wwv_flow_imp.id(2315729644343442)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140568867043344440)
,p_plug_template_id=>wwv_flow_imp.id(2315729644343442)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140568907417344440)
,p_plug_template_id=>wwv_flow_imp.id(2315729644343442)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140569054311344440)
,p_plug_template_id=>wwv_flow_imp.id(2315729644343442)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140569150526344440)
,p_plug_template_id=>wwv_flow_imp.id(2315729644343442)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140569294370344440)
,p_plug_template_id=>wwv_flow_imp.id(2315729644343442)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140569392716344440)
,p_plug_template_id=>wwv_flow_imp.id(2315729644343442)
,p_name=>'Change'
,p_placeholder=>'CHANGE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_div_with_id_and_region_attributes
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(2976007666683831)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>#BODY#</div>'
,p_page_plug_template_name=>'[x] APEX 4.0 - Div with ID and Region Attributes'
,p_internal_name=>'APEX_4.0_DIV_WITH_ID_AND_REGION_ATTRIBUTES'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>2974803291668087
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60420651362125961)
,p_plug_template_id=>wwv_flow_imp.id(2976007666683831)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60421176955125961)
,p_plug_template_id=>wwv_flow_imp.id(2976007666683831)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/ppr_region
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(12270828624874231)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_ID#" style="clear:both;"><htmldb:PPR_#REGION_ID#>#BODY#</htmldb:PPR_#REGION_ID#></div>'
,p_page_plug_template_name=>'PPR Region'
,p_internal_name=>'PPR_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140569617539344439)
,p_plug_template_id=>wwv_flow_imp.id(12270828624874231)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140569774467344439)
,p_plug_template_id=>wwv_flow_imp.id(12270828624874231)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/top_bar_white_collapsed
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(22867306215341549)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#REGION_STATIC_ID#" class="top-bar" #REGION_ATTRIBUTES#><div style="float: left">#BODY#</div><div style="float: left">#CLOSE##EDIT##DELETE##CREATE##CREATE2##PREVIOUS##NEXT#</div></div>',
''))
,p_page_plug_template_name=>'Top Bar (white) (collapsed)'
,p_internal_name=>'TOP_BAR_WHITE_COLLAPSED'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>21
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>17586323272111445
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140570290826344439)
,p_plug_template_id=>wwv_flow_imp.id(22867306215341549)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140570388177344439)
,p_plug_template_id=>wwv_flow_imp.id(22867306215341549)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140570438244344438)
,p_plug_template_id=>wwv_flow_imp.id(22867306215341549)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140570535541344438)
,p_plug_template_id=>wwv_flow_imp.id(22867306215341549)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140570634988344438)
,p_plug_template_id=>wwv_flow_imp.id(22867306215341549)
,p_name=>'Create2'
,p_placeholder=>'CREATE2'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140570756770344438)
,p_plug_template_id=>wwv_flow_imp.id(22867306215341549)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140570831895344438)
,p_plug_template_id=>wwv_flow_imp.id(22867306215341549)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140570969512344438)
,p_plug_template_id=>wwv_flow_imp.id(22867306215341549)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140571052856344438)
,p_plug_template_id=>wwv_flow_imp.id(22867306215341549)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_hide_and_show_region_2
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(35638231141594602)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="hide-show-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="hide-show-top">',
'    <div class="hide-show-title"><h3 data-apex-heading>',
'      <a href="#" onclick="htmldb_ToggleTableBody(''i#REGION_STATIC_ID#'',''body#REGION_STATIC_ID#''); return false;">',
'        <img src="#IMAGE_PREFIX#htmldb/builder/rollup_plus_dgray.gif" class="pseudoButtonActive" id="i#REGION_STATIC_ID#" alt="" />',
'        #TITLE#',
'      </a></h3>    ',
'    </div>',
'  </div>',
'  <div class="hide-show-body" style="display:none;" id="body#REGION_STATIC_ID#">#BODY#</div>',
'</div>'))
,p_page_plug_template_name=>'[x] APEX 4.0 -  Hide and Show Region 2'
,p_internal_name=>'APEX_4.0__HIDE_AND_SHOW_REGION_2'
,p_theme_id=>3
,p_theme_class_id=>1
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>106535103160611208
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1735033528443682)
,p_plug_template_id=>wwv_flow_imp.id(35638231141594602)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1735575205443682)
,p_plug_template_id=>wwv_flow_imp.id(35638231141594602)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_top_bar_100
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(40570329559709427)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion buttonRegion" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    #BODY#',
'    <span class="aButtonContainer">',
'      #CLOSE##COPY##DELETE##CHANGE##EDIT##PREVIOUS##NEXT##CREATE##EXPAND#',
'    </span>',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'[x] APEX 4.0 - Top Bar (100%)'
,p_internal_name=>'APEX_4.0_TOP_BAR_100%'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>17357218626599946
,p_translate_this_template=>'N'
,p_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <table class="TopBarUIFix" cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_STATIC_ID#" width="100%"><tbody class="GreenBar"><tr><td valign="middle" class="L">#BODY#</td><td width="30" class="C"><br /></td><td valign="middle" class='
||'"R" align="right"><span style="margin-right:10px;">#CLOSE#</span>#COPY##DELETE##CHANGE##EDIT##PREVIOUS##NEXT##CREATE##EXPAND#</td></tr></tbody></table>',
''))
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(92532656060295513)
,p_plug_template_id=>wwv_flow_imp.id(40570329559709427)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(92533191075295513)
,p_plug_template_id=>wwv_flow_imp.id(40570329559709427)
,p_name=>'Change'
,p_placeholder=>'CHANGE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(92533679190295514)
,p_plug_template_id=>wwv_flow_imp.id(40570329559709427)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(92534148283295514)
,p_plug_template_id=>wwv_flow_imp.id(40570329559709427)
,p_name=>'Copy'
,p_placeholder=>'COPY'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(92534641363295514)
,p_plug_template_id=>wwv_flow_imp.id(40570329559709427)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(92535194699295514)
,p_plug_template_id=>wwv_flow_imp.id(40570329559709427)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(92535567759295515)
,p_plug_template_id=>wwv_flow_imp.id(40570329559709427)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(92536056688295515)
,p_plug_template_id=>wwv_flow_imp.id(40570329559709427)
,p_name=>'Expand'
,p_placeholder=>'EXPAND'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(92536558065295515)
,p_plug_template_id=>wwv_flow_imp.id(40570329559709427)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(92537029933295515)
,p_plug_template_id=>wwv_flow_imp.id(40570329559709427)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(92537573978295516)
,p_plug_template_id=>wwv_flow_imp.id(40570329559709427)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_div_float_left
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(42819301025617014)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES# style="float:left;clear:both;">#BODY#</div>'
,p_page_plug_template_name=>'[x] APEX 4.0 - Div (Float Left)'
,p_internal_name=>'APEX_4.0_DIV_FLOAT_LEFT'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>35964702876463547
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60409856513110472)
,p_plug_template_id=>wwv_flow_imp.id(42819301025617014)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60410375256110472)
,p_plug_template_id=>wwv_flow_imp.id(42819301025617014)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_reports_region
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(61427413413570608)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="rounded-corner-region" id="#REGION_STATIC_ID#" style="width:100%">',
'  <div class="rc-gray-top"><div class="rc-gray-top-r">',
'    <div class="rc-title"><h2 data-apex-heading>#TITLE#</h2></div>',
'    <div class="rc-buttons">#EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#</div>',
'  </div></div>',
'  <div class="rc-body"><div class="rc-body-r"><div class="rc-content">#BODY#</div></div></div>',
'  <div class="rc-bottom"><div class="rc-bottom-r"></div></div>',
'</div>'))
,p_page_plug_template_name=>'[x] APEX 4.0 - Reports Region'
,p_internal_name=>'APEX_4.0_REPORTS_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>17354512447599941
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1814802119451814)
,p_plug_template_id=>wwv_flow_imp.id(61427413413570608)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1815320396451814)
,p_plug_template_id=>wwv_flow_imp.id(61427413413570608)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1815823503451814)
,p_plug_template_id=>wwv_flow_imp.id(61427413413570608)
,p_name=>'Copy'
,p_placeholder=>'COPY'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1816389150451815)
,p_plug_template_id=>wwv_flow_imp.id(61427413413570608)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1816827424451815)
,p_plug_template_id=>wwv_flow_imp.id(61427413413570608)
,p_name=>'Create2'
,p_placeholder=>'CREATE2'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1817371797451815)
,p_plug_template_id=>wwv_flow_imp.id(61427413413570608)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1817893774451815)
,p_plug_template_id=>wwv_flow_imp.id(61427413413570608)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1818310389451815)
,p_plug_template_id=>wwv_flow_imp.id(61427413413570608)
,p_name=>'Expand'
,p_placeholder=>'EXPAND'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1818807597451815)
,p_plug_template_id=>wwv_flow_imp.id(61427413413570608)
,p_name=>'Help'
,p_placeholder=>'HELP'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1819338733451815)
,p_plug_template_id=>wwv_flow_imp.id(61427413413570608)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1819815806451815)
,p_plug_template_id=>wwv_flow_imp.id(61427413413570608)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1820329419451816)
,p_plug_template_id=>wwv_flow_imp.id(61427413413570608)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_sidebar_gray_header
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(81906901123495005)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion sideRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1 data-apex-heading>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'[x] APEX 4.0 - Sidebar (Gray Header)'
,p_internal_name=>'APEX_4.0_SIDEBAR_GRAY_HEADER'
,p_plug_table_bgcolor=>'#F7F7E7'
,p_theme_id=>3
,p_theme_class_id=>2
,p_plug_heading_bgcolor=>'#F7F7E7'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_reference_id=>17355419405599943
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2095263839463800)
,p_plug_template_id=>wwv_flow_imp.id(81906901123495005)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2095758728463800)
,p_plug_template_id=>wwv_flow_imp.id(81906901123495005)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2096285580463800)
,p_plug_template_id=>wwv_flow_imp.id(81906901123495005)
,p_name=>'Copy'
,p_placeholder=>'COPY'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2096726020463800)
,p_plug_template_id=>wwv_flow_imp.id(81906901123495005)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2097209587463800)
,p_plug_template_id=>wwv_flow_imp.id(81906901123495005)
,p_name=>'Create2'
,p_placeholder=>'CREATE2'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2097724429463801)
,p_plug_template_id=>wwv_flow_imp.id(81906901123495005)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2098246604463801)
,p_plug_template_id=>wwv_flow_imp.id(81906901123495005)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2098794899463801)
,p_plug_template_id=>wwv_flow_imp.id(81906901123495005)
,p_name=>'Expand'
,p_placeholder=>'EXPAND'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2099296654463801)
,p_plug_template_id=>wwv_flow_imp.id(81906901123495005)
,p_name=>'Help'
,p_placeholder=>'HELP'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2099714224463801)
,p_plug_template_id=>wwv_flow_imp.id(81906901123495005)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2100222544463801)
,p_plug_template_id=>wwv_flow_imp.id(81906901123495005)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2100727534463801)
,p_plug_template_id=>wwv_flow_imp.id(81906901123495005)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/blank_wizard_region_c_htmldbbwr
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(106819925599248236)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table class="htmldbBWR" cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_ID#">',
'<thead>',
'<tr>',
'<th class="T"><br /></th>',
'<th class="BT" valign="bottom">#CLOSE#&nbsp;&nbsp;#EDIT##DELETE#<img src="#IMAGE_PREFIX#htmldb/builder/1px_trans.gif" alt="" height="1" width="5" />#PREVIOUS##NEXT##CREATE##CREATE2#</th>',
'</tr>',
'</thead>',
'<tbody>',
'<tr>',
'<td colspan="2" class="B">#BODY#</td>',
'</tr>',
'</tbody>',
'</table>'))
,p_page_plug_template_name=>'Blank Wizard Region (c:htmldbBWR)'
,p_internal_name=>'BLANK_WIZARD_REGION_C:HTMLDBBWR'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140615659540344392)
,p_plug_template_id=>wwv_flow_imp.id(106819925599248236)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140615799443344391)
,p_plug_template_id=>wwv_flow_imp.id(106819925599248236)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140615814240344391)
,p_plug_template_id=>wwv_flow_imp.id(106819925599248236)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140615965516344391)
,p_plug_template_id=>wwv_flow_imp.id(106819925599248236)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140616067438344391)
,p_plug_template_id=>wwv_flow_imp.id(106819925599248236)
,p_name=>'Create2'
,p_placeholder=>'CREATE2'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140616153694344391)
,p_plug_template_id=>wwv_flow_imp.id(106819925599248236)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140616296448344391)
,p_plug_template_id=>wwv_flow_imp.id(106819925599248236)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140616345733344391)
,p_plug_template_id=>wwv_flow_imp.id(106819925599248236)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140616421636344391)
,p_plug_template_id=>wwv_flow_imp.id(106819925599248236)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_2_action_box
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(140310301493602560)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1 data-apex-heading>#TITLE#</h1>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'  <span class="aButtonContainer">',
'    #CLOSE##DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#',
'  </span>',
'</section>'))
,p_page_plug_template_name=>'[x] APEX 4.2 - Action Box'
,p_internal_name=>'APEX_4.2_ACTION_BOX'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>18253116293565611
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2290033637476438)
,p_plug_template_id=>wwv_flow_imp.id(140310301493602560)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2290521085476438)
,p_plug_template_id=>wwv_flow_imp.id(140310301493602560)
,p_name=>'Change'
,p_placeholder=>'CHANGE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2291056254476438)
,p_plug_template_id=>wwv_flow_imp.id(140310301493602560)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2291526021476438)
,p_plug_template_id=>wwv_flow_imp.id(140310301493602560)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2292087800476438)
,p_plug_template_id=>wwv_flow_imp.id(140310301493602560)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2292538054476439)
,p_plug_template_id=>wwv_flow_imp.id(140310301493602560)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2293020120476439)
,p_plug_template_id=>wwv_flow_imp.id(140310301493602560)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2293552183476439)
,p_plug_template_id=>wwv_flow_imp.id(140310301493602560)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2294004885476439)
,p_plug_template_id=>wwv_flow_imp.id(140310301493602560)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_2_action_box_confirm
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(162408401422136243)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion confirmRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1 data-apex-heading>#TITLE#</h1>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    <div class="aActionRegionIcon">',
'      <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" />',
'    </div>',
'    #BODY#',
'  </div>',
'  <span class="aButtonContainer">',
'    #CLOSE##DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#',
'  </span>',
'</section>'))
,p_page_plug_template_name=>'[x] APEX 4.2 - Action Box (Confirm)'
,p_internal_name=>'APEX_4.2_ACTION_BOX_CONFIRM'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>186682507972859454
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2382370259478202)
,p_plug_template_id=>wwv_flow_imp.id(162408401422136243)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2382854753478202)
,p_plug_template_id=>wwv_flow_imp.id(162408401422136243)
,p_name=>'Change'
,p_placeholder=>'CHANGE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2383301871478203)
,p_plug_template_id=>wwv_flow_imp.id(162408401422136243)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2383878540478203)
,p_plug_template_id=>wwv_flow_imp.id(162408401422136243)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2384303904478203)
,p_plug_template_id=>wwv_flow_imp.id(162408401422136243)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2384818358478203)
,p_plug_template_id=>wwv_flow_imp.id(162408401422136243)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2385385029478203)
,p_plug_template_id=>wwv_flow_imp.id(162408401422136243)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2385817872478203)
,p_plug_template_id=>wwv_flow_imp.id(162408401422136243)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2386309517478204)
,p_plug_template_id=>wwv_flow_imp.id(162408401422136243)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_sidebar_gray_header_002
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(197664431770780199)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion sideRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1 data-apex-heading>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'[x] APEX 4.0 - Sidebar (Gray Header) (2)'
,p_internal_name=>'APEX_4.0_SIDEBAR_GRAY_HEADER'
,p_plug_table_bgcolor=>'#F7F7E7'
,p_theme_id=>3
,p_theme_class_id=>2
,p_plug_heading_bgcolor=>'#F7F7E7'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_reference_id=>17355419405599943
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2106380028463804)
,p_plug_template_id=>wwv_flow_imp.id(197664431770780199)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2106894359463804)
,p_plug_template_id=>wwv_flow_imp.id(197664431770780199)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2107371612463804)
,p_plug_template_id=>wwv_flow_imp.id(197664431770780199)
,p_name=>'Copy'
,p_placeholder=>'COPY'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2107882453463804)
,p_plug_template_id=>wwv_flow_imp.id(197664431770780199)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2108368624463804)
,p_plug_template_id=>wwv_flow_imp.id(197664431770780199)
,p_name=>'Create2'
,p_placeholder=>'CREATE2'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2108857337463804)
,p_plug_template_id=>wwv_flow_imp.id(197664431770780199)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2109389053463804)
,p_plug_template_id=>wwv_flow_imp.id(197664431770780199)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2109835378463805)
,p_plug_template_id=>wwv_flow_imp.id(197664431770780199)
,p_name=>'Expand'
,p_placeholder=>'EXPAND'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2110376601463805)
,p_plug_template_id=>wwv_flow_imp.id(197664431770780199)
,p_name=>'Help'
,p_placeholder=>'HELP'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2110866179463805)
,p_plug_template_id=>wwv_flow_imp.id(197664431770780199)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2111315014463805)
,p_plug_template_id=>wwv_flow_imp.id(197664431770780199)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2111863354463805)
,p_plug_template_id=>wwv_flow_imp.id(197664431770780199)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_2_action_box_002
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(201494524216316816)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1 data-apex-heading>#TITLE#</h1>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'  <span class="aButtonContainer">',
'    #CLOSE##DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#',
'  </span>',
'</section>'))
,p_page_plug_template_name=>'[x] APEX 4.2 - Action Box (2)'
,p_internal_name=>'APEX_4.2_ACTION_BOX'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>18253116293565611
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2298486281476441)
,p_plug_template_id=>wwv_flow_imp.id(201494524216316816)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2298982952476441)
,p_plug_template_id=>wwv_flow_imp.id(201494524216316816)
,p_name=>'Change'
,p_placeholder=>'CHANGE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2299413893476441)
,p_plug_template_id=>wwv_flow_imp.id(201494524216316816)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2299934663476441)
,p_plug_template_id=>wwv_flow_imp.id(201494524216316816)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2300423234476441)
,p_plug_template_id=>wwv_flow_imp.id(201494524216316816)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2300959386476441)
,p_plug_template_id=>wwv_flow_imp.id(201494524216316816)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2301498794476441)
,p_plug_template_id=>wwv_flow_imp.id(201494524216316816)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2301926113476442)
,p_plug_template_id=>wwv_flow_imp.id(201494524216316816)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2302420737476442)
,p_plug_template_id=>wwv_flow_imp.id(201494524216316816)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_2_wizard_body
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(208285310117555084)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aWizardRegion" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'</section>'))
,p_page_plug_template_name=>'[x] APEX 4.2 - Wizard Body'
,p_internal_name=>'APEX_4.2_WIZARD_BODY'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>42209615589242480
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93622510957534560)
,p_plug_template_id=>wwv_flow_imp.id(208285310117555084)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93623002611534560)
,p_plug_template_id=>wwv_flow_imp.id(208285310117555084)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_2_wizard_body_divider
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(208285802016555084)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aWizardRegion dividerTop" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'<div class="wizardRegionHeading">',
'  <h1 data-apex-heading>#TITLE#</h1>',
'  <div class="buttonContainer">',
'#EDIT##CLOSE##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT##CREATE##CREATE2#',
'  </div>',
'</div>',
'  #BODY#',
'</section>'))
,p_page_plug_template_name=>'[x] APEX 4.2 - Wizard Body (Divider)'
,p_internal_name=>'APEX_4.2_WIZARD_BODY_DIVIDER'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>42209811475242480
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2447276468480665)
,p_plug_template_id=>wwv_flow_imp.id(208285802016555084)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2447796066480665)
,p_plug_template_id=>wwv_flow_imp.id(208285802016555084)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2448282068480665)
,p_plug_template_id=>wwv_flow_imp.id(208285802016555084)
,p_name=>'Copy'
,p_placeholder=>'COPY'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2448764363480666)
,p_plug_template_id=>wwv_flow_imp.id(208285802016555084)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2449257721480666)
,p_plug_template_id=>wwv_flow_imp.id(208285802016555084)
,p_name=>'Create2'
,p_placeholder=>'CREATE2'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2449777736480666)
,p_plug_template_id=>wwv_flow_imp.id(208285802016555084)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2450279849480666)
,p_plug_template_id=>wwv_flow_imp.id(208285802016555084)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2450717968480666)
,p_plug_template_id=>wwv_flow_imp.id(208285802016555084)
,p_name=>'Expand'
,p_placeholder=>'EXPAND'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2451253607480666)
,p_plug_template_id=>wwv_flow_imp.id(208285802016555084)
,p_name=>'Help'
,p_placeholder=>'HELP'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2451731641480666)
,p_plug_template_id=>wwv_flow_imp.id(208285802016555084)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2452224365480667)
,p_plug_template_id=>wwv_flow_imp.id(208285802016555084)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2452766070480667)
,p_plug_template_id=>wwv_flow_imp.id(208285802016555084)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/body_and_button_positions
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(267352014896608032)
,p_layout=>'TABLE'
,p_template=>'<table  cellpadding="0" cellspacing="0" border="0" summary="" class="htmldbButtonPositionsOnly" id="#REGION_STATIC_ID#"><tbody><tr><td>#BODY#</td><td style="padding-right:25px;">#CLOSE#</td><td>#PREVIOUS#</td><td>#NEXT#</td><td>#DELETE#</td><td>#CHAN'
||'GE##EDIT#</td><td>#CREATE#</td><td>#CREATE2#</td><td>#HELP#</td></tr></tbody></table>'
,p_page_plug_template_name=>'Body and Button Positions'
,p_internal_name=>'BODY_AND_BUTTON_POSITIONS'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>149939626832608434
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140622773062344384)
,p_plug_template_id=>wwv_flow_imp.id(267352014896608032)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140622839124344384)
,p_plug_template_id=>wwv_flow_imp.id(267352014896608032)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140622955035344384)
,p_plug_template_id=>wwv_flow_imp.id(267352014896608032)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140623035834344384)
,p_plug_template_id=>wwv_flow_imp.id(267352014896608032)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140623106716344384)
,p_plug_template_id=>wwv_flow_imp.id(267352014896608032)
,p_name=>'Create2'
,p_placeholder=>'CREATE2'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140623237658344384)
,p_plug_template_id=>wwv_flow_imp.id(267352014896608032)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140623381858344384)
,p_plug_template_id=>wwv_flow_imp.id(267352014896608032)
,p_name=>'Help'
,p_placeholder=>'HELP'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140623493674344384)
,p_plug_template_id=>wwv_flow_imp.id(267352014896608032)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140623521160344383)
,p_plug_template_id=>wwv_flow_imp.id(267352014896608032)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140623663131344383)
,p_plug_template_id=>wwv_flow_imp.id(267352014896608032)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140623702882344383)
,p_plug_template_id=>wwv_flow_imp.id(267352014896608032)
,p_name=>'Change'
,p_placeholder=>'CHANGE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_region
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(380771699411878611)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region #REGION_CSS_CLASSES#" #REGION_LANDMARK_ATTRIBUTES# #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title" id="#REGION_STATIC_ID#_heading" data-apex-heading>#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'  <div class="a-Region-bodyHeader">#REGION_HEADER#</div>',
'  #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'[x] APEX 5.0 - Region'
,p_internal_name=>'APEX_5.0_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_preset_template_options=>'a-Region--noPadding'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_default_landmark_type=>'region'
,p_region_title_dom_id=>'#REGION_STATIC_ID#_heading'
,p_reference_id=>174748721787471587
,p_translate_this_template=>'N'
,p_template_comment=>'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI a-Button--goToTop" onclick="uF();" type="button" title="&TOP."><span class="a-Icon icon-up-chevron"></span></button>'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3144203740501001)
,p_plug_template_id=>wwv_flow_imp.id(380771699411878611)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3144789539501001)
,p_plug_template_id=>wwv_flow_imp.id(380771699411878611)
,p_name=>'Change'
,p_placeholder=>'CHANGE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3145248557501001)
,p_plug_template_id=>wwv_flow_imp.id(380771699411878611)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3145713010501001)
,p_plug_template_id=>wwv_flow_imp.id(380771699411878611)
,p_name=>'Copy'
,p_placeholder=>'COPY'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3146233546501001)
,p_plug_template_id=>wwv_flow_imp.id(380771699411878611)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3146796837501001)
,p_plug_template_id=>wwv_flow_imp.id(380771699411878611)
,p_name=>'Create2'
,p_placeholder=>'CREATE2'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3147280923501002)
,p_plug_template_id=>wwv_flow_imp.id(380771699411878611)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3147795554501002)
,p_plug_template_id=>wwv_flow_imp.id(380771699411878611)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3148232889501002)
,p_plug_template_id=>wwv_flow_imp.id(380771699411878611)
,p_name=>'Expand'
,p_placeholder=>'EXPAND'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3148712804501002)
,p_plug_template_id=>wwv_flow_imp.id(380771699411878611)
,p_name=>'Help'
,p_placeholder=>'HELP'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3149228821501002)
,p_plug_template_id=>wwv_flow_imp.id(380771699411878611)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3149750045501002)
,p_plug_template_id=>wwv_flow_imp.id(380771699411878611)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3150284500501002)
,p_plug_template_id=>wwv_flow_imp.id(380771699411878611)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_div_with_id_class_and_region_attributes
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(385770331595976651)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" class="#REGION_CSS_CLASSES#" #REGION_LANDMARK_ATTRIBUTES# #REGION_ATTRIBUTES#>#PREVIOUS##BODY##NEXT#</div>'
,p_page_plug_template_name=>'[x] APEX 5.0 - Div with ID, Class, and Region Attributes'
,p_internal_name=>'APEX_5.0_DIV_WITH_ID,_CLASS,_AND_REGION_ATTRIBUTES'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>716895227337398760
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(32623447158747577)
,p_plug_template_id=>wwv_flow_imp.id(385770331595976651)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(32623930637747577)
,p_plug_template_id=>wwv_flow_imp.id(385770331595976651)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(32624452081747578)
,p_plug_template_id=>wwv_flow_imp.id(385770331595976651)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(32624942853747578)
,p_plug_template_id=>wwv_flow_imp.id(385770331595976651)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_region_hidden_heading
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(385893260111566687)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <h2 class="u-VisuallyHidden" data-apex-heading>#TITLE#</h2>',
'  <div class="a-Region-body">',
'  #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'[x] APEX 5.0 - Region (Hidden Heading)'
,p_internal_name=>'APEX_5.0_REGION_HIDDEN_HEADING'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>717832816842067694
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3198946782502850)
,p_plug_template_id=>wwv_flow_imp.id(385893260111566687)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3199449405502850)
,p_plug_template_id=>wwv_flow_imp.id(385893260111566687)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_layout_container
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(386079172240342588)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="u-Table #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'#BODY#',
'#SUB_REGIONS#',
'</div>'))
,p_sub_plug_template=>'<div class="u-Table-fill">#SUB_REGION#</div>'
,p_page_plug_template_name=>'APEX 5.0 - Layout Container'
,p_internal_name=>'APEX_5.0_LAYOUT_CONTAINER'
,p_theme_id=>3
,p_theme_class_id=>7
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140625790284344381)
,p_plug_template_id=>wwv_flow_imp.id(386079172240342588)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140625807453344381)
,p_plug_template_id=>wwv_flow_imp.id(386079172240342588)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>false
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_button_region
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(690697788869123307)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-ButtonRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_LANDMARK_ATTRIBUTES# #REGION_ATTRIBUTES#>',
'  <div class="a-ButtonRegion-wrap">',
'    <div class="a-ButtonRegion-col a-ButtonRegion-col--left"><div class="a-ButtonRegion-buttons">#PREVIOUS##DELETE##CLOSE#</div></div>',
'    <div class="a-ButtonRegion-col a-ButtonRegion-col--content">',
'      <h2 id="#REGION_STATIC_ID#_TITLE" class="a-ButtonRegion-title" data-apex-heading>#TITLE#</h2>',
'      #BODY#',
'      <div class="a-ButtonRegion-buttons">#CHANGE#</div>',
'    </div>',
'    <div class="a-ButtonRegion-col a-ButtonRegion-col--right"><div class="a-ButtonRegion-buttons">#EDIT##CREATE##NEXT#</div></div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Button Region'
,p_internal_name=>'APEX_5.0_BUTTON_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_template_options=>'a-ButtonRegion--wizard'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_default_landmark_type=>'region'
,p_region_title_dom_id=>'#REGION_STATIC_ID#_TITLE'
,p_reference_id=>687153470345619376
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2317153217232381)
,p_plug_template_id=>wwv_flow_imp.id(690697788869123307)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2317659208232381)
,p_plug_template_id=>wwv_flow_imp.id(690697788869123307)
,p_name=>'Change'
,p_placeholder=>'CHANGE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2318129038232381)
,p_plug_template_id=>wwv_flow_imp.id(690697788869123307)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2318680893232381)
,p_plug_template_id=>wwv_flow_imp.id(690697788869123307)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2319117315232382)
,p_plug_template_id=>wwv_flow_imp.id(690697788869123307)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2319609612232382)
,p_plug_template_id=>wwv_flow_imp.id(690697788869123307)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2320114681232382)
,p_plug_template_id=>wwv_flow_imp.id(690697788869123307)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2320664356232382)
,p_plug_template_id=>wwv_flow_imp.id(690697788869123307)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2321199760232382)
,p_plug_template_id=>wwv_flow_imp.id(690697788869123307)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_interactive_report_region
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(690714020036152159)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#REGION_STATIC_ID#" class="a-IRR-region #REGION_CSS_CLASSES#" #REGION_LANDMARK_ATTRIBUTES# #REGION_ATTRIBUTES#>',
'  <h2 id="#REGION_STATIC_ID#_heading" class="u-vh a-Region-header" data-apex-heading>#TITLE#</h2>',
'  #PREVIOUS##BODY##NEXT#',
'</div>',
''))
,p_page_plug_template_name=>'[x] APEX 5.0 - Interactive Report Region'
,p_internal_name=>'APEX_5.0_INTERACTIVE_REPORT_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_template_options=>'a-IRR-region--responsiveIconView'
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_default_landmark_type=>'region'
,p_region_title_dom_id=>'#REGION_STATIC_ID#_heading'
,p_reference_id=>678354360586321695
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2947648000493396)
,p_plug_template_id=>wwv_flow_imp.id(690714020036152159)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2948155722493396)
,p_plug_template_id=>wwv_flow_imp.id(690714020036152159)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2948602486493396)
,p_plug_template_id=>wwv_flow_imp.id(690714020036152159)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2949154006493396)
,p_plug_template_id=>wwv_flow_imp.id(690714020036152159)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_region_with_icon
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(703386252988943977)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region a-Region--hasIcon #REGION_CSS_CLASSES#" #REGION_LANDMARK_ATTRIBUTES# #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 id="#REGION_STATIC_ID#_TITLE" class="a-Region-title" data-apex-heading>#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'    <div class="a-RegionMedia">',
'      <div class="a-RegionMedia-graphic">',
'        <span aria-hidden="true" class="a-Icon a-Icon--regionIcon #ICON_CSS_CLASSES#"></span>',
'      </div>',
'      <div class="a-RegionMedia-content">',
'        #BODY#',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Region with Icon'
,p_internal_name=>'APEX_5.0_REGION_WITH_ICON'
,p_theme_id=>3
,p_theme_class_id=>21
,p_preset_template_options=>'a-Region--noPadding'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_default_landmark_type=>'region'
,p_region_title_dom_id=>'#REGION_STATIC_ID#_TITLE'
,p_reference_id=>698829239393878937
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1687170522423910)
,p_plug_template_id=>wwv_flow_imp.id(703386252988943977)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1687675517423910)
,p_plug_template_id=>wwv_flow_imp.id(703386252988943977)
,p_name=>'Change'
,p_placeholder=>'CHANGE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1688183946423910)
,p_plug_template_id=>wwv_flow_imp.id(703386252988943977)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1688664127423910)
,p_plug_template_id=>wwv_flow_imp.id(703386252988943977)
,p_name=>'Copy'
,p_placeholder=>'COPY'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1689172459423910)
,p_plug_template_id=>wwv_flow_imp.id(703386252988943977)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1689636219423910)
,p_plug_template_id=>wwv_flow_imp.id(703386252988943977)
,p_name=>'Create2'
,p_placeholder=>'CREATE2'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1690113475423910)
,p_plug_template_id=>wwv_flow_imp.id(703386252988943977)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1690675572423911)
,p_plug_template_id=>wwv_flow_imp.id(703386252988943977)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1691161740423911)
,p_plug_template_id=>wwv_flow_imp.id(703386252988943977)
,p_name=>'Expand'
,p_placeholder=>'EXPAND'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1691671643423911)
,p_plug_template_id=>wwv_flow_imp.id(703386252988943977)
,p_name=>'Help'
,p_placeholder=>'HELP'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1692149284423911)
,p_plug_template_id=>wwv_flow_imp.id(703386252988943977)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1692653144423911)
,p_plug_template_id=>wwv_flow_imp.id(703386252988943977)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(1693156331423911)
,p_plug_template_id=>wwv_flow_imp.id(703386252988943977)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_hide_show_region
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(717403738062820750)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region a-Region--hideShow #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# #REGION_LANDMARK_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--controls">',
'        <h2 id="#REGION_STATIC_ID#_TITLE" class="a-Region-title" data-apex-heading>',
'            <button class="a-Region-toggle" type="button">#TITLE#</button>',
'        </h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'  #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'[x] APEX 5.0 - Hide + Show Region'
,p_internal_name=>'APEX_5.0_HIDE_+_SHOW_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_template_options=>'a-Region--flush'
,p_preset_template_options=>'is-expanded'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_default_landmark_type=>'region'
,p_region_title_dom_id=>'#REGION_STATIC_ID#_TITLE'
,p_reference_id=>689955986849128825
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2868424057491388)
,p_plug_template_id=>wwv_flow_imp.id(717403738062820750)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2868944022491389)
,p_plug_template_id=>wwv_flow_imp.id(717403738062820750)
,p_name=>'Change'
,p_placeholder=>'CHANGE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2869472522491389)
,p_plug_template_id=>wwv_flow_imp.id(717403738062820750)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2869955602491389)
,p_plug_template_id=>wwv_flow_imp.id(717403738062820750)
,p_name=>'Copy'
,p_placeholder=>'COPY'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2870480494491389)
,p_plug_template_id=>wwv_flow_imp.id(717403738062820750)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2870940220491389)
,p_plug_template_id=>wwv_flow_imp.id(717403738062820750)
,p_name=>'Create2'
,p_placeholder=>'CREATE2'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2871425021491389)
,p_plug_template_id=>wwv_flow_imp.id(717403738062820750)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2871979709491389)
,p_plug_template_id=>wwv_flow_imp.id(717403738062820750)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2872459439491389)
,p_plug_template_id=>wwv_flow_imp.id(717403738062820750)
,p_name=>'Expand'
,p_placeholder=>'EXPAND'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2872901496491390)
,p_plug_template_id=>wwv_flow_imp.id(717403738062820750)
,p_name=>'Help'
,p_placeholder=>'HELP'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2873463518491390)
,p_plug_template_id=>wwv_flow_imp.id(717403738062820750)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2873930057491390)
,p_plug_template_id=>wwv_flow_imp.id(717403738062820750)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2874491076491390)
,p_plug_template_id=>wwv_flow_imp.id(717403738062820750)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_page_anchors
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(717413953976820775)
,p_layout=>'TABLE'
,p_template=>'<div class="a-PageAnchors #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_LANDMARK_ATTRIBUTES# #REGION_ATTRIBUTES#>#BODY#</div>'
,p_page_plug_template_name=>'[x] APEX 5.0 - Page Anchors'
,p_internal_name=>'APEX_5.0_PAGE_ANCHORS'
,p_plug_table_bgcolor=>'white'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'white'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_default_landmark_type=>'region'
,p_form_table_attr=>' '
,p_reference_id=>17354206769599941
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(135733768264120568)
,p_plug_template_id=>wwv_flow_imp.id(717413953976820775)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(135734299553120569)
,p_plug_template_id=>wwv_flow_imp.id(717413953976820775)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_page_designer_column
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(717414629694820775)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-PageColumn #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-PageColumn-header">',
'    <h2 class="a-PageColumn-heading" data-apex-heading>#TITLE#</h2>',
'  </div>',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Page Designer Column'
,p_internal_name=>'APEX_5.0_PAGE_DESIGNER_COLUMN'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174613223222362440
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3759184206621369)
,p_plug_template_id=>wwv_flow_imp.id(717414629694820775)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3759646957621369)
,p_plug_template_id=>wwv_flow_imp.id(717414629694820775)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_page_designer_column_body
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(717415310646820776)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-PageColumn-body #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Page Designer Column (Body)'
,p_internal_name=>'APEX_5.0_PAGE_DESIGNER_COLUMN_BODY'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174630015632506596
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140630424943344376)
,p_plug_template_id=>wwv_flow_imp.id(717415310646820776)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140630552482344376)
,p_plug_template_id=>wwv_flow_imp.id(717415310646820776)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_toolbar
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(717416953442820777)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div role="toolbar" aria-label="#TITLE!ATTR#" class="a-Toolbar #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Toolbar-items a-Toolbar-items--left">#PREVIOUS#</div>',
'  <div class="a-Toolbar-items a-Toolbar-items--right">#NEXT#</div>',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Toolbar'
,p_internal_name=>'APEX_5.0_TOOLBAR'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174613705533399534
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(68610428493251732)
,p_plug_template_id=>wwv_flow_imp.id(717416953442820777)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(68610995903251732)
,p_plug_template_id=>wwv_flow_imp.id(717416953442820777)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(68611464254251732)
,p_plug_template_id=>wwv_flow_imp.id(717416953442820777)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(68611953614251733)
,p_plug_template_id=>wwv_flow_imp.id(717416953442820777)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_toolbar_items_left
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(717417607324820781)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Toolbar-items a-Toolbar-items--left #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'  #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Toolbar Items (Left)'
,p_internal_name=>'APEX_5.0_TOOLBAR_ITEMS_LEFT'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174628415239478085
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140631265610344375)
,p_plug_template_id=>wwv_flow_imp.id(717417607324820781)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140631366145344375)
,p_plug_template_id=>wwv_flow_imp.id(717417607324820781)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140631416167344375)
,p_plug_template_id=>wwv_flow_imp.id(717417607324820781)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140631504266344375)
,p_plug_template_id=>wwv_flow_imp.id(717417607324820781)
,p_name=>'Expand'
,p_placeholder=>'EXPAND'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140631670438344375)
,p_plug_template_id=>wwv_flow_imp.id(717417607324820781)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140631796624344375)
,p_plug_template_id=>wwv_flow_imp.id(717417607324820781)
,p_name=>'Create2'
,p_placeholder=>'CREATE2'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140631851827344375)
,p_plug_template_id=>wwv_flow_imp.id(717417607324820781)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140631904406344375)
,p_plug_template_id=>wwv_flow_imp.id(717417607324820781)
,p_name=>'Help'
,p_placeholder=>'HELP'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140632086527344375)
,p_plug_template_id=>wwv_flow_imp.id(717417607324820781)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140632184989344375)
,p_plug_template_id=>wwv_flow_imp.id(717417607324820781)
,p_name=>'Copy'
,p_placeholder=>'COPY'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140632272366344374)
,p_plug_template_id=>wwv_flow_imp.id(717417607324820781)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140632352001344374)
,p_plug_template_id=>wwv_flow_imp.id(717417607324820781)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140632498942344374)
,p_plug_template_id=>wwv_flow_imp.id(717417607324820781)
,p_name=>'Change'
,p_placeholder=>'CHANGE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_toolbar_items_right
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(717418310522820781)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Toolbar-items a-Toolbar-items--right #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'  #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Toolbar Items (Right)'
,p_internal_name=>'APEX_5.0_TOOLBAR_ITEMS_RIGHT'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174629130392501406
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140632574281344374)
,p_plug_template_id=>wwv_flow_imp.id(717418310522820781)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140632684557344374)
,p_plug_template_id=>wwv_flow_imp.id(717418310522820781)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140632728489344374)
,p_plug_template_id=>wwv_flow_imp.id(717418310522820781)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140632829190344374)
,p_plug_template_id=>wwv_flow_imp.id(717418310522820781)
,p_name=>'Expand'
,p_placeholder=>'EXPAND'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140632976120344374)
,p_plug_template_id=>wwv_flow_imp.id(717418310522820781)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140633006992344374)
,p_plug_template_id=>wwv_flow_imp.id(717418310522820781)
,p_name=>'Create2'
,p_placeholder=>'CREATE2'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140633187155344373)
,p_plug_template_id=>wwv_flow_imp.id(717418310522820781)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140633239349344373)
,p_plug_template_id=>wwv_flow_imp.id(717418310522820781)
,p_name=>'Help'
,p_placeholder=>'HELP'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140633325873344373)
,p_plug_template_id=>wwv_flow_imp.id(717418310522820781)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140633488530344373)
,p_plug_template_id=>wwv_flow_imp.id(717418310522820781)
,p_name=>'Copy'
,p_placeholder=>'COPY'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140633553386344373)
,p_plug_template_id=>wwv_flow_imp.id(717418310522820781)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140633605355344373)
,p_plug_template_id=>wwv_flow_imp.id(717418310522820781)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140633751591344373)
,p_plug_template_id=>wwv_flow_imp.id(717418310522820781)
,p_name=>'Change'
,p_placeholder=>'CHANGE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_wizard_body_hide_show
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(717419046555820782)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aWizardRegion aWizardRegion--disclosure" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="wizardRegionHeading">',
'    <h2 data-apex-heading>',
'        <button type="button">#TITLE#</button>',
'    </h2>',
'    <div class="buttonContainer">',
'    #EDIT##CLOSE##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT##CREATE##CREATE2#',
'    </div>',
'  </div>',
'  <div class="hideShowRegion" id="#REGION_STATIC_ID#_content">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'[x] APEX 5.0 - Wizard Body (Hide/Show)'
,p_internal_name=>'APEX_5.0_WIZARD_BODY_HIDE/SHOW'
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'$( "##REGION_STATIC_ID#" ).collapsible({',
'    content: $( "##REGION_STATIC_ID#_content" )',
'});'))
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>399850559367741099
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3317470807506014)
,p_plug_template_id=>wwv_flow_imp.id(717419046555820782)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3317911990506014)
,p_plug_template_id=>wwv_flow_imp.id(717419046555820782)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3318489259506014)
,p_plug_template_id=>wwv_flow_imp.id(717419046555820782)
,p_name=>'Copy'
,p_placeholder=>'COPY'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3318932037506014)
,p_plug_template_id=>wwv_flow_imp.id(717419046555820782)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3319400184506014)
,p_plug_template_id=>wwv_flow_imp.id(717419046555820782)
,p_name=>'Create2'
,p_placeholder=>'CREATE2'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3319924921506014)
,p_plug_template_id=>wwv_flow_imp.id(717419046555820782)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3320444871506015)
,p_plug_template_id=>wwv_flow_imp.id(717419046555820782)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3320992609506015)
,p_plug_template_id=>wwv_flow_imp.id(717419046555820782)
,p_name=>'Expand'
,p_placeholder=>'EXPAND'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3321416601506015)
,p_plug_template_id=>wwv_flow_imp.id(717419046555820782)
,p_name=>'Help'
,p_placeholder=>'HELP'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3321902181506015)
,p_plug_template_id=>wwv_flow_imp.id(717419046555820782)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3322409825506015)
,p_plug_template_id=>wwv_flow_imp.id(717419046555820782)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3322964570506015)
,p_plug_template_id=>wwv_flow_imp.id(717419046555820782)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_wizard_region
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(717419707883820782)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Wizard-region a-Form #REGION_CSS_CLASSES#" #REGION_LANDMARK_ATTRIBUTES# #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <h2 id="#REGION_STATIC_ID#_TITLE" class="u-vh" data-apex-heading>#TITLE#</h2>',
'  <div class="a-Wizard-regionHeader">#REGION_HEADER#</div>',
'  <div class="a-Wizard-regionBody">#BODY#</div>',
'  <div class="a-Wizard-regionFooter">#REGION_FOOTER#</div>',
'</div>'))
,p_page_plug_template_name=>'[x] APEX 5.0 - Wizard Region'
,p_internal_name=>'APEX_5.0_WIZARD_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_default_landmark_type=>'region'
,p_region_title_dom_id=>'#REGION_STATIC_ID#_TITLE'
,p_reference_id=>702777601713950915
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3364942479508595)
,p_plug_template_id=>wwv_flow_imp.id(717419707883820782)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3365417172508596)
,p_plug_template_id=>wwv_flow_imp.id(717419707883820782)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_wizard_title_region
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(717420493098820783)
,p_layout=>'TABLE'
,p_template=>'<div class="#REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#><h1 class="a-Wizard-title" data-apex-heading>#TITLE#</h1></div>'
,p_page_plug_template_name=>'[x] APEX 5.0 - Wizard Title Region'
,p_internal_name=>'APEX_5.0_WIZARD_TITLE_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>703469000349150769
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3391489230510523)
,p_plug_template_id=>wwv_flow_imp.id(717420493098820783)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3391957034510523)
,p_plug_template_id=>wwv_flow_imp.id(717420493098820783)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_iframe_region
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(737759501522573640)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region a-Region--iframe #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title" data-apex-heading>#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'  #BODY#',
'  </div>',
'  <div class="a-Region-iframeButtons">',
'    <div class="a-ButtonRegion">',
'      <div class="a-ButtonRegion-wrap">',
'        <div class="a-ButtonRegion-col a-ButtonRegion-col--left"><div class="a-ButtonRegion-buttons">#PREVIOUS##DELETE##CLOSE#</div></div>',
'        <div class="a-ButtonRegion-col a-ButtonRegion-col--content">',
'          <div class="a-ButtonRegion-buttons">#CHANGE#</div>',
'        </div>',
'        <div class="a-ButtonRegion-col a-ButtonRegion-col--right"><div class="a-ButtonRegion-buttons">#EDIT##CREATE##NEXT#</div></div>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'[x] APEX 5.0 - iFrame Region'
,p_internal_name=>'APEX_5.0_IFRAME_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_preset_template_options=>'a-Region--paddedBody'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>737749193541531906
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3417776337514193)
,p_plug_template_id=>wwv_flow_imp.id(737759501522573640)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3418232487514193)
,p_plug_template_id=>wwv_flow_imp.id(737759501522573640)
,p_name=>'Change'
,p_placeholder=>'CHANGE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3418712921514194)
,p_plug_template_id=>wwv_flow_imp.id(737759501522573640)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3419287602514194)
,p_plug_template_id=>wwv_flow_imp.id(737759501522573640)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3419764078514194)
,p_plug_template_id=>wwv_flow_imp.id(737759501522573640)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3420294560514194)
,p_plug_template_id=>wwv_flow_imp.id(737759501522573640)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3420718170514194)
,p_plug_template_id=>wwv_flow_imp.id(737759501522573640)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3421211459514194)
,p_plug_template_id=>wwv_flow_imp.id(737759501522573640)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(3421708460514194)
,p_plug_template_id=>wwv_flow_imp.id(737759501522573640)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_alert
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(746376253838324384)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_LANDMARK_ATTRIBUTES# #REGION_ATTRIBUTES#>',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon #ICON_CSS_CLASSES#" aria-hidden="true"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 id="#REGION_STATIC_ID#_TITLE" class="a-Alert-title" data-apex-heading>#TITLE#</h2>',
'      </div>',
'      <div role="alert" class="a-Alert-body">#BODY#</div>',
'    </div>',
'    <div class="a-Alert-buttons">#PREVIOUS##CLOSE##CREATE##NEXT#</div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'[x] APEX 5.0 - Alert'
,p_internal_name=>'APEX_5.0_ALERT'
,p_theme_id=>3
,p_theme_class_id=>7
,p_default_template_options=>'a-Alert--defaultIcons'
,p_preset_template_options=>'a-Alert--warning:a-Alert--wizard'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_default_landmark_type=>'region'
,p_region_title_dom_id=>'#REGION_STATIC_ID#_TITLE'
,p_reference_id=>746362351042209764
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2606970615486634)
,p_plug_template_id=>wwv_flow_imp.id(746376253838324384)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2607490615486634)
,p_plug_template_id=>wwv_flow_imp.id(746376253838324384)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2607934632486634)
,p_plug_template_id=>wwv_flow_imp.id(746376253838324384)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2608466852486635)
,p_plug_template_id=>wwv_flow_imp.id(746376253838324384)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2608913845486635)
,p_plug_template_id=>wwv_flow_imp.id(746376253838324384)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(2609408057486635)
,p_plug_template_id=>wwv_flow_imp.id(746376253838324384)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_region_dialog
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(1131993087623131882)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#REGION_STATIC_ID#"  class="a-DialogRegion js-regionDialog #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# style="display:none" title="#TITLE#">',
'  <div class="a-DialogRegion-body">',
'#BODY#',
'  </div>',
'  <div class="a-DialogRegion-buttons">',
'     <div class="a-ButtonRegion a-ButtonRegion--dialogRegion">',
'       <div class="a-ButtonRegion-wrap">',
'         <div class="a-ButtonRegion-col a-ButtonRegion-col--left"><div class="a-ButtonRegion-buttons">#PREVIOUS##DELETE##CLOSE#</div></div>',
'         <div class="a-ButtonRegion-col a-ButtonRegion-col--right"><div class="a-ButtonRegion-buttons">#EDIT##CREATE##NEXT#</div></div>',
'       </div>',
'     </div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'[x] APEX 5.0 - Region Dialog'
,p_internal_name=>'APEX_5.0_REGION_DIALOG'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_template_options=>'js-draggable:js-resizable:js-modal'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>428597701677720079
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(88396950648832854)
,p_plug_template_id=>wwv_flow_imp.id(1131993087623131882)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(88397406280832854)
,p_plug_template_id=>wwv_flow_imp.id(1131993087623131882)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(88397947921832854)
,p_plug_template_id=>wwv_flow_imp.id(1131993087623131882)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(88398453429832855)
,p_plug_template_id=>wwv_flow_imp.id(1131993087623131882)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(88398987674832855)
,p_plug_template_id=>wwv_flow_imp.id(1131993087623131882)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(88399462614832855)
,p_plug_template_id=>wwv_flow_imp.id(1131993087623131882)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(88399989588832856)
,p_plug_template_id=>wwv_flow_imp.id(1131993087623131882)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(88400409851832856)
,p_plug_template_id=>wwv_flow_imp.id(1131993087623131882)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_nested_splitter
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(1225836530715180993)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES# class="resize #REGION_CSS_CLASSES#"> ',
'#BODY#',
'<div id="#REGION_STATIC_ID#_content" class="resize">',
'#SUB_REGIONS#',
'</div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Nested Splitter'
,p_internal_name=>'APEX_5.0_NESTED_SPLITTER'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>177373906751600776
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140637795916344369)
,p_plug_template_id=>wwv_flow_imp.id(1225836530715180993)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140637817526344369)
,p_plug_template_id=>wwv_flow_imp.id(1225836530715180993)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/list/dhtml_list_image_with_sublist_from_4999
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(1216501287578773)
,p_list_template_current=>'<div class="dhtmlMenuItem"><a href="#LINK#" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# /></a><img src="#IMAGE_PREFIX#htmldb/builder/menu_pulldown.png" width="32" height="84" class="dhtmlMenu" onclick="app_AppMenuMultiOpenBott'
||'om(this,''#LIST_ITEM_ID#'',false)" alt=""/><a href="#LINK#" class="dhtmlBottom" title="#TEXT_ESC_SC#">#TEXT#</a></div>'
,p_list_template_noncurrent=>'<div class="dhtmlMenuItem"><a href="#LINK#" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# /></a><img src="#IMAGE_PREFIX#htmldb/builder/menu_pulldown.png" width="32" height="84" class="dhtmlMenu" onclick="app_AppMenuMultiOpenBott'
||'om(this,''#LIST_ITEM_ID#'',false)" alt="" /><a href="#LINK#" class="dhtmlBottom" title="#TEXT_ESC_SC#">#TEXT#</a></div>'
,p_list_template_name=>'DHTML List (Image) with Sublist from 4999'
,p_internal_name=>'DHTML_LIST_IMAGE_WITH_SUBLIST_FROM_4999'
,p_theme_id=>3
,p_theme_class_id=>10
,p_list_template_before_rows=>'<div class="dhtmlMenuLG">'
,p_list_template_after_rows=>'</div><br style="clear:both;"/><br style="clear:both;"/>'
,p_before_sub_list=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="dhtmlSubMenu" style="display:none;">',
'<li class="dhtmlSubMenuP" onmouseover="dhtml_CloseAllSubMenusL(this)">#PARENT_TEXT#</li>'))
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="dhtmlMenuSep"><img src="#IMAGE_PREFIX#1px_trans.gif"  width="1" height="1" alt=""  class="dhtmlMenuSep" /></li>'
,p_sub_list_item_noncurrent=>'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)" title="#TEXT_ESC_SC#">#TEXT#</a></li>'
,p_sub_templ_curr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')" title="#TEXT_ESC_SC#"><span>#TEXT#</span><img class="htmldbMIMG" alt="" src="#IMAGE_PREFIX#menu_open_right2.gif" /></a></'
||'li>'
,p_sub_templ_noncurr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')" title="#TEXT_ESC_SC#"><span>#TEXT#</span><img class="htmldbMIMG" alt="" src="#IMAGE_PREFIX#menu_open_right2.gif" /></a></'
||'li>'
,p_reference_id=>6245728734686542
);
end;
/
prompt --application/shared_components/user_interface/templates/list/simple_tabbed_navigation_list_ppr
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(11751121765920036)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td valign="bottom"><a href="javascript:ob_PPR_TAB(''#LINK#'')" class="tabcurrent" #A01# title="#TEXT_ESC_SC#">#TEXT#</a></td>',
''))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td valign="bottom"><a href="javascript:ob_PPR_TAB(''#LINK#'')" #A01# title="#TEXT_ESC_SC#">#TEXT#</a></td>',
'',
''))
,p_list_template_name=>'Simple Tabbed Navigation List (PPR)'
,p_internal_name=>'SIMPLE_TABBED_NAVIGATION_LIST_PPR'
,p_theme_id=>3
,p_theme_class_id=>7
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table class="htmldbTabbedNavigationList" border="0" cellpadding="0" cellspacing="0" summary=""><tr>',
'',
''))
,p_list_template_after_rows=>'<td width="100%"><br /></td></tr></table>'
,p_item_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td valign="bottom"><a href="#LINK#" class="tabcurrent" #A01# title="#TEXT_ESC_SC#">#TEXT#</a></td>',
''))
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td valign="bottom"><a href="#LINK#" #A01# title="#TEXT_ESC_SC#">#TEXT#</a></td>',
''))
,p_reference_id=>108849122001556988
);
end;
/
prompt --application/shared_components/user_interface/templates/list/dhtml_list_button_with_sublist
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(18702621564272688)
,p_list_template_current=>'<li>#TEXT#</li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#" class="dList" title="#TEXT_ESC_SC#">#TEXT#</a></li>'
,p_list_template_name=>'DHTML List Button with Sublist'
,p_internal_name=>'DHTML_LIST_BUTTON_WITH_SUBLIST'
,p_theme_id=>3
,p_theme_class_id=>10
,p_list_template_before_rows=>'<ul class="dList">'
,p_list_template_after_rows=>'</ul>'
,p_item_templ_curr_w_child=>'<li>#TEXT#</li>'
,p_item_templ_noncurr_w_child=>'<li><a href="#LINK#" class="dList" title="#TEXT_ESC_SC#">#TEXT#</a></li>'
,p_reference_id=>18183125227392377
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_links_list
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(20507805987268923)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-LinksList-item is-current #A03#" aria-current="page">',
'  <a href="#LINK#" class="a-LinksList-link" #A02#>',
'    <span class="a-LinksList-icon" aria-hidden="true"><span class="t-Icon #IMAGE#"></span></span>',
'    <span class="a-LinksList-label">#TEXT#</span>',
'    <span class="u-vh">&nbsp;</span>',
'    <span class="a-LinksList-badge">#A01#</span>',
'    <span class="a-LinksList-arrow" aria-hidden="true"></span>',
'  </a>',
'</li>',
''))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-LinksList-item #A03#">',
'  <a href="#LINK#" class="a-LinksList-link" #A02#>',
'    <span class="a-LinksList-icon" aria-hidden="true"><span class="t-Icon #IMAGE#"></span></span>',
'    <span class="a-LinksList-label">#TEXT#</span>',
'    <span class="u-vh">&nbsp;</span>',
'    <span class="a-LinksList-badge">#A01#</span>',
'    <span class="a-LinksList-arrow" aria-hidden="true"></span>',
'  </a>',
'</li>',
''))
,p_list_template_name=>'[x] APEX 5.0 - Links List (2)'
,p_internal_name=>'APEX_5.0_LINKS_LIST'
,p_theme_id=>3
,p_theme_class_id=>1
,p_default_template_options=>'a-LinksList--showArrow'
,p_list_template_before_rows=>'<ul class="a-LinksList #COMPONENT_CSS_CLASSES#" id="#LIST_ID#">'
,p_list_template_after_rows=>'</ul>'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-LinksList-item is-current #A03#" aria-current="page">',
'  <a href="#LINK#" class="a-LinksList-link" #A02#>',
'    <span class="a-LinksList-icon" aria-hidden="true"><span class="t-Icon #IMAGE#"></span></span>',
'    <span class="a-LinksList-label">#TEXT#</span>',
'    <span class="a-LinksList-badge">#A01#</span>',
'    <span class="a-LinksList-arrow" aria-hidden="true"></span>',
'  </a>',
'</li>'))
,p_sub_list_item_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-LinksList-item #A03#">',
'  <a href="#LINK#" class="a-LinksList-link" #A02#>',
'    <span class="a-LinksList-icon" aria-hidden="true"><span class="t-Icon #IMAGE#"></span></span>',
'    <span class="a-LinksList-label">#TEXT#</span>',
'    <span class="a-LinksList-badge">#A01#</span>',
'    <span class="a-LinksList-arrow" aria-hidden="true"></span>',
'  </a>',
'</li>'))
,p_item_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-LinksList-item is-current is-expanded #A03#" aria-current="page">',
'  <a href="#LINK#" class="a-LinksList-link" #A02#>',
'    <span class="a-LinksList-icon" aria-hidden="true"><span class="t-Icon #IMAGE#"></span></span>',
'    <span class="a-LinksList-label">#TEXT#</span>',
'    <span class="u-vh">&nbsp;</span>',
'    <span class="a-LinksList-badge">#A01#</span>',
'    <span class="a-LinksList-arrow" aria-hidden="true"></span>',
'  </a>',
'  #SUB_LISTS#',
'</li>'))
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-LinksList-item #A03#">',
'  <a href="#LINK#" class="a-LinksList-link" #A02#>',
'    <span class="a-LinksList-icon" aria-hidden="true"><span class="t-Icon #IMAGE#"></span></span>',
'    <span class="a-LinksList-label">#TEXT#</span>',
'    <span class="u-vh">&nbsp;</span>',
'    <span class="a-LinksList-badge">#A01#</span>',
'    <span class="a-LinksList-arrow" aria-hidden="true"></span>',
'  </a>',
'  #SUB_LISTS#',
'</li>'))
,p_reference_id=>60219508156141083
);
end;
/
prompt --application/shared_components/user_interface/templates/list/flowwizard
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(23328315128356826)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-wiz-current"><span>#TEXT#</span></div>',
''))
,p_list_template_noncurrent=>'<div class="apex-wiz-non"><span>#TEXT#</span></div>'
,p_list_template_name=>'FlowWizard'
,p_internal_name=>'FLOWWIZARD'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<div class="apex-wiz-bar">'
,p_list_template_after_rows=>'</div>'
,p_between_items=>'<div class="apex-wiz-arrow"></div>'
,p_reference_id=>60218330803141060
);
end;
/
prompt --application/shared_components/user_interface/templates/list/columbus_object_browser_object_types
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(23673306353078906)
,p_list_template_current=>'<option htmldb:type="#A01#" id="#A01#" value="#A01#" selected="selected"">#TEXT#</option>'
,p_list_template_noncurrent=>'<option htmldb:type="#A01#" id="#A01#" value="#A01#">#TEXT#</option>'
,p_list_template_name=>'(Columbus) Object Browser Object Types'
,p_internal_name=>'COLUMBUS_OBJECT_BROWSER_OBJECT_TYPES'
,p_theme_id=>3
,p_theme_class_id=>16
,p_list_template_before_rows=>'<label for="obObjectSelect" class="hideMeButHearMe">Object Type</label><select onchange="gLastTab=false;gSideBar.onchange(true);"  id="obObjectSelect" class="a-Form-select">'
,p_list_template_after_rows=>'</select>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/simple_image_list
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(32427114807996970)
,p_list_template_current=>'<li><a href="#LINK#" title="#TEXT#">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#" title="#TEXT#">#TEXT#</a></li>'
,p_list_template_name=>'Simple Image List'
,p_internal_name=>'SIMPLE_IMAGE_LIST'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<ul class="listwithicon">'
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>32421627622986728
,p_list_template_comment=>'<img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# />'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/unordered_list_omit_current
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(35432701931461853)
,p_list_template_current=>' '
,p_list_template_noncurrent=>'<li><a href="#LINK#" title="#TEXT_ESC_SC#">#TEXT#</a></li>'
,p_list_template_name=>'Unordered List (omit current)'
,p_internal_name=>'UNORDERED_LIST_OMIT_CURRENT'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<ul class="noIndent">'
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>354043718465235283
);
end;
/
prompt --application/shared_components/user_interface/templates/list/simple_tabbed_navigation_list
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(108863608130594810)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td valign="bottom"><a href="#LINK#" class="tabcurrent" #A01# title="#TEXT_ESC_SC#">#TEXT#</a></td>',
'',
''))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td valign="bottom"><a href="#LINK#" #A01# title="#TEXT_ESC_SC#">#TEXT#</a></td>',
''))
,p_list_template_name=>'Simple Tabbed Navigation List'
,p_internal_name=>'SIMPLE_TABBED_NAVIGATION_LIST'
,p_theme_id=>3
,p_theme_class_id=>7
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table class="htmldbTabbedNavigationList" border="0" cellpadding="0" cellspacing="0"><tr>',
'',
''))
,p_list_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td width="100%"><br /></td></tr></table>',
''))
,p_item_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td valign="bottom"><a href="#LINK#" class="tabcurrent" #A01# title="#TEXT_ESC_SC#">#TEXT#</a></td>',
'',
''))
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td valign="bottom"><a href="#LINK#" #A01# title="#TEXT_ESC_SC#">#TEXT#</a></td>',
''))
,p_reference_id=>108854228567566739
);
end;
/
prompt --application/shared_components/user_interface/templates/list/image_list_legend
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(175500817357553766)
,p_list_template_current=>'<li><img src="#IMAGE_PREFIX##IMAGE#" style="margin-right:10px;" alt="" />#TEXT#</li>'
,p_list_template_noncurrent=>'<li><img src="#IMAGE_PREFIX##IMAGE#" style="margin-right:10px;" alt="" />#TEXT#</li>'
,p_list_template_name=>'Image List (Legend)'
,p_internal_name=>'IMAGE_LIST_LEGEND'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<ul class="htmldbSessionLegend">'
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>237858014773116158
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_sub_tabs
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(196867506292090262)
,p_list_template_current=>'<li class="a-Tabs-item is-active" aria-current="page"><a href="#LINK#" class="a-Tabs-link">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li class="a-Tabs-item"><a href="#LINK#" class="a-Tabs-link">#TEXT#</a></li>'
,p_list_template_name=>'APEX 5.0 - Sub Tabs (2)'
,p_internal_name=>'APEX_5.0_SUB_TABS'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-TabsContainer a-TabsContainer--subTabs">',
'  <ul class="a-Tabs a-Tabs--subTabButtons">'))
,p_list_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'  </ul>',
'</div>'))
,p_reference_id=>168708522102193705
,p_list_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aSubTabs"><ul>',
'<li class="active"><a href="#LINK#" title="#TEXT_ESC_SC#"><span>#TEXT#</span></a></li>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_4_2_pull_down_button_list
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(208299907447573159)
,p_list_template_current=>'<button onclick="javascript:redirect(''#LINK#'')" class="aButton hotButton" type="button"><span>#TEXT#</span></button> '
,p_list_template_noncurrent=>'<button onclick="javascript:redirect(''#LINK#'')" class="aButton" type="button"><span>#TEXT#</span></button> '
,p_list_template_name=>'APEX 4.2 - Pull Down Button List'
,p_internal_name=>'APEX_4.2_PULL_DOWN_BUTTON_LIST'
,p_theme_id=>3
,p_theme_class_id=>9
,p_list_template_before_rows=>'<div class="rButtonContainer dhtmlMenuLGButton">'
,p_list_template_after_rows=>'</div>'
,p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="dhtmlSubMenu" style="display:none;">'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="dhtmlMenuSep"><img src="#IMAGE_PREFIX#themes/theme_13/1px_trans.gif"  width="1" height="1" alt="" class="dhtmlMenuSep" /></li>'
,p_sub_list_item_noncurrent=>'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)">#TEXT#</a></li>'
,p_item_templ_curr_w_child=>'<button onclick="javascript:redirect(''#LINK#'')" class="aButton hotButton" type="button"><span>#TEXT#</span></button> '
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<button onclick="app_AppMenuMultiOpenBottom2(this,''#LIST_ITEM_ID#'',false)" class="dhtmlMenu" type="button"><span>#TEXT#<img src="#IMAGE_PREFIX#f_spacer.gif" alt="" /></span></button> ',
''))
,p_sub_templ_curr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" /></a></li>'
,p_sub_templ_noncurr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" / ></a></li>'
,p_reference_id=>253872418832604079
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_4_2_run_edit_bar
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(212033724996722960)
,p_list_template_current=>'  <li><a href="#LINK#" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#TEXT_ESC_SC#" class="iconSmall #A01#" /></a></li>'
,p_list_template_noncurrent=>'  <li><a href="#LINK#" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#TEXT_ESC_SC#" class="iconSmall #A01#" /></a></li>'
,p_list_template_name=>'APEX 4.2 - Run / Edit Bar'
,p_internal_name=>'APEX_4.2_RUN_/_EDIT_BAR'
,p_theme_id=>3
,p_theme_class_id=>3
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul class="aRunEditBar">',
'  <li><span class="currentPage">&PAGE. &FB_FLOW_PAGE_ID.</span></li>'))
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>210390516819756900
);
end;
/
prompt --application/shared_components/user_interface/templates/list/done_wizard_progress_sidebar_clickable
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(240152923292316768)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-wiz-current">',
'  <div class="apex-wiz-top"></div>',
'  <div class="apex-wiz-body">#TEXT#</div>',
'</div>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-wiz-non">',
'  <div class="apex-wiz-top"></div>',
'  <div class="apex-wiz-body"><a href="#LINK#" title="#TEXT_ESC_SC#">#TEXT#</a></div>',
'</div>'))
,p_list_template_name=>'(Done) Wizard Progress Sidebar (Clickable)'
,p_internal_name=>'DONE_WIZARD_PROGRESS_SIDEBAR_CLICKABLE'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<div class="apex-wiz-bar">'
,p_list_template_after_rows=>'</div>'
,p_between_items=>'<div class="apex-wiz-arrow-small"></div>'
,p_reference_id=>240146817030288131
);
end;
/
prompt --application/shared_components/user_interface/templates/list/button_list_horizontal_c_htmldbbuttonlist
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(292458412644987596)
,p_list_template_current=>'<td><a href="#LINK#" class="htmldbButtonListCurrent">#TEXT#</a></td>'
,p_list_template_noncurrent=>'<td><a href="#LINK#" class="htmldbButtonList">#TEXT#</a></td>'
,p_list_template_name=>'Button List Horizontal (c:htmldbButtonList)'
,p_internal_name=>'BUTTON_LIST_HORIZONTAL_C:HTMLDBBUTTONLIST'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<table class="htmldbButtonList" summary="" border="0" cellpadding="0" cellspacing="3"><tr>'
,p_list_template_after_rows=>'</tr></table>'
,p_item_templ_curr_w_child=>'<td><img src="#IMAGE_PREFIX#1px_trans.gif" alt="" width="20" height="1" /></td>'
,p_item_templ_noncurr_w_child=>'<td><img src="#IMAGE_PREFIX#1px_trans.gif" alt="" width="20" height="1" /></td>'
,p_reference_id=>21059717155998569
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_navigation_list
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(385776082908002390)
,p_list_template_current=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#" target="#A06#">#TEXT_ESC_SC#</a></li>'
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#" target="#A06#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_name=>'APEX 5.0 - Navigation List'
,p_internal_name=>'APEX_5.0_NAVIGATION_LIST'
,p_theme_id=>3
,p_theme_class_id=>7
,p_list_template_before_rows=>'<ul>'
,p_list_template_after_rows=>'</ul>'
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul></li>'
,p_sub_list_item_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#" target="#A06#">#TEXT_ESC_SC#</a></li>',
''))
,p_sub_list_item_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#" target="#A06#">#TEXT_ESC_SC#</a></li>',
''))
,p_item_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#" target="#A06#">#TEXT_ESC_SC#</a>',
''))
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#" target="#A06#">#TEXT_ESC_SC#</a>',
''))
,p_sub_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#" target="#A06#">#TEXT_ESC_SC#</a>',
''))
,p_sub_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#" target="#A06#">#TEXT_ESC_SC#</a>',
''))
,p_a06_label=>'Link Target'
,p_reference_id=>573607518145151423
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_menu_popup
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(385776364537002403)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#" target="#A06#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#" target="#A06#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_name=>'APEX 5.0 - Menu Popup'
,p_internal_name=>'APEX_5.0_MENU_POPUP'
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var e = apex.jQuery("##PARENT_STATIC_ID#_menu", apex.gPageContext$);',
'if (e.hasClass("js-addActions")) {',
'  apex.actions.addFromMarkup(e);',
'}',
'e.menu({ slide: e.hasClass("js-slide")});',
''))
,p_theme_id=>3
,p_theme_class_id=>20
,p_list_template_before_rows=>'<div id="#PARENT_STATIC_ID#_menu" class="#COMPONENT_CSS_CLASSES#" style="display:none;"><ul>'
,p_list_template_after_rows=>'</ul></div>'
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul></li>'
,p_sub_list_item_current=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#" target="#A06#">#TEXT_ESC_SC#</a></li>'
,p_sub_list_item_noncurrent=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#" target="#A06#">#TEXT_ESC_SC#</a></li>'
,p_item_templ_curr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#" target="#A06#">#TEXT_ESC_SC#</a>'
,p_item_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#" target="#A06#">#TEXT_ESC_SC#</a>'
,p_sub_templ_curr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#" target="#A06#">#TEXT_ESC_SC#</a>'
,p_sub_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#" target="#A06#">#TEXT_ESC_SC#</a>'
,p_a06_label=>'Target'
,p_reference_id=>747588010155545129
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_image_navigation
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(385894774262579225)
,p_list_template_current=>'<li class="a-ImageNav-item"><button type="button" data-link="#LINK#" class="a-ImageNav-link launch-aut #A01#"><span class="a-ImageNav-img gi-icon-#IMAGE#"></span><span class="a-ImageNav-label">#TEXT_ESC_SC#</span></button></li>'
,p_list_template_noncurrent=>'<li class="a-ImageNav-item"><a href="#LINK#" class="a-ImageNav-link #A01#"><span class="a-ImageNav-img gi-icon-#IMAGE#"></span><span class="a-ImageNav-label">#TEXT_ESC_SC#</span></a></li>'
,p_list_template_name=>'APEX 5.0 - Image Navigation'
,p_internal_name=>'APEX_5.0_IMAGE_NAVIGATION'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<ul class="a-ImageNav #COMPONENT_CSS_CLASSES#">'
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>481290423891543508
,p_list_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td style="width: 20%">',
'	<a href="#LINK#" class="iconContainer" title="#TEXT_ESC_SC#">',
'		<span class="largeIcon"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# /></span>',
'		<span class="iconLabel">#TEXT#</span>',
'	</a>',
'</td>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_4_0_pull_down_button_list
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(436814111820869843)
,p_list_template_current=>'<button onclick="javascript:redirect(''#LINK#'')" class="aButton hotButton" type="button"><span>#TEXT#</span></button> '
,p_list_template_noncurrent=>'<button onclick="javascript:redirect(''#LINK#'')" class="aButton" type="button"><span>#TEXT#</span></button> '
,p_list_template_name=>'APEX 4.0 - Pull Down Button List'
,p_internal_name=>'APEX_4.0_PULL_DOWN_BUTTON_LIST'
,p_theme_id=>3
,p_theme_class_id=>9
,p_list_template_before_rows=>'<div class="rButtonContainer dhtmlMenuLGButton">'
,p_list_template_after_rows=>'</div>'
,p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="dhtmlSubMenu" style="display:none;">'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="dhtmlMenuSep"><img src="#IMAGE_PREFIX#themes/theme_13/1px_trans.gif"  width="1" height="1" alt="" class="dhtmlMenuSep" /></li>'
,p_sub_list_item_noncurrent=>'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)">#TEXT#</a></li>'
,p_item_templ_curr_w_child=>'<button onclick="javascript:redirect(''#LINK#'')" class="aButton hotButton" type="button"><span>#TEXT#</span></button> '
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<button onclick="app_AppMenuMultiOpenBottom2(this,''#LIST_ITEM_ID#'',false)" class="dhtmlMenu" type="button"><span>#TEXT#<img src="#IMAGE_PREFIX#f_spacer.gif" alt="" /></span></button> ',
''))
,p_sub_templ_curr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" /></a></li>'
,p_sub_templ_noncurr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" / ></a></li>'
,p_reference_id=>253872418832604079
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_4_0_ob_button_list
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(461032606198391037)
,p_list_template_current=>'<div class="list-button-c"><button onclick="#LINK#" class="dhtmlMenu" type="button"><span>#TEXT#</span></button></div>'
,p_list_template_noncurrent=>'<div class="list-button-nc"><button onclick="#LINK#" class="dhtmlMenu" type="button"><span>#TEXT#</span></button></div>'
,p_list_template_name=>'APEX 4.0 - OB Button List'
,p_internal_name=>'APEX_4.0_OB_BUTTON_LIST'
,p_theme_id=>3
,p_theme_class_id=>9
,p_list_template_before_rows=>'<div class="dhtmlMenuLGButton">'
,p_list_template_after_rows=>'</div>'
,p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="dhtmlSubMenu" style="display:none;">'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="dhtmlMenuSep"><img src="#IMAGE_PREFIX#themes/theme_13/1px_trans.gif"  width="1" height="1" alt="" class="dhtmlMenuSep" /></li>'
,p_sub_list_item_noncurrent=>'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)">#TEXT#</a></li>'
,p_item_templ_curr_w_child=>'<div class="list-button-c-sub"><button onclick="#LINK#" class="dhtmlMenu" type="button"><span>#TEXT#</span></button></div>'
,p_item_templ_noncurr_w_child=>'<div class="list-button-nc-sub"><button onclick="app_AppMenuMultiOpenBottom2(this,''#LIST_ITEM_ID#'',false)" class="dhtmlMenu" type="button"><span>#TEXT#</span></button></div>'
,p_sub_templ_curr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" /></a></li>'
,p_sub_templ_noncurr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" / ></a></li>'
,p_reference_id=>461050507240493294
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_media_list
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(692727073209839891)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-MediaList-item is-active">',
'    <div class="a-MediaList-link">',
'        <div class="a-MediaList-iconWrap">',
'            <span class="a-MediaList-icon" aria-hidden="true"><span class="a-Icon #IMAGE#" #IMAGE_ATTR#></span></span>',
'        </div>',
'        <div class="a-MediaList-body">',
'            <h3 class="a-MediaList-title" aria-describedby="description_#LIST_ITEM_ID#"><a href="#LINK#" aria-current="page" #A03#>#TEXT#</a></h3>',
'            <p id="description_#LIST_ITEM_ID#" class="a-MediaList-desc">#A01#</p>',
'        </div>',
'        <div class="a-MediaList-badgeWrap">',
'            <span class="a-MediaList-badge">#A02#</span>',
'        </div>',
'    </div>',
'</li>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-MediaList-item">',
'    <div class="a-MediaList-link">',
'        <div class="a-MediaList-iconWrap">',
'            <span class="a-MediaList-icon" aria-hidden="true"><span class="a-Icon #IMAGE#" #IMAGE_ATTR#></span></span>',
'        </div>',
'        <div class="a-MediaList-body">',
'            <h3 class="a-MediaList-title" aria-describedby="description_#LIST_ITEM_ID#"><a href="#LINK#" #A03#>#TEXT#</a></h3>',
'            <p id="description_#LIST_ITEM_ID#" class="a-MediaList-desc">#A01#</p>',
'        </div>',
'        <div class="a-MediaList-badgeWrap">',
'            <span class="a-MediaList-badge">#A02#</span>',
'        </div>',
'    </div>',
'</li>'))
,p_list_template_name=>'[x] APEX 5.0 - Media List'
,p_internal_name=>'APEX_5.0_MEDIA_LIST'
,p_theme_id=>3
,p_theme_class_id=>9
,p_default_template_options=>'a-MediaList--noBadge'
,p_list_template_before_rows=>'<ul class="a-MediaList #COMPONENT_CSS_CLASSES#">'
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>692720897220784060
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_wizard_progress
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(703372217110859571)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-WizardSteps-step is-active" aria-current="step">',
'  <div class="a-WizardSteps-wrap">',
'    <span class="a-WizardSteps-marker" aria-hidden="true"><span class="a-Icon icon-wizard-step-complete"></span></span>',
'    <span class="a-WizardSteps-label">#TEXT#</span>',
'  </div>',
'</li>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-WizardSteps-step is-inactive">',
'  <div class="a-WizardSteps-wrap">',
'    <span class="a-WizardSteps-marker" aria-hidden="true"><span class="a-Icon icon-wizard-step-complete"></span></span>',
'    <span class="a-WizardSteps-label">#TEXT#</span>',
'  </div>',
'</li>',
''))
,p_list_template_name=>'APEX 5.0 - Wizard Progress'
,p_internal_name=>'APEX_5.0_WIZARD_PROGRESS'
,p_theme_id=>3
,p_theme_class_id=>17
,p_default_template_options=>'a-WizardSteps--slim'
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul aria-label="#CURRENT_PROGRESS#" class="a-WizardSteps #COMPONENT_CSS_CLASSES#">',
''))
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>687902065557685310
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_links_list_002
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(704358525679957526)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-LinksList-item is-current #A03#" aria-current="page">',
'  <a href="#LINK#" class="a-LinksList-link" #A02#>',
'    <span class="a-LinksList-icon" aria-hidden="true"><span class="t-Icon #IMAGE#"></span></span>',
'    <span class="a-LinksList-label">#TEXT#</span>',
'    <span class="u-vh">&nbsp;</span>',
'    <span class="a-LinksList-badge">#A01#</span>',
'    <span class="a-LinksList-arrow" aria-hidden="true"></span>',
'  </a>',
'</li>',
''))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-LinksList-item #A03#">',
'  <a href="#LINK#" class="a-LinksList-link" #A02#>',
'    <span class="a-LinksList-icon" aria-hidden="true"><span class="t-Icon #IMAGE#"></span></span>',
'    <span class="a-LinksList-label">#TEXT#</span>',
'    <span class="u-vh">&nbsp;</span>',
'    <span class="a-LinksList-badge">#A01#</span>',
'    <span class="a-LinksList-arrow" aria-hidden="true"></span>',
'  </a>',
'</li>',
''))
,p_list_template_name=>'[x] APEX 5.0 - Links List'
,p_internal_name=>'APEX_5.0_LINKS_LIST'
,p_theme_id=>3
,p_theme_class_id=>1
,p_default_template_options=>'a-LinksList--showArrow'
,p_list_template_before_rows=>'<ul class="a-LinksList #COMPONENT_CSS_CLASSES#" id="#LIST_ID#">'
,p_list_template_after_rows=>'</ul>'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-LinksList-item is-current #A03#" aria-current="page">',
'  <a href="#LINK#" class="a-LinksList-link" #A02#>',
'    <span class="a-LinksList-icon" aria-hidden="true"><span class="t-Icon #IMAGE#"></span></span>',
'    <span class="a-LinksList-label">#TEXT#</span>',
'    <span class="a-LinksList-badge">#A01#</span>',
'    <span class="a-LinksList-arrow" aria-hidden="true"></span>',
'  </a>',
'</li>'))
,p_sub_list_item_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-LinksList-item #A03#">',
'  <a href="#LINK#" class="a-LinksList-link" #A02#>',
'    <span class="a-LinksList-icon" aria-hidden="true"><span class="t-Icon #IMAGE#"></span></span>',
'    <span class="a-LinksList-label">#TEXT#</span>',
'    <span class="a-LinksList-badge">#A01#</span>',
'    <span class="a-LinksList-arrow" aria-hidden="true"></span>',
'  </a>',
'</li>'))
,p_item_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-LinksList-item is-current is-expanded #A03#" aria-current="page">',
'  <a href="#LINK#" class="a-LinksList-link" #A02#>',
'    <span class="a-LinksList-icon" aria-hidden="true"><span class="t-Icon #IMAGE#"></span></span>',
'    <span class="a-LinksList-label">#TEXT#</span>',
'    <span class="u-vh">&nbsp;</span>',
'    <span class="a-LinksList-badge">#A01#</span>',
'    <span class="a-LinksList-arrow" aria-hidden="true"></span>',
'  </a>',
'  #SUB_LISTS#',
'</li>'))
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-LinksList-item #A03#">',
'  <a href="#LINK#" class="a-LinksList-link" #A02#>',
'    <span class="a-LinksList-icon" aria-hidden="true"><span class="t-Icon #IMAGE#"></span></span>',
'    <span class="a-LinksList-label">#TEXT#</span>',
'    <span class="u-vh">&nbsp;</span>',
'    <span class="a-LinksList-badge">#A01#</span>',
'    <span class="a-LinksList-arrow" aria-hidden="true"></span>',
'  </a>',
'  #SUB_LISTS#',
'</li>'))
,p_reference_id=>60219508156141083
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_sub_tabs_002
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(764029929273005392)
,p_list_template_current=>'<li class="a-Tabs-item is-active" aria-current="page"><a href="#LINK#" class="a-Tabs-link">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li class="a-Tabs-item"><a href="#LINK#" class="a-Tabs-link">#TEXT#</a></li>'
,p_list_template_name=>'APEX 5.0 - Sub Tabs'
,p_internal_name=>'APEX_5.0_SUB_TABS'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-TabsContainer a-TabsContainer--subTabs">',
'  <ul class="a-Tabs a-Tabs--subTabButtons">'))
,p_list_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'  </ul>',
'</div>'))
,p_reference_id=>168708522102193705
,p_list_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aSubTabs"><ul>',
'<li class="active"><a href="#LINK#" title="#TEXT_ESC_SC#"><span>#TEXT#</span></a></li>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_sql_workshop_buttons_list
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(1241653799958177324)
,p_list_template_current=>'<button type="button" onclick="apex.navigation.redirect(''#LINK#'')" class="a-Button">#TEXT#</button>'
,p_list_template_noncurrent=>'<button type="button" onclick="apex.navigation.redirect(''#LINK#'')" class="a-Button">#TEXT#</button>'
,p_list_template_name=>'APEX 5.0 - SQL Workshop Buttons List'
,p_internal_name=>'APEX_5.0_SQL_WORKSHOP_BUTTONS_LIST'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<div class="a-Button-list">'
,p_list_template_after_rows=>'</div>'
,p_reference_id=>1241650007443166178
,p_list_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aSubTabs"><ul>',
'<li class="active"><a href="#LINK#" title="#TEXT_ESC_SC#"><span>#TEXT#</span></a></li>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_23_1_object_browser_cards
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(1449172575682074)
,p_row_template_name=>'APEX 23.1 - Object Browser Cards'
,p_internal_name=>'APEX_23.1_OBJECT_BROWSER_CARDS'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="b-OB-Card">',
'  <div class="b-OB-Card-wrap">',
'    <span class="b-OB-Card-icon a-Icon #CARD_ICON#" aria-hidden="true"></span>',
'    <h3 class="b-OB-Card-title" aria-describedby="description_#CARD_ICON#"><a href="#CARD_LINK#" aria-haspopup="dialog">#CARD_TITLE#</a></h3>',
'    <p class="b-OB-Card-description" id="description_#CARD_ICON#">#CARD_TEXT#</p>',
'  </div>',
'</li>',
''))
,p_row_template_before_rows=>' <ul class="b-OB-Cards #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_STATIC_ID#_cards" data-region-id="#REGION_STATIC_ID#">'
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</ul>',
'<!-- #PAGINATION# -->'))
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>7
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/standard_new_ajax
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(2251716882439710)
,p_row_template_name=>'Standard (New Ajax)'
,p_internal_name=>'STANDARD_NEW_AJAX'
,p_row_template1=>'<td class="a-Report-cell" #ALIGNMENT# #ACCESSIBLE_HEADERS# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Report #COMPONENT_CSS_CLASSES#" id="report_#REGION_STATIC_ID#" #REPORT_ATTRIBUTES#>',
'  <div class="a-Report-wrap">',
'    <table class="a-Report-pagination" role="presentation">#TOP_PAGINATION#</table>',
'    <div class="a-Report-tableWrap">',
'    <table class="a-Report-report" aria-label="#REGION_TITLE#">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'      </tbody>',
'    </table>',
'    </div>',
'    <div class="a-Report-links">#EXTERNAL_LINK##CSV_LINK#</div>',
'    <table class="a-Report-pagination a-Report-pagination a-Report-pagination--bottom" role="presentation">#PAGINATION#</table>',
'  </div>',
'</div>'))
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_before_column_heading=>'<thead>'
,p_column_heading_template=>'<th class="a-Report-colHead" #ALIGNMENT# #ARIA_SORT# id="#COLUMN_HEADER_NAME#" #COLUMN_WIDTH#>#COLUMN_HEADER#</th>'
,p_after_column_heading=>'</thead><tbody>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="a-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>123725814882271159
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/dhtml_automatic_ppr_pagination_report_from_4999_3
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(7082409118250737)
,p_row_template_name=>'(DHTML) Automatic PPR Pagination Report From 4999 (3)'
,p_internal_name=>'DHTML_AUTOMATIC_PPR_PAGINATION_REPORT_FROM_4999_3'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="report#REGION_ID#"><htmldb:#REGION_ID#><table cellpadding="0" cellspacing="0" class="u-Report"  border="0" summary="#REGION_TITLE#" id="#REGION_ID#" htmldb:href="p=&APP_ID.:&APP_PAGE_ID.:&SESSION.:pg_R_#REGION_ID#:NO:">',
'<tbody>'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'<tfoot>#PAGINATION#</tfoot>',
'</table>',
'<span class="htmldbCSV">#CSV_LINK#</span>',
'',
'<script>',
'<!--',
'init_htmlPPRReport(''#REGION_ID#'');',
'',
'//-->',
'</script>',
'</htmldb:#REGION_ID#>',
'</div>'))
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#TEXT#',
''))
,p_next_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><span class="a-Icon icon-right-chevron"></span></a>'
,p_previous_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><span class="a-Icon icon-left-chevron"></span></a>'
,p_next_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_row_style_mouse_over=>'#CCCCCC'
,p_row_style_checked=>'#CCCCCC'
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>6574616710304003
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/dhtml_automatic_ppr_pagination_report_from_4999
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(11028007180514315)
,p_row_template_name=>'(DHTML) Automatic PPR Pagination Report from 4999'
,p_internal_name=>'DHTML_AUTOMATIC_PPR_PAGINATION_REPORT_FROM_4999'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="report#REGION_ID#"><htmldb:#REGION_ID#><table cellpadding="0" cellspacing="0" class="u-Report"  border="0" summary="#REGION_TITLE#" id="#REGION_ID#" htmldb:href="p=&APP_ID.:&APP_PAGE_ID.:&SESSION.:pg_R_#REGION_ID#:NO:">',
'<tbody>'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'<tfoot>#PAGINATION#</tfoot>',
'</table>',
'<span class="htmldbCSV">#CSV_LINK#</span>',
'',
'<script>',
'<!--',
'init_htmlPPRReport(''#REGION_ID#'');',
'',
'//-->',
'</script>',
'</htmldb:#REGION_ID#>',
'</div>'))
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#TEXT#',
''))
,p_next_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><span class="a-Icon icon-right-chevron"></span></a>'
,p_previous_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><span class="a-Icon icon-left-chevron"></span></a>'
,p_next_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_row_style_mouse_over=>'#CCCCCC'
,p_row_style_checked=>'#CCCCCC'
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>6574616710304003
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/dhtml_automatic_ppr_pagination_report_from_4999_2
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(22095907193828478)
,p_row_template_name=>'(DHTML) Automatic PPR Pagination Report From 4999 (2)'
,p_internal_name=>'DHTML_AUTOMATIC_PPR_PAGINATION_REPORT_FROM_4999_2'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="report#REGION_ID#"><htmldb:#REGION_ID#><table cellpadding="0" cellspacing="0" class="u-Report"  border="0" summary="#REGION_TITLE#" id="#REGION_ID#" htmldb:href="p=&APP_ID.:&APP_PAGE_ID.:&SESSION.:pg_R_#REGION_ID#:NO:">',
'<tbody>'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'<tfoot>#PAGINATION#</tfoot>',
'</table>',
'<span class="htmldbCSV">#CSV_LINK#</span>',
'',
'<script>',
'<!--',
'init_htmlPPRReport(''#REGION_ID#'');',
'',
'//-->',
'</script>',
'</htmldb:#REGION_ID#>',
'</div>'))
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#TEXT#',
''))
,p_next_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><span class="a-Icon icon-right-chevron"></span></a>'
,p_previous_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><span class="a-Icon icon-left-chevron"></span></a>'
,p_next_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_row_style_mouse_over=>'#CCCCCC'
,p_row_style_checked=>'#CCCCCC'
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>6574616710304003
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/database_browser_trigger_body
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(33210746522512634)
,p_row_template_name=>'Database Browser Trigger Body'
,p_internal_name=>'DATABASE_BROWSER_TRIGGER_BODY'
,p_row_template1=>'<pre>#TRIGGER_BODY#</pre>'
,p_row_template_before_rows=>'<table><tr><td>'
,p_row_template_after_rows=>'</td></tr></table>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'NOT_CONDITIONAL'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>354957901800346152
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/quick_pick_list_items
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(38811532466194226)
,p_row_template_name=>'quick_pick_list_items'
,p_internal_name=>'QUICK_PICK_LIST_ITEMS'
,p_row_template1=>'<li class="a-LinksList-item">#COLUMN_VALUE#</li>'
,p_row_template_before_rows=>'<ul class="a-LinksList a-LinksList--report #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES#>'
,p_row_template_after_rows=>'</ul>'
,p_row_template_before_first=>'OMIT'
,p_row_template_after_last=>'OMIT'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'OMIT'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'NOT_CONDITIONAL'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_template_options=>'a-LinksList--nowrap:a-LinksList--showArrow'
,p_reference_id=>17383712077884846
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_4_0_portlet_row_template
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(46912117501975223)
,p_row_template_name=>'APEX 4.0 - Portlet Row Template'
,p_internal_name=>'APEX_4.0_PORTLET_ROW_TEMPLATE'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AVPList-item">',
'  <span class="a-AVPList-label">#1#</span>',
'  <span class="a-AVPList-value">#2#</span>',
'</li>'))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul class="a-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_ID#_report">',
''))
,p_row_template_after_rows=>'</ul>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>46763700145123930
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/icon_report_from_4999
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(134307417931747174)
,p_row_template_name=>'Icon Report From 4999'
,p_internal_name=>'ICON_REPORT_FROM_4999'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table width="100" style="float:left;margin:10px;">',
'<tr><td align="center"><a href="#3#"><img src="#IMAGE_PREFIX##1#" title="#2#" alt="#2#" style="display:block;"/></a></td></tr>',
'<tr><td align="center"><a href="#3#" class="htmldbIconName">#4#</a></td></tr>',
'</table>',
'<br style="clear:both;" />'))
,p_row_template_condition1=>'mod (#ROWNUM#, 5) = 0'
,p_row_template2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table width="100" style="float:left;margin:10px;">',
'<tr><td align="center"><a href="#3#"><img src="#IMAGE_PREFIX##1#" title="#2#" alt="#2#" style="display:block;"/></a></td></tr>',
'<tr><td align="center"><a href="#3#" class="htmldbIconName">#4#</a></td></tr>',
'</table>'))
,p_row_template_before_rows=>'<div id="report#REGION_ID#"><htmldb:#REGION_ID#><table class="htmldbListIconHolder" border="0" cellpadding="0" cellpadding="0" summary="">#TOP_PAGINATION#<tr><td>'
,p_row_template_after_rows=>'</td></tr>#PAGINATION#</table></htmldb:#REGION_ID#></div>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_column_heading_template=>'OMIT'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_next_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_next_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>134516716361378454
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/vertical_no_background
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(161923301611160944)
,p_row_template_name=>'Vertical - No Background'
,p_internal_name=>'VERTICAL_NO_BACKGROUND'
,p_row_template1=>'<tr><th scope="row" align="right">#COLUMN_HEADER#</th><td>#COLUMN_VALUE#</td></tr>'
,p_row_template_before_rows=>'#CSV_LINK#<table class="htmldbVerticalRptPlain" summary="#REGION_TITLE#" cellpadding="0" cellspacing="0" border="0">'
,p_row_template_after_rows=>'</table>'
,p_row_template_before_first=>'OMIT'
,p_row_template_after_last=>'OMIT'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'NOT_CONDITIONAL'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_theme_id=>3
,p_theme_class_id=>0
,p_reference_id=>172647727246303349
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/no_background
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(165449703104678078)
,p_row_template_name=>'No Background'
,p_internal_name=>'NO_BACKGROUND'
,p_row_template1=>'<td#ALIGNMENT# id="td#ROWNUM#_#COLNUM#" headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" class="htmldbRptNoBackground" summary="#REGION_TITLE#">',
'<tbody>'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'</table>'))
,p_row_template_before_first=>'<tr id="row#ROWNUM#">'
,p_row_template_after_last=>'</tr>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>237868603542157245
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_4_0_portlet_column_template
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(171907206171165798)
,p_row_template_name=>'APEX 4.0 - Portlet Column Template'
,p_internal_name=>'APEX_4.0_PORTLET_COLUMN_TEMPLATE'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AVPList-item">',
'  <span class="a-AVPList-label">#COLUMN_HEADER#</span>',
'  <span class="a-AVPList-value">#COLUMN_VALUE#</span>',
'</li>'))
,p_row_template_before_rows=>'<ul class="a-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_ID#_report">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>0
,p_reference_id=>43020300221196425
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/automatic_ppr_no_background
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(172773906323382535)
,p_row_template_name=>'Automatic PPR - No Background'
,p_internal_name=>'AUTOMATIC_PPR_NO_BACKGROUND'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="report#REGION_ID#"><htmldb:#REGION_ID#><table cellpadding="0" cellspacing="0" class="htmldbRptNoBackHoriz"  border="0" summary="#REGION_TITLE#" id="#REGION_ID#" htmldb:href="p=&APP_ID.:&APP_PAGE_ID.:&SESSION.:pg_R_#REGION_ID#:NO:">',
'<tbody>'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'<tfoot>#PAGINATION#</tfoot>',
'</table>',
'<span class="htmldbCSV">#CSV_LINK#</span>',
'',
'<script>',
'<!--',
'init_htmlPPRReport(''#REGION_ID#'');',
'',
'//-->',
'</script>',
'</htmldb:#REGION_ID#>',
'</div>'))
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#TEXT#',
''))
,p_next_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_next_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_row_style_mouse_over=>'#CCCCCC'
,p_row_style_checked=>'#CCCCCC'
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>172923115706660192
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_badge_list
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(385896719135645040)
,p_row_template_name=>'APEX 5.0 - Badge List'
,p_internal_name=>'APEX_5.0_BADGE_LIST'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-BadgeList-item #A01#">',
'  <span class="a-BadgeList-label">#COLUMN_HEADER#</span>',
'  <span class="a-BadgeList-value">#COLUMN_VALUE#</span>',
'</li>',
''))
,p_row_template_before_rows=>'<ul class="a-BadgeList #COMPONENT_CSS_CLASSES#">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>0
,p_preset_template_options=>'a-BadgeList--fixed:a-BadgeList--large'
,p_reference_id=>488487951233692049
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_date_list
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(386075171368129866)
,p_row_template_name=>'APEX 5.0 - Date List'
,p_internal_name=>'APEX_5.0_DATE_LIST'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'  <li class="a-DateList-item">',
'    <div class="a-MediaBlock">',
'      <div class="a-MediaBlock-graphic">',
'        <span class="a-DateList-date">',
'          <span class="a-DateList-day">#DAY#</span>',
'          <span class="a-DateList-month">#MONTH#</span>',
'        </span>',
'      </div>',
'      <div class="a-MediaBlock-content">',
'        <span class="a-DateList-desc">#TEXT#</span>',
'        <span class="a-DateList-attribute">#CREATED_BY#</span>',
'        <span class="a-DateList-attribute">#CREATED_ON#</span>',
'      </div>',
'    </div>',
'  </li>'))
,p_row_template_before_rows=>'<ul class="a-DateList">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_4_0_standard_report
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(617728329737082310)
,p_row_template_name=>'APEX 4.0 - Standard Report'
,p_internal_name=>'APEX_4.0_STANDARD_REPORT'
,p_row_template1=>'<td class="a-Report-cell" #ALIGNMENT# #ACCESSIBLE_HEADERS# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Report #COMPONENT_CSS_CLASSES#" id="report_#REGION_STATIC_ID#" #REPORT_ATTRIBUTES#>',
'  <div class="a-Report-wrap">',
'    <table class="a-Report-pagination" role="presentation">#TOP_PAGINATION#</table>',
'    <div class="a-Report-tableWrap">',
'    <table class="a-Report-report" aria-label="#REGION_TITLE#">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'      </tbody>',
'    </table>',
'    </div>',
'    <div class="a-Report-links">#EXTERNAL_LINK##CSV_LINK#</div>',
'    <table class="a-Report-pagination a-Report-pagination a-Report-pagination--bottom" role="presentation">#PAGINATION#</table>',
'  </div>',
'</div>'))
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_before_column_heading=>'<thead>'
,p_column_heading_template=>'<th class="a-Report-colHead" #ALIGNMENT# #ARIA_SORT# id="#COLUMN_HEADER_NAME#" #COLUMN_WIDTH#>#COLUMN_HEADER#</th>'
,p_after_column_heading=>'</thead><tbody>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="a-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>123725814882271159
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_badge_list_named_column
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(717423775712828084)
,p_row_template_name=>'APEX 5.0 - Badge List (Named Column)'
,p_internal_name=>'APEX_5.0_BADGE_LIST_NAMED_COLUMN'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-BadgeList-item #A01#">',
'  <span class="a-BadgeList-label">#COLUMN_HEADER#</span>',
'  <span class="a-BadgeList-value">#COLUMN_VALUE#</span>',
'</li>',
''))
,p_row_template_before_rows=>'<ul class="a-BadgeList #COMPONENT_CSS_CLASSES#">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>0
,p_preset_template_options=>'a-BadgeList--fixed:a-BadgeList--large'
,p_reference_id=>488487951233692049
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_badge_list_row
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(717432943772828094)
,p_row_template_name=>'APEX 5.0 - Badge List (Row)'
,p_internal_name=>'APEX_5.0_BADGE_LIST_ROW'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-BadgeList-item">',
'  <span class="t-BadgeList-label">#1#</span>',
'  <span class="t-BadgeList-value">#2#</span>',
'</li>'))
,p_row_template_before_rows=>'<ul class="t-BadgeList #COMPONENT_CSS_CLASSES#">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>6
,p_reference_id=>689060248369886348
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_links_list
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(717433602632828095)
,p_row_template_name=>'APEX 5.0 - Links List'
,p_internal_name=>'APEX_5.0_LINKS_LIST'
,p_row_template1=>'<li class="a-LinksList-item">#COLUMN_VALUE#</li>'
,p_row_template_before_rows=>'<ul class="a-LinksList a-LinksList--report #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES#>'
,p_row_template_after_rows=>'</ul>'
,p_row_template_before_first=>'OMIT'
,p_row_template_after_last=>'OMIT'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'OMIT'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'NOT_CONDITIONAL'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_template_options=>'a-LinksList--nowrap:a-LinksList--showArrow'
,p_reference_id=>17383712077884846
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_standard_report
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(717436155076828097)
,p_row_template_name=>'APEX 5.0 - Standard Report'
,p_internal_name=>'APEX_5.0_STANDARD_REPORT'
,p_row_template1=>'<td class="a-Report-cell" #ALIGNMENT# #ACCESSIBLE_HEADERS# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Report #COMPONENT_CSS_CLASSES#" id="report_#REGION_STATIC_ID#" #REPORT_ATTRIBUTES#>',
'  <div class="a-Report-wrap">',
'    <table class="a-Report-pagination" role="presentation">#TOP_PAGINATION#</table>',
'    <div class="a-Report-tableWrap">',
'    <table class="a-Report-report" aria-label="#REGION_TITLE#">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'      </tbody>',
'    </table>',
'    </div>',
'    <div class="a-Report-links">#EXTERNAL_LINK##CSV_LINK#</div>',
'    <table class="a-Report-pagination a-Report-pagination a-Report-pagination--bottom" role="presentation">#PAGINATION#</table>',
'  </div>',
'</div>'))
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_before_column_heading=>'<thead>'
,p_column_heading_template=>'<th class="a-Report-colHead" #ALIGNMENT# #ARIA_SORT# id="#COLUMN_HEADER_NAME#" #COLUMN_WIDTH#>#COLUMN_HEADER#</th>'
,p_after_column_heading=>'</thead><tbody>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="a-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>123725814882271159
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_vertical_report
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(1127586271702515372)
,p_row_template_name=>'APEX 5.0 - Vertical Report'
,p_internal_name=>'APEX_5.0_VERTICAL_REPORT'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<tr>',
'  <td class="a-Report-cell a-Report-cell--header" scope="row">#COLUMN_HEADER#</td>',
'  <td class="a-Report-cell">#COLUMN_VALUE#</td>',
'</tr>'))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Report a-Report--vertical a-Report--staticRowColors #COMPONENT_CSS_CLASSES#" id="report_#REGION_STATIC_ID#" #REPORT_ATTRIBUTES#>',
'  <div class="a-Report-wrap">',
'    <table class="a-Report-pagination">#TOP_PAGINATION#</table>',
'    <div class="a-Report-tableWrap">',
'    <table class="a-Report-report" summary="#REGION_TITLE#">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    </table>',
'    </div>',
'    <div class="a-Report-links">#EXTERNAL_LINK##CSV_LINK#</div>',
'    <table class="a-Report-pagination a-Report-pagination a-Report-pagination--bottom">#PAGINATION#</table>',
'  </div>',
'</div>'))
,p_row_template_before_first=>' '
,p_row_template_after_last=>' '
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="a-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>1126924627125205941
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_portlet_column_template
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(1340556612002171029)
,p_row_template_name=>'APEX 5.0 - Portlet Column Template'
,p_internal_name=>'APEX_5.0_PORTLET_COLUMN_TEMPLATE'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AVPList-item">',
'  <span class="a-AVPList-label">#COLUMN_HEADER#</span>',
'  <span class="a-AVPList-value">#COLUMN_VALUE#</span>',
'</li>'))
,p_row_template_before_rows=>'<ul class="a-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_ID#_report">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>0
,p_reference_id=>43020300221196425
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_portlet_row_template
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(1340557295961171098)
,p_row_template_name=>'APEX 5.0 - Portlet Row Template'
,p_internal_name=>'APEX_5.0_PORTLET_ROW_TEMPLATE'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AVPList-item">',
'  <span class="a-AVPList-label">#1#</span>',
'  <span class="a-AVPList-value">#2#</span>',
'</li>'))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul class="a-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_ID#_report">',
''))
,p_row_template_after_rows=>'</ul>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>46763700145123930
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/formfield_optional
begin
wwv_flow_imp_shared.create_field_template(
 p_id=>wwv_flow_imp.id(3301520602864636)
,p_template_name=>'FormField_Optional'
,p_internal_name=>'FORMFIELD_OPTIONAL'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="aLabel aOptional"><a href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_on_error_after_label=>'<small class="aError">#ERROR_MESSAGE#</small>'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>17388415351892041
,p_translate_this_template=>'N'
,p_template_comment=>'<label for="#CURRENT_ITEM_NAME#"><a class="htmldbLabelOptional" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/formfield_required
begin
wwv_flow_imp_shared.create_field_template(
 p_id=>wwv_flow_imp.id(3301625476864638)
,p_template_name=>'FormField_Required'
,p_internal_name=>'FORMFIELD_REQUIRED'
,p_template_body1=>'<em>*</em><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="aLabel aRequired"><a href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
,p_template_body2=>' <span class="hideMeButHearMe">(#VALUE_REQUIRED#)</span></a></label>'
,p_on_error_after_label=>'<small class="aError">#ERROR_MESSAGE#</small>'
,p_theme_id=>3
,p_theme_class_id=>2
,p_reference_id=>17388508175892042
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/label_tag_only
begin
wwv_flow_imp_shared.create_field_template(
 p_id=>wwv_flow_imp.id(4904018598976684)
,p_template_name=>'LABEL Tag Only'
,p_internal_name=>'LABEL_TAG_ONLY'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999" class="hideMeButHearMe">'
,p_template_body2=>'</label>'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#'
,p_theme_id=>3
,p_theme_class_id=>13
,p_reference_id=>4903009179971452
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/hidden_label_read_by_screen_reader
begin
wwv_flow_imp_shared.create_field_template(
 p_id=>wwv_flow_imp.id(6693608793786901)
,p_template_name=>'Hidden label, read by screen reader'
,p_internal_name=>'HIDDEN_LABEL,_READ_BY_SCREEN_READER'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999" class="hideMeButHearMe">'
,p_template_body2=>'</label>'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#'
,p_theme_id=>3
,p_theme_class_id=>13
,p_reference_id=>4903009179971452
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/formfield_optional_w_o_popup
begin
wwv_flow_imp_shared.create_field_template(
 p_id=>wwv_flow_imp.id(12399821819620115)
,p_template_name=>'FormField_Optional w/o popup'
,p_internal_name=>'FORMFIELD_OPTIONAL_W/O_POPUP'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#"><span class="htmldbLabelOptional">'
,p_template_body2=>'</span></label>'
,p_theme_id=>3
,p_theme_class_id=>0
,p_reference_id=>238114715839717766
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/htmldb_greenarealabel_c_htmldbgalabel
begin
wwv_flow_imp_shared.create_field_template(
 p_id=>wwv_flow_imp.id(187652405321922937)
,p_template_name=>'htmldb_GreenAreaLabel (c:htmldbGALabel)'
,p_internal_name=>'HTMLDB_GREENAREALABEL_C:HTMLDBGALABEL'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#"><a class="apex-ga-label" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_theme_id=>3
,p_theme_class_id=>0
,p_reference_id=>57728329098847875
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_4_0_top_bar_label
begin
wwv_flow_imp_shared.create_field_template(
 p_id=>wwv_flow_imp.id(197619827652543551)
,p_template_name=>'APEX 4.0 - Top Bar Label'
,p_internal_name=>'APEX_4.0_TOP_BAR_LABEL'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#"><a class="apex-ga-label" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_theme_id=>3
,p_theme_class_id=>0
,p_reference_id=>57728329098847875
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_optional_label
begin
wwv_flow_imp_shared.create_field_template(
 p_id=>wwv_flow_imp.id(488671029226029669)
,p_template_name=>'APEX 5.0 - Optional Label'
,p_internal_name=>'APEX_5.0_OPTIONAL_LABEL'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#HELP_TEMPLATE##ERROR_TEMPLATE##INLINE_HELP_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_inline_help_text=>'<div class="a-Form-inlineHelp">#CURRENT_ITEM_INLINE_HELP_TEXT#</div>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>487444299516703815
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_required_label
begin
wwv_flow_imp_shared.create_field_template(
 p_id=>wwv_flow_imp.id(488671190365029680)
,p_template_name=>'APEX 5.0 - Required Label'
,p_internal_name=>'APEX_5.0_REQUIRED_LABEL'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'  <span class="a-Form-required"><span class="a-Icon icon-asterisk"></span></span><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>487443659585685414
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_optional_label_above
begin
wwv_flow_imp_shared.create_field_template(
 p_id=>wwv_flow_imp.id(492677255463052067)
,p_template_name=>'APEX 5.0 - Optional Label (Above)'
,p_internal_name=>'APEX_5.0_OPTIONAL_LABEL_ABOVE'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>#HELP_TEMPLATE#',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer a-Form-fieldContainer--stacked #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_on_error_after_label=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>492676964457041934
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_required_label_above
begin
wwv_flow_imp_shared.create_field_template(
 p_id=>wwv_flow_imp.id(492677350674053149)
,p_template_name=>'APEX 5.0 - Required Label (Above)'
,p_internal_name=>'APEX_5.0_REQUIRED_LABEL_ABOVE'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'  <span class="a-Form-required"><span class="a-Icon icon-asterisk"></span></span><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
' </label>#HELP_TEMPLATE#',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer a-Form-fieldContainer--stacked #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>492677038682043223
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_dynamic_attribute
begin
wwv_flow_imp_shared.create_field_template(
 p_id=>wwv_flow_imp.id(717397080423801376)
,p_template_name=>'APEX 5.0 - Dynamic Attribute'
,p_internal_name=>'APEX_5.0_DYNAMIC_ATTRIBUTE'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'  <span class="a-Form-required"><span class="a-Icon icon-asterisk"></span></span><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <span class="u-VisuallyHidden">(#VALUE_REQUIRED#)</span></label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-dynamicItemHelp" data-itemname="#CURRENT_ITEM_NAME#" data-appid="&FB_FLOW_ID." title="" aria-label="" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidden="true"></span>'
||'</button>#ERROR_TEMPLATE#</div>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>692681574974429799
,p_translate_this_template=>'N'
,p_template_comment=>'<label for="#CURRENT_ITEM_NAME#"><a class="htmldbLabelOptional" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_hidden_label
begin
wwv_flow_imp_shared.create_field_template(
 p_id=>wwv_flow_imp.id(717397144393801382)
,p_template_name=>'APEX 5.0 - Hidden Label'
,p_internal_name=>'APEX_5.0_HIDDEN_LABEL'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer a-Form-labelContainer--visuallyhidden">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label visuallyhidden">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>687907221148719616
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/breadcrumbs
begin
wwv_flow_imp_shared.create_menu_template(
 p_id=>wwv_flow_imp.id(6698104029693013)
,p_name=>'breadcrumbs'
,p_internal_name=>'BREADCRUMBS'
,p_current_page_option=>'<span class="htmldbBreadcrumb">#NAME#</span>'
,p_non_current_page_option=>'<a href="#LINK#" class="htmldbBreadcrumb" title="#NAME#">#NAME#</a>'
,p_between_levels=>'<span class="htmldbBreadcrumbSep"><img alt="" src="#IMAGE_PREFIX#apex/apex_top_sep.gif"></span>'
,p_max_levels=>12
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>60115300853820165
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/apex_5_0_breadcrumbs
begin
wwv_flow_imp_shared.create_menu_template(
 p_id=>wwv_flow_imp.id(387975456606606350)
,p_name=>'APEX 5.0 - Breadcrumbs'
,p_internal_name=>'APEX_5.0_BREADCRUMBS'
,p_before_first=>'<ul class="a-Breadcrumb">'
,p_current_page_option=>'<li class="a-Breadcrumb-item a-Breadcrumb-item is-active" aria-current="page"><span class="a-Breadcrumb-label">#NAME#</span></li>'
,p_non_current_page_option=>'<li class="a-Breadcrumb-item"><a href="#LINK#" class="a-Breadcrumb-label">#NAME#</a></li>'
,p_after_last=>'</ul>'
,p_max_levels=>8
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>689285808648404711
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/popuplov
begin
wwv_flow_imp_shared.create_popup_lov_template(
 p_id=>wwv_flow_imp.id(12797101143975616)
,p_page_name=>'winlov'
,p_page_title=>'Search Dialog'
,p_page_html_head=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html lang="&BROWSER_LANGUAGE.">',
'<head>',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#THEME_CSS#',
'#APEX_JAVASCRIPT#',
'<meta name="viewport" content="width=device-width,initial-scale=1.0" />',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon">',
'<link rel="stylesheet" href="#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css?v=#APEX_VERSION#" type="text/css"/>',
'<link rel="stylesheet" href="#IMAGE_PREFIX#apex_ui/css/Theme-Standard#MIN#.css?v=#APEX_VERSION#" type="text/css"/>',
'</head>'))
,p_page_body_attr=>'onload="first_field()" class="a-Page a-Page--popupLOV"'
,p_before_field_text=>'<div class="a-PopupLOV-actions a-Form--large">'
,p_filter_width=>'15'
,p_filter_max_width=>'100'
,p_filter_text_attr=>'class="a-Form-field a-Form-searchField"'
,p_find_button_text=>'Search'
,p_find_button_attr=>'class="a-Button a-Button--hot a-Button--padLeft"'
,p_close_button_text=>'Close'
,p_close_button_attr=>'class="a-Button u-pullRight"'
,p_next_button_text=>'Next &gt;'
,p_next_button_attr=>'class="a-Button a-PopupLOV-button"'
,p_prev_button_text=>'&lt; Previous'
,p_prev_button_attr=>'class="a-Button a-PopupLOV-button"'
,p_after_field_text=>'</div>'
,p_scrollbars=>'1'
,p_resizable=>'1'
,p_width=>'380'
,p_height=>'480'
,p_result_row_x_of_y=>'<div class="a-PopupLOV-pagination">Row(s) #FIRST_ROW# - #LAST_ROW#</div>'
,p_result_rows_per_pg=>200
,p_before_result_set=>'<div class="a-PopupLOV-links">'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>17343114994581872
,p_translate_this_template=>'N'
,p_after_result_set=>'</div>'
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/basic_calendar
begin
wwv_flow_imp_shared.create_calendar_template(
 p_id=>wwv_flow_imp.id(11334530416692434)
,p_cal_template_name=>'Basic Calendar'
,p_internal_name=>'BASIC_CALENDAR'
,p_day_of_week_format=>'<th scope="col">#IDAY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation">',
' <tr>',
'   <td align="center" style="font-weight:bold;">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="1" cellpadding="1" cellspacing="1" summary="0">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>',
''))
,p_day_title_format=>'<div>#DD#</div><br />'
,p_day_open_format=>'<td valign="top">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" bgcolor="#d3d3d3">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div>#DD#</div>'
,p_weekend_open_format=>'<td valign="top">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div>#DD#</div>'
,p_nonday_open_format=>'<td valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/themes
begin
wwv_flow_imp_shared.create_theme(
 p_id=>wwv_flow_imp.id(75126415316030828)
,p_theme_id=>3
,p_theme_name=>'APEX 5.0'
,p_theme_internal_name=>'APEX_5.0'
,p_navigation_type=>'T'
,p_nav_bar_type=>'NAVBAR'
,p_is_locked=>false
,p_current_theme_style_id=>wwv_flow_imp.id(72332249557526712)
,p_default_page_template=>wwv_flow_imp.id(385762900697898960)
,p_default_dialog_template=>wwv_flow_imp.id(690784265136803192)
,p_error_template=>wwv_flow_imp.id(703368619593851824)
,p_printer_friendly_template=>wwv_flow_imp.id(385762900697898960)
,p_default_button_template=>wwv_flow_imp.id(385765234519963355)
,p_default_region_template=>wwv_flow_imp.id(380771699411878611)
,p_default_report_template=>wwv_flow_imp.id(717436155076828097)
,p_default_label_template=>wwv_flow_imp.id(488671029226029669)
,p_default_menu_template=>wwv_flow_imp.id(6698104029693013)
,p_default_calendar_template=>wwv_flow_imp.id(11334530416692434)
,p_default_list_template=>wwv_flow_imp.id(20507805987268923)
,p_default_nav_list_position=>'TOP'
,p_file_prefix => nvl(wwv_flow_application_install.get_static_theme_file_prefix(3),'')
,p_css_file_urls=>'#IMAGE_PREFIX#libraries/oracle-fonts/oraclesans-apex#MIN#.css?v=#APEX_VERSION#'
);
end;
/
prompt --application/shared_components/user_interface/theme_style
begin
wwv_flow_imp_shared.create_theme_style(
 p_id=>wwv_flow_imp.id(72332249557526712)
,p_theme_id=>3
,p_name=>'DARK'
,p_css_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css',
'#IMAGE_PREFIX#apex_ui/css/Theme-Dark#MIN#.css'))
,p_is_public=>false
,p_is_accessible=>false
,p_theme_roller_read_only=>false
);
wwv_flow_imp_shared.create_theme_style(
 p_id=>wwv_flow_imp.id(204023927913767476)
,p_theme_id=>3
,p_name=>'STANDARD'
,p_css_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css',
'#IMAGE_PREFIX#apex_ui/css/Theme-Standard#MIN#.css'))
,p_is_public=>false
,p_is_accessible=>false
,p_theme_roller_read_only=>false
);
wwv_flow_imp_shared.create_theme_style(
 p_id=>wwv_flow_imp.id(556399735490108657)
,p_theme_id=>3
,p_name=>'DARK_AUTO'
,p_css_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css',
'#IMAGE_PREFIX#apex_ui/css/Theme-Dark#MIN#.css'))
,p_is_public=>false
,p_is_accessible=>false
,p_theme_roller_read_only=>false
);
wwv_flow_imp_shared.create_theme_style(
 p_id=>wwv_flow_imp.id(556400064664109422)
,p_theme_id=>3
,p_name=>'STANDARD_AUTO'
,p_css_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css',
'#IMAGE_PREFIX#apex_ui/css/Theme-Standard#MIN#.css'))
,p_is_public=>false
,p_is_accessible=>false
,p_theme_roller_read_only=>false
);
end;
/
prompt --application/shared_components/user_interface/theme_files
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_opt_groups
begin
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(2338950325000391)
,p_theme_id=>3
,p_name=>'HEADING_LEVEL'
,p_display_name=>'Heading Level'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(689635167517993971)
,p_theme_id=>3
,p_name=>'REGION_PADDING'
,p_display_name=>'Region Padding'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Padding'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(689636107671993973)
,p_theme_id=>3
,p_name=>'REGION_POSITION'
,p_display_name=>'Region Position'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Position'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(689636807321993973)
,p_theme_id=>3
,p_name=>'REGION_STYLE'
,p_display_name=>'Region Style'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Style'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(689638757932993974)
,p_theme_id=>3
,p_name=>'REGION_OVERFLOW'
,p_display_name=>'Region Overflow'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Behavior'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(692727409810839893)
,p_theme_id=>3
,p_name=>'LAYOUT'
,p_display_name=>'Layout'
,p_display_sequence=>1
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(696624360683145458)
,p_theme_id=>3
,p_name=>'REGION_TITLE'
,p_display_name=>'Region Title'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(697239665711708855)
,p_theme_id=>3
,p_name=>'DISPLAY_ICONS'
,p_display_name=>'Display Icons'
,p_display_sequence=>1
,p_template_types=>'LIST'
,p_null_text=>'Default - No Icons'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(698688432545187815)
,p_theme_id=>3
,p_name=>'ALTERNATING_TABLE_ROWS'
,p_display_name=>'Alternating Table Rows'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Enable'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(698689189405187817)
,p_theme_id=>3
,p_name=>'ROW_HIGHLIGHTING'
,p_display_name=>'Row Highlighting'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Disable'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(698689890777187817)
,p_theme_id=>3
,p_name=>'REPORT_BORDER'
,p_display_name=>'Report Border'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Default Border'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(698691450870187818)
,p_theme_id=>3
,p_name=>'REPORT_WIDTH'
,p_display_name=>'Report Width'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(717406084452820762)
,p_theme_id=>3
,p_name=>'DISPLAY'
,p_display_name=>'Display'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(717424165974828087)
,p_theme_id=>3
,p_name=>'BADGE_LAYOUT'
,p_display_name=>'Badge Layout'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(717426618396828089)
,p_theme_id=>3
,p_name=>'BADGE_SIZE'
,p_display_name=>'Badge Size'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(746376625117324389)
,p_theme_id=>3
,p_name=>'ALERT_TYPE'
,p_display_name=>'Alert Type'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(746420691677405750)
,p_theme_id=>3
,p_name=>'HEIGHT'
,p_display_name=>'Height'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Behavior'
,p_is_advanced=>'Y'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(746421932096405751)
,p_theme_id=>3
,p_name=>'FORM_LABEL_ALIGNMENT'
,p_display_name=>'Form Label Alignment'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_help_text=>'Set Form Alignment for Grid Based forms'
,p_null_text=>'Right'
,p_is_advanced=>'Y'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(746422298476405751)
,p_theme_id=>3
,p_name=>'FORM_LABEL_WIDTH'
,p_display_name=>'Form Label Width'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(746422550773405751)
,p_theme_id=>3
,p_name=>'BUTTON_SET'
,p_display_name=>'Button Set'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Not Part of Button Set'
,p_is_advanced=>'Y'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(746423628537405752)
,p_theme_id=>3
,p_name=>'LABEL_WIDTH'
,p_display_name=>'Label Width'
,p_display_sequence=>1
,p_template_types=>'FIELD'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(746423916240405752)
,p_theme_id=>3
,p_name=>'FORM_LABEL_POSITION'
,p_display_name=>'Form Label Position'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Position'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(746424218274405754)
,p_theme_id=>3
,p_name=>'BUTTON_SIZE'
,p_display_name=>'Button Size'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Button Size'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(746424531468405755)
,p_theme_id=>3
,p_name=>'SPACING_LEFT'
,p_display_name=>'Spacing left'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Left Spacing'
,p_is_advanced=>'Y'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(746424813431405755)
,p_theme_id=>3
,p_name=>'SPACING_RIGHT'
,p_display_name=>'Spacing Right'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Right Spacing'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(746425349736405755)
,p_theme_id=>3
,p_name=>'ICON_POSITION'
,p_display_name=>'Icon Position'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Icon on Right'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(746425674061405755)
,p_theme_id=>3
,p_name=>'BUTTON_TYPE'
,p_display_name=>'Button Type'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(1141459524801402371)
,p_theme_id=>3
,p_name=>'DIALOG_SIZE'
,p_display_name=>'Dialog Size'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_help_text=>'Predefined dialog sizes'
,p_null_text=>'Default Size'
,p_is_advanced=>'N'
);
end;
/
prompt --application/shared_components/user_interface/template_options
begin
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1541502566426805)
,p_theme_id=>3
,p_name=>'HIDDEN'
,p_display_name=>'Hidden to Assistive Tech'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(690714020036152159)
,p_css_classes=>'a-Region--hideHeader'
,p_group_id=>wwv_flow_imp.id(696624360683145458)
,p_template_types=>'REGION'
,p_help_text=>'By default, region title is hidden but accessible, use this option to remove the header from accessible interface'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(2339270100009517)
,p_theme_id=>3
,p_name=>'HEADING_LEVEL_H1'
,p_display_name=>'H1'
,p_display_sequence=>10
,p_css_classes=>'js-headingLevel-1'
,p_group_id=>wwv_flow_imp.id(2338950325000391)
,p_template_types=>'REGION'
,p_help_text=>'H1'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(2339506990009517)
,p_theme_id=>3
,p_name=>'HEADING_LEVEL_H2'
,p_display_name=>'H2'
,p_display_sequence=>20
,p_css_classes=>'js-headingLevel-2'
,p_group_id=>wwv_flow_imp.id(2338950325000391)
,p_template_types=>'REGION'
,p_help_text=>'H2'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(2339990813009517)
,p_theme_id=>3
,p_name=>'HEADING_LEVEL_H3'
,p_display_name=>'H3'
,p_display_sequence=>30
,p_css_classes=>'js-headingLevel-3'
,p_group_id=>wwv_flow_imp.id(2338950325000391)
,p_template_types=>'REGION'
,p_help_text=>'H3'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(2340350615009518)
,p_theme_id=>3
,p_name=>'HEADING_LEVEL_H4'
,p_display_name=>'H4'
,p_display_sequence=>40
,p_css_classes=>'js-headingLevel-4'
,p_group_id=>wwv_flow_imp.id(2338950325000391)
,p_template_types=>'REGION'
,p_help_text=>'H4'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(2340709351009518)
,p_theme_id=>3
,p_name=>'HEADING_LEVEL_H5'
,p_display_name=>'H5'
,p_display_sequence=>50
,p_css_classes=>'js-headingLevel-5'
,p_group_id=>wwv_flow_imp.id(2338950325000391)
,p_template_types=>'REGION'
,p_help_text=>'H5'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(2341130570009518)
,p_theme_id=>3
,p_name=>'HEADING_LEVEL_H6'
,p_display_name=>'H6'
,p_display_sequence=>60
,p_css_classes=>'js-headingLevel-6'
,p_group_id=>wwv_flow_imp.id(2338950325000391)
,p_template_types=>'REGION'
,p_help_text=>'H6'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755319348318018349)
,p_theme_id=>3
,p_name=>'USE_COLORED_BACKGROUND'
,p_display_name=>'Use Colored Background'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(746376253838324384)
,p_css_classes=>'a-Alert--colorBG'
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755319458208018350)
,p_theme_id=>3
,p_name=>'USE_DEFAULT_ICONS'
,p_display_name=>'Use Default Icons'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(746376253838324384)
,p_css_classes=>'a-Alert--defaultIcons'
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755319634177018356)
,p_theme_id=>3
,p_name=>'WARNING'
,p_display_name=>'Warning'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(746376253838324384)
,p_css_classes=>'a-Alert--warning'
,p_group_id=>wwv_flow_imp.id(746376625117324389)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755319862500018356)
,p_theme_id=>3
,p_name=>'ERROR'
,p_display_name=>'Error'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(746376253838324384)
,p_css_classes=>'a-Alert--danger'
,p_group_id=>wwv_flow_imp.id(746376625117324389)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755320072547018357)
,p_theme_id=>3
,p_name=>'INFORMATIONAL'
,p_display_name=>'Informational'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(746376253838324384)
,p_css_classes=>'a-Alert--info'
,p_group_id=>wwv_flow_imp.id(746376625117324389)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755320288486018357)
,p_theme_id=>3
,p_name=>'HORIZONTAL'
,p_display_name=>'Horizontal'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(746376253838324384)
,p_css_classes=>'a-Alert--horizontal'
,p_group_id=>wwv_flow_imp.id(717406084452820762)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755320416910018357)
,p_theme_id=>3
,p_name=>'WIZARD'
,p_display_name=>'Wizard'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(746376253838324384)
,p_css_classes=>'a-Alert--wizard'
,p_group_id=>wwv_flow_imp.id(717406084452820762)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755320549428018357)
,p_theme_id=>3
,p_name=>'REMOVE_ICON'
,p_display_name=>'Remove Icons'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(746376253838324384)
,p_css_classes=>'a-Alert--noIcon'
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755320725444018357)
,p_theme_id=>3
,p_name=>'SUCCESS'
,p_display_name=>'Success'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(746376253838324384)
,p_css_classes=>'a-Alert--success'
,p_group_id=>wwv_flow_imp.id(746376625117324389)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755321011331018360)
,p_theme_id=>3
,p_name=>'REGIONCONTAINSITEMSTEXT'
,p_display_name=>'Region Contains Items / Text'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(690697788869123307)
,p_css_classes=>'a-ButtonRegion--withItems'
,p_template_types=>'REGION'
,p_help_text=>'Check this option if this region contains items or text.'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755321262415018361)
,p_theme_id=>3
,p_name=>'REMOVEUIDECORATION'
,p_display_name=>'Remove UI Decoration'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(690697788869123307)
,p_css_classes=>'a-ButtonRegion--noUI'
,p_group_id=>wwv_flow_imp.id(689636807321993973)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755321430113018361)
,p_theme_id=>3
,p_name=>'REMOVEBORDERS'
,p_display_name=>'Remove Borders'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(690697788869123307)
,p_css_classes=>'a-ButtonRegion--noBorder'
,p_group_id=>wwv_flow_imp.id(689636807321993973)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755321650581018361)
,p_theme_id=>3
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(690697788869123307)
,p_css_classes=>'a-ButtonRegion--slimPadding'
,p_group_id=>wwv_flow_imp.id(689635167517993971)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755321826695018361)
,p_theme_id=>3
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(690697788869123307)
,p_css_classes=>'a-ButtonRegion--noPadding'
,p_group_id=>wwv_flow_imp.id(689635167517993971)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755321997452018361)
,p_theme_id=>3
,p_name=>'WIZARDDIALOG'
,p_display_name=>'Used for Wizard Dialog'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(690697788869123307)
,p_css_classes=>'a-ButtonRegion--wizard'
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755322169222018361)
,p_theme_id=>3
,p_name=>'VISIBLE'
,p_display_name=>'Visible'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(690697788869123307)
,p_css_classes=>'a-ButtonRegion--showTitle'
,p_group_id=>wwv_flow_imp.id(696624360683145458)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755322393600018361)
,p_theme_id=>3
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(690697788869123307)
,p_css_classes=>'a-ButtonRegion--accessibleTitle'
,p_group_id=>wwv_flow_imp.id(696624360683145458)
,p_template_types=>'REGION'
,p_help_text=>'Use this option to add a visually hidden heading which is accessible for screen readers, but otherwise not visible to users.'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755334063275018373)
,p_theme_id=>3
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(737759501522573640)
,p_css_classes=>'a-Region--accessibleHeader'
,p_group_id=>wwv_flow_imp.id(696624360683145458)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755334236254018373)
,p_theme_id=>3
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(737759501522573640)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_imp.id(689638757932993974)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755334469839018373)
,p_theme_id=>3
,p_name=>'DEFAULTPADDING'
,p_display_name=>'Default Padding'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_imp.id(737759501522573640)
,p_css_classes=>'a-Region--paddedBody'
,p_group_id=>wwv_flow_imp.id(689635167517993971)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755334699540018373)
,p_theme_id=>3
,p_name=>'HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(737759501522573640)
,p_css_classes=>'a-Region--hideHeader'
,p_group_id=>wwv_flow_imp.id(696624360683145458)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755334871937018373)
,p_theme_id=>3
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_imp.id(737759501522573640)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_imp.id(689635167517993971)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755335024214018375)
,p_theme_id=>3
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(737759501522573640)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_imp.id(689638757932993974)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755335244855018375)
,p_theme_id=>3
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_imp.id(737759501522573640)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_imp.id(689635167517993971)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755343697621018390)
,p_theme_id=>3
,p_name=>'FLOATITEMS'
,p_display_name=>'Float Items'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(385896719135645040)
,p_css_classes=>'a-BadgeList--float'
,p_group_id=>wwv_flow_imp.id(717424165974828087)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755343852274018390)
,p_theme_id=>3
,p_name=>'FIXED'
,p_display_name=>'Span Horizontally'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(385896719135645040)
,p_css_classes=>'a-BadgeList--fixed'
,p_group_id=>wwv_flow_imp.id(717424165974828087)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755344085264018390)
,p_theme_id=>3
,p_name=>'STACKEDVERTICALLY'
,p_display_name=>'Stacked Vertically'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(385896719135645040)
,p_css_classes=>'a-BadgeList--stacked'
,p_group_id=>wwv_flow_imp.id(717424165974828087)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755344293879018390)
,p_theme_id=>3
,p_name=>'SMALL'
,p_display_name=>'32px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(385896719135645040)
,p_css_classes=>'a-BadgeList--small'
,p_group_id=>wwv_flow_imp.id(717426618396828089)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755344447099018391)
,p_theme_id=>3
,p_name=>'MEDIUM'
,p_display_name=>'48px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(385896719135645040)
,p_css_classes=>'a-BadgeList--medium'
,p_group_id=>wwv_flow_imp.id(717426618396828089)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755344602370018391)
,p_theme_id=>3
,p_name=>'LARGE'
,p_display_name=>'64px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(385896719135645040)
,p_css_classes=>'a-BadgeList--large'
,p_group_id=>wwv_flow_imp.id(717426618396828089)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755344861153018391)
,p_theme_id=>3
,p_name=>'XLARGE'
,p_display_name=>'96px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(385896719135645040)
,p_css_classes=>'a-BadgeList--xlarge'
,p_group_id=>wwv_flow_imp.id(717426618396828089)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755345020387018391)
,p_theme_id=>3
,p_name=>'XXLARGE'
,p_display_name=>'128px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(385896719135645040)
,p_css_classes=>'a-BadgeList--xxlarge'
,p_group_id=>wwv_flow_imp.id(717426618396828089)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755345249021018391)
,p_theme_id=>3
,p_name=>'2COLUMNNGRID'
,p_display_name=>'2 Columnn Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(385896719135645040)
,p_css_classes=>'a-BadgeList--cols'
,p_group_id=>wwv_flow_imp.id(717424165974828087)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755345413694018391)
,p_theme_id=>3
,p_name=>'3COLUMNGRID'
,p_display_name=>'3 Column Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(385896719135645040)
,p_css_classes=>'a-BadgeList--cols a-BadgeList--3cols'
,p_group_id=>wwv_flow_imp.id(717424165974828087)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755345686664018391)
,p_theme_id=>3
,p_name=>'4COLUMNGRID'
,p_display_name=>'4 Column Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(385896719135645040)
,p_css_classes=>'a-BadgeList--cols a-BadgeList--4cols'
,p_group_id=>wwv_flow_imp.id(717424165974828087)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755345836994018391)
,p_theme_id=>3
,p_name=>'5COLUMNGRID'
,p_display_name=>'5 Column Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(385896719135645040)
,p_css_classes=>'a-BadgeList--cols a-BadgeList--5cols'
,p_group_id=>wwv_flow_imp.id(717424165974828087)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755346057787018391)
,p_theme_id=>3
,p_name=>'FLEXIBLEBOX'
,p_display_name=>'Flexible Box'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(385896719135645040)
,p_css_classes=>'a-BadgeList--flex'
,p_group_id=>wwv_flow_imp.id(717424165974828087)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755346536605018392)
,p_theme_id=>3
,p_name=>'FLOATITEMS'
,p_display_name=>'Float Items'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(717423775712828084)
,p_css_classes=>'a-BadgeList--float'
,p_group_id=>wwv_flow_imp.id(717424165974828087)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755346771517018392)
,p_theme_id=>3
,p_name=>'FIXED'
,p_display_name=>'Span Horizontally'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(717423775712828084)
,p_css_classes=>'a-BadgeList--fixed'
,p_group_id=>wwv_flow_imp.id(717424165974828087)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755346908516018392)
,p_theme_id=>3
,p_name=>'STACKEDVERTICALLY'
,p_display_name=>'Stacked Vertically'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(717423775712828084)
,p_css_classes=>'a-BadgeList--stacked'
,p_group_id=>wwv_flow_imp.id(717424165974828087)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755347127238018393)
,p_theme_id=>3
,p_name=>'SMALL'
,p_display_name=>'32px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(717423775712828084)
,p_css_classes=>'a-BadgeList--small'
,p_group_id=>wwv_flow_imp.id(717426618396828089)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755347387178018393)
,p_theme_id=>3
,p_name=>'MEDIUM'
,p_display_name=>'48px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(717423775712828084)
,p_css_classes=>'a-BadgeList--medium'
,p_group_id=>wwv_flow_imp.id(717426618396828089)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755347523204018393)
,p_theme_id=>3
,p_name=>'LARGE'
,p_display_name=>'64px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(717423775712828084)
,p_css_classes=>'a-BadgeList--large'
,p_group_id=>wwv_flow_imp.id(717426618396828089)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755347707352018393)
,p_theme_id=>3
,p_name=>'XLARGE'
,p_display_name=>'96px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(717423775712828084)
,p_css_classes=>'a-BadgeList--xlarge'
,p_group_id=>wwv_flow_imp.id(717426618396828089)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755347942333018393)
,p_theme_id=>3
,p_name=>'XXLARGE'
,p_display_name=>'128px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(717423775712828084)
,p_css_classes=>'a-BadgeList--xxlarge'
,p_group_id=>wwv_flow_imp.id(717426618396828089)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755348111386018393)
,p_theme_id=>3
,p_name=>'2COLUMNNGRID'
,p_display_name=>'2 Columnn Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(717423775712828084)
,p_css_classes=>'a-BadgeList--cols'
,p_group_id=>wwv_flow_imp.id(717424165974828087)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755348302485018394)
,p_theme_id=>3
,p_name=>'3COLUMNGRID'
,p_display_name=>'3 Column Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(717423775712828084)
,p_css_classes=>'a-BadgeList--cols a-BadgeList--3cols'
,p_group_id=>wwv_flow_imp.id(717424165974828087)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755348557394018394)
,p_theme_id=>3
,p_name=>'4COLUMNGRID'
,p_display_name=>'4 Column Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(717423775712828084)
,p_css_classes=>'a-BadgeList--cols a-BadgeList--4cols'
,p_group_id=>wwv_flow_imp.id(717424165974828087)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755348717973018394)
,p_theme_id=>3
,p_name=>'5COLUMNGRID'
,p_display_name=>'5 Column Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(717423775712828084)
,p_css_classes=>'a-BadgeList--cols a-BadgeList--5cols'
,p_group_id=>wwv_flow_imp.id(717424165974828087)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755348979659018394)
,p_theme_id=>3
,p_name=>'FLEXIBLEBOX'
,p_display_name=>'Flexible Box'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(717423775712828084)
,p_css_classes=>'a-BadgeList--flex'
,p_group_id=>wwv_flow_imp.id(717424165974828087)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755359739129018410)
,p_theme_id=>3
,p_name=>'2COLUMNGRID'
,p_display_name=>'2 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(692727073209839891)
,p_css_classes=>'a-MediaList--cols a-MediaList--2cols'
,p_group_id=>wwv_flow_imp.id(692727409810839893)
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755359935524018410)
,p_theme_id=>3
,p_name=>'3COLUMNGRID'
,p_display_name=>'3 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(692727073209839891)
,p_css_classes=>'a-MediaList--cols a-MediaList--3cols'
,p_group_id=>wwv_flow_imp.id(692727409810839893)
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755360139586018410)
,p_theme_id=>3
,p_name=>'4COLUMNGRID'
,p_display_name=>'4 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(692727073209839891)
,p_css_classes=>'a-MediaList--cols a-MediaList--4cols'
,p_group_id=>wwv_flow_imp.id(692727409810839893)
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755360307757018410)
,p_theme_id=>3
,p_name=>'5COLUMNGRID'
,p_display_name=>'5 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(692727073209839891)
,p_css_classes=>'a-MediaList--cols a-MediaList--5cols'
,p_group_id=>wwv_flow_imp.id(692727409810839893)
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755360503097018411)
,p_theme_id=>3
,p_name=>'SPANHORIZONTALLY'
,p_display_name=>'Span Horizontally'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(692727073209839891)
,p_css_classes=>'a-MediaList--horizontal'
,p_group_id=>wwv_flow_imp.id(692727409810839893)
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755360682997018411)
,p_theme_id=>3
,p_name=>'HIDEBADGE'
,p_display_name=>'Hide Badge'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(692727073209839891)
,p_css_classes=>'a-MediaList--noBadge'
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755360717790018411)
,p_theme_id=>3
,p_name=>'HIDEDESCRIPTION'
,p_display_name=>'Hide Description'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(692727073209839891)
,p_css_classes=>'a-MediaList--noDesc'
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755360835509018411)
,p_theme_id=>3
,p_name=>'HIDETITLE'
,p_display_name=>'Hide Title'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(692727073209839891)
,p_css_classes=>'a-MediaList--noTitle'
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755360943590018411)
,p_theme_id=>3
,p_name=>'HIDEICONS'
,p_display_name=>'Hide Icons'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(692727073209839891)
,p_css_classes=>'a-MediaList--noIcons'
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755361040145018411)
,p_theme_id=>3
,p_name=>'SLIMLIST'
,p_display_name=>'Slim List'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(692727073209839891)
,p_css_classes=>'a-MediaList--slim'
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755367926644019886)
,p_theme_id=>3
,p_name=>'LARGELEFT'
,p_display_name=>'Large'
,p_display_sequence=>1
,p_css_classes=>'a-Button--gapLeft'
,p_group_id=>wwv_flow_imp.id(746424531468405755)
,p_template_types=>'BUTTON'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755368131371019886)
,p_theme_id=>3
,p_name=>'LARGERIGHT'
,p_display_name=>'Large'
,p_display_sequence=>1
,p_css_classes=>'a-Button--gapRight'
,p_group_id=>wwv_flow_imp.id(746424813431405755)
,p_template_types=>'BUTTON'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755368316248019887)
,p_theme_id=>3
,p_name=>'LEFTICON'
,p_display_name=>'Left'
,p_display_sequence=>1
,p_css_classes=>'a-Button--iconLeft'
,p_group_id=>wwv_flow_imp.id(746425349736405755)
,p_template_types=>'BUTTON'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755368553370019887)
,p_theme_id=>3
,p_name=>'LARGE'
,p_display_name=>'Large'
,p_display_sequence=>3
,p_css_classes=>'a-Button--large'
,p_group_id=>wwv_flow_imp.id(746424218274405754)
,p_template_types=>'BUTTON'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755368735312019887)
,p_theme_id=>3
,p_name=>'SMALLLEFT'
,p_display_name=>'Small'
,p_display_sequence=>1
,p_css_classes=>'a-Button--padLeft'
,p_group_id=>wwv_flow_imp.id(746424531468405755)
,p_template_types=>'BUTTON'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755368927938019887)
,p_theme_id=>3
,p_name=>'SMALLRIGHT'
,p_display_name=>'Small'
,p_display_sequence=>1
,p_css_classes=>'a-Button--padRight'
,p_group_id=>wwv_flow_imp.id(746424813431405755)
,p_template_types=>'BUTTON'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755369189057019887)
,p_theme_id=>3
,p_name=>'INNERBUTTON'
,p_display_name=>'Inner Button'
,p_display_sequence=>2
,p_css_classes=>'a-Button--pill'
,p_group_id=>wwv_flow_imp.id(746422550773405751)
,p_template_types=>'BUTTON'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755369395951019887)
,p_theme_id=>3
,p_name=>'LASTBUTTON'
,p_display_name=>'Last Button'
,p_display_sequence=>3
,p_css_classes=>'a-Button--pillEnd'
,p_group_id=>wwv_flow_imp.id(746422550773405751)
,p_template_types=>'BUTTON'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755369570087019887)
,p_theme_id=>3
,p_name=>'FIRSTBUTTON'
,p_display_name=>'First Button'
,p_display_sequence=>1
,p_css_classes=>'a-Button--pillStart'
,p_group_id=>wwv_flow_imp.id(746422550773405751)
,p_template_types=>'BUTTON'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755369737564019889)
,p_theme_id=>3
,p_name=>'PRIMARY'
,p_display_name=>'Primary'
,p_display_sequence=>1
,p_css_classes=>'a-Button--primary'
,p_group_id=>wwv_flow_imp.id(746425674061405755)
,p_template_types=>'BUTTON'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755369838791019889)
,p_theme_id=>3
,p_name=>'REGIONHEADERBUTTON'
,p_display_name=>'Button in Region Header'
,p_display_sequence=>1
,p_css_classes=>'a-Button--regionHeader'
,p_template_types=>'BUTTON'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755370076039019889)
,p_theme_id=>3
,p_name=>'SMALL'
,p_display_name=>'Small'
,p_display_sequence=>1
,p_css_classes=>'a-Button--small'
,p_group_id=>wwv_flow_imp.id(746424218274405754)
,p_template_types=>'BUTTON'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755370120514019889)
,p_theme_id=>3
,p_name=>'STRONGBUTTONLABEL'
,p_display_name=>'Strong Button Label'
,p_display_sequence=>1
,p_css_classes=>'a-Button--strongLabel'
,p_template_types=>'BUTTON'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755370393151019889)
,p_theme_id=>3
,p_name=>'AUTOWIDTH'
,p_display_name=>'Auto Width'
,p_display_sequence=>1
,p_css_classes=>'a-Form--autoWidthLabels'
,p_group_id=>wwv_flow_imp.id(746422298476405751)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755370562593019889)
,p_theme_id=>3
,p_name=>'FIXEDWIDTH'
,p_display_name=>'Fixed'
,p_display_sequence=>10
,p_css_classes=>'a-Form--fixedLabels'
,p_group_id=>wwv_flow_imp.id(746422298476405751)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755370786398019889)
,p_theme_id=>3
,p_name=>'LABELSABOVE'
,p_display_name=>'Labels Above'
,p_display_sequence=>1
,p_css_classes=>'a-Form--labelsAbove'
,p_group_id=>wwv_flow_imp.id(746423916240405752)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755370945815019890)
,p_theme_id=>3
,p_name=>'ALIGNLABELSLEFT'
,p_display_name=>'Left'
,p_display_sequence=>1
,p_css_classes=>'a-Form--leftLabels'
,p_group_id=>wwv_flow_imp.id(746421932096405751)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755371117542019890)
,p_theme_id=>3
,p_name=>'LABELAUTOWIDTH'
,p_display_name=>'Auto Width'
,p_display_sequence=>1
,p_css_classes=>'a-Form-fieldContainer--autoLabelWidth'
,p_group_id=>wwv_flow_imp.id(746423628537405752)
,p_template_types=>'FIELD'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755371211932019890)
,p_theme_id=>3
,p_name=>'STRETCHFORMFIELD'
,p_display_name=>'Stretch Form Field'
,p_display_sequence=>1
,p_css_classes=>'a-Form-fieldContainer--stretch'
,p_template_types=>'FIELD'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755371447167019890)
,p_theme_id=>3
,p_name=>'FIXEDLARGE'
,p_display_name=>'Fixed (Large Width)'
,p_display_sequence=>30
,p_css_classes=>'a-Form-fixedLabelsLarge'
,p_group_id=>wwv_flow_imp.id(746422298476405751)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755371663537019890)
,p_theme_id=>3
,p_name=>'FIXEDMEDIUM'
,p_display_name=>'Fixed (Medium Width)'
,p_display_sequence=>20
,p_css_classes=>'a-Form-fixedLabelsMed'
,p_group_id=>wwv_flow_imp.id(746422298476405751)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755371848184019890)
,p_theme_id=>3
,p_name=>'180PX'
,p_display_name=>'180px'
,p_display_sequence=>10
,p_css_classes=>'h180'
,p_group_id=>wwv_flow_imp.id(746420691677405750)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755372020903019890)
,p_theme_id=>3
,p_name=>'240PX'
,p_display_name=>'240px'
,p_display_sequence=>20
,p_css_classes=>'h240'
,p_group_id=>wwv_flow_imp.id(746420691677405750)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755372233442019890)
,p_theme_id=>3
,p_name=>'320PX'
,p_display_name=>'320px'
,p_display_sequence=>30
,p_css_classes=>'h320'
,p_group_id=>wwv_flow_imp.id(746420691677405750)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755372416975019890)
,p_theme_id=>3
,p_name=>'480PX'
,p_display_name=>'480px'
,p_display_sequence=>50
,p_css_classes=>'h480'
,p_group_id=>wwv_flow_imp.id(746420691677405750)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755372687978019890)
,p_theme_id=>3
,p_name=>'540PX'
,p_display_name=>'540px'
,p_display_sequence=>60
,p_css_classes=>'h540'
,p_group_id=>wwv_flow_imp.id(746420691677405750)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(755372807853019891)
,p_theme_id=>3
,p_name=>'640PX'
,p_display_name=>'640px'
,p_display_sequence=>70
,p_css_classes=>'h640'
,p_group_id=>wwv_flow_imp.id(746420691677405750)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(787117311043949716)
,p_theme_id=>3
,p_name=>'DISABLE'
,p_display_name=>'Disable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(2251716882439710)
,p_css_classes=>'a-Report--staticRowColors'
,p_group_id=>wwv_flow_imp.id(698688432545187815)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(787117583690949716)
,p_theme_id=>3
,p_name=>'ENABLE'
,p_display_name=>'Enable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(2251716882439710)
,p_css_classes=>'a-Report--rowHighlight'
,p_group_id=>wwv_flow_imp.id(698689189405187817)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(787117782882949716)
,p_theme_id=>3
,p_name=>'NOBORDERS'
,p_display_name=>'No Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(2251716882439710)
,p_css_classes=>'a-Report--noBorders'
,p_group_id=>wwv_flow_imp.id(698689890777187817)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(787117993065949716)
,p_theme_id=>3
,p_name=>'HORIZONTALBORDERS'
,p_display_name=>'Horizontal Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(2251716882439710)
,p_css_classes=>'a-Report--horizontalBorders'
,p_group_id=>wwv_flow_imp.id(698689890777187817)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(787118109139949716)
,p_theme_id=>3
,p_name=>'VERTICALBORDERS'
,p_display_name=>'Vertical Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(2251716882439710)
,p_css_classes=>'a-Report--verticalBorders'
,p_group_id=>wwv_flow_imp.id(698689890777187817)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(787118210367949716)
,p_theme_id=>3
,p_name=>'INLINEBORDERS'
,p_display_name=>'Inline Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(2251716882439710)
,p_css_classes=>'a-Report--inline'
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(787118446447949717)
,p_theme_id=>3
,p_name=>'STRETCH'
,p_display_name=>'Stretch'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(2251716882439710)
,p_css_classes=>'a-Report--stretch'
,p_group_id=>wwv_flow_imp.id(698691450870187818)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(787118999001949718)
,p_theme_id=>3
,p_name=>'DISABLE'
,p_display_name=>'Disable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(617728329737082310)
,p_css_classes=>'a-Report--staticRowColors'
,p_group_id=>wwv_flow_imp.id(698688432545187815)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(787119198364949718)
,p_theme_id=>3
,p_name=>'ENABLE'
,p_display_name=>'Enable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(617728329737082310)
,p_css_classes=>'a-Report--rowHighlight'
,p_group_id=>wwv_flow_imp.id(698689189405187817)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(787119375234949718)
,p_theme_id=>3
,p_name=>'NOBORDERS'
,p_display_name=>'No Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(617728329737082310)
,p_css_classes=>'a-Report--noBorders'
,p_group_id=>wwv_flow_imp.id(698689890777187817)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(787119542567949718)
,p_theme_id=>3
,p_name=>'HORIZONTALBORDERS'
,p_display_name=>'Horizontal Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(617728329737082310)
,p_css_classes=>'a-Report--horizontalBorders'
,p_group_id=>wwv_flow_imp.id(698689890777187817)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(787119713399949718)
,p_theme_id=>3
,p_name=>'VERTICALBORDERS'
,p_display_name=>'Vertical Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(617728329737082310)
,p_css_classes=>'a-Report--verticalBorders'
,p_group_id=>wwv_flow_imp.id(698689890777187817)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(787119853489949718)
,p_theme_id=>3
,p_name=>'INLINEBORDERS'
,p_display_name=>'Inline Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(617728329737082310)
,p_css_classes=>'a-Report--inline'
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(787120018395949718)
,p_theme_id=>3
,p_name=>'STRETCH'
,p_display_name=>'Stretch'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(617728329737082310)
,p_css_classes=>'a-Report--stretch'
,p_group_id=>wwv_flow_imp.id(698691450870187818)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(787133502775949747)
,p_theme_id=>3
,p_name=>'DISABLE'
,p_display_name=>'Disable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(717436155076828097)
,p_css_classes=>'a-Report--staticRowColors'
,p_group_id=>wwv_flow_imp.id(698688432545187815)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(787133742911949747)
,p_theme_id=>3
,p_name=>'ENABLE'
,p_display_name=>'Enable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(717436155076828097)
,p_css_classes=>'a-Report--rowHighlight'
,p_group_id=>wwv_flow_imp.id(698689189405187817)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(787133937296949747)
,p_theme_id=>3
,p_name=>'NOBORDERS'
,p_display_name=>'No Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(717436155076828097)
,p_css_classes=>'a-Report--noBorders'
,p_group_id=>wwv_flow_imp.id(698689890777187817)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(787134188912949747)
,p_theme_id=>3
,p_name=>'HORIZONTALBORDERS'
,p_display_name=>'Horizontal Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(717436155076828097)
,p_css_classes=>'a-Report--horizontalBorders'
,p_group_id=>wwv_flow_imp.id(698689890777187817)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(787134324612949747)
,p_theme_id=>3
,p_name=>'VERTICALBORDERS'
,p_display_name=>'Vertical Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(717436155076828097)
,p_css_classes=>'a-Report--verticalBorders'
,p_group_id=>wwv_flow_imp.id(698689890777187817)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(787134433950949747)
,p_theme_id=>3
,p_name=>'INLINEBORDERS'
,p_display_name=>'Inline Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(717436155076828097)
,p_css_classes=>'a-Report--inline'
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(787134647594949747)
,p_theme_id=>3
,p_name=>'STRETCH'
,p_display_name=>'Stretch'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(717436155076828097)
,p_css_classes=>'a-Report--stretch'
,p_group_id=>wwv_flow_imp.id(698691450870187818)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(926399273702707533)
,p_theme_id=>3
,p_name=>'ADD_ACTIONS'
,p_display_name=>'Add Actions'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(385776364537002403)
,p_css_classes=>'js-addActions'
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(926399333093707533)
,p_theme_id=>3
,p_name=>'ADD_SLIDE_ANIMATION'
,p_display_name=>'Add Slide Animation'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(385776364537002403)
,p_css_classes=>'js-slide'
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(940697553666341585)
,p_theme_id=>3
,p_name=>'SLIMPROGRESSLIST'
,p_display_name=>'Slim Progress List'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(703372217110859571)
,p_css_classes=>'a-WizardSteps--slim'
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1131768309924193980)
,p_theme_id=>3
,p_name=>'ENABLE'
,p_display_name=>'Enable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(1127586271702515372)
,p_css_classes=>'a-Report--rowHighlight'
,p_group_id=>wwv_flow_imp.id(698689189405187817)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1131768523123193980)
,p_theme_id=>3
,p_name=>'HORIZONTALBORDERS'
,p_display_name=>'Horizontal Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(1127586271702515372)
,p_css_classes=>'a-Report--horizontalBorders'
,p_group_id=>wwv_flow_imp.id(698689890777187817)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1131768627575193980)
,p_theme_id=>3
,p_name=>'INLINEBORDERS'
,p_display_name=>'Inline Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(1127586271702515372)
,p_css_classes=>'a-Report--inline'
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1131768874640193981)
,p_theme_id=>3
,p_name=>'NOBORDERS'
,p_display_name=>'No Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(1127586271702515372)
,p_css_classes=>'a-Report--noBorders'
,p_group_id=>wwv_flow_imp.id(698689890777187817)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1131769045921193981)
,p_theme_id=>3
,p_name=>'STRETCH'
,p_display_name=>'Stretch'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(1127586271702515372)
,p_css_classes=>'a-Report--stretch'
,p_group_id=>wwv_flow_imp.id(698691450870187818)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1131769275377193981)
,p_theme_id=>3
,p_name=>'VERTICALBORDERS'
,p_display_name=>'Vertical Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(1127586271702515372)
,p_css_classes=>'a-Report--verticalBorders'
,p_group_id=>wwv_flow_imp.id(698689890777187817)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1199561355394032423)
,p_theme_id=>3
,p_name=>'LEFT'
,p_display_name=>'Left'
,p_display_sequence=>1
,p_button_template_id=>wwv_flow_imp.id(690706750701136097)
,p_css_classes=>'a-Button--iconLeft'
,p_group_id=>wwv_flow_imp.id(746425349736405755)
,p_template_types=>'BUTTON'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1445975050737085430)
,p_theme_id=>3
,p_name=>'RESIZABLE'
,p_display_name=>'Resizable'
,p_display_sequence=>2
,p_region_template_id=>wwv_flow_imp.id(1131993087623131882)
,p_css_classes=>'js-resizable'
,p_template_types=>'REGION'
,p_help_text=>'Allow dialog to be resized.'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1445975135241085430)
,p_theme_id=>3
,p_name=>'DRAGGABLE'
,p_display_name=>'Draggable'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(1131993087623131882)
,p_css_classes=>'js-draggable'
,p_template_types=>'REGION'
,p_help_text=>'Allow dialog to be moved.'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1445975358746085430)
,p_theme_id=>3
,p_name=>'SMALL_480X320'
,p_display_name=>'Small (480x320)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(1131993087623131882)
,p_css_classes=>'js-dialog-size480x320'
,p_group_id=>wwv_flow_imp.id(1141459524801402371)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1445975518111085431)
,p_theme_id=>3
,p_name=>'LARGE_720X480'
,p_display_name=>'Large (720x480)'
,p_display_sequence=>3
,p_region_template_id=>wwv_flow_imp.id(1131993087623131882)
,p_css_classes=>'js-dialog-size720x480'
,p_group_id=>wwv_flow_imp.id(1141459524801402371)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1445975704313085431)
,p_theme_id=>3
,p_name=>'MEDIUM_600X400'
,p_display_name=>'Medium (600x400)'
,p_display_sequence=>2
,p_region_template_id=>wwv_flow_imp.id(1131993087623131882)
,p_css_classes=>'js-dialog-size600x400'
,p_group_id=>wwv_flow_imp.id(1141459524801402371)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1445975835000085431)
,p_theme_id=>3
,p_name=>'MODAL'
,p_display_name=>'Modal'
,p_display_sequence=>3
,p_region_template_id=>wwv_flow_imp.id(1131993087623131882)
,p_css_classes=>'js-modal'
,p_template_types=>'REGION'
,p_help_text=>'Display as modal.'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1525655309965182076)
,p_theme_id=>3
,p_name=>'DONOTWRAPTEXT'
,p_display_name=>'Do not wrap text'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(20507805987268923)
,p_css_classes=>'a-LinksList--nowrap'
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1525655479052182076)
,p_theme_id=>3
,p_name=>'SHOWBADGES'
,p_display_name=>'Show Badges'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(20507805987268923)
,p_css_classes=>'a-LinksList--showBadge'
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1525655500963182076)
,p_theme_id=>3
,p_name=>'SHOWRIGHTARROW'
,p_display_name=>'Show Right Arrow'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(20507805987268923)
,p_css_classes=>'a-LinksList--showArrow'
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1525655616409182076)
,p_theme_id=>3
,p_name=>'USEBRIGHTHOVERS'
,p_display_name=>'Use Bright Hovers'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(20507805987268923)
,p_css_classes=>'a-LinksList--brightHover'
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1525655890890182076)
,p_theme_id=>3
,p_name=>'FORTOPLEVELONLY'
,p_display_name=>'For top level only'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(20507805987268923)
,p_css_classes=>'a-LinksList--showTopIcons'
,p_group_id=>wwv_flow_imp.id(697239665711708855)
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1525656046318182076)
,p_theme_id=>3
,p_name=>'FORALLITEMS'
,p_display_name=>'For all items'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(20507805987268923)
,p_css_classes=>'a-LinksList--showIcons'
,p_group_id=>wwv_flow_imp.id(697239665711708855)
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1525667568855182133)
,p_theme_id=>3
,p_name=>'DONOTWRAPTEXT'
,p_display_name=>'Do not wrap text'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(704358525679957526)
,p_css_classes=>'a-LinksList--nowrap'
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1525667694538182133)
,p_theme_id=>3
,p_name=>'SHOWBADGES'
,p_display_name=>'Show Badges'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(704358525679957526)
,p_css_classes=>'a-LinksList--showBadge'
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1525667713426182133)
,p_theme_id=>3
,p_name=>'SHOWRIGHTARROW'
,p_display_name=>'Show Right Arrow'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(704358525679957526)
,p_css_classes=>'a-LinksList--showArrow'
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1525667858315182133)
,p_theme_id=>3
,p_name=>'USEBRIGHTHOVERS'
,p_display_name=>'Use Bright Hovers'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(704358525679957526)
,p_css_classes=>'a-LinksList--brightHover'
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1525668042336182133)
,p_theme_id=>3
,p_name=>'FORTOPLEVELONLY'
,p_display_name=>'For top level only'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(704358525679957526)
,p_css_classes=>'a-LinksList--showTopIcons'
,p_group_id=>wwv_flow_imp.id(697239665711708855)
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1525668231424182134)
,p_theme_id=>3
,p_name=>'FORALLITEMS'
,p_display_name=>'For all items'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(704358525679957526)
,p_css_classes=>'a-LinksList--showIcons'
,p_group_id=>wwv_flow_imp.id(697239665711708855)
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1544815603312477990)
,p_theme_id=>3
,p_name=>'SHOWRIGHTARROW'
,p_display_name=>'Show Right Arrow'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(38811532466194226)
,p_css_classes=>'a-LinksList--showArrow'
,p_template_types=>'REPORT'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1544815753448477990)
,p_theme_id=>3
,p_name=>'USEBRIGHTHOVERS'
,p_display_name=>'Use Bright Hovers'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(38811532466194226)
,p_css_classes=>'a-LinksList--brightHover'
,p_template_types=>'REPORT'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1544815884959477990)
,p_theme_id=>3
,p_name=>'DONOTWRAPTEXT'
,p_display_name=>'Do not wrap text'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(38811532466194226)
,p_css_classes=>'a-LinksList--nowrap'
,p_template_types=>'REPORT'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1544818837483478024)
,p_theme_id=>3
,p_name=>'SHOWRIGHTARROW'
,p_display_name=>'Show Right Arrow'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(717433602632828095)
,p_css_classes=>'a-LinksList--showArrow'
,p_template_types=>'REPORT'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1544818973917478024)
,p_theme_id=>3
,p_name=>'USEBRIGHTHOVERS'
,p_display_name=>'Use Bright Hovers'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(717433602632828095)
,p_css_classes=>'a-LinksList--brightHover'
,p_template_types=>'REPORT'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1544819035865478024)
,p_theme_id=>3
,p_name=>'DONOTWRAPTEXT'
,p_display_name=>'Do not wrap text'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(717433602632828095)
,p_css_classes=>'a-LinksList--nowrap'
,p_template_types=>'REPORT'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1554812770773408377)
,p_theme_id=>3
,p_name=>'HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(380771699411878611)
,p_css_classes=>'a-Region--hideHeader'
,p_group_id=>wwv_flow_imp.id(696624360683145458)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1554812985067408377)
,p_theme_id=>3
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(380771699411878611)
,p_css_classes=>'a-Region--accessibleHeader'
,p_group_id=>wwv_flow_imp.id(696624360683145458)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1554813151047408377)
,p_theme_id=>3
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_imp.id(380771699411878611)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_imp.id(689635167517993971)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1554813301944408378)
,p_theme_id=>3
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_imp.id(380771699411878611)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_imp.id(689635167517993971)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1554813525412408378)
,p_theme_id=>3
,p_name=>'SIDEBAR'
,p_display_name=>'Sidebar'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(380771699411878611)
,p_css_classes=>'a-Region--sideRegion'
,p_group_id=>wwv_flow_imp.id(689636107671993973)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1554813730587408378)
,p_theme_id=>3
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(380771699411878611)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_imp.id(689636807321993973)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1554813933522408378)
,p_theme_id=>3
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(380771699411878611)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_imp.id(689638757932993974)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1554814137047408378)
,p_theme_id=>3
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(380771699411878611)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_imp.id(689638757932993974)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1554814391152408378)
,p_theme_id=>3
,p_name=>'DEFAULTPADDING'
,p_display_name=>'Default Padding'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_imp.id(380771699411878611)
,p_css_classes=>'a-Region--paddedBody'
,p_group_id=>wwv_flow_imp.id(689635167517993971)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1554814467842408378)
,p_theme_id=>3
,p_name=>'REMOVE_TOP_BORDER'
,p_display_name=>'Remove Top Border'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(380771699411878611)
,p_css_classes=>'a-Region--noTopBorder'
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1554814632627408378)
,p_theme_id=>3
,p_name=>'SIMPLE'
,p_display_name=>'Simple'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(380771699411878611)
,p_css_classes=>'a-Region--simple'
,p_group_id=>wwv_flow_imp.id(689636807321993973)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1554831633096526796)
,p_theme_id=>3
,p_name=>'RESPONSIVEICONCOLUMNS'
,p_display_name=>'Responsive Icon Columns'
,p_display_sequence=>2
,p_region_template_id=>wwv_flow_imp.id(690714020036152159)
,p_css_classes=>'a-IRR-region--responsiveIconView'
,p_template_types=>'REGION'
,p_help_text=>'Automatically increases number of icon columns to show based on screen resolution.'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1554831701564526797)
,p_theme_id=>3
,p_name=>'ICONLABELSRIGHT'
,p_display_name=>'Icon Labels on Right'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(690714020036152159)
,p_css_classes=>'a-IRR-region--iconLabelsRight'
,p_template_types=>'REGION'
,p_help_text=>'Shows labels in Icon View to the right of the icon.'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1554831806774526797)
,p_theme_id=>3
,p_name=>'REMOVEOUTERBORDERS'
,p_display_name=>'Remove Outer Borders'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(690714020036152159)
,p_css_classes=>'a-IRR-region--noOuterBorders'
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1554846967207542276)
,p_theme_id=>3
,p_name=>'FLUSHREGION'
,p_display_name=>'Flush Region'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(717403738062820750)
,p_css_classes=>'a-Region--flush'
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1554847055162542276)
,p_theme_id=>3
,p_name=>'STACKEDREGION'
,p_display_name=>'Stacked Region'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(717403738062820750)
,p_css_classes=>'a-Region--stacked'
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1554847272590542276)
,p_theme_id=>3
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(717403738062820750)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_imp.id(689635167517993971)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1554847450067542276)
,p_theme_id=>3
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(717403738062820750)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_imp.id(689635167517993971)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1554847672581542276)
,p_theme_id=>3
,p_name=>'SIDEBAR'
,p_display_name=>'Sidebar'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(717403738062820750)
,p_css_classes=>'a-Region--sideRegion'
,p_group_id=>wwv_flow_imp.id(689636107671993973)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1554847887758542276)
,p_theme_id=>3
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(717403738062820750)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_imp.id(689636807321993973)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1554848073675542277)
,p_theme_id=>3
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(717403738062820750)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_imp.id(689638757932993974)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1554848294732542277)
,p_theme_id=>3
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(717403738062820750)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_imp.id(689638757932993974)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1554848424496542277)
,p_theme_id=>3
,p_name=>'EXPANDED'
,p_display_name=>'Expanded'
,p_display_sequence=>.1
,p_region_template_id=>wwv_flow_imp.id(717403738062820750)
,p_css_classes=>'is-expanded'
,p_group_id=>wwv_flow_imp.id(717406084452820762)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1554848666729542278)
,p_theme_id=>3
,p_name=>'COLLAPSED'
,p_display_name=>'Collapsed'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(717403738062820750)
,p_css_classes=>'is-collapsed'
,p_group_id=>wwv_flow_imp.id(717406084452820762)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1554862320208550802)
,p_theme_id=>3
,p_name=>'REMOVE_TOP_BORDER'
,p_display_name=>'Remove Top Border'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(703386252988943977)
,p_css_classes=>'a-Region--noTopBorder'
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1554862544640550802)
,p_theme_id=>3
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(703386252988943977)
,p_css_classes=>'a-Region--accessibleHeader'
,p_group_id=>wwv_flow_imp.id(696624360683145458)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1554862741972550802)
,p_theme_id=>3
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(703386252988943977)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_imp.id(689638757932993974)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1554862983266550802)
,p_theme_id=>3
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(703386252988943977)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_imp.id(689636807321993973)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1554863120634550802)
,p_theme_id=>3
,p_name=>'DEFAULTPADDING'
,p_display_name=>'Default Padding'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_imp.id(703386252988943977)
,p_css_classes=>'a-Region--paddedBody'
,p_group_id=>wwv_flow_imp.id(689635167517993971)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1554863336092550802)
,p_theme_id=>3
,p_name=>'HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(703386252988943977)
,p_css_classes=>'a-Region--hideHeader'
,p_group_id=>wwv_flow_imp.id(696624360683145458)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1554863545945550802)
,p_theme_id=>3
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_imp.id(703386252988943977)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_imp.id(689635167517993971)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1554863760759550802)
,p_theme_id=>3
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(703386252988943977)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_imp.id(689638757932993974)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1554863920638550802)
,p_theme_id=>3
,p_name=>'SIDEBAR'
,p_display_name=>'Sidebar'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(703386252988943977)
,p_css_classes=>'a-Region--sideRegion'
,p_group_id=>wwv_flow_imp.id(689636107671993973)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1554864134947550802)
,p_theme_id=>3
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_imp.id(703386252988943977)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_imp.id(689635167517993971)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
end;
/
prompt --application/shared_components/globalization/language
begin
wwv_flow_imp_shared.create_language_map(
 p_id=>wwv_flow_imp.id(72246516903976156)
,p_translation_flow_id=>4501
,p_translation_flow_language_cd=>'es'
,p_translation_comments=>'SQL Workshop - Spanish'
,p_direction_right_to_left=>'N'
);
wwv_flow_imp_shared.create_language_map(
 p_id=>wwv_flow_imp.id(72246614295976156)
,p_translation_flow_id=>4502
,p_translation_flow_language_cd=>'fr'
,p_translation_comments=>'SQL Workshop - French'
,p_direction_right_to_left=>'N'
);
wwv_flow_imp_shared.create_language_map(
 p_id=>wwv_flow_imp.id(72246709197976156)
,p_translation_flow_id=>4503
,p_translation_flow_language_cd=>'de'
,p_translation_comments=>'SQL Workshop - German'
,p_direction_right_to_left=>'N'
);
wwv_flow_imp_shared.create_language_map(
 p_id=>wwv_flow_imp.id(72246810868976156)
,p_translation_flow_id=>4504
,p_translation_flow_language_cd=>'it'
,p_translation_comments=>'SQL Workshop - Italian'
,p_direction_right_to_left=>'N'
);
wwv_flow_imp_shared.create_language_map(
 p_id=>wwv_flow_imp.id(72246910302976156)
,p_translation_flow_id=>4505
,p_translation_flow_language_cd=>'pt-br'
,p_translation_comments=>'SQL Workshop - Brazilian Portuguese'
,p_direction_right_to_left=>'N'
);
wwv_flow_imp_shared.create_language_map(
 p_id=>wwv_flow_imp.id(72247010323976156)
,p_translation_flow_id=>4506
,p_translation_flow_language_cd=>'zh-cn'
,p_translation_comments=>'SQL Workshop - Simplified Chinese'
,p_direction_right_to_left=>'N'
);
wwv_flow_imp_shared.create_language_map(
 p_id=>wwv_flow_imp.id(72247105821976156)
,p_translation_flow_id=>4507
,p_translation_flow_language_cd=>'zh-tw'
,p_translation_comments=>'SQL Workshop - Traditional Chinese'
,p_direction_right_to_left=>'N'
);
wwv_flow_imp_shared.create_language_map(
 p_id=>wwv_flow_imp.id(72247224176976156)
,p_translation_flow_id=>4508
,p_translation_flow_language_cd=>'ko'
,p_translation_comments=>'SQL Workshop - Korean'
,p_direction_right_to_left=>'N'
);
wwv_flow_imp_shared.create_language_map(
 p_id=>wwv_flow_imp.id(72247317117976156)
,p_translation_flow_id=>4509
,p_translation_flow_language_cd=>'ja'
,p_translation_comments=>'SQL Workshop - Japanese'
,p_direction_right_to_left=>'N'
);
end;
/
prompt --application/shared_components/logic/build_options
begin
wwv_flow_imp_shared.create_build_option(
 p_id=>wwv_flow_imp.id(3083101046366798)
,p_build_option_name=>'Allow Alter of MLE Env Lang Options'
,p_build_option_status=>'EXCLUDE'
,p_version_scn=>37165770887393
,p_build_option_comment=>'Whether to allow the updating of an MLE environment''s language options. See bug 33890408.'
);
wwv_flow_imp_shared.create_build_option(
 p_id=>wwv_flow_imp.id(140211619632429750)
,p_build_option_name=>'SQL Command Processor Transactions'
,p_build_option_status=>'INCLUDE'
,p_version_scn=>37165770887393
,p_build_option_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'within the SQL command processor; ability to run in a transactional mode. ',
'',
'Uses DBMS_JOBS to maintain session state over multiple pages views / statements within a transaction.'))
);
wwv_flow_imp_shared.create_build_option(
 p_id=>wwv_flow_imp.id(140265918963157648)
,p_build_option_name=>'Database Monitoring'
,p_build_option_status=>'INCLUDE'
,p_version_scn=>37165770887393
,p_build_option_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'monitor sessions',
'view SQL',
'view tablespace information',
'view data files',
'trace sessions',
''))
);
wwv_flow_imp_shared.create_build_option(
 p_id=>wwv_flow_imp.id(240237502901130926)
,p_build_option_name=>'Create Synonym Wizard'
,p_build_option_status=>'INCLUDE'
,p_version_scn=>37165770887393
,p_build_option_comment=>'Show or suppress the create synonym wizard'
);
wwv_flow_imp_shared.create_build_option(
 p_id=>wwv_flow_imp.id(240247031763163202)
,p_build_option_name=>'Create MView Wizard'
,p_build_option_status=>'INCLUDE'
,p_version_scn=>37165770887393
,p_build_option_comment=>'Show or suppress create materialized view wizard'
);
wwv_flow_imp_shared.create_build_option(
 p_id=>wwv_flow_imp.id(256109433659228165)
,p_build_option_name=>'Object REST Enablement'
,p_build_option_status=>'INCLUDE'
,p_version_scn=>37165770887393
,p_default_on_export=>'INCLUDE'
,p_build_option_comment=>'This is being used to hide REST Enablement features in the Object Browser.'
);
wwv_flow_imp_shared.create_build_option(
 p_id=>wwv_flow_imp.id(693462110571635991)
,p_build_option_name=>'Enable APEX Internal Feedback'
,p_build_option_status=>'EXCLUDE'
,p_version_scn=>37165770887393
,p_default_on_export=>'EXCLUDE'
);
wwv_flow_imp_shared.create_build_option(
 p_id=>wwv_flow_imp.id(1080926199001296276)
,p_build_option_name=>'Commented Out'
,p_build_option_status=>'EXCLUDE'
,p_version_scn=>37165770887393
);
wwv_flow_imp_shared.create_build_option(
 p_id=>wwv_flow_imp.id(1694682434415493288)
,p_build_option_name=>'BUILDER_AUTH_SSO'
,p_build_option_status=>'INCLUDE'
,p_version_scn=>37165770887393
);
end;
/
prompt --application/shared_components/globalization/messages
begin
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2622179911827563)
,p_name=>'AI.DATA_MODEL.QUICK_SQL'
,p_message_text=>'Review Quick SQL'
,p_is_js_message=>true
,p_version_scn=>133769588
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1601207464752058)
,p_name=>'AI.DATA_MODEL.SAMPLE_1_MSG'
,p_message_text=>'Create a data model for managing project and task data.'
,p_is_js_message=>true
,p_version_scn=>132762209
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1601029936440413)
,p_name=>'AI.DATA_MODEL.SAMPLE_1_TITLE'
,p_message_text=>'Sample Project and Task Management'
,p_is_js_message=>true
,p_version_scn=>133769644
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2206295099678400)
,p_name=>'AI.DATA_MODEL.SAMPLE_2_MSG'
,p_message_text=>'Create a data model for a school course catalog, including departments, instructors, and students.'
,p_is_js_message=>true
,p_version_scn=>133769865
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2206076570681837)
,p_name=>'AI.DATA_MODEL.SAMPLE_2_TITLE'
,p_message_text=>'Sample School Course Catalog'
,p_is_js_message=>true
,p_version_scn=>133769753
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2621938032829290)
,p_name=>'AI.DATA_MODEL.SQL_SCRIPT'
,p_message_text=>'Create SQL Script'
,p_is_js_message=>true
,p_version_scn=>130835610
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5048299565690228)
,p_name=>'AI.DISCLAIMER'
,p_message_text=>'This assistant lets you use natural language to generate a data model and sample data. Use it to jump-start the creation of a schema to build your application on.'
,p_is_js_message=>true
,p_version_scn=>125119102
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1600830978450730)
,p_name=>'AI.PROMPT.CANNOT_PROCESS'
,p_message_text=>'I''m sorry, I couldn''t process that. Could you please rephrase your question?'
,p_is_js_message=>true
,p_version_scn=>129972647
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(625174511518088116)
,p_name=>'DATA.LOAD.SODA_FILE_FORMATS'
,p_message_text=>'Supported formats json, txt, zip'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4801520630592684)
,p_name=>'EDITOR.UNSAVED_CHANGES'
,p_message_text=>'Changes have been made. Press OK to close editor without saving changes.'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(556059929884498062)
,p_name=>'GATHER_TABLE_STATS'
,p_message_text=>'Gather Table Statistics'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2212896908166355)
,p_name=>'OB.ACTION_ADD_COL'
,p_message_text=>'Add Column'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3474254740742093)
,p_name=>'OB.ACTION_ADD_IMPORT'
,p_message_text=>'Add Import'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5400859373416842)
,p_name=>'OB.ACTION_ALTER'
,p_message_text=>'Alter'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1941063512089528)
,p_name=>'OB.ACTION_CHANGE_VIEW'
,p_message_text=>'Change View'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1851290203844630)
,p_name=>'OB.ACTION_COLUMNS'
,p_message_text=>'Columns...'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1928159810461137)
,p_name=>'OB.ACTION_COMMENT'
,p_message_text=>'Comment'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1857545053039404)
,p_name=>'OB.ACTION_COMPILE'
,p_message_text=>'Compile'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1853647715946628)
,p_name=>'OB.ACTION_COPY'
,p_message_text=>'Copy'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2214419958183873)
,p_name=>'OB.ACTION_COPY_TABLE'
,p_message_text=>'Copy Table'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5910118428968822)
,p_name=>'OB.ACTION_COUNT_ROWS'
,p_message_text=>'Count Rows'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1857366404034413)
,p_name=>'OB.ACTION_CREATE'
,p_message_text=>'Create'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2214281087182640)
,p_name=>'OB.ACTION_CREATE_APP'
,p_message_text=>'Create App'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1817160120602218)
,p_name=>'OB.ACTION_CREATE_CURRENT'
,p_message_text=>'Create Current Object'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2214057665180110)
,p_name=>'OB.ACTION_CREATE_LT'
,p_message_text=>'Create Lookup Table'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2216643324353712)
,p_name=>'OB.ACTION_CREATE_RELATIONAL_VIEW'
,p_message_text=>'Create Relational View'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2214940707347017)
,p_name=>'OB.ACTION_CREATE_SEARCH_INDEX'
,p_message_text=>'Create Search Index'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3001062160099481)
,p_name=>'OB.ACTION_DEL_COL'
,p_message_text=>'Delete Column'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1856394934017757)
,p_name=>'OB.ACTION_DISABLE'
,p_message_text=>'Disable'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1851828289855516)
,p_name=>'OB.ACTION_DL_EXCEL'
,p_message_text=>'Download'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1852067231863763)
,p_name=>'OB.ACTION_DL_TEXT'
,p_message_text=>'Download'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1855956246009879)
,p_name=>'OB.ACTION_DROP'
,p_message_text=>'Drop'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2213406646173510)
,p_name=>'OB.ACTION_DROP_COL'
,p_message_text=>'Drop Column'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2216472771350095)
,p_name=>'OB.ACTION_DROP_SEARCH_INDEX'
,p_message_text=>'Drop Search Index'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2602338086467147)
,p_name=>'OB.ACTION_DROP_TABLE'
,p_message_text=>'Drop Table'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1856152981015681)
,p_name=>'OB.ACTION_ENABLE'
,p_message_text=>'Enable'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1851492005846931)
,p_name=>'OB.ACTION_FILTER'
,p_message_text=>'Filter...'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1857032973028978)
,p_name=>'OB.ACTION_GET_STATS'
,p_message_text=>'Gather Statistics'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1634059969389080)
,p_name=>'OB.ACTION_GOTO_ERROR'
,p_message_text=>'Go to Error'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1856599786020316)
,p_name=>'OB.ACTION_GRANT'
,p_message_text=>'Grant'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1855331449001308)
,p_name=>'OB.ACTION_INSERT'
,p_message_text=>'Insert Row'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1855788029008255)
,p_name=>'OB.ACTION_LOAD_DATA'
,p_message_text=>'Load Data'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2213094212168437)
,p_name=>'OB.ACTION_MODIFY_COL'
,p_message_text=>'Modify Column'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1816182757599836)
,p_name=>'OB.ACTION_OPEN_OBJECT'
,p_message_text=>'Open Object'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1857925335049208)
,p_name=>'OB.ACTION_REBUILD'
,p_message_text=>'Rebuild'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1849821324656912)
,p_name=>'OB.ACTION_REFRESH'
,p_message_text=>'Refresh'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2213696925175427)
,p_name=>'OB.ACTION_RENAME'
,p_message_text=>'Rename Table'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2213296170170746)
,p_name=>'OB.ACTION_RENAME_COL'
,p_message_text=>'Rename Column'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1856850273024957)
,p_name=>'OB.ACTION_REVOKE'
,p_message_text=>'Revoke'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1853477501943794)
,p_name=>'OB.ACTION_RUN'
,p_message_text=>'Run'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1857736410044524)
,p_name=>'OB.ACTION_SAVE_COMPILE'
,p_message_text=>'Save and Compile'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2602691256472293)
,p_name=>'OB.ACTION_TABLE_COMMENT'
,p_message_text=>'Table Comment'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1858376572067697)
,p_name=>'OB.ACTION_TEST'
,p_message_text=>'Test'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2213819483177158)
,p_name=>'OB.ACTION_TRUNCATE'
,p_message_text=>'Truncate Table'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2214644170185856)
,p_name=>'OB.ACTION_UI_DEFAULTS'
,p_message_text=>'UI Defaults'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(234644174279126877)
,p_name=>'OB.ADD_IMPORT'
,p_message_text=>'Add Import'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1642064381100623)
,p_name=>'OB.CARD_DATABASE_LINK'
,p_message_text=>'Database Link'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1640077596066902)
,p_name=>'OB.CARD_FUNCTION'
,p_message_text=>'Function'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1640227217071597)
,p_name=>'OB.CARD_FUNCTION_DESC'
,p_message_text=>'A function is a subprogram that can take parameters and return a value.'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1640444792073465)
,p_name=>'OB.CARD_INDEX'
,p_message_text=>'Index'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(116528009209776151)
,p_name=>'OB.CARD_MLE_ENVIRONMENT'
,p_message_text=>'MLE Environment'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(116528228610779062)
,p_name=>'OB.CARD_MLE_MODULE'
,p_message_text=>'MLE Module - JavaScript'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1639242873034636)
,p_name=>'OB.CARD_PACKAGE'
,p_message_text=>'Package'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1639485691043240)
,p_name=>'OB.CARD_PACKAGE_DESC'
,p_message_text=>'A package is a database object that groups logically related PL/SQL items, such as types, functions and procedures.'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1639642282045093)
,p_name=>'OB.CARD_PROCEDURE'
,p_message_text=>'Procedure'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1639818215065063)
,p_name=>'OB.CARD_PROCEDURE_DESC'
,p_message_text=>'A procedure is a subprogram that performs a specific action.'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1640804738079513)
,p_name=>'OB.CARD_SEQUENCE'
,p_message_text=>'Sequence'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1642859268113647)
,p_name=>'OB.CARD_SODA_COLLECTION'
,p_message_text=>'SODA Collection'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1642478599104806)
,p_name=>'OB.CARD_SYNONYM'
,p_message_text=>'Synonym'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1638246942966648)
,p_name=>'OB.CARD_TABLE'
,p_message_text=>'Table'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1638406203971240)
,p_name=>'OB.CARD_TABLE_DESC'
,p_message_text=>'A table is a unit of data storage in an Oracle database, containing rows and columns.'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1641628594095055)
,p_name=>'OB.CARD_TRIGGER'
,p_message_text=>'Trigger'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1641241298090253)
,p_name=>'OB.CARD_TYPE'
,p_message_text=>'Type'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1638847869019285)
,p_name=>'OB.CARD_VIEW'
,p_message_text=>'View'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1639036225032276)
,p_name=>'OB.CARD_VIEW_DESC'
,p_message_text=>'A view is a logical representation of another table or combination of tables.'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2354919561288748)
,p_name=>'OB.CLOSE_WARNING'
,p_message_text=>'There are unsaved changes. Do you want to continue?'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3274225303590796)
,p_name=>'OB.CMD_COMPILE.MLE_ENVIRONMENT'
,p_message_text=>'MLE Environment %0 compiled.'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(18804787158568124)
,p_name=>'OB.CMD_COMPILE.TRIGGER'
,p_message_text=>'Trigger %0 compiled.'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(18804563832565763)
,p_name=>'OB.CMD_COMPILE.VIEW'
,p_message_text=>'View %0 compiled.'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(8610365781132053)
,p_name=>'OB.CMD_COUNT_ROWS.RESULT'
,p_message_text=>'%0 has %1 rows.'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5001474760593682)
,p_name=>'OB.CMD_CREATE_SODA_INDEX'
,p_message_text=>'Index %0 created.'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5001290027592497)
,p_name=>'OB.CMD_CREATE_SODA_VIEW'
,p_message_text=>'View %0 created.'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(19001090872628470)
,p_name=>'OB.CMD_DISABLE.INDEX'
,p_message_text=>'Index %0 has been disabled.'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(19000462675599472)
,p_name=>'OB.CMD_DISABLE.TRIGGER'
,p_message_text=>'Trigger %0 has been disabled.'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5000893356590583)
,p_name=>'OB.CMD_DROP_SODA'
,p_message_text=>'Collection %0 dropped.'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5001035746591645)
,p_name=>'OB.CMD_DROP_SODA_INDEX'
,p_message_text=>'JSON search index dropped.'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(19000841572626023)
,p_name=>'OB.CMD_ENABLE.INDEX'
,p_message_text=>'Index %0 has been enabled.'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(19000265824597329)
,p_name=>'OB.CMD_ENABLE.TRIGGER'
,p_message_text=>'Trigger %0 has been enabled.'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(7601265083866984)
,p_name=>'OB.CMD_GATHER_STATS.IN_PROGRESS'
,p_message_text=>'Gather statistics in progress...'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(7600324805826673)
,p_name=>'OB.CMD_GATHER_STATS.RUNNING'
,p_message_text=>'Gather statistics is still running. Please wait until it finishes.'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(7600536014831069)
,p_name=>'OB.CMD_GATHER_STATS.STARTED'
,p_message_text=>'Job has started to gather statistics. This may take a while to finish. Please wait and refresh the view later.'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(19001398168694451)
,p_name=>'OB.CMD_REBUILD.INDEX'
,p_message_text=>'Index %0 has been rebuilt.'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2004333645632289)
,p_name=>'OB.CMD_TEST_DB_LINK'
,p_message_text=>'Database link "%0" has been successfully tested.'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2002950771825300)
,p_name=>'OB.COL_ACTION_TYPE'
,p_message_text=>'Action Type'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2003070367825311)
,p_name=>'OB.COL_ACTIVE'
,p_message_text=>'Active'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2003155175825311)
,p_name=>'OB.COL_APP_ID'
,p_message_text=>'App ID'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2003298088825312)
,p_name=>'OB.COL_APP_NAME'
,p_message_text=>'App Name'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2003333420825312)
,p_name=>'OB.COL_ATTRIBUTES'
,p_message_text=>'# of Attributes'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2013353334825313)
,p_name=>'OB.COL_AVG_COL_LEN'
,p_message_text=>'Average Column Length'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2003485373825312)
,p_name=>'OB.COL_AVG_ROW_LEN'
,p_message_text=>'Average Row Length'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2003599471825312)
,p_name=>'OB.COL_BASE_NAME'
,p_message_text=>'Base Object Name'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2003659370825312)
,p_name=>'OB.COL_BASE_OWNER'
,p_message_text=>'Base Object Owner'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2003713874825312)
,p_name=>'OB.COL_BASE_TYPE'
,p_message_text=>'Base Object Type'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2003824597825312)
,p_name=>'OB.COL_BLOCKS'
,p_message_text=>'Blocks'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2003915747825312)
,p_name=>'OB.COL_BUCKETS'
,p_message_text=>'Buckets'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2004058812825312)
,p_name=>'OB.COL_CACHE_SIZE'
,p_message_text=>'Cache Size'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2004106914825312)
,p_name=>'OB.COL_COLUMNS'
,p_message_text=>'Columns'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2004272996825312)
,p_name=>'OB.COL_COLUMN_EXPRESSION'
,p_message_text=>'Column Expression'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2004450351825312)
,p_name=>'OB.COL_COLUMN_NAME'
,p_message_text=>'Column Name'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2004526185825312)
,p_name=>'OB.COL_COLUMN_POSITION'
,p_message_text=>'Column Position'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2004669525825312)
,p_name=>'OB.COL_COMMENT'
,p_message_text=>'Comment'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2004788319825312)
,p_name=>'OB.COL_COMPLETE'
,p_message_text=>'Complete'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2004833367825312)
,p_name=>'OB.COL_COMPRESSION'
,p_message_text=>'Compression'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2004940221825312)
,p_name=>'OB.COL_CONSTRAINT'
,p_message_text=>'Constraint'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2005067017825312)
,p_name=>'OB.COL_CONTENT'
,p_message_text=>'Content'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2005195349825312)
,p_name=>'OB.COL_CREATED'
,p_message_text=>'Created'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2005348853825312)
,p_name=>'OB.COL_CYCLE_FLAG'
,p_message_text=>'Cycle Flag'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2005417647825312)
,p_name=>'OB.COL_DATA_LENGTH'
,p_message_text=>'Data Length'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2005518966825312)
,p_name=>'OB.COL_DATA_PRECISION'
,p_message_text=>'Data Precision'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2005695223825312)
,p_name=>'OB.COL_DATA_SCALE'
,p_message_text=>'Data Scale'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2005713800825312)
,p_name=>'OB.COL_DATA_TYPE'
,p_message_text=>'Data Type'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2005866917825312)
,p_name=>'OB.COL_DB_LINK'
,p_message_text=>'DB Link'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2005967544825312)
,p_name=>'OB.COL_DEFAULT'
,p_message_text=>'Default'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2006000877825312)
,p_name=>'OB.COL_DELETE_RULE'
,p_message_text=>'Delete Rule'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2006174041825312)
,p_name=>'OB.COL_DENSITY'
,p_message_text=>'Density'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2006203193825312)
,p_name=>'OB.COL_DESCRIPTION'
,p_message_text=>'Description'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2006373589825312)
,p_name=>'OB.COL_DISTINCT'
,p_message_text=>'Distinct'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2006462793825312)
,p_name=>'OB.COL_DOCUMENT_COUNT'
,p_message_text=>'Document Count'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2006563724825312)
,p_name=>'OB.COL_ENDPOINT'
,p_message_text=>'SODA REST Endpoint'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2006631768825312)
,p_name=>'OB.COL_ERROR'
,p_message_text=>'Error'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2006763163825312)
,p_name=>'OB.COL_FINAL'
,p_message_text=>'Final'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2006993788825312)
,p_name=>'OB.COL_FUNCTION_STATUS'
,p_message_text=>'Function Status'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2007072267825312)
,p_name=>'OB.COL_GRANTABLE'
,p_message_text=>'Grantable'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2007142555825312)
,p_name=>'OB.COL_GRANTEE'
,p_message_text=>'Grantee'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2007230719825312)
,p_name=>'OB.COL_GRANTOR'
,p_message_text=>'Grantor'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2007372985825312)
,p_name=>'OB.COL_HOST'
,p_message_text=>'Host'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1505585825054006)
,p_name=>'OB.COL_IDENTITY'
,p_message_text=>'Identity'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2792122121539948)
,p_name=>'OB.COL_IMPORT_NAME'
,p_message_text=>'Import Name'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2007493515825312)
,p_name=>'OB.COL_INCREMENT_BY'
,p_message_text=>'Increment By'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2007549995825312)
,p_name=>'OB.COL_INDEX'
,p_message_text=>'Index'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2007688332825312)
,p_name=>'OB.COL_INDEX_NAME'
,p_message_text=>'Index Name'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2007712030825312)
,p_name=>'OB.COL_INDEX_TYPE'
,p_message_text=>'Index Type'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2007828457825312)
,p_name=>'OB.COL_INSTANTIABLE'
,p_message_text=>'Instantiable'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2007961851825312)
,p_name=>'OB.COL_INVALID'
,p_message_text=>'Invalid'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2008074430825312)
,p_name=>'OB.COL_JOB_INTERVAL'
,p_message_text=>'Job Interval'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2008224861825312)
,p_name=>'OB.COL_KEY'
,p_message_text=>'Key'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2008321281825312)
,p_name=>'OB.COL_LAST_ANALYZED'
,p_message_text=>'Last Analyzed'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2008406441825312)
,p_name=>'OB.COL_LAST_CHANGE'
,p_message_text=>'Last Change'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2008506515825312)
,p_name=>'OB.COL_LAST_MODIFIED'
,p_message_text=>'Last Modified'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2008645292825312)
,p_name=>'OB.COL_LAST_NUMBER'
,p_message_text=>'Last Number'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2008764337825312)
,p_name=>'OB.COL_LAST_REFRESH'
,p_message_text=>'Last Refresh'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2008823266825312)
,p_name=>'OB.COL_LAST_SYNC'
,p_message_text=>'Last Synchronization'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2009090707825312)
,p_name=>'OB.COL_LINE'
,p_message_text=>'Line'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2009176264825312)
,p_name=>'OB.COL_LOCAL_ATTRIBUTES'
,p_message_text=>'Local Attributes'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2009226775825312)
,p_name=>'OB.COL_LOCAL_METHODS'
,p_message_text=>'Local Methods'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2009359340825312)
,p_name=>'OB.COL_LOCATION'
,p_message_text=>'Location'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2009474159825312)
,p_name=>'OB.COL_MASTER'
,p_message_text=>'Master'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2009504018825312)
,p_name=>'OB.COL_MASTER_LINK'
,p_message_text=>'Master Link'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2009623539825312)
,p_name=>'OB.COL_MASTER_OWNER'
,p_message_text=>'Master Owner'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2009730348825312)
,p_name=>'OB.COL_MASTER_ROLLBACK'
,p_message_text=>'Master Rollback Seg.'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2009886454825312)
,p_name=>'OB.COL_MASTER_VIEW'
,p_message_text=>'Master View'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2009973489825312)
,p_name=>'OB.COL_MAX_VALUE'
,p_message_text=>'Max Value'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2010039333825312)
,p_name=>'OB.COL_METHODS'
,p_message_text=>'# of Methods'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2010196235825312)
,p_name=>'OB.COL_MIN_VALUE'
,p_message_text=>'Min Value'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2791961817538251)
,p_name=>'OB.COL_MODULE_NAME'
,p_message_text=>'Module Name'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2791741029537221)
,p_name=>'OB.COL_MODULE_OWNER'
,p_message_text=>'Module Owner'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2010293218825312)
,p_name=>'OB.COL_NAME'
,p_message_text=>'Name'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(135002483531583703)
,p_name=>'OB.COL_NEXT_SYNC'
,p_message_text=>'Next Synchronization'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2010523603825313)
,p_name=>'OB.COL_NULLABLE'
,p_message_text=>'Nullable'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2010677796825313)
,p_name=>'OB.COL_NULLS'
,p_message_text=>'Nulls'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2010757040825313)
,p_name=>'OB.COL_NUM_ROWS'
,p_message_text=>'Number of Rows'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2010833830825313)
,p_name=>'OB.COL_OBJECT_NAME'
,p_message_text=>'Object Name'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2010932127825313)
,p_name=>'OB.COL_OBJECT_OWNER'
,p_message_text=>'Object Owner'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2011060742825313)
,p_name=>'OB.COL_OBJECT_STATUS'
,p_message_text=>'Object Status'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2011156547825313)
,p_name=>'OB.COL_OBJECT_TYPE'
,p_message_text=>'Object Type'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2011278412825313)
,p_name=>'OB.COL_OBJ_COL'
,p_message_text=>'Object/Collection'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2011362822825313)
,p_name=>'OB.COL_ORDER_FLAG'
,p_message_text=>'Order Flag'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2011435929825313)
,p_name=>'OB.COL_OWNER'
,p_message_text=>'Owner'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2011521987825313)
,p_name=>'OB.COL_PARTITIONED'
,p_message_text=>'Partitioned'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2011631291825313)
,p_name=>'OB.COL_POSITION'
,p_message_text=>'Position'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2011763402825313)
,p_name=>'OB.COL_PREBUILT'
,p_message_text=>'Prebuilt'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2011913766825313)
,p_name=>'OB.COL_PREDEFINED'
,p_message_text=>'Predefined'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2012047692825313)
,p_name=>'OB.COL_PREFIX_LENGTH'
,p_message_text=>'Prefix Length'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2012160840825313)
,p_name=>'OB.COL_PRIMARY_KEY'
,p_message_text=>'Primary Key'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2012231742825313)
,p_name=>'OB.COL_PRIVILEGE'
,p_message_text=>'Privilege'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2012364338825313)
,p_name=>'OB.COL_QUERY'
,p_message_text=>'Query'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2012469351825313)
,p_name=>'OB.COL_REFERENCING_NAMES'
,p_message_text=>'Referencing Names'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2012500175825313)
,p_name=>'OB.COL_REFRESH_GROUP'
,p_message_text=>'Refresh Group'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2012648182825313)
,p_name=>'OB.COL_REFRESH_METHOD'
,p_message_text=>'Refresh Method'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2012760869825313)
,p_name=>'OB.COL_REFRESH_MODE'
,p_message_text=>'Refresh Mode'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2012803053825313)
,p_name=>'OB.COL_RELATED_CONSTRAINT'
,p_message_text=>'Related Constraint'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2012974744825313)
,p_name=>'OB.COL_RELATIONAL_VIEWS'
,p_message_text=>'Relational Views'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2013086822825313)
,p_name=>'OB.COL_RELEVANCE'
,p_message_text=>'Relevance'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(7800535782997265)
,p_name=>'OB.COL_REST_ENABLED'
,p_message_text=>'REST Enabled'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2013121737825313)
,p_name=>'OB.COL_REST_SOURCE'
,p_message_text=>'REST Source'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2013292121825313)
,p_name=>'OB.COL_ROWS'
,p_message_text=>'Rows'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2013542908825313)
,p_name=>'OB.COL_SEARCH_CONDITION'
,p_message_text=>'Search Condition'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2013673225825313)
,p_name=>'OB.COL_SEARCH_INDEX'
,p_message_text=>'Search Index Name'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2013784569825313)
,p_name=>'OB.COL_SIZE'
,p_message_text=>'Size'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2013804713825313)
,p_name=>'OB.COL_START_WITH'
,p_message_text=>'Start With'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2013959769825313)
,p_name=>'OB.COL_STATUS'
,p_message_text=>'Status'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2014071187825313)
,p_name=>'OB.COL_SUPERTYPE_NAME'
,p_message_text=>'Supertype Name'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2014185056825313)
,p_name=>'OB.COL_SUPERTYPE_OWNER'
,p_message_text=>'Supertype Owner'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2014209235825313)
,p_name=>'OB.COL_SYNONYM_NAME'
,p_message_text=>'Synonym Name'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2014314536825313)
,p_name=>'OB.COL_SYNONYM_OWNER'
,p_message_text=>'Synonym Owner'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2014427236825313)
,p_name=>'OB.COL_TABLE'
,p_message_text=>'Table'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2014541956825314)
,p_name=>'OB.COL_TABLESPACE_NAME'
,p_message_text=>'Tablespace Name'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2014621664825314)
,p_name=>'OB.COL_TABLE_NAME'
,p_message_text=>'Table Name'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2014776336825314)
,p_name=>'OB.COL_TABLE_OWNER'
,p_message_text=>'Table Owner'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2014832882825314)
,p_name=>'OB.COL_TABLE_TYPE'
,p_message_text=>'Table Type'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2014957560825314)
,p_name=>'OB.COL_TEMPORARY'
,p_message_text=>'Temporary'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2015084258825314)
,p_name=>'OB.COL_TEXT'
,p_message_text=>'Text'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2015122594825314)
,p_name=>'OB.COL_TRIGGERING_EVENT'
,p_message_text=>'Triggering Event'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2015298819825314)
,p_name=>'OB.COL_TRIGGER_NAME'
,p_message_text=>'Trigger Name'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2015310961825314)
,p_name=>'OB.COL_TRIGGER_STATUS'
,p_message_text=>'Trigger Status'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2015481885825314)
,p_name=>'OB.COL_TRIGGER_TYPE'
,p_message_text=>'Trigger Type'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2015518897825314)
,p_name=>'OB.COL_TYPE'
,p_message_text=>'Type'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2015662415825314)
,p_name=>'OB.COL_TYPE_NAME'
,p_message_text=>'Type Name'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2015728810825314)
,p_name=>'OB.COL_TYPE_OID'
,p_message_text=>'Type OID'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2015884196825314)
,p_name=>'OB.COL_UNIQUENESS'
,p_message_text=>'Uniqueness'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2015906693825314)
,p_name=>'OB.COL_UPDATABLE'
,p_message_text=>'Updatable'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2016069474825314)
,p_name=>'OB.COL_UPDATE_LOG'
,p_message_text=>'Update Log'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2016148734825314)
,p_name=>'OB.COL_UPDATE_TRIGGER'
,p_message_text=>'Update Trigger'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2016201682825314)
,p_name=>'OB.COL_USAGE'
,p_message_text=>'Usage'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2016375677825314)
,p_name=>'OB.COL_USERNAME'
,p_message_text=>'Username'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2016421374825314)
,p_name=>'OB.COL_USE_LOG'
,p_message_text=>'Can Use Log'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2008117575825312)
,p_name=>'OB.COL_VISIBILITY'
,p_message_text=>'Visibility'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2016533635825314)
,p_name=>'OB.COL_WHEN_CLAUSE'
,p_message_text=>'When Clause'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(110982115000031967)
,p_name=>'OB.CORRECT_ERRORS'
,p_message_text=>'Correct errors before saving.'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2402188315706775)
,p_name=>'OB.CREATE_DATA'
,p_message_text=>'Insert Row'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1401676602278908)
,p_name=>'OB.CREATE_FUNCTION'
,p_message_text=>'Create Function'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1401817405281044)
,p_name=>'OB.CREATE_PACKAGE'
,p_message_text=>'Create Package'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1401434269276492)
,p_name=>'OB.CREATE_PROCEDURE'
,p_message_text=>'Create Procedure'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(6401560940496359)
,p_name=>'OB.DUP_ARG_FOUND'
,p_message_text=>'Duplicate argument(s) %0 found. Please enter unique argument names.'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(6401025426482272)
,p_name=>'OB.DUP_COL_FOUND'
,p_message_text=>'Duplicate column(s) %0 found. Please enter unique column names.'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3201124927799749)
,p_name=>'OB.EDIT_DATA'
,p_message_text=>'Edit Row'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(234643963608125373)
,p_name=>'OB.EDIT_IMPORT'
,p_message_text=>'Edit Import'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1801037656867270)
,p_name=>'OB.FILTER_ADDED'
,p_message_text=>'Filter added. Enter filter.'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2000880229099437)
,p_name=>'OB.FILTER_GROUP'
,p_message_text=>'Filter %0'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25403171384294321)
,p_name=>'OB.FUNCTION'
,p_message_text=>'Function'
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(234643764570124054)
,p_name=>'OB.IMPORT_CREATED'
,p_message_text=>'Import created'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(234644549700131414)
,p_name=>'OB.IMPORT_DELETED'
,p_message_text=>'Import Deleted'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(234644334693129798)
,p_name=>'OB.IMPORT_DELETE_CONFIRM'
,p_message_text=>'Are you sure you want to delete this Import?'
,p_is_js_message=>true
,p_version_scn=>37165770887574
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(12400246073519700)
,p_name=>'OB.INSUFFICIENT_PRIVILEGES'
,p_message_text=>'The %0 schema does not have the required privileges to create this object.'
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1801224131166749)
,p_name=>'OB.INVALID'
,p_message_text=>'Invalid'
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2354515999281581)
,p_name=>'OB.INVALID_OBJECTS'
,p_message_text=>'Invalid Objects'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2643912110539056)
,p_name=>'OB.MLE.URL_COULD_NOT_FETCH'
,p_message_text=>'Could not fetch file.'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2643679253533143)
,p_name=>'OB.MLE.URL_MUST_BE_PROVIDED'
,p_message_text=>'The URL must be provided.'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(19000778534332184)
,p_name=>'OB.MOVE_DOWN'
,p_message_text=>'Move Down'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(19000530372331181)
,p_name=>'OB.MOVE_UP'
,p_message_text=>'Move Up'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1852627111904749)
,p_name=>'OB.NO_DATA'
,p_message_text=>'No data found.'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1852895262931238)
,p_name=>'OB.NO_DATA_COLUMNS'
,p_message_text=>'No columns found.'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1854600923969095)
,p_name=>'OB.NO_DATA_CONSTRAINTS'
,p_message_text=>'No constraints found.'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1853210661938419)
,p_name=>'OB.NO_DATA_ERRORS'
,p_message_text=>'No errors found.'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1853058101935344)
,p_name=>'OB.NO_DATA_GRANTS'
,p_message_text=>'No grants found.'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3473876179727379)
,p_name=>'OB.NO_DATA_IMPORTS'
,p_message_text=>'No imports found.'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1854446253965450)
,p_name=>'OB.NO_DATA_INDEX'
,p_message_text=>'No indexes found.'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1853836394953988)
,p_name=>'OB.NO_DATA_REF'
,p_message_text=>'No references to other objects found.'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1854053058957077)
,p_name=>'OB.NO_DATA_REF_BY'
,p_message_text=>'No references by other objects found.'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1855077409981432)
,p_name=>'OB.NO_DATA_REST'
,p_message_text=>'No REST synchronizations found.'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1854268959960475)
,p_name=>'OB.NO_DATA_SYNONYMS'
,p_message_text=>'No synonyms found.'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1854853628975269)
,p_name=>'OB.NO_DATA_TRIGGERS'
,p_message_text=>'No triggers found.'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1818167097605097)
,p_name=>'OB.NO_SCHEMA'
,p_message_text=>'Can''t open object in schema %0'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(16600587002064927)
,p_name=>'OB.NO_SQL'
,p_message_text=>'Enter all required fields.'
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3831258877277213)
,p_name=>'OB.OBJECTS'
,p_message_text=>'Objects'
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5400842814711239)
,p_name=>'OB.OBJECT_NAME_RESERVED'
,p_message_text=>'Entered object name <strong>%0</strong> is an Oracle reserved word. Please enter another name.'
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5400600427707334)
,p_name=>'OB.OBJECT_NAME_TOO_LONG'
,p_message_text=>'Entered Object Name is too long. Maximum allowed length is %0 bytes.'
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(7424972051959851)
,p_name=>'OB.PACKAGE'
,p_message_text=>'Package'
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25402912990293333)
,p_name=>'OB.PROCEDURE'
,p_message_text=>'Procedure'
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2402670867730182)
,p_name=>'OB.ROW_DELETED'
,p_message_text=>'Row deleted'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2402458092719554)
,p_name=>'OB.ROW_DELETE_CONFIRM'
,p_message_text=>'Are you sure you want to delete this row?'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2402810018934361)
,p_name=>'OB.ROW_INSERTED'
,p_message_text=>'Row inserted'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2016688242825314)
,p_name=>'OB.SV_COLUMN_STATISTICS'
,p_message_text=>'Column Statistics'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1807797026123910)
,p_name=>'OB.SV_CONTENTS'
,p_message_text=>'Contents'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2016836469825314)
,p_name=>'OB.SV_DATA_GUIDE'
,p_message_text=>'JSON Data Guide'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2016903170825314)
,p_name=>'OB.SV_INDEX'
,p_message_text=>'Index'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2017099365825314)
,p_name=>'OB.SV_INDEX_COLUMNS'
,p_message_text=>'Index Columns'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2017109663825314)
,p_name=>'OB.SV_META_DATA'
,p_message_text=>'Collection Meta Data'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2017208639825314)
,p_name=>'OB.SV_REFERENCED_BY'
,p_message_text=>'Referenced by'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2017357703825314)
,p_name=>'OB.SV_REFERENCES'
,p_message_text=>'References'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2017446043825314)
,p_name=>'OB.SV_REST_SYNC'
,p_message_text=>'REST Synchronizations'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2017532039825314)
,p_name=>'OB.SV_SUMMARY'
,p_message_text=>'Summary'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2017682912825314)
,p_name=>'OB.SV_SYNONYMS'
,p_message_text=>'Synonyms'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2017712919825314)
,p_name=>'OB.SV_TABLE_STATISTICS'
,p_message_text=>'Table Statistics'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2017885172825314)
,p_name=>'OB.SV_TRIGGER'
,p_message_text=>'Trigger'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2017959280825314)
,p_name=>'OB.SV_TRIGGER_COLUMNS'
,p_message_text=>'Trigger Columns'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2354269405269720)
,p_name=>'OB.TB_LABEL'
,p_message_text=>'%0 Actions'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1453528600760292)
,p_name=>'OB.TB_MORE'
,p_message_text=>'More'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2018096988825314)
,p_name=>'OB.VIEW_BODY'
,p_message_text=>'Body'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2018180799825314)
,p_name=>'OB.VIEW_CODE'
,p_message_text=>'Code'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2018225377825315)
,p_name=>'OB.VIEW_COL_CONTENTS'
,p_message_text=>'Collection Contents'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2018354847825315)
,p_name=>'OB.VIEW_CONSTRAINTS'
,p_message_text=>'Constraints'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2018427938825315)
,p_name=>'OB.VIEW_DATA'
,p_message_text=>'Data'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2019648648825315)
,p_name=>'OB.VIEW_DDL'
,p_message_text=>'DDL'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2018549114825315)
,p_name=>'OB.VIEW_DEPS'
,p_message_text=>'Dependencies'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2018659189825315)
,p_name=>'OB.VIEW_DETAILS'
,p_message_text=>'Details'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2792487507560154)
,p_name=>'OB.VIEW_ENV_IMPORTS'
,p_message_text=>'Imports'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2018723222825315)
,p_name=>'OB.VIEW_ERRORS'
,p_message_text=>'Errors'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2018856480825315)
,p_name=>'OB.VIEW_GRANTS'
,p_message_text=>'Grants'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2018989595825315)
,p_name=>'OB.VIEW_GUIDE'
,p_message_text=>'Data Guide'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2019001126825315)
,p_name=>'OB.VIEW_INDEXES'
,p_message_text=>'Indexes'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2019149236825315)
,p_name=>'OB.VIEW_MATERIALIZED_VIEW'
,p_message_text=>'Columns'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2019254681825315)
,p_name=>'OB.VIEW_META'
,p_message_text=>'Meta Data'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2019343553825315)
,p_name=>'OB.VIEW_OBJECT_DETAILS'
,p_message_text=>'Object Details'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2019499939825315)
,p_name=>'OB.VIEW_SAMPLES'
,p_message_text=>'Sample Queries'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2019540759825315)
,p_name=>'OB.VIEW_SPECIFICATION'
,p_message_text=>'Specification'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2019784223825315)
,p_name=>'OB.VIEW_STATS'
,p_message_text=>'Statistics'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2019862870825315)
,p_name=>'OB.VIEW_SYNONYMS'
,p_message_text=>'Synonyms'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2019956734825315)
,p_name=>'OB.VIEW_TABLE'
,p_message_text=>'Columns'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2020077680825315)
,p_name=>'OB.VIEW_TRIGGERS'
,p_message_text=>'Triggers'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2020173704825315)
,p_name=>'OB.VIEW_UI_DEFS'
,p_message_text=>'UI Defaults'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2020254147825315)
,p_name=>'OB.VIEW_VIEW'
,p_message_text=>'Columns'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3902048964406116)
,p_name=>'OB_TREE.DATABASE_LINK_PLURAL'
,p_message_text=>'Database Links'
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3901643500403927)
,p_name=>'OB_TREE.FUNCTION_PLURAL'
,p_message_text=>'Functions'
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3900657315395883)
,p_name=>'OB_TREE.INDEX_PLURAL'
,p_message_text=>'Indexes'
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3902211473407400)
,p_name=>'OB_TREE.MATERIALIZED_VIEW_PLURAL'
,p_message_text=>'Materialized Views'
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3600976273704134)
,p_name=>'OB_TREE.MLE_ENVIRONMENT_PLURAL'
,p_message_text=>'MLE Environments'
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3601153986708784)
,p_name=>'OB_TREE.MLE_MODULE_PLURAL'
,p_message_text=>'MLE Modules - JavaScript'
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3901261278400365)
,p_name=>'OB_TREE.PACKAGE_PLURAL'
,p_message_text=>'Packages'
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3901494070402832)
,p_name=>'OB_TREE.PROCEDURE_PLURAL'
,p_message_text=>'Procedures'
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3900819609397962)
,p_name=>'OB_TREE.SEQUENCE_PLURAL'
,p_message_text=>'Sequences'
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3902643700409933)
,p_name=>'OB_TREE.SODA_COLLECTION_PLURAL'
,p_message_text=>'SODA Collections'
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3902476981408554)
,p_name=>'OB_TREE.SYNONYM_PLURAL'
,p_message_text=>'Synonyms'
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3900244234392486)
,p_name=>'OB_TREE.TABLE_PLURAL'
,p_message_text=>'Tables'
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3901849450404939)
,p_name=>'OB_TREE.TRIGGER_PLURAL'
,p_message_text=>'Triggers'
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3901022396399060)
,p_name=>'OB_TREE.TYPE_PLURAL'
,p_message_text=>'Types'
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3900485389393893)
,p_name=>'OB_TREE.VIEW_PLURAL'
,p_message_text=>'Views'
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1440178356030480)
,p_name=>'ODG.BLUEPRINT.TABLE_ERROR'
,p_message_text=>'Error in table %0: %1'
,p_version_scn=>56731448
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2215158266643539)
,p_name=>'ODG.BLUEPRINT_ERRORS'
,p_message_text=>'Could not save %0: %1. %2'
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(8052220435709409)
,p_name=>'ODG.BLUEPRINT_SAVED'
,p_message_text=>'Blueprint Saved'
,p_is_js_message=>true
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3015187357045317)
,p_name=>'ODG.PE.ADVANCED'
,p_message_text=>'Advanced'
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3007671235963892)
,p_name=>'ODG.PE.BLUEPRINT'
,p_message_text=>'Blueprint'
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3804705192527799)
,p_name=>'ODG.PE.BLUEPRINT.DESCRIPTION.HELP'
,p_message_text=>'Enter a description for this blueprint.'
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(259741959839369660)
,p_name=>'ODG.PE.BLUEPRINT.DISPLAY_NAME.HELP'
,p_message_text=>'Enter a user-friendly blueprint name.'
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3704744807443876)
,p_name=>'ODG.PE.BLUEPRINT.NAME.HELP'
,p_message_text=>'Enter a unique name for this blueprint. The name will be automatically capitalized and special characters will be removed.'
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3804966557528835)
,p_name=>'ODG.PE.BLUEPRINT.SCHEMA.HELP'
,p_message_text=>'The blueprint schema. You can use existing tables visible in this schema to generate data into tables in this blueprint.'
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5205228542411197)
,p_name=>'ODG.PE.BLUEPRINT_COL'
,p_message_text=>'Blueprint Column'
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3018187812120330)
,p_name=>'ODG.PE.BLUEPRINT_DESIGNER'
,p_message_text=>'Blueprint Designer'
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(73954850321753693)
,p_name=>'ODG.PE.BLUEPRINT_SOURCE'
,p_message_text=>'Blueprint Source'
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5205055762409889)
,p_name=>'ODG.PE.BLUEPRINT_TBL'
,p_message_text=>'Blueprint Table'
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1406913860547486)
,p_name=>'ODG.PE.BLUEPRINT_TREE_NAME'
,p_message_text=>'Blueprint'
,p_version_scn=>21942881
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3010923780014733)
,p_name=>'ODG.PE.BUILT_IN'
,p_message_text=>'Built-In'
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(73955042455761517)
,p_name=>'ODG.PE.CLICK_TO_SELECT_BLUEPRINT_DS'
,p_message_text=>'Select a Table and Column from this Blueprint'
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(48061688906241109)
,p_name=>'ODG.PE.CLICK_TO_SELECT_CUSTOM_DS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Select a Custom Data Source',
''))
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3810951800555884)
,p_name=>'ODG.PE.COL.DISPLAY_NAME.HELP'
,p_message_text=>'Enter a user-friendly column name.'
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3806335325535707)
,p_name=>'ODG.PE.COL.DS.BLUEPRINT.HELP'
,p_message_text=>'References an existing column in another table in this blueprint. This option is available when there are two or more tables.'
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3807190669539389)
,p_name=>'ODG.PE.COL.DS.BUILTIN.FORMAT_MASK.HELP'
,p_message_text=>'Enter a format for the dates to be generated. Default format used: ''YYYY-MM-DD"T"HH24:MI:SS"Z"'''
,p_version_scn=>37165770887597
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3806545647536562)
,p_name=>'ODG.PE.COL.DS.BUILTIN.HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>References an existing built-in data source. Depending on the built-in data type, other customizations are available.</p>',
'<p>For DATE data types, you can customize a <strong>Minimum Date</strong>, <strong>Maximum Date</strong> and <strong>Format Mask</strong>.</p>',
'<p>For NUMBER data types, you can customize a <strong>Minimum Value</strong>, <strong>Maximum Value</strong> and <strong>Value Precision</strong>.</p>',
'<p>When mixed with multi-value options, you can generate more than one built-in value per row.</p>',
''))
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3806910853538618)
,p_name=>'ODG.PE.COL.DS.BUILTIN.MAX_DATE.HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Enter a date you want the dates to be generated equal to or less than.</p>',
'<p>',
'The date string will be converted to a date object using the format mask specified. If none is provided, the default format mask is: YYYY-MM-DD"T"HH24:MI:SS"Z"</p>'))
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3807574829540906)
,p_name=>'ODG.PE.COL.DS.BUILTIN.MAX_VAL.HELP'
,p_message_text=>'Enter a value to generate numbers equal to or less than.'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3806724401537956)
,p_name=>'ODG.PE.COL.DS.BUILTIN.MIN_DATE.HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Enter a date you want the dates to be generated equal to or greater than.</p>',
'<p>The date string will be converted to a date object using the format mask specified. If none is provided, the default format mask is: YYYY-MM-DD"T"HH24:MI:SS"Z"</p>'))
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3807327600540009)
,p_name=>'ODG.PE.COL.DS.BUILTIN.MIN_VAL.HELP'
,p_message_text=>'Enter a value to generate numbers equal to or greater than.'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3807732018541674)
,p_name=>'ODG.PE.COL.DS.BUILTIN.PRECISION.HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Enter <strong>0</strong> if you want no decimal values.</p>',
'<p>Enter -1 to round generated numbers to ten.</p>',
'<p>Enter any positive integer as the number of decimal places desired.</p>',
''))
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3807915379544606)
,p_name=>'ODG.PE.COL.DS.CUSTOM.HELP'
,p_message_text=>'References an existing custom data source in this blueprint. Custom Data Sources obtain data from existing tables in the current schema or from a SQL Query.'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3808165192545429)
,p_name=>'ODG.PE.COL.DS.CUSTOM_COLUMN.HELP'
,p_message_text=>'References a column from an existing custom data source in this blueprint. Custom Data Sources obtain data from existing tables in the current schema or from a SQL Query.'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3806144869534773)
,p_name=>'ODG.PE.COL.DS.HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Choose a Data Source Type:</p>',
'<ul>',
'    <li><strong>Blueprint:</strong> Creates a reference to a column in another table in this blueprint. This option is available when there are two or more tables.</li>',
'    <li><strong>Custom Data Source:</strong> References data in a table or in a SQL query. This option is available when there are data sources added to this blueprint.</li>',
'    <li><strong>Built In:</strong> Generates real-world sample data from a wide variety of categories already included in APEX.<br/> Built-in data can be related to each other. Example: if a column uses location.city and another uses location.state, '
||'the city will correlate with the state selected.</br>Can be used with multi-value options.</li>',
'    <li><strong>Inline:</strong> Allows you to add custom values each with its own frequency. The frequency indicates how often the related value appears in the generated data, when used with multi-value options.</li>',
'    <li><strong>Sequence:</strong> Creates a numeric sequence with customizable start value and interval between successive numbers (increment).</li>',
'    <li><strong>Formula:</strong> You can use PL/SQL expressions to reference other columns in this table and apply basic transformations.</li>',
'</ul>'))
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3808391401546122)
,p_name=>'ODG.PE.COL.DS.INLINE.HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Add custom values each with its own frequency.</p>',
'<p>The <strong>frequency</strong> indicates how often this value appears compared to other values in the list. The higher the frequency, the more often this value will occur in the generated data.</p>',
'<p>Example.: If you provide <code>ValueA,1</code> and <code>ValueB,3</code>, ValueA will occur 1/4 rows and ValueB will occur 3/4 rows.</p>',
'<p>When combined with <strong>Multi Value</strong> set to "YES", the frequency will also affect how often a value occurs on each row.</p>',
'<p>Example: an <strong>inline</strong> value of <code>JavaScript,4;PLSQL,2;CSS,3</code> could generate the following output data for this column:<br/><br/>',
'row1: Javascript,PLSQL<br/>',
'row2: Javascript,CSS<br/>',
'row3: Javascript,PLSQL,CSS<br/>',
'row4: Javascript,CSS<br/>',
'</p>',
'<p><strong>Note:</strong> the frequency value is an approximation, so it might not produce the exact distribution.</p>'))
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3808772209547508)
,p_name=>'ODG.PE.COL.DS.SEQUENCE.INCREMENT.HELP'
,p_message_text=>'Specify the interval between sequence numbers.'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3808569225546833)
,p_name=>'ODG.PE.COL.DS.SEQUENCE.START_WITH.HELP'
,p_message_text=>'<p>Set the number to be used as the first value in the sequence.</p>'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3809125297549403)
,p_name=>'ODG.PE.COL.FORMULA.HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Define a PL/SQL formula to transform the column output data. Use the <code>{column_name}</code> syntax to reference column values from the table.</p>',
'<p>Example that produces custom emails, referencing col1 and col2 from the same table:</p>',
'<p><code>lower({col1}||''.''||{col2}||''@company.com'' )</code></p>'))
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3811399271557149)
,p_name=>'ODG.PE.COL.LANG.HELP'
,p_message_text=>'This indicates the language used for generating data for this column.'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3811507343557792)
,p_name=>'ODG.PE.COL.MAX_LENGTH.HELP'
,p_message_text=>'Enter the maximum number of characters to generate for this column.'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3809998958552483)
,p_name=>'ODG.PE.COL.MULTI_VALUE.DELIMITER.HELP'
,p_message_text=>'Define a delimiter to separate each value in this column.'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3809721906551359)
,p_name=>'ODG.PE.COL.MULTI_VALUE.FORMAT.HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Select an output format option:</p>',
'<ul>',
'    <li><strong>Delimited:</strong> You can use a custom delimiter to separate values for this column generated data.</li>',
'    <li><strong>JSON:</strong> This column generated data will be in JavaScript object notation (JSON). Example: <code>{"column_name":["output1","output2","output3"]}</code></li>',
'</ul>'))
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3808922395548233)
,p_name=>'ODG.PE.COL.MULTI_VALUE.HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>When enabled, values can be repeated in generated data.</p>',
'<p>When disabled, built in data types will always generate distinct column values. Inline data types will be distinct as long as all values appear only once.</p>',
''))
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3810557480554477)
,p_name=>'ODG.PE.COL.MULTI_VALUE.MAX_ENTRIES.HELP'
,p_message_text=>'Determine the maximum amount of values for this column.'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3810399480553742)
,p_name=>'ODG.PE.COL.MULTI_VALUE.MIN_ENTRIES.HELP'
,p_message_text=>'Determine the minimum amount of values for this column.'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3810740767555141)
,p_name=>'ODG.PE.COL.MULTI_VALUE.PARTITION_BY.HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>You can select another built-in from the same group of the built-in selected above.</p>',
'<p>For instance, by selecting built-in car.model for a column and partition by car.make ensures the car models correlate the car maker.</p>'))
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3810168229553102)
,p_name=>'ODG.PE.COL.MULTI_VALUE.UNIQUE.HELP'
,p_message_text=>'When enabled, each value in this column will not repeat. Otherwise, duplicates are allowed.'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3805929267533751)
,p_name=>'ODG.PE.COL.NAME.HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Enter a name for this column. If its name matches an existing column in a table with the same name in the current schema, you can run insert statements directly to populate it with generated data.',
''))
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3809559973550681)
,p_name=>'ODG.PE.COL.PERCENT_BLANK.HELP'
,p_message_text=>'Define a number between 0 and 100 to set the percentage of NULL values that will be generated for this column.'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3809316940550074)
,p_name=>'ODG.PE.COL.REQUIRED.HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Marks this column as required, therefore it will not generate NULL values.</p>',
'<p>When set to ''NO'', a number from 0 to 100 can be set in the <strong>Percent Blank</strong> property to indicate how many NULL values will be generated.</p>'))
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3811134271556539)
,p_name=>'ODG.PE.COL.SEQ.HELP'
,p_message_text=>'This auto-generated value dictates the order in which columns get their data generated.'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3010120837995002)
,p_name=>'ODG.PE.COLUMN'
,p_message_text=>'Column'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(255763086717633849)
,p_name=>'ODG.PE.COMMENT'
,p_message_text=>'Comment'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3409812959168233)
,p_name=>'ODG.PE.CONFIRM_DELETE'
,p_message_text=>'Are you sure you want to delete %0 "%1"?'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4801902788205738)
,p_name=>'ODG.PE.CONTEXT.ADD_COLUMN'
,p_message_text=>'Add Column'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4802126092208655)
,p_name=>'ODG.PE.CONTEXT.ADD_DATA_SOURCE'
,p_message_text=>'Add Data Source'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4801729899173838)
,p_name=>'ODG.PE.CONTEXT.ADD_TABLE'
,p_message_text=>'Add Table'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4802564439213634)
,p_name=>'ODG.PE.CONTEXT.DELETE_COLUMN'
,p_message_text=>'Delete Column'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4802707119215031)
,p_name=>'ODG.PE.CONTEXT.DELETE_DATA_SOURCE'
,p_message_text=>'Delete Data Source'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4802342069211455)
,p_name=>'ODG.PE.CONTEXT.DELETE_TABLE'
,p_message_text=>'Delete Table'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4802902441219867)
,p_name=>'ODG.PE.CONTEXT.PREVIEW_DATA'
,p_message_text=>'Preview Data'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(54969233954390661)
,p_name=>'ODG.PE.CORRECT_BEFORE_SAVE'
,p_message_text=>'Before you can save, preview, or generate data, correct the following errors in the blueprint: %0'
,p_is_js_message=>true
,p_version_scn=>15350308
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3008762075983330)
,p_name=>'ODG.PE.CREATED_BY'
,p_message_text=>'Created By'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3008574225981837)
,p_name=>'ODG.PE.CREATED_ON'
,p_message_text=>'Created On'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3010780907011780)
,p_name=>'ODG.PE.CUSTOM_DATA_SOURCE'
,p_message_text=>'Custom Data Source'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3010523953008368)
,p_name=>'ODG.PE.DATA_SOURCE'
,p_message_text=>'Data Source'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3811768862558462)
,p_name=>'ODG.PE.DATA_SOURCE.NAME.HELP'
,p_message_text=>'Enter a name for this data source.'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3812569166561276)
,p_name=>'ODG.PE.DATA_SOURCE.SQL_QUERY.HELP'
,p_message_text=>'<p>Add a valid SQL Query with named columns so they can be selected as a custom data source.</p>'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3812106237560038)
,p_name=>'ODG.PE.DATA_SOURCE.TABLE.HELP'
,p_message_text=>'Name of an existing table in the schema.'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3811972005559266)
,p_name=>'ODG.PE.DATA_SOURCE.TYPE.HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Select a source type:</p>',
'<ul>',
'    <li><strong>Table</strong> requires an existing table in the schema. Optional Where clause can be added.</li>',
'    <li><strong>SQL Query</strong> requires a valid SQL query.</li>',
'</ul>'))
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3812307876560607)
,p_name=>'ODG.PE.DATA_SOURCE.WHERE_CLAUSE.HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Optionally add a where clause to filter the data from the source table. Do not include the where clause itself.</p>',
'<p>Example: <code>deptno <= 20</code> will result in</p>',
'<p><code>select * </br>from dept</br>where deptno <= 20</code></p>'))
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3015516427047421)
,p_name=>'ODG.PE.DATA_SOURCE_NAME'
,p_message_text=>'Data Source Name'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3017690542110364)
,p_name=>'ODG.PE.DELIMITED'
,p_message_text=>'Delimited'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3013539606035369)
,p_name=>'ODG.PE.DELIMITER'
,p_message_text=>'Delimiter'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3008337300977400)
,p_name=>'ODG.PE.DESCRIPTION'
,p_message_text=>'Description'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3009569132990379)
,p_name=>'ODG.PE.DISPLAY_NAME'
,p_message_text=>'Display Name'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3509882244182126)
,p_name=>'ODG.PE.ERROR_DELETE'
,p_message_text=>'Could not delete blueprint object %0. Output: %1'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3017350963100139)
,p_name=>'ODG.PE.EXISTING_TABLE'
,p_message_text=>'Existing Table'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3013395967034377)
,p_name=>'ODG.PE.FORMAT'
,p_message_text=>'Format'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3011522908021160)
,p_name=>'ODG.PE.FORMAT_MASK'
,p_message_text=>'Format Mask'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3014536648041622)
,p_name=>'ODG.PE.FORMULA'
,p_message_text=>'Formula'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4100873143349896)
,p_name=>'ODG.PE.HELP'
,p_message_text=>'<h3>Blueprint Designer</h3><p>Use the tree view on the left to select a blueprint, table, column or custom data source object and modify its attributes.</p><p>You can create new tables, columns and custom data sources using the context menu too.</p><'
||'p>Using the Generate Data and Preview Data buttons, you can preview data for the tables and columns, and export the data to a JSON, CSV, or SQL file. If a table exists in the schema with the same name, data can be inserted into the corresponding colu'
||'mns.</p>'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3012730715030085)
,p_name=>'ODG.PE.INCREMENT'
,p_message_text=>'Increment'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3012360030026898)
,p_name=>'ODG.PE.INLINE'
,p_message_text=>'Inline'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3010341155996794)
,p_name=>'ODG.PE.LANGUAGE'
,p_message_text=>'Language'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3011338806019784)
,p_name=>'ODG.PE.MAX_DATE'
,p_message_text=>'Maximum Date'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3014164377039273)
,p_name=>'ODG.PE.MAX_ENTRIES'
,p_message_text=>'Maximum Entries'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3015343551046283)
,p_name=>'ODG.PE.MAX_LENGTH'
,p_message_text=>'Maximum Length'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3011902882024649)
,p_name=>'ODG.PE.MAX_VALUE'
,p_message_text=>'Maximum Value'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3011134524017445)
,p_name=>'ODG.PE.MIN_DATE'
,p_message_text=>'Minimum Date'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3013991405038057)
,p_name=>'ODG.PE.MIN_ENTRIES'
,p_message_text=>'Minimum Entries'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3011739096022733)
,p_name=>'ODG.PE.MIN_VALUE'
,p_message_text=>'Minimum Value'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3012965942031265)
,p_name=>'ODG.PE.MULTI_VALUE'
,p_message_text=>'Multi Value'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3013131342033377)
,p_name=>'ODG.PE.MULTI_VALUE_OPTIONS'
,p_message_text=>'Multi Value Options'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3007978157972442)
,p_name=>'ODG.PE.NAME'
,p_message_text=>'Name'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3017808319113916)
,p_name=>'ODG.PE.NO_PARTITION'
,p_message_text=>'No Partition'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3009782277991869)
,p_name=>'ODG.PE.NUM_ROWS'
,p_message_text=>'Number of Rows'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3014350987040561)
,p_name=>'ODG.PE.PARTITION_BY'
,p_message_text=>'Partition By'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3014984132043844)
,p_name=>'ODG.PE.PERCENT_BLANK'
,p_message_text=>'Percent Blank'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4201049819877724)
,p_name=>'ODG.PE.REDIRECT'
,p_message_text=>'Go to Blueprints'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3014796346042764)
,p_name=>'ODG.PE.REQUIRED'
,p_message_text=>'Required'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3016954438076797)
,p_name=>'ODG.PE.RETURN_TYPE'
,p_message_text=>'Return Type'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3008155540975880)
,p_name=>'ODG.PE.SCHEMA'
,p_message_text=>'Schema'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(255763867714642519)
,p_name=>'ODG.PE.SEARCH'
,p_message_text=>'Search'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3009957558993237)
,p_name=>'ODG.PE.SEQUENCE'
,p_message_text=>'Sequence'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3016161362050745)
,p_name=>'ODG.PE.SQL_QUERY'
,p_message_text=>'SQL Query'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3012548323028349)
,p_name=>'ODG.PE.START_WITH'
,p_message_text=>'Start With'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3009370563987035)
,p_name=>'ODG.PE.TABLE'
,p_message_text=>'Table'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3805340060531043)
,p_name=>'ODG.PE.TABLE.DISPLAY_NAME.HELP'
,p_message_text=>'Enter a user-friendly table name.'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1403411887644831)
,p_name=>'ODG.PE.TABLE.NAME.ERROR'
,p_message_text=>'The table name should not contain spaces.'
,p_is_js_message=>true
,p_version_scn=>22249552
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3805141919529799)
,p_name=>'ODG.PE.TABLE.NAME.HELP'
,p_message_text=>'Enter a name for this table. If its name matches an existing table in the current schema, you can run insert statements to directly populate its columns with generated data.'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(54970540922554277)
,p_name=>'ODG.PE.TABLE.NUM_ROWS.ERROR'
,p_message_text=>'The maximum number of rows allowed is 500,000.'
,p_is_js_message=>true
,p_version_scn=>15141300
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3805589614531940)
,p_name=>'ODG.PE.TABLE.NUM_ROWS.HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Enter the number of rows of data to generate for this table. This number can be scaled later to generate fewer or more rows of data.</p>',
'<p>The maximum number of rows allowed is 500,000</p>'))
,p_version_scn=>15141260
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3805712164532877)
,p_name=>'ODG.PE.TABLE.SEQ.HELP'
,p_message_text=>'This auto-generated value dictates the order in which tables get their data generated.'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(255762216927565243)
,p_name=>'ODG.PE.TABLES'
,p_message_text=>'Tables'
,p_is_js_message=>true
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3015951900049423)
,p_name=>'ODG.PE.TABLE_NAME'
,p_message_text=>'Table Name'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3015792300048322)
,p_name=>'ODG.PE.TYPE'
,p_message_text=>'Type'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(309972573244004937)
,p_name=>'ODG.PE.UNABLE_TO_DELETE.BODY'
,p_message_text=>'<p>The <code>%0</code> %1 is currently referenced by:</p><code>%2</code><br><br><p>Please remove all references to this %3 first and try again.</p>'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(309972364279001653)
,p_name=>'ODG.PE.UNABLE_TO_DELETE.TITLE'
,p_message_text=>'Unable to delete %0'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3013711233036981)
,p_name=>'ODG.PE.UNIQUE'
,p_message_text=>'Unique'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3009121003985784)
,p_name=>'ODG.PE.UPDATED_BY'
,p_message_text=>'Updated By'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3008926794984602)
,p_name=>'ODG.PE.UPDATED_ON'
,p_message_text=>'Updated On'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3012135600025816)
,p_name=>'ODG.PE.VALUE_PRECISION'
,p_message_text=>'Value Precision'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(255762631051630238)
,p_name=>'ODG.PE.VIEWS'
,p_message_text=>'Views'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3016309169052030)
,p_name=>'ODG.PE.WHERE_CLAUSE'
,p_message_text=>'Where Clause'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5907526340473557)
,p_name=>'PE.CODE_EDITOR'
,p_message_text=>'Code Editor: %0'
,p_is_js_message=>true
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5906046830303871)
,p_name=>'PE.LIST_OF_VALUES'
,p_message_text=>'List of Values %0'
,p_is_js_message=>true
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(240658061184279133)
,p_name=>'PE.NO_COMPONENTS_SELECTED'
,p_message_text=>'No components currently selected'
,p_is_js_message=>true
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5905619355298052)
,p_name=>'PE.PICK'
,p_message_text=>'Pick %0'
,p_is_js_message=>true
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2051332710059484)
,p_name=>'QUICKSQL.ABOUT'
,p_message_text=>'About Quick SQL'
,p_version_scn=>45129633
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(288106152097340154)
,p_name=>'QUICKSQL.ABOUT.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Use Quick SQL to rapidly create a relational data model from a simple text specification. With minimal typing, you can instantly generate the SQL commands to create tables, views, triggers, index structures, and sample data. While not a replacemen'
||'t for formal data modeling, it''s a lightning-fast way to produce a SQL script you can later evolve as needed.</p>',
'',
'<p>Top Use Cases:',
'<ul>',
'  <li>Quickly create robust data models</li>',
'  <li>Save Quick SQL shorthand as a model to adapt or use later</li>',
'  <li>Easily generate sample data</li>',
'  <li>Learn SQL syntax using provided examples</li>',
'</ul>',
'</p>'))
,p_version_scn=>40145885
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184668194170428798)
,p_name=>'QUICKSQL.APEX_SETTING_PART1'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Controls whether audit column triggers use the APEX-aware expression to set the <code>created_by</code> and <code>updated_by</code> column values:',
''))
,p_version_scn=>39913246
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2055378505438736)
,p_name=>'QUICKSQL.APEX_SETTING_PART2'
,p_message_text=>'When not enabled the following function is used:'
,p_version_scn=>45137876
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184673724980577946)
,p_name=>'QUICKSQL.API_SETTING'
,p_message_text=>'Generates PL/SQL package API for each table to query, insert, update, and delete its data.'
,p_version_scn=>39913334
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184682076856629834)
,p_name=>'QUICKSQL.AUDITCOLS'
,p_message_text=>'Audits changes for each table in <code>created</code>, <code>created_by</code>, <code>updated</code>, <code>updated_by</code> columns using a trigger.'
,p_version_scn=>39913430
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184687133295708234)
,p_name=>'QUICKSQL.COMPRESS_SETTING'
,p_message_text=>'Compresses each table''s data to optimize space.'
,p_version_scn=>39913663
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184688894599736074)
,p_name=>'QUICKSQL.CREATEDBYCOL_SETTING'
,p_message_text=>'Overrides default audit column name for user who created a row.'
,p_version_scn=>39930075
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184689027075742257)
,p_name=>'QUICKSQL.CREATED_SETTING'
,p_message_text=>'Overrides default audit column name for when row was created.'
,p_version_scn=>39914054
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184694962019798352)
,p_name=>'QUICKSQL.DATE_SETTING'
,p_message_text=>'Overrides default datatype for dates. Valid values are:'
,p_version_scn=>39914076
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184707889930819644)
,p_name=>'QUICKSQL.DB_SETTING'
,p_message_text=>'Sets database version compatibility for generated SQL. Valid values:'
,p_version_scn=>39927395
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2055176741436415)
,p_name=>'QUICKSQL.DEFAULT'
,p_message_text=>'Default'
,p_version_scn=>45137820
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2053163403402822)
,p_name=>'QUICKSQL.DEPARTMENTSANDEMPLOYEES'
,p_message_text=>'Departments and Employees'
,p_version_scn=>45137037
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(713113287843203492)
,p_name=>'QUICKSQL.DEPARTMENTSANDEMPLOYEES_DESC'
,p_message_text=>'Includes DEPARTMENTS and EMPLOYEES tables with an additional EMP_V join view.  Generates random data (/INSERT).  Adds a NOT NULL constraint (/NN).  Defines tables, columns and child tables using indented lists. Illustrates how primary and foreign key'
||' columns get automatically added.'
,p_version_scn=>39380206
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2054982149434711)
,p_name=>'QUICKSQL.DESCRIPTION'
,p_message_text=>'Description'
,p_version_scn=>45137760
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3401027774241468)
,p_name=>'QUICKSQL.DIAGRAM_TITLE'
,p_message_text=>'Diagram'
,p_is_js_message=>true
,p_version_scn=>47409286
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184718810726850774)
,p_name=>'QUICKSQL.DROP_SETTING'
,p_message_text=>'Includes commands to initially drop each database object.'
,p_version_scn=>39919216
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(7402670978443803)
,p_name=>'QUICKSQL.EDITIONABLE'
,p_message_text=>'Enables PL/SQL triggers and packages to be editionable.'
,p_version_scn=>39919366
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2056117639487976)
,p_name=>'QUICKSQL.EDITIONABLE_SETTING'
,p_message_text=>'When generating PL/SQL objects including triggers and packages make these editionable.'
,p_version_scn=>45140672
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2053368280408404)
,p_name=>'QUICKSQL.EMPLOYEESKILLS'
,p_message_text=>'Employee Skills'
,p_version_scn=>45137111
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(713112726666196735)
,p_name=>'QUICKSQL.EMPLOYEESKILLS.DESC'
,p_message_text=>'Includes DEPARTMENTS, EMPLOYEES, and SKILLS tables using indentation to identify parent and child tables.  Specifies a SQL datatype (VC255). Generates ten rows of random data (/INSERT) and provides example values (/VALUES). Defines legal values with '
||'a check constraint (/CHECK). Illustrates adding a column comment in square brackets.'
,p_version_scn=>39385565
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2052905490086499)
,p_name=>'QUICKSQL.EXAMPLE'
,p_message_text=>'Example'
,p_version_scn=>45130088
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184955470455149614)
,p_name=>'QUICKSQL.GENPK_SETTING'
,p_message_text=>'Generates an <code>ID</code> primary key column for each table.'
,p_version_scn=>39925124
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2051579609060907)
,p_name=>'QUICKSQL.GETTING_STARTED'
,p_message_text=>'Getting Started'
,p_version_scn=>45129652
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(288107368887373395)
,p_name=>'QUICKSQL.GETTING_STARTED.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>SQL is generated automatically in the SQL panel upon typing. Enter parent table names at the start of a line. Add column names, one per line, following the table they belong to using a uniform indentation of 2 or more spaces. Primary keys are gene'
||'rated automatically. Create parent/child relationships by simply indenting child tables under parent tables, or define any foreign key relationships needed using the <code>/fk</code> column directive. By default, relationships prevent deletion of ref'
||'erenced rows. However, to automatically delete child rows when a parent row is deleted, add the <code>/cascade</code> directive to the child table or child foreign key column.</p>',
'',
'<p>Unqualified columns default to a <code>varchar2</code> datatype. To specify a different type, add <code>num</code>, <code>int</code>, or <code>date</code> after the column name, separated by a space. If you don''t explicitly specify a type, one may'
||' be deduced from the English text in the column name. For example, if the column name contains the word "date" then it will be a <code>date</code> datatype, or if the column name contains the word "num" or "number" it will be a <code>number</code> da'
||'tatype. To specify a specific <code>varchar2</code> length enter <code>vc<em>NN</em></code> where <code><em>NN</em></code> is the length of the <code>varchar2</code>. Object names are formatted automatically, replacing spaces with underscores, so you'
||' can use spaces in column and table names.</p>',
'',
'<p>Click the Settings button to view many generation options. You can easily add "Audit Columns" to track who created and last updated a given row and when. Enable a row version column to simplify lost update detection since its value automatically i'
||'ncrements by one on each row update.  Generate a PL/SQL package API for each table with procedures to query, insert, update, and delete rows.</p>'))
,p_version_scn=>37166084578110
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(725112430983910509)
,p_name=>'QUICKSQL.HELP.API'
,p_message_text=>'Generates PL/SQL package API to query, insert, update, and delete data.'
,p_is_js_message=>true
,p_version_scn=>45140910
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(725112639931916262)
,p_name=>'QUICKSQL.HELP.AUDIT'
,p_message_text=>'Audits changes with Oracle auditing (e.g. <code>audit all on <em>table_name</em></code>)'
,p_is_js_message=>true
,p_version_scn=>45140947
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(725112868872923441)
,p_name=>'QUICKSQL.HELP.AUDITCOLS'
,p_message_text=>'Audits changes in <code>created</code>, <code>created_by</code>, <code>updated</code>, <code>updated_by</code> columns using a trigger.'
,p_is_js_message=>true
,p_version_scn=>45140976
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(725110182018829848)
,p_name=>'QUICKSQL.HELP.BETWEEN'
,p_message_text=>'Constrains value to an inclusive range (e.g. <code>/between 1 and 100</code>)'
,p_is_js_message=>true
,p_version_scn=>45140992
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2054186111421462)
,p_name=>'QUICKSQL.HELP.CASCADE'
,p_message_text=>'Auto-deletes rows when parent row is deleted.'
,p_is_js_message=>true
,p_version_scn=>45141008
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(725107159626792263)
,p_name=>'QUICKSQL.HELP.CHECK'
,p_message_text=>'Provides case-sensitive list of only allowed values (e.g. <code>/check Yes, No</code>)'
,p_is_js_message=>true
,p_version_scn=>45141033
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(185257284050410232)
,p_name=>'QUICKSQL.HELP.COLPREFIX'
,p_message_text=>'Prefixes all column names in the table with this value.'
,p_is_js_message=>true
,p_version_scn=>45141058
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2051944895066695)
,p_name=>'QUICKSQL.HELP.COLUMN_NAME'
,p_message_text=>'Column Name'
,p_is_js_message=>true
,p_version_scn=>45141074
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(725111739646857312)
,p_name=>'QUICKSQL.HELP.COMMENTS'
,p_message_text=>'Annotates model with comments using square brackets or dash dash'
,p_is_js_message=>true
,p_version_scn=>45141091
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(725113060400927845)
,p_name=>'QUICKSQL.HELP.COMPRESSED'
,p_message_text=>'Compresses the data to optimize space.'
,p_is_js_message=>true
,p_version_scn=>45141107
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(725107457114804968)
,p_name=>'QUICKSQL.HELP.CONSTANT'
,p_message_text=>'Uses a constant value while generating data (e.g. <code>/constant NYC</code>)'
,p_is_js_message=>true
,p_version_scn=>45141126
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(574808573766447382)
,p_name=>'QUICKSQL.HELP.DEFAULT'
,p_message_text=>'Specifies value to insert if column is missing or null.'
,p_is_js_message=>true
,p_version_scn=>45141142
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2054557398428227)
,p_name=>'QUICKSQL.HELP.FILE_DATATYPE'
,p_message_text=>'Adds a BLOB column and _FILENAME, _CHARSET, _MIMETYPE, _LASTUPD columns that enhance the ability for file download via a browser.'
,p_is_js_message=>true
,p_version_scn=>45141158
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(725111363719847509)
,p_name=>'QUICKSQL.HELP.FK'
,p_message_text=>'Defines foreign key relationship to another table (e.g. <code>/references <em>table_name</em></code>)'
,p_is_js_message=>true
,p_version_scn=>45141194
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(725111096243842314)
,p_name=>'QUICKSQL.HELP.HIDDEN'
,p_message_text=>'Hides value from appearing in results of <code>select * from <em>table_name</em></code>'
,p_is_js_message=>true
,p_version_scn=>45141210
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(460328015703763545)
,p_name=>'QUICKSQL.HELP.INDEX'
,p_message_text=>'Creates an index to speed up searches.'
,p_is_js_message=>true
,p_version_scn=>45141229
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(725113535941943386)
,p_name=>'QUICKSQL.HELP.INSERT'
,p_message_text=>'Inserts <strong><em>NN</em></strong> (&le; 1000) rows of example data (e.g. <code>/insert 20</code>)'
,p_is_js_message=>true
,p_version_scn=>45141245
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2052306055078294)
,p_name=>'QUICKSQL.HELP.LOWER'
,p_message_text=>'Forces column values to lower case'
,p_is_js_message=>true
,p_version_scn=>45141261
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2054314438426098)
,p_name=>'QUICKSQL.HELP.NNN'
,p_message_text=>'NNN identifies a number between 1 and 32767.'
,p_is_js_message=>true
,p_version_scn=>45141302
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(725108276464822358)
,p_name=>'QUICKSQL.HELP.NOTNULL'
,p_message_text=>'Requires a value using a <code>not null</code> constraint.'
,p_is_js_message=>true
,p_version_scn=>45141318
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(725111553542853532)
,p_name=>'QUICKSQL.HELP.PK'
,p_message_text=>'Identifies primary key when auto-created one does not suffice.'
,p_is_js_message=>true
,p_version_scn=>45141334
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(725114008402976527)
,p_name=>'QUICKSQL.HELP.REST'
,p_message_text=>'Enables Auto-REST data access using Oracle REST Data Services (ORDS)'
,p_is_js_message=>true
,p_version_scn=>45141350
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2061055700512397)
,p_name=>'QUICKSQL.HELP.SELECT'
,p_message_text=>'Generate SQL SELECT statement after generating data for each table'
,p_is_js_message=>true
,p_version_scn=>45141843
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(116793818610424618)
,p_name=>'QUICKSQL.HELP.TABLE_UNIQUE'
,p_message_text=>'Generates table level unique constraint (e.g. <code>/unique state,city</code>)'
,p_is_js_message=>true
,p_version_scn=>45141366
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(725106874366786022)
,p_name=>'QUICKSQL.HELP.UNIQUE'
,p_message_text=>'Prevents duplicate values with a unique constraint.'
,p_is_js_message=>true
,p_version_scn=>45141401
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2052119695070111)
,p_name=>'QUICKSQL.HELP.UPPER'
,p_message_text=>'Forces column values to upper case'
,p_is_js_message=>true
,p_version_scn=>45141385
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(725107684099808580)
,p_name=>'QUICKSQL.HELP.VALUES'
,p_message_text=>'Lists example values for generated data (e.g. <code>/values 1,2,3</code> or <code>/values Small,Large</code>)'
,p_is_js_message=>true
,p_version_scn=>45141417
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2051777098062773)
,p_name=>'QUICKSQL.IMPLEMENT'
,p_message_text=>'Creating the Database Objects'
,p_version_scn=>45129674
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(296541223167665719)
,p_name=>'QUICKSQL.IMPLEMENT.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Once you have finished entering the Quick SQL Shorthand and applied appropriate settings, you are ready to use the generated SQL. It can create the database objects, and optionally populate some or all tables with sample data. Follow these steps:<'
||'br>',
'<ol>',
'  <li>Choose <strong>Save Model</strong> from the left pane <em>Actions</em> menu to save the Quick SQL shorthand as a named model to reuse in the future.</li>',
'  <li>Enter a model name.</li>',
'  <li>Choose <strong>Save SQL Script</strong> from the right pane <em>SQL Script Actions</em> menu to save the generated output as a script.</li>',
'  <li>Enter a script name.</li>',
'  <li>Click <strong>Review and Run</strong> to navigate to the Script Editor.</li>',
'  <li>In the Script Editor, review the script contents if needed.</li>',
'  <li>Click <strong>Run</strong> to create the database objects.</li>',
'  <li>On the script confirmation page, click <strong>Run Now</strong>.</li>',
'  <li>On the results page review the statements processed, successful, and with errors. If any errors are reported, navigate through the result pages to see the specific Oracle error messages.</li>',
'  <li>Optionally, click <strong>Create App from Script</strong> to go to into the Create App Wizard and have pages automatically generated based on the tables and views specified in the script.</li>',
'</ol>',
'</p>',
'',
'<p><em><strong>Note:</strong></em> Oracle recommends downloading the SQL shorthand to your computer if you want to update it in the future. If you have specified any settings then navigate to the bottom of the Oracle SQL Output pane and copy the line'
||' starting with <code># settings =</code> to the top of the Quick SQL Shorthand pane.</p>',
'<p>Choose <strong>Download</strong> from the right pane <em>SQL Script Actions</em> menu to save the SQL file to your computer.</p>'))
,p_version_scn=>40148672
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(11601045035511232)
,p_name=>'QUICKSQL.INSERT_SETTING'
,p_message_text=>'Disables all sample data generation when set to false.'
,p_version_scn=>39919795
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3400550410232779)
,p_name=>'QUICKSQL.JS_NOT_LOADED'
,p_message_text=>'QuickSQL file resources could not be loaded from ORDS. Please check your reverse proxy configuration if applicable.'
,p_version_scn=>47434247
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184749788214908870)
,p_name=>'QUICKSQL.LANGUAGE_SETTING'
,p_message_text=>'Chooses language for sample data generation. Supported values:'
,p_version_scn=>39920086
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184909646341994382)
,p_name=>'QUICKSQL.LONGVC_SETTING'
,p_message_text=>'Allows <code>varchar2</code> sizes over 4000 (&le; 32767) in databases configured to support longer varchars.'
,p_version_scn=>39921874
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184912464529030108)
,p_name=>'QUICKSQL.OVERRIDESETTINGS_SETTING'
,p_message_text=>'Ignores any settings beyond those set in Quick SQL shorthand.'
,p_version_scn=>39922237
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184953196701066650)
,p_name=>'QUICKSQL.PK_SETTING'
,p_message_text=>'Chooses primary key strategy of identity, sequence, SYS_GUID, or none.  Valid values:'
,p_version_scn=>39924923
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184955249054104018)
,p_name=>'QUICKSQL.PREFIXPKWITHTNAME_SETTING'
,p_message_text=>'Prefixes primary key column with table name (e.g. <code>EMPLOYEE_ID</code>)'
,p_version_scn=>39925023
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184954636069088053)
,p_name=>'QUICKSQL.PREFIX_SETTING'
,p_message_text=>'Identifies common prefix for all objects, automatically separated by an underscore.'
,p_version_scn=>39924669
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2053584341409530)
,p_name=>'QUICKSQL.PRODUCTSALES'
,p_message_text=>'Product Sales'
,p_version_scn=>45137193
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(713113448842206461)
,p_name=>'QUICKSQL.PRODUCTSALES_DESC'
,p_message_text=>'Defines star schema with PRODUCTS, CUSTOMERS, CHANNELS, PROMOTIONS, and SALES tables.  The SALES table has foreign key references to others.  Identifies numeric columns (NUM). Defines legal values (/CHECK) for two columns. Generates random sample dat'
||'a (/INSERT) for all tables, and adds SALES_V join view including them all.'
,p_version_scn=>39386153
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2053719220411285)
,p_name=>'QUICKSQL.PROJECTMANAGEMENT'
,p_message_text=>'Project Management'
,p_version_scn=>45137238
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(713112950240199680)
,p_name=>'QUICKSQL.PROJECTMANAGEMENT_DESC'
,p_message_text=>'Defines project management schema with PROJECTS parent table and four child tables: MILESTONES, LINKS, ATTACHMENTS, and ACTION_ITEMS. Adds view PROJECT_MS joining projects and milestones and PROJECT_AI combining projects and action items. Specifies l'
||'egal values (/CHECK), example values (/VALUES), and generates sample rows (/INSERT). Adds audit columns in SQL syntax directives after #-sign (auditcols: true).'
,p_version_scn=>39388491
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2055732878449407)
,p_name=>'QUICKSQL.RESETSETTINGS_SETTING'
,p_message_text=>'Resets all application settings to default values.  When included all application settings currently active for your session will be ignored.'
,p_version_scn=>45138117
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184955873168174304)
,p_name=>'QUICKSQL.ROWKEY_SETTING'
,p_message_text=>'Adds trigger-assigned <code>ROW_KEY</code> column for alphanumeric id to each table.'
,p_version_scn=>39925451
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184963056213308121)
,p_name=>'QUICKSQL.ROWVERSION'
,p_message_text=>'Adds trigger-assigned <code>ROW_VERSION</code> column that increments on update to each table.'
,p_version_scn=>39927253
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(185117790875655747)
,p_name=>'QUICKSQL.SCHEMA_SETTING'
,p_message_text=>'Qualifies generated SQL object names with an optional schema.'
,p_version_scn=>39927614
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(185175670431154803)
,p_name=>'QUICKSQL.SEMANTICS_SETTING'
,p_message_text=>'Sets <code>varchar2</code> column length semantics to <code>byte</code>, <code>char</code>, or default.'
,p_version_scn=>39929561
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2054763254432110)
,p_name=>'QUICKSQL.SETTING'
,p_message_text=>'Setting'
,p_version_scn=>45137686
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184001664306113352)
,p_name=>'QUICKSQL.SETTINGS_DESC'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>You can define SQL syntax generation options <em>interactively</em> in the <strong>Settings</strong> dialog or <em>explicitly</em> in your Quick SQL Shorthand. Including settings in your Quick SQL Shorthand ensures the same options are always used'
||'. For example, to prefix all table names with <code>test</code> and generate for schema <code>obe</code> enter the following:</p>',
'<p>',
'<code># settings = { prefix: "test", schema: "obe" }</code>',
'</p>',
'<p>Alternatively, enter each setting on a separate line for the same result:</p>',
'<p>',
'<code># prefix: "test"<br>',
'# schema: "obe"</code>',
'</p>',
'<p><em><strong>Note:</strong> Settings must start on a new line and begin with <code># settings = </code> to enter multiple settings, or <code># </code> to enter a single setting per line. All values are case insensitive. Add brackets, spaces, or com'
||'mas for additional clarity if desired. To include all settings in the generated script, use <code># verbose: true</code>.</em>',
'</p>',
'&nbsp;<br>'))
,p_version_scn=>39914255
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3401243143242596)
,p_name=>'QUICKSQL.SQL_TITLE'
,p_message_text=>'SQL'
,p_version_scn=>47409339
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2052518505080634)
,p_name=>'QUICKSQL.SYNTAX'
,p_message_text=>'Syntax'
,p_version_scn=>45130012
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2053991876412261)
,p_name=>'QUICKSQL.TODOS'
,p_message_text=>'ToDos'
,p_version_scn=>45137255
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(839277711771636211)
,p_name=>'QUICKSQL.TODOS_DESC'
,p_message_text=>'Includes ASSIGNEES and TODOS tables. Defines NOT NULL constraints (/NN). Specifies legal values (/CHECK). Generates sample data (/INSERT). Adds audit columns (#auditcols: true). Enables creating a custom ToDo system in minutes.'
,p_version_scn=>39389039
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(185118571468664184)
,p_name=>'QUICKSQL.UPDATEDBYCOL_SETTING'
,p_message_text=>'Overrides default audit column name for user who last updated a row.'
,p_version_scn=>39934491
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(185118778020682348)
,p_name=>'QUICKSQL.UPDATEDCOL_SETTING'
,p_message_text=>'Overrides default audit column name for when a row was last updated.'
,p_version_scn=>39914144
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(185131355684693041)
,p_name=>'QUICKSQL.VERBOSE_SETTING'
,p_message_text=>'Includes all settings values in generated script.'
,p_version_scn=>39934779
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2052718358084737)
,p_name=>'QUICKSQL.VIEW_SYNTAX_DESC'
,p_message_text=>'Ensure the view name contains no spaces, ensure the table names contain no spaces.  Delimit table names by a space or comma.'
,p_version_scn=>45130065
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(24186897178604247)
,p_name=>'SCRIPT.MAX_SCRIPT_SIZE'
,p_message_text=>'This script is above the maximum size limit of %0 bytes. Please edit to make it smaller than the current size, %1 bytes.'
,p_is_js_message=>true
,p_version_scn=>78317249
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1344105008697170133)
,p_name=>'SCRIPTS.CHANGES_SAVED'
,p_message_text=>'Changes saved'
,p_is_js_message=>true
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2607221627981139)
,p_name=>'SDW_CONNECT'
,p_message_text=>'Connect'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2607869683984381)
,p_name=>'SDW_ERROR_ACTION'
,p_message_text=>'Action'
,p_is_js_message=>true
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2607682684983471)
,p_name=>'SDW_ERROR_CAUSE'
,p_message_text=>'Cause'
,p_is_js_message=>true
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2607044126977992)
,p_name=>'SDW_NOT_REST_ENABLED'
,p_message_text=>'This schema is not REST-enabled'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2000706429283846)
,p_name=>'SDW_OPEN_NEW_WINDOW'
,p_message_text=>'Opens in new window'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2606857775976558)
,p_name=>'SDW_REST_ENABLED'
,p_message_text=>'REST-enabled'
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3005039574867164)
,p_name=>'STATIC_LOV.GROUP.VALUES'
,p_message_text=>'Values'
,p_is_js_message=>true
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3005877475872855)
,p_name=>'STATIC_LOV.MOVE_DOWN'
,p_message_text=>'Move Down'
,p_is_js_message=>true
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3006652251892718)
,p_name=>'STATIC_LOV.MOVE_DOWN_VALUE_N'
,p_message_text=>'Move Down Value %0'
,p_is_js_message=>true
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3005669183871714)
,p_name=>'STATIC_LOV.MOVE_UP'
,p_message_text=>'Move Up'
,p_is_js_message=>true
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3007407225904194)
,p_name=>'STATIC_LOV.MOVE_UP_VALUE_N'
,p_message_text=>'Move Up Value %0'
,p_is_js_message=>true
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3005440858870100)
,p_name=>'STATIC_LOV.PROP.VALUES'
,p_message_text=>'Values'
,p_is_js_message=>true
,p_version_scn=>37165770887598
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3005236767868663)
,p_name=>'STATIC_LOV.REMOVE'
,p_message_text=>'Remove'
,p_is_js_message=>true
,p_version_scn=>37165770887564
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3007284747901031)
,p_name=>'STATIC_LOV.REMOVE_VALUE_N'
,p_message_text=>'Remove Value %0'
,p_is_js_message=>true
,p_version_scn=>37165770887564
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3006284830875758)
,p_name=>'STATIC_LOV.VALUE.DISPLAY'
,p_message_text=>'Display'
,p_is_js_message=>true
,p_version_scn=>37165770887564
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3006072131874349)
,p_name=>'STATIC_LOV.VALUE.FREQUENCY'
,p_message_text=>'Frequency'
,p_is_js_message=>true
,p_version_scn=>37165770887564
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3004810936857093)
,p_name=>'STATIC_LOV.VALUES'
,p_message_text=>'Values'
,p_is_js_message=>true
,p_version_scn=>37165770887564
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3006873524895654)
,p_name=>'STATIC_LOV.VALUE_N_DISPLAY'
,p_message_text=>'Value %0: Display'
,p_is_js_message=>true
,p_version_scn=>37165770887564
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3007005584899201)
,p_name=>'STATIC_LOV.VALUE_N_FREQUENCY'
,p_message_text=>'Value %0: Frequency'
,p_is_js_message=>true
,p_version_scn=>37165770887564
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1428391852969216)
,p_name=>'UI_DEFAULT.GET_DATA_DICTIONARY_ERROR'
,p_message_text=>'Error getting the data dictionary cache value for %0.'
,p_version_scn=>119797447
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2213848594146231)
,p_name=>'UI_DEFAULT.SYNC_INTO_DATA_DICTIONARY_ERROR'
,p_message_text=>'Error syncing %0 information into the data dictionary cache.'
,p_version_scn=>120702566
);
end;
/
prompt --application/shared_components/globalization/dyntranslations
begin
null;
end;
/
prompt --application/shared_components/user_interface/shortcuts/rename_script_name
begin
wwv_flow_imp_shared.create_shortcut(
 p_id=>wwv_flow_imp.id(32179615812392135)
,p_shortcut_name=>'RENAME_SCRIPT_NAME'
,p_shortcut_type=>'TEXT_ESCAPE_JS'
,p_version_scn=>75558194
,p_shortcut=>'The script name exists already in your workspace and owned by another user.  Please enter different script name.'
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/null_script_name
begin
wwv_flow_imp_shared.create_shortcut(
 p_id=>wwv_flow_imp.id(110802131425678586)
,p_shortcut_name=>'NULL_SCRIPT_NAME'
,p_shortcut_type=>'TEXT_ESCAPE_JS'
,p_version_scn=>75558194
,p_shortcut=>'Script Name must be specified.'
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/null_script
begin
wwv_flow_imp_shared.create_shortcut(
 p_id=>wwv_flow_imp.id(110803013894682985)
,p_shortcut_name=>'NULL_SCRIPT'
,p_shortcut_type=>'TEXT_ESCAPE_JS'
,p_version_scn=>75558194
,p_shortcut=>'Script must be entered.'
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/dup_script_name
begin
wwv_flow_imp_shared.create_shortcut(
 p_id=>wwv_flow_imp.id(111043910462526159)
,p_shortcut_name=>'DUP_SCRIPT_NAME'
,p_shortcut_type=>'TEXT_ESCAPE_JS'
,p_version_scn=>75558194
,p_shortcut=>'The script name exists already in your workspace.'
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/max_script_size
begin
wwv_flow_imp_shared.create_shortcut(
 p_id=>wwv_flow_imp.id(133393615560571789)
,p_shortcut_name=>'MAX_SCRIPT_SIZE'
,p_shortcut_type=>'TEXT_ESCAPE_JS'
,p_version_scn=>75558194
,p_shortcut=>'The script exceeds the maximum size allowed.'
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/delete_confirm_msg
begin
wwv_flow_imp_shared.create_shortcut(
 p_id=>wwv_flow_imp.id(165162327257300666)
,p_shortcut_name=>'DELETE_CONFIRM_MSG'
,p_shortcut_type=>'TEXT_ESCAPE_JS'
,p_version_scn=>75558194
,p_shortcut=>'Would you like to perform this delete action?'
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/ok_to_get_next_prev_pk_value
begin
wwv_flow_imp_shared.create_shortcut(
 p_id=>wwv_flow_imp.id(180175522684124268)
,p_shortcut_name=>'OK_TO_GET_NEXT_PREV_PK_VALUE'
,p_shortcut_type=>'TEXT_ESCAPE_JS'
,p_version_scn=>75558194
,p_shortcut=>'Are you sure you want to leave this page without saving?'
);
end;
/
prompt --application/shared_components/security/authentications/internal_authentication
begin
wwv_flow_imp_shared.create_authentication(
 p_id=>wwv_flow_imp.id(539837904309662819)
,p_name=>'Internal Authentication'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.AUTHN.INTERNAL.APEX'
,p_invalid_session_type=>'LOGIN'
,p_logout_url=>'f?p=4550:8:&SESSION.'
,p_cookie_name=>'ORA_WWV_USER_&INSTANCE_ID.'
,p_use_secure_cookie_yn=>'N'
,p_ras_mode=>0
,p_reference_id=>540226219724705040
);
end;
/
prompt --application/shared_components/plugins/region_type/com_oracle_apex_ai_hook
begin
wwv_flow_imp_shared.create_plugin(
 p_id=>wwv_flow_imp.id(1465565782563888)
,p_plugin_type=>'REGION TYPE'
,p_name=>'COM.ORACLE.APEX.AI_HOOK'
,p_display_name=>'AI Hook'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('REGION TYPE','COM.ORACLE.APEX.AI_HOOK'),'')
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'procedure render (',
'    p_plugin in            apex_plugin.t_plugin,',
'    p_region in            apex_plugin.t_region,',
'    p_param  in            apex_plugin.t_region_render_param,',
'    p_result in out nocopy apex_plugin.t_region_render_result )',
'as',
'    l_enabled   boolean         := wwv_flow_ai.is_enabled;',
'    l_ajax_id   varchar2(1000)  := wwv_flow_plugin.get_ajax_identifier;',
'    l_ai_key    varchar2(1000)  := p_region.attributes.get_varchar2( ''ai_key'' );',
'begin',
'    wwv_flow_javascript.add_onload_code (',
'        p_code =>',
'            ''apex.aiHook = {'' || wwv_flow.LF ||',
'            ''    aiEnabled: '' || case when l_enabled then ''true'' else ''false'' end || '','' || wwv_flow.LF ||',
'            ''    ajaxId: {}''  || wwv_flow.LF ||',
'            ''};'',',
'        p_key  => ''ai-hook'' );',
'',
'    if l_enabled then',
'        wwv_flow_javascript.add_onload_code (',
'            p_code => ''apex.aiHook.ajaxId[ '' || wwv_flow_escape.js_literal( l_ai_key ) || '' ] = '' ||',
'                wwv_flow_escape.js_literal( l_ajax_id ) || '';'' );',
'    end if;',
'end render;'))
,p_api_version=>3
,p_render_function=>'render'
,p_standard_attributes=>'AI_ENABLED_ALWAYS:AI_SYSTEM_PROMPT'
,p_substitute_attributes=>true
,p_reference_id=>1423361590814899
,p_version_scn=>128904175
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(2063514013567718)
,p_plugin_id=>wwv_flow_imp.id(1465565782563888)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_static_id=>'ai_key'
,p_prompt=>'Key'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_help_text=>'Provide a key, or an id, that will be used to get a handle on the plug-in''s AJAX ID as such: <code>apex.aiHook.ajaxId[ "{key here}" ]</code>.'
);
end;
/
prompt --application/shared_components/plugins/item_type/ai_item_plugin
begin
wwv_flow_imp_shared.create_plugin(
 p_id=>wwv_flow_imp.id(1803822956438934)
,p_plugin_type=>'ITEM TYPE'
,p_name=>'AI_ITEM_PLUGIN'
,p_display_name=>'AI Chat Item'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('ITEM TYPE','AI_ITEM_PLUGIN'),'')
,p_api_version=>3
,p_render_function=>'wwv_flow_f4000_plugins.render_ai_chat_item'
,p_standard_attributes=>'INIT_JAVASCRIPT_CODE:AI_ENABLED:AI_SYSTEM_PROMPT:AI_WELCOME_MESSAGE'
,p_substitute_attributes=>true
,p_reference_id=>2007076565402830
,p_version_scn=>134123884
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
,p_files_version=>115
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(1804148925438926)
,p_plugin_id=>wwv_flow_imp.id(1803822956438934)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_static_id=>'display_mode'
,p_prompt=>'Display Mode'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'DIALOG'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>'This setting specifies how the chat should be rendered.'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(1804438396438926)
,p_plugin_attribute_id=>wwv_flow_imp.id(1804148925438926)
,p_display_sequence=>10
,p_display_value=>'Dialog'
,p_return_value=>'DIALOG'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(1804938495438925)
,p_plugin_attribute_id=>wwv_flow_imp.id(1804148925438926)
,p_display_sequence=>20
,p_display_value=>'Inline'
,p_return_value=>'INLINE'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(1805473085438924)
,p_plugin_id=>wwv_flow_imp.id(1803822956438934)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_static_id=>'close_mode'
,p_prompt=>'Close Mode'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'CLOSE'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_imp.id(1804148925438926)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'DIALOG'
,p_lov_type=>'STATIC'
,p_help_text=>'<p>This setting controls what should happen to the chat when the user hits Escape or clicks the Close button.</p>'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(1805823256438924)
,p_plugin_attribute_id=>wwv_flow_imp.id(1805473085438924)
,p_display_sequence=>10
,p_display_value=>'Close'
,p_return_value=>'CLOSE'
,p_help_text=>'Closes the chat. All history and progress is reset.'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(1806393424438924)
,p_plugin_attribute_id=>wwv_flow_imp.id(1805473085438924)
,p_display_sequence=>20
,p_display_value=>'Hide'
,p_return_value=>'HIDE'
,p_help_text=>'Hides the dialog. It can be re-opened programatically where it was left off.'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(1806891342438924)
,p_plugin_id=>wwv_flow_imp.id(1803822956438934)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_static_id=>'focus'
,p_prompt=>'Focus'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'Y'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_imp.id(1804148925438926)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'INLINE'
,p_help_text=>'Whether the textarea should receive focus when the chat is opened.'
);
wwv_flow_imp_shared.create_plugin_std_attribute(
 p_id=>wwv_flow_imp.id(1807822323438918)
,p_plugin_id=>wwv_flow_imp.id(1803822956438934)
,p_name=>'INIT_JAVASCRIPT_CODE'
,p_is_required=>false
);
end;
/
prompt --application/shared_components/plugins/region_type/object_browser
begin
wwv_flow_imp_shared.create_plugin(
 p_id=>wwv_flow_imp.id(2105478322088418)
,p_plugin_type=>'REGION TYPE'
,p_name=>'OBJECT_BROWSER'
,p_display_name=>'Object Browser'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('REGION TYPE','OBJECT_BROWSER'),'')
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'procedure render (',
'    p_region in            wwv_flow_plugin_api.t_region,',
'    p_plugin in            wwv_flow_plugin_api.t_plugin,',
'    p_param  in            wwv_flow_plugin_api.t_region_render_param,',
'    p_result in out nocopy wwv_flow_plugin_api.t_region_render_result )',
'is',
'    c_render_name       varchar2(255) := p_region.attributes.get_varchar2(''attribute_01'');',
'    c_ajax_name         varchar2(255) := p_region.attributes.get_varchar2(''attribute_02'');',
'    c_variable_name     varchar2(255) := p_region.attributes.get_varchar2(''attribute_03'');',
'begin',
'    if c_render_name is not null then',
'        execute immediate ''begin '' || c_render_name || ''; end;'';',
'    end if;',
'    ',
'    if c_ajax_name is not null then',
'        wwv_flow_javascript.add_inline_code ( c_variable_name || ''='' || wwv_flow_escape.js_literal( wwv_flow_plugin.get_ajax_identifier ) || '';'' );',
'    end if;',
'end render;',
'',
'procedure ajax (',
'    p_region in            wwv_flow_plugin_api.t_region,',
'    p_plugin in            wwv_flow_plugin_api.t_plugin,',
'    p_param  in            wwv_flow_plugin_api.t_region_ajax_param,',
'    p_result in out nocopy wwv_flow_plugin_api.t_region_ajax_result )',
'is',
'    c_ajax_name varchar2(255) := p_region.attributes.get_varchar2(''attribute_02'');',
'begin',
'    execute immediate ''begin '' || c_ajax_name || ''( p_json_path => :p_json_path ); end;'' using p_param.json_path;',
'end ajax;'))
,p_api_version=>3
,p_render_function=>'render'
,p_ajax_function=>'ajax'
,p_substitute_attributes=>true
,p_version_scn=>88931178
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(2105636326091683)
,p_plugin_id=>wwv_flow_imp.id(2105478322088418)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_static_id=>'attribute_01'
,p_prompt=>'Render Procedure Name'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(2105977537092681)
,p_plugin_id=>wwv_flow_imp.id(2105478322088418)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_static_id=>'attribute_02'
,p_prompt=>'Ajax Procedure Name'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(2106219119093540)
,p_plugin_id=>wwv_flow_imp.id(2105478322088418)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_static_id=>'attribute_03'
,p_prompt=>'Ajax Identifier Variable Name'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
);
end;
/
prompt --application/shared_components/plugins/item_type/com_oracle_apex_code_language
begin
wwv_flow_imp_shared.create_plugin(
 p_id=>wwv_flow_imp.id(2678472121698841)
,p_plugin_type=>'ITEM TYPE'
,p_name=>'COM.ORACLE.APEX.CODE_LANGUAGE'
,p_display_name=>'Code Language'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('ITEM TYPE','COM.ORACLE.APEX.CODE_LANGUAGE'),'')
,p_api_version=>2
,p_render_function=>'wwv_flow_f4000_plugins.render_code_language'
,p_validation_function=>'wwv_flow_f4000_plugins.validate_code_language'
,p_standard_attributes=>'VISIBLE:FORM_ELEMENT:SESSION_STATE:SOURCE'
,p_substitute_attributes=>true
,p_reference_id=>1801904462214602
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(2678664416698833)
,p_plugin_id=>wwv_flow_imp.id(2678472121698841)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_static_id=>'attribute_01'
,p_prompt=>'Default Language'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>false
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_null_text=>'Automatically Picked'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(2679023964698832)
,p_plugin_attribute_id=>wwv_flow_imp.id(2678664416698833)
,p_display_sequence=>10
,p_display_value=>'SQL'
,p_return_value=>'SQL'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(2679542644698827)
,p_plugin_attribute_id=>wwv_flow_imp.id(2678664416698833)
,p_display_sequence=>20
,p_display_value=>'PL/SQL'
,p_return_value=>'PLSQL'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(2680096274698826)
,p_plugin_id=>wwv_flow_imp.id(2678472121698841)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_static_id=>'attribute_02'
,p_prompt=>'Type Page Item'
,p_attribute_type=>'PAGE ITEM'
,p_is_required=>false
,p_is_translatable=>false
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(2680454110698826)
,p_plugin_id=>wwv_flow_imp.id(2678472121698841)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_static_id=>'attribute_03'
,p_prompt=>'Hide SQL'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'N'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_imp.id(2680096274698826)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'NULL'
);
end;
/
prompt --application/shared_components/plugins/authorization_type/com_oracle_apex_developer_authorization
begin
wwv_flow_imp_shared.create_plugin(
 p_id=>wwv_flow_imp.id(12506617921221692)
,p_plugin_type=>'AUTHORIZATION TYPE'
,p_name=>'COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_display_name=>'Developer Authorization'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHORIZATION TYPE','COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'),'')
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function is_authorized (',
'    p_authorization in wwv_flow_plugin_api.t_authorization,',
'    p_plugin        in wwv_flow_plugin_api.t_plugin )',
'    return wwv_flow_plugin_api.t_authorization_exec_result',
'is',
'    l_result               wwv_flow_plugin_api.t_authorization_exec_result;',
'begin',
'    l_result.is_authorized := wwv_flow_authorization.is_authorized_developer ( ',
'                                  p_developer_authorization => p_authorization.attribute_01 );',
'    return l_result;',
'exception',
'    when no_data_found then',
'        l_result.is_authorized := false;',
'        return l_result;',
'end;'))
,p_api_version=>1
,p_execution_function=>'is_authorized'
,p_substitute_attributes=>true
,p_reference_id=>12457518297512494
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(1713462395757980)
,p_plugin_id=>wwv_flow_imp.id(12506617921221692)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Developer Role'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>false
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(1714304067757981)
,p_plugin_attribute_id=>wwv_flow_imp.id(1713462395757980)
,p_display_sequence=>10
,p_display_value=>'ADMIN: Ability to manage flow developer privileges'
,p_return_value=>'ADMIN'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(1714884646757981)
,p_plugin_attribute_id=>wwv_flow_imp.id(1713462395757980)
,p_display_sequence=>20
,p_display_value=>'EDIT: Ability change all attributes of specified flow(s)'
,p_return_value=>'EDIT'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(1715334069757981)
,p_plugin_attribute_id=>wwv_flow_imp.id(1713462395757980)
,p_display_sequence=>30
,p_display_value=>'HELP: Ability edit help page for a given company'
,p_return_value=>'HELP'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(1715895874757982)
,p_plugin_attribute_id=>wwv_flow_imp.id(1713462395757980)
,p_display_sequence=>40
,p_display_value=>'BROWSE: Access to Oracle data dictionary browser'
,p_return_value=>'BROWSE'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(1716321480757982)
,p_plugin_attribute_id=>wwv_flow_imp.id(1713462395757980)
,p_display_sequence=>50
,p_display_value=>'CREATE: Ability to create new flows'
,p_return_value=>'CREATE'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(1716874753757982)
,p_plugin_attribute_id=>wwv_flow_imp.id(1713462395757980)
,p_display_sequence=>60
,p_display_value=>'MONITOR: Ability to monitor flow activity'
,p_return_value=>'MONITOR'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(1717324527757983)
,p_plugin_attribute_id=>wwv_flow_imp.id(1713462395757980)
,p_display_sequence=>70
,p_display_value=>'DB_MONITOR: Ability to monitor Oracle database attributes'
,p_return_value=>'DB_MONITOR'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(1717868080757983)
,p_plugin_attribute_id=>wwv_flow_imp.id(1713462395757980)
,p_display_sequence=>80
,p_display_value=>'SQL: Ability to issues SQL statements'
,p_return_value=>'SQL'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(1718388334757984)
,p_plugin_attribute_id=>wwv_flow_imp.id(1713462395757980)
,p_display_sequence=>90
,p_display_value=>'USER_MANAGER: Manage user accounts for cookie based authentication'
,p_return_value=>'USER_MANAGER'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(1718815104757984)
,p_plugin_attribute_id=>wwv_flow_imp.id(1713462395757980)
,p_display_sequence=>100
,p_display_value=>'DATA_LOADER: Data Workshop'
,p_return_value=>'DATA_LOADER'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(1719393374757984)
,p_plugin_attribute_id=>wwv_flow_imp.id(1713462395757980)
,p_display_sequence=>110
,p_display_value=>'RESTFUL: Ability to enable RESTful Services'
,p_return_value=>'RESTFUL'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(1719857229757985)
,p_plugin_attribute_id=>wwv_flow_imp.id(1713462395757980)
,p_display_sequence=>130
,p_display_value=>'EDIT or SQL'
,p_return_value=>'EDIT:SQL'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(1713874581757981)
,p_plugin_attribute_id=>wwv_flow_imp.id(1713462395757980)
,p_display_sequence=>140
,p_display_value=>'DATA_GENERATOR: Ability to access Data Generator in SQL Workshop'
,p_return_value=>'DATA_GENERATOR'
);
end;
/
prompt --application/shared_components/plugins/item_type/com_oracle_apex_plugin_dynamic_attribute
begin
wwv_flow_imp_shared.create_plugin(
 p_id=>wwv_flow_imp.id(12964533458812939)
,p_plugin_type=>'ITEM TYPE'
,p_name=>'COM.ORACLE.APEX.PLUGIN_DYNAMIC_ATTRIBUTE'
,p_display_name=>'Plug-In Dynamic Attribute'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('ITEM TYPE','COM.ORACLE.APEX.PLUGIN_DYNAMIC_ATTRIBUTE'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_plugin_attribute'
,p_ajax_function=>'wwv_flow_f4000_plugins.ajax_plugin_attribute'
,p_standard_attributes=>'VISIBLE:FORM_ELEMENT:SESSION_STATE:SOURCE'
,p_substitute_attributes=>true
,p_reference_id=>6480508142096556
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_saml
begin
wwv_flow_imp_shared.create_plugin(
 p_id=>wwv_flow_imp.id(44507297529251872)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.SAML'
,p_display_name=>'INTERNAL SAML'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.SAML'),'')
,p_api_version=>2
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_saml'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_saml'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_saml'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_saml'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_saml'
,p_substitute_attributes=>true
,p_reference_id=>77082398185639908
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/item_type/com_oracle_apex_searchbox
begin
wwv_flow_imp_shared.create_plugin(
 p_id=>wwv_flow_imp.id(61354658999430857)
,p_plugin_type=>'ITEM TYPE'
,p_name=>'COM.ORACLE.APEX.SEARCHBOX'
,p_display_name=>'Search Box'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('ITEM TYPE','COM.ORACLE.APEX.SEARCHBOX'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_searchbox'
,p_standard_attributes=>'VISIBLE:FORM_ELEMENT'
,p_substitute_attributes=>true
,p_reference_id=>42609120788689442
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(1513166384709230023)
,p_plugin_id=>wwv_flow_imp.id(61354658999430857)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_static_id=>'attribute_01'
,p_prompt=>'Redirect URL'
,p_attribute_type=>'TEXTAREA'
,p_is_required=>true
,p_default_value=>'f?p=&APP_ID.:<target page>:&SESSION.::&DEBUG.::<target item>:'
,p_display_length=>80
,p_max_length=>4000
,p_is_translatable=>false
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(1513166776921230023)
,p_plugin_id=>wwv_flow_imp.id(61354658999430857)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_static_id=>'attribute_02'
,p_prompt=>'Search Text'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'Search'
,p_is_translatable=>true
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
''))
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_apex
begin
wwv_flow_imp_shared.create_plugin(
 p_id=>wwv_flow_imp.id(113746032581665431)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.APEX'
,p_display_name=>'INTERNAL Oracle APEX Accounts'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.APEX'),'')
,p_api_version=>1
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_apex'
,p_standard_attributes=>'INVALID_SESSION:LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113737019268347425
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_social
begin
wwv_flow_imp_shared.create_plugin(
 p_id=>wwv_flow_imp.id(118578616481923799)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.SOCIAL'
,p_display_name=>'INTERNAL Social Sign-In'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.SOCIAL'),'')
,p_api_version=>2
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_social'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_social'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_social'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_social'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_social'
,p_substitute_attributes=>true
,p_reference_id=>117694777698093086
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(416869786596942532)
,p_plugin_id=>wwv_flow_imp.id(118578616481923799)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Authentication Provider'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'OPENID_CONNECT'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(416870176495942532)
,p_plugin_attribute_id=>wwv_flow_imp.id(416869786596942532)
,p_display_sequence=>10
,p_display_value=>'OpenID Connect Provider'
,p_return_value=>'OPENID_CONNECT'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(416870657765942533)
,p_plugin_attribute_id=>wwv_flow_imp.id(416869786596942532)
,p_display_sequence=>20
,p_display_value=>'Generic OAuth2 Provider'
,p_return_value=>'OAUTH2'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(416871156029942533)
,p_plugin_attribute_id=>wwv_flow_imp.id(416869786596942532)
,p_display_sequence=>30
,p_display_value=>'Google'
,p_return_value=>'GOOGLE'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(416871607466942533)
,p_plugin_attribute_id=>wwv_flow_imp.id(416869786596942532)
,p_display_sequence=>40
,p_display_value=>'Facebook'
,p_return_value=>'FACEBOOK'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(416872177370942534)
,p_plugin_id=>wwv_flow_imp.id(118578616481923799)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Discovery URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_imp.id(416869786596942532)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OPENID_CONNECT'
,p_examples=>'https://accounts.example.com/.well-known/openid-configuration'
,p_help_text=>'Enter the OpenID Connect provider''s discovery URL.'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(416872581992942534)
,p_plugin_id=>wwv_flow_imp.id(118578616481923799)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Authorization Endpoint URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_imp.id(416869786596942532)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OAUTH2'
,p_help_text=>'Enter the OAuth2 provider''s authorization endpoint URL.'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(416872962730942534)
,p_plugin_id=>wwv_flow_imp.id(118578616481923799)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Token Endpoint URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_imp.id(416869786596942532)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OAUTH2'
,p_help_text=>'Enter the OAuth2 provider''s token endpoint URL.'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(416873391914942534)
,p_plugin_id=>wwv_flow_imp.id(118578616481923799)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'User Info Endpoint URL'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_imp.id(416869786596942532)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OAUTH2'
,p_help_text=>'Enter the OAuth2 provider''s user info endpoint URL.'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(416873750757942535)
,p_plugin_id=>wwv_flow_imp.id(118578616481923799)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'Scope'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_d