prompt --application/set_environment
set define off verify off feedback off
--------------------------------------------------------------------------------
--
-- Oracle APEX export file
--
-- You should run this script using a SQL client connected to the database as
-- the owner (parsing schema) of the application or as a database user with the
-- APEX_ADMINISTRATOR_ROLE role.
--
-- This export file has been automatically generated. Modifying this file is not
-- supported by Oracle and can lead to unexpected application and/or instance
-- behavior now or in the future.
--
-- NOTE: Calls to apex_application_install override the defaults below.
--
--------------------------------------------------------------------------------
begin
wwv_flow_imp.import_begin (
 p_version_yyyy_mm_dd=>'2024.11.30'
,p_release=>'24.2.0'
,p_default_workspace_id=>10
,p_default_application_id=>4411
,p_default_id_offset=>0
,p_default_owner=>'APEX_240200'
);
end;
/
 
prompt APPLICATION 4411 - Oracle APEX Builder, Wizard Messages and Native Plug-Ins
--
-- Application Export:
--   Application:     4411
--   Name:            Oracle APEX Builder, Wizard Messages and Native Plug-Ins
--   Exported By:     APEX_240200
--   Flashback:       0
--   Export Type:     Application Export
--     Pages:                      1
--     Shared Components:
--       Logic:
--       Navigation:
--         Lists:                  3
--       Security:
--         Authentication:         1
--       User Interface:
--         Themes:                 1
--         Templates:
--           Page:                 2
--           Region:               1
--           Label:                1
--           List:                 1
--           Popup LOV:            1
--           Calendar:             3
--           Breadcrumb:           2
--           Button:               1
--           Report:               1
--         Plug-ins:             173
--       PWA:
--       Globalization:
--         Messages:          17,979
--       Reports:
--       E-Mail:
--     Supporting Objects:  Included
--   Version:         24.2.0
--   Instance ID:     1000199029436341
--

prompt --application/delete_application
begin
wwv_flow_imp.remove_flow(wwv_flow.g_flow_id);
end;
/
prompt --application/create_application
begin
wwv_imp_workspace.create_flow(
 p_id=>wwv_flow.g_flow_id
,p_owner=>nvl(wwv_flow_application_install.get_schema,'APEX_240200')
,p_name=>nvl(wwv_flow_application_install.get_application_name,'Oracle APEX Builder, Wizard Messages and Native Plug-Ins')
,p_alias=>nvl(wwv_flow_application_install.get_application_alias,'MESSAGES-PLUGINS')
,p_application_group=>wwv_flow_imp.id(91050719712959059)
,p_application_group_name=>'APEX Product'
,p_application_group_comment=>'Applications shipped with the APEX product distribution'
,p_page_view_logging=>'YES'
,p_charset=>'utf-8'
,p_page_protection_enabled_y_n=>'Y'
,p_checksum_salt_last_reset=>'20250422164159'
,p_bookmark_checksum_function=>'SH1'
,p_compatibility_mode=>'24.2'
,p_session_state_commits=>'IMMEDIATE'
,p_flow_language=>'en'
,p_flow_language_derived_from=>'SESSION'
,p_direction_right_to_left=>'N'
,p_flow_image_prefix => nvl(wwv_flow_application_install.get_image_prefix,'')
,p_documentation_banner=>'Oracle APEX User interface messages used to support translation of strings that are not defined as part of the core APEX user interface.'
,p_authentication_id=>wwv_flow_imp.id(91645213681389498)
,p_populate_roles=>'A'
,p_application_tab_set=>0
,p_public_user=>'APEX_PUBLIC_USER'
,p_proxy_server=>nvl(wwv_flow_application_install.get_proxy,'')
,p_no_proxy_domains=>nvl(wwv_flow_application_install.get_no_proxy_domains,'')
,p_flow_version=>'&PRODUCT_NAME. 24.2.0'
,p_flow_status=>'UNAVAILABLE'
,p_flow_unavailable_text=>'This application is currently unavailable.'
,p_exact_substitutions_only=>'Y'
,p_browser_cache=>'N'
,p_browser_frame=>'D'
,p_deep_linking=>'Y'
,p_pass_ecid=>'N'
,p_authorize_public_pages_yn=>'Y'
,p_rejoin_existing_sessions=>'N'
,p_csv_encoding=>'N'
,p_auto_time_zone=>'N'
,p_file_prefix => nvl(wwv_flow_application_install.get_static_app_file_prefix,'')
,p_version_scn=>2483339
,p_print_server_type=>'INSTANCE'
,p_file_storage=>'DB'
,p_is_pwa=>'N'
);
end;
/
prompt --application/user_interfaces
begin
wwv_flow_imp_shared.create_user_interface(
 p_id=>wwv_flow_imp.id(4411)
,p_theme_id=>1
,p_home_url=>'f?p=4411:1:&SESSION.'
,p_theme_style_by_user_pref=>false
,p_nav_list_template_options=>'#DEFAULT#'
,p_include_legacy_javascript=>'PRE18:18'
,p_nav_bar_type=>'NAVBAR'
,p_nav_bar_template_options=>'#DEFAULT#'
);
end;
/
prompt --application/shared_components/navigation/lists/spotlight_custom_entries_global
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(562090986404402217)
,p_name=>'Spotlight \ Custom Entries - Global'
,p_list_status=>'PUBLIC'
,p_version_scn=>72470870
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(48650898565635010)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Sign out'
,p_list_item_link_target=>'&LOGOUT_URL.'
,p_list_text_01=>'Sign out of Oracle APEX'
,p_list_text_09=>'Y'
,p_list_text_10=>'logout exit quit :q'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(281916990329150760)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Create an application on a spreadsheet'
,p_list_item_link_target=>'f?p=4000:56:&APP_SESSION.::NO:56,103,104,106,130,131,35,227,3020,3000,3001'
,p_list_text_01=>'Import your excel or csv files and create an application'
,p_list_text_09=>'Y'
,p_list_text_10=>'excel csv xsl xslx spreadsheet data paste load import'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(282255839842182292)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Oracle APEX Home'
,p_list_item_link_target=>'f?p=4100:1:&APP_SESSION.'
,p_list_text_10=>'homepage start '
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(296033420364984683)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Browse Font APEX Icons'
,p_list_item_link_target=>'javascript:apex.navigation.openInNewWindow(''https://apex.oracle.com/fontapex'');'
,p_list_text_01=>'Browse Font APEX icons, add modifiers, and copy CSS or HTML you need.'
,p_list_text_09=>'Y'
,p_list_text_10=>'icons font apex library graphics'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/spotlight_custom_entries_app_level
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(562091518091404815)
,p_name=>'Spotlight \ Custom Entries - App Level'
,p_list_status=>'PUBLIC'
,p_version_scn=>72470938
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(562091727563404815)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Export Application'
,p_list_item_link_target=>'f?p=4000:4900:&SESSION.::NO:::'
,p_list_text_01=>'Export Application {APP_ID} as SQL File'
,p_list_text_09=>'Y'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(562093357853428158)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Unused Lists'
,p_list_item_link_target=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/spotlight_custom_entries_page_designer
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(562092153904409717)
,p_name=>'Spotlight \ Custom Entries - Page Designer'
,p_list_status=>'PUBLIC'
,p_version_scn=>72470938
);
end;
/
prompt --application/shared_components/navigation/listentry
begin
null;
end;
/
prompt --application/plugin_settings
begin
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(1730093136541659)
,p_plugin_type=>'PROCESS TYPE'
,p_plugin=>'PLUGIN_GEOCODING'
,p_attribute_01=>'RELAX_HOUSE_NUMBER'
,p_version_scn=>84561042
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(2402129102885900)
,p_plugin_type=>'DYNAMIC ACTION'
,p_plugin=>'PLUGIN_OPEN_AI_ASSISTANT'
,p_version_scn=>12355160
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(3223689581446811)
,p_plugin_type=>'WEB SOURCE TYPE'
,p_plugin=>'PLUGIN_ADFBC'
,p_version_scn=>1794227179
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(4016600614278093)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_SELECT_MANY'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'display_values_as', 'separated')).to_clob
,p_version_scn=>93095303
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(14843831009863117)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_YES_NO'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'attribute_01', 'Y',
  'attribute_03', 'N',
  'attribute_05', 'SWITCH_CB')).to_clob
,p_version_scn=>37165931336884
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(22674295917345008)
,p_plugin_type=>'WEB SOURCE TYPE'
,p_plugin=>'PLUGIN_BOSS'
,p_version_scn=>1840358383
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(146861159122292557)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_SINGLE_CHECKBOX'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'attribute_01', 'Y',
  'attribute_02', 'N')).to_clob
,p_version_scn=>37165931336884
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(183033629816949774)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_GEOCODED_ADDRESS'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'attribute_01', 'RELAX_HOUSE_NUMBER',
  'attribute_02', 'N',
  'attribute_04', 'default',
  'attribute_06', 'LIST')).to_clob
,p_version_scn=>60404021
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(280965675228226639)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_DATE_PICKER_APEX'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'attribute_02', 'VISIBLE',
  'attribute_03', '15',
  'attribute_04', 'FOCUS')).to_clob
,p_version_scn=>37165931336884
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(460407779408652225)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_COM.ORACLE.APEX.STARRATING_MODERN'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'attribute_01', 'fa-star',
  'attribute_04', '#VALUE#')).to_clob
,p_version_scn=>37165931336884
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(497671453666914719)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_STAR_RATING'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'attribute_01', 'fa-star')).to_clob
,p_version_scn=>29808778
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(631035363954639049)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_DATE_PICKER_JET'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'attribute_01', 'MONTH-PICKER:YEAR-PICKER',
  'attribute_02', 'VISIBLE',
  'attribute_03', '15',
  'attribute_04', 'FOCUS')).to_clob
,p_version_scn=>37165931336884
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(1082458703597614427)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_IG'
,p_version_scn=>1088662543
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(1831649180083980462)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_IR'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'attribute_01', 'IG')).to_clob
,p_version_scn=>1088662545
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(1832884277947217587)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_COLOR_PICKER'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'attribute_01', 'modern',
  'attribute_02', 'POPUP')).to_clob
,p_version_scn=>28367502
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(1840861033969283097)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_DISPLAY_SELECTOR'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'attribute_01', 'Y')).to_clob
,p_version_scn=>1088662545
);
end;
/
prompt --application/shared_components/navigation/navigation_bar
begin
null;
end;
/
prompt --application/shared_components/logic/application_settings
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/standard
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/parent
begin
null;
end;
/
prompt --application/pages/page_groups
begin
null;
end;
/
prompt --application/shared_components/navigation/breadcrumbentry
begin
null;
end;
/
prompt --application/shared_components/user_interface/templates/page/one_level_tabs
begin
wwv_flow_imp_shared.create_template(
 p_id=>wwv_flow_imp.id(91626406749381989)
,p_theme_id=>1
,p_name=>'One Level Tabs'
,p_internal_name=>'ONE_LEVEL_TABS'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">',
'',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<title>#TITLE#</title>',
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">',
'  <tr>',
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>',
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>',
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>',
'  </tr>',
'</table>',
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">',
'  <tr>',
'    <td colspan="5" class="t1ParentTabHolder"><table border="0" cellpadding="0" cellspacing="0" summary="" align="right"><tr><td><br /></td>#TAB_CELLS#</tr></table></td>',
'  </tr>',
'  <tr>',
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_left.png" alt="" /></td>',
'    <td class="t1topbarMiddle" valign="bottom"><table cellpadding="0" cellspacing="0" border="0" summary=""><tr><td height="50%"><br /></td></tr><tr><td height="50%">#REGION_POSITION_01#</td></tr></table></td>',
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>',
'  </tr>',
'<tr>',
'<td><br /></td>',
'<td class="t1PageCenter" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">',
'<tr>',
'<td width="100%" valign="top" class="t1PageBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BODY##REGION_POSITION_02##REGION_POSITION_04#</td>',
'<td valign="top">#REGION_POSITION_03#<br /></td>',
'</tr>',
'</table></td>',
'</tr>',
'</table>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">',
'  <tr>',
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>',
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>',
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>',
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_right.png" alt="" /></td>',
'  </tr>',
'</table>',
'<br />',
'#REGION_POSITION_05#',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#APEX_JAVASCRIPT#',
'#GENERATED_CSS#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>'<div class="t1success" role="alert">#SUCCESS_MESSAGE#</div>'
,p_current_tab=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_left.png" border="0" alt="" /></td>',
'<td class="t1ParentTabCenterOn">#TAB_LABEL##TAB_INLINE_EDIT#</td>',
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_right.png" border="0" alt="" /></td>',
'',
''))
,p_non_current_tab=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_left.png" border="0" alt="" /></td>',
'<td class="t1ParentTabCenterOff"><a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td>',
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_right.png" border="0" alt="" /></td>',
''))
,p_notification_message=>'<div class="t1notification">#MESSAGE#</div>'
,p_navigation_bar=>'<div class="t1NavigationBar">#BAR_BODY#</div>'
,p_navbar_entry=>'<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>1
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_template_comment=>'12'
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140001488931349566)
,p_page_template_id=>wwv_flow_imp.id(91626406749381989)
,p_name=>'Page Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140001517815349566)
,p_page_template_id=>wwv_flow_imp.id(91626406749381989)
,p_name=>'Page Position 1'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140001699115349566)
,p_page_template_id=>wwv_flow_imp.id(91626406749381989)
,p_name=>'Page Position 2'
,p_placeholder=>'REGION_POSITION_02'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140001740672349566)
,p_page_template_id=>wwv_flow_imp.id(91626406749381989)
,p_name=>'Page Position 3'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140001820430349566)
,p_page_template_id=>wwv_flow_imp.id(91626406749381989)
,p_name=>'Page Position 4'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140001949447349565)
,p_page_template_id=>wwv_flow_imp.id(91626406749381989)
,p_name=>'Page Position 5'
,p_placeholder=>'REGION_POSITION_05'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140002088971349565)
,p_page_template_id=>wwv_flow_imp.id(91626406749381989)
,p_name=>'Page Position 6'
,p_placeholder=>'REGION_POSITION_06'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140002117005349565)
,p_page_template_id=>wwv_flow_imp.id(91626406749381989)
,p_name=>'Page Position 7'
,p_placeholder=>'REGION_POSITION_07'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140002264345349565)
,p_page_template_id=>wwv_flow_imp.id(91626406749381989)
,p_name=>'Page Position 8'
,p_placeholder=>'REGION_POSITION_08'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/printer_friendly
begin
wwv_flow_imp_shared.create_template(
 p_id=>wwv_flow_imp.id(91626529080381989)
,p_theme_id=>1
,p_name=>'Printer Friendly'
,p_internal_name=>'PRINTER_FRIENDLY'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">',
'',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<title>#TITLE#</title>',
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">',
'<tr>',
'<td width="100%" valign="top">',
'<div style="border:1px solid black;">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>',
'#BODY##REGION_POSITION_04#</td>',
'<td valign="top">#REGION_POSITION_03#<br /></td>',
'</tr>',
'</table>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#APEX_JAVASCRIPT#',
'#GENERATED_CSS#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_theme_class_id=>5
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_template_comment=>'3'
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140002343913349565)
,p_page_template_id=>wwv_flow_imp.id(91626529080381989)
,p_name=>'Page Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140002490586349565)
,p_page_template_id=>wwv_flow_imp.id(91626529080381989)
,p_name=>'Page Position 3'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140002552177349565)
,p_page_template_id=>wwv_flow_imp.id(91626529080381989)
,p_name=>'Page Position 4'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/button/button
begin
wwv_flow_imp_shared.create_button_templates(
 p_id=>wwv_flow_imp.id(91626823864381990)
,p_template_name=>'Button'
,p_internal_name=>'BUTTON'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table class="t1Button" cellspacing="0" cellpadding="0" border="0"  summary="">',
'<tr>',
'<td class="t1L"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_left.gif" alt="" width="4" height="24" /></a></td>',
'<td class="t1C"><a href="#LINK#">#LABEL!HTML#</a></td>',
'<td class="t1R"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_right.gif" width="4" height="24" alt="" /></a></td>',
'</tr>',
'</table>'))
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>1
);
end;
/
prompt --application/shared_components/user_interface/templates/region/reports_region
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(91632832228382001)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ReportsRegion" id="#REGION_ID#">',
'<tr>',
'<td class="t1RegionHeader">#TITLE#</td>',
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>',
'</tr>',
'<tr>',
'<td class="t1Body" colspan="2">#BODY#</td>',
'</tr>',
'</table>'))
,p_page_plug_template_name=>'Reports Region'
,p_internal_name=>'REPORTS_REGION'
,p_plug_table_bgcolor=>'#ffffff'
,p_theme_id=>1
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#ffffff'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>'Red Theme'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140382691031344638)
,p_plug_template_id=>wwv_flow_imp.id(91632832228382001)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140382773788344638)
,p_plug_template_id=>wwv_flow_imp.id(91632832228382001)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140382895312344637)
,p_plug_template_id=>wwv_flow_imp.id(91632832228382001)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140382923760344637)
,p_plug_template_id=>wwv_flow_imp.id(91632832228382001)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140383001370344637)
,p_plug_template_id=>wwv_flow_imp.id(91632832228382001)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140383101590344637)
,p_plug_template_id=>wwv_flow_imp.id(91632832228382001)
,p_name=>'Help'
,p_placeholder=>'HELP'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140383260593344637)
,p_plug_template_id=>wwv_flow_imp.id(91632832228382001)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140383343091344637)
,p_plug_template_id=>wwv_flow_imp.id(91632832228382001)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140383417298344637)
,p_plug_template_id=>wwv_flow_imp.id(91632832228382001)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140383590781344637)
,p_plug_template_id=>wwv_flow_imp.id(91632832228382001)
,p_name=>'Change'
,p_placeholder=>'CHANGE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/list/vertical_unordered_list_with_bullets
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(91636711305382010)
,p_list_template_current=>'<li class="t1current">#TEXT#</li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Vertical Unordered List with Bullets'
,p_internal_name=>'VERTICAL_UNORDERED_LIST_WITH_BULLETS'
,p_theme_id=>1
,p_theme_class_id=>1
,p_list_template_before_rows=>'<ul class="t1VerticalUnorderedListwithBullets">'
,p_list_template_after_rows=>'</ul>'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/standard
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(91638400927382012)
,p_row_template_name=>'Standard'
,p_internal_name=>'STANDARD'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="t1data">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellpadding="0" border="0" cellspacing="0" summary="">#TOP_PAGINATION#',
'<tr>',
'<td><table cellpadding="0" border="0" cellspacing="0" summary="" class="t1standard">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>',
'</tr>',
'#PAGINATION#',
'</table>'))
,p_row_template_before_first=>'<tr #HIGHLIGHT_ROW#>'
,p_row_template_after_last=>'</tr>'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#" class="t1header">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>'
,p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>'
,p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>'
,p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>'
,p_row_style_checked=>'#CCCCCC'
,p_theme_id=>1
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/optional_with_help
begin
wwv_flow_imp_shared.create_field_template(
 p_id=>wwv_flow_imp.id(91641225667382016)
,p_template_name=>'Optional with help'
,p_internal_name=>'OPTIONAL_WITH_HELP'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999"><a class="t1OptionalwithHelp" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_on_error_before_label=>'<div class="t1InlineError">'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>'
,p_theme_id=>1
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/hierarchical_menu
begin
wwv_flow_imp_shared.create_menu_template(
 p_id=>wwv_flow_imp.id(91641730492382017)
,p_name=>'Hierarchical Menu'
,p_internal_name=>'HIERARCHICAL_MENU'
,p_before_first=>'<ul class="t1HierarchicalMenu">'
,p_current_page_option=>'<li class="t1current">#NAME#</li>'
,p_non_current_page_option=>'<li><a href="#LINK#">#NAME#</a></li>'
,p_after_last=>'</ul>'
,p_max_levels=>11
,p_start_with_node=>'CHILD_MENU'
,p_theme_id=>1
,p_theme_class_id=>2
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/breadcrumb_menu
begin
wwv_flow_imp_shared.create_menu_template(
 p_id=>wwv_flow_imp.id(91641814330382017)
,p_name=>'Breadcrumb Menu'
,p_internal_name=>'BREADCRUMB_MENU'
,p_before_first=>'<div class="t1BreadcrumbMenu">'
,p_current_page_option=>'<span class="t1current">#NAME#</span>'
,p_non_current_page_option=>'<a href="#LINK#">#NAME#</a>'
,p_between_levels=>'&nbsp;&gt;&nbsp;'
,p_after_last=>'</div>'
,p_max_levels=>12
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>1
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/popuplov
begin
wwv_flow_imp_shared.create_popup_lov_template(
 p_id=>wwv_flow_imp.id(91642503902382024)
,p_popup_icon=>'#IMAGE_PREFIX#list_gray.gif'
,p_popup_icon_attr=>'width="13" height="13" alt="Popup Lov"'
,p_page_name=>'winlov'
,p_page_title=>'Search Dialog'
,p_page_html_head=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html lang="&BROWSER_LANGUAGE.">',
'<head>',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#APEX_JAVASCRIPT#',
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V2.css" type="text/css">',
'',
'#THEME_CSS#',
'</head>'))
,p_page_body_attr=>'onload="first_field()" style="margin:0;"'
,p_before_field_text=>'<div class="t1PopupHead">'
,p_filter_width=>'20'
,p_filter_max_width=>'100'
,p_find_button_text=>'Search'
,p_close_button_text=>'Close'
,p_next_button_text=>'Next >'
,p_prev_button_text=>'< Previous'
,p_after_field_text=>'</div>'
,p_scrollbars=>'1'
,p_resizable=>'1'
,p_width=>'400'
,p_height=>'450'
,p_result_row_x_of_y=>'<br /><div style="padding:2px; font-size:8pt;">Row(s) #FIRST_ROW# - #LAST_ROW#</div>'
,p_result_rows_per_pg=>500
,p_before_result_set=>'<div class="t1PopupBody">'
,p_theme_id=>1
,p_theme_class_id=>1
,p_translate_this_template=>'N'
,p_after_result_set=>'</div>'
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/small_calendar
begin
wwv_flow_imp_shared.create_calendar_template(
 p_id=>wwv_flow_imp.id(91641910982382018)
,p_cal_template_name=>'Small Calendar'
,p_internal_name=>'SMALL_CALENDAR'
,p_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#DY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1SmallCalendarHolder"> ',
' <tr>',
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="1" summary="#CALENDAR_TITLE# #IMONTH# #YYYY#" class="t1SmallCalendar">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>'))
,p_day_title_format=>'<div class="t1DayTitle">#DD#</div>'
,p_day_open_format=>'<td class="t1Day" valign="top">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="t1Today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="t1WeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="t1WeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="t1NonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="t1NonDay" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1SmallWeekCalendarHolder">',
'<tr>',
'<td class="t1MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#<br />#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="1" summary="#CALENDAR_TITLE# #START_DL# - #END_DL#" class="t1SmallWeekCalendar">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="t1Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="t1Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="t1NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th scope="row" class="t1Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1SmallDayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr><tr><td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="1" summary="#CALENDAR_TITLE# #START_DL#" class="t1SmallDayCalendar">'
,p_daily_month_close_format=>'</table></td></tr></table>'
,p_daily_day_open_format=>'<td valign="top" class="t1Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="t1Today">'
,p_daily_time_open_format=>'<th scope="row" class="t1Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>1
,p_theme_class_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/calendar
begin
wwv_flow_imp_shared.create_calendar_template(
 p_id=>wwv_flow_imp.id(91642102481382020)
,p_cal_template_name=>'Calendar'
,p_internal_name=>'CALENDAR'
,p_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1CalendarHolder"> ',
' <tr>',
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" summary="0" class="t1Calendar">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>',
''))
,p_day_title_format=>'<div class="t1DayTitle">#DD#</div>'
,p_day_open_format=>'<td class="t1Day" valign="top">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="t1Today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="t1WeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="t1WeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="t1NonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="t1NonDay" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1WeekCalendarHolder">',
'<tr>',
'<td class="t1MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#<br>#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" summary="#CALENDAR_TITLE# #START_DL# - #END_DL#" class="t1WeekCalendar">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="t1Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="t1Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="t1NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th scope="row" class="t1Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="0" summary="#CALENDAR_TITLE# #START_DL#" class="t1DayCalendar">'
,p_daily_month_close_format=>'</table></td> </tr> </table>'
,p_daily_day_open_format=>'<td valign="top" class="t1Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="t1Today">'
,p_daily_time_open_format=>'<th scope="row" class="t1Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>1
,p_theme_class_id=>1
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/calendar_alternative_1
begin
wwv_flow_imp_shared.create_calendar_template(
 p_id=>wwv_flow_imp.id(91642303533382020)
,p_cal_template_name=>'Calendar, Alternative 1'
,p_internal_name=>'CALENDAR,_ALTERNATIVE_1'
,p_day_of_week_format=>'<th scope="col" valign="bottom" class="t1DayOfWeek">#IDAY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1CalendarAlternative1Holder"> ',
' <tr>',
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="2" summary="0" class="t1CalendarAlternative1">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>',
''))
,p_day_title_format=>'<div class="t1DayTitle">#DD#</div>'
,p_day_open_format=>'<td class="t1Day" valign="top" height="100" height="100">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="t1Today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="t1WeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="t1WeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="t1NonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="t1NonDay" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1WeekCalendarAlternative1Holder">',
'<tr>',
'<td class="t1MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#<br>#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="2" summary="#CALENDAR_TITLE# #START_DL# - #END_DL#" class="t1WeekCalendarAlternative1">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="t1Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="t1Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="t1NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th scope="row" class="t1Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1DayCalendarAlternative1Holder"> <tr><td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td></tr><tr><td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="2" summary="#CALENDAR_TITLE# #START_DL#" class="t1DayCalendarAlternative1">'
,p_daily_month_close_format=>'</table></td> </tr> </table>'
,p_daily_day_open_format=>'<td valign="top" class="t1Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="t1Today">'
,p_daily_time_open_format=>'<th scope="row" class="t1Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>1
,p_theme_class_id=>2
);
end;
/
prompt --application/shared_components/user_interface/themes
begin
wwv_flow_imp_shared.create_theme(
 p_id=>wwv_flow_imp.id(91642708702382024)
,p_theme_id=>1
,p_theme_name=>'Red'
,p_theme_internal_name=>'RED'
,p_navigation_type=>'T'
,p_nav_bar_type=>'NAVBAR'
,p_is_locked=>false
,p_default_page_template=>wwv_flow_imp.id(91626406749381989)
,p_error_template=>wwv_flow_imp.id(91626406749381989)
,p_printer_friendly_template=>wwv_flow_imp.id(91626529080381989)
,p_breadcrumb_display_point=>'REGION_POSITION_01'
,p_sidebar_display_point=>'REGION_POSITION_02'
,p_login_template=>wwv_flow_imp.id(91625820476381987)
,p_default_button_template=>wwv_flow_imp.id(91626823864381990)
,p_default_region_template=>wwv_flow_imp.id(91632832228382001)
,p_default_chart_template=>wwv_flow_imp.id(91631622717381999)
,p_default_form_template=>wwv_flow_imp.id(91630725782381998)
,p_default_reportr_template=>wwv_flow_imp.id(91632832228382001)
,p_default_tabform_template=>wwv_flow_imp.id(91632832228382001)
,p_default_wizard_template=>wwv_flow_imp.id(91632204784382001)
,p_default_menur_template=>wwv_flow_imp.id(91633105066382001)
,p_default_listr_template=>wwv_flow_imp.id(91627727983381992)
,p_default_report_template=>wwv_flow_imp.id(91638400927382012)
,p_default_label_template=>wwv_flow_imp.id(91641225667382016)
,p_default_menu_template=>wwv_flow_imp.id(91641814330382017)
,p_default_calendar_template=>wwv_flow_imp.id(91642102481382020)
,p_default_list_template=>wwv_flow_imp.id(91636711305382010)
,p_default_option_label=>wwv_flow_imp.id(91641225667382016)
,p_default_required_label=>wwv_flow_imp.id(91641529261382017)
,p_file_prefix => nvl(wwv_flow_application_install.get_static_theme_file_prefix(1),'')
);
end;
/
prompt --application/shared_components/user_interface/theme_style
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_files
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_opt_groups
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_options
begin
null;
end;
/
prompt --application/shared_components/globalization/language
begin
wwv_flow_imp_shared.create_language_map(
 p_id=>wwv_flow_imp.id(72245617218976155)
,p_translation_flow_id=>4412
,p_translation_flow_language_cd=>'es'
,p_translation_comments=>'APEX Builder, Wizard Messages and Native Types - Spanish'
,p_direction_right_to_left=>'N'
);
wwv_flow_imp_shared.create_language_map(
 p_id=>wwv_flow_imp.id(72245702935976155)
,p_translation_flow_id=>4413
,p_translation_flow_language_cd=>'fr'
,p_translation_comments=>'APEX Builder, Wizard Messages and Native Types - French'
,p_direction_right_to_left=>'N'
);
wwv_flow_imp_shared.create_language_map(
 p_id=>wwv_flow_imp.id(72245830838976155)
,p_translation_flow_id=>4414
,p_translation_flow_language_cd=>'de'
,p_translation_comments=>'APEX Builder, Wizard Messages and Native Types - German'
,p_direction_right_to_left=>'N'
);
wwv_flow_imp_shared.create_language_map(
 p_id=>wwv_flow_imp.id(72245929066976155)
,p_translation_flow_id=>4415
,p_translation_flow_language_cd=>'it'
,p_translation_comments=>'APEX Builder, Wizard Messages and Native Types - Italian'
,p_direction_right_to_left=>'N'
);
wwv_flow_imp_shared.create_language_map(
 p_id=>wwv_flow_imp.id(72246029698976155)
,p_translation_flow_id=>4416
,p_translation_flow_language_cd=>'pt-br'
,p_translation_comments=>'APEX Builder, Wizard Messages and Native Types - Brazilian Portuguese'
,p_direction_right_to_left=>'N'
);
wwv_flow_imp_shared.create_language_map(
 p_id=>wwv_flow_imp.id(72246123317976155)
,p_translation_flow_id=>4417
,p_translation_flow_language_cd=>'zh-cn'
,p_translation_comments=>'APEX Builder, Wizard Messages and Native Types - Simplified Chinese'
,p_direction_right_to_left=>'N'
);
wwv_flow_imp_shared.create_language_map(
 p_id=>wwv_flow_imp.id(72246228444976155)
,p_translation_flow_id=>4418
,p_translation_flow_language_cd=>'zh-tw'
,p_translation_comments=>'APEX Builder, Wizard Messages and Native Types - Traditional Chinese'
,p_direction_right_to_left=>'N'
);
wwv_flow_imp_shared.create_language_map(
 p_id=>wwv_flow_imp.id(72246319589976155)
,p_translation_flow_id=>4419
,p_translation_flow_language_cd=>'ko'
,p_translation_comments=>'APEX Builder, Wizard Messages and Native Types - Korean'
,p_direction_right_to_left=>'N'
);
wwv_flow_imp_shared.create_language_map(
 p_id=>wwv_flow_imp.id(72246430201976155)
,p_translation_flow_id=>4420
,p_translation_flow_language_cd=>'ja'
,p_translation_comments=>'APEX Builder, Wizard Messages and Native Types - Japanese'
,p_direction_right_to_left=>'N'
);
end;
/
prompt --application/shared_components/logic/build_options
begin
null;
end;
/
prompt --application/shared_components/globalization/messages
begin
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1814227314326251)
,p_name=>'2DCOLUMN'
,p_message_text=>'2D Column'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1816526316326253)
,p_name=>'2DCOLUMN_LINE'
,p_message_text=>'2D Column Line'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1814413427326252)
,p_name=>'2DDOUGHNUT'
,p_message_text=>'2D Doughnut'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1816323524326253)
,p_name=>'2DHSTACKED_PCT'
,p_message_text=>'Stacked Horizontal 2D Column (Percent)'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1814513062326252)
,p_name=>'2DLINE'
,p_message_text=>'2D Line'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1814632268326252)
,p_name=>'2DPIE'
,p_message_text=>'2D Pie'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1816109684326252)
,p_name=>'2DSTACKED_PCT'
,p_message_text=>'Stacked 2D Column (Percent)'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1814703346326252)
,p_name=>'3DCOLUMN'
,p_message_text=>'3D Column'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1816420921326253)
,p_name=>'3DHSTACKED_PCT'
,p_message_text=>'Stacked Horizontal 3D Column (Percent)'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1814811711326252)
,p_name=>'3DPIE'
,p_message_text=>'3D Pie'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1816210234326253)
,p_name=>'3DSTACKED_PCT'
,p_message_text=>'Stacked 3D Column (Percent)'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(455039001641343152)
,p_name=>'4000.912.0.ITEMS.FOR.INSERT.INTO.AD'
,p_message_text=>'0 Items for insert into the Attribute Dictionary'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(455037830590266387)
,p_name=>'4000.912.0.ITEMS.FOR.UPDATE'
,p_message_text=>'0 Items for update'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(455053331966541163)
,p_name=>'4000.912.0.ITEMS.FOR.UPDATE.OF.AD'
,p_message_text=>'0 Items for update of the Attribute Dictionary'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(455058806180647209)
,p_name=>'4000.912.0.RC.FOR.INSERT.INTO.AD'
,p_message_text=>'0 Report Columns for insert into the Attribute Dictionary'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(455059408735657438)
,p_name=>'4000.912.0.RC.FOR.UPDATE.OF.AD'
,p_message_text=>'0 Report Columns for update of the Attribute Dictionary'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(455037519855263300)
,p_name=>'4000.912.REVIEW.N.ITEMS.FOR.UPDATE'
,p_message_text=>'Review %0 Items for update'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(455057508903619572)
,p_name=>'4000:912:0.RC.FOR.UPDATE'
,p_message_text=>'0 Report Columns for update'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(455038728175341364)
,p_name=>'4000:912:REVIEW.N.ITEMS.FOR.INSERT.INTO.AD'
,p_message_text=>'Review %0 Items for insert into the Attribute Dictionary'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(455039712077374539)
,p_name=>'4000:912:REVIEW.N.ITEMS.FOR.UPDATE.OF.AD'
,p_message_text=>'Review %0 Items for update of the Attribute Dictionary'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(455058528559644236)
,p_name=>'4000:912:REVIEW.N.RC.FOR.INSERT.INTO.AD'
,p_message_text=>'Review %0 Report Columns for insert into the Attribute Dictionary'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(455057100246617113)
,p_name=>'4000:912:REVIEW.N.RC.FOR.UPDATE'
,p_message_text=>'Review %0 Report Columns for update'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(455059100424655013)
,p_name=>'4000:912:REVIEW.N.RC.FOR.UPDATE.OF.AD'
,p_message_text=>'Review %0 Report Columns for update of the Attribute Dictionary'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(237332502821717106)
,p_name=>'4000_424_VALUE_MUST_BE_NUMERIC'
,p_message_text=>'Value must be numeric.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(218854722491089205)
,p_name=>'4000_639_SEQ_MESG'
,p_message_text=>'<span class="fielddata"> Cannot reorder because Region sequences are not unique.</span>'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(218862500140319382)
,p_name=>'4000_641_SEQ_MESG'
,p_message_text=>'<span class="fielddata">Cannot reorder because Button sequences are not unique.</span>'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(218862911568322684)
,p_name=>'4000_646_SEQ_MESG'
,p_message_text=>'<span class="fielddata">Cannot reorder because Navigation Bar sequences are not unique.</span>'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(218863320572325259)
,p_name=>'4000_749_SEQ_MESG'
,p_message_text=>'<span class="fielddata">Cannot reorder because Region Item sequences are not unique.</span>'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(294714627951753160)
,p_name=>'4000_APPLICATION_ID'
,p_message_text=>'Application ID'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(42641015751974682)
,p_name=>'4000_EDIT_APPLICATION'
,p_message_text=>'Edit Application: %0 %1'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(190191216789904908)
,p_name=>'4000_INVALID_DATE_FORMAT'
,p_message_text=>'The specified date format is invalid.  The calendar requires a date in YYYYMMDD format.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(244160625121134779)
,p_name=>'4000_TREE'
,p_message_text=>'Tree'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(294716021025786683)
,p_name=>'4000_WORKSPACE_ID'
,p_message_text=>'Workspace ID'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145516618269340884)
,p_name=>'4050_106_ENTER_SCHEMA_NAME'
,p_message_text=>'Enter the name of the new schema to be created. Choose a password for the schema, and choose the default tablespace and temporary tablespace.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145518524503342700)
,p_name=>'4050_106_EXISTING_SCHEMA'
,p_message_text=>'Enter the name of the existing schema.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145538114591349291)
,p_name=>'4050_106_WHEN_DONE'
,p_message_text=>'When done, click <strong>Next</strong>.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(109980301694498629)
,p_name=>'4050_110_DROP_TABLESPACES'
,p_message_text=>'Drop tablespaces and associated datafiles: %0'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(109979522687495285)
,p_name=>'4050_110_DROP_USERS'
,p_message_text=>'Drop database users: %0'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(301177569873546148)
,p_name=>'4050_131_SSL_WALLET_PROPERTY'
,p_message_text=>'The current wallet path is defined by the SSL_WALLET database property'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(301177264212544976)
,p_name=>'4050_131_WALLET_ALTERNATIVE'
,p_message_text=>'You can specify an alternative wallet below.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(620830686957124301)
,p_name=>'4050_139_WEB_SERVICE_ACTIVITY_LOG'
,p_message_text=>'Web Service Activity Log entries'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1413965805969355)
,p_name=>'4050_162_WEB_SOURCE_SYNC_LOG'
,p_message_text=>'REST Synchronization Log entries'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1589821405443861)
,p_name=>'4050_182_AUTOMATION_LOG'
,p_message_text=>'Automation Log Entries'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145045413871421848)
,p_name=>'4050_19_LOG_ENTRIES'
,p_message_text=>'Developer activity log entries'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15389030604151768)
,p_name=>'4050_31_LOG_COUNT'
,p_message_text=>'Login Access Log entries'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145015920573357494)
,p_name=>'4050_3_CHANGE_REQUESTS'
,p_message_text=>'Change Requests'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145018106852362972)
,p_name=>'4050_3_RUNTIME_REQUESTS'
,p_message_text=>'Runtime Requests'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145005228968340997)
,p_name=>'4050_3_SERVICE_REQUESTS'
,p_message_text=>'Workspace Requests'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145168805550693769)
,p_name=>'4050_46_AD_HOC'
,p_message_text=>'SQL Command Processor history entries'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145168027236690625)
,p_name=>'4050_46_CONTROL_FILE'
,p_message_text=>'Control File execution log entries'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145163630915682190)
,p_name=>'4050_46_SCRIPT_FILE'
,p_message_text=>'Script File execution log entries'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145171026328699838)
,p_name=>'4050_46_SQL_ARCHIVES'
,p_message_text=>'SQL Archives entries'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145297613131093383)
,p_name=>'4050_61_ACTIVE_LOG'
,p_message_text=>'Active Log Information'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145299932178098938)
,p_name=>'4050_61_CURRENT_LOG_NO'
,p_message_text=>'Current Log Number'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145301013262102934)
,p_name=>'4050_61_CUR_LOG_TIME'
,p_message_text=>'Current Log Timestamp'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145352109200158478)
,p_name=>'4050_61_HOURS_UNTIL'
,p_message_text=>'Hours until next log switch'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145337722051114944)
,p_name=>'4050_61_INTERVAL_DAYS'
,p_message_text=>'Interval in days (constant)'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145351432618155852)
,p_name=>'4050_61_NEXT_LOG_SWITCH'
,p_message_text=>'Next log switch scheduled for'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145357628378173480)
,p_name=>'4050_70_DEV_ACT'
,p_message_text=>'Developer activity log entries'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145361831972183993)
,p_name=>'4050_71_CLICK'
,p_message_text=>'Click through log entries'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145413101375241443)
,p_name=>'4050_75_AD_HOC'
,p_message_text=>'SQL Command Processor history entries'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145412628602239809)
,p_name=>'4050_75_CTRL_FILE'
,p_message_text=>'Control File execution log entries'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145409911633234875)
,p_name=>'4050_75_SCRIPT_FILE'
,p_message_text=>'Script File execution log entries'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145417806701252460)
,p_name=>'4050_75_SQL_ARCH'
,p_message_text=>'SQL Archives entries'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145477428995268293)
,p_name=>'4050_82_WORKSPACE'
,p_message_text=>'Workspace %0 has %1 applications and %2 user(s).'
,p_version_scn=>11335129
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145511106017327963)
,p_name=>'4050_85_CLICK_COUNT'
,p_message_text=>'Click Counting log entries'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(254832409736047670)
,p_name=>'4050_PACKAGED_APPLICATIONS'
,p_message_text=>'Productivity and Sample Apps'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(254079723483458269)
,p_name=>'4050_WORKSPACE_COUNT'
,p_message_text=>'Workspace Count'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(122913011490532448)
,p_name=>'4350_EDIT_APPLICATION'
,p_message_text=>'Edit Application'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(20429928742346966)
,p_name=>'4500 800 HD HTMLDB'
,p_message_text=>'Oracle APEX 2 Day Plus Developer Guide.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(20434315976371693)
,p_name=>'4500 800 MSG DBA'
,p_message_text=>'Discusses common day-to-day administrative tasks.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(20435308834379034)
,p_name=>'4500 800 MSG HTMLDB'
,p_message_text=>'Offers a series to tutorials that describe how to build database-centric Web applications.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(20437122471392467)
,p_name=>'4500 800 MSG NET'
,p_message_text=>'This document describes the key features of Oracle Data Provider for .NET and Oracle Developer Tools for Visual Studio .NET. It leads you through installation and configuration, shows how to build basic applications using Oracle Data Provider for .NE'
||'T and Oracle Developer Tools for Visual Studio .NET, and how to create and use both PL/SQL and .NET stored procedures.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(9769223806175173)
,p_name=>'4500_1002_QB_CLONE_ALIAS'
,p_message_text=>'Alias'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(9768218827164295)
,p_name=>'4500_1002_QB_CLONE_COLUMN'
,p_message_text=>'Column'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(9770107314179814)
,p_name=>'4500_1002_QB_CLONE_CONDITION'
,p_message_text=>'Condition'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(164969022563427041)
,p_name=>'4500_1002_QB_CLONE_DEL'
,p_message_text=>'Delete'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(9772910562190200)
,p_name=>'4500_1002_QB_CLONE_FUNCTION'
,p_message_text=>'Function'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(9773819913192934)
,p_name=>'4500_1002_QB_CLONE_GROUP'
,p_message_text=>'Group By'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(9769730386177026)
,p_name=>'4500_1002_QB_CLONE_OBJECT'
,p_message_text=>'Object'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(9771831902186993)
,p_name=>'4500_1002_QB_CLONE_OUTPUT'
,p_message_text=>'Show'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(9770515280182137)
,p_name=>'4500_1002_QB_CLONE_SORT'
,p_message_text=>'Sort Type'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(9771224630184824)
,p_name=>'4500_1002_QB_CLONE_SORT_ORDER'
,p_message_text=>'Sort Order'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(10964410371662927)
,p_name=>'4500_1002_QB_JOIN'
,p_message_text=>'Join'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(9296531469510943)
,p_name=>'4500_1002_QB_JOIN_HINT'
,p_message_text=>'Click here to select column for join'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(11155203668127634)
,p_name=>'4500_1002_QB_MAX_COLS'
,p_message_text=>'A maximum of 60 columns may be selected.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(9295919348507481)
,p_name=>'4500_1002_QB_REMOVE_TABLE'
,p_message_text=>'Remove'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(9295405496503444)
,p_name=>'4500_1002_QB_SHOW_COLS'
,p_message_text=>'Show/Hide Columns'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(10964702537670191)
,p_name=>'4500_1002_QB_TO'
,p_message_text=>'to'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(8942925019019788)
,p_name=>'4500_1220_SCRIPT_RESULT'
,p_message_text=>'Results of %0, run %1'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(110293223052704114)
,p_name=>'4500_46_RET_TO_QUERY'
,p_message_text=>'Return to Original Query'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(14084928671830801)
,p_name=>'4500_OBJECT_BROWSER_ONLY_N_COLS'
,p_message_text=>'First %0 columns displayed.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(180129026087321856)
,p_name=>'4500_SESS_EVENT'
,p_message_text=>'Event'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(180128316737319102)
,p_name=>'4500_SESS_KILOBYTES'
,p_message_text=>'Kilobytes'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(180127911196317514)
,p_name=>'4500_SESS_MEGABYTES'
,p_message_text=>'Megabytes'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(21299607759967144)
,p_name=>'4500_UI_DEF_HINT_TEXT'
,p_message_text=>'UI Defaults allow AI interactions to understand the contents of your tables. They are also used to populate initial labels for forms and reports, providing consistency across multiple pages in an application or multiple applications.'
,p_version_scn=>117498961
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(27776610928855106)
,p_name=>'4550_COOKIES_ENABLED'
,p_message_text=>'This application requires cookies to be enabled.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(27747406874537909)
,p_name=>'4550_JAVASCRIPT_ENABLED'
,p_message_text=>'This application requires JavaScript to be enabled.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(188057516467537629)
,p_name=>'ABOUT'
,p_message_text=>'About'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(907030700283981973)
,p_name=>'ABOUT_TO_CREATE_USERS'
,p_message_text=>'Please confirm adding the following %0 user(s) to your workspace.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(195669319386995168)
,p_name=>'ACCEPTED'
,p_message_text=>'Accepted'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184002513763630549)
,p_name=>'ACCESSIBILITY_ASSIGNEE'
,p_message_text=>'Accessibility Assignee'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(183995707136600262)
,p_name=>'ACCESSIBILITY_IMPACT'
,p_message_text=>'Accessibility Impact'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184004003505637013)
,p_name=>'ACCESSIBILITY_STATUS'
,p_message_text=>'Accessibility Status'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2040478723215461769)
,p_name=>'ACCESSIBILITY_TESTED'
,p_message_text=>'Accessibility Tested'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(66768901771821180)
,p_name=>'ACCESS_CONTROL_ADMIN_AUTH'
,p_message_text=>'Administration Rights'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(13038822941882315)
,p_name=>'ACCESS_CONTROL_ADMIN_PAGE'
,p_message_text=>'Access Control Administration Page'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(155070400433342171)
,p_name=>'ACCESS_CONTROL_ADMIN_ROLE'
,p_message_text=>'Administrator'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(232263043267802089)
,p_name=>'ACCESS_CONTROL_ADMIN_ROLE_DESC'
,p_message_text=>'Role assigned to application administrators.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(13164129717423676)
,p_name=>'ACCESS_CONTROL_APP_ADMIN'
,p_message_text=>'Application Administration'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(13167830503480662)
,p_name=>'ACCESS_CONTROL_APP_MODE'
,p_message_text=>'Application Mode'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(13167215958476490)
,p_name=>'ACCESS_CONTROL_APP_MODE_HELP'
,p_message_text=>'Identify how access to this application will be controlled.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(13190231008067472)
,p_name=>'ACCESS_CONTROL_APP_MODE_SET_ERROR'
,p_message_text=>'Unable to process set application mode request.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(13190621789074218)
,p_name=>'ACCESS_CONTROL_APP_MODE_SET_SUCCESS'
,p_message_text=>'Application Mode Set.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(67427815913071208)
,p_name=>'ACCESS_CONTROL_CANNOT_DELETE'
,p_message_text=>'You may not delete yourself.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(67430621023091671)
,p_name=>'ACCESS_CONTROL_CANNOT_REMOVE_ADMIN'
,p_message_text=>'You may not remove administrator privilege from yourself.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(13047625590949379)
,p_name=>'ACCESS_CONTROL_CONFIRM_TABLE'
,p_message_text=>'Create Table'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(155069799286334366)
,p_name=>'ACCESS_CONTROL_CONTRIB_AUTH'
,p_message_text=>'Contribution Rights'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(155070692180345306)
,p_name=>'ACCESS_CONTROL_CONTRIB_ROLE'
,p_message_text=>'Contributor'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(232263370382804234)
,p_name=>'ACCESS_CONTROL_CONTRIB_ROLE_DESC'
,p_message_text=>'Role assigned to application contributors.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(181826015286466071)
,p_name=>'ACCESS_CONTROL_CREATE_APP_SETTINGS'
,p_message_text=>'The following Application Setting(s) will be created:'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(155071206201353888)
,p_name=>'ACCESS_CONTROL_CREATE_AUTH_ROLE'
,p_message_text=>'The following Application Access Role(s) will be created:'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(19726902022653116)
,p_name=>'ACCESS_CONTROL_CREATE_AUTH_SCHEME'
,p_message_text=>'The following Authorization Scheme(s) will be created:'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(39652705194868521)
,p_name=>'ACCESS_CONTROL_CREATE_PAGE_ERROR'
,p_message_text=>'Unable to create access control page. %0'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(39651309219860229)
,p_name=>'ACCESS_CONTROL_CREATE_TABLE_ERROR'
,p_message_text=>'Unable to create access control tables. %0'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(69251416022747608)
,p_name=>'ACCESS_CONTROL_DUP_USERNAME'
,p_message_text=>'You may not enter duplicate username.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(66770728090828700)
,p_name=>'ACCESS_CONTROL_EDIT_AUTH'
,p_message_text=>'access control - edit'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(13175605925549284)
,p_name=>'ACCESS_CONTROL_FIND_HELP'
,p_message_text=>'Enter case insensitive query criteria, then press the <strong>Go</strong> button.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(13183519140007243)
,p_name=>'ACCESS_CONTROL_GET_APP_MODE_ERROR'
,p_message_text=>'Unable to get application administration mode.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(13174505447539669)
,p_name=>'ACCESS_CONTROL_LAST_CHANGED_BY'
,p_message_text=>'Last Changed By'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(13169100290490889)
,p_name=>'ACCESS_CONTROL_LIST'
,p_message_text=>'Access Control List'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(13164713572428457)
,p_name=>'ACCESS_CONTROL_MODE1'
,p_message_text=>'Full access to all, access control list not used.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(13165400543434154)
,p_name=>'ACCESS_CONTROL_MODE2'
,p_message_text=>'Restricted access. Only users defined in the access control list are allowed.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(13166015088438389)
,p_name=>'ACCESS_CONTROL_MODE3'
,p_message_text=>'Public read only. Edit and administrative privileges controlled by access control list.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(13166623100469024)
,p_name=>'ACCESS_CONTROL_MODE4'
,p_message_text=>'Administrative access only.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(13188211353042819)
,p_name=>'ACCESS_CONTROL_NO_PRIV'
,p_message_text=>'No privilege for attempted action.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(13170831374518767)
,p_name=>'ACCESS_CONTROL_PRIV'
,p_message_text=>'Privilege'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(181819236830426340)
,p_name=>'ACCESS_CONTROL_READER_AUTH'
,p_message_text=>'Reader Rights'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(181819006172424408)
,p_name=>'ACCESS_CONTROL_READER_ROLE'
,p_message_text=>'Reader'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(232263806108806288)
,p_name=>'ACCESS_CONTROL_READER_ROLE_DESC'
,p_message_text=>'Role assigned to application readers.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(19873728462944627)
,p_name=>'ACCESS_CONTROL_RPT_REGION_HEADER'
,p_message_text=>'Identify usernames which correspond to this application''s authentication scheme.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(13168516436486095)
,p_name=>'ACCESS_CONTROL_SET_APP_MODE'
,p_message_text=>'Set Application Mode'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(44642222810423676)
,p_name=>'ACCESS_CONTROL_SUCCESS_MSG'
,p_message_text=>'The access control pages have been created successfully.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(155071510027356455)
,p_name=>'ACCESS_CONTROL_USE_AUTH_ROLE'
,p_message_text=>'Use Existing Access Control Role'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(19825416155827552)
,p_name=>'ACCESS_CONTROL_USE_AUTH_SCHEME'
,p_message_text=>'Use Existing Authorization Scheme'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(19726026001641114)
,p_name=>'ACCESS_CONTROL_USE_TABLE'
,p_message_text=>'Use Existing Table'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(66771912075843074)
,p_name=>'ACCESS_CONTROL_VIEW_AUTH'
,p_message_text=>'access control - view'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(20472403022632871)
,p_name=>'ACCOUNT_CREATED'
,p_message_text=>'Account created.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(389048005730370199)
,p_name=>'ACCOUNT_MENU'
,p_message_text=>'Account'
,p_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Do not add "menu" word because this message is used for accessible description of the account menu, and the word "menu" is provided through other means (through semantic ARIA role).',
'Used in core/wwv_flow_4000_ui.plb'))
,p_version_scn=>751984648
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(173001212090777484)
,p_name=>'ACKNOWLEDGED'
,p_message_text=>'Acknowledged'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(173007316901826204)
,p_name=>'ACKNOWLEDGED_NO_ACTION'
,p_message_text=>'Acknowledged, no action'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(205915321720818630)
,p_name=>'ACL_ADD_USER'
,p_message_text=>'Add User'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(623904200121647964)
,p_name=>'ACL_TABLE.ACCESS_DASHBOARD'
,p_message_text=>'Access Dashboard'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(623904728172656022)
,p_name=>'ACL_TABLE.ACCESS_MONITOR'
,p_message_text=>'Access Monitor Activity'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(623899814488614244)
,p_name=>'ACL_TABLE.ADD_MODIFY'
,p_message_text=>'Add / Modify'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(623903020768644500)
,p_name=>'ACL_TABLE.ADMIN_WHEN_RUNNING'
,p_message_text=>'Administration when Running Application'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(623893122790541004)
,p_name=>'ACL_TABLE.ADMIN_WITHIN_BUILDER'
,p_message_text=>'Administration from within App Builder'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(623896920244606431)
,p_name=>'ACL_TABLE.ANNOTATIONS'
,p_message_text=>'Annotations (files, tags, notes)'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(623890708283489468)
,p_name=>'ACL_TABLE.APEX_AUTH_WO_ACL'
,p_message_text=>'Oracle APEX Account Authentication without Access Control List'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(623890406074479441)
,p_name=>'ACL_TABLE.AUTH_WITH_ACL'
,p_message_text=>'Authentication with Access Control List'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(623896318120577480)
,p_name=>'ACL_TABLE.EDIT_SQL_ACCESS'
,p_message_text=>'Edit SQL Access and Suggested Objects'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(628482831215278735)
,p_name=>'ACL_TABLE.INTRO_TEXT'
,p_message_text=>'Once authenticated to an application, access control specifies what users can do within the application. The table below identifies what capabilities different types of users will have based on the authentication being used within this application.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(623904901768667361)
,p_name=>'ACL_TABLE.MAINTAIN_ACL'
,p_message_text=>'Maintain Access Control List'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(623896523445588443)
,p_name=>'ACL_TABLE.RUN_AND_VIEW'
,p_message_text=>'Run and View'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(623895629071571156)
,p_name=>'ACL_TABLE.UPDATE_APP'
,p_message_text=>'Update Application Properties'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(442738628681346793)
,p_name=>'ACTIONS'
,p_message_text=>'Actions'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(622852123755935803)
,p_name=>'ACTION_MENU_SETTINGS'
,p_message_text=>'Action Menu Settings'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(23004506192614313)
,p_name=>'ACTIVE'
,p_message_text=>'Active'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(160800423410678999)
,p_name=>'ACTIVITY'
,p_message_text=>'Activity'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184162618020814333)
,p_name=>'ACTIVITY_SUMMARY'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Activity Summary',
''))
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(367642914624521833)
,p_name=>'ADDED_BY'
,p_message_text=>'Added By'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(617128321947502667)
,p_name=>'ADDED_TO_PURGE_LIST'
,p_message_text=>'Added to Purge List'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(435244708193906718)
,p_name=>'ADDITIONAL_INFORMATION_REQUESTED'
,p_message_text=>'Additional information requested'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(146309201279652859)
,p_name=>'ADD_ARGUEMENT'
,p_message_text=>'Add Argument'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145295524643077859)
,p_name=>'ADD_COLUMN'
,p_message_text=>'Add Column'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(270356309633834871)
,p_name=>'ADD_COLUMN_NAME'
,p_message_text=>'Add Column %0'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(96747802282607912)
,p_name=>'ADD_CONSTRAINT'
,p_message_text=>'Add Constraint'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145158415069658752)
,p_name=>'ADD_MORE...'
,p_message_text=>'Add More...'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(170150827202818987)
,p_name=>'ADD_ROW'
,p_message_text=>'Add Row'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(290106114414522846)
,p_name=>'ADJUST_PROVISIONED_SPACE'
,p_message_text=>'Adjust provisioned space by %0 megabytes'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145049818158432512)
,p_name=>'ADMIN'
,p_message_text=>'Admin'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1512430359936356)
,p_name=>'ADMIN.WORKSPACE_BANNER_COLOR'
,p_message_text=>'Banner Color'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1511947154901605)
,p_name=>'ADMIN.WORKSPACE_BANNER_ENABLE'
,p_message_text=>'Enable Environment Banner'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1512202657934439)
,p_name=>'ADMIN.WORKSPACE_BANNER_LABEL'
,p_message_text=>'Banner Label'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145812130405722393)
,p_name=>'ADMIN.WORKSPACE_BANNER_POS'
,p_message_text=>'Banner Position'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(17810000592953257)
,p_name=>'ADMINISTRATOR'
,p_message_text=>'Workspace Administrator'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184039402886242283)
,p_name=>'ADMINISTRATORS'
,p_message_text=>'Administrators'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(21022444493203559)
,p_name=>'ADMIN_DIGEST_ADMIN_ACCOUNT'
,p_message_text=>'Maximum Administrator Accounts'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(21022035390196788)
,p_name=>'ADMIN_DIGEST_CREATED_APPS'
,p_message_text=>'Created Applications'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(21020880422172014)
,p_name=>'ADMIN_DIGEST_DBLINKS'
,p_message_text=>'Database Links'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(21022683347205912)
,p_name=>'ADMIN_DIGEST_DEV_ACCOUNT'
,p_message_text=>'Maximum Developer Accounts'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(21023667173219230)
,p_name=>'ADMIN_DIGEST_EMAIL_CREATED'
,p_message_text=>'Created'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(21023466088217662)
,p_name=>'ADMIN_DIGEST_EMAIL_QUEUED'
,p_message_text=>'Still in queue'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(21023817311220573)
,p_name=>'ADMIN_DIGEST_EMAIL_SENT'
,p_message_text=>'Sent'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(21022855900209840)
,p_name=>'ADMIN_DIGEST_ENDUSER_ACCOUNT'
,p_message_text=>'Maximum End User Accounts'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(21024041471222570)
,p_name=>'ADMIN_DIGEST_ERROR'
,p_message_text=>'Errors'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(21027109230364944)
,p_name=>'ADMIN_DIGEST_FAILEDJOBS'
,p_message_text=>'Failed Jobs'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(21021679061187891)
,p_name=>'ADMIN_DIGEST_FAILEDLOGINS'
,p_message_text=>'Failed Logins'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(21020687601170293)
,p_name=>'ADMIN_DIGEST_INSTANCE_JOBS'
,p_message_text=>'Total Instance Jobs'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(21023230662214775)
,p_name=>'ADMIN_DIGEST_IP_ADDRESS'
,p_message_text=>'Distinct IP Addresses'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(21021074085179138)
,p_name=>'ADMIN_DIGEST_PAGE_EVENTS'
,p_message_text=>'Page Events'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(21022223701198801)
,p_name=>'ADMIN_DIGEST_REMOVED_APPS'
,p_message_text=>'Removed Applications'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(21023073669212640)
,p_name=>'ADMIN_DIGEST_SESSIONS'
,p_message_text=>'Distinct Sessions'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(21021808288191171)
,p_name=>'ADMIN_DIGEST_SUCCESSJOBS'
,p_message_text=>'Successful Jobs'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(21021432560186114)
,p_name=>'ADMIN_DIGEST_SUCCESSLOGIN'
,p_message_text=>'Successful Logins'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(21019835805125132)
,p_name=>'ADMIN_DIGEST_TOTAL_APPLICATIONS'
,p_message_text=>'Total Applications'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(21019648732123263)
,p_name=>'ADMIN_DIGEST_TOTAL_WORKSPACES'
,p_message_text=>'Total Workspaces'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(21020094055158066)
,p_name=>'ADMIN_DIGEST_TOTAL_WORKSPACE_USERS'
,p_message_text=>'Total Workspace Users'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(21020429504168407)
,p_name=>'ADMIN_DIGEST_USER_JOBS'
,p_message_text=>'Total User Jobs'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(21021292192181152)
,p_name=>'ADMIN_DIGEST_WEBSRV_REQUESTS'
,p_message_text=>'Web Service Requests'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(21020222275164428)
,p_name=>'ADMIN_DIGEST_WKSP_SCHEMAS'
,p_message_text=>'Total Workspace Schemas'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145601307809214859)
,p_name=>'ADMIN_EMAIL_MUST_BE_PROV'
,p_message_text=>'Administrators email must be provided'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(240625155773891491)
,p_name=>'ADVISOR.CATEGORY.ACCESSIBILITY'
,p_message_text=>'Accessibility'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25296814352073057)
,p_name=>'ADVISOR.CATEGORY.ERROR'
,p_message_text=>'Error'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25297430975077855)
,p_name=>'ADVISOR.CATEGORY.PERFORMANCE'
,p_message_text=>'Performance'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25297709306582514)
,p_name=>'ADVISOR.CATEGORY.QA'
,p_message_text=>'Quality Assurance'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25297021278075098)
,p_name=>'ADVISOR.CATEGORY.SECURITY'
,p_message_text=>'Security'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25297915540584280)
,p_name=>'ADVISOR.CATEGORY.USABILITY'
,p_message_text=>'Usability'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25297225434076270)
,p_name=>'ADVISOR.CATEGORY.WARNING'
,p_message_text=>'Warning'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(356767707912315557)
,p_name=>'ADVISOR.CHECK.AJAX_ITEMS_WITH_SSP.MSG_AJAX_ITEMS_WITH_SSP.DA'
,p_message_text=>'Item "%1" is protected and can not be set via an Ajax call.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(356770604517514650)
,p_name=>'ADVISOR.CHECK.AJAX_ITEMS_WITH_SSP.MSG_AJAX_ITEMS_WITH_SSP.ITEM'
,p_message_text=>'Item "%1" is protected and can not be set via an Ajax call.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(362665601326910853)
,p_name=>'ADVISOR.CHECK.AJAX_ITEMS_WITH_SSP.MSG_AJAX_ITEMS_WITH_SSP.REGION'
,p_message_text=>'Item "%1" is protected and can not be set via an Ajax call.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(37150127533471770)
,p_name=>'ADVISOR.CHECK.APEX_CODE_SMELL.MSG_MISSING_SYS_PREFIX'
,p_message_text=>'Missing SYS schema prefix'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(480431173835158437)
,p_name=>'ADVISOR.CHECK.APEX_CODE_SMELL.MSG_WWV_FLOW'
,p_message_text=>'Usage of WWV_FLOW APIs (use APEX APIs instead)'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(420868258611572443)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_IG_COLUMN_NOT_EXISTS'
,p_message_text=>'Column %0 does not exist in Region Source SQL Statement!'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25318319241869637)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_IR_FILTER_NOT_EXISTS'
,p_message_text=>'Interactive Report column %0 does not exist.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25316006670869634)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_NOT_EXISTS'
,p_message_text=>'%0 does not exist.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(21580909857697783)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_REGION_COLUMN_NOT_EXISTS'
,p_message_text=>'Column %0 does not exist in Region Source SQL Statement!'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(500053531887502655)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_TABFORM_COLUMN_NOT_EXISTS'
,p_message_text=>'Tabular Form column %0 does not exist.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25316122214869634)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_WRONG_REFERENCE'
,p_message_text=>'%0 cannot be referenced as application or page item name.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(931576377428421039)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_NO_APP_PROC_AUTHORIZATION'
,p_message_text=>'Ajax Callback application process is not protected by an authorization scheme.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(931430218509929499)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_NO_PAGE_AUTHORIZATION'
,p_message_text=>'Page is not protected by an authorization scheme.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25317007970869636)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_NO_TARGET_AUTH_DEFINED'
,p_message_text=>'Target page %1 (within application %0) has no authorization scheme defined.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(932274342204661069)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_PARENT_PAGE_AUTH_DIFFERENT'
,p_message_text=>'Authorization of this page is different to authorization "%1" of parent page %0.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25317132477869636)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_TARGET_AUTH_DIFFERENT'
,p_message_text=>'Authorization "%0" on target page is different to "%1".'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25315632635869633)
,p_name=>'ADVISOR.CHECK.BIND_VARIABLE_SYNTAX.MSG_NOT_EXISTS'
,p_message_text=>'%0 does not exist.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25315516938869633)
,p_name=>'ADVISOR.CHECK.BIND_VARIABLE_SYNTAX.MSG_UNKNOWN_ERROR'
,p_message_text=>'Could not perform bind variable syntax check. Error: %0'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25315705427869634)
,p_name=>'ADVISOR.CHECK.BIND_VARIABLE_SYNTAX.MSG_WRONG_REFERENCE'
,p_message_text=>'%0 cannot be referenced with bind variable syntax.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25317711275869636)
,p_name=>'ADVISOR.CHECK.BRANCH_SEQUENCE.MSG_FOUND'
,p_message_text=>'Unconditional branch before other branches.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(931429660986921496)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_AUTOCOMPLETE'
,p_message_text=>'Autocomplete is set to "On" for a page that contains password items.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(931430051637925888)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_BROWSER_CACHE'
,p_message_text=>'"Cache" allows the browser to cache sensitive data.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(573558501444704314)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_BROWSER_FRAME'
,p_message_text=>'"Embed in Frames" leaves the application vulnerable to clickjacking attacks.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(573558744556709386)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_HTML_ESCAPING_MODE'
,p_message_text=>'"HTML Escaping Mode" only escapes a limited set of characters.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2108067184704050)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_ITEM_OUTPUT_ESCAPING'
,p_message_text=>'Items should escape special characters to avoid Cross-Site-Scripting attacks (XSS).'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(576284706610466257)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_REFERRER_POLICY'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'The HTTP "Referer" request header can leak sensitive session information to third parties.',
'Applications should set "Referrer Policy" to "strict-origin".'))
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(6723418373787727)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_COMPATIBLE.MSG_ID_FOUND_IN_ATTRIBUTES'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'ID found in the Button Attributes, for a button referenced in a Dynamic Action (%0). ',
'',
'When an ID is defined in Button Attributes, this will cause Dynamic Actions referencing the button not to work. Please consider removing this ID, as the button will generate an ID by default.'))
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(6725910839116736)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_COMPATIBLE.MSG_TEMPLATE_BUTTON_NO_BUTTON_ID'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Button Template used by a button, that itself is referenced in a Dynamic Action (%0) does not contain the #BUTTON_ID# substitution string.',
'',
'Template:',
'%1',
'',
'Please consider either adding the #BUTTON_ID# substitution string to this template or changing the button template to one that includes the #BUTTON_ID# substitution string.'))
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(8469915985140202)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_INCONSISTENT_REFS.MSG_ACTION_NOT_DEFINED_BY_DA'
,p_message_text=>'Button ''Action'' is not ''Defined by Dynamic Action'', for a button referenced in a Dynamic Action (%0).'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(9969927715808840)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_INCONSISTENT_REFS.MSG_NO_BUTTON_DEFINED_FOR_DA'
,p_message_text=>'Button (%0) has an ''Action'' of ''Defined by Dynamic Action'', but there is no corresponding Dynamic Action referencing this button.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25316715973869635)
,p_name=>'ADVISOR.CHECK.CLEAR_CACHE_PAGE_NUMBER.MSG_OTHER_PAGE'
,p_message_text=>'Clear Cache Page %0 is not the current or target page %1.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25315402063869633)
,p_name=>'ADVISOR.CHECK.COLUMN_SYNTAX.MSG_NOT_EXISTS'
,p_message_text=>'%0 does not exist.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(728339641269994550)
,p_name=>'ADVISOR.CHECK.DEPRECATED_ATTRIBUTES.MSG_ATTRIBUTE'
,p_message_text=>'This attribute value has been deprecated.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(746093378228936520)
,p_name=>'ADVISOR.CHECK.DEPRECATED_ATTRIBUTES.MSG_COMPONENT_TYPE'
,p_message_text=>'This component type has been deprecated.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(357364128938707207)
,p_name=>'ADVISOR.CHECK.DESC_AJAX_ITEMS_WITH_SSP'
,p_message_text=>'Protected items in Ajax calls'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(37149914027467871)
,p_name=>'ADVISOR.CHECK.DESC_APEX_CODE_SMELL'
,p_message_text=>'Code Smell (APEX internal)'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25308004897688115)
,p_name=>'ADVISOR.CHECK.DESC_APPL_PAGE_ITEM_REF'
,p_message_text=>'Declarative References of Application Items, Page Items, Columns or Interactive Report Filters'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(931429261300900875)
,p_name=>'ADVISOR.CHECK.DESC_AUTHORIZATION'
,p_message_text=>'Authorization'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25307421042683345)
,p_name=>'ADVISOR.CHECK.DESC_BIND_VARIABLE_SYNTAX'
,p_message_text=>'References with Bind Variable Syntax'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25310407929707996)
,p_name=>'ADVISOR.CHECK.DESC_BRANCH_SEQUENCE'
,p_message_text=>'Unconditional Branch before other Branches'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(931510289991221548)
,p_name=>'ADVISOR.CHECK.DESC_BROWSER_SECURITY'
,p_message_text=>'Browser Security Settings'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(6723215257786814)
,p_name=>'ADVISOR.CHECK.DESC_BUTTON_DA_COMPATIBLE'
,p_message_text=>'Button is not compatible with Dynamic Actions'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(9946705897802612)
,p_name=>'ADVISOR.CHECK.DESC_BUTTON_DA_INCONSISTENT_REFS'
,p_message_text=>'Inconsistent references between Dynamic Actions and Buttons'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25308620827692711)
,p_name=>'ADVISOR.CHECK.DESC_CLEAR_CACHE_PAGE_NUMBER'
,p_message_text=>'Clear Cache Page Number equals Target or Current Page'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25307213423681147)
,p_name=>'ADVISOR.CHECK.DESC_COLUMN_SYNTAX'
,p_message_text=>'References with Column Syntax'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(728337360892970978)
,p_name=>'ADVISOR.CHECK.DESC_DEPRECATED_ATTRIBUTES'
,p_message_text=>'Deprecated attribute values'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25309409530699006)
,p_name=>'ADVISOR.CHECK.DESC_DML_PROCESSES'
,p_message_text=>'Fetch, DML, MR* Processes are Valid'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25310201349706076)
,p_name=>'ADVISOR.CHECK.DESC_HARDCODED_APPLICATION_ID'
,p_message_text=>'Hardcoded Application ID'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(172104812234201851)
,p_name=>'ADVISOR.CHECK.DESC_HAS_HELP_TEXT'
,p_message_text=>'Page Item has Help Text'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(240623156551821000)
,p_name=>'ADVISOR.CHECK.DESC_HAS_PAGE_TITLE'
,p_message_text=>'Page has page title'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(247063415322317717)
,p_name=>'ADVISOR.CHECK.DESC_IMAGE_ITEM_HAS_ALT'
,p_message_text=>'Display Image item has image ALT text defined'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(573557583616659864)
,p_name=>'ADVISOR.CHECK.DESC_INSECURE_APPLICATION_DEFAULTS'
,p_message_text=>'Application attributes that can be locked down'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25307626583684954)
,p_name=>'ADVISOR.CHECK.DESC_IS_ITEM_OF_PAGE'
,p_message_text=>'Referenced Item is on Current Page'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25307832470686658)
,p_name=>'ADVISOR.CHECK.DESC_IS_ITEM_OF_TARGET_PAGE'
,p_message_text=>'Referenced Item is Page Item of Target Page'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(240679264181063844)
,p_name=>'ADVISOR.CHECK.DESC_ITEMS_NO_CONTEXT_CHANGE'
,p_message_text=>'Page item does not cause an unexpected context change'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(241922259823281882)
,p_name=>'ADVISOR.CHECK.DESC_ITEM_HAS_LABEL'
,p_message_text=>'Page item has label'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25310820396711546)
,p_name=>'ADVISOR.CHECK.DESC_ITEM_NAME_LENGTH'
,p_message_text=>'Length of Item or Tabular Form Column Name'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(37055831115179720)
,p_name=>'ADVISOR.CHECK.DESC_LEGACY_ORPHAN_COMPONENTS'
,p_message_text=>'Legacy Orphan Components'
,p_version_scn=>37165770887567
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25308210437689788)
,p_name=>'ADVISOR.CHECK.DESC_PAGE_ITEM_REF_AS_STRING'
,p_message_text=>'References of Page Item in a String'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25308415632691218)
,p_name=>'ADVISOR.CHECK.DESC_PAGE_NUMBER_EXISTS'
,p_message_text=>'Referenced Page Number Exists'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(240626832540486067)
,p_name=>'ADVISOR.CHECK.DESC_REGION_HAS_ROW_HEADER'
,p_message_text=>'Region has Row Header'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25311216072748119)
,p_name=>'ADVISOR.CHECK.DESC_REPORT_DEFAULT_ORDER'
,p_message_text=>'Report has Default Order'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(931536764055366995)
,p_name=>'ADVISOR.CHECK.DESC_SESSION_STATE_PROTECTION'
,p_message_text=>'Session State Protection'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25309614378700349)
,p_name=>'ADVISOR.CHECK.DESC_SQL_INJECTION'
,p_message_text=>'Inappropriate use of Substitution Syntax'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25307007536679465)
,p_name=>'ADVISOR.CHECK.DESC_SUBSTITUTION_SYNTAX'
,p_message_text=>'References with Substitution Syntax'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25309205028697628)
,p_name=>'ADVISOR.CHECK.DESC_TARGET_PAGE_AUTH_USABILITY'
,p_message_text=>'Target Page Authorization is also set for Current Component'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(240672089207637382)
,p_name=>'ADVISOR.CHECK.DESC_THEME_STYLE_IS_ACCESSIBLE'
,p_message_text=>'Theme Style tested for accessibility'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(342223406255329137)
,p_name=>'ADVISOR.CHECK.DESC_UI_INCLUDES_COMPATIBILITY_JS'
,p_message_text=>'User Interface includes compatibility JavaScript'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25310614163709730)
,p_name=>'ADVISOR.CHECK.DESC_VALIDATION_ASSOCIATED_ITEM'
,p_message_text=>'Associated Item or Column of Validations'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25308826021694302)
,p_name=>'ADVISOR.CHECK.DESC_VALID_SQL_PLSQL_CODE'
,p_message_text=>'Is Valid SQL or PL/SQL Code'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25310028923704534)
,p_name=>'ADVISOR.CHECK.DESC_VERIFY_CLOB_PROPERTY'
,p_message_text=>'Verify Clob Property'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25309819572701829)
,p_name=>'ADVISOR.CHECK.DESC_V_FUNCTION_IN_SQL'
,p_message_text=>'V Function used in SQL Statements'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25311026976713451)
,p_name=>'ADVISOR.CHECK.DESC_WHEN_BUTTON_PRESSED'
,p_message_text=>'Referenced Button in When Button Pressed exists'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25317305682869636)
,p_name=>'ADVISOR.CHECK.DML_PROCESSES.MSG_INVALID'
,p_message_text=>'Compilation error - %0 Statement: %1'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25317630457869636)
,p_name=>'ADVISOR.CHECK.HARDCODED_APPLICATION_ID.MSG_FOUND'
,p_message_text=>'Link contains the current Application ID as hardcoded value.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(172102828679168744)
,p_name=>'ADVISOR.CHECK.HAS_HELP_TEXT.MSG_NOT_DEFINED'
,p_message_text=>'No help text defined.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(240623793173854740)
,p_name=>'ADVISOR.CHECK.HAS_PAGE_TITLE.MSG_NOT_DEFINED'
,p_message_text=>'This page has no page title. Meaningful page titles are important for accessibility, to help users understand the content and purpose of the current page.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(247072235389367899)
,p_name=>'ADVISOR.CHECK.IMAGE_ITEM_HAS_ALT.MSG_NOT_DEFINED'
,p_message_text=>'The item is missing the alternative text required for the image. Good text to use for this should adequately describe the contents of the image, and also should not duplicate any information that is visible on the page displayed in the context of the'
||' image (to avoid possible duplication). Note: If the image is provided by users, then so too should the image alternative text be, with appropriate guidance to help your users provide high quality text.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(573558319384695449)
,p_name=>'ADVISOR.CHECK.INSECURE_APPLICATION_DEFAULTS.MSG_RUNTIME_API_USAGE'
,p_message_text=>'"Runtime API Usage" allows application and workspace modification.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25315805182869634)
,p_name=>'ADVISOR.CHECK.IS_ITEM_OF_PAGE.MSG_NOT_ITEM_OF_PAGE'
,p_message_text=>'%0 is not an item on page %1.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25315906592869634)
,p_name=>'ADVISOR.CHECK.IS_ITEM_OF_TARGET_PAGE.MSG_NOT_ITEM_OF_TARGET_PAGE'
,p_message_text=>'%0 is not an item on target page %1.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(240679667246079314)
,p_name=>'ADVISOR.CHECK.ITEMS_NO_CONTEXT_CHANGE.MSG_CAUSES_CHANGE_OF_CONTEXT'
,p_message_text=>'The setting ''Page Action on Selection'' for the page item could cause an unexpected change of context for the user. Consider switching to ''None'' so there is no change of context and replacing the functionality with Dynamic Actions or Cascading LOVs (i'
||'f you need to stay on the same page). Alternatively consider providing some information for the user so that they know what will happen, for example, adding ''Launches new page'' in the label. '
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(247038837204790392)
,p_name=>'ADVISOR.CHECK.ITEM_HAS_LABEL.MSG_NO_LABEL'
,p_message_text=>'A label for the item must be defined. If you prefer not to display a visible label, you should still define a label and then select the ''Hidden'' label template.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(241922654885316313)
,p_name=>'ADVISOR.CHECK.ITEM_HAS_LABEL.MSG_PLACEHOLDER_BUT_NO_LABEL'
,p_message_text=>'The item defines a ''Value Placeholder'' value, but no label. Placeholder text should not be used solely to label the item, as this causes accessibility issues. For better accessibility, an item label should be defined. If you prefer not to display a v'
||'isible label, you should still define a label and then select the ''Hidden'' label template.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25318029024869637)
,p_name=>'ADVISOR.CHECK.ITEM_NAME_LENGTH.MSG_TOO_LONG'
,p_message_text=>'Name has a length of %0 characters, but should have a maximum of 30 characters.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4746294442484784)
,p_name=>'ADVISOR.CHECK.LEGACY_ORPHAN_COMPONENTS.MSG_BUTTON_ORPHAN_FOUND'
,p_message_text=>'Button is found in the "Legacy Orphan Components" slot. It should be moved to a supported slot.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4746079327482902)
,p_name=>'ADVISOR.CHECK.LEGACY_ORPHAN_COMPONENTS.MSG_ITEM_ORPHAN_FOUND'
,p_message_text=>'Item is found in the "Legacy Orphan Components" slot. It should be moved to a supported slot.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25316221549869634)
,p_name=>'ADVISOR.CHECK.PAGE_ITEM_REF_AS_STRING.MSG_NOT_EXISTS'
,p_message_text=>'%0 might not exist.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25316300225869634)
,p_name=>'ADVISOR.CHECK.PAGE_ITEM_REF_AS_STRING.MSG_WRONG_REFERENCE'
,p_message_text=>'%0 might not be a page or application item'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25316611810869635)
,p_name=>'ADVISOR.CHECK.PAGE_NUMBER_EXISTS.MSG_CLEAR_CACHE_NOT_EXISTS'
,p_message_text=>'Clear Cache Page %1 (within application %0) does not exist.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25316431363869635)
,p_name=>'ADVISOR.CHECK.PAGE_NUMBER_EXISTS.MSG_NOT_EXISTS'
,p_message_text=>'Page %0 does not exist.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25316509183869635)
,p_name=>'ADVISOR.CHECK.PAGE_NUMBER_EXISTS.MSG_TARGET_NOT_EXISTS'
,p_message_text=>'Target Page %1 (within application %0) does not exist.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(181842959358531832)
,p_name=>'ADVISOR.CHECK.REGION_HAS_ROW_HEADER.MSG_COL_TOGGLE_NOT_DEFINED'
,p_message_text=>'The Column Toggle region does not have a column with ''Value Identifies Row'' set to ''Yes''. This should be defined on the column, or columns that help to identify the row of data (for example customer name in a report of customer information), and is i'
||'mportant for accessibility.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2201281381019534)
,p_name=>'ADVISOR.CHECK.REGION_HAS_ROW_HEADER.MSG_CR_NOT_DEFINED'
,p_message_text=>'The Classic Report region does not have a column with ''Value Identifies Row'' set to ''Yes''. This should be defined on the column, or columns that help to identify the row of data (for example customer name in a report of customer information), and is '
||'important for accessibility.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2801442691158342)
,p_name=>'ADVISOR.CHECK.REGION_HAS_ROW_HEADER.MSG_IG_NOT_DEFINED'
,p_message_text=>'The Interactive Grid region does not have a column with ''Value Identifies Row'' set to ''Yes''. This should be defined on the column, or columns that help to identify the row of data (for example customer name in a report of customer information), and i'
||'s important for accessibility.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2201480498021836)
,p_name=>'ADVISOR.CHECK.REGION_HAS_ROW_HEADER.MSG_IR_NOT_DEFINED'
,p_message_text=>'The Interactive Report region does not have a column with ''Value Identifies Row'' set to ''Yes''. This should be defined on the column, or columns that help to identify the row of data (for example customer name in a report of customer information), and'
||' is important for accessibility.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(181867445444623902)
,p_name=>'ADVISOR.CHECK.REGION_HAS_ROW_HEADER.MSG_REFLOW_NOT_DEFINED'
,p_message_text=>'The Reflow region does not have a column with ''Value Identifies Row'' set to ''Yes''. This should be defined on the column, or columns that help to identify the row of data (for example customer name in a report of customer information), and is importan'
||'t for accessibility.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(240627431814514759)
,p_name=>'ADVISOR.CHECK.REGION_HAS_ROW_HEADER.MSG_TABFORM_NOT_DEFINED'
,p_message_text=>'This Tabular Form region does not have a column with "Use as Row Header" set to Yes. The Row Header column should be the column that best identifies the current row (for example a customer name in a table of customer information). This information is'
||' then used when rendering the Tabular Form, to provide unique labels for each row''s form fields.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25318203115869637)
,p_name=>'ADVISOR.CHECK.REPORT_DEFAULT_ORDER.MSG_NO_DEFAULT_ORDER'
,p_message_text=>'Report does not have a default order.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(573559261376727748)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_BOOKMARK_CHECKSUM_FUNCTION'
,p_message_text=>'"Bookmark Hash Function" is set to a legacy algorithm.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(573559477274733790)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_NO_APP_PROTECTION'
,p_message_text=>'"Session State Protection" is disabled.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(931498729821018872)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_NO_PAGE_PROTECTION'
,p_message_text=>'On a page with a fetch process, you should use Page Access Protection and enable protection for the items that you pass via the URL.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(18961442298586347)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_NO_PREPARE_URL'
,p_message_text=>'Region contains "f?p" URL that is not passed through APEX_UTIL.PREPARE_URL.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25317402787869636)
,p_name=>'ADVISOR.CHECK.SQL_INJECTION.MSG_ITEM_SUBSTITUTION'
,p_message_text=>'Possible SQL Injection detected. %0 is used with substitution syntax in SQL, PL/SQL code or process table name.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25315216700869633)
,p_name=>'ADVISOR.CHECK.SUBSTITUTION_SYNTAX.MSG_NOT_EXISTS'
,p_message_text=>'%0 does not exist.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25315312914869633)
,p_name=>'ADVISOR.CHECK.SUBSTITUTION_SYNTAX.MSG_WRONG_REFERENCE'
,p_message_text=>'%0 cannot be referenced with substitution syntax.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25317228758869636)
,p_name=>'ADVISOR.CHECK.TARGET_PAGE_AUTH_USABILITY.MSG_NO_AUTH_DEFINED'
,p_message_text=>'Target page %1 (within application %0) has an authorization scheme defined, but current component does not.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(240672444358656828)
,p_name=>'ADVISOR.CHECK.THEME_STYLE_IS_ACCESSIBLE.MSG_NOT_ACCESSIBLE'
,p_message_text=>'The current Theme Style for the application has not been tested for accessibility. Please either switch to a Theme Style that has Accessibility Tested set to Yes, or if your current Theme Style has been tested, set its Accessibility Tested attribute '
||'to Yes under your Theme settings.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(342370355471829199)
,p_name=>'ADVISOR.CHECK.UI_INCLUDES_COMPATIBILITY_JS.MSG_JQUERY_MIGRATE'
,p_message_text=>'User Interface includes jQuery Migrate. jQuery Migrate helps when migrating to a newer version of jQuery by restoring removed APIs and shows warnings in the browser console when removed or deprecated APIs are used. This includes an extra JavaScript f'
||'ile on every page in your app. To help remove this, please review the jQuery Migrate upgrade guide for details of APIs which should be changed, then once you are confident you no longer rely on any of these APIs, set Include jQuery Migrate to No.'
,p_version_scn=>37165770887488
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(342223808924402055)
,p_name=>'ADVISOR.CHECK.UI_INCLUDES_COMPATIBILITY_JS.MSG_LEGACY_JS'
,p_message_text=>'User Interface includes Deprecated or Desupported JavaScript functions. This includes an extra JavaScript file on every page in your app. To help remove this, please review the ''Deprecated Features'' section of the Release Notes, where you will find i'
||'nstructions on how to check for dependencies to deprecated or desupported functions, and work towards no longer including this in your app.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25317928647869637)
,p_name=>'ADVISOR.CHECK.VALIDATION_ASSOCIATED_ITEM.MSG_NOT_DEFINED'
,p_message_text=>'Associated Item or Column is not defined, but "Error Message Display Location" would require it.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25317812276869637)
,p_name=>'ADVISOR.CHECK.VALIDATION_ASSOCIATED_ITEM.MSG_NOT_EQUAL'
,p_message_text=>'Associated Item or Column is not equal to "%0" specified in Validation Expression 1.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25316800142869635)
,p_name=>'ADVISOR.CHECK.VALID_SQL_PLSQL_CODE.MSG_INVALID'
,p_message_text=>'Compilation error - %0'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25316910802869636)
,p_name=>'ADVISOR.CHECK.VALID_SQL_PLSQL_CODE.MSG_NOT_DEFINED'
,p_message_text=>'No SQL or PL/SQL code defined.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25315110849869633)
,p_name=>'ADVISOR.CHECK.VERIFY_CLOB_PROPERTY.MSG_TOO_LONG'
,p_message_text=>'Is longer than 32767. Only the first 32767 are checked. Length: %0'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25317518541869636)
,p_name=>'ADVISOR.CHECK.V_FUNCTION_IN_SQL.MSG_CONTAINS_CALL'
,p_message_text=>'Contains V/NV/DV function call in SQL statement (can be a performance problem).'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25318106109869637)
,p_name=>'ADVISOR.CHECK.WHEN_BUTTON_PRESSED.MSG_NOT_EXISTS'
,p_message_text=>'Referenced button does not exist anymore.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(166097224445033723)
,p_name=>'AFTER'
,p_message_text=>'After'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145542516335207895)
,p_name=>'AGREEMENT_MISSING'
,p_message_text=>'Agreement missing'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1407693115634864)
,p_name=>'AI.CONSENT_MESSAGE'
,p_message_text=>'<p>Please review the documentation regarding <a rel="noopener noreferrer" target="_blank" href="%0">terms</a> governing certain features of Oracle APEX that allow you to use third-party services, including generative AI services. Clicking <strong>Acc'
||'ept</strong> below and your use of such features constitutes your acknowledgement of the terms.</p>'
,p_version_scn=>1891933781
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1408457477569663)
,p_name=>'AI.NO_APP_SERVICE_SET'
,p_message_text=>'A default AI Service must be specified at application level'
,p_version_scn=>1052655207
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1408269988576468)
,p_name=>'AI.NO_BUILDER_SERVICE_SET'
,p_message_text=>'An AI Service marked as "Used by App Builder" must exist in this workspace'
,p_version_scn=>1057826508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(6424552467881940)
,p_name=>'AI.NO_TABLES_FOUND'
,p_message_text=>'We could not find any tables that matched your request. If you have the tables needed for this type of application in the workspace default schema, please try to provide more details.'
,p_version_scn=>178456229
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1920190335217360)
,p_name=>'AI_CONFIG_RAG_SOURCES'
,p_message_text=>'AI Configuration - RAG Sources'
,p_version_scn=>177700252
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86584014582220650)
,p_name=>'ALIAS'
,p_message_text=>'Alias'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(484877215940188465)
,p_name=>'ALLOW_APP_BUILDING'
,p_message_text=>'Allow application building'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1478581304946132)
,p_name=>'ALLOW_EXTENSIONS'
,p_message_text=>'Allow Hosting Extensions'
,p_version_scn=>24837499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(403370385927921636)
,p_name=>'ALLOW_PACKAGED_APP_INS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Allow installation of productivity and sample applications.',
''))
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(320716805963100795)
,p_name=>'ALLOW_RESTFUL_SERVICES'
,p_message_text=>'Allow Use of RESTful Services'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(484878120789189881)
,p_name=>'ALLOW_SQL_WORKSHOP'
,p_message_text=>'Allow SQL Workshop Use'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(484878800488193470)
,p_name=>'ALLOW_TEAM_DEVELOPMENT'
,p_message_text=>'Allow Use of Team Development'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(484869812038130500)
,p_name=>'ALLOW_TO_BE_PURGED_YN'
,p_message_text=>'Allow workspace to be purged'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(87983805377032963)
,p_name=>'ALL_APPLICATIONS'
,p_message_text=>'All Applications'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(14632001252651677)
,p_name=>'ALL_APPLICATIONS_NULL_DISP'
,p_message_text=>'- All - '
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(14574000363462192)
,p_name=>'ALL_CATEGORIES'
,p_message_text=>'All Categories'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(14632516489656103)
,p_name=>'ALL_CATEGORIES_NULL_DISP'
,p_message_text=>'- All Categories -'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(485076117219856761)
,p_name=>'ALL_MILESTONES'
,p_message_text=>'All Milestones'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(251172702018475751)
,p_name=>'ALL_RELEASES'
,p_message_text=>'All Releases'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(88269320723696242)
,p_name=>'ALL_STATIC_FILES'
,p_message_text=>'all static files'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(88150006909944679)
,p_name=>'ALL_THEMES'
,p_message_text=>'all themes'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(495226290774101568)
,p_name=>'ALL_TYPES'
,p_message_text=>'All Types'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(495248866860596614)
,p_name=>'ALL_TYPES_NULL_DISP'
,p_message_text=>'- All Types -'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(88002619472254588)
,p_name=>'ALL_USERS'
,p_message_text=>'All Users'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(907031286000990559)
,p_name=>'ALREADY_IN_ACL'
,p_message_text=>'User is already has an APEX account'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(829735640879014301)
,p_name=>'ALREADY_IN_WS'
,p_message_text=>'User already exists in workspace'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(653851581838798040)
,p_name=>'ALWAYS'
,p_message_text=>'Always'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(172941223450974103)
,p_name=>'ANALYSIS'
,p_message_text=>'%0 Analysis'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(172950716749038434)
,p_name=>'ANALYZE'
,p_message_text=>'Analyze by %0'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(270684517232453645)
,p_name=>'ANALYZE_TABLE'
,p_message_text=>'Analyze using %0 method'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(88139419358796943)
,p_name=>'ANONYMOUS_BLOCK'
,p_message_text=>'anonymous block'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(26172702490478302)
,p_name=>'ANSWERS'
,p_message_text=>'Answers'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(18929017490190454)
,p_name=>'ANY_DEVELOPER'
,p_message_text=>'(Any Developer)'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1412118393021287)
,p_name=>'APEX.ACL_NOT_ASSIGNED'
,p_message_text=>'The &PRODUCT_NAME. user has not been granted an ACL to access the target host. See section "Enabling Network Services in Oracle Database" in the &PRODUCT_NAME. Installation Guide.'
,p_version_scn=>129636705
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1813973379818556359)
,p_name=>'APEX.ACTIVITY_BY_HOUR.APPCHANGES'
,p_message_text=>'Application Changes:'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1813920029513387028)
,p_name=>'APEX.ACTIVITY_BY_HOUR.HOUR'
,p_message_text=>'Hour:'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1834499481255569864)
,p_name=>'APEX.ACTIVITY_BY_HOUR.K'
,p_message_text=>'%0 K'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1813974106561558043)
,p_name=>'APEX.ACTIVITY_BY_HOUR.PAGEVIEWS'
,p_message_text=>'Page Views: '
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(17616082422963647)
,p_name=>'APEX.ADMIN_DIGEST.APP_DELETED'
,p_message_text=>'Application %0 was removed.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1449677835587436)
,p_name=>'APEX.ADMIN_DIGEST.ATTRIBUTE_CREATED'
,p_message_text=>'Attribute changed to %2 for user %1 in workspace %0.'
,p_version_scn=>61306353
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(23641335759567106)
,p_name=>'APEX.ADMIN_DIGEST.CONTAINER'
,p_message_text=>'Container'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1449869287607311)
,p_name=>'APEX.ADMIN_DIGEST.DEVELOPER_ROLE_CREATED'
,p_message_text=>'Developer role %3 created for user %1 in workspace %4.'
,p_version_scn=>61311640
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1450084558609967)
,p_name=>'APEX.ADMIN_DIGEST.DEVELOPER_ROLE_UPDATED'
,p_message_text=>'Developer role %3 updated for user %1 in workspace %4.'
,p_version_scn=>61312511
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(23642828161608106)
,p_name=>'APEX.ADMIN_DIGEST.ERRINSTANCE'
,p_message_text=>'Error Instance ID'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(23643096447630672)
,p_name=>'APEX.ADMIN_DIGEST.ERR_SEQ'
,p_message_text=>'Error Instance Sequence'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(23641515081570667)
,p_name=>'APEX.ADMIN_DIGEST.HOST_ID'
,p_message_text=>'Host ID'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(23642488011595351)
,p_name=>'APEX.ADMIN_DIGEST.MESSAGE_GROUP'
,p_message_text=>'Message Group'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(23642646505598460)
,p_name=>'APEX.ADMIN_DIGEST.MESSAGE_ID'
,p_message_text=>'Message ID'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(23641718765576282)
,p_name=>'APEX.ADMIN_DIGEST.MESSAGE_LEVEL'
,p_message_text=>'Message Level'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1449020610579392)
,p_name=>'APEX.ADMIN_DIGEST.PREFERENCE_CREATED'
,p_message_text=>'Preference %1 with the value of %2 was created in workspace %0.'
,p_version_scn=>61306122
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1449201119581743)
,p_name=>'APEX.ADMIN_DIGEST.PREFERENCE_DELETED'
,p_message_text=>'Preference %1 was deleted from workspace %0.'
,p_version_scn=>61306168
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1449494082583958)
,p_name=>'APEX.ADMIN_DIGEST.PREFERENCE_UPDATED'
,p_message_text=>'Preference %1 was updated to value %2 in workspace %0.'
,p_version_scn=>61306303
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(23643290109641256)
,p_name=>'APEX.ADMIN_DIGEST.PROBLEMKEY'
,p_message_text=>'Problem Key'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(17615592708921820)
,p_name=>'APEX.ADMIN_DIGEST.SCHEMA_CREATED'
,p_message_text=>'New schema %1 added to the workspace %0.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(17615787902937486)
,p_name=>'APEX.ADMIN_DIGEST.SCHEMA_DELETED'
,p_message_text=>'Schema %1 removed from the workspace %0.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(17616202073978429)
,p_name=>'APEX.ADMIN_DIGEST.SCHEMA_EXCEPTION_CREATED'
,p_message_text=>'A schema exception was created. This allows assignment of restricted schema: %0 to workspace: %1.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(17616467372987458)
,p_name=>'APEX.ADMIN_DIGEST.SCHEMA_EXCEPTION_DELETED'
,p_message_text=>'Exception removed for restricted schema: %0 to workspace: %1.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(17616758261013958)
,p_name=>'APEX.ADMIN_DIGEST.SCHEMA_RESTRICT'
,p_message_text=>'Schema %0 has no privilege to be assigned to a workspace.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(17616918469021013)
,p_name=>'APEX.ADMIN_DIGEST.SCHEMA_UNRESTRICT'
,p_message_text=>'Schema %0 recovered all privileges to be assigned to a workspace.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1448020297563636)
,p_name=>'APEX.ADMIN_DIGEST.USER_CREATED'
,p_message_text=>'User %1 was created for workspace %0.'
,p_version_scn=>61305482
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1448295651566192)
,p_name=>'APEX.ADMIN_DIGEST.USER_DELETED'
,p_message_text=>'User %1 was deleted in workspace %0.'
,p_version_scn=>61305821
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1448621604571755)
,p_name=>'APEX.ADMIN_DIGEST.USER_GROUP_CREATED'
,p_message_text=>'User group %1 created within workspace %3.'
,p_version_scn=>61305976
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1448881532573824)
,p_name=>'APEX.ADMIN_DIGEST.USER_GROUP_DELETED'
,p_message_text=>'User group %1 deleted from workspace %3.'
,p_version_scn=>61306019
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1448472550569479)
,p_name=>'APEX.ADMIN_DIGEST.USER_UPDATED'
,p_message_text=>'User %1 updated for workspace %0.'
,p_version_scn=>61305879
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(17613234252787969)
,p_name=>'APEX.ADMIN_DIGEST.WKSP_CREATED'
,p_message_text=>'Workspace %1 created. Source Identifier: %2. New schema: %3. Resource Manager Consumer Group: %4.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(17615293941895697)
,p_name=>'APEX.ADMIN_DIGEST.WKSP_DELETED'
,p_message_text=>'Workspace %1 removed.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(17614076592844376)
,p_name=>'APEX.ADMIN_DIGEST.WKSP_UPDATED'
,p_message_text=>'Workspace %1 updated. New schema %3 added. Resource Manager Consumer Group changed: %4.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(566012924313444410)
,p_name=>'APEX.API.RUNTIME_API_USAGE.ERROR'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'An API call has been prohibited.',
'Contact your administrator.',
'Details about this incident are available via debug id "%0".'))
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(39872803540444214)
,p_name=>'APEX.ASSERT.DESUPPORTED_API'
,p_message_text=>'The API call "%0" has been desupported in Oracle APEX version %1. Details about this incident are available via debug id "%2".'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(192412832512555774)
,p_name=>'APEX.ASSERT.FUNCTION_BODY_START'
,p_message_text=>'Function Body must start with DECLARE,BEGIN, or RETURN'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(192412534599555773)
,p_name=>'APEX.ASSERT.NO_DYNAMIC_SQL'
,p_message_text=>'Query must not contain dynamic SQL: %0'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(192412959337555774)
,p_name=>'APEX.ASSERT.SQL_OR_FUNCTION_START'
,p_message_text=>'Expected DECLARE,BEGIN,RETURN,SELECT, or WITH'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(192412686692555774)
,p_name=>'APEX.ASSERT.SQL_QUERY_START'
,p_message_text=>'Query must begin with SELECT or WITH'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(192413035367555774)
,p_name=>'APEX.ASSERT.VERIFY_PARSING_SCHEMA'
,p_message_text=>'Invalid parsing schema for current workspace ID'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(192412785576555774)
,p_name=>'APEX.ASSERT.WHERE_CLAUSE_START'
,p_message_text=>'WHERE clause must start with WHERE'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(180071718656895367)
,p_name=>'APEX.AUTO_COMPLETE.NOT_IN_LIST'
,p_message_text=>'#LABEL# does not exist in list.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(6201033197359306)
,p_name=>'APEX.BRANCH.MODAL.BEFORE_HEADER_NOT_SUPPORTED'
,p_message_text=>'Before Header branches to Modal Dialog pages are not supported.'
,p_version_scn=>167650729
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(447793064593724800)
,p_name=>'APEX.BRANCH.SHOW_ONLY_NOT_SUPPORTED'
,p_message_text=>'Show Only branches are not supported if the page attribute "Reload on Submit" is set to "Only for Success".'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(88359402284059953)
,p_name=>'APEX.BRANCH.UNHANDLED_ERROR'
,p_message_text=>'Error processing branch.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(6102403194325087)
,p_name=>'APEX.COMPUTATION.UNHANDLED_ERROR'
,p_message_text=>'Error processing computation.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86839409490701736)
,p_name=>'APEX.CONDITION.UNHANDLED_ERROR'
,p_message_text=>'Error processing condition.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(106572910593837829)
,p_name=>'APEX.CONDITION.UNKNOWN_TYPE'
,p_message_text=>'Unknown condition type "%0"'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4900993327931858)
,p_name=>'APEX.DATA.LOAD.INVALID_FILE_BROWSE_ITEM'
,p_message_text=>'File browse item %0 must use APEX_APPLICATION_TEMP_FILES table.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1432776207207445)
,p_name=>'APEX.DATA.LOAD.MERGE_NOT_ALLOWED_FOR_COLLECTION'
,p_message_text=>'"Merge" loading type is not supported for loading into collections.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(623765043314141060)
,p_name=>'APEX.DATA.LOAD.MERGE_REQUIRES_PRIMARY_KEY'
,p_message_text=>'"Merge" loading type requires at least one primary key column in the Data Profile.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(623764585237131712)
,p_name=>'APEX.DATA.LOAD.SQL_QUERY_ERROR'
,p_message_text=>'Loading Source SQL Query cannot be parsed: %0.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(623764814985136441)
,p_name=>'APEX.DATA.LOAD.SQL_QUERY_RETURNS_WRONG_DATA_TYPE'
,p_message_text=>'Loading Source SQL Query must return VARCHAR2, CLOB or BLOB.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(148432930458802696)
,p_name=>'APEX.DIALOG.PAGE.ERROR'
,p_message_text=>'Application %0 Dialog page %1 cannot be rendered successfully.  Ensure the page template in use on page %1 is of template type "Dialog page", with appropriate JavaScript dialog initialization, dialog closure and dialog cancel code defined.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1502116932934915858)
,p_name=>'APEX.EMAIL.COPYRIGHT'
,p_message_text=>'Copyright &copy; %0, All rights reserved.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1502124066455975274)
,p_name=>'APEX.EMAIL.CREATE_WORKSPACE'
,p_message_text=>'Create Workspace'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1502114784898909741)
,p_name=>'APEX.EMAIL.DISCLAIMER'
,p_message_text=>'This is a system generated message. Do not reply to this message.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1613712881630550691)
,p_name=>'APEX.EMAIL.ENVIRONMENT'
,p_message_text=>'Environment'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1967442919973765677)
,p_name=>'APEX.EMAIL.GENERIC_USER'
,p_message_text=>'Oracle APEX User'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1502212088742654552)
,p_name=>'APEX.EMAIL.GET_STARTED'
,p_message_text=>'Get Started'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1502117332712920703)
,p_name=>'APEX.EMAIL.GREETING'
,p_message_text=>'Hello %0,'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1502149330315258964)
,p_name=>'APEX.EMAIL.PASSWORD'
,p_message_text=>'Password'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1613713006899553480)
,p_name=>'APEX.EMAIL.PREVENT_PURGE'
,p_message_text=>'Prevent Workspace Purge'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1502204926674566759)
,p_name=>'APEX.EMAIL.PURGE.BODY'
,p_message_text=>'You can prevent your workspace from being purged by clicking the button below and following the on-screen instructions. If you do not act in %0 day(s), your workspace will automatically be removed.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1613712296050542306)
,p_name=>'APEX.EMAIL.PURGE.FOOTER'
,p_message_text=>'No action is necessary if you no longer require your workspace.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1613713484429562581)
,p_name=>'APEX.EMAIL.PURGE.HEADING'
,p_message_text=>'Your workspace is about to be purged!'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1613657056143871428)
,p_name=>'APEX.EMAIL.PURGE.INTRO'
,p_message_text=>'Your workspace %0 has not shown any recent activity and is scheduled to be purged soon.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1613656545025863893)
,p_name=>'APEX.EMAIL.PURGE.SUBJECT'
,p_message_text=>'Warning! Your workspace "%0" is about to be purged.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1613712651034549844)
,p_name=>'APEX.EMAIL.PURGE_DATE'
,p_message_text=>'Purge Date'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1613742878448803925)
,p_name=>'APEX.EMAIL.REQUEST_ACTION_REQ'
,p_message_text=>'Please complete your workspace request.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1613742454843790049)
,p_name=>'APEX.EMAIL.REQUEST_APPROVED'
,p_message_text=>'Your workspace "%0" is ready!'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1613743107291808807)
,p_name=>'APEX.EMAIL.REQUEST_APPROVE_2'
,p_message_text=>'Your workspace "%0" has been approved!'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1613742623658795476)
,p_name=>'APEX.EMAIL.REQUEST_DECLINED'
,p_message_text=>'Your workspace request has been declined.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1502121240784948033)
,p_name=>'APEX.EMAIL.USERNAME'
,p_message_text=>'Username'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1613713229763560062)
,p_name=>'APEX.EMAIL.WARNING'
,p_message_text=>'Warning!'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1502121035475947160)
,p_name=>'APEX.EMAIL.WORKSPACE'
,p_message_text=>'Workspace'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1502118841897926686)
,p_name=>'APEX.EMAIL.WS_REQ_APPR'
,p_message_text=>'Workspace Request Approved'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1502124299811978438)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_FOOTER'
,p_message_text=>'Click the button below to complete the approval process and set your password.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1502119253893931555)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_INTRO'
,p_message_text=>'Your workspace request has been approved!'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1502148776991221459)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_READY_FOOTER'
,p_message_text=>'Click the button below to get started.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1502149978894274097)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_READY_INTRO'
,p_message_text=>'Your workspace is ready!'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1502119014367928428)
,p_name=>'APEX.EMAIL.WS_REQ_DECL'
,p_message_text=>'Workspace Request Declined'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1502119682600937556)
,p_name=>'APEX.EMAIL.WS_REQ_DECL_INTRO'
,p_message_text=>'Sorry, your workspace request has been declined.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(230785551309946848)
,p_name=>'APEX.FEATURE.EMAIL_REPORTING.QUEUED'
,p_message_text=>'Queued'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(230785723092947749)
,p_name=>'APEX.FEATURE.EMAIL_REPORTING.SENT'
,p_message_text=>'Sent'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(16215668814939242)
,p_name=>'APEX.FEEDBACK.FEEDBACK_ENTRIES'
,p_message_text=>'Feedback Entries'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(16215867669940917)
,p_name=>'APEX.FEEDBACK.OPEN_FEEDBACK_ENTRIES'
,p_message_text=>'Open Feedback Entries'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(16216741984949755)
,p_name=>'APEX.FEEDBACK.USERS'
,p_message_text=>'Users'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(135860124558880754)
,p_name=>'APEX.GROUP.NOT_FOUND'
,p_message_text=>'Group "%0" could not be found'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1007658038863784512)
,p_name=>'APEX.HELP.VIEW_DOC'
,p_message_text=>'View Documentation'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(6169169552872633)
,p_name=>'APEX.HTTP.DOWNLOAD_NOT_SUPPORTED'
,p_message_text=>'Downloads are not supported if the page attribute "Reload on Submit" is set to "Only for Success". Change the page attribute "Reload on Submit" to "Always" or use a before header process.'
,p_version_scn=>72849545
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(42882491343010755)
,p_name=>'APEX.HTTP.HEADER.DUPLICATE'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'The HTTP header %0 was sent twice, this could be an attack.',
'<ul>',
'<li>1st value: "%1"</li>',
'<li>2nd value: "%2"</li>',
'</ul>'))
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(66173618008083723)
,p_name=>'APEX.INSTANCE_ADMIN.BIPUB_OPTION'
,p_message_text=>'Printing support must be STANDARD, ADVANCED, APEX_LISTENER, AOP or NONE.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(311469125967828275)
,p_name=>'APEX.INSTANCE_ADMIN.CANT_DEFER_FREE'
,p_message_text=>'You cannot defer the upgrade on a free instance'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(66174023549085299)
,p_name=>'APEX.INSTANCE_ADMIN.FIRST_SCHEMA'
,p_message_text=>'Cannot remove first schema provisioned'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(24557818073907060)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_APPLICATION'
,p_message_text=>'Invalid application ID.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(249468900103202117)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_EMAIL_ADDRESS'
,p_message_text=>'Invalid Email address'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1503702698027035)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_EXTENSION_WORKSPACE'
,p_message_text=>'Invalid extension workspace.'
,p_version_scn=>52289703
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(21961906187835010)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_HISTORY_DAYS'
,p_message_text=>'Value must be zero or a positive integer.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(66174529782087088)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_PORT'
,p_message_text=>'Invalid port number'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(295567327400638221)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_SUBSCRIPTION'
,p_message_text=>'Invalid subscription ID.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(66174904979089370)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_WALLET'
,p_message_text=>'Wallet path must be in the form file:<filesystempath>'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(98891620098834899)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_WORKSPACE'
,p_message_text=>'The workspace was not found.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(98882701388753837)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_WORKSPACE_ID'
,p_message_text=>'Invalid workspace ID.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(107047388434655289)
,p_name=>'APEX.INSTANCE_ADMIN.LIMIT'
,p_message_text=>'Value must not be greater than %0.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1740472563251004)
,p_name=>'APEX.INSTANCE_ADMIN.PARAMETER_IS_NOT_FLAT_JSON'
,p_message_text=>'The value of instance parameter "%0" must be valid JSON with a flat structure.'
,p_version_scn=>1843716
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(79475304028561473)
,p_name=>'APEX.INSTANCE_ADMIN.PARAMETER_REGEXP_MISMATCH'
,p_message_text=>'The value "%1" of instance parameter "%0" does not match regular expression "%2"'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(79475223911236089)
,p_name=>'APEX.INSTANCE_ADMIN.PARAMETER_REQUIRED'
,p_message_text=>'The instance parameter "%0" must have a value'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(66175510866091123)
,p_name=>'APEX.INSTANCE_ADMIN.PARM_NOTFOUND'
,p_message_text=>'Instance parameter not found'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(288077407792782328)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.APEX-AUTH'
,p_message_text=>'Password'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(6115905511977304)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.CLOUD_IDM-AUTH'
,p_message_text=>'Password (For authentication against workspace user account repository only)'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(480992070311969668)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.HEADER-AUTH'
,p_message_text=>'Password (For authentication against workspace user account repository only)'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(362586005740005181)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.LDAP-AUTH'
,p_message_text=>'Password (For authentication against workspace user account repository only)'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(38550715718983061)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.SAML-AUTH'
,p_message_text=>'Password (For authentication against workspace user account repository only)'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(118624798306312512)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.SOCIAL-AUTH'
,p_message_text=>'Password (For authentication against workspace user account repository only)'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(288073403983781233)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.SSO-AUTH'
,p_message_text=>'Password (For authentication against workspace user account repository only)'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(66312611523315675)
,p_name=>'APEX.INSTANCE_ADMIN.PRINTSVR_PROTOCOL'
,p_message_text=>'Print server protocol must be either http or https'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(66313020874318381)
,p_name=>'APEX.INSTANCE_ADMIN.SCHEMA_DOES_NOT_EXIST'
,p_message_text=>'Schema does not exist'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(66313428492320660)
,p_name=>'APEX.INSTANCE_ADMIN.SCHEMA_RESTRICTED'
,p_message_text=>'Schema is restricted'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(311468748162820278)
,p_name=>'APEX.INSTANCE_ADMIN.UPGRADE_NOT_AVAILABLE'
,p_message_text=>'Upgrade is not available'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(311468922929825330)
,p_name=>'APEX.INSTANCE_ADMIN.UPGRADE_RUNNING'
,p_message_text=>'Upgrade is already running'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15755597969243546)
,p_name=>'APEX.ISSUES.APPLICATION'
,p_message_text=>'Application'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15755119993235451)
,p_name=>'APEX.ISSUES.APPLICATION_NO_LONGER_EXISTS'
,p_message_text=>'Application no longer exists'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(510501949159987765)
,p_name=>'APEX.ISSUES.ASSIGN'
,p_message_text=>'Assign'
,p_is_js_message=>true
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(93814477731170564)
,p_name=>'APEX.ISSUES.ATTACHMENTS'
,p_message_text=>'Attachments'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(681640508284272117)
,p_name=>'APEX.ISSUES.CARDS'
,p_message_text=>'Cards'
,p_is_js_message=>true
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(16222824335265439)
,p_name=>'APEX.ISSUES.CLOSED'
,p_message_text=>'Closed'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15763795466715114)
,p_name=>'APEX.ISSUES.COMMENTED'
,p_message_text=>'Commented'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15762404351690795)
,p_name=>'APEX.ISSUES.COMMENTS'
,p_message_text=>'comments'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(16223080303266791)
,p_name=>'APEX.ISSUES.COMPLETE'
,p_message_text=>'Complete'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(150589340191932058)
,p_name=>'APEX.ISSUES.CREATED_THIS_ISSUE'
,p_message_text=>'Created this issue %0'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(6788125556287759)
,p_name=>'APEX.ISSUES.DELETE'
,p_message_text=>'Delete'
,p_is_js_message=>true
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(6787551832283275)
,p_name=>'APEX.ISSUES.DELETE_COMMENT_CONFIRM'
,p_message_text=>'Are you sure you want to delete this comment?'
,p_is_js_message=>true
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(500030975775711386)
,p_name=>'APEX.ISSUES.DELETE_ISSUE'
,p_message_text=>'Delete Issue'
,p_is_js_message=>true
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(10546849968035579)
,p_name=>'APEX.ISSUES.DELETE_ISSUE_CONFIRM'
,p_message_text=>'Are you sure you want to delete this issue?'
,p_is_js_message=>true
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15769641748946864)
,p_name=>'APEX.ISSUES.DOCUMENT'
,p_message_text=>'Document'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15765460435759253)
,p_name=>'APEX.ISSUES.DOCUMENTS'
,p_message_text=>'Documents'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(6787823569286241)
,p_name=>'APEX.ISSUES.EDIT'
,p_message_text=>'Edit'
,p_is_js_message=>true
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(563176259568667423)
,p_name=>'APEX.ISSUES.EDIT_COMMENT'
,p_message_text=>'Edit Comment'
,p_is_js_message=>true
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(563176612274669818)
,p_name=>'APEX.ISSUES.EDIT_ISSUE'
,p_message_text=>'Edit Issue'
,p_is_js_message=>true
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15757514978409950)
,p_name=>'APEX.ISSUES.ERR_APP_DOES_NOT_EXIST'
,p_message_text=>'Application specified does not exist in this workspace.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15758386464439501)
,p_name=>'APEX.ISSUES.ERR_ATTEMPTING_TO_DELETE_COMMENT'
,p_message_text=>'Error attempting to delete comment.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15758128174434701)
,p_name=>'APEX.ISSUES.ERR_COMMENT_NOT_FOUND'
,p_message_text=>'Comment not found.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15758928743451732)
,p_name=>'APEX.ISSUES.ERR_ISSUE_NOT_FOUND'
,p_message_text=>'Issue not found.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15759119813458689)
,p_name=>'APEX.ISSUES.ERR_MARKING_ISSUE_FOR_DELETE'
,p_message_text=>'Error attempting to mark issue for delete.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15757721148415641)
,p_name=>'APEX.ISSUES.ERR_PAGE_DOES_NOT_EXIST'
,p_message_text=>'Page specified does not exist in this workspace or in the provided application.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15758560186445720)
,p_name=>'APEX.ISSUES.ERR_USER_NOT_AUTH_DELETE_COMMENT'
,p_message_text=>'User is not authorized to delete this comment.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15759330510464873)
,p_name=>'APEX.ISSUES.ERR_USER_NOT_AUTH_TO_DELETE_ISSUE'
,p_message_text=>'User not authorized to delete this issue.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15757977766430563)
,p_name=>'APEX.ISSUES.ERR_USER_NOT_AUTH_VISIBILITY'
,p_message_text=>'User is not authorized to change the visibility of this comment.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(598679943579795070)
,p_name=>'APEX.ISSUES.FILE_SIZE_CHECK_ERROR'
,p_message_text=>'There was a problem checking file sizes. Please contact your system administrator.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(598679623924784998)
,p_name=>'APEX.ISSUES.FILE_SIZE_PLURAL'
,p_message_text=>'One of these files is larger than the max file size of %0 bytes.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(598669656884776816)
,p_name=>'APEX.ISSUES.FILE_SIZE_SINGULAR'
,p_message_text=>'This file is larger than the maximum file size of %0 bytes.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(6788392375288492)
,p_name=>'APEX.ISSUES.HIDE'
,p_message_text=>'Hide'
,p_is_js_message=>true
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15769212667944478)
,p_name=>'APEX.ISSUES.IMAGE'
,p_message_text=>'Image'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15765090237756188)
,p_name=>'APEX.ISSUES.IMAGES'
,p_message_text=>'Images'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15754321445205293)
,p_name=>'APEX.ISSUES.ISSUE_NOT_FOUND'
,p_message_text=>'an issue that was not found in the system'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1659503297613032)
,p_name=>'APEX.ISSUES.JS.ADD_NOTIFICATION_PREFS'
,p_message_text=>'Add Preference for User'
,p_is_js_message=>true
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15763984156734988)
,p_name=>'APEX.ISSUES.JS.ATTACH_FILES'
,p_message_text=>'Attach Files'
,p_is_js_message=>true
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15761764932646517)
,p_name=>'APEX.ISSUES.JS.CLOSED'
,p_message_text=>'Closed'
,p_is_js_message=>true
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(698743093683144194)
,p_name=>'APEX.ISSUES.JS.HEADING'
,p_message_text=>'Heading'
,p_is_js_message=>true
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15767952903890575)
,p_name=>'APEX.ISSUES.JS.IS_EMPTY'
,p_message_text=>'is empty.'
,p_is_js_message=>true
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15767555285843328)
,p_name=>'APEX.ISSUES.JS.ONE_OF_THESE_FILES_IS'
,p_message_text=>'One of these files is'
,p_is_js_message=>true
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15761331822642524)
,p_name=>'APEX.ISSUES.JS.OPEN'
,p_message_text=>'Open'
,p_is_js_message=>true
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15776591708128695)
,p_name=>'APEX.ISSUES.JS.PERMANENTLY_DELETE_SELECTED'
,p_message_text=>'Permanently Delete Selected'
,p_is_js_message=>true
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(500417367361378905)
,p_name=>'APEX.ISSUES.JS.PURGE_ALL'
,p_message_text=>'Purge All'
,p_is_js_message=>true
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15776301247123383)
,p_name=>'APEX.ISSUES.JS.RESINSTATE_SELECTED'
,p_message_text=>'Reinstate Selected'
,p_is_js_message=>true
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15764105164737383)
,p_name=>'APEX.ISSUES.JS.RESPONSE_TEMPLATES'
,p_message_text=>'Response Templates'
,p_is_js_message=>true
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15767745366885392)
,p_name=>'APEX.ISSUES.JS.SINGLE_TOO_LARGE'
,p_message_text=>'too large to upload. <br>Files must be less than'
,p_is_js_message=>true
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15768686319917121)
,p_name=>'APEX.ISSUES.JS.SUPPORTED_FILE_TYPES_ARE'
,p_message_text=>'Supported file types are: '
,p_is_js_message=>true
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(586263564801423122)
,p_name=>'APEX.ISSUES.JS.TEMPLATE'
,p_message_text=>'Select a Response Template'
,p_is_js_message=>true
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15767379936829231)
,p_name=>'APEX.ISSUES.JS.THIS_FILE_IS'
,p_message_text=>'This file is'
,p_is_js_message=>true
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15768144002899184)
,p_name=>'APEX.ISSUES.JS.UNSUPPORTED_FILE_TYPE'
,p_message_text=>'not a supported file type.'
,p_is_js_message=>true
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459414268865169612)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.BUG'
,p_message_text=>'Bug'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459415474770182851)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.DOCUMENTATIONISSUE'
,p_message_text=>'Documentation Issue'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459414410540173125)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.ENHANCEMENTREQUEST'
,p_message_text=>'Enhancement Request'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459414695207174891)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.FEATUREREQUEST'
,p_message_text=>'Feature Request'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459415270051180858)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.INSTALLATIONISSUE'
,p_message_text=>'Installation Issue'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459415061051178881)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.PERFORMANCEISSUE'
,p_message_text=>'Performance Issue'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459414826096176730)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.SECURITYISSUE'
,p_message_text=>'Security Issue'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459415630553184166)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.TRAININGISSUE'
,p_message_text=>'Training Issue'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459417047404196234)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.ADMINISTRATION'
,p_message_text=>'Administration'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459416482013191574)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.CSSHTML'
,p_message_text=>'CSS / HTML'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459416658696194018)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.DAJAVASCRIPT'
,p_message_text=>'Dynamic Actions / JavaScript'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459416028114188787)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.DATABASE'
,p_message_text=>'Database'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459417246817198623)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.EXTINTEGRATION'
,p_message_text=>'External System Integration'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459416251897190299)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.RESTINTEGRATION'
,p_message_text=>'REST Integration'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459416861408194923)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.SECURITY'
,p_message_text=>'Security'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459415881988187616)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.UIUX'
,p_message_text=>'UI / UX'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459414055537163639)
,p_name=>'APEX.ISSUES.LABELS.GROUP.CATEGORY.DESC'
,p_message_text=>'Category assigned to the issue.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459412139945138517)
,p_name=>'APEX.ISSUES.LABELS.GROUP.CATEGORY.NAME'
,p_message_text=>'Category'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459413873260160868)
,p_name=>'APEX.ISSUES.LABELS.GROUP.FUNCTIONALAREA.DESC'
,p_message_text=>'Functional area affected by the issue.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459412387728141273)
,p_name=>'APEX.ISSUES.LABELS.GROUP.FUNCTIONALAREA.NAME'
,p_message_text=>'Functional Area'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459413600296157679)
,p_name=>'APEX.ISSUES.LABELS.GROUP.IMPORTANCE.DESC'
,p_message_text=>'Level of importance assigned to the issue.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459412515948143780)
,p_name=>'APEX.ISSUES.LABELS.GROUP.IMPORTANCE.NAME'
,p_message_text=>'Importance'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459413402585154504)
,p_name=>'APEX.ISSUES.LABELS.GROUP.LEVELOFEFFORT.DESC'
,p_message_text=>'Level of effort to address the issue.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459412757477145573)
,p_name=>'APEX.ISSUES.LABELS.GROUP.LEVELOFEFFORT.NAME'
,p_message_text=>'Level of Effort'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459413219977151330)
,p_name=>'APEX.ISSUES.LABELS.GROUP.PROGRESS.DESC'
,p_message_text=>'Progress against the issue.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459412999120146808)
,p_name=>'APEX.ISSUES.LABELS.GROUP.PROGRESS.NAME'
,p_message_text=>'Progress'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459418006306205982)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.BACKLOG'
,p_message_text=>'Backlog'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459417411926202503)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.CRITICAL'
,p_message_text=>'Critical'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459417695263203303)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.IMPORTANT'
,p_message_text=>'Important'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459417800739204284)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.NORMAL'
,p_message_text=>'Normal'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459418285551207449)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.WILLNOTADDRESS'
,p_message_text=>'Will Not Address'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459418454661211243)
,p_name=>'APEX.ISSUES.LABELS.LEVELOFEFFORT.EASY'
,p_message_text=>'Easy Fix'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459418874349214088)
,p_name=>'APEX.ISSUES.LABELS.LEVELOFEFFORT.LARGE'
,p_message_text=>'Large Development Effort'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459418678569212348)
,p_name=>'APEX.ISSUES.LABELS.LEVELOFEFFORT.MODERATE'
,p_message_text=>'Moderate Effort'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459419670793223855)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.CANNOTFIX'
,p_message_text=>'Can Not Fix'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459419855083225058)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.COMPLETE'
,p_message_text=>'Complete'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459419224245220503)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.REQUIRESMOREINFO'
,p_message_text=>'Requires More Info'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459419450587222758)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.WAITINGONTHIRDPARTY'
,p_message_text=>'Waiting on Third Party'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459419098647218464)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.WORKINGONIT'
,p_message_text=>'Working On It'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461681272756449089)
,p_name=>'APEX.ISSUES.LABEL_GROUP_DELETE_WARNING'
,p_message_text=>'This Label Group may not be deleted because one or more of its members is assigned to an issue.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(16222020043254273)
,p_name=>'APEX.ISSUES.LAST_UPDATED'
,p_message_text=>'Last updated'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15760115651579953)
,p_name=>'APEX.ISSUES.MARKED_DUPLICATE_OF'
,p_message_text=>'Marked duplicate of'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(500032458659723624)
,p_name=>'APEX.ISSUES.MENU.ASSIGNEES'
,p_message_text=>'Assignees'
,p_is_js_message=>true
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(500032225975723007)
,p_name=>'APEX.ISSUES.MENU.LABELS'
,p_message_text=>'Labels'
,p_is_js_message=>true
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(500194278431059049)
,p_name=>'APEX.ISSUES.MENU.MILESTONES'
,p_message_text=>'Milestones'
,p_is_js_message=>true
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(500032000488721930)
,p_name=>'APEX.ISSUES.MENU.STATUS'
,p_message_text=>'Status'
,p_is_js_message=>true
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15752717890152350)
,p_name=>'APEX.ISSUES.MILESTONES'
,p_message_text=>'milestones'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(460427799520556560)
,p_name=>'APEX.ISSUES.MILESTONES.CODEFREEZE'
,p_message_text=>'Code Freeze'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(460428113883562989)
,p_name=>'APEX.ISSUES.MILESTONES.FINALRELEASE'
,p_message_text=>'Final Release'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(460427974831560195)
,p_name=>'APEX.ISSUES.MILESTONES.UIFREEZE'
,p_message_text=>'UI Freeze'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15775324805078948)
,p_name=>'APEX.ISSUES.NOTIFY.ADDED_A_COMMENT_TO'
,p_message_text=>'%0 added a comment to %1 %2'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1420753918636510)
,p_name=>'APEX.ISSUES.NOTIFY.HAS_CHANGED'
,p_message_text=>'has changed.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(471455708555167362)
,p_name=>'APEX.ISSUES.NOTIFY.ISSUE_HAS_CHANGED'
,p_message_text=>'Issue number %0 in workspace %1 has changed.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(598636091558730275)
,p_name=>'APEX.ISSUES.NO_LABLES_FOUND'
,p_message_text=>'No Labels have been defined.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(16222626734263717)
,p_name=>'APEX.ISSUES.OPEN'
,p_message_text=>'Open'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15765842514763884)
,p_name=>'APEX.ISSUES.OTHER'
,p_message_text=>'Other'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15755764899244576)
,p_name=>'APEX.ISSUES.PAGE'
,p_message_text=>'Page'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15755321856237326)
,p_name=>'APEX.ISSUES.PAGE_NO_LONGER_EXISTS'
,p_message_text=>'Page no longer exists'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(673260390160512570)
,p_name=>'APEX.ISSUES.PURGE_BUTTON'
,p_message_text=>'Purge All'
,p_is_js_message=>true
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(510502185254988762)
,p_name=>'APEX.ISSUES.REMOVE'
,p_message_text=>'Remove'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15754762488223719)
,p_name=>'APEX.ISSUES.REMOVED_ASSOCIATION'
,p_message_text=>'Removed the Application and Page association from'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15756510522271058)
,p_name=>'APEX.ISSUES.REMOVED_THE_ATTACHMENT'
,p_message_text=>'Removed the attachment'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(625055880474785986)
,p_name=>'APEX.ISSUES.REPLACE_COMMENT_CONFIRM'
,p_message_text=>'Do you want to replace your current comment with this template?'
,p_is_js_message=>true
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(627065760940319955)
,p_name=>'APEX.ISSUES.SAMPLE_ISSUE_BODY'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Hi there! ',
'',
'This is your very first issue! You can create issues to keep track of tasks, features, bugs, and feedback for all of your APEX projects!  You can add labels to issues, add assignees, set milestones, and even apply formatting using Markdown shorthand!'
||'  ',
'',
'Below is a quick sample of what you can do with Markdown:'))
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(627020434793279507)
,p_name=>'APEX.ISSUES.SAMPLE_ISSUE_TITLE'
,p_message_text=>'Welcome to Team Development in Oracle APEX!'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(514603986874946476)
,p_name=>'APEX.ISSUES.SELECT'
,p_message_text=>'- Select -'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15756749342273960)
,p_name=>'APEX.ISSUES.SET_STATUS_TO'
,p_message_text=>'Set status to'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(6824529888322728)
,p_name=>'APEX.ISSUES.SHOW_ACTIONS'
,p_message_text=>'Show actions'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(626969010413120433)
,p_name=>'APEX.ISSUES.SHOW_MORE'
,p_message_text=>'Show More...'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15755933081249428)
,p_name=>'APEX.ISSUES.SUBSCRIBED'
,p_message_text=>'Subscribed'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(598752029318567239)
,p_name=>'APEX.ISSUES.SUMMARY_LINE'
,p_message_text=>'%0 in workspace %1 has %2 new notifications.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459406070959977425)
,p_name=>'APEX.ISSUES.TEMPLATE.BUG.DESC'
,p_message_text=>'Template used to log a bug.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459405325950965248)
,p_name=>'APEX.ISSUES.TEMPLATE.BUG.NAME'
,p_message_text=>'Bug Template'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459404851388926104)
,p_name=>'APEX.ISSUES.TEMPLATE.BUG.TEXT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'**Expected Behavior**',
'- Tell us what you believe should happen.',
'',
'',
'**Current Behavior**',
'- Tell us what happens.',
'',
'',
'**Who is affected**',
'- Tell us who/what is affected. ',
'',
'**Possible Solution**',
'- If you can, suggest how you would fix this bug.',
'',
'**Steps to Reproduce**',
'- Provide an unambiguous set of steps to reproduce, including screen shots and code snippets if appropriate.',
'1.',
'2.',
'3.',
'',
'**Context**',
'- What were you trying to accomplish when the bug occurred. Does the bug only occur under certain conditions, or at certain times of day, and so forth.',
'',
'**Environment**',
'',
'- Version: ',
'- Platform: ',
'- Subsystem:',
'',
'______',
'',
'_**NOTE:** To associate an issue with an application and/or page, first log the issue, then use the **ACTIONS** drop down to associate the App and Page._'))
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459408795010070233)
,p_name=>'APEX.ISSUES.TEMPLATE.BUGRAISED.DESC'
,p_message_text=>'A bug has been raised.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459408570739066912)
,p_name=>'APEX.ISSUES.TEMPLATE.BUGRAISED.NAME'
,p_message_text=>'Bug Raised'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459408946397074008)
,p_name=>'APEX.ISSUES.TEMPLATE.BUGRAISED.TEXT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'A **Bug** has been filed in the appropriate external system.',
'',
'- Bug Tracking System: ',
'- Bug ID: ',
'- URL to bug: ',
'',
'Comments:'))
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459406805249027008)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATURE.DESC'
,p_message_text=>'Template used to log a feature request.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459406654637024303)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATURE.NAME'
,p_message_text=>'Feature Request Template'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459407083603031574)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATURE.TEXT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'**Feature Summary**',
' - Provide a one paragraph general overview of the feature request.',
'',
'',
'**Context**',
' - Does this request relate to a specific situation or process? For example, "I am always frustrated when [...]"',
'',
'',
' - Please provide any supporting information, including screenshots, use cases, and so forth.',
'',
'',
'**Preferred Solution**',
'- Provide a clear description of what you would like to see implemented.',
'',
'',
'**Alternative Solutions**',
'- Provide a description of alternative solutions or features considered, or workarounds used.',
'',
'',
'______',
'_**NOTE:** To associate an issue with an application and/or page, first log the issue, then use the **ACTIONS** drop down to associate the App and Page._'))
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459409339680081921)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATUREFILED.DESC'
,p_message_text=>'A feature request has been filed.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459409110641078448)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATUREFILED.NAME'
,p_message_text=>'Feature Request Filed'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459409590453084860)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATUREFILED.TEXT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'A **Feature Request** has been filed in the appropriate external system.',
'',
'- Feature Tracking System: ',
'- Feature ID: ',
'- URL to Feature Definition: ',
'',
'Comments:'))
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459411166280106591)
,p_name=>'APEX.ISSUES.TEMPLATE.FOLLOWUP.DESC'
,p_message_text=>'A followup action is required.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459410914872104152)
,p_name=>'APEX.ISSUES.TEMPLATE.FOLLOWUP.NAME'
,p_message_text=>'Followup Action Required'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459411342342109166)
,p_name=>'APEX.ISSUES.TEMPLATE.FOLLOWUP.TEXT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Please perform the following actions: ',
'',
'1.',
'2.',
'3.',
'4.',
'',
'Comments: '))
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459407429811046820)
,p_name=>'APEX.ISSUES.TEMPLATE.HOWDOI.DESC'
,p_message_text=>'Template used to ask a procedural question.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459407251548044622)
,p_name=>'APEX.ISSUES.TEMPLATE.HOWDOI.NAME'
,p_message_text=>'How Do I ...'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459407693725049491)
,p_name=>'APEX.ISSUES.TEMPLATE.HOWDOI.TEXT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'**Question**',
'- State your question or request as succinctly as possible.',
'',
'**General Context**',
'- What are you trying to do? ',
'',
'',
'- Where else have you looked or who else have you contacted to find an answer? ',
'',
'',
'**Environment** ',
'Is this question specific to an environment, programming language or other area?',
'',
'______',
'_**NOTE:** To associate an issue with an application and/or page, first log the issue, then use the **ACTIONS** drop down to associate the App and Page._'))
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459410582957099400)
,p_name=>'APEX.ISSUES.TEMPLATE.KNOWNISSUE.DESC'
,p_message_text=>'Reference a known issue.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459410349696095617)
,p_name=>'APEX.ISSUES.TEMPLATE.KNOWNISSUE.NAME'
,p_message_text=>'Known Issue'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459410743655101136)
,p_name=>'APEX.ISSUES.TEMPLATE.KNOWNISSUE.TEXT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'After review, it has been determined that this is a known issue, see details below.',
'',
'- Bug Tracking System: ',
'- Bug ID: ',
'- URL to bug: ',
'',
'Comments: '))
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459409972722090704)
,p_name=>'APEX.ISSUES.TEMPLATE.MOREINFO.DESC'
,p_message_text=>'Request for more information.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459409725735088140)
,p_name=>'APEX.ISSUES.TEMPLATE.MOREINFO.NAME'
,p_message_text=>'Need More Information'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459410136474093077)
,p_name=>'APEX.ISSUES.TEMPLATE.MOREINFO.TEXT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'**More information is needed for this issue:**',
'',
'Please provide the information requested below. Without this information it will be difficult to triage and address the issue further.',
'',
'',
'Comments:'))
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459408193962060440)
,p_name=>'APEX.ISSUES.TEMPLATE.WONTACTION.DESC'
,p_message_text=>'This issue will not be actioned'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459407948488057034)
,p_name=>'APEX.ISSUES.TEMPLATE.WONTACTION.NAME'
,p_message_text=>'Won''t Action'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(459408349341062954)
,p_name=>'APEX.ISSUES.TEMPLATE.WONTACTION.TEXT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'After careful consideration, **no further action will be taken on this issue**. ',
'',
'Comments:'))
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15769868452948224)
,p_name=>'APEX.ISSUES.TEXT_FILE'
,p_message_text=>'Text File'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15765698960761153)
,p_name=>'APEX.ISSUES.TEXT_FILES'
,p_message_text=>'Text Files'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15751914666135585)
,p_name=>'APEX.ISSUES.THIS_ISSUE'
,p_message_text=>'this issue'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(471458196903192063)
,p_name=>'APEX.ISSUES.TIMELINE.ADDED_ATTACHMENT'
,p_message_text=>'added the attachment %0 to %1 %2'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(471456152071174289)
,p_name=>'APEX.ISSUES.TIMELINE.ADDED_LABELS'
,p_message_text=>'added %0 to %1 %2'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(471483680554268589)
,p_name=>'APEX.ISSUES.TIMELINE.ADDED_MILESTONES'
,p_message_text=>'added %0 to %1 %2				'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(471456581311177879)
,p_name=>'APEX.ISSUES.TIMELINE.ASSIGNED'
,p_message_text=>'assigned %0 to %1 %2'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(471457387041185245)
,p_name=>'APEX.ISSUES.TIMELINE.ASSOCIATED'
,p_message_text=>'associated %0 with %1 %2'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15774956500066416)
,p_name=>'APEX.ISSUES.TIMELINE.EDITED_A_COMMENT_FOR'
,p_message_text=>'edited a comment for %0	%1'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(93754039405421844)
,p_name=>'APEX.ISSUES.TIMELINE.EDITED_ISSUE'
,p_message_text=>'edited issue %0 %1'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(471474151956907146)
,p_name=>'APEX.ISSUES.TIMELINE.HIDDEN'
,p_message_text=>'This issue has been hidden.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(471456914764181877)
,p_name=>'APEX.ISSUES.TIMELINE.MARKED_DUP'
,p_message_text=>'marked %0 as a duplicate of %1 %2'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(471470290824653152)
,p_name=>'APEX.ISSUES.TIMELINE.OPENED'
,p_message_text=>'Opened %0 by'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(471458397968193844)
,p_name=>'APEX.ISSUES.TIMELINE.REMOVED_ATTACHMENT'
,p_message_text=>'removed the attachment %0 from %1 %2'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(471456382600176139)
,p_name=>'APEX.ISSUES.TIMELINE.REMOVED_LABELS'
,p_message_text=>'removed %0 from %1 %2'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(471483888072272586)
,p_name=>'APEX.ISSUES.TIMELINE.REMOVED_MILESTONES'
,p_message_text=>'removed %0 from %1 %2 			'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(471458569323195583)
,p_name=>'APEX.ISSUES.TIMELINE.STATUS'
,p_message_text=>'set status for %0 to %1 %2'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(471457701231188763)
,p_name=>'APEX.ISSUES.TIMELINE.SUBSCRIBED'
,p_message_text=>'subscribed to %0 %1'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(471456715018179929)
,p_name=>'APEX.ISSUES.TIMELINE.UNASSIGNED'
,p_message_text=>'unassigned %0 from %1 %2'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(471457507348186925)
,p_name=>'APEX.ISSUES.TIMELINE.UNASSOCIATED'
,p_message_text=>'removed the Application and Page association from %0 %1'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(471457138248183693)
,p_name=>'APEX.ISSUES.TIMELINE.UNMARKED_DUP'
,p_message_text=>'unmarked %0 as duplicate %1'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(471457944217190420)
,p_name=>'APEX.ISSUES.TIMELINE.UNSUBSCRIBED'
,p_message_text=>'unsubscribed from %0 %1'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(471470035188651331)
,p_name=>'APEX.ISSUES.TIMELINE_MARKED_DUPLICATE_OF'
,p_message_text=>'marked duplicate of %0 %1 by %2'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15753369414170235)
,p_name=>'APEX.ISSUES.UNASSIGNED'
,p_message_text=>'Unassigned'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(6788575618289773)
,p_name=>'APEX.ISSUES.UNHIDE'
,p_message_text=>'Unhide'
,p_is_js_message=>true
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15756187320259859)
,p_name=>'APEX.ISSUES.UNSUBSCRIBED'
,p_message_text=>'Unsubscribed'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(500031837979718118)
,p_name=>'APEX.ISSUES.UPDATE_MENU'
,p_message_text=>'Update...'
,p_is_js_message=>true
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15769451818945593)
,p_name=>'APEX.ISSUES.ZIP_FILE'
,p_message_text=>'Zip File'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15765200525758181)
,p_name=>'APEX.ISSUES.ZIP_FILES'
,p_message_text=>'Zip Files'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2212964321847020)
,p_name=>'APEX.ITEM.GEOCODE.ERROR_DA_AFFECTED_ELEM'
,p_message_text=>'%0 is not a Geocoded Address item.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(618179493321995456)
,p_name=>'APEX.ITEM.NOT_FOUND'
,p_message_text=>'Item %0 not found.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(591719169453077645)
,p_name=>'APEX.PAGE.CHECKSUM.DESCRIPTION'
,p_message_text=>'The page checksum provides an easy way to determine whether the same page is deployed elsewhere. You can compare this checksum to determine whether there is a match.	Changes to Shared Components used on this page will not be reflected within this che'
||'cksum.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(727452646001026597)
,p_name=>'APEX.PAGE_NAME.ABOUT_THIS_APP'
,p_message_text=>'About this Application'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(727278751559955251)
,p_name=>'APEX.PAGE_NAME.CONFIGURATION_OPTIONS'
,p_message_text=>'Configuration Options'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(727289478035981358)
,p_name=>'APEX.PAGE_NAME.THEME_STYLE_SELECTION'
,p_message_text=>'Theme Style Selection'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(7402625739553451)
,p_name=>'APEX.PDF.ERROR.CFF_MULTIPLE_FONTS'
,p_message_text=>'Only Compact Font Format (CFF) fonts with one font are allowed.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(7402866828566450)
,p_name=>'APEX.PDF.ERROR.CFF_MULTIPLE_TOP_DICTS'
,p_message_text=>'Only Compact Font Format (CFF) fonts with one top DICT are allowed.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(7403012578568428)
,p_name=>'APEX.PDF.ERROR.CFF_NOT_TYPE2_CHARSTRINGS'
,p_message_text=>'Only Compact Font Format (CFF) fonts with Type 2 CharString Format are allowed.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(11401015227163974)
,p_name=>'APEX.PDF.ERROR.FONT_NOT_FOUND'
,p_message_text=>'The font was not found.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(11400897978162374)
,p_name=>'APEX.PDF.ERROR.INVALID_CMAP'
,p_message_text=>'Only format 4 and 12 cmap tables are supported.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(11401686337180244)
,p_name=>'APEX.PDF.ERROR.INVALID_ORIENTATION'
,p_message_text=>'Invalid page orientation.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(11401261170165884)
,p_name=>'APEX.PDF.ERROR.NOT_INITIALIZED'
,p_message_text=>'The PDF is not initialized.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(11400689408160974)
,p_name=>'APEX.PDF.ERROR.NO_CMAP'
,p_message_text=>'No valid cmap sub-tables found in the font.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(11401445079168584)
,p_name=>'APEX.PDF.ERROR.NO_PAGES'
,p_message_text=>'The PDF has no pages.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(168402932951957365)
,p_name=>'APEX.PDF.INTERNAL_ERROR'
,p_message_text=>'An internal error has occurred while creating the PDF file.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(13800526896179985)
,p_name=>'APEX.PROCESS.INVALID_EDITABLE_REGION'
,p_message_text=>'Process "%0" has invalid (non Multi-Row) Editable Region assigned.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(9335300046801064)
,p_name=>'APEX.PROCESS.NATIVE.GET_NEXT_OR_PREV_PK_ERROR'
,p_message_text=>'Unable to get next or previous primary key value.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(362308404356075090)
,p_name=>'APEX.PROCESS.NATIVE.WEB_SERVICE.NOT_FOUND'
,p_message_text=>'The web service was not found.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(88422025627501910)
,p_name=>'APEX.PROCESS.UNHANDLED_ERROR'
,p_message_text=>'Error processing process.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3601179216152664)
,p_name=>'APEX.PROVISION_REQUEST.INVALID_EMAIL'
,p_message_text=>'The email address format provided in the workspace request is invalid.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(19248021403301631)
,p_name=>'APEX.QOS.REQUEST_LIMIT_REACHED'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Oracle APEX could not process the request because of database session resource limitations. Please try again later.',
'<p/>',
'Details about this incident are available via debug id "%0".'))
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(9700490508606492)
,p_name=>'APEX.REMOTEDEPLOY.ERROR'
,p_message_text=>'The following error occurred while deploying the application: %0'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(10773029274266624)
,p_name=>'APEX.REMOTEDEPLOY.SUCCESS'
,p_message_text=>'Application %0 successfully deployed to remote server.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(11900354650958272)
,p_name=>'APEX.REMOTEDEPLOY.SUCCESS2'
,p_message_text=>'Application %0 successfully deployed as %1 to remote server.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(358729193892838276)
,p_name=>'APEX.REMOTESQL.AUTHENTICATION_FAILED'
,p_message_text=>'Authentication failed for REST Enabled SQL service.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(19707705727680031)
,p_name=>'APEX.REMOTESQL.AUTHENTICATION_FAILED_FOR_LOV'
,p_message_text=>'Authentication failure. List of Values uses a REST Enabled SQL data source that references invalid web credentials, which will prevent you from editing column information for this LOV. Please check authentication credentials. '
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(681124897300108628)
,p_name=>'APEX.REMOTESQL.COMMUNICATION_FAILURE'
,p_message_text=>'Communication failure. There was a problem invoking the REST Enabled SQL data source referenced by the List of Values, which will prevent you from editing column information for the LOV. Please check the REST Enabled SQL data source is working correc'
||'tly, and also the corresponding authentication credentials are correct.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3301047227140977)
,p_name=>'APEX.REMOTESQL.DATABASE_NOT_SUPPORTED'
,p_message_text=>'REST Enabled SQL Database Type %0 is not supported.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(359290872198939253)
,p_name=>'APEX.REMOTESQL.REMOTE_ERROR'
,p_message_text=>'Error on Remote Server: %0'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(309252727957636603)
,p_name=>'APEX.REMOTESQL.SERVER_NOT_FOUND'
,p_message_text=>'Specified ORDS REST Enabled SQL instance not found.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(100611171647129283)
,p_name=>'APEX.REMOTESQL.SERVER_SENT_REDIRECT'
,p_message_text=>'Server sent a redirection to: %0'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(218215259070608118)
,p_name=>'APEX.REMOTESQL.SQL_STATEMENT_TOO_LONG'
,p_message_text=>'SQL Statement is longer than 32.767 bytes.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(241923994125388733)
,p_name=>'APEX.REMOTESQL.TEST_MESSAGE'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Hello, Oracle APEX! You are connected as #USER#.',
'The local database timestamp is: #SYSDATE#.'))
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461678196397341941)
,p_name=>'APEX.REST.DEFAULT_SCHEMA_WARNING'
,p_message_text=>'You are editing the alias for the workspace''s default schema. Setting this alias will also change the Path Prefix at the workspace level.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(212724747305602464)
,p_name=>'APEX.SC.REFERENCES'
,p_message_text=>'%0 references'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1410035224780861)
,p_name=>'APEX.SEARCH.APP_PATH'
,p_message_text=>'App %0 (%1)'
,p_version_scn=>36697233
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461360095208526401)
,p_name=>'APEX.SEARCH.AU.APPLICATION_UTILITIES'
,p_message_text=>'Utilities'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461360200313526418)
,p_name=>'APEX.SEARCH.AU.APPLICATION_UTILITIES_DESCRIPTION'
,p_message_text=>'Navigate to: Application Utilities \ %LIST_ITEM_NAME%'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(49714562754352881)
,p_name=>'APEX.SEARCH.AU.APP_ALIAS'
,p_message_text=>'App %0 (%1)'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(49714743747372945)
,p_name=>'APEX.SEARCH.AU.APP_PAGE_ALIAS'
,p_message_text=>'App %0'
,p_version_scn=>36720279
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1411453084791896)
,p_name=>'APEX.SEARCH.CATEGORY.ACTIONS'
,p_message_text=>'Actions'
,p_is_js_message=>true
,p_version_scn=>36715791
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1410686502786087)
,p_name=>'APEX.SEARCH.CATEGORY.APPLICATIONS'
,p_message_text=>'Applications'
,p_is_js_message=>true
,p_version_scn=>36714013
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1410432592785153)
,p_name=>'APEX.SEARCH.CATEGORY.GLOBAL'
,p_message_text=>'Global'
,p_is_js_message=>true
,p_version_scn=>36713979
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1411258991789813)
,p_name=>'APEX.SEARCH.CATEGORY.OTHERS'
,p_message_text=>'Others'
,p_is_js_message=>true
,p_version_scn=>36715717
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1411069214789061)
,p_name=>'APEX.SEARCH.CATEGORY.PAGES'
,p_message_text=>'Pages'
,p_is_js_message=>true
,p_version_scn=>36715643
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1412313989799657)
,p_name=>'APEX.SEARCH.CLEAR_ALL'
,p_message_text=>'Clear All'
,p_is_js_message=>true
,p_version_scn=>36716172
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461381863818527075)
,p_name=>'APEX.SEARCH.GO_TO_PAGE'
,p_message_text=>'Go to page'
,p_is_js_message=>true
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461381592546527067)
,p_name=>'APEX.SEARCH.GO_TO_SHARED_COMPONENTS'
,p_message_text=>'Go to Shared Components'
,p_is_js_message=>true
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1410415157231896)
,p_name=>'APEX.SEARCH.NO_RESULTS_FOUND'
,p_message_text=>'No results found'
,p_is_js_message=>true
,p_version_scn=>40889298
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461360571624526427)
,p_name=>'APEX.SEARCH.P1500.APP_BUILDER'
,p_message_text=>'App Builder'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461360866509526435)
,p_name=>'APEX.SEARCH.P1500.APP_BUILDER_TASKS'
,p_message_text=>'App Builder Tasks > '
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1410246947781970)
,p_name=>'APEX.SEARCH.PAGE_PATH'
,p_message_text=>'App %0 / Page %1 %2'
,p_version_scn=>52795779
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461361163014526444)
,p_name=>'APEX.SEARCH.SC.APP_ITEMS'
,p_message_text=>'Application Items'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461361437528526452)
,p_name=>'APEX.SEARCH.SC.APP_ITEMS_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ Application Items \ %LIST_ITEM_NAME%'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461361727720526461)
,p_name=>'APEX.SEARCH.SC.APP_LOGIC'
,p_message_text=>'Application Logic'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461362051439526469)
,p_name=>'APEX.SEARCH.SC.AUTHENTICATION_SCHEMES'
,p_message_text=>'Authentication Schemes'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461362310854526478)
,p_name=>'APEX.SEARCH.SC.AUTHENTICATION_SCHEMES_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ Security Authentication Schemes \ %LIST_ITEM_NAME%'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461362578180526486)
,p_name=>'APEX.SEARCH.SC.AUTHORIZATION_SCHEMES'
,p_message_text=>'Authorization Schemes'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461362809891526495)
,p_name=>'APEX.SEARCH.SC.AUTHORIZATION_SCHEMES_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ Security Authorization Schemes \ %LIST_ITEM_NAME%'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461363190129526503)
,p_name=>'APEX.SEARCH.SC.BREADCRUMBS'
,p_message_text=>'Breadcrumbs'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461363459173526512)
,p_name=>'APEX.SEARCH.SC.BREADCRUMBS_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ Breadcrumbs \ %LIST_ITEM_NAME%'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461363785862526520)
,p_name=>'APEX.SEARCH.SC.BUILD_OPTIONS'
,p_message_text=>'Build Options'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461364079937526529)
,p_name=>'APEX.SEARCH.SC.BUILD_OPTIONS_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ Build Options \ %LIST_ITEM_NAME%'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461364361400526537)
,p_name=>'APEX.SEARCH.SC.COMPONENT_SETTINGS'
,p_message_text=>'Component Settings'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461364617319526546)
,p_name=>'APEX.SEARCH.SC.COMPONENT_SETTINGS_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ Component Settings \ %LIST_ITEM_NAME%'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461364987961526554)
,p_name=>'APEX.SEARCH.SC.COMPUTATIONS'
,p_message_text=>'Computations'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461365210329526562)
,p_name=>'APEX.SEARCH.SC.COMPUTATIONS_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ Application Computations \ %LIST_ITEM_NAME%'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461365559294526571)
,p_name=>'APEX.SEARCH.SC.CREATE_APPLICATION_ITEM'
,p_message_text=>'Create Application Item'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461365842706526579)
,p_name=>'APEX.SEARCH.SC.CREATE_AUTHENTICATION_SCHEME'
,p_message_text=>'Create Authentication Scheme'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461366047952526587)
,p_name=>'APEX.SEARCH.SC.CREATE_BUILD_OPTION'
,p_message_text=>'Create Build Option'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461366350794526596)
,p_name=>'APEX.SEARCH.SC.CREATE_COMPUTATION'
,p_message_text=>'Create Application Computation'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461366629942526604)
,p_name=>'APEX.SEARCH.SC.CREATE_EMAIL_TEMPLATE'
,p_message_text=>'Create Email Template'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461366932786526613)
,p_name=>'APEX.SEARCH.SC.CREATE_PLUG-IN'
,p_message_text=>'Create Plug-in'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461367200861526621)
,p_name=>'APEX.SEARCH.SC.CREATE_THEME'
,p_message_text=>'Create Theme'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461367545659526630)
,p_name=>'APEX.SEARCH.SC.CREATE_WEB_CREDENTIALS'
,p_message_text=>'Create Web Credentials'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461367871873526645)
,p_name=>'APEX.SEARCH.SC.DATA_LOAD_DEFINITIONS'
,p_message_text=>'Data Load Definitions'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461368118423526660)
,p_name=>'APEX.SEARCH.SC.DATA_LOAD_DEFINITIONS_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ Data Load Definitions \ %LIST_ITEM_NAME%'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461368431050526671)
,p_name=>'APEX.SEARCH.SC.DATA_SOURCES'
,p_message_text=>'Data Sources'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461368733741526679)
,p_name=>'APEX.SEARCH.SC.DEFINITION_ATTRIBUTES'
,p_message_text=>'Definition Attributes'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461368939897526690)
,p_name=>'APEX.SEARCH.SC.EMAIL_TEMPLATES'
,p_message_text=>'Email Templates'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461369238599526699)
,p_name=>'APEX.SEARCH.SC.LAYOUTS'
,p_message_text=>'Report Layouts'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461369549889526707)
,p_name=>'APEX.SEARCH.SC.LAYOUTS_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ Report Layouts \ %LIST_ITEM_NAME%'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461369821500526715)
,p_name=>'APEX.SEARCH.SC.LEGACY_WEB_SERVICES'
,p_message_text=>'Legacy Web Services'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461370179061526724)
,p_name=>'APEX.SEARCH.SC.LEGACY_WEB_SERVICES_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ Legacy Web Services \ %LIST_ITEM_NAME%'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461370420527526732)
,p_name=>'APEX.SEARCH.SC.LISTS'
,p_message_text=>'Navigation Lists'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461370710464526741)
,p_name=>'APEX.SEARCH.SC.LISTS_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ Classic Navigation Lists \ %LIST_ITEM_NAME%'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461371003867526751)
,p_name=>'APEX.SEARCH.SC.LIST_OF_VALUES'
,p_message_text=>'List of Values'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461371368501526759)
,p_name=>'APEX.SEARCH.SC.LIST_OF_VALUES_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ List of Values \ %LIST_ITEM_NAME%'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(171970280041020767)
,p_name=>'APEX.SEARCH.SC.MANAGE_PREFERENCES'
,p_message_text=>'Manage Preferences'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(171970571338047514)
,p_name=>'APEX.SEARCH.SC.MANAGE_SERVICE'
,p_message_text=>'Manage Service'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(171970069103019026)
,p_name=>'APEX.SEARCH.SC.MANAGE_SESSION_STATE'
,p_message_text=>'Manage Session State'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(171969706136015539)
,p_name=>'APEX.SEARCH.SC.MANAGE_WORKSPACE'
,p_message_text=>'Manage Workspace'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461371681971526768)
,p_name=>'APEX.SEARCH.SC.NAVIGATION'
,p_message_text=>'Navigation'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461371942600526777)
,p_name=>'APEX.SEARCH.SC.OTHER_COMPONENTS'
,p_message_text=>'Other Components'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461372139782526785)
,p_name=>'APEX.SEARCH.SC.PLUG-INS'
,p_message_text=>'Plug-ins'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461372413791526793)
,p_name=>'APEX.SEARCH.SC.PLUG-INS_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ Plug-ins \ %LIST_ITEM_NAME%'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461372749803526802)
,p_name=>'APEX.SEARCH.SC.PROCESSES'
,p_message_text=>'Processes'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461373012959526810)
,p_name=>'APEX.SEARCH.SC.PROCESSES_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ Application Processes \ %LIST_ITEM_NAME%'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461373307855526828)
,p_name=>'APEX.SEARCH.SC.QUERIES'
,p_message_text=>'Report Queries'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461373622189526836)
,p_name=>'APEX.SEARCH.SC.QUERIES_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ Report Queries \ %LIST_ITEM_NAME%'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461373988321526845)
,p_name=>'APEX.SEARCH.SC.REPORTS'
,p_message_text=>'Reports'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461374204636526853)
,p_name=>'APEX.SEARCH.SC.REST_ENABLED_SQL'
,p_message_text=>'REST Enabled SQL'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461374524416526862)
,p_name=>'APEX.SEARCH.SC.REST_ENABLED_SQL_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ REST Enabled SQL \ %LIST_ITEM_NAME%'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461374895502526870)
,p_name=>'APEX.SEARCH.SC.SECURITY'
,p_message_text=>'Security'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461375108211526878)
,p_name=>'APEX.SEARCH.SC.SESSION_STATE_PROTECTION'
,p_message_text=>'Session State Protection'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461375366418526887)
,p_name=>'APEX.SEARCH.SC.SET_APPLICATION_SESSION_STATE_PROTECTION'
,p_message_text=>'Set Application State Protection'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461375638234526895)
,p_name=>'APEX.SEARCH.SC.SHARED_COMPONENTS'
,p_message_text=>'Shared Components'
,p_is_js_message=>true
,p_version_scn=>36715482
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461375938330526904)
,p_name=>'APEX.SEARCH.SC.SHARED_COMPONENTS_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ %LIST_ITEM_NAME%'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461376296119526912)
,p_name=>'APEX.SEARCH.SC.SHORTCUTS'
,p_message_text=>'Shortcuts'
,p_is_js_message=>true
,p_version_scn=>36716044
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461376550556526921)
,p_name=>'APEX.SEARCH.SC.SHORTCUTS_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ Shortcuts \ %LIST_ITEM_NAME%'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461376850620526929)
,p_name=>'APEX.SEARCH.SC.TABS'
,p_message_text=>'Tabs (Legacy)'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461377423883526949)
,p_name=>'APEX.SEARCH.SC.TEMPLATES'
,p_message_text=>'Templates'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461377739997526957)
,p_name=>'APEX.SEARCH.SC.TEMPLATES_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ UI Templates \ %LIST_ITEM_NAME%'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461378003791526966)
,p_name=>'APEX.SEARCH.SC.THEMES'
,p_message_text=>'Themes'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461378355217526974)
,p_name=>'APEX.SEARCH.SC.THEMES_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ UI Themes \ %LIST_ITEM_NAME%'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461378510250526982)
,p_name=>'APEX.SEARCH.SC.UI'
,p_message_text=>'User Interface'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461378880743526991)
,p_name=>'APEX.SEARCH.SC.WEB_CREDENTIALS'
,p_message_text=>'Web Credentials'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461379155251526999)
,p_name=>'APEX.SEARCH.SC.WEB_CREDENTIALS_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ Security Web Credentials \ %LIST_ITEM_NAME%'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461379440989527008)
,p_name=>'APEX.SEARCH.SC.WEB_SOURCE_MODULES'
,p_message_text=>'REST Data Source'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461379751305527016)
,p_name=>'APEX.SEARCH.SC.WEB_SOURCE_MODULES_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ REST Data Sources \ %LIST_ITEM_NAME%'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461380073505527025)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP'
,p_message_text=>'SQL Workshop'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461380350406527033)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.CREATE_OBJECT'
,p_message_text=>'Create Object'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461380609146527042)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.CREATE_OBJECT_DESCRIPTION'
,p_message_text=>'Create %LIST_ITEM_NAME% in SQL Workshop'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461380957058527050)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.SCRIPT_EDITOR'
,p_message_text=>'Script Editor'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(461381245873527059)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.TASKS'
,p_message_text=>'SQL Workshop Tasks'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(44166157386204306)
,p_name=>'APEX.SEARCH.UTILITIES.OBJECT_REPORTS'
,p_message_text=>'Object Reports'
,p_is_js_message=>true
,p_version_scn=>36715832
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1582027430515961721)
,p_name=>'APEX.SESSION_STATE.DB_COLUMN_SOURCE_USED'
,p_message_text=>'Page Item %0 is based on a Database Column but the attribute ''Source Used'' is set to ''Only when current value in session state is null''. This is very dangerous and can result in accidentally overwriting data when viewing and saving multiple records. '
||'Always set ''Source Used'' to ''Always, replacing any existing value in session state''.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(716454763684253965)
,p_name=>'APEX.SESSION_STATE.DISABLED'
,p_message_text=>'Access to session state is disabled, attempt to read/write was blocked.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(23680232504124313)
,p_name=>'APEX.SESSION_STATE.INTERNAL_ONLY_VIOLATION'
,p_message_text=>'Attempt to save item %0 in session state during show processing, item has Internal Only protection.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(21006331518737908)
,p_name=>'APEX.SESSION_STATE.INTERNAL_ONLY_VIOLATION2'
,p_message_text=>'Attempt to save item %0 in session state during accept processing, item has Internal Only protection or is not a form item that can be POSTed.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(21005116019714586)
,p_name=>'APEX.SESSION_STATE.SSP_VIOLATION2_FOR_DEVELOPERS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'The checksum computed on the request, clear cache, argument names, and argument values (%0) did not match the checksum passed into the show procedure (%1).',
'',
'Note: End users get a different error message.'))
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(20999902634644494)
,p_name=>'APEX.SESSION_STATE.SSP_VIOLATION_FOR_DEVELOPERS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Attempt to save item %0 in session state during show processing. Item protection level indicates:',
'  %1',
'',
'No checksum was passed in or the checksum passed in would be suitable for an item with protection level "%2".',
'',
'Note: End users get a different error message.'))
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(88416518916490500)
,p_name=>'APEX.SESSION_STATE.UNHANDLED_ERROR'
,p_message_text=>'ERR-1022 Unable to save attributes.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2123374987810646)
,p_name=>'APEX.SPATIAL.CANNOT_CONVERT_SDO_GEOMETRY_TO_GEOJSON'
,p_message_text=>'Cannot convert SDO_GEOMETRY value to GeoJSON.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1865271625862732)
,p_name=>'APEX.SPATIAL.CANNOT_CONVERT_TEXT_TO_SDO_GEOMETRY'
,p_message_text=>'Cannot convert text to an SDO_GEOMETRY object.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2018021290361364)
,p_name=>'APEX.SPATIAL.INVALID_GEOJSON'
,p_message_text=>'%0 does not contain valid GeoJSON.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5994227411936586)
,p_name=>'APEX.TABULAR_FORM.COLUMN_DEFAULT_ERR'
,p_message_text=>'Error computing default value for column #COMPONENT_NAME#.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(6224418492659112)
,p_name=>'APEX.TABULAR_FORM.MRD.UNHANDLED_ERROR'
,p_message_text=>'Error processing Multi Row Delete process.'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(106583016405934090)
,p_name=>'APEX.TABULAR_FORM.MRU.FCS_MISSING'
,p_message_text=>'Checksum column ("FCS") is required and was not supplied'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(106584209264941524)
,p_name=>'APEX.TABULAR_FORM.MRU.NO_PRIM_KEY_VALS'
,p_message_text=>'No primary key values were supplied, at least one row must be supplied for updates to occur'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(106613731493127723)
,p_name=>'APEX.TABULAR_FORM.MRU.NO_SEC_KEY_VALS'
,p_message_text=>'No secondary values were supplied for the identified secondary key column'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(143444531694195363)
,p_name=>'APEX.TABULAR_FORM.MRU.NO_VALUES'
,p_message_text=>'no data found in tabular form'
,p_version_scn=>37165770887489
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(106582623201926606)
,p_name=>'APEX.TABULAR_FORM.MRU.PRIM_KEY_COL_NOT_SPECIFIED'
,p_message_text=>'Primary key column was not specified'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(106611710368121624)
,p_name=>'APEX.TABULAR_FORM.MRU.SEC_KEY_COL_NOT_IN_SELECT_LIST'
,p_message_text=>'Secondary key column identified was not located in the select list of the query'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(106581428957918814)
,p_name=>'APEX.TABULAR_FORM.MRU.TABLE_NAME_NOT_SPECIFIED'
,p_message_text=>'Table Name was not specified'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(106580518568915814)
,p_name=>'APEX.TABULAR_FORM.MRU.TABLE_OWNER_NOT_SPECIFIED'
,p_message_text=>'Table Owner was not specified'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(112132616702429999)
,p_name=>'APEX.TABULAR_FORM.MRU.UNHANDLED_ERROR'
,p_message_text=>'Error processing Multi Row Update process.'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(110951617009402863)
,p_name=>'APEX.TEMPLATE_DIRECTIVE.INFINITE_LOOP'
,p_message_text=>'Possible infinite loop detected while applying a Template Component.'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15456502223871318)
,p_name=>'APEX.THEMES.COPY_THEME_ERROR'
,p_message_text=>'Can not copy theme "%0" in application "%1".'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1429533317665073149)
,p_name=>'APEX.THEMES.INCOMPATIBLE_THEME'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'The imported theme is not compatible with the current theme.',
''))
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(968205231756292138)
,p_name=>'APEX.THEMES.INVALID_THEME_NUMBER'
,p_message_text=>'Theme number is invalid or theme is not a current UI theme.'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(715870652181741385)
,p_name=>'APEX.TREE.ID_AND_PARENT_ID_COLUMNS_REQUIRED'
,p_message_text=>'Primary Key and Parent Key Columns required to compute hierarchy.'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(715870894672745390)
,p_name=>'APEX.TREE.NODE_LEVEL_AND_STATUS_COLUMNS_REQUIRED'
,p_message_text=>'Node Level and Node Status Columns required when hierarchy is not computed.'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(832771875757067316)
,p_name=>'APEX.UI.APPEARANCE'
,p_message_text=>'Appearance'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(562168105051650372)
,p_name=>'APEX.UI.AUTO_MODE'
,p_message_text=>'Automatic'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(72345618085017415)
,p_name=>'APEX.UI.DARK_MODE'
,p_message_text=>'Dark Mode'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(72346399126023116)
,p_name=>'APEX.UI.DISABLED'
,p_message_text=>'Disabled'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(562167987415648326)
,p_name=>'APEX.UI.LIGHT_MODE'
,p_message_text=>'Light Mode'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(48282408156372544)
,p_name=>'APEX.USER.CHECK_SGID'
,p_message_text=>'Unauthorized access (security group package variable not set).'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(48286710328429891)
,p_name=>'APEX.USER.FETCH_ERROR'
,p_message_text=>'Cannot fetch find user information. %0'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(43150918940160201)
,p_name=>'APEX.USER.NOT_ADMIN'
,p_message_text=>'User %0 requires ADMIN privilege to perform this operation.'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(48286117469422535)
,p_name=>'APEX.USER.NO_EMAIL'
,p_message_text=>'User %0 has not supplied an e-mail address.'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(38396719225016778)
,p_name=>'APEX.USER.UNAUTHORIZED'
,p_message_text=>'Unauthorized access.'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(48285131190417009)
,p_name=>'APEX.USER.USER_DOES_NOT_EXIST'
,p_message_text=>'User %0 does not exist.'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(21500487218820275)
,p_name=>'APEX.VALIDATION.INVALID_EDITABLE_REGION'
,p_message_text=>'Validation "%0" has invalid (non Multi-Row) Editable Region assigned.'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(88419200693494703)
,p_name=>'APEX.VALIDATION.UNHANDLED_ERROR'
,p_message_text=>'Error processing validation.'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2257806996639685)
,p_name=>'APEX.WEBSRC.ARRAY_COLUMN_NOT_FOUND'
,p_message_text=>'Column %0 is not an nested rows in the data profile.'
,p_version_scn=>48956933
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(718365479485605501)
,p_name=>'APEX.WEBSRC.CANNOT_PARSE_DATA'
,p_message_text=>'Oracle APEX cannot compute a data profile from the response data of type: %0.'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1469219931399671)
,p_name=>'APEX.WEBSRC.COLUMN_VALIDATION_REGEXP_VIOLATED'
,p_message_text=>'Invalid value for Data Profile column %0.'
,p_version_scn=>37165770887606
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(328258143932001598)
,p_name=>'APEX.WEBSRC.DATAPROFILE.MANY'
,p_message_text=>'Table'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(328257912987000826)
,p_name=>'APEX.WEBSRC.DATAPROFILE.ONE'
,p_message_text=>'Row'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2001336063737674)
,p_name=>'APEX.WEBSRC.DEFAULT_CATALOG_SERVICE_NAME'
,p_message_text=>'Service'
,p_version_scn=>26236570
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(658173211885075774)
,p_name=>'APEX.WEBSRC.FILTER_EXPR_INVALID_JSON'
,p_message_text=>'Filter expression is not valid JSON.'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(644535835248888446)
,p_name=>'APEX.WEBSRC.FILTER_NOT_SUPPORTED_BY_ORDS'
,p_message_text=>'Filter is not supported by Oracle REST Data Services.'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(212670799626464682)
,p_name=>'APEX.WEBSRC.HTTP.PAGINATION_PARAMETER_CONFLICT'
,p_message_text=>'Pagination URL Parameter "%0" conflicts with a REST Source Parameter.'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(310129990065948603)
,p_name=>'APEX.WEBSRC.HTTP200'
,p_message_text=>'HTTP 200: Success'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(310130179567949413)
,p_name=>'APEX.WEBSRC.HTTP201'
,p_message_text=>'HTTP 201: Created'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(310128919460940749)
,p_name=>'APEX.WEBSRC.HTTP400'
,p_message_text=>'HTTP 400: Bad request'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(310128547530938849)
,p_name=>'APEX.WEBSRC.HTTP401'
,p_message_text=>'HTTP 401: Unauthorized'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(310129108827942513)
,p_name=>'APEX.WEBSRC.HTTP403'
,p_message_text=>'HTTP 403: Forbidden'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(310128736779939806)
,p_name=>'APEX.WEBSRC.HTTP404'
,p_message_text=>'HTTP 404: Not found'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(310129360298943614)
,p_name=>'APEX.WEBSRC.HTTP405'
,p_message_text=>'HTTP 405: Method not allowed'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2033978997579515)
,p_name=>'APEX.WEBSRC.HTTP407'
,p_message_text=>'HTTP 407: Proxy Authentication required'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2035038201600950)
,p_name=>'APEX.WEBSRC.HTTP409'
,p_message_text=>'HTTP 409: Conflict'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2034494541587302)
,p_name=>'APEX.WEBSRC.HTTP412'
,p_message_text=>'HTTP 412: Precondition failed'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2034839697594944)
,p_name=>'APEX.WEBSRC.HTTP428'
,p_message_text=>'HTTP 428: Precondition Required'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(310129593388944751)
,p_name=>'APEX.WEBSRC.HTTP500'
,p_message_text=>'HTTP 500: Internal Server Error'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(310129705571947828)
,p_name=>'APEX.WEBSRC.HTTP502'
,p_message_text=>'HTTP 502: Bad Gateway'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(719239318137040446)
,p_name=>'APEX.WEBSRC.HTTP503'
,p_message_text=>'HTTP 503: Service Unavailable'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(719239519188043065)
,p_name=>'APEX.WEBSRC.HTTP504'
,p_message_text=>'HTTP 504: Gateway Timeout'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(580953514844599291)
,p_name=>'APEX.WEBSRC.HTTP_ERROR_OCCURRED'
,p_message_text=>'REST Data Source returned an HTTP error: %0'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(309252214290620546)
,p_name=>'APEX.WEBSRC.MODULE_NOT_FOUND'
,p_message_text=>'REST Data Source not found.'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86184817819805672)
,p_name=>'APEX.WEBSRC.NO_ARRAY_SELECTED'
,p_message_text=>'Row Selector "%0" did not select an array of objects to be treated as a Table.'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86185855899815153)
,p_name=>'APEX.WEBSRC.NO_SINGLE_ROW_SELECTED'
,p_message_text=>'Row Selector "%0" did not select an object to be treated as a Single Row.'
,p_version_scn=>37165770887490
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1469867057006028)
,p_name=>'APEX.WEBSRC.OPERATION_STATIC_ID_NOT_UNIQUE'
,p_message_text=>'Operation Static ID is not unique'
,p_version_scn=>37165770887493
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1469023854403720)
,p_name=>'APEX.WEBSRC.PARAM_VALIDATION_REGEXP_VIOLATED'
,p_message_text=>'Invalid value for REST Source Parameter %0.'
,p_version_scn=>37165770887606
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2500432815259450)
,p_name=>'APEX.WEBSRC.RATELIMIT_EXCEEDED'
,p_message_text=>'The REST Data Source rate limit (%0 requests within %1 seconds) has been exceeded.'
,p_version_scn=>37165770887493
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1706842673865383)
,p_name=>'APEX.WEBSRC.RATELIMIT_EXCEEDED_CANNOT_WAIT'
,p_message_text=>'The REST Data Source rate limit (%0 requests within %1 seconds) has been exceeded and the required waiting time is too long.'
,p_version_scn=>37165770887493
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(580953317951585160)
,p_name=>'APEX.WEBSRC.REQUIRED_PARAM_MISSING'
,p_message_text=>'Required REST Source IN parameter "%0" of type "%1" must have a value.'
,p_version_scn=>37165770887493
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(538482188904946926)
,p_name=>'APEX.WEBSRC.RESPONSE_BODY_TOO_LARGE'
,p_message_text=>'The response body is too large to display.'
,p_version_scn=>37165770887493
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(280176385690444441)
,p_name=>'APEX.WEBSRC.SMALL_ORDS2_FIXED_PAGE_SIZE'
,p_message_text=>'Legacy ORDS REST service uses a small Fixed Page Size.'
,p_version_scn=>37165770887493
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(9321724657569761)
,p_name=>'APEX.WEBSRC.SOURCE_DOES_NOT_USE_PAGINATION'
,p_message_text=>'This data source does not allow pagination'
,p_version_scn=>272092386
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3500258507404990)
,p_name=>'APEX.WEBSRC.SYNC.API_CALL_COMMENT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'-- This API call dynamically synchronizes the table columns to the ',
'-- REST Data Source''s data profile by executing ALTER TABLE statements. ',
'-- If a column data type cannot be changed using ALTER TABLE, an error ',
'-- message will be raised.',
'--'))
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3002629821886787)
,p_name=>'APEX.WEBSRC.SYNC.CANNOT_SYNC_TABLE_COLUMNS'
,p_message_text=>'Data Profile changes cannot be automatically applied, local table columns must be adjusted manually.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3500804276420203)
,p_name=>'APEX.WEBSRC.SYNC.DDL_CALL_COMMENT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'-- As of %0 this will execute:',
''))
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3001045503832068)
,p_name=>'APEX.WEBSRC.SYNC.MERGE_REQUIRES_PRIMARY_KEY'
,p_message_text=>'The merge synchronization method requires a primary key to be defined in the Data Profile.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3001659363843656)
,p_name=>'APEX.WEBSRC.SYNC.NO_COMMON_COLUMNS'
,p_message_text=>'The local table and the data profile have no common columns.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1706261919784177)
,p_name=>'APEX.WEBSRC.SYNC.STATUS_ABORTED'
,p_message_text=>'Job terminated'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3002069500852015)
,p_name=>'APEX.WEBSRC.SYNC.STATUS_FAILURE'
,p_message_text=>'Failure'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3002279220854625)
,p_name=>'APEX.WEBSRC.SYNC.STATUS_INCOMPLETE'
,p_message_text=>'Incomplete (Request limit exceeded)'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3002465944858667)
,p_name=>'APEX.WEBSRC.SYNC.STATUS_JOB_ALREADY_RUNNING'
,p_message_text=>'Job already running'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1729255222008618)
,p_name=>'APEX.WEBSRC.SYNC.STATUS_RUNNING'
,p_message_text=>'Running'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1729378473010739)
,p_name=>'APEX.WEBSRC.SYNC.STATUS_SCHEDULED'
,p_message_text=>'Scheduled'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3001809403851243)
,p_name=>'APEX.WEBSRC.SYNC.STATUS_SUCCESS'
,p_message_text=>'Success'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3001288958834389)
,p_name=>'APEX.WEBSRC.SYNC.STEP_STATIC_LABEL'
,p_message_text=>'Synchronization Step %0'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3001476237835497)
,p_name=>'APEX.WEBSRC.SYNC.STEP_STATIC_LABEL_COPY'
,p_message_text=>'%0 (New)'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(183659823754519819)
,p_name=>'APEX.WEBSRC.TEST_OPERATION'
,p_message_text=>'Test Operation'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(242132451615743610)
,p_name=>'APEX.WEBSRC.TIMEOUT_EXCEEDED'
,p_message_text=>'Timeout exceeded when fetching all REST Source data.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(206935809388034186)
,p_name=>'APEX.WEBSRC.TOO_MANY_NEXT_PAGE_REQUESTS'
,p_message_text=>'The current local SQL filters require too many "Next Page" requests to the REST service.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(108217961343965515)
,p_name=>'APEX.WEBSRC.TYPE_SWITCHED'
,p_message_text=>'Created REST Source as the "Simple HTTP" type, as it appears that the REST service does not support filtering or pagination.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2797152098598580)
,p_name=>'APEX.WEBSRC.UNFILTERABLE_ATTR_OR_BAD_OPER'
,p_message_text=>'Search filter includes a non-queryable column or unsupported operator'
,p_version_scn=>272322883
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(280176141272441818)
,p_name=>'APEX.WEBSRC.UNKNOWN_ORDS2_FIXED_PAGE_SIZE'
,p_message_text=>'Fixed Page Size for Legacy ORDS REST Service is unknown.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(97557422558470784)
,p_name=>'APEX.WORKSPACE_ADMIN.PARM_NOTFOUND'
,p_message_text=>'The workspace parameter was not found or the parameter cannot be changed using this functionality.'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113436236028212955)
,p_name=>'APEXAPP.BRANCH.ADMIN'
,p_message_text=>'Branch to Admin Page'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113410758871212964)
,p_name=>'APEXAPP.BREADCRUMB.DEFAULT'
,p_message_text=>'Breadcrumb'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113432377513212957)
,p_name=>'APEXAPP.BUILD_OPTION.COMMENTED_OUT'
,p_message_text=>'Commented Out'
,p_is_js_message=>true
,p_version_scn=>100563846
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113416847511212962)
,p_name=>'APEXAPP.BUTTON.ADD'
,p_message_text=>'Add Row'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113417134109212962)
,p_name=>'APEXAPP.BUTTON.ADD_ENTITY'
,p_message_text=>'Add %0'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113417551213212962)
,p_name=>'APEXAPP.BUTTON.ADD_MULTIPLE_USERS'
,p_message_text=>'Add Multiple Users'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113417671635212962)
,p_name=>'APEXAPP.BUTTON.ADD_USER'
,p_message_text=>'Add User'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113417777732212962)
,p_name=>'APEXAPP.BUTTON.ADD_USERS'
,p_message_text=>'Add Users'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113416514323212962)
,p_name=>'APEXAPP.BUTTON.APPLY'
,p_message_text=>'Apply Changes'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113416667471212962)
,p_name=>'APEXAPP.BUTTON.CANCEL'
,p_message_text=>'Cancel'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113416758259212962)
,p_name=>'APEXAPP.BUTTON.CLOSE'
,p_message_text=>'Close'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113416462432212962)
,p_name=>'APEXAPP.BUTTON.CREATE'
,p_message_text=>'Create'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113405759040212966)
,p_name=>'APEXAPP.BUTTON.DELETE'
,p_message_text=>'Delete'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113416968277212962)
,p_name=>'APEXAPP.BUTTON.DELETE_CHECKED'
,p_message_text=>'Delete Checked'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113417058209212962)
,p_name=>'APEXAPP.BUTTON.EDIT'
,p_message_text=>'Edit'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113417296241212962)
,p_name=>'APEXAPP.BUTTON.FINISH'
,p_message_text=>'Finish'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113405576148212966)
,p_name=>'APEXAPP.BUTTON.GO'
,p_message_text=>'Go'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113406249107212965)
,p_name=>'APEXAPP.BUTTON.LOAD_DATA'
,p_message_text=>'Load Data'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113417331639212962)
,p_name=>'APEXAPP.BUTTON.LOGIN'
,p_message_text=>'Sign In'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113405941339212966)
,p_name=>'APEXAPP.BUTTON.NEXT'
,p_message_text=>'Next'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113405870519212966)
,p_name=>'APEXAPP.BUTTON.PREVIOUS'
,p_message_text=>'Previous'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113405633246212966)
,p_name=>'APEXAPP.BUTTON.RESET'
,p_message_text=>'Reset'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113406039205212965)
,p_name=>'APEXAPP.BUTTON.SAVE'
,p_message_text=>'Save'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113406107803212965)
,p_name=>'APEXAPP.BUTTON.SUBMIT'
,p_message_text=>'Submit'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113417822948212962)
,p_name=>'APEXAPP.BUTTON.SUBMIT_FEEDBACK'
,p_message_text=>'Submit Feedback'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113417477405212962)
,p_name=>'APEXAPP.BUTTON.VIEW_DETAILS'
,p_message_text=>'View Details'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113410634924212964)
,p_name=>'APEXAPP.CHART.LABEL'
,p_message_text=>'Label %0'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113429857233212958)
,p_name=>'APEXAPP.CHART.SERIES'
,p_message_text=>'Series %0'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113422226568212960)
,p_name=>'APEXAPP.COLUMN.ACL_ROLES'
,p_message_text=>'Roles'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113410453999212964)
,p_name=>'APEXAPP.COLUMN.ACTIONS'
,p_message_text=>'Actions'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113421272716212961)
,p_name=>'APEXAPP.COLUMN.ACTIVITY_BY_HOUR'
,p_message_text=>'Activity by Hour'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113420598140212961)
,p_name=>'APEXAPP.COLUMN.APPLICATION_SESSIONS'
,p_message_text=>'Application Sessions'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113410358898212964)
,p_name=>'APEXAPP.COLUMN.ATTACHMENT'
,p_message_text=>'Attachment'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113409571105212964)
,p_name=>'APEXAPP.COLUMN.AUTOMATION'
,p_message_text=>'Automation'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113420108191212961)
,p_name=>'APEXAPP.COLUMN.AVG_ELAPSED'
,p_message_text=>'Avg Elapsed'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113419523560212961)
,p_name=>'APEXAPP.COLUMN.COMPONENT_NAME'
,p_message_text=>'Component Name'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113421180255212961)
,p_name=>'APEXAPP.COLUMN.CONTEXT'
,p_message_text=>'Context'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113418417974212961)
,p_name=>'APEXAPP.COLUMN.CURRENT_STATUS'
,p_message_text=>'Current Status'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113418103176212961)
,p_name=>'APEXAPP.COLUMN.DESCRIPTION'
,p_message_text=>'Description'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113420422699212961)
,p_name=>'APEXAPP.COLUMN.DISTINCT_USERS'
,p_message_text=>'Distinct Users'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113409376835212964)
,p_name=>'APEXAPP.COLUMN.EDIT'
,p_message_text=>'Edit'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113419212623212961)
,p_name=>'APEXAPP.COLUMN.ELAPSED'
,p_message_text=>'Elapsed'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113422165649212960)
,p_name=>'APEXAPP.COLUMN.ENDED'
,p_message_text=>'Ended'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113419884792212961)
,p_name=>'APEXAPP.COLUMN.ERROR'
,p_message_text=>'Error'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113409429675212964)
,p_name=>'APEXAPP.COLUMN.ERRORS'
,p_message_text=>'Errors'
,p_version_scn=>37165770887496
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113422082029212960)
,p_name=>'APEXAPP.COLUMN.ERROR_ROWS'
,p_message_text=>'Error Rows'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113417958587212962)
,p_name=>'APEXAPP.COLUMN.FEATURE'
,p_message_text=>'Feature'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113410098999212964)
,p_name=>'APEXAPP.COLUMN.FEEDBACK'
,p_message_text=>'Feedback'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113409802326212964)
,p_name=>'APEXAPP.COLUMN.FILED'
,p_message_text=>'Filed'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113422466407212960)
,p_name=>'APEXAPP.COLUMN.FILED_BY'
,p_message_text=>'Filed By'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113420932528212961)
,p_name=>'APEXAPP.COLUMN.FULL_PAGE_VIEWS'
,p_message_text=>'Full Page Views'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113419769573212961)
,p_name=>'APEXAPP.COLUMN.IR_SEARCH'
,p_message_text=>'IR Search'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113418514956212961)
,p_name=>'APEXAPP.COLUMN.LABEL'
,p_message_text=>'Label'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113418832741212961)
,p_name=>'APEXAPP.COLUMN.LAST_ACTIVITY'
,p_message_text=>'Last Activity'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113420033327212961)
,p_name=>'APEXAPP.COLUMN.MAX_ELAPSED'
,p_message_text=>'Max Elapsed'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113420255676212961)
,p_name=>'APEXAPP.COLUMN.MEDIAN_ELAPSED'
,p_message_text=>'Median Elapsed'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113421664948212960)
,p_name=>'APEXAPP.COLUMN.MESSAGE'
,p_message_text=>'Message'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113421768692212960)
,p_name=>'APEXAPP.COLUMN.MESSAGE_TYPE'
,p_message_text=>'Message Type'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113419962910212961)
,p_name=>'APEXAPP.COLUMN.MIN_ELAPSED'
,p_message_text=>'Min Elapsed'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113421588529212960)
,p_name=>'APEXAPP.COLUMN.MOST_RECENT'
,p_message_text=>'Most_Recent'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113419672595212961)
,p_name=>'APEXAPP.COLUMN.NUM_ROWS'
,p_message_text=>'Num Rows'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113421031580212961)
,p_name=>'APEXAPP.COLUMN.OCCURRENCE'
,p_message_text=>'Occurrence'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113419398157212961)
,p_name=>'APEXAPP.COLUMN.PAGE'
,p_message_text=>'Page'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113421324569212960)
,p_name=>'APEXAPP.COLUMN.PAGE_EVENTS'
,p_message_text=>'Page Events'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113419424921212961)
,p_name=>'APEXAPP.COLUMN.PAGE_MODE'
,p_message_text=>'Mode'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113418909854212961)
,p_name=>'APEXAPP.COLUMN.PAGE_NAME'
,p_message_text=>'Page Name'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113420637526212961)
,p_name=>'APEXAPP.COLUMN.PAGE_VIEWS'
,p_message_text=>'Page Views'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113420840793212961)
,p_name=>'APEXAPP.COLUMN.PARTIAL_PAGE_VIEWS'
,p_message_text=>'Partial Page Views'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113421851403212960)
,p_name=>'APEXAPP.COLUMN.PK_VALUE'
,p_message_text=>'Primary Key Value'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113409992703212964)
,p_name=>'APEXAPP.COLUMN.RATING'
,p_message_text=>'Rating'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113422301049212960)
,p_name=>'APEXAPP.COLUMN.REASON'
,p_message_text=>'Reason'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113410198769212964)
,p_name=>'APEXAPP.COLUMN.RESPONSE'
,p_message_text=>'Response'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113421443133212960)
,p_name=>'APEXAPP.COLUMN.ROWS_FETCHED'
,p_message_text=>'Rows Fetched'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113409792687212964)
,p_name=>'APEXAPP.COLUMN.SCHEDULED'
,p_message_text=>'Scheduled'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113409673490212964)
,p_name=>'APEXAPP.COLUMN.STARTED'
,p_message_text=>'Started'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113418067160212961)
,p_name=>'APEXAPP.COLUMN.STATUS'
,p_message_text=>'Status'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113421911298212960)
,p_name=>'APEXAPP.COLUMN.SUCCESSFUL_ROWS'
,p_message_text=>'Successful Rows'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113419125079212961)
,p_name=>'APEXAPP.COLUMN.TIMESTAMP'
,p_message_text=>'Timestamp'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113420741607212961)
,p_name=>'APEXAPP.COLUMN.TOTAL_ROWS'
,p_message_text=>'Total Rows'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113418361367212961)
,p_name=>'APEXAPP.COLUMN.UPDATED_BY'
,p_message_text=>'Updated By'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113418248080212961)
,p_name=>'APEXAPP.COLUMN.UPDATED_ON'
,p_message_text=>'Updated'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113419074268212961)
,p_name=>'APEXAPP.COLUMN.USER'
,p_message_text=>'User'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113418785376212961)
,p_name=>'APEXAPP.COLUMN.USERNAME'
,p_message_text=>'Username'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113410284459212964)
,p_name=>'APEXAPP.COLUMN.USER_AGENT'
,p_message_text=>'User Agent'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113418633728212961)
,p_name=>'APEXAPP.COLUMN.VALUE'
,p_message_text=>'Value'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113420354166212961)
,p_name=>'APEXAPP.COLUMN.WEIGHTED_PERFORMANCE'
,p_message_text=>'Weighted Performance'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113402910198212968)
,p_name=>'APEXAPP.DA.AFTER_CLOSE_DIALOG'
,p_message_text=>'Dialog Closed'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113415872113212962)
,p_name=>'APEXAPP.DA.CANCEL_BUTTON.DIALOG_CANCEL'
,p_message_text=>'Cancel Dialog'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113416326456212962)
,p_name=>'APEXAPP.DA.CHANGE_FILTERS'
,p_message_text=>'Change Filters'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113415930640212962)
,p_name=>'APEXAPP.DA.CREATE_BUTTON.DIALOG_CLOSED'
,p_message_text=>'Create Button - Dialog Closed'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113416074788212962)
,p_name=>'APEXAPP.DA.EDIT_REPORT.DIALOG_CLOSED'
,p_message_text=>'Edit Report - Dialog Closed'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113416114562212962)
,p_name=>'APEXAPP.DA.PERFORM_SEARCH'
,p_message_text=>'Perform Search'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113416227616212962)
,p_name=>'APEXAPP.DA.REFRESH_REPORT'
,p_message_text=>'Refresh Report'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113405407214212966)
,p_name=>'APEXAPP.DATA_LOAD.CHAR_SET_ITEM_HELP'
,p_message_text=>'File Character Set'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15128674953471154)
,p_name=>'APEXAPP.FA_AUTHENTICATION_SCHEME_COMMENT'
,p_message_text=>'Created for federated authentication with the %0 Fusion instance.'
,p_version_scn=>37167548362450
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3578716989865350)
,p_name=>'APEXAPP.FA_DATA_SOURCE_SELF_NAME'
,p_message_text=>'HCM Self Details'
,p_version_scn=>37167525203450
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(11852881629681451)
,p_name=>'APEXAPP.FA_DEFAULT_APP_DESCRIPTION'
,p_message_text=>'Sample application with pre-configured integrations to the %0 Fusion Applications environment.'
,p_version_scn=>37167548362476
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(11655200623642438)
,p_name=>'APEXAPP.FA_DEFAULT_APP_NAME'
,p_message_text=>'Fusion Integrated Sample App (%0)'
,p_version_scn=>37167509040520
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(11852692108676530)
,p_name=>'APEXAPP.FA_DEFAULT_APP_VERSION'
,p_message_text=>'Release 1.0'
,p_version_scn=>37167509399195
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15002155510303804)
,p_name=>'APEXAPP.FA_LAUNCH_URL_TITLE'
,p_message_text=>'Fusion Cloud Applications'
,p_version_scn=>37167528208845
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15658814954415490)
,p_name=>'APEXAPP.FA_PAGE_NAME_HOME'
,p_message_text=>'Home'
,p_version_scn=>37167528237308
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3127601385182641)
,p_name=>'APEXAPP.FA_PAGE_TITLE_SELF_DETAILS'
,p_message_text=>'Your Details'
,p_version_scn=>37167514537094
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(9770436938365588)
,p_name=>'APEXAPP.FA_REGION_TITLE_SELF_DETAILS'
,p_message_text=>'Details About the Current User'
,p_version_scn=>37167526807896
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(13643705345022712)
,p_name=>'APEXAPP.FA_REGION_TITLE_SELF_HERO'
,p_message_text=>'Example Authenticated REST API Call'
,p_version_scn=>37167527488662
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(13388805429307560)
,p_name=>'APEXAPP.FA_REMOTE_SERVER_COMMENT'
,p_message_text=>'Created for access to the REST endpoints on the %0 Fusion instance.'
,p_version_scn=>37167548362519
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(13389251607316838)
,p_name=>'APEXAPP.FA_WEB_CREDENTIAL_COMMENT'
,p_message_text=>'Credential for integration with the %0 Fusion instance via OAuth.'
,p_version_scn=>37167548362542
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113405062585212966)
,p_name=>'APEXAPP.ITEM.ACL_ROLES'
,p_message_text=>'Roles'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113428617978212958)
,p_name=>'APEXAPP.ITEM.ACL_ROLES.HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>When Access Control is enabled, Administrators have the ability to restrict access to certain application features for authenticated users. This application supports the following 3 roles: Reader, Contributor, and Administrator.<p>',
'<ul>',
'  <li><strong>Readers</strong> have read-only access to all information and can also view reports.</li>',
'  <li><strong>Contributors</strong> can create,edit and delete information and view reports.</li>',
'  <li><strong>Administrators</strong>,in addition to Contributors capability,can also perform configuration of the application.</li>',
'</ul>'))
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113428461084212958)
,p_name=>'APEXAPP.ITEM.ANY_USER_HAS_ACCESS'
,p_message_text=>'Any authenticated user may access this application'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113428588608212958)
,p_name=>'APEXAPP.ITEM.ANY_USER_HAS_ACCESS.HELP'
,p_message_text=>'Choose <strong>No</strong> if all users are defined in the access control list. Choose <strong>Yes</strong> if authenticated users not in the access control list may also use this application.'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113426756128212959)
,p_name=>'APEXAPP.ITEM.APP_DATE_FORMAT'
,p_message_text=>'Date / Number Formats to use'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113426804945212959)
,p_name=>'APEXAPP.ITEM.APP_DATE_FORMAT.HELP'
,p_message_text=>'Choose whether to provide custom or to use standard format masks'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113429206780212958)
,p_name=>'APEXAPP.ITEM.ATTACHMENT'
,p_message_text=>'Attachment'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113428283922212958)
,p_name=>'APEXAPP.ITEM.AUTOMATION'
,p_message_text=>'Automation'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113426941005212959)
,p_name=>'APEXAPP.ITEM.CHAR_SET'
,p_message_text=>'File Character Set'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113425715209212959)
,p_name=>'APEXAPP.ITEM.COPY_PASTE'
,p_message_text=>'Copy and Paste Delimited Data'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113427021835212959)
,p_name=>'APEXAPP.ITEM.CURRENCY'
,p_message_text=>'Currency Symbol'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113427123451212959)
,p_name=>'APEXAPP.ITEM.CURRENCY.HELP'
,p_message_text=>'If your data contains international currency symbol, enter it here. For example, if your data has "&euro;1,234.56" or "&yen;1,234.56", enter "&euro;" or "&yen;".  Otherwise the data will not load correctly.'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113425464176212959)
,p_name=>'APEXAPP.ITEM.DATA_LOAD_IMPORT_FROM'
,p_message_text=>'Import From'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113427430957212959)
,p_name=>'APEXAPP.ITEM.DECIMAL_CHARACTER_HELP'
,p_message_text=>'Decimal Character'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113427594884212959)
,p_name=>'APEXAPP.ITEM.DECIMAL_CHARACTER_HELP.HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>The decimal character separates the integer and decimal parts of a number.</p>',
'<p> Any character can be the decimal character. The character specified must be single-byte, and the decimal character must be different from group separator. The character can be a space, but cannot be any numeric character or any of the following c'
||'haracters:</p>',
'<ul class="noIndent">',
'<li>plus (+)</li>',
'<li>hyphen (-)</li> ',
'<li>less than sign (<)</li>',
'<li>greater than sign (>)</li> ',
'</ul>'))
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113404655958212966)
,p_name=>'APEXAPP.ITEM.DISPLAY'
,p_message_text=>'Display'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113429320003212958)
,p_name=>'APEXAPP.ITEM.ENABLE_ATTACHEMENTS'
,p_message_text=>'Enable Attachments'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113426081768212959)
,p_name=>'APEXAPP.ITEM.ENCLOSED_BY'
,p_message_text=>'Optionally Enclosed By'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113404980117212966)
,p_name=>'APEXAPP.ITEM.ENCLOSED_BY.HELP'
,p_message_text=>'Enter a delimiter character. You can use this character to delineate the starting and ending boundary of a data value. If you specify a delimiter character, Data Workshop ignores whitespace occurring before the starting and ending boundary of a data '
||'value. You can also use this option to enclose a data value with the specified delimiter character.'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113429192675212958)
,p_name=>'APEXAPP.ITEM.EXPERIENCE'
,p_message_text=>'Experience'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113426499731212959)
,p_name=>'APEXAPP.ITEM.FAILED_COUNT'
,p_message_text=>'Failed Row(s):'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113405188338212966)
,p_name=>'APEXAPP.ITEM.FEEDBACK'
,p_message_text=>'Feedback'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113429406720212958)
,p_name=>'APEXAPP.ITEM.FILED'
,p_message_text=>'Filed'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113425537776212959)
,p_name=>'APEXAPP.ITEM.FILE_NAME'
,p_message_text=>'File Name'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113425670006212959)
,p_name=>'APEXAPP.ITEM.FILE_NAME.HELP'
,p_message_text=>'Name of the file to upload'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113426129899212959)
,p_name=>'APEXAPP.ITEM.FIRST_ROW.HELP'
,p_message_text=>'Select this box if your data contains column names in the first row.'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113427266266212959)
,p_name=>'APEXAPP.ITEM.GROUP_SEPARATOR'
,p_message_text=>'Group Separator'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113427383218212959)
,p_name=>'APEXAPP.ITEM.GROUP_SEPARATOR.HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>A group separator is a character that separates integer groups, for example to show thousands and millions.</p>',
'<p>Any character can be the group separator. The character specified must be single-byte, and the group separator must be different from any other decimal character. The character can be a space, but cannot be a numeric character or any of the follow'
||'ing:</p>',
'<ul class="noIndent">',
'<li>plus (+)</li>',
'<li>hyphen (-)</li> ',
'<li>less than sign (<)</li>',
'<li>greater than sign (>)</li> ',
'</ul>'))
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113426281686212959)
,p_name=>'APEXAPP.ITEM.INSERTED_COUNT'
,p_message_text=>'Inserted Row(s):'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(10200684396998904)
,p_name=>'APEXAPP.ITEM.ORDER_BY'
,p_message_text=>'Order By'
,p_is_js_message=>true
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113405296743212966)
,p_name=>'APEXAPP.ITEM.PAGE'
,p_message_text=>'Page'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113404849891212966)
,p_name=>'APEXAPP.ITEM.PASSWORD'
,p_message_text=>'Password'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2000648611280622)
,p_name=>'APEXAPP.ITEM.PERSISTENT_AUTHENTICATION'
,p_message_text=>'Remember me'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113429599664212958)
,p_name=>'APEXAPP.ITEM.RATING'
,p_message_text=>'Rating'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113425205195212959)
,p_name=>'APEXAPP.ITEM.REMEMBER_USERNAME'
,p_message_text=>'Remember username'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113425398031212959)
,p_name=>'APEXAPP.ITEM.REMEMBER_USERNAME.HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'If you select this checkbox, the application will save your username in a persistent browser cookie named "LOGIN_USERNAME_COOKIE".',
'When you go to the login page the next time,',
'the username field will be automatically populated with this value.',
'</p>',
'<p>',
'If you deselect this checkbox and your username is already saved in the cookie,',
'the application will overwrite it with an empty value.',
'You can also use your browser''s developer tools to completely remove the cookie.',
'</p>'))
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113429626710212958)
,p_name=>'APEXAPP.ITEM.RESPONSE'
,p_message_text=>'Response'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113426542819212959)
,p_name=>'APEXAPP.ITEM.REVIEW_COUNT'
,p_message_text=>'To be Reviewed Row(s):'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113404444903212966)
,p_name=>'APEXAPP.ITEM.SEARCH'
,p_message_text=>'Search'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113404592508212966)
,p_name=>'APEXAPP.ITEM.SEARCH.PLACEHOLDER'
,p_message_text=>'Search...'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113425858288212959)
,p_name=>'APEXAPP.ITEM.SEPARATOR'
,p_message_text=>'Separator'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113425905491212959)
,p_name=>'APEXAPP.ITEM.SEPARATOR.HELP'
,p_message_text=>'Identify a column separator character. Use <code>\t</code> for tab separators.'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113426687352212959)
,p_name=>'APEXAPP.ITEM.SHOW_ADVANCED_SETTINGS.HELP'
,p_message_text=>'Display advanced settings for data loading: Currency Symbol, Decimal Characters, File Encoding or Date Formats'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113428353305212958)
,p_name=>'APEXAPP.ITEM.STARTED'
,p_message_text=>'Started'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113405317049212966)
,p_name=>'APEXAPP.ITEM.STATUS'
,p_message_text=>'Status'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113427943045212959)
,p_name=>'APEXAPP.ITEM.THEME_PREFERENCE'
,p_message_text=>'End User Theme Preference'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113428003116212958)
,p_name=>'APEXAPP.ITEM.THEME_PREFERENCE.HELP'
,p_message_text=>'If checked, end users may choose their own Theme Style using the Customize link.'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113427730866212959)
,p_name=>'APEXAPP.ITEM.THEME_STYLE'
,p_message_text=>'Desktop Theme Style'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113427879513212959)
,p_name=>'APEXAPP.ITEM.THEME_STYLE.HELP'
,p_message_text=>'The default Theme Style applies to all users.'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113427672596212959)
,p_name=>'APEXAPP.ITEM.TIMEFRAME'
,p_message_text=>'Timeframe'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113426320365212959)
,p_name=>'APEXAPP.ITEM.UPDATED_COUNT'
,p_message_text=>'Updated Row(s):'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113404703183212966)
,p_name=>'APEXAPP.ITEM.USERNAME'
,p_message_text=>'Username'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113428717163212958)
,p_name=>'APEXAPP.ITEM.USERNAMES'
,p_message_text=>'Usernames'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113428902575212958)
,p_name=>'APEXAPP.ITEM.USERNAMES.HELP'
,p_message_text=>'Enter usernames separated by commas, semicolons, or whitespace. Existing or duplicate usernames will automatically be ignored.'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113428859757212958)
,p_name=>'APEXAPP.ITEM.USERNAMES.PLACEHOLDER'
,p_message_text=>'Enter usernames here'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113429059714212958)
,p_name=>'APEXAPP.ITEM.USERNAME_FORMAT'
,p_message_text=>'Username Format'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113429712638212958)
,p_name=>'APEXAPP.ITEM.USER_AGENT'
,p_message_text=>'User Agent'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113428135444212958)
,p_name=>'APEXAPP.ITEM.VIEW_AS'
,p_message_text=>'View As'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113407415602212965)
,p_name=>'APEXAPP.LIST.ACCESS_CONTROL'
,p_message_text=>'Access Control'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113407358646212965)
,p_name=>'APEXAPP.LIST.ACTIVITY_REPORTS'
,p_message_text=>'Activity Reports'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113432089574212957)
,p_name=>'APEXAPP.LIST.APP_ADMINISTRATION'
,p_message_text=>'Application Administration'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113407236790212965)
,p_name=>'APEXAPP.LIST.APP_CONFIGURATION'
,p_message_text=>'Application Configuration'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113407664160212965)
,p_name=>'APEXAPP.LIST.EMAIL_REPORTING'
,p_message_text=>'Email Reporting'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113407518891212965)
,p_name=>'APEXAPP.LIST.FEEDBACK'
,p_message_text=>'Feedback'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113431980005212957)
,p_name=>'APEXAPP.LIST.HOME_NAVIGATION'
,p_message_text=>'Page Navigation'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113407786708212965)
,p_name=>'APEXAPP.LIST.JOB_REPORTING'
,p_message_text=>'Job Reporting'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113431891886212957)
,p_name=>'APEXAPP.LIST.NAVIGATION_BAR'
,p_message_text=>'Navigation Bar'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113432110330212957)
,p_name=>'APEXAPP.LIST.NAVIGATION_MENU'
,p_message_text=>'Navigation Menu'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113407137906212965)
,p_name=>'APEXAPP.LIST.USER_INTERFACE'
,p_message_text=>'User Interface'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113432295909212957)
,p_name=>'APEXAPP.LIST_ENTRY.APP_ADMIN.DESC'
,p_message_text=>'Manage component'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113407998270212965)
,p_name=>'APEXAPP.LIST_ENTRY.HOME'
,p_message_text=>'Home'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113408074122212965)
,p_name=>'APEXAPP.LIST_ENTRY.LOGOUT'
,p_message_text=>'Log Out'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113430053969212958)
,p_name=>'APEXAPP.LOV.RPT_MAX_ROW'
,p_message_text=>'Report Row Per Page'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113431539905212957)
,p_name=>'APEXAPP.LOV_ENTRY.ACKNOWLEDGED'
,p_message_text=>'Acknowledged'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113430957512212958)
,p_name=>'APEXAPP.LOV_ENTRY.CHART'
,p_message_text=>'Add Chart Page'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113431721460212957)
,p_name=>'APEXAPP.LOV_ENTRY.CLOSED'
,p_message_text=>'Closed'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113430283982212958)
,p_name=>'APEXAPP.LOV_ENTRY.COPY_PASTE'
,p_message_text=>'Copy and Paste'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113430577182212958)
,p_name=>'APEXAPP.LOV_ENTRY.DATE_FORMAT_APP'
,p_message_text=>'Use application standard format masks'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113430609791212958)
,p_name=>'APEXAPP.LOV_ENTRY.DATE_FORMAT_CUSTOM'
,p_message_text=>'Provide custom formats for uploaded columns'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113431044326212958)
,p_name=>'APEXAPP.LOV_ENTRY.EMAIL_ADDRESSES'
,p_message_text=>'Email Addresses'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113430796638212958)
,p_name=>'APEXAPP.LOV_ENTRY.END_USER_THEME_SELECTION'
,p_message_text=>'Allow End Users to choose Theme Style'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113430302188212958)
,p_name=>'APEXAPP.LOV_ENTRY.FIRST_ROW'
,p_message_text=>'First Row has Column Names'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113431320966212958)
,p_name=>'APEXAPP.LOV_ENTRY.NEGATIVE'
,p_message_text=>'Negative'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113431280229212958)
,p_name=>'APEXAPP.LOV_ENTRY.NEUTRAL'
,p_message_text=>'Neutral'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113431477538212957)
,p_name=>'APEXAPP.LOV_ENTRY.NO_ACTION'
,p_message_text=>'No Action'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113431658668212957)
,p_name=>'APEXAPP.LOV_ENTRY.OPEN'
,p_message_text=>'Open'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113431161241212958)
,p_name=>'APEXAPP.LOV_ENTRY.POSITIVE'
,p_message_text=>'Positive'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113430870233212958)
,p_name=>'APEXAPP.LOV_ENTRY.REPORT'
,p_message_text=>'Add Report Page'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113430468808212958)
,p_name=>'APEXAPP.LOV_ENTRY.SHOW_ADVANCED_SETTINGS'
,p_message_text=>'Use Advanced Settings'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113430153933212958)
,p_name=>'APEXAPP.LOV_ENTRY.UPLOAD_FILE'
,p_message_text=>'Upload file, comma separated (*.csv) or tab delimited'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113434131142212956)
,p_name=>'APEXAPP.PAGE.ACTIVITY_DASHBOARD'
,p_message_text=>'Activity Dashboard'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113408689696212964)
,p_name=>'APEXAPP.PAGE.ADD_MULTIPLE_USERS'
,p_message_text=>'Add Multiple Users - Step %0'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113408849554212964)
,p_name=>'APEXAPP.PAGE.ADD_MULTIPLE_USERS.TITLE'
,p_message_text=>'Add Multiple Users'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113433762171212956)
,p_name=>'APEXAPP.PAGE.ADMIN'
,p_message_text=>'Administration'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113433857009212956)
,p_name=>'APEXAPP.PAGE.ADMIN.HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>The administration page allows application owners (Administrators) to configure the application and maintain common data used across the application.',
'By selecting one of the available settings, administrators can potentially change how the application is displayed and/or features available to the end users.</p>',
'<p>Access to this page should be limited to Administrators only.</p>'))
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113434355729212956)
,p_name=>'APEXAPP.PAGE.AUTOMATIONS_LOG'
,p_message_text=>'Automations Log'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113434467413212956)
,p_name=>'APEXAPP.PAGE.AUTOMATIONS_LOG.HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>This page provides an interactive report of the automations log.</p>',
'<p>Review logged information about previous automation executions. The log contains start and end timestamps as well as details about processed rows (successful and with errors). Drill down into Messages to see individual messages for processed rows.'
||'</p>',
''))
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113434097449212956)
,p_name=>'APEXAPP.PAGE.CONFIGURATION_SETTINGS.HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Configuration settings allow you to make specific functionality either available (enabled) or unavailable (disabled) to end users.</p>',
'<p>If a specific function is not 100% ready, or needs to be temporarily removed, click <strong>Disabled</strong>. ',
'Once it should be made available, simply click <strong>Enabled</strong>.</p>',
'<p><em><strong>Note:</strong> Changes made here will not be reflected for individual end users currently running the application. Once the end user signs out and then signs back in the revised feature settings will be invoked.</em></p>'))
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113435489936212956)
,p_name=>'APEXAPP.PAGE.CONFIG_ACCESS_CONTROL'
,p_message_text=>'Configure Access Control'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113435574061212956)
,p_name=>'APEXAPP.PAGE.CONFIG_ACCESS_CONTROL.HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Select the appropriate choice for any authenticated users.<br> ',
'Selecting <strong>No</strong> makes the application more secure as only specified users can access the application. ',
'However, if your application has a large user community then maintaining users may be onerous, and you may prefer to choose <strong>Yes</strong> and only enter application Administrators, and possibly Contributors.<br>',
'If you select <strong>Yes</strong> then you must also select how users not included in the users list are treated.</p>',
'<p>Select between requiring email addresses and any alphanumeric value for Usernames.<br>',
'Generally, you should set this setting to <strong>E-mail Address</strong> if your application uses (or will be configured to use) a centralized authentication scheme such as Oracle Access Manager, or SSO.</p>',
'<p><em><strong>Note:</strong> This application supports the following 3 access levels: Reader, Contributor, and Administrator.',
'<ul>',
'  <li><strong>Readers</strong> have read-only access to all information and can also view reports.</li>',
'  <li><strong>Contributors</strong> can create, edit and delete information and view reports.</li>',
'  <li><strong>Administrators</strong>, in addition to Contributors capability, can also perform configuration of the application by accessing the Administration section of the application.</li>',
'</ul>',
'</em></p>'))
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113434967516212956)
,p_name=>'APEXAPP.PAGE.ERROR_LOG'
,p_message_text=>'Application Error Log'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113435034451212956)
,p_name=>'APEXAPP.PAGE.ERROR_LOG.HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>This page provides an interactive report of all unexpected errors logged by this application.</p>',
'<p>Click on the column headings to sort and filter data, or click on the <strong>Actions</strong> button to customize column display and many additional advanced features. Click the <strong>Reset</strong> button to reset the interactive report back t'
||'o the default settings.</p>'))
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113435734527212956)
,p_name=>'APEXAPP.PAGE.FEEDBACK'
,p_message_text=>'Feedback'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113435852302212956)
,p_name=>'APEXAPP.PAGE.FEEDBACK_SETTINGS'
,p_message_text=>'Feedback Settings'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113435981701212956)
,p_name=>'APEXAPP.PAGE.FEEDBACK_SETTINGS.HELP'
,p_message_text=>'<p><strong>Enable Attachments</strong> - If yes, users will be able to upload an attachment in support of their feedback.</p>'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113408709650212964)
,p_name=>'APEXAPP.PAGE.FEEDBACK_SUBMITTED'
,p_message_text=>'Feedback Submitted'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113408439038212964)
,p_name=>'APEXAPP.PAGE.GLOBAL'
,p_message_text=>'Global Page'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113408192761212965)
,p_name=>'APEXAPP.PAGE.HOME'
,p_message_text=>'Home'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113432818985212957)
,p_name=>'APEXAPP.PAGE.HOME.HELP.FEEDBACK'
,p_message_text=>'<p>Click the feedback icon ( <span class="fa fa-comment-o" aria-hidden="true"></span> ) in the navigation bar, from any page in the application, to leave feedback for the application administrators.</p>'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113432617965212957)
,p_name=>'APEXAPP.PAGE.HOME.HELP.SIDE_MENU'
,p_message_text=>'<p>This is the home page of the application. Click on the cards to access different pages in the application, or use the navigation menu on the side of the page.</p>'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113433228098212957)
,p_name=>'APEXAPP.PAGE.HOME.HELP.SIGNOUT'
,p_message_text=>'<p>Click your name dropdown in the navigation bar to sign out of the application.</p>'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113433103147212957)
,p_name=>'APEXAPP.PAGE.HOME.HELP.TIMEZONE'
,p_message_text=>'<p>Click the user menu ( <span class="fa fa-user" aria-hidden="true"></span> ) in the navigation bar to update your time zone preference, and sign out of the application.</p>'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113432574771212957)
,p_name=>'APEXAPP.PAGE.HOME.HELP.TITLE'
,p_message_text=>'Home Page'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113432727420212957)
,p_name=>'APEXAPP.PAGE.HOME.HELP.TOP_MENU'
,p_message_text=>'<p>This is the home page of the application. Click on the cards to access different pages in the application, or use the navigation menu at the top of the page.</p>'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113433067539212957)
,p_name=>'APEXAPP.PAGE.HOME.HELP.USER'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Click the user menu ( <span class="fa fa-user" aria-hidden="true"></span> ) in the navigation bar (top right of the page) to access your user profile, and sign out of the application.<br>',
'If you click <strong>View My Profile</strong> you can then click <strong>Update Profile</strong> to enter your personal details and upload a photo or avatar.</p>'))
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113432980286212957)
,p_name=>'APEXAPP.PAGE.HOME.HELP.USER_TIMEZONE'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Click the user menu ( <span class="fa fa-user" aria-hidden="true"></span> ) in the navigation bar to access your user profile, update your time zone preference, and sign out of the application.<br>',
'If you click <strong>View My Profile</strong> you can then click <strong>Update Profile</strong> to enter your personal details and upload a photo or avatar.</p>'))
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113433413090212957)
,p_name=>'APEXAPP.PAGE.IG.HELP.EDITABLE'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>You can insert, update, and delete data directly within this interactive grid.<br>',
'  Insert a new row by clicking the Add Row button.<br>',
'  Double click into a cell, or click the <strong>Edit</strong> button to update data values, similar to editing data in a spreadsheet.</p>',
'',
'<p>Use the Row Actions menu ( <span class="fa fa-bars" aria-hidden="true"></span> ) at the top of the report to duplicate, delete, refresh or revert selected rows.<br> ',
'  Use the Row Actions menu on individual rows to also access the single row view or add a new row.</p>',
'',
'<p>To find data enter a search term into the search dialog, or click on the column headings to limit the records returned.</p>',
'',
'<p>You can perform numerous functions by clicking the <strong>Actions</strong> button. This includes selecting the columns that are displayed / hidden and their display sequence, plus numerous data and format functions.  You can also define an additi'
||'onal view of the data using the chart option.</p>',
'',
'<p>If you want to save your customizations select report, or click download to unload the data.<p>',
'',
'<p>For additional information click Help at the bottom of the Actions menu.</p> ',
'',
'<p>Click the <strong>Reset</strong> button to reset the interactive grid back to the default settings.</p>'))
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113433589415212957)
,p_name=>'APEXAPP.PAGE.IG.HELP.READONLY'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>To find data enter a search term into the search dialog, or click on the column headings to limit the records returned.</p>',
'',
'<p>You can perform numerous functions by clicking the <strong>Actions</strong> button. This includes selecting the columns that are displayed / hidden and their display sequence, plus numerous data and format functions.  You can also define an additi'
||'onal view of the data using the chart option.</p>',
'',
'<p>If you want to save your customizations select report, or click download to unload the data.<p>',
'<br>',
'<p>For additional information click Help at the bottom of the Actions menu.</p> ',
'',
'<p>Click the <strong>Reset</strong> button to reset the interactive report back to the default settings.</p>',
''))
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113433317012212957)
,p_name=>'APEXAPP.PAGE.IR.HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>To find data enter a search term into the search dialog, or click on the column headings to limit the records returned.</p>',
'',
'<p>You can perform numerous functions by clicking the <strong>Actions</strong> button. This includes selecting the columns that are displayed / hidden and their display sequence, plus numerous data and format functions.  You can also define additiona'
||'l views of the data using the chart, group by, and pivot options.</p>',
'',
'<p>If you want to save your customizations select report, or click download to unload the data. Enter you email address and time frame under subscription to be sent the data on a regular basis.<p>',
'',
'<p>For additional information click Help at the bottom of the Actions menu.</p> ',
'',
'<p>Click the <strong>Reset</strong> button to reset the interactive report back to the default settings.</p>'))
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113408208592212965)
,p_name=>'APEXAPP.PAGE.LOGIN'
,p_message_text=>'Login Page'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113408327507212965)
,p_name=>'APEXAPP.PAGE.LOGIN.TITLE'
,p_message_text=>'%0 - Log In'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113435165931212956)
,p_name=>'APEXAPP.PAGE.LOG_MESSAGES'
,p_message_text=>'Log Messages'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113436017312212955)
,p_name=>'APEXAPP.PAGE.MANAGE_FEEDBACK'
,p_message_text=>'Manage Feedback'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113436145079212955)
,p_name=>'APEXAPP.PAGE.MANAGE_FEEDBACK.HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Feedback can be entered by end users from any normal page within the application.</p>',
'<p>This report shows the feedback entered, any response enter by administrators, and the status of the feedback.</p>',
'<p>Click the edit icon (yellow pencil) to enter a response or update the feedback status.</p>',
'<p><em><strong>Note:</strong> If feedback recipients have been defined then feedback submissions will also be emailed to the email addresses in the feedback recipients list.</em></p>'))
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113435279279212956)
,p_name=>'APEXAPP.PAGE.MANAGE_USER_ACCESS'
,p_message_text=>'Manage User Access'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113435344754212956)
,p_name=>'APEXAPP.PAGE.MANAGE_USER_ACCESS.HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>This page shows a report of the application users and the access level granted.</p>',
'<p>Click on the column headings to sort and filter data, or click on the <strong>Actions</strong> button to customize column display and many additional advanced features.<br>',
'Click the <strong>Reset</strong> button to reset the interactive report back to the default settings.</p>',
'<p>Click the edit icon (yellow pencil) to edit the user details and access level, or to delete the user.</p>',
'<p>Click <strong>Add User</strong>, at the top of the report, to add a new user and their access level.</p>'))
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113435646307212956)
,p_name=>'APEXAPP.PAGE.MANAGE_USER_ACCESS_FORM.HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Use this form to enter users, their email address and set their access level. ',
'The settings defined under <em>Configure Access Control</em> will determine whether the username must be their email address or can be any alphanumeric entry.</p>',
'<p>This application supports the following 3 access levels: Reader, Contributor, and Administrator.</p>',
'<ul>',
'  <li><strong>Readers</strong> have read-only access to all information and can also view reports.</li>',
'  <li><strong>Contributors</strong> can create, edit and delete information and view reports.</li>',
'  <li><strong>Administrators</strong>, in addition to Contributors capability, can also perform configuration of the application by accessing the Administration section of the application.</li>',
'</ul>',
'<p>When editing an existing user you can lock their account which will prevent them from accessing the application.</p>',
'<p><em><strong>Note:</strong>   If using Oracle APEX accounts then users entered here must also be defined as end users by a Workspace Administrator, who can also set their password.</em></p>'))
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113433610035212956)
,p_name=>'APEXAPP.PAGE.MD.HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>This report page displays primary records in a selector on the side of the page. ',
'  Select a record to see the master record and any detail records defined.<br> ',
'  Click the edit icon ( <span class="fa fa-pencil-square-o" aria-hidden="true"></span> ) to edit the master record.',
'  For detail records, click the pencil, at the beginning of each row, to edit that record.</p>',
'<p>To limit the data displayed in the selector enter a search term into the search dialog.</p>',
'',
'<p>To add a new master record click <strong>Create</strong> at the top of the page.',
'  For detail records, click the plus icon ( + ) at the top of the detail region to add a detail record.</p>',
'',
'<p>Click <strong>Reset</strong> at the top of the page to reset the page back to the default settings, removing any search term previously defined.</p>'))
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113434715669212956)
,p_name=>'APEXAPP.PAGE.PAGE_PERFORMANCE'
,p_message_text=>'Page Performance'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113434828283212956)
,p_name=>'APEXAPP.PAGE.PAGE_PERFORMANCE.HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>This page provides an interactive report of the page performance and popularity. The report is ordered by <strong>Weighted Performance</strong> which is calculated by multiplying the Median Elapsed time and number of Page Views.</p>',
'<p>Select the reporting timeframe (Default = 1 day) at the top of the page as necessary.<br>',
'Click on the column headings to sort and filter data, or click on the <strong>Actions</strong> button to customize column display and many additional advanced features. Click the <strong>Reset</strong> button to reset the interactive report back to t'
||'he default settings.</p>'))
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113434500105212956)
,p_name=>'APEXAPP.PAGE.PAGE_VIEWS'
,p_message_text=>'Page Views'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113434605339212956)
,p_name=>'APEXAPP.PAGE.PAGE_VIEWS.HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>This page provides an interactive report of the most recent page views.</p>',
'<p>Select the reporting timeframe (Default = 1 day) at the top of the page as necessary.<br>',
'Click on the column headings to sort and filter data, or click on the <strong>Actions</strong> button to customize column display and many additional advanced features. Click the <strong>Reset</strong> button to reset the interactive report back to t'
||'he default settings.</p>'))
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113433956921212956)
,p_name=>'APEXAPP.PAGE.THEME_SELECTOR.HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Select the default color scheme used to display the application.</p>',
'<p>If <strong>Allow End Users to choose Theme Style</strong> is checked, then each end user can select from the available theme styles by clicking the <em>Customize</em> link in the bottom left corner of the Home page.</p>'))
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113408520658212964)
,p_name=>'APEXAPP.PAGE.TOP_USERS'
,p_message_text=>'Top Users'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113434247997212956)
,p_name=>'APEXAPP.PAGE.TOP_USERS.HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Use this report and chart to see the users with the most page views for the specified timeframe.</p>',
'<p>Select the reporting timeframe (Default = 1 day) and choose between the report and chart icons at the top of the page.</p>',
'<p>For the interactive report, use the search field, or select the <strong>User</strong> column heading, to select a specific user. You can perform numerous functions by clicking the <strong>Actions</strong> button, such as columns displayed / hidden'
||', rows per page, filter, and so forth. Click the <strong>Reset</strong> button to reset the interactive report back to the default settings.</p>'))
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113424649551212960)
,p_name=>'APEXAPP.PROCESS.ADD_USERS_TO_ACL'
,p_message_text=>'Add Users to Access Control List'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113424747498212959)
,p_name=>'APEXAPP.PROCESS.ADD_USERS_TO_ACL.SUCCESS'
,p_message_text=>'User(s) added.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113422943634212960)
,p_name=>'APEXAPP.PROCESS.CLEAR_PAGE'
,p_message_text=>'Clear Page(s) Cache'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113406553249212965)
,p_name=>'APEXAPP.PROCESS.CLOSE_DIALOG'
,p_message_text=>'Close Dialog'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113424550109212960)
,p_name=>'APEXAPP.PROCESS.CREATE_COLLECTIONS'
,p_message_text=>'Create Collections'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113406805968212965)
,p_name=>'APEXAPP.PROCESS.DELETE_FEEDBACK'
,p_message_text=>'Delete Feedback'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113406951930212965)
,p_name=>'APEXAPP.PROCESS.DELETE_FEEDBACK.SUCCESS'
,p_message_text=>'Feedback Deleted'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113424475565212960)
,p_name=>'APEXAPP.PROCESS.DML_FORM'
,p_message_text=>'Process form %0'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113425162533212959)
,p_name=>'APEXAPP.PROCESS.GET_FILE_ID'
,p_message_text=>'Get File ID'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113424143046212960)
,p_name=>'APEXAPP.PROCESS.GET_LOG_DETAIL'
,p_message_text=>'Get Log Detail'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113423433637212960)
,p_name=>'APEXAPP.PROCESS.GET_NEXT_PREV_PK'
,p_message_text=>'Get Next or Previous Primary Key Value'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113422896687212960)
,p_name=>'APEXAPP.PROCESS.GET_USERNAME_COOKIE'
,p_message_text=>'Get Username Cookie'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113422541511212960)
,p_name=>'APEXAPP.PROCESS.IG_DML'
,p_message_text=>'%0 - Save Interactive Grid Data'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113424390172212960)
,p_name=>'APEXAPP.PROCESS.INIT_FORM'
,p_message_text=>'Initialize form %0'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113423320159212960)
,p_name=>'APEXAPP.PROCESS.LEGACY_FORM_DML.SUCCESS'
,p_message_text=>'Action Processed.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113406674529212965)
,p_name=>'APEXAPP.PROCESS.LOAD_DATA'
,p_message_text=>'Load Data'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113423507698212960)
,p_name=>'APEXAPP.PROCESS.LOAD_DATA.ERROR'
,p_message_text=>'Data Loading Failed'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113406761429212965)
,p_name=>'APEXAPP.PROCESS.REPLY_TO_FEEDBACK'
,p_message_text=>'Reply to Feedback'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113406390795212965)
,p_name=>'APEXAPP.PROCESS.RESET_PAGINATION'
,p_message_text=>'Reset Pagination'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113422605125212960)
,p_name=>'APEXAPP.PROCESS.RESET_RPT_SEARCH'
,p_message_text=>'Reset report search'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113406453612212965)
,p_name=>'APEXAPP.PROCESS.SET_ACL'
,p_message_text=>'Set Access Control'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113424280346212960)
,p_name=>'APEXAPP.PROCESS.SET_ACL.HELP'
,p_message_text=>'Access Control settings saved.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113423928469212960)
,p_name=>'APEXAPP.PROCESS.SET_CONFIG_OPTIONS'
,p_message_text=>'Update'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113424090592212960)
,p_name=>'APEXAPP.PROCESS.SET_CONFIG_OPTIONS.SUCCESS'
,p_message_text=>'Configuration Options updated. '
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113425045780212959)
,p_name=>'APEXAPP.PROCESS.SET_FEEDBACK_OPTIONS'
,p_message_text=>'Save Setting'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113422788837212960)
,p_name=>'APEXAPP.PROCESS.SET_USERNAME_COOKIE'
,p_message_text=>'Set Username Cookie'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113424829963212959)
,p_name=>'APEXAPP.PROCESS.SUBMIT_FEEDBACK'
,p_message_text=>'Submit Feedback'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113424921857212959)
,p_name=>'APEXAPP.PROCESS.SUBMIT_FEEDBACK.SUCCESS'
,p_message_text=>'Feedback Submitted'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113423098037212960)
,p_name=>'APEXAPP.PROCESS.TABFORM_DELETE.SUCCESS'
,p_message_text=>'#MRD_COUNT# row(s) deleted.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113423197677212960)
,p_name=>'APEXAPP.PROCESS.TABFORM_PLSQL.SUCCESS'
,p_message_text=>'Update applied.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113423240661212960)
,p_name=>'APEXAPP.PROCESS.TABFORM_UPDATE_INSERT.SUCCESS'
,p_message_text=>'#MRU_COUNT# row(s) updated, #MRI_COUNT# row(s) inserted.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113423868864212960)
,p_name=>'APEXAPP.PROCESS.THEME_STYLE_PREF_SAVE'
,p_message_text=>'Save End User Style Preference'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113407026935212965)
,p_name=>'APEXAPP.PROCESS.THEME_STYLE_PREF_SAVE.SUCCESS'
,p_message_text=>'Application Appearance Settings Saved.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113423629174212960)
,p_name=>'APEXAPP.PROCESS.THEME_STYLE_SAVE'
,p_message_text=>'Save Theme Style'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113423759682212960)
,p_name=>'APEXAPP.PROCESS.THEME_STYLE_SAVE.SUCCESS'
,p_message_text=>'Application Appearance Settings Saved.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(11400624042249723)
,p_name=>'APEXAPP.PUSH_NOTIFICATIONS.CREDENTIALS_NAME'
,p_message_text=>'App %0 Push Notifications Credentials'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(27407527852609193)
,p_name=>'APEXAPP.PUSH_NOTIFICATIONS.DA.ENABLE_PUSH'
,p_message_text=>'Change %0'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(27406121249506284)
,p_name=>'APEXAPP.PUSH_NOTIFICATIONS.ITEM.ENABLE_PUSH'
,p_message_text=>'Enable push notifications on this device'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(27406778068506284)
,p_name=>'APEXAPP.PUSH_NOTIFICATIONS.LIST_ENTRY'
,p_message_text=>'Push Notifications'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1820761415876674)
,p_name=>'APEXAPP.PUSH_NOTIFICATIONS.LIST_ENTRY.DESC'
,p_message_text=>'Configure whether you want to receive push notifications on this device.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2601686553085957)
,p_name=>'APEXAPP.PUSH_NOTIFICATIONS.NOT_SUPPORTED.REGION'
,p_message_text=>'Push Notifications Not Supported'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2601879478088659)
,p_name=>'APEXAPP.PUSH_NOTIFICATIONS.NOT_SUPPORTED.REGION.BODY'
,p_message_text=>'Push notifications are not currently supported in your browser.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(27405358471506282)
,p_name=>'APEXAPP.PUSH_NOTIFICATIONS.PAGE'
,p_message_text=>'Push Notifications'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(27405562252506283)
,p_name=>'APEXAPP.PUSH_NOTIFICATIONS.PAGE.HELP'
,p_message_text=>'This page contains the settings for controlling push notification subscription for the current user.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(27405875618506283)
,p_name=>'APEXAPP.PUSH_NOTIFICATIONS.REGION'
,p_message_text=>'Push Notifications'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1828334658928076)
,p_name=>'APEXAPP.PUSH_NOTIFICATIONS.REGION.BODY'
,p_message_text=>'Push notifications have to be enabled for each device you want to receive the notifications on. The first time you enable push notifications, you will have to grant permission to your browser. This setting can be changed at any time.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(8000520712745470)
,p_name=>'APEXAPP.PUSH_NOTIFICATIONS.SUBSCRIBE'
,p_message_text=>'Subscribe to push notifications'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(8000719340747710)
,p_name=>'APEXAPP.PUSH_NOTIFICATIONS.UNSUBSCRIBE'
,p_message_text=>'Unsubscribe from push notifications'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113413316879212963)
,p_name=>'APEXAPP.REGION.ACCESS_CONTROL'
,p_message_text=>'Access Control'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113413226675212963)
,p_name=>'APEXAPP.REGION.ACCESS_CONTROL_ACTIONS'
,p_message_text=>'Access Control Actions'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113415092067212962)
,p_name=>'APEXAPP.REGION.ACCESS_CONTROL_CONFIG'
,p_message_text=>'Access Control Configuration'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113413456772212963)
,p_name=>'APEXAPP.REGION.ACCESS_CONTROL_INFO'
,p_message_text=>'ACL Information'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113413034463212963)
,p_name=>'APEXAPP.REGION.ACTIVITY_REPORTS'
,p_message_text=>'Activity Reports'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113404032948212966)
,p_name=>'APEXAPP.REGION.ADMIN'
,p_message_text=>'Application Administration'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113412844202212963)
,p_name=>'APEXAPP.REGION.APP_CONFIGURATION'
,p_message_text=>'Application Configuration'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113414845151212962)
,p_name=>'APEXAPP.REGION.AUTOMATION_EXECUTION'
,p_message_text=>'Automation Execution'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113403184214212967)
,p_name=>'APEXAPP.REGION.BREADCRUMB'
,p_message_text=>'Breadcrumb'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113411934715212963)
,p_name=>'APEXAPP.REGION.BUTTONS'
,p_message_text=>'Buttons'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113403967777212966)
,p_name=>'APEXAPP.REGION.COLUMN'
,p_message_text=>'Column %0'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113412739423212963)
,p_name=>'APEXAPP.REGION.CONFIGURATION'
,p_message_text=>'Configuration'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113413133018212963)
,p_name=>'APEXAPP.REGION.CONFIG_APPEARANCE'
,p_message_text=>'Configure Appearance'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113403449366212966)
,p_name=>'APEXAPP.REGION.DASHBOARD_CHART'
,p_message_text=>'Chart %0'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113412374977212963)
,p_name=>'APEXAPP.REGION.DATA_LOAD_FAILED_RECORDS'
,p_message_text=>'Failed Records'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113412452710212963)
,p_name=>'APEXAPP.REGION.DATA_LOAD_JUST_CHANGED_RECORDS'
,p_message_text=>'Records Changed by Another User.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113412232270212963)
,p_name=>'APEXAPP.REGION.DATA_LOAD_PROGRESS'
,p_message_text=>'Data Load Wizard Progress'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113403770336212966)
,p_name=>'APEXAPP.REGION.DEFAULT.MAX_ROWS'
,p_message_text=>'The maximum row count for this report is %0 rows.  Please apply a filter to reduce the number of records in your query.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113403677614212966)
,p_name=>'APEXAPP.REGION.DEFAULT.NO_DATA'
,p_message_text=>'No data found.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113413851964212963)
,p_name=>'APEXAPP.REGION.EMAIL_REPORTING'
,p_message_text=>'Email Reporting'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113415246159212962)
,p_name=>'APEXAPP.REGION.EXCEPTIONS'
,p_message_text=>'Exceptions'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113413549369212963)
,p_name=>'APEXAPP.REGION.FEEDBACK'
,p_message_text=>'Feedback'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113404331607212966)
,p_name=>'APEXAPP.REGION.FEEDBACK_SUBMITTED'
,p_message_text=>'Feedback Submitted'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113414514723212963)
,p_name=>'APEXAPP.REGION.FILTERS'
,p_message_text=>'Filters'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113415772641212962)
,p_name=>'APEXAPP.REGION.FORM_ITEMS'
,p_message_text=>'Form Items Region'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113403586638212966)
,p_name=>'APEXAPP.REGION.FORM_ON'
,p_message_text=>'Form on %0'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113415609571212962)
,p_name=>'APEXAPP.REGION.HIDDEN_ITEMS'
,p_message_text=>'Hidden Items'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113414065134212963)
,p_name=>'APEXAPP.REGION.HOURLY_PAGE_EVENTS'
,p_message_text=>'Hourly Page Events'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113412167781212963)
,p_name=>'APEXAPP.REGION.INFORMATION'
,p_message_text=>'Information'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113413982678212963)
,p_name=>'APEXAPP.REGION.JOB_REPORTING'
,p_message_text=>'Job Reporting'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113413629753212963)
,p_name=>'APEXAPP.REGION.LANGUAGE_SELECTOR'
,p_message_text=>'Language Selector'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113414390978212963)
,p_name=>'APEXAPP.REGION.LATEST_ACTIVITY'
,p_message_text=>'Latest Activity'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113414407608212963)
,p_name=>'APEXAPP.REGION.LATEST_ACTIVITY.NO_DATA'
,p_message_text=>'No activities found'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113412506513212963)
,p_name=>'APEXAPP.REGION.MASTER_RECORDS'
,p_message_text=>'Master Records'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113414937531212962)
,p_name=>'APEXAPP.REGION.MESSAGES'
,p_message_text=>'Messages'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113414184713212963)
,p_name=>'APEXAPP.REGION.MOST_ACTIVE_PAGES'
,p_message_text=>'Most Active Pages'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113403887706212966)
,p_name=>'APEXAPP.REGION.NAVIGATION'
,p_message_text=>'Page Navigation'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113403369901212966)
,p_name=>'APEXAPP.REGION.NO_RECORD_SELECTED'
,p_message_text=>'No Record Selected'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113412677692212963)
,p_name=>'APEXAPP.REGION.NO_RECORD_SELECTED.NO_DATA'
,p_message_text=>'No Record Selected'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113415405165212962)
,p_name=>'APEXAPP.REGION.NO_VALID_USERS_EXIST'
,p_message_text=>'No Valid Users Exist - Page Info'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113415520519212962)
,p_name=>'APEXAPP.REGION.NO_VALID_USERS_EXIST.SOURCE'
,p_message_text=>'No valid new users found'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113414212614212963)
,p_name=>'APEXAPP.REGION.RECENT_ERRORS'
,p_message_text=>'Recent Errors'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113403228094212966)
,p_name=>'APEXAPP.REGION.REGION_DISPLAY_SELECTOR'
,p_message_text=>'Region Display Selector'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113404109187212966)
,p_name=>'APEXAPP.REGION.REPORT'
,p_message_text=>'Report'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113403034595212967)
,p_name=>'APEXAPP.REGION.SEARCH'
,p_message_text=>'Search'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1857991881663264)
,p_name=>'APEXAPP.REGION.SEARCH_NO_QUERY_ENTERED'
,p_message_text=>'Please enter your search term.'
,p_version_scn=>62128914
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1858103498664347)
,p_name=>'APEXAPP.REGION.SEARCH_NO_RESULTS_FOUND'
,p_message_text=>'No results for your search term.'
,p_version_scn=>62129106
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113414655699212963)
,p_name=>'APEXAPP.REGION.TOP_USERS'
,p_message_text=>'Top Users'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113414766351212963)
,p_name=>'APEXAPP.REGION.TOP_USERS_CHART'
,p_message_text=>'Top Users Chart'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113404216896212966)
,p_name=>'APEXAPP.REGION.USERS_TO_ADD'
,p_message_text=>'%0 Users to Add'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113413714564212963)
,p_name=>'APEXAPP.REGION.USER_COUNTS_REPORT'
,p_message_text=>'User Counts Report'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113412984394212963)
,p_name=>'APEXAPP.REGION.USER_INTERFACE'
,p_message_text=>'User Interface'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113415300955212962)
,p_name=>'APEXAPP.REGION.VALID_USERS_EXIST'
,p_message_text=>'Valid Users Exist - Page Info'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113415103529212962)
,p_name=>'APEXAPP.REGION.WIZARD_CONTAINER'
,p_message_text=>'Wizard Container'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113412023489212963)
,p_name=>'APEXAPP.REGION.WIZARD_PROGRESS'
,p_message_text=>'Wizard Progress'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113432424888212957)
,p_name=>'APEXAPP.RELEASE'
,p_message_text=>'Release %0'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113429993673212958)
,p_name=>'APEXAPP.SHORTCUT.GET_NEXT_PREV_PK'
,p_message_text=>'Are you sure you want to leave this page without saving?'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113410586118212964)
,p_name=>'APEXAPP.SUCCESS_MSG.ROWS_UPDATED'
,p_message_text=>'%0 row(s) updated.'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(7204613406880255)
,p_name=>'APEXAPP.TASK.DETAILS_PAGE_DEVELOPER_INFORMATION'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>This page shows detailed information for the human task whose ID is passed',
'in to the <strong>Pnn_TASK_ID</strong> page item and is used as boilerplate for you to',
'start building your Task Detail page that your user will use to perform the',
'task. APEX has generated this page for you containing all of the task',
'services available for Human Tasks. These includes services like:</p>',
'',
'<ul>',
'    <li>task claiming, release and delegation</li>',
'    <li>task due dates, expiration, renewal</li>',
'    <li>requesting and providing more information from the originator</li>',
'    <li>task commenting</li>',
'    <li>task history</li>',
'    <li>saving task progress and submitting a complete task</li>',
'</ul>',
'',
'<p>You can delete this region and any task service regions or buttons that',
'are not required for your application. Then add one or more regions that',
'implement the task that the user needs to perform as part of your',
'application. You can do this by adding forms, reports, cards or other APEX',
'region types inside this page - just like you would on a normal page.</p>',
'',
'<p>You will need to make sure that the Page Processing includes processes to',
'update your data into the database. These should be executed on the',
'<strong>Save</strong> and <strong>Complete</strong> buttons. The',
'<strong>Automatic Row Processing</strong> process should occur',
'<strong>before Human Task - Manage</strong> process executes.</p>'))
,p_version_scn=>15475661
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(9490722419867672)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.ALERT.PROVIDE_COMMENT'
,p_message_text=>'Please provide a comment'
,p_version_scn=>288639872
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3279272633809033)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.ALERT.PROVIDE_MESSAGE'
,p_message_text=>'Please provide a message'
,p_version_scn=>289826187
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4202239021858536)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.ALERT.PROVIDE_NEW_PARAM_VALUE'
,p_message_text=>'Please provide a new parameter value'
,p_version_scn=>37165770887536
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3511475674170501)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.ALERT.PROVIDE_POTENTIAL_OWNER'
,p_message_text=>'Please provide a potential owner'
,p_version_scn=>336478278
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3513219500771817)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.BRANCH.RELOAD_DIALOG'
,p_message_text=>'Reload Dialog'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1628859363744696)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.CONFIRM.CANCEL_TASK'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Do you really want to cancel this task?</p>',
'<p>This will mark the task as no longer needed.</p>'))
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3925412523258761)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.ENTITY_TITLE.PLURAL'
,p_message_text=>'tasks'
,p_version_scn=>477529161
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3925273135257365)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.ENTITY_TITLE.SINGULAR'
,p_message_text=>'task'
,p_version_scn=>477529101
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(9489585068810654)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.ACTIONS'
,p_message_text=>'Actions'
,p_version_scn=>288632739
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1981189064778542)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.ADD_COMMENT'
,p_message_text=>'Add Comment'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2367949396504124)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.APPLICATION'
,p_message_text=>'Application'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1981300446780994)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.APPROVE'
,p_message_text=>'Approve'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1629136458748384)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.CANCEL_TASK'
,p_message_text=>'Cancel Task'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(10412716947646910)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.CATEGORY'
,p_message_text=>'Category'
,p_version_scn=>15475662
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3500203026176064)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.CHANGE_DUE_DATE'
,p_message_text=>'Change Due Date'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1891432895653575)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.CHANGE_PRIORITY'
,p_message_text=>'Change Priority'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1891749966656741)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.CLAIM'
,p_message_text=>'Claim'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1981577999785130)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.CLAIM_TASK'
,p_message_text=>'Claim Task'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(9782128361173588)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.CLOSE_ADD_COMMENT_DIALOG'
,p_message_text=>'Close Add Comment Dialog'
,p_version_scn=>288737823
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5000649139032407)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.CLOSE_CANCEL_TASK_DIALOG'
,p_message_text=>'Close Cancel Task Dialog'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3500491786181014)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.CLOSE_CHANGE_DUE_DATE_DIALOG'
,p_message_text=>'Close Change Due Date Dialog'
,p_version_scn=>288742520
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1891295010650402)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.CLOSE_CHANGE_PRIORITY_DIALOG'
,p_message_text=>'Close Change Priority Dialog'
,p_version_scn=>288742824
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(311444607064787965)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.CLOSE_DELEGATE_DIALOG'
,p_message_text=>'Close Delegate Dialog'
,p_version_scn=>288742908
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(9489953014820192)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.CLOSE_EDIT_PARAMETER_DIALOG'
,p_message_text=>'Close Edit Parameter Dialog'
,p_version_scn=>288738053
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3511214555130416)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.CLOSE_INVITE_PARTICIPANT_DIALOG'
,p_message_text=>'Close Invite Participant Dialog'
,p_version_scn=>288741453
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(9781959643138277)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.CLOSE_REMOVE_PARTICIPANT_DIALOG'
,p_message_text=>'Close Remove Participant Dialog'
,p_version_scn=>288738258
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3001914441616996)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.CLOSE_REQUEST_INFORMATION_DIALOG'
,p_message_text=>'Close Request Information Dialog'
,p_version_scn=>288742108
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3002126852619688)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.CLOSE_SUBMIT_INFORMATION_DIALOG'
,p_message_text=>'Close Submit Information Dialog'
,p_version_scn=>288741627
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1982382248796006)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.COMMENT'
,p_message_text=>'Comment'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(6400831322557139)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.COMMENTS_EXPIRED_TASKS'
,p_message_text=>'Include comments from expired tasks'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(7400309168161312)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.COMPLETE'
,p_message_text=>'Complete'
,p_version_scn=>15475662
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1986707412841191)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.CREATED'
,p_message_text=>'Created'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(9489770012815833)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.CURRENT_VALUE'
,p_message_text=>'Current Value'
,p_version_scn=>288632864
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1981736427789928)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.DELEGATE'
,p_message_text=>'Delegate'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(411787055578245571)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.DEVELOPER_INFORMATION'
,p_message_text=>'Developer Information'
,p_version_scn=>37166022046028
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(9490197222829281)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.DISABLE_ENABLE_UPDATE_BUTTON'
,p_message_text=>'Disable/Enable Update Button'
,p_version_scn=>288633577
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(267547169316719121)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.DUE'
,p_message_text=>'Due'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4200941334639378)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.EDIT_PARAMETER'
,p_message_text=>'Edit Parameter'
,p_version_scn=>288638957
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(311444565510787965)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.EVENT'
,p_message_text=>'Event'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1903063851416422)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.FORWARD'
,p_message_text=>'Forward'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(6400590580543353)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.HISTORY_EXPIRED_TASKS'
,p_message_text=>'Include history from expired tasks'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(267547834178740091)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.INITIATED'
,p_message_text=>'Initiated'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1905431875803582)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.INITIATOR'
,p_message_text=>'Initiator'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3505458898666495)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.INVITE_PARTICIPANT'
,p_message_text=>'Invite Participant'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1904103283617492)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.MATURITY'
,p_message_text=>'Maturity'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1986969768842559)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.MESSAGE'
,p_message_text=>'Message'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3500860301206760)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.NEW_DUE_DATE'
,p_message_text=>'New Due Date'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1982548139798470)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.NEW_OWNER'
,p_message_text=>'New Owner'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3505637234764350)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.NEW_POTENTIAL_OWNER'
,p_message_text=>'New Potential Owner'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1890851040644537)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.NEW_PRIORITY'
,p_message_text=>'New Priority'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4201764039795373)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.NEW_VALUE'
,p_message_text=>'New Value'
,p_version_scn=>37165770887536
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3226363515640827)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.NO_COMMENTS'
,p_message_text=>'No Comments'
,p_version_scn=>299281456
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(292640930691582485)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.NO_TASKS'
,p_message_text=>'No Tasks'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5000488271027900)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.OPEN_CANCEL_TASK_DIALOG'
,p_message_text=>'Open Cancel Task Dialog'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(305910060206854961)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.OUTCOME'
,p_message_text=>'Outcome'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(292640608567582485)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.OWNER'
,p_message_text=>'Owner'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4201359648772393)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.PARAMETER'
,p_message_text=>'Parameter'
,p_version_scn=>37165770887536
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3201310945173102)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.POTENTIAL_OWNER'
,p_message_text=>'Potential Owner'
,p_version_scn=>37165770887536
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4200667284048265)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.PRIORITY'
,p_message_text=>'Priority'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1981945852791597)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.REJECT'
,p_message_text=>'Reject'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1982131927794390)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.RELEASE'
,p_message_text=>'Release'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2200293650310453)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.REMOVE_PARTICIPANT'
,p_message_text=>'Remove Participant'
,p_version_scn=>37165770887536
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5200236826206240)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.RENEW_TASK'
,p_message_text=>'Renew Task'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3001517507605187)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.REQUEST_INFORMATION'
,p_message_text=>'Request Information'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(7400518149162678)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.SAVE'
,p_message_text=>'Save'
,p_version_scn=>16749560
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1906395123854468)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.SEARCH'
,p_message_text=>'Search'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2409462116945101)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.SHOW_EXPIRED_TASKS'
,p_message_text=>'Show expired tasks'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(9065221830379614)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.SHOW_HIDE_BUTTONS'
,p_message_text=>'Show/Hide Buttons'
,p_version_scn=>295844975
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1908963761082145)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.SHOW_SUCCESS_MESSAGE'
,p_message_text=>'Show Success Message'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(292640798465582485)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.SORT_BY'
,p_message_text=>'Sort by'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1905707086830021)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.STATE'
,p_message_text=>'State'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(292640821642582485)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.SUBJECT'
,p_message_text=>'Subject'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3001709204610084)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.SUBMIT_INFORMATION'
,p_message_text=>'Submit Information'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(311444446596787963)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.TIME'
,p_message_text=>'Time '
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1987157499843766)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.TYPE'
,p_message_text=>'Type'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4202584259028358)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.UPDATE_PARAMETER'
,p_message_text=>'Update Parameter'
,p_version_scn=>37165770887536
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1987339495845158)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LABEL.USER'
,p_message_text=>'User'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1982790485800364)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LOV.CREATED_HOURS.LAST_24_HOURS'
,p_message_text=>'Last 24 hours'
,p_version_scn=>37165770887497
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1982906298801836)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LOV.CREATED_HOURS.LAST_30_DAYS'
,p_message_text=>'Last 30 days'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1983179394803596)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LOV.CREATED_HOURS.LAST_7_DAYS'
,p_message_text=>'Last 7 days'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1983349978805109)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LOV.CREATED_HOURS.LAST_HOUR'
,p_message_text=>'Last hour'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1983576113807578)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LOV.CREATED_HOURS.OLDER_THAN_30_DAYS'
,p_message_text=>'Older than 30 days'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1983723981808848)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LOV.DUE_HOURS.MORE_THAN_30_DAYS'
,p_message_text=>'More than 30 days'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1983924651810229)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LOV.DUE_HOURS.NEXT_24_HOURS'
,p_message_text=>'Next 24 hours'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1984128132812015)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LOV.DUE_HOURS.NEXT_30_DAYS'
,p_message_text=>'Next 30 days'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1984374381813404)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LOV.DUE_HOURS.NEXT_7_DAYS'
,p_message_text=>'Next 7 days'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1984545708814906)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LOV.DUE_HOURS.NEXT_HOUR'
,p_message_text=>'Next hour'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1984720901816495)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LOV.DUE_HOURS.OVERDUE'
,p_message_text=>'Overdue'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1904434351688450)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LOV.DUE_HOURS.WITHOUT_DUE_DATE'
,p_message_text=>'No due date'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1984990420821229)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LOV.META.CREATED'
,p_message_text=>'Created %0'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1985181855822922)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.LOV.META.INITIATED_BY'
,p_message_text=>'Initiated by %0'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1985350129825143)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.PAGE.TASK_DETAILS'
,p_message_text=>'Task Details'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1985521016831213)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.PAGE.UNIFIED_TASK_LIST'
,p_message_text=>'Unified Task List'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(9926388406459816)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.PROCESS.ADD_COMMENT.SUCCESS_MESSAGE'
,p_message_text=>'Comment added'
,p_version_scn=>288768880
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1889071057018823)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.PROCESS.APPROVE.SUCCESS_MESSAGE'
,p_message_text=>'Task approved'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1629302081750732)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.PROCESS.CANCEL_TASK.SUCCESS_MESSAGE'
,p_message_text=>'Task canceled'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1889923978048478)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.PROCESS.CLAIM.SUCCESS_MESSAGE'
,p_message_text=>'Task claimed'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(7401254142291345)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.PROCESS.COMPLETE.SUCCESS_MESSAGE'
,p_message_text=>'Task completed'
,p_version_scn=>15475662
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1889711087044021)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.PROCESS.DELEGATE.SUCCESS_MESSAGE'
,p_message_text=>'Task delegated to %0'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1903544500492459)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.PROCESS.FETCH_TASK_DATA'
,p_message_text=>'Fetch Task Data'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3512622989700974)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.PROCESS.INVITE_PARTICIPANT.SUCCESS_MESSAGE'
,p_message_text=>'Participant %0 added to task as potential owner'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1889471935032217)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.PROCESS.REJECT.SUCCESS_MESSAGE'
,p_message_text=>'Task rejected'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1890171777055128)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.PROCESS.RELEASE.SUCCESS_MESSAGE'
,p_message_text=>'Task released - can now be claimed by others'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3201657204286893)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.PROCESS.REMOVE_PARTICIPANT.SUCCESS_MESSAGE'
,p_message_text=>'Participant %0 removed from task.'
,p_version_scn=>37165770887564
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4801722663690298)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.PROCESS.RENEW_TASK.SUCCESS_MESSAGE'
,p_message_text=>'Task renewed'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3002577351630336)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.PROCESS.REQUEST_INFORMATION.SUCCESS_MESSAGE'
,p_message_text=>'Information requested'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3500680163194093)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.PROCESS.SET_DUE_DATE.SUCCESS_MESSAGE'
,p_message_text=>'Task due date updated'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1891018403647255)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.PROCESS.SET_PRIORITY.SUCCESS_MESSAGE'
,p_message_text=>'Task priority changed'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1892291891750987)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.PROCESS.SET_SUCCESS_MESSAGE'
,p_message_text=>'Set Success Message'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3002376478628088)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.PROCESS.SUBMIT_INFORMATION.SUCCESS_MESSAGE'
,p_message_text=>'Information submitted'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4202872384035747)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.PROCESS.UPDATE_PARAMETER.SUCCESS_MESSAGE'
,p_message_text=>'Parameter updated'
,p_version_scn=>37165770887564
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(232314808214833098)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.REFRESH_REPORT'
,p_message_text=>'Refresh - %0'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1985785969833120)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.REGION.COMMENTS'
,p_message_text=>'Comments'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1985944806834892)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.REGION.DETAILS'
,p_message_text=>'Details'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1986313195837932)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.REGION.EDIT_TASK'
,p_message_text=>'Edit Task'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1986185759836431)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.REGION.HISTORY'
,p_message_text=>'History'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1986508361839247)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.REGION.OVERVIEW'
,p_message_text=>'Overview'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(292641066670582485)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.SORT_ORDER.CREATE_DATE'
,p_message_text=>'Create Date'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(292641169830582486)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.SORT_ORDER.DUE_DATE'
,p_message_text=>'Due Date'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1987500051846951)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.TAB.ADMIN_TASKS'
,p_message_text=>'Admin Tasks'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(232314567796797461)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.TAB.ADMIN_TASKS_REGION_NAME'
,p_message_text=>'Admin Tasks - %0'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1987718975848869)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.TAB.INITIATED_BY_ME'
,p_message_text=>'Initiated by Me'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(232314357296792572)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.TAB.INITIATED_BY_ME_REGION_NAME'
,p_message_text=>'Initiated by Me - %0'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1987942138850622)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.TAB.MY_TASKS'
,p_message_text=>'My Tasks'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(232313849871743269)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.TAB.MY_TASKS_REGION_NAME'
,p_message_text=>'My Tasks - %0'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1988111610852754)
,p_name=>'APEXAPP.UNIFIED_TASK_LIST.TAB.TASK_LISTS'
,p_message_text=>'Task Lists'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(27404984473480974)
,p_name=>'APEXAPP.USER_SETTINGS.LIST'
,p_message_text=>'User Settings'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(27407142236564058)
,p_name=>'APEXAPP.USER_SETTINGS.LIST_ENTRY'
,p_message_text=>'Settings'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(27404021901480973)
,p_name=>'APEXAPP.USER_SETTINGS.PAGE'
,p_message_text=>'Settings'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(27404335227480973)
,p_name=>'APEXAPP.USER_SETTINGS.PAGE.HELP'
,p_message_text=>'This page contains a list of settings applicable to the current application user.'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(27403867154480973)
,p_name=>'APEXAPP.USER_SETTINGS.PAGE_GROUP'
,p_message_text=>'User Settings'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(27404648393480974)
,p_name=>'APEXAPP.USER_SETTINGS.REGION'
,p_message_text=>'Settings'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113411754308212963)
,p_name=>'APEXAPP.VALIDATION.AT_LEAST_ONE_REQUIRED'
,p_message_text=>'At least One Feedback Required'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113411821112212963)
,p_name=>'APEXAPP.VALIDATION.AT_LEAST_ONE_REQUIRED.ERROR'
,p_message_text=>'Please provide feedback or your experience.'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113411501684212963)
,p_name=>'APEXAPP.VALIDATION.CANNOT_REMOVE_YOURSELF_FROM_ADMIN'
,p_message_text=>'Cannot remove yourself from administrator'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113411629599212963)
,p_name=>'APEXAPP.VALIDATION.CANNOT_REMOVE_YOURSELF_FROM_ADMIN.ERROR'
,p_message_text=>'You cannot remove administrator role from yourself.'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113411082649212964)
,p_name=>'APEXAPP.VALIDATION.COLUMN.DATE.ERROR'
,p_message_text=>'#COLUMN_HEADER# must be a valid date.'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113410870015212964)
,p_name=>'APEXAPP.VALIDATION.COLUMN.NOT_NULL.ERROR'
,p_message_text=>'#COLUMN_HEADER# must have a value.'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113410935786212964)
,p_name=>'APEXAPP.VALIDATION.COLUMN.NUMERIC.ERROR'
,p_message_text=>'#COLUMN_HEADER# must be numeric.'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113411168626212964)
,p_name=>'APEXAPP.VALIDATION.COLUMN.TIMESTAMP.ERROR'
,p_message_text=>'#COLUMN_HEADER# must be a valid timestamp value.'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113409135361212964)
,p_name=>'APEXAPP.VALIDATION.DATE'
,p_message_text=>'%0 must be a valid date'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113411394170212964)
,p_name=>'APEXAPP.VALIDATION.ITEM.DATE.ERROR'
,p_message_text=>'#LABEL# must be a valid date.'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113411295228212964)
,p_name=>'APEXAPP.VALIDATION.ITEM.NOT_NULL.ERROR'
,p_message_text=>'#LABEL# must have some value.'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113411471886212964)
,p_name=>'APEXAPP.VALIDATION.ITEM.TIMESTAMP.ERROR'
,p_message_text=>'#LABEL# must be a valid timestamp.'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113408936971212964)
,p_name=>'APEXAPP.VALIDATION.NOT_NULL'
,p_message_text=>'%0 not null'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113409005657212964)
,p_name=>'APEXAPP.VALIDATION.NUMERIC'
,p_message_text=>'%0 must be numeric'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113409237711212964)
,p_name=>'APEXAPP.VALIDATION.TIMESTAMP'
,p_message_text=>'%0 must be a valid timestamp'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2806737954788203)
,p_name=>'APEXAPP.WORKFLOW_CHARTS.ACTIVITIES'
,p_message_text=>'Activities'
,p_version_scn=>16569763
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2806952591791846)
,p_name=>'APEXAPP.WORKFLOW_CHARTS.ACTIVITIES.NOT_FOUND'
,p_message_text=>'Please select a Workflow in the Overview region to see further details'
,p_version_scn=>16569774
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2805137566739864)
,p_name=>'APEXAPP.WORKFLOW_CHARTS.AVG_COMPLETION_TIME'
,p_message_text=>'Average Completion Time'
,p_version_scn=>16569785
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2803135211662929)
,p_name=>'APEXAPP.WORKFLOW_CHARTS.DETAILS'
,p_message_text=>'Details'
,p_version_scn=>16569796
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2803917880688012)
,p_name=>'APEXAPP.WORKFLOW_CHARTS.INSTANCES'
,p_message_text=>'Instances'
,p_version_scn=>16569806
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2802745255654791)
,p_name=>'APEXAPP.WORKFLOW_CHARTS.OVERVIEW'
,p_message_text=>'Overview'
,p_version_scn=>16569817
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2802954377660573)
,p_name=>'APEXAPP.WORKFLOW_CHARTS.OVERVIEW.SERIES'
,p_message_text=>'Overview Series'
,p_version_scn=>16569827
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2804395452713426)
,p_name=>'APEXAPP.WORKFLOW_CHARTS.PERFORMANCE'
,p_message_text=>'Performance'
,p_version_scn=>16569837
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2807191455798862)
,p_name=>'APEXAPP.WORKFLOW_CHARTS.REFRESH.ACTIVITIES'
,p_message_text=>'Refresh Activities'
,p_version_scn=>16569847
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2805343788748799)
,p_name=>'APEXAPP.WORKFLOW_CHARTS.REFRESH.PERFORMANCE'
,p_message_text=>'Refresh Performance Chart'
,p_version_scn=>16569881
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2804131065698468)
,p_name=>'APEXAPP.WORKFLOW_CHARTS.REFRESH.WORKFLOW.INSTANCES'
,p_message_text=>'Refresh Workflow Per State Details Region'
,p_version_scn=>16569891
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2802491191646987)
,p_name=>'APEXAPP.WORKFLOW_CHARTS.STATE.REGION'
,p_message_text=>'Workflows By State'
,p_version_scn=>16569910
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2804560910716733)
,p_name=>'APEXAPP.WORKFLOW_CHARTS.TIME_UNIT'
,p_message_text=>'Time Unit'
,p_version_scn=>16569930
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3600892899879139)
,p_name=>'APEXAPP.WORKFLOW_CHARTS.TIME_UNIT.DAYS'
,p_message_text=>'Days'
,p_version_scn=>16728375
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2804727883722296)
,p_name=>'APEXAPP.WORKFLOW_CHARTS.TIME_UNIT.HELP_TEXT'
,p_message_text=>'Select the time unit to display within the Performance chart.'
,p_version_scn=>16569940
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3601056982881447)
,p_name=>'APEXAPP.WORKFLOW_CHARTS.TIME_UNIT.HOURS'
,p_message_text=>'Hours'
,p_version_scn=>16728413
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3600460923876224)
,p_name=>'APEXAPP.WORKFLOW_CHARTS.TIME_UNIT.MINS'
,p_message_text=>'Minutes'
,p_version_scn=>16728345
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3600686130878160)
,p_name=>'APEXAPP.WORKFLOW_CHARTS.TIME_UNIT.SEC'
,p_message_text=>'Seconds'
,p_version_scn=>16728362
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2803789250686008)
,p_name=>'APEXAPP.WORKFLOW_CHARTS.WORKFLOWS'
,p_message_text=>'Workflows'
,p_version_scn=>16569964
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2806187779771245)
,p_name=>'APEXAPP.WORKFLOW_CHARTS.WORKFLOWS.ACTIVE.NOT_FOUND'
,p_message_text=>'No Active Workflows found'
,p_version_scn=>16569975
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2804988203735908)
,p_name=>'APEXAPP.WORKFLOW_CHARTS.WORKFLOWS.COMPLETED.NOT_FOUND'
,p_message_text=>'No Completed or Terminated Workflows found'
,p_version_scn=>16569985
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2806327954774036)
,p_name=>'APEXAPP.WORKFLOW_CHARTS.WORKFLOWS.FAULTED.NOT_FOUND'
,p_message_text=>'No Faulted Workflows found'
,p_version_scn=>16569995
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2803379630667811)
,p_name=>'APEXAPP.WORKFLOW_CHARTS.WORKFLOWS.NOT_FOUND'
,p_message_text=>'Please select a workflow state in the Overview chart to see further details'
,p_version_scn=>16570010
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2803550971681614)
,p_name=>'APEXAPP.WORKFLOW_CHARTS.WORKFLOWS.STATE'
,p_message_text=>'Instances Per Workflow'
,p_version_scn=>16569715
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2806567782779243)
,p_name=>'APEXAPP.WORKFLOW_CHARTS.WORKLOAD'
,p_message_text=>'Workflows'
,p_version_scn=>16570019
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2805734433762117)
,p_name=>'APEXAPP.WORKFLOW_CHARTS.WORKLOAD.ACTIVE'
,p_message_text=>'Active Workflows'
,p_version_scn=>16570055
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2805904776765214)
,p_name=>'APEXAPP.WORKFLOW_CHARTS.WORKLOAD.FAULTED'
,p_message_text=>'Faulted Workflows'
,p_version_scn=>16570071
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2392233044251154)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.BUTTON.PARENT_WORKFLOW'
,p_message_text=>'To Parent Workflow'
,p_version_scn=>2149465429
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2801935810630110)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.CONTEXT.ADMIN_WORKFLOWS'
,p_message_text=>'Admin Workflows'
,p_version_scn=>38788293
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2801537499627741)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.CONTEXT.ADMIN_WORKFLOWS_REGION_NAME'
,p_message_text=>'Admin Workflows - %0'
,p_version_scn=>38788293
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2803575589727860)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.CONTEXT.INITIATED_BY_ME'
,p_message_text=>'Initiated by Me'
,p_version_scn=>38788293
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2803326010726356)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.CONTEXT.INITIATED_BY_ME_REGION_NAME'
,p_message_text=>'Initiated by Me - %0'
,p_version_scn=>38788293
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2802908198690464)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.CONTEXT.MY_WORKFLOWS'
,p_message_text=>'My Workflows'
,p_version_scn=>38788293
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2802708471688813)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.CONTEXT.MY_WORKFLOWS_REGION_NAME'
,p_message_text=>'My Workflows - %0'
,p_version_scn=>38788293
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3924862610242665)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.ENTITY_TITLE.PLURAL'
,p_message_text=>'workflows'
,p_version_scn=>477512069
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3924623447240809)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.ENTITY_TITLE.SINGULAR'
,p_message_text=>'workflow'
,p_version_scn=>477511956
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3600523313648827)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.LABEL.ACTIVITIES'
,p_message_text=>'Activities'
,p_version_scn=>38788293
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4400865539466560)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.LABEL.ACTIVITY_AUDIT'
,p_message_text=>'Activity Audit'
,p_version_scn=>38788293
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3200869218014433)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.LABEL.APPLICATION'
,p_message_text=>'Application'
,p_version_scn=>38788293
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4800272533485456)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.LABEL.CANCEL_ACTIVITY_AUDIT'
,p_message_text=>'Cancel Activity Audit'
,p_version_scn=>38949913
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4601452028056396)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.LABEL.CANCEL_DIALOG'
,p_message_text=>'Cancel Dialog'
,p_version_scn=>38788293
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4402715488548203)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.LABEL.CANCEL_EDIT_VARIABLE'
,p_message_text=>'Cancel Edit Variable'
,p_version_scn=>38788293
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(10267615031709866)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.LABEL.CURRENT_VALUE'
,p_message_text=>'Current Value'
,p_version_scn=>288794146
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4800410522487829)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.LABEL.DISABLE_ENABLE_UPDATE_BUTTON'
,p_message_text=>'Disable/Enable Update Button'
,p_version_scn=>39427470
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4401233637481340)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.LABEL.EDIT_VARIABLE'
,p_message_text=>'Edit Variable'
,p_version_scn=>38788293
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4401885983499155)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.LABEL.HISTORY'
,p_message_text=>'History'
,p_version_scn=>38788293
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3201222032030845)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.LABEL.INITIATED'
,p_message_text=>'Initiated'
,p_version_scn=>38788293
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3201012280022005)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.LABEL.INITIATOR'
,p_message_text=>'Initiator'
,p_version_scn=>38788293
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4401484600486189)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.LABEL.NEW_VALUE'
,p_message_text=>'New Value'
,p_version_scn=>38788293
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3201443703038979)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.LABEL.NO_WORKFLOWS'
,p_message_text=>'No Workflows'
,p_version_scn=>38788293
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4401620625493556)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.LABEL.PARAMETERS'
,p_message_text=>'Parameters'
,p_version_scn=>38788293
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3201863209068385)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.LABEL.RESUME'
,p_message_text=>'Resume'
,p_version_scn=>38788293
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4402282281513365)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.LABEL.RETRY'
,p_message_text=>'Retry'
,p_version_scn=>38788293
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3000292601966959)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.LABEL.SEARCH'
,p_message_text=>'Search'
,p_version_scn=>38788293
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3400684186420703)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.LABEL.SHOW_SUCCESS_MESSAGE'
,p_message_text=>'Show Success Message'
,p_version_scn=>38788293
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3202285360085800)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.LABEL.SORT_BY'
,p_message_text=>'Sort By'
,p_version_scn=>38788293
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3000889262986148)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.LABEL.STATE'
,p_message_text=>'State'
,p_version_scn=>38788293
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3401661172571949)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.LABEL.STATUS'
,p_message_text=>'Status'
,p_version_scn=>38788293
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3401437010552294)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.LABEL.SUBJECT'
,p_message_text=>'Subject'
,p_version_scn=>38788293
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4402078452504776)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.LABEL.SUSPEND'
,p_message_text=>'Suspend'
,p_version_scn=>38788293
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3202082015075313)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.LABEL.TERMINATE'
,p_message_text=>'Terminate'
,p_version_scn=>38788293
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3000668901976761)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.LABEL.TYPE'
,p_message_text=>'Type'
,p_version_scn=>38788293
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4601634154069582)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.LABEL.UPDATE_VARIABLE'
,p_message_text=>'Update Variable'
,p_version_scn=>38788293
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4401013780469774)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.LABEL.VARIABLE'
,p_message_text=>'Variable'
,p_version_scn=>38788293
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4849780254887925)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.LABEL.VARIABLES'
,p_message_text=>'Variables'
,p_version_scn=>38788293
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2599759572565449)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.LABEL.WORKFLOW_DIAGRAM'
,p_message_text=>'Workflow Diagram'
,p_version_scn=>120639943
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4746203053824892)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.LOV.CREATED_HOURS.LAST_24_HOURS'
,p_message_text=>'Last 24 hours'
,p_version_scn=>38788293
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4746619294829138)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.LOV.CREATED_HOURS.LAST_30_DAYS'
,p_message_text=>'Last 30 days'
,p_version_scn=>38788293
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4746417810827109)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.LOV.CREATED_HOURS.LAST_7_DAYS'
,p_message_text=>'Last 7 days'
,p_version_scn=>38788293
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4746013897819423)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.LOV.CREATED_HOURS.LAST_HOUR'
,p_message_text=>'Last hour'
,p_version_scn=>38788293
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4747027770845041)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.LOV.CREATED_HOURS.OLDER_THAN_30_DAYS'
,p_message_text=>'Older than 30 days'
,p_version_scn=>38788293
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3201641702059778)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.PAGE.WORKFLOW_DETAILS'
,p_message_text=>'Workflow Details'
,p_version_scn=>38788293
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3400809349475282)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.PROCESS.RESUME.SUCCESS_MESSAGE'
,p_message_text=>'Workflow resumed'
,p_version_scn=>38788294
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4602266761186467)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.PROCESS.RETRY.SUCCESS_MESSAGE'
,p_message_text=>'Workflow retried'
,p_version_scn=>38788294
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4602090432160874)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.PROCESS.SUSPEND.SUCCESS_MESSAGE'
,p_message_text=>'Workflow suspended'
,p_version_scn=>38788294
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3401090461479147)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.PROCESS.TERMINATE.SUCCESS_MESSAGE'
,p_message_text=>'Workflow terminated'
,p_version_scn=>38788294
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4601852481147222)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.PROCESS.UPDATE_VARIABLE.SUCCESS_MESSAGE'
,p_message_text=>'Variable updated'
,p_version_scn=>38788294
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3401218819499727)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.REFRESH_REPORT'
,p_message_text=>'Refresh - %0'
,p_version_scn=>38788294
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3400210724401497)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.SORT_ORDER.CREATE_DATE'
,p_message_text=>'Create Date'
,p_version_scn=>38788294
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3400410238405537)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.SORT_ORDER.LAST_UPDATE'
,p_message_text=>'Last Update'
,p_version_scn=>38788294
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(7401311218568069)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.STATE.COMPLETED'
,p_message_text=>'Completed'
,p_version_scn=>40822828
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(7401100566565462)
,p_name=>'APEXAPP.WORKFLOW_CONSOLE.STATE.STARTED'
,p_message_text=>'Started'
,p_version_scn=>40822828
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4043614693658048)
,p_name=>'APEXDEV.CREATE_APP_STATIC_FILE'
,p_message_text=>'Create Application Static File'
,p_version_scn=>475806000
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4043809597661899)
,p_name=>'APEXDEV.CREATE_WS_STATIC_FILE'
,p_message_text=>'Create Workspace Static File'
,p_version_scn=>475806263
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2088189729524976)
,p_name=>'APEXDEV.DBMS_CLOUD_INT.NO_DBMS_CLOUD'
,p_message_text=>'The DBMS_CLOUD package is not available on this system.'
,p_version_scn=>8581224
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2088305196526475)
,p_name=>'APEXDEV.DBMS_CLOUD_INT.NO_DBMS_CLOUD_ACCESS'
,p_message_text=>'Missing EXECUTE privilege on the DBMS_CLOUD package.'
,p_version_scn=>8581253
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3685697291162365)
,p_name=>'APEXDEV.DIFF.ADDED'
,p_message_text=>'%0 Added'
,p_version_scn=>48450708
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(413960891492883975)
,p_name=>'APEXDEV.DIFF.AUDIT_COMMENT'
,p_message_text=>'Components merged: %0, Working copy: %1, Elapsed time: %2 sec'
,p_version_scn=>11313611
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(488343868872854461)
,p_name=>'APEXDEV.DIFF.AUDIT_COMMENT_REFRESH'
,p_message_text=>'Refreshed from Main. Components merged: %0, Elapsed time: %1 sec'
,p_version_scn=>11313611
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1794326996031927)
,p_name=>'APEXDEV.DIFF.BACKUP_APP'
,p_message_text=>'Automatic backup before merging changes from app ID: %0 into app ID: %1'
,p_version_scn=>42339255
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3685433316161412)
,p_name=>'APEXDEV.DIFF.CHANGED'
,p_message_text=>'%0 Changed'
,p_version_scn=>48450730
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3771729412977828)
,p_name=>'APEXDEV.DIFF.EXPORTS_COMPLETED'
,p_message_text=>'Finishing up'
,p_version_scn=>42339255
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3771361391947626)
,p_name=>'APEXDEV.DIFF.EXPORT_APP'
,p_message_text=>'Exporting: %0 application'
,p_version_scn=>45796352
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2705597105612308)
,p_name=>'APEXDEV.DIFF.INFO_LINK_TEXT'
,p_message_text=>'More information'
,p_version_scn=>48302664
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2705756668641183)
,p_name=>'APEXDEV.DIFF.INFO_MESSAGE'
,p_message_text=>'%0 changes detected. <strong>Note:</strong> there might be modifications to your application that cannot be merged.'
,p_version_scn=>51195396
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4571990994936512)
,p_name=>'APEXDEV.DIFF.MAIN'
,p_message_text=>'Main'
,p_version_scn=>42339255
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3685821666164730)
,p_name=>'APEXDEV.DIFF.MISSING'
,p_message_text=>'%0 Missing'
,p_version_scn=>48450758
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2014455144085190)
,p_name=>'APEXDEV.DIFF.PAGE_HEADER_COMPARE'
,p_message_text=>'Compare <span class="workingCopyName">%0</span> with %1'
,p_version_scn=>48302783
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3783679057409828)
,p_name=>'APEXDEV.DIFF.PAGE_HEADER_MERGE'
,p_message_text=>'Merge <span class="workingCopyName">%0</span> into %1'
,p_version_scn=>48302807
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2704117323419116)
,p_name=>'APEXDEV.DIFF.PAGE_HEADER_REFRESH'
,p_message_text=>'Refresh <span class="workingCopyName">%1</span> from %0'
,p_version_scn=>53600843
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1796022725512810)
,p_name=>'APEXDEV.DIFF.PAGE_IS_LOCKED_ERROR'
,p_message_text=>'Page %0 is locked in %1 by %2'
,p_version_scn=>100515159
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4572139511938946)
,p_name=>'APEXDEV.DIFF.WORKING_COPY'
,p_message_text=>'Working Copy'
,p_version_scn=>42339255
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3089644060501208)
,p_name=>'APEXDEV.DIFF.WORKING_COPY.COUNT'
,p_message_text=>'%0 Working Copy'
,p_version_scn=>57325803
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1440542402676692)
,p_name=>'APEXDEV.DIFF.WORKING_COPY.COUNT.PLURAL'
,p_message_text=>'%0 Working Copies'
,p_version_scn=>57325735
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1803166797376553)
,p_name=>'APEXDEV.DOWNLOAD.DATATYPE_NOT_SUPPORTED'
,p_message_text=>'Datatype not supported. Only BLOB, CLOB or VARCHAR2 columns are supported.'
,p_version_scn=>5717790
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1803332419377880)
,p_name=>'APEXDEV.DOWNLOAD.PROCESS_NOT_SUPPORTED'
,p_message_text=>'The Download process type is exclusively supported in the ''Before Header'' position during Page Rendering or in Page Processing when the page-level attribute ''Reload on Submit'' is configured as ''Always''. To achieve the desired functionality, consider '
||'utilizing the Download dynamic action as an alternative instead of relying on a page process.'
,p_version_scn=>5717801
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1408633006034984)
,p_name=>'APEXDEV.ICON_LABEL.IMAGE_FILE'
,p_message_text=>'Image file'
,p_version_scn=>472692045
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1408828712040153)
,p_name=>'APEXDEV.ICON_LABEL.OTHER_FILE'
,p_message_text=>'Other file'
,p_version_scn=>472692886
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(283307935221129307)
,p_name=>'APEXDEV.ICON_LABEL.SUCCESS'
,p_message_text=>'Success'
,p_is_js_message=>true
,p_version_scn=>453707698
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(283307419377127780)
,p_name=>'APEXDEV.ICON_LABEL.WARNING'
,p_message_text=>'Warning'
,p_is_js_message=>true
,p_version_scn=>37166015446655
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(873307975274722518)
,p_name=>'APEXDEV.IG.COLUMN_NOT_EXISTS'
,p_message_text=>'Interactive Grid Column ''%0'' specified for Dynamic Action ''#COMPONENT_NAME#'' does not exist.'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(879103136883340544)
,p_name=>'APEXDEV.IG.DML.COMPLEX_VIEW_LOCK'
,p_message_text=>'Process ''%0'' raised ''%1'' while performing row locking. This error can occur when the process issues a SELECT FOR UPDATE on a complex view with an instead-of trigger, to lock the row. Set the process attribute ''Lock Row'' to No or PL/SQL Code.'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(879102909220329261)
,p_name=>'APEXDEV.IG.DML.VIRTUAL_COLUMN'
,p_message_text=>'Process ''%0'' raised ''%1'' while executing a DML command. This error can occur if a column is based on an aggregation or SQL expression. Set column attribute ''Query Only'' to Yes to exclude the column from the INSERT and UPDATE statement.'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(497340504568985648)
,p_name=>'APEXDEV.IG.MASTER_DETAIL_COLUMN_NOT_POPULATED'
,p_message_text=>'The master detail column ''%0'' does not contain a value. Please make sure that the process ''%1'' is executed after the corresponding process of the master region.'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(727791972487724320)
,p_name=>'APEXDEV.IG.NO_MASTER_COLUMN'
,p_message_text=>'Interactive Grid ''%0'' doesn''t have a master column defined which is required for a master detail relationship.'
,p_version_scn=>37165770887498
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(268382530378995588)
,p_name=>'APEXDEV.IG.NO_PK'
,p_message_text=>'Interactive Grid ''%0'' doesn''t have a primary key column defined which is required for editing or in a master detail relationship.'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(651045564097108671)
,p_name=>'APEXDEV.IG.RELOAD_ON_SUBMIT_EDITABLE'
,p_message_text=>'For an Editable Interactive Grid, the Page attribute ''Reload on Submit'' must be set to ''Only for Success''.'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(7214182808225809)
,p_name=>'APEXDEV.INVOKE_API.FUNCTION_RESULT'
,p_message_text=>'Function Result'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3309838195213779)
,p_name=>'APEXDEV.OBJECT_DEPENDENCIES.PACKAGE_METHOD_NOT_FOUND'
,p_message_text=>'Package procedure or function %0 does not exist.'
,p_version_scn=>43835508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3122094596026286)
,p_name=>'APEXDEV.OBJECT_DEPENDENCIES.SCAN_IN_PROGRESS'
,p_message_text=>'Another scan of this application is in progress.'
,p_version_scn=>42506908
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(12172284545201942)
,p_name=>'APEXDEV.OBJECT_DEPENDENCIES.UNSUPPORTED_EXPRESSION'
,p_message_text=>'Warning: analysis of Column SQL Expression based on a Function Body Returning SQL is not fully supported.'
,p_version_scn=>11566613
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(612409860626451489)
,p_name=>'APEXDEV.PE.CODE_EDITOR'
,p_message_text=>'Code Editor: %0'
,p_is_js_message=>true
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(612410174397451493)
,p_name=>'APEXDEV.PE.COLLAPSE'
,p_message_text=>'Collapse %0'
,p_is_js_message=>true
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(612410430905451493)
,p_name=>'APEXDEV.PE.COLOR_PICKER'
,p_message_text=>'Color Picker: %0'
,p_is_js_message=>true
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(612410719592451494)
,p_name=>'APEXDEV.PE.EDIT_COMPONENT'
,p_message_text=>'Edit Component'
,p_is_js_message=>true
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(612411000391451494)
,p_name=>'APEXDEV.PE.ERROR_POSTFIX'
,p_message_text=>' (Error)'
,p_is_js_message=>true
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(612411384203451494)
,p_name=>'APEXDEV.PE.EXPAND'
,p_message_text=>'Expand %0'
,p_is_js_message=>true
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(612409685614451487)
,p_name=>'APEXDEV.PE.FILTER'
,p_message_text=>'Filter'
,p_is_js_message=>true
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(612411648032451494)
,p_name=>'APEXDEV.PE.FILTER_NO_MATCH'
,p_message_text=>'No results found.'
,p_is_js_message=>true
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(612411956862451495)
,p_name=>'APEXDEV.PE.FILTER_NO_MATCH_COMMON'
,p_message_text=>'No results found. Try searching all properties by clicking the ''Show All'' button above.'
,p_is_js_message=>true
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(612412238896451495)
,p_name=>'APEXDEV.PE.FILTER_PROPERTIES'
,p_message_text=>'Filter Properties'
,p_is_js_message=>true
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(612412578032451495)
,p_name=>'APEXDEV.PE.INVALID'
,p_message_text=>'%0 (Invalid)'
,p_is_js_message=>true
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4435411486753472)
,p_name=>'APEXDEV.PE.INVALID_GRAPH_NAME'
,p_message_text=>'The property graph %0 does not exist.'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(6601296965619661)
,p_name=>'APEXDEV.PE.INVALID_METHOD_NAME1'
,p_message_text=>'The function or procedure %0 in package %1 does not exist.'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(6601495027623201)
,p_name=>'APEXDEV.PE.INVALID_METHOD_NAME2'
,p_message_text=>'The stored function or procedure %0 does not exist.'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(6800390708839639)
,p_name=>'APEXDEV.PE.INVALID_PACKAGE_NAME'
,p_message_text=>'The package %0 does not exist.'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(612412877049451495)
,p_name=>'APEXDEV.PE.LIST_OF_VALUES'
,p_message_text=>'List of Values: %0'
,p_is_js_message=>true
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(612413190550451496)
,p_name=>'APEXDEV.PE.NO'
,p_message_text=>'No'
,p_is_js_message=>true
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(612413450988451496)
,p_name=>'APEXDEV.PE.NO_COMMON_PROPERTIES'
,p_message_text=>'The selected components have no properties in common.'
,p_is_js_message=>true
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(612417086929451499)
,p_name=>'APEXDEV.PE.NO_COMPONENTS_SELECTED'
,p_message_text=>'No components currently selected'
,p_is_js_message=>true
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(612413717105451496)
,p_name=>'APEXDEV.PE.PICK'
,p_message_text=>'Pick %0'
,p_is_js_message=>true
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(612414096872451497)
,p_name=>'APEXDEV.PE.PIN_FILTER'
,p_message_text=>'Pin Filter'
,p_is_js_message=>true
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(612414346715451497)
,p_name=>'APEXDEV.PE.QUICK_PICK'
,p_message_text=>'Quick Pick: %0'
,p_is_js_message=>true
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(612414646064451497)
,p_name=>'APEXDEV.PE.QUICK_PICK.CLEAR'
,p_message_text=>'Clear Selection'
,p_is_js_message=>true
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(612414910864451497)
,p_name=>'APEXDEV.PE.REQUIRED'
,p_message_text=>'Required'
,p_is_js_message=>true
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(612415246651451498)
,p_name=>'APEXDEV.PE.SEARCH'
,p_message_text=>'Search'
,p_is_js_message=>true
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(612415566399451498)
,p_name=>'APEXDEV.PE.SELECT'
,p_message_text=>'- Select -'
,p_is_js_message=>true
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(612415880557451498)
,p_name=>'APEXDEV.PE.VALUE_VARIES_POSTFIX'
,p_message_text=>' (Value Varies)'
,p_is_js_message=>true
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(612416193276451498)
,p_name=>'APEXDEV.PE.WARNING'
,p_message_text=>'Warning'
,p_is_js_message=>true
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(612416484511451499)
,p_name=>'APEXDEV.PE.WARNING_POSTFIX'
,p_message_text=>' (Warning)'
,p_is_js_message=>true
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(612416741449451499)
,p_name=>'APEXDEV.PE.YES'
,p_message_text=>'Yes'
,p_is_js_message=>true
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1404503700241713)
,p_name=>'APEXDEV.PRINT_REPORT.PROCESS_NOT_SUPPORTED'
,p_message_text=>'The Print Report process type is exclusively supported in the ''Before Header'' position during Page Rendering or in Page Processing when the page-level attribute ''Reload on Submit'' is configured as ''Always''. To achieve the desired functionality, consi'
||'der utilizing the Print Report dynamic action as an alternative instead of relying on a page process.'
,p_version_scn=>32255563
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5227580686548819)
,p_name=>'APEXDEV.REGION.TEMPLATE_COMPONENT.NO_PK'
,p_message_text=>'The Template Component region ''%0'' doesn''t have a primary key column defined, which is required for enabling selection or grouping functionality.'
,p_version_scn=>38718814
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4044020048680152)
,p_name=>'APEXDEV.STATIC_APP_FILE_ACTIONS'
,p_message_text=>'Static application file actions'
,p_version_scn=>475812799
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4044268184685965)
,p_name=>'APEXDEV.STATIC_WS_FILE_ACTIONS'
,p_message_text=>'Static workspace file actions'
,p_version_scn=>475813993
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(651047747543155674)
,p_name=>'APEXDEV.TABFORM.RELOAD_ON_SUBMIT'
,p_message_text=>'For a Tabular Form, the Page attribute ''Reload on Submit'' must be set to ''Always''.'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(6801557010052339)
,p_name=>'APEXDEV.TEMPLATE_COMPONENT.PK_REQUIRED'
,p_message_text=>'A primary key is required for displaying media as part of the "%0" Template Component.'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(9600737088997323)
,p_name=>'APEXDEV.TEMPLATE_DIRECTIVE.INVALID_PLACEHOLDER_NAME'
,p_message_text=>'"%0" is an invalid placeholder name.'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(110951881565404586)
,p_name=>'APEXDEV.TEMPLATE_DIRECTIVE.MAX_SELF_APPLIED'
,p_message_text=>'The "%0" Template Component keeps applying itself.'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1800659889442686)
,p_name=>'APEXDEV.TEMPLATE_DIRECTIVE.MISSING_ARGUMENT'
,p_message_text=>'Missing "%0" argument in the template.'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2102963056373576)
,p_name=>'APEXDEV.TEMPLATE_DIRECTIVE.MISSING_END_TOKEN'
,p_message_text=>'Missing "%0" in the template.'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5201590669039291)
,p_name=>'APEXDEV.TEMPLATE_DIRECTIVE.PLACEHOLDER_NOT_DEFINED'
,p_message_text=>'Placeholder "%0" is not defined in the "%1" Template Component.'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(10005055326610040)
,p_name=>'APEXDEV.TEMPLATE_DIRECTIVE.REQUIRED_PLACEHOLDER_IS_MISSING'
,p_message_text=>'Placeholder "%0" is required in order to apply the "%1" Template Component.'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5201126270989200)
,p_name=>'APEXDEV.TEMPLATE_DIRECTIVE.TEMPLATE_NOT_FOUND'
,p_message_text=>'Template Component "%0" not found.'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2102346846355687)
,p_name=>'APEXDEV.TEMPLATE_DIRECTIVE.TOKEN_UNEXPECTED'
,p_message_text=>'Unexpected "%0" in the template.'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2103832091503645)
,p_name=>'APEXDEV.TEMPLATE_DIRECTIVE.TOKEN_UNEXPECTED_AFTER'
,p_message_text=>'Unexpected "%0" after "%1" in the template.'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5481791421095679)
,p_name=>'APEXDEV.TEMPLATE_DIRECTIVE.UNEXPECTED_ARGUMENT'
,p_message_text=>'Unexpected "%0" argument in the template.'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3617614094693068)
,p_name=>'APEXDEV.TEMPLATE_WORKSPACE'
,p_message_text=>'Workspace'
,p_version_scn=>465446364
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(7223597401931205)
,p_name=>'APEXDEV.THEME.SWITCH.FAILED'
,p_message_text=>'Theme Switch failed.'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(7203680098369584)
,p_name=>'APEXDEV.THEME.SWITCH.TMPL_ATTR_ERROR'
,p_message_text=>'Cannot Switch Template Component "%0". Custom Attribute "%1" is not equal due to the Name, Sequence, or Type in Theme %2.'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3456762454183373)
,p_name=>'APEXDEV.THEME.SWITCH.TMPL_ATTR_REQUIRED'
,p_message_text=>'Cannot Switch Template Component "%0". Custom Attribute "%1" is required in Theme %2.'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1601134037315465)
,p_name=>'APEXDEV.WORKING_ENVIRONMENT'
,p_message_text=>'Working Environment'
,p_version_scn=>7355608
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(545782169043116383)
,p_name=>'APEXIG_MULTIIG_PAGE_REGION_STATIC_ID_REQUIRED'
,p_message_text=>'Region Static ID must be specified as the page contains multiple Interactive Grids.'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(67560903880357065)
,p_name=>'APEXIR_3D'
,p_message_text=>'3D'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(112052218889463208)
,p_name=>'APEXIR_ADD'
,p_message_text=>'Add'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(444781311433192374)
,p_name=>'APEXIR_ADD_SUBSCRIPTION'
,p_message_text=>'Add Subscription'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(147600119386132087)
,p_name=>'APEXIR_AGGREGATE_DESCRIPTION'
,p_message_text=>'Aggregates are displayed after each control break and at the end of the report.'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(121294162436905517)
,p_name=>'APEXIR_AGG_COUNT_DISTINCT'
,p_message_text=>'Count Distinct'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(112079230934911338)
,p_name=>'APEXIR_AGG_MODE'
,p_message_text=>'Mode'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(644585214705381401)
,p_name=>'APEXIR_AREA'
,p_message_text=>'Area'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(439756463016811486)
,p_name=>'APEXIR_BLACK'
,p_message_text=>'Black'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(112498219214129041)
,p_name=>'APEXIR_CALENDAR'
,p_message_text=>'Calendar'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(136484730494817722)
,p_name=>'APEXIR_COLUMN_HEADING'
,p_message_text=>'Column Heading'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(791245704267305762)
,p_name=>'APEXIR_DAY'
,p_message_text=>'Day'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113562124088824615)
,p_name=>'APEXIR_DELETE_CHECKED'
,p_message_text=>'Delete Checked'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(147696903858581672)
,p_name=>'APEXIR_DELETE_CONFIRM_JS_DIALOG'
,p_message_text=>'Would you like to perform this delete action?'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(141701322705830797)
,p_name=>'APEXIR_DISABLE'
,p_message_text=>'Disable'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(67616512564286660)
,p_name=>'APEXIR_DISPLAY'
,p_message_text=>'Display'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(57099547077721312)
,p_name=>'APEXIR_DONUT'
,p_message_text=>'Donut'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(6902576875804404)
,p_name=>'APEXIR_DOWNLOAD_DATA_ONLY'
,p_message_text=>'Data Only'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(67562512107378287)
,p_name=>'APEXIR_DO_NOT_AGGREGATE'
,p_message_text=>'- Do not aggregate -'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(623927411493897229)
,p_name=>'APEXIR_EDIT_ALTERNATIVE_DEFAULT'
,p_message_text=>'Edit Alternative Default'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(141700107467826356)
,p_name=>'APEXIR_ENABLE'
,p_message_text=>'Enable'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(147667208426412771)
,p_name=>'APEXIR_FLASHBACK_ERROR_MSG'
,p_message_text=>'Unable to perform flashback request'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(411213431260597045)
,p_name=>'APEXIR_FUNCTION_COLUMN'
,p_message_text=>'Function Column %0'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(439756626969811971)
,p_name=>'APEXIR_GRAY'
,p_message_text=>'Gray'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(55272404660857836)
,p_name=>'APEXIR_HIGHLIGHT_WHEN'
,p_message_text=>'Highlight When'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(362416425067891251)
,p_name=>'APEXIR_LABEL_PREFIX'
,p_message_text=>'Label Prefix'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(419523509375811302)
,p_name=>'APEXIR_MANAGE_SUBSCRIPTION'
,p_message_text=>'Please click <a href=''%0''>here</a> to manage your subscription.'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(147809928997853860)
,p_name=>'APEXIR_MORE_DATA'
,p_message_text=>'More Data'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(63857427647172147)
,p_name=>'APEXIR_NEW_CATEGORY'
,p_message_text=>'- New Category -'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113562810367830112)
,p_name=>'APEXIR_NO_AGGREGATION_DEFINED'
,p_message_text=>'No aggregation defined.'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(92168806416507513)
,p_name=>'APEXIR_NO_COLUMN_INFO'
,p_message_text=>'No column information available.'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113563622141833542)
,p_name=>'APEXIR_NO_COMPUTATION_DEFINED'
,p_message_text=>'No computation defined.'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(791245424915302275)
,p_name=>'APEXIR_NO_END_DATE'
,p_message_text=>'- No End Date -'
,p_version_scn=>37165770887499
);
end;
/
begin
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1613435287230446315)
,p_name=>'APEXIR_PIVOT_ROW_COLUMN_INVALID'
,p_message_text=>'Please select different row column.  The HTML expression or link in the row column contains column defined as pivot or aggregate column.'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(112052717597519521)
,p_name=>'APEXIR_REMOVE_AGGREGATE'
,p_message_text=>'Remove Aggregate'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(327439527633801368)
,p_name=>'APEXIR_REPORT_DISPLAY_COLUMN_LIMIT_REACHED'
,p_message_text=>'The number of display columns in the report reached the limit.  Please click Select Columns under Actions menu to minimize the report display column list.'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(103919323340917461)
,p_name=>'APEXIR_ROW_ORDER'
,p_message_text=>'Row Order'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(6748409827923181)
,p_name=>'APEXIR_RPT_DISP_COL_EXCEED'
,p_message_text=>'The number of display columns in the report reached the limit.  Please click Select Columns under Actions menu to minimize the report display column list.'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113540030003703334)
,p_name=>'APEXIR_SAVE_AS_DEFAULT'
,p_message_text=>'Save as Default'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(56145302739843998)
,p_name=>'APEXIR_SELECT_CATEGORY'
,p_message_text=>'- Select Category -'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(148092507292405773)
,p_name=>'APEXIR_SELECT_COLUMNS_FOOTER'
,p_message_text=>'Computed columns are prefixed with **.'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(791243729239265742)
,p_name=>'APEXIR_SELECT_SORT_COLUMN'
,p_message_text=>'- Select Sort Column -'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(147809506488847342)
,p_name=>'APEXIR_SELECT_VALUE'
,p_message_text=>'Select Value'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(791241818157262484)
,p_name=>'APEXIR_SORT_COLUMN'
,p_message_text=>'Sort Column %0'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(408433823707074435)
,p_name=>'APEXIR_SUBSCRIPTION_ENDING_UNIT'
,p_message_text=>'Ending Unit'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(147668206479421636)
,p_name=>'APEXIR_UNAUTHORIZED'
,p_message_text=>'Unauthorized'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(139688810701818118)
,p_name=>'APEXIR_UNIQUE_COLUMN_HEADING'
,p_message_text=>'Column Heading must be unique.'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(791246325392311859)
,p_name=>'APEXIR_WEEK'
,p_message_text=>'Week'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5726119032631729)
,p_name=>'APEX_ADMIN_SERVICES'
,p_message_text=>'Oracle APEX Administration Services'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(624801124779296459)
,p_name=>'APEX_AUTHENTICATION.NOT_CONFIGURED'
,p_message_text=>'There is no authentication configured for this application.'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(164806130198109254)
,p_name=>'APEX_SAMPLE_LOAD'
,p_message_text=>'The following database objects will be %0 into the selected schema:'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(164812283120259655)
,p_name=>'APEX_SAMPLE_LOAD_SUCCESS'
,p_message_text=>'The following database objects were successfully %0:'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(502640933259223682)
,p_name=>'APEX_SCROLL_DOWN'
,p_message_text=>'Scroll down'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(502641259368224775)
,p_name=>'APEX_SCROLL_TO_TOP'
,p_message_text=>'Scroll to top'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(8485712413560636)
,p_name=>'APEX_WIZARD_FORM'
,p_message_text=>'Navigation Form'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(623926632702884462)
,p_name=>'APEX_WS_EDIT_ROW'
,p_message_text=>'Edit Row'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(295234610322901649)
,p_name=>'APEX_WS_INVALID_OBJECTS'
,p_message_text=>'Invalid Objects'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(820480710316844869)
,p_name=>'APEX_WS_NO_PEER_PAGES'
,p_message_text=>'No peer pages exist'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(628754359011688580)
,p_name=>'APEX_WS_SETUP_CREATE_OBJ'
,p_message_text=>'Objects to create'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(628832820607735495)
,p_name=>'APEX_WS_SETUP_DELETE_TABLES'
,p_message_text=>'Delete from Tables'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(628883040615235507)
,p_name=>'APEX_WS_SETUP_DROP_OBJECTS'
,p_message_text=>'Drop Objects'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(456465923849355411)
,p_name=>'APEX_WS_SETUP_OBJECT_NAME'
,p_message_text=>'Object Name'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(456466728005356617)
,p_name=>'APEX_WS_SETUP_OBJECT_TYPE'
,p_message_text=>'Object Type'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(456463701077329978)
,p_name=>'APEX_WS_SETUP_SCHEMA'
,p_message_text=>'Schema'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(628753580952682996)
,p_name=>'APEX_WS_SETUP_USE_EXISTING_OBJ'
,p_message_text=>'Existing objects to be used'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25119900774841915)
,p_name=>'APPLICACTION_COMPUTATIONS'
,p_message_text=>'Application Computations'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25119502543795150)
,p_name=>'APPLICACTION_PROCESS'
,p_message_text=>'Application Processes'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(276935211336777527)
,p_name=>'APPLICATION'
,p_message_text=>'Application'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(359248313170152671)
,p_name=>'APPLICATION BUILDER'
,p_message_text=>'App Builder'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(192771330479976314)
,p_name=>'APPLICATION COMPUTATION CONDITION'
,p_message_text=>'Application Computation Condition'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(193925322687230689)
,p_name=>'APPLICATION IMAGE'
,p_message_text=>'Application Image'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(192771710178979905)
,p_name=>'APPLICATION PROCESS CONDITION'
,p_message_text=>'Application Process Condition'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(160743812928269079)
,p_name=>'APPLICATIONS'
,p_message_text=>'applications'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(254103219723839878)
,p_name=>'APPLICATIONS_INITCAP'
,p_message_text=>'Applications'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184171506479952922)
,p_name=>'APPLICATION_ACTIVITY'
,p_message_text=>'Application Activity'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(204326431260698780)
,p_name=>'APPLICATION_ALIAS'
,p_message_text=>'Application Alias'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(201888924075925886)
,p_name=>'APPLICATION_DELETED'
,p_message_text=>'Application Deleted'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5715305985486099)
,p_name=>'APPLICATION_DEVELOPMENT'
,p_message_text=>'Application Development'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(203483230134875810)
,p_name=>'APPLICATION_HELP'
,p_message_text=>'Identifies Application.'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(183997123759605032)
,p_name=>'APPLICATION_ID'
,p_message_text=>'Application Number'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(137890104814220249)
,p_name=>'APPLICATION_ID_RESERVED'
,p_message_text=>'Application ID is reserved.'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(137688617384138471)
,p_name=>'APPLICATION_ID_VALIDATION'
,p_message_text=>'Application ID must be a positive, whole number.'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(486385824784572064)
,p_name=>'APPLICATION_IMAGES'
,p_message_text=>'Application Images'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(244155829077041830)
,p_name=>'APPLICATION_ITEM'
,p_message_text=>'Application Item'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(34139202594701700)
,p_name=>'APPLICATION_ITEMS'
,p_message_text=>'Application Items'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(23824317961115621)
,p_name=>'APPLICATION_LABEL'
,p_message_text=>'Application: %0'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(204325926066697215)
,p_name=>'APPLICATION_NAME'
,p_message_text=>'Application Name'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(820473101406548964)
,p_name=>'APPLICATION_NAMES'
,p_message_text=>'Application Names'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(315871028643575093)
,p_name=>'APPLICATION_OVERRIDE_ID'
,p_message_text=>'Application Override ID'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(201792407780421040)
,p_name=>'APPLICATION_OWNER'
,p_message_text=>'Application Owner'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(820472102875530500)
,p_name=>'APPLICATION_PAGES'
,p_message_text=>'Application Pages'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(72038406986033206)
,p_name=>'APPLICATION_SETTINGS'
,p_message_text=>'Application Settings'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(201793217823423985)
,p_name=>'APPLICATION_STATUS'
,p_message_text=>'Application Status'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(282817600879195063)
,p_name=>'APPLICATION_VERSION'
,p_message_text=>'Application Version'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(11212531906149315)
,p_name=>'APPLICATION_X'
,p_message_text=>'Application %0'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(176999305714750057)
,p_name=>'APPROVED'
,p_message_text=>'Approved'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(209403007313600972)
,p_name=>'APP_SUCCESS_MSG'
,p_message_text=>'The application has been successfully created.'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(836388413761993110)
,p_name=>'APP_TEMPLATE_LABEL'
,p_message_text=>'Template Application'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(22592528732319119)
,p_name=>'APP_TYPE_DATABASE'
,p_message_text=>'Application'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(22593232542320275)
,p_name=>'APP_TYPE_PACKAGED'
,p_message_text=>'Productivity or Sample Application'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(176657314673029861)
,p_name=>'ARCHIVED'
,p_message_text=>'Archived'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(23929717128314457)
,p_name=>'ARCHIVELOG'
,p_message_text=>'Log Archiving: On'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(114403831934115900)
,p_name=>'ARGUMENTS_MUST_HAVE_CHECKSUM'
,p_message_text=>'Arguments Must Have Checksum'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145291012953055509)
,p_name=>'ARGUMENT_NAME'
,p_message_text=>'Argument Name'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145291931654060896)
,p_name=>'ARGUMENT_TYPE'
,p_message_text=>'Argument Type'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(172768009090484269)
,p_name=>'ASAP'
,p_message_text=>'As soon as possible'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(171872404945931328)
,p_name=>'ASSIGNED'
,p_message_text=>'Assigned'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(68117228795073143)
,p_name=>'ASSIGNEE'
,p_message_text=>'Assignee'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(969138433284014825)
,p_name=>'ASSIGN_LABEL'
,p_message_text=>'Assign  %0'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(88270128342698420)
,p_name=>'ASSOCIATED'
,p_message_text=>'associated'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(70744921953402322)
,p_name=>'ASSOCIATED_FEATURES'
,p_message_text=>'Associated Features'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184527917540507627)
,p_name=>'ATTACHMENT'
,p_message_text=>'Attachment'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1116469627795891689)
,p_name=>'AT_RISK_LABEL'
,p_message_text=>'At Risk'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84980113452412986)
,p_name=>'AUTH.CONFIRM_MIGRATE'
,p_message_text=>'You are about to migrate this application''s custom authentication options to an authentication scheme.'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84975628165379446)
,p_name=>'AUTH.CURRENT_AUTH_METHOD'
,p_message_text=>'Current Authentication Method'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84979308473402072)
,p_name=>'AUTH.CUSTOM_AUTH_FUNCTION'
,p_message_text=>'Custom Authentication Function'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84977318253386052)
,p_name=>'AUTH.LOGIN_PAGE'
,p_message_text=>'Login Page'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84978925657397584)
,p_name=>'AUTH.LOGIN_URL'
,p_message_text=>'Login URL'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84978002454390895)
,p_name=>'AUTH.NONE'
,p_message_text=>'none'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86590502377236028)
,p_name=>'AUTHENTICATION'
,p_message_text=>'Authentication'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(192776815943047895)
,p_name=>'AUTHENTICATION FUNCTION'
,p_message_text=>'Authentication Function'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(192775618929039286)
,p_name=>'AUTHENTICATION SCHEME'
,p_message_text=>'Authentication Scheme'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(87208221048414695)
,p_name=>'AUTHENTICATION.CONFIRM_DELETE'
,p_message_text=>'You are about to delete an authentication scheme from application %0. If the application is not currently using SCHEME authentication or if the scheme is not the current authentication scheme, deleting the scheme has no effect on the operation of the'
||' application. If the application is using SCHEME authentication and this is the current authentication scheme, the application will continue to run using SCHEME authentication, but with a default authentication scheme. This will use a built-in login '
||'page with "open door" credentials verification (that is, anyone will be allowed to run the application). '
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(87889804014093209)
,p_name=>'AUTHENTICATION.MAKE_CURRENT'
,p_message_text=>'Click the Make Current button to have your application use this authentication scheme.'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(363427413736982258)
,p_name=>'AUTHENTICATION_NAME.NATIVE_APEX_ACCOUNTS'
,p_message_text=>'Oracle APEX Accounts'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4770420113873080)
,p_name=>'AUTHENTICATION_NAME.NATIVE_CLOUD_IDM'
,p_message_text=>'Oracle Cloud Identity Management'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(363435219276983864)
,p_name=>'AUTHENTICATION_NAME.NATIVE_CUSTOM'
,p_message_text=>'Custom'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(363483002438988511)
,p_name=>'AUTHENTICATION_NAME.NATIVE_DAD'
,p_message_text=>'No Authentication'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(363443124471985374)
,p_name=>'AUTHENTICATION_NAME.NATIVE_DB_ACCOUNTS'
,p_message_text=>'Database Accounts'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1784899136475230)
,p_name=>'AUTHENTICATION_NAME.NATIVE_EXTENSION'
,p_message_text=>'Builder Extension Sign-In'
,p_version_scn=>19403533
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(556006715508818492)
,p_name=>'AUTHENTICATION_NAME.NATIVE_HTTP_HEADER_VARIABLE'
,p_message_text=>'HTTP Header Variable'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(363511814559991981)
,p_name=>'AUTHENTICATION_NAME.NATIVE_IAS_SSO'
,p_message_text=>'Oracle Application Server Single Sign-On'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(363462329319986727)
,p_name=>'AUTHENTICATION_NAME.NATIVE_LDAP'
,p_message_text=>'LDAP Directory'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(363499006940989801)
,p_name=>'AUTHENTICATION_NAME.NATIVE_OPEN_DOOR'
,p_message_text=>'Open Door Credentials'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1382586340020134)
,p_name=>'AUTHENTICATION_NAME.NATIVE_SAML'
,p_message_text=>'SAML Sign-In'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15243204618976010)
,p_name=>'AUTHENTICATION_NAME.NATIVE_SOCIAL'
,p_message_text=>'Social Sign-In'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(244213402938372976)
,p_name=>'AUTHENTICATION_SCHEME'
,p_message_text=>'Authentication Scheme'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(192775001960034392)
,p_name=>'AUTHORIZATION SCHEME'
,p_message_text=>'Authorization Scheme'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4774527732875201)
,p_name=>'AUTHORIZATION_NAME.NATIVE_CLOUD_IDM'
,p_message_text=>'Oracle Cloud Identity Management'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(11261109462457047)
,p_name=>'AUTHORIZATION_NAME.NATIVE_EXISTS'
,p_message_text=>'Exists SQL Query'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(11261314310458385)
,p_name=>'AUTHORIZATION_NAME.NATIVE_FUNCTION_BODY'
,p_message_text=>'PL/SQL Function Returning Boolean'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(135867122178687109)
,p_name=>'AUTHORIZATION_NAME.NATIVE_IS_IN_GROUP'
,p_message_text=>'Is In Role or Group'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(135867319806688244)
,p_name=>'AUTHORIZATION_NAME.NATIVE_IS_NOT_IN_GROUP'
,p_message_text=>'Is Not In Role or Group'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(11261519158459818)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_EQUALS_VALUE'
,p_message_text=>'Value of Item in Expression 1 Equals Expression 2'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(11261724007461158)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_IS_NOT_NULL'
,p_message_text=>'Item in Expression1 is NOT NULL'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(11262006822465716)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_IS_NULL'
,p_message_text=>'Item in Expression 1 is NULL'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(11262210632466812)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_NOT_EQUALS_VALUE'
,p_message_text=>'Value of Item in Expression 1 Does NOT Equal Expression 2'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(11262414441467901)
,p_name=>'AUTHORIZATION_NAME.NATIVE_NOT_EXISTS'
,p_message_text=>'NOT Exists SQL Query'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(11262618943469182)
,p_name=>'AUTHORIZATION_NAME.NATIVE_PREF_EQUALS_VALUE'
,p_message_text=>'Value of Preference in Expression 1 Equals Expression 2'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(11262823099470416)
,p_name=>'AUTHORIZATION_NAME.NATIVE_PREF_NOT_EQUALS_VALUE'
,p_message_text=>'Value of Preference in Expression 1 Does NOT Equal Expression 2'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25598506881464331)
,p_name=>'AUTHZ_CACHE_PER_PAGE_VIEW'
,p_message_text=>'Evaluate for every page view'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25598915885466909)
,p_name=>'AUTHZ_CACHE_PER_SESSION'
,p_message_text=>'Evaluate once per session'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(12752907900044741)
,p_name=>'AUTH_ACCOUNT_EXPIRED'
,p_message_text=>'Account Expired'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(12752503051043328)
,p_name=>'AUTH_ACCOUNT_LOCKED'
,p_message_text=>'Account Locked'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(12754102836052690)
,p_name=>'AUTH_ATTEMPTS_EXCEEDED'
,p_message_text=>'Maximum Login Attempts Exceeded'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(12754509762054706)
,p_name=>'AUTH_INTERNAL_ERROR'
,p_message_text=>'Unknown Internal Error'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(12753725561049781)
,p_name=>'AUTH_PASSWORD_FIRST_USE'
,p_message_text=>'Password First Use'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(12753318289047745)
,p_name=>'AUTH_PASSWORD_INCORRECT'
,p_message_text=>'Incorrect Password'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(12751723006039634)
,p_name=>'AUTH_SUCCESS'
,p_message_text=>'Normal, successful authentication'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(12752130279041717)
,p_name=>'AUTH_UNKNOWN_USER'
,p_message_text=>'Unknown User Name'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(42835024888575920)
,p_name=>'AUTH_UNKNOWN_WORKSPACE'
,p_message_text=>'Unknown Workspace Name'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(46712915547065819)
,p_name=>'AUTH_UNKNOWN_WORKSPACE_COLON'
,p_message_text=>'Unknown Workspace Name: %0'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(106601517552404527)
,p_name=>'AUTOCOMMIT'
,p_message_text=>'Commit statement not applicable.  All statements are automatically committed.'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(561323515570939404)
,p_name=>'AUTOMATIONS'
,p_message_text=>'Automation'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(561324058485973047)
,p_name=>'AUTOMATION_ACTIONS'
,p_message_text=>'Automation Action'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(254984219822103682)
,p_name=>'AUTOPROVISION_MODE'
,p_message_text=>'Provisioning Mode'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3611510058039936)
,p_name=>'AUTO_FIRST_ITEM'
,p_message_text=>'First Item'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(290093313947238895)
,p_name=>'AVAILABILITY_INIT_CAP'
,p_message_text=>'Availability'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(14633025624668156)
,p_name=>'AVAILABLE'
,p_message_text=>'Available'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(402732328872676693)
,p_name=>'AVAILABLE_TO_DEVELOPERS_ONLY'
,p_message_text=>'Available to Developers Only'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(402716131434667851)
,p_name=>'AVAILABLE_WITH_EDIT_LINKS'
,p_message_text=>'Available with Developer Toolbar'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184176217280135809)
,p_name=>'AVERAGE_RENDER_TIME_SECONDS'
,p_message_text=>'Average Rendering Time (Seconds)'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(175289809867113949)
,p_name=>'BAR_CHART'
,p_message_text=>'Bar Chart'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(471700515483089456)
,p_name=>'BASIC'
,p_message_text=>'Basic'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(19748000349798134)
,p_name=>'BASIC_DEVELOPER'
,p_message_text=>'Basic Developer'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(166096519250032238)
,p_name=>'BEFORE'
,p_message_text=>'Before'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(858434258584172426)
,p_name=>'BEFORE LIST ENTRY'
,p_message_text=>'Before List Entry'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(946323974268547532)
,p_name=>'BEFORE_FIRST'
,p_message_text=>'Before First'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(194638714428741225)
,p_name=>'BIND_LABEL'
,p_message_text=>'Bind Label'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(194225607253578559)
,p_name=>'BIND_VARIABLE'
,p_message_text=>'Bind Variable'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(194226113964589955)
,p_name=>'BIND_VARIABLE_LABEL'
,p_message_text=>'Bind Variable Label'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(211008925787727306)
,p_name=>'BLACK_TEXT'
,p_message_text=>'Black Text'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5910016279942038)
,p_name=>'BLANK'
,p_message_text=>'Blank'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184523023896443249)
,p_name=>'BLOB_COLUMN'
,p_message_text=>'BLOB Column'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(317487424096621745)
,p_name=>'BLOB_DOWNLOAD_TEXT'
,p_message_text=>'Download'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(22989702805390350)
,p_name=>'BLOB_FORMAT'
,p_message_text=>'Blob Format'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(317510018014943651)
,p_name=>'BLOB_FORMAT_ATTACHMENT'
,p_message_text=>'Attachment'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(317506415691883968)
,p_name=>'BLOB_FORMAT_DOWNLOAD'
,p_message_text=>'DOWNLOAD'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(317506612887885269)
,p_name=>'BLOB_FORMAT_IMAGE'
,p_message_text=>'IMAGE'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(317509821249942086)
,p_name=>'BLOB_FORMAT_INLINE'
,p_message_text=>'Inline'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184536305681873179)
,p_name=>'BLOB_FORMAT_MASK'
,p_message_text=>'BLOB Format'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184526705719475860)
,p_name=>'BLOB_LAST_UPDATED_COLUMN'
,p_message_text=>'BLOB Last Updated Column'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184522708181429296)
,p_name=>'BLOB_TABLE'
,p_message_text=>'BLOB Table'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(211008521978726251)
,p_name=>'BLUE_TEXT'
,p_message_text=>'Blue Text'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(190201810387940994)
,p_name=>'BRANCH CONDITION'
,p_message_text=>'Branch Condition'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(26574026263306547)
,p_name=>'BRANCHES'
,p_message_text=>'Branches'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(112649114174331879)
,p_name=>'BREADCRUMB'
,p_message_text=>'Breadcrumb'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(166156511706285586)
,p_name=>'BREADCRUMB LABEL'
,p_message_text=>'Breadcrumb Label'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(166157216208286830)
,p_name=>'BREADCRUMB LONG NAME'
,p_message_text=>'Breadcrumb Long Name'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(112652500584346879)
,p_name=>'BREADCRUMBS'
,p_message_text=>'Breadcrumbs'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(227313332167417545)
,p_name=>'BREADCRUMB_ENTRY'
,p_message_text=>'Breadcrumb Entry'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(244159817585123126)
,p_name=>'BREADCRUMB_ENTRY_NAME'
,p_message_text=>'Breadcrumb Entry: %0'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(138291118408684695)
,p_name=>'BREADCRUMB_PAGES'
,p_message_text=>'Breadcrumb Pages'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(170067405116549071)
,p_name=>'BREADCRUMB_REGION'
,p_message_text=>'Breadcrumb Region'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(47749016267868812)
,p_name=>'BREADCRUMB_SUCCESS_MSG'
,p_message_text=>'The breadcrumb has been created successfully.'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(166879626973629620)
,p_name=>'BROWSE_ICON'
,p_message_text=>'Browse Icon'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(166350003385352802)
,p_name=>'BROWSE_PACKAGE'
,p_message_text=>'Browse Package'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145279924934973828)
,p_name=>'BROWSE_TABLE'
,p_message_text=>'Browse Table'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15119263075733254)
,p_name=>'BU.APPLICATION_ERROR'
,p_message_text=>'An error occurred backing up the application'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15118664523711425)
,p_name=>'BU.APPLICATION_RESTORED'
,p_message_text=>'Application %0 restored from revision %1'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1802407597908026)
,p_name=>'BU.APP_ACL'
,p_message_text=>'Application ACL'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1702144432186491)
,p_name=>'BU.APP_COMPUTATION'
,p_message_text=>'Application Computation'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1702368180188467)
,p_name=>'BU.APP_ITEM'
,p_message_text=>'Application Item'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1702863233206431)
,p_name=>'BU.APP_PROCESS'
,p_message_text=>'Application Process'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(482676484408478150)
,p_name=>'BU.APP_PROPS_MODIFIED'
,p_message_text=>'Application Properties: Modified'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1701377062165516)
,p_name=>'BU.APP_SETTING'
,p_message_text=>'Application Setting'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1706991102383692)
,p_name=>'BU.APP_STATIC_FILE'
,p_message_text=>'Static Application File'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(221348628070546856)
,p_name=>'BU.AUTHENTICATION'
,p_message_text=>'Authentication Scheme'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1705784639370184)
,p_name=>'BU.AUTHENTICATION_SCHEMES'
,p_message_text=>'Authentication Schemes'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1705942926372075)
,p_name=>'BU.AUTHORIZATION'
,p_message_text=>'Authorization Scheme'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1411030306766457)
,p_name=>'BU.AUTOMATION'
,p_message_text=>'Automation'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1415809852150827)
,p_name=>'BU.BREADCRUMB'
,p_message_text=>'Breadcrumb'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1800452149872935)
,p_name=>'BU.BREADCRUMB_ENTRY'
,p_message_text=>'Breadcrumb Entry'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1800608675884821)
,p_name=>'BU.BREADCRUMB_TEMPLATE'
,p_message_text=>'Breadcrumb Template'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1702576502191183)
,p_name=>'BU.BUILD_OPTION'
,p_message_text=>'Build Option'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1801086392888364)
,p_name=>'BU.BUTTON_TEMPLATE'
,p_message_text=>'Button Template'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1800831101886798)
,p_name=>'BU.CALENDAR_TEMPLATE'
,p_message_text=>'Calendar Template'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(221347968561525146)
,p_name=>'BU.COMPONENTS'
,p_message_text=>'Components'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(555956116779069467)
,p_name=>'BU.COMPONENTS_DELETED'
,p_message_text=>'%0 Deleted'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(555955935742068251)
,p_name=>'BU.COMPONENTS_MODIFIED'
,p_message_text=>'%0 Modified'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(555955729562066674)
,p_name=>'BU.COMPONENTS_NEW'
,p_message_text=>'%0 New'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1706308531376863)
,p_name=>'BU.COMPONENT_SETTINGS'
,p_message_text=>'Component Settings'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1904044312400017)
,p_name=>'BU.CREDENTIAL'
,p_message_text=>'Credential'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1803412028916452)
,p_name=>'BU.DATA_LOAD'
,p_message_text=>'Data Loading'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1407453146331896)
,p_name=>'BU.DATA_PROFILE'
,p_message_text=>'Data Profile'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2313139677522393)
,p_name=>'BU.DELETED'
,p_message_text=>'%0 Deleted'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2313328296524005)
,p_name=>'BU.DEVELOPERS'
,p_message_text=>'Developers'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1706762033381926)
,p_name=>'BU.EMAIL_TEMPLATE'
,p_message_text=>'Email Template'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15119424933735656)
,p_name=>'BU.IN_PROGRESS'
,p_message_text=>'Application backup is in progress'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1801697184896745)
,p_name=>'BU.LABEL_TEMPLATE'
,p_message_text=>'Label Template'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(221383051921897436)
,p_name=>'BU.LAST_BACKUP'
,p_message_text=>'Last Backup: %0'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(221347660858522604)
,p_name=>'BU.LAST_UPDATE'
,p_message_text=>'Last Update: %0'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1420532879213215)
,p_name=>'BU.LEGACY_DATA_LOAD'
,p_message_text=>'Legacy Data Load'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1703030376215662)
,p_name=>'BU.LIST'
,p_message_text=>'List'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1801499221891834)
,p_name=>'BU.LIST_TEMPLATE'
,p_message_text=>'List Template'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15118804264729006)
,p_name=>'BU.LOCKED'
,p_message_text=>'Locked'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1704484605232781)
,p_name=>'BU.LOV'
,p_message_text=>'List of Values'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1707395869389595)
,p_name=>'BU.MESSAGE'
,p_message_text=>'Text Message'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1903474336341912)
,p_name=>'BU.MESSAGES'
,p_message_text=>'Messages'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2312941158520744)
,p_name=>'BU.MODIFIED'
,p_message_text=>'%0 Modified'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1705310654362575)
,p_name=>'BU.NAVBAR'
,p_message_text=>'Navigation Menu'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(221348437591531542)
,p_name=>'BU.NEW'
,p_message_text=>'%0 New'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1602009007294268)
,p_name=>'BU.PAGE'
,p_message_text=>'Page'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1800245353869748)
,p_name=>'BU.PAGES'
,p_message_text=>'Pages'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(555955545407065478)
,p_name=>'BU.PAGES_DELETED'
,p_message_text=>'%0 Deleted'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(555955369137063915)
,p_name=>'BU.PAGES_MODIFIED'
,p_message_text=>'%0 Modified'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(555955126547062456)
,p_name=>'BU.PAGES_NEW'
,p_message_text=>'%0 New'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1407664294338074)
,p_name=>'BU.PAGE_GROUP'
,p_message_text=>'Page Group'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1416435643150827)
,p_name=>'BU.PAGE_TEMPLATE'
,p_message_text=>'Page Template'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1416103393150827)
,p_name=>'BU.PARENT_TAB'
,p_message_text=>'Tab'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1704607495236865)
,p_name=>'BU.PLUGIN'
,p_message_text=>'Plug-in'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1802227132904581)
,p_name=>'BU.POPUP_LOV_TEMPLATE'
,p_message_text=>'LOV Template'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1916404152112587)
,p_name=>'BU.PWA_SCREENSHOT'
,p_message_text=>'PWA Screenshots'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1916233322110252)
,p_name=>'BU.PWA_SHORTCUT'
,p_message_text=>'PWA Shortcuts'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1801296798890058)
,p_name=>'BU.REGION_TEMPLATE'
,p_message_text=>'Region Template'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1707564312390578)
,p_name=>'BU.REMOTE_SERVER'
,p_message_text=>'REST Enabled SQL'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1904460144404383)
,p_name=>'BU.REMOTE_SERVERS'
,p_message_text=>'Remove Servers'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1803067191913247)
,p_name=>'BU.REPORT_LAYOUT'
,p_message_text=>'Report Layout'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1802894221911619)
,p_name=>'BU.REPORT_QUERY'
,p_message_text=>'Shared Query'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1802098701901459)
,p_name=>'BU.REPORT_TEMPLATE'
,p_message_text=>'Report Template'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184304869410158113)
,p_name=>'BU.RESTORED'
,p_message_text=>'Restored Application'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(11200636087663135)
,p_name=>'BU.RESTORED_DESCRIPTION'
,p_message_text=>'Application restored from backup revision %0'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1412035469105298)
,p_name=>'BU.SEARCH_CONFIG'
,p_message_text=>'Search Configuration'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2001769583937170)
,p_name=>'BU.SEARCH_CONFIGURATIONS'
,p_message_text=>'Search Configurations.'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1706528083378618)
,p_name=>'BU.SHORTCUT'
,p_message_text=>'Shortcut'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(13799188462677910)
,p_name=>'BU.SUMMARY_NOT_AVAILABLE'
,p_message_text=>'Change summary not available'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1801835672899545)
,p_name=>'BU.TAB'
,p_message_text=>'Tab'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1415531338150827)
,p_name=>'BU.TASK_DEFINITION'
,p_message_text=>'Task Definition'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1407946128350589)
,p_name=>'BU.TEMPLATE_COMPONENT'
,p_message_text=>'Template Component'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1704286023226770)
,p_name=>'BU.THEME'
,p_message_text=>'Theme'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1802629394909503)
,p_name=>'BU.TREE'
,p_message_text=>'Tree'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15119063214730172)
,p_name=>'BU.UNLOCKED'
,p_message_text=>'Unlocked'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1704048945223473)
,p_name=>'BU.USER_INTERFACES'
,p_message_text=>'User Interface Attributes'
,p_is_js_message=>true
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1706160616374005)
,p_name=>'BU.WEB_CREDENTIALS'
,p_message_text=>'Web Credentials'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1803234202915007)
,p_name=>'BU.WEB_SERVICE'
,p_message_text=>'Web Service'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1904278876401643)
,p_name=>'BU.WEB_SOURCE'
,p_message_text=>'REST Data Source'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1707119428385575)
,p_name=>'BU.WS_STATIC_FILE'
,p_message_text=>'Static Workspace File'
,p_version_scn=>37165770887604
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(7691925242338300)
,p_name=>'BUFFER CACHE'
,p_message_text=>'Buffer Cache'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(172902200721777965)
,p_name=>'BUG'
,p_message_text=>'Bug'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184179708585180614)
,p_name=>'BUGS'
,p_message_text=>'Bugs'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(191842801468313387)
,p_name=>'BUGS_ASSIGNED'
,p_message_text=>'bugs assigned'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(236539728609554422)
,p_name=>'BUGS_ASSIGNED_COUNT'
,p_message_text=>'Bugs Assigned'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(17736421345477258)
,p_name=>'BUGS_CLOSED'
,p_message_text=>'Bugs closed (%0 / %1):'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(496363927958523300)
,p_name=>'BUGS_PERCENT_CLOSED'
,p_message_text=>'Bugs percent closed (%0/%1):'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(236540021493557674)
,p_name=>'BUGS_UNASSIGNED_COUNT'
,p_message_text=>'Bugs Unassigned'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(236544023637571892)
,p_name=>'BUGS_WITHOUT_FIXBY'
,p_message_text=>'No Fix By Dates'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(496735400777253310)
,p_name=>'BUG_FEEDBACK_DASH'
,p_message_text=>'Bugs: %1 of %0 closed'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1036814214998182732)
,p_name=>'BUG_LABEL'
,p_message_text=>'Bug: %0'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(185507901218425453)
,p_name=>'BUILD QUERY'
,p_message_text=>'Build Query'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2301161452243484)
,p_name=>'BUILDER.CODE_LANGUAGE.JAVA'
,p_message_text=>'Java (MLE)'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2300933861242412)
,p_name=>'BUILDER.CODE_LANGUAGE.JAVASCRIPT'
,p_message_text=>'JavaScript (MLE)'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2300709255240747)
,p_name=>'BUILDER.CODE_LANGUAGE.PLSQL'
,p_message_text=>'PL/SQL'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2301309008244857)
,p_name=>'BUILDER.CODE_LANGUAGE.PYTHON'
,p_message_text=>'Python (MLE)'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2300584712239737)
,p_name=>'BUILDER.CODE_LANGUAGE.SQL'
,p_message_text=>'SQL'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(279427301631085873)
,p_name=>'BUILDER.PLUGINS'
,p_message_text=>'Plug-ins'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(275007606818926902)
,p_name=>'BUILDER.UNSUPPORTED_COMPONENT'
,p_message_text=>'[Unsupported]'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(484879007067195370)
,p_name=>'BUILDER_NOTIFICATION_MESSAGE'
,p_message_text=>'Workspace Message'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86867914216769358)
,p_name=>'BUILD_OPTION'
,p_message_text=>'Build Option'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(337598917473396386)
,p_name=>'BUILD_OPTION_LABEL'
,p_message_text=>'Build Option: %0'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1034832221991964130)
,p_name=>'BUILD_STATUS_LABEL'
,p_message_text=>'Build Status: %0'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(342012314841257514)
,p_name=>'BUILD_VERSION'
,p_message_text=>'Build Version'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(231303217767143013)
,p_name=>'BUILT_IN_REPORT_TEMPLATE'
,p_message_text=>'Built in Report Template'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(165836317894003951)
,p_name=>'BUTTON'
,p_message_text=>'button'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(324872079304916555)
,p_name=>'BUTTON.ADD'
,p_message_text=>'Add'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(10465811136933132)
,p_name=>'BUTTON.DA.INVALID.BUTTON_ATTR_CONTAIN_ID'
,p_message_text=>'The selected Button''s Button Attributes must not contain an ID'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(10465526804918707)
,p_name=>'BUTTON.DA.INVALID.NOT_DEFINED_BY_DA'
,p_message_text=>'The selected button must be a button with an Action set to ''Defined by Dynamic Action'''
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(10517831315345828)
,p_name=>'BUTTON.DA.INVALID.TEMPLATE_NO_BUTTON_ID'
,p_message_text=>'The selected button uses a ''Button Template'' that does not contain the #BUTTON_ID# substitution string'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(324871665525913142)
,p_name=>'BUTTON.DELETE'
,p_message_text=>'Delete'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(26585521658835522)
,p_name=>'BUTTON.INVALID.ACTION.REDIRECT_PAGE'
,p_message_text=>'Page must be specified.'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(23646206473246698)
,p_name=>'BUTTON.INVALID.ACTION.REPORT_QRY'
,p_message_text=>'Report Query must be specified.'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(22557715752175614)
,p_name=>'BUTTON.INVALID.ACTION.SOURCE'
,p_message_text=>'Button Request must be specified for all the Button Request Source Types, unless Button Request Source Type is "Always Null".'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(22641822294574881)
,p_name=>'BUTTON.INVALID.ACTION.SOURCE_TYPE'
,p_message_text=>'Button Request Source Type must be specified.'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(26585724775836349)
,p_name=>'BUTTON.INVALID.ACTION.URL_TARGET'
,p_message_text=>'URL Target must be specified.'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(11131426025055486)
,p_name=>'BUTTON.INVALID.BUTTON_ATTR_HAS_ID_WHEN_DA'
,p_message_text=>'When the Action is ''Defined by Dynamic Action'', the Button Attributes must not contain an ID'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(27028915636625079)
,p_name=>'BUTTON.INVALID.STYLE.IMAGE'
,p_message_text=>'Image must be specified.'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(27029127757628555)
,p_name=>'BUTTON.INVALID.STYLE.NO_STYLE'
,p_message_text=>'Style must be specified.'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(27027908710623121)
,p_name=>'BUTTON.INVALID.STYLE.TEMPLATE'
,p_message_text=>'Template must be specified.'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(11128929433952372)
,p_name=>'BUTTON.INVALID.TEMPLATE_NO_BUTTON_ID_WHEN_DA'
,p_message_text=>'When the Button Style is ''Template Based Button'' and Action is ''Defined by Dynamic Action'', the selected Button Template must contain the #BUTTON_ID# substitution string'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(6700327932133912)
,p_name=>'BUTTON.INVALID_DELETE.REFERENCED_BY.DA_AFFECTED_ELEMENT'
,p_message_text=>'Button cannot be deleted because it is referenced in a Dynamic Action (Page: %0, Dynamic Action: ''%1'', Action: ''%2'', Attribute: ''Affected Element'').'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(6699904678099115)
,p_name=>'BUTTON.INVALID_DELETE.REFERENCED_BY.DA_WHEN'
,p_message_text=>'Button cannot be deleted because it is referenced in a Dynamic Action (Page: %0, Dynamic Action: ''%1'', Attribute: ''When'').'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(324871850640915087)
,p_name=>'BUTTON.SUBMIT'
,p_message_text=>'Submit'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(313215230634932044)
,p_name=>'BUTTON.TEMPLATE.JAVASCRIPT'
,p_message_text=>'To be used in an "onclick" attribute'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(320371216069176796)
,p_name=>'BUTTON.TEMPLATE.LINK'
,p_message_text=>'To be used in an "href" attribute'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1909996074231882)
,p_name=>'BUTTON.TEMPLATE.ONCLICK'
,p_message_text=>'Indicates that the button has an onclick event with JavaScript code, which will be included in a script tag at the bottom of the page.'
,p_version_scn=>78664300
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(26575631804308135)
,p_name=>'BUTTONS'
,p_message_text=>'Buttons'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(195521424962048000)
,p_name=>'BUTTON_ATTRIBUTES'
,p_message_text=>'Button Attributes'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1034739606398883849)
,p_name=>'BUTTON_LABEL'
,p_message_text=>'Button: %0'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1722407472733113)
,p_name=>'BUTTON_NAME'
,p_message_text=>'Button Name'
,p_version_scn=>38408921
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(200661619685415091)
,p_name=>'BUTTON_TEMPLATE'
,p_message_text=>'Button Template'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(26057215633754454)
,p_name=>'BYTES'
,p_message_text=>'bytes'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(172768215323486103)
,p_name=>'BY_NEXT_PATCH'
,p_message_text=>'By next patch'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(172768419133487142)
,p_name=>'BY_NEXT_RELEASE'
,p_message_text=>'By next release'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922460531074056574)
,p_name=>'CA.ABOUT'
,p_message_text=>'About'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2645711118768334914)
,p_name=>'CA.ABOUT.PAGE'
,p_message_text=>'About Page'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2645703065337281803)
,p_name=>'CA.ABOUT.PAGE.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Include an about this application page which features a description of the application, the application version, and a page count.',
'</p>'))
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84023937671947678)
,p_name=>'CA.ABOUT.PAGE.HELP.CONTENT.CONTAINER'
,p_message_text=>'Content Container'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922460986216066186)
,p_name=>'CA.ABOUT.THIS.APPLICATION'
,p_message_text=>'About Page'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922461179966070662)
,p_name=>'CA.ABOUT.THIS.APPLICATION.DESC'
,p_message_text=>'Text about this application can be placed here.'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922460399157049710)
,p_name=>'CA.ABOUT.THIS.PAGE'
,p_message_text=>'About this Page'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3108275218294181249)
,p_name=>'CA.ABOUT.THIS.PREVIEW.RELEASE'
,p_message_text=>'About this preview release'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(52067345260651933)
,p_name=>'CA.ACCESS.CANNOT_REMOVE_YOURSELF_FROM_ADMIN'
,p_message_text=>'Cannot remove yourself from administrator'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(52067196448634533)
,p_name=>'CA.ACCESS.CANNOT_REMOVE_YOURSELF_FROM_ADMIN_MSG'
,p_message_text=>'You cannot remove administrator role from yourself.'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2646689428037471242)
,p_name=>'CA.ACCESS.CONTROL'
,p_message_text=>'Access Control'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2936352154493906864)
,p_name=>'CA.ACCESS.CONTROL.ACTIONS'
,p_message_text=>'Access Control Actions'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921862982160185411)
,p_name=>'CA.ACCESS.CONTROL.CONFIGURATION'
,p_message_text=>'Access Control Configuration'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2621197543015395554)
,p_name=>'CA.ACCESS.CONTROL.DESC'
,p_message_text=>'Enable role-based user authorization'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2646691137910499236)
,p_name=>'CA.ACCESS.CONTROL.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Incorporate role based user authentication within your application.',
'Users can be defined as Administrators, Contributors, or Readers.',
'You can then readily define different access to different roles for various components throughout your application, such as pages, menu entries, regions, columns, items, buttons and so forth.</p>',
'<p>Includes the following components:',
'<ul>',
'<li>Administrative page region with links to access control features</li>',
'<li>Users table to manage access control</li>',
'<li>Configuration page to set access level of authenticated users</li>',
'<li>Configuration page to specify if usernames are email addresses or not</li>',
'<li>Manage users access page to report and edit user access</li>',
'<li>Add user page with ability to add a single user</li>',
'<li>Add multiple users page with ability to add multiple users (email usernames only)</li>',
'</ul>',
'</p>'))
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921457360963067999)
,p_name=>'CA.ACCESS.ROLE'
,p_message_text=>'Role'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921458928124083758)
,p_name=>'CA.ACCESS.ROLE.ID'
,p_message_text=>'Access Role ID'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(40777121249534403)
,p_name=>'CA.ACCESS.ROLES'
,p_message_text=>'Roles'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921457568177069383)
,p_name=>'CA.ACCOUNT.LOCKED'
,p_message_text=>'Account Locked'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(51097352111856095)
,p_name=>'CA.ACKNOWLEDGED'
,p_message_text=>'Acknowledged'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2936348073694895278)
,p_name=>'CA.ACL.INFORMATION'
,p_message_text=>'ACL Information'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2939101723648525336)
,p_name=>'CA.ACL.NOT.ADMIN'
,p_message_text=>'Insufficient privileges, user is not an Administrator'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2939101924183534294)
,p_name=>'CA.ACL.NOT.AUTHORIZED'
,p_message_text=>'You are not authorized to view this application, either because you have not been granted access, or your account has been locked. Please contact the application administrator.'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2939102140061539543)
,p_name=>'CA.ACL.NOT.CONTRIBUTOR'
,p_message_text=>'Insufficient privileges, user is not a Contributor'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922000798241226929)
,p_name=>'CA.ACL.SAVED'
,p_message_text=>'Access Control settings saved.'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922444182764816692)
,p_name=>'CA.ACTION.BUTTON.HTML'
,p_message_text=>'Action Button HTML'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922438254857756049)
,p_name=>'CA.ACTION.LABEL'
,p_message_text=>'Action Label'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922438458821758338)
,p_name=>'CA.ACTION.LINK'
,p_message_text=>'Action Link'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922457162389968680)
,p_name=>'CA.ACTION.LINK.HTML'
,p_message_text=>'Action Link HTML'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921391448582703368)
,p_name=>'CA.ACTION.PROCESSED'
,p_message_text=>'Action Processed.'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921454434670019772)
,p_name=>'CA.ACTIVITY.BY.HOUR'
,p_message_text=>'Activity by Hour'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3431138782265996762)
,p_name=>'CA.ACTIVITY.DASHBOARD'
,p_message_text=>'Activity Dashboard'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2646811269044516004)
,p_name=>'CA.ACTIVITY.REPORTING'
,p_message_text=>'Activity Reporting'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2621235814173596267)
,p_name=>'CA.ACTIVITY.REPORTING.DESC'
,p_message_text=>'Include user activity and error reports'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2646812353061526776)
,p_name=>'CA.ACTIVITY.REPORTING.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Include numerous reports on end user activity for your application. Determine the most active users, the most used pages, the performance of pages, and errors raised, to better understand how your application is being utilized and areas for improv'
||'ement.</p>',
'<p>Includes the following:',
'<ul>',
'<li>Top Users report</li>',
'<li>Application Error Log report</li>',
'<li>Page Performance, activity and performance by page</li>',
'<li>Application activity by page report</li>',
'<li>Page Views detail report</li>',
'',
'</ul>',
'</p>'))
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184722752668855322)
,p_name=>'CA.ACTUAL.START.DATE'
,p_message_text=>'Actual Start Date'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2936347375766890525)
,p_name=>'CA.ADD'
,p_message_text=>'Add'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922445037810823657)
,p_name=>'CA.ADD.EMAIL.TEMPLATE'
,p_message_text=>'Add Email Template'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3207348376277304563)
,p_name=>'CA.ADD.MULTI.USERS.STEP.2'
,p_message_text=>'Add Multiple Users - Step 2'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2928845970974696196)
,p_name=>'CA.ADD.NEW.WIDGET'
,p_message_text=>'Add New %0'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921243212875092122)
,p_name=>'CA.ADD.NOTIFICATION'
,p_message_text=>'Add Notification'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(727736448010205713)
,p_name=>'CA.ADD.PAGE'
,p_message_text=>'Add Page'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921459160717086449)
,p_name=>'CA.ADD.USER'
,p_message_text=>'Add User'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3207350475634336341)
,p_name=>'CA.ADD.USERS'
,p_message_text=>'Add Users'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2647110565840280585)
,p_name=>'CA.ADDING.PAGES'
,p_message_text=>'Adding Pages'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2647115246828353695)
,p_name=>'CA.ADDING.PAGES.DETAIL'
,p_message_text=>'<p>Click <strong>Add Page</strong> to add a page to your application. Then, select a page type (such as Blank, Chart, Form, Report, and so on) and define its attributes. You may also need to specify a valid table or view or use SQL Workshop to prepar'
||'e database objects in your workspace.</p>'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922455409080934735)
,p_name=>'CA.ADDITIONAL.HTML.TEMPLATES'
,p_message_text=>'Advanced'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184716749547844868)
,p_name=>'CA.ADDITIONAL.INFO'
,p_message_text=>'Additional Information'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921458512102079691)
,p_name=>'CA.ADDRESS'
,p_message_text=>'Address'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717719947844869664)
,p_name=>'CA.ADMIN.ACCESS.CONTROL'
,p_message_text=>'Access Control'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717723416783887135)
,p_name=>'CA.ADMIN.ACCESS.CONTROL.DESC'
,p_message_text=>'Change access control settings and disable access control'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717555357248833976)
,p_name=>'CA.ADMIN.ACTIVITY.REPORTS'
,p_message_text=>'Activity Reports'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717720390087870685)
,p_name=>'CA.ADMIN.ADD'
,p_message_text=>'Add'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717729259651943829)
,p_name=>'CA.ADMIN.ADMINISTRATION'
,p_message_text=>'Administration'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717721582582875378)
,p_name=>'CA.ADMIN.ADMINISTRATORS'
,p_message_text=>'Administrators'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(218159415342551405)
,p_name=>'CA.ADMIN.APP.CONFIGURATION'
,p_message_text=>'Application Configuration'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(306458550608649433)
,p_name=>'CA.ADMIN.APP.USER_INTERFACE'
,p_message_text=>'User Interface'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3019487861416921306)
,p_name=>'CA.ADMIN.APPLICATION.ADMINISTRATION'
,p_message_text=>'Application Administration'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3019490170988923820)
,p_name=>'CA.ADMIN.APPLICATION.ADMINISTRATION.DESC'
,p_message_text=>'Manage component'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717553734035817062)
,p_name=>'CA.ADMIN.APPLICATION.APPEARANCE'
,p_message_text=>'Theme Style Selection'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717554215113824357)
,p_name=>'CA.ADMIN.APPLICATION.APPEARANCE.DESC'
,p_message_text=>'Set the default application look and feel'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717552658117808643)
,p_name=>'CA.ADMIN.APPLICATION.CONFIGURATION.OPTIONS'
,p_message_text=>'Configuration Options'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717552297279805154)
,p_name=>'CA.ADMIN.APPLICATION.CONFIGURATION.OPTIONS.DESC'
,p_message_text=>'Enable or disable application features'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717556275937838498)
,p_name=>'CA.ADMIN.APPLICATION.ERROR.LOG'
,p_message_text=>'Application Error Log'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717716478535842068)
,p_name=>'CA.ADMIN.APPLICATION.ERROR.LOG.DESC'
,p_message_text=>'Report of errors logged by this application'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717554498319826140)
,p_name=>'CA.ADMIN.APPLICATION.SETTINGS'
,p_message_text=>'Application Settings'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717554945167831899)
,p_name=>'CA.ADMIN.APPLICATION.SETTINGS.DESC'
,p_message_text=>'Set application name and short description'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717553237079811577)
,p_name=>'CA.ADMIN.APPLICATION.UPDATES'
,p_message_text=>'Application Updates'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717553533218813726)
,p_name=>'CA.ADMIN.APPLICATION.UPDATES.DESC'
,p_message_text=>'Maintain the list of application updates'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717547491399784980)
,p_name=>'CA.ADMIN.CONFIGURATION'
,p_message_text=>'Configuration'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717721396161874155)
,p_name=>'CA.ADMIN.CONTRIBUTORS'
,p_message_text=>'Contributors'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3392601437263297482)
,p_name=>'CA.ADMIN.DASHBOARD'
,p_message_text=>'Dashboard'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3392590633246194854)
,p_name=>'CA.ADMIN.DASHBOARD.DESC'
,p_message_text=>'View application activity metrics'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2722746696365755572)
,p_name=>'CA.ADMIN.DEFAULT.TZ'
,p_message_text=>'Default Time Zone'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2722746819091756827)
,p_name=>'CA.ADMIN.DEFAULT.TZ.DESC'
,p_message_text=>'Set the default time zone for this application'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717725912407903634)
,p_name=>'CA.ADMIN.EMAIL'
,p_message_text=>'Email'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2722747909848810687)
,p_name=>'CA.ADMIN.EMAIL.SETTINGS'
,p_message_text=>'Email Settings'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2722748121389812242)
,p_name=>'CA.ADMIN.EMAIL.SETTINGS.DESC'
,p_message_text=>'Set if email should be sent and if so, who reply to should be'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717723695986888474)
,p_name=>'CA.ADMIN.FEEDBACK'
,p_message_text=>'Feedback'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717725181560895461)
,p_name=>'CA.ADMIN.FEEDBACK.SETTINGS'
,p_message_text=>'Feedback Settings'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717725523559899912)
,p_name=>'CA.ADMIN.FEEDBACK.SETTINGS.DESC'
,p_message_text=>'Manage if attachments should be allowed.'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717723847939889886)
,p_name=>'CA.ADMIN.MANAGE.FEEDBACK'
,p_message_text=>'User Feedback'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717724817879894153)
,p_name=>'CA.ADMIN.MANAGE.FEEDBACK.DESC'
,p_message_text=>'Report of all feedback submitted by application users'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717726183260905316)
,p_name=>'CA.ADMIN.MANAGE.TEMPLATES'
,p_message_text=>'Email Templates'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717726618186923296)
,p_name=>'CA.ADMIN.MANAGE.TEMPLATES.DESC'
,p_message_text=>'Manage email template HTML and CSS used by this application'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717548659596787143)
,p_name=>'CA.ADMIN.NOTIFICATIONS'
,p_message_text=>'Notifications'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717550305849793439)
,p_name=>'CA.ADMIN.NOTIFICATIONS.DESC'
,p_message_text=>'Display notifications on the home page'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3035872367426225072)
,p_name=>'CA.ADMIN.PAGE'
,p_message_text=>'Administration Page'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(729541870126076153)
,p_name=>'CA.ADMIN.PAGE.AUTOMATIONS.LOG'
,p_message_text=>'Automations Log'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(729545027816133501)
,p_name=>'CA.ADMIN.PAGE.AUTOMATIONS.LOG.DESC'
,p_message_text=>'Report of automation executions and messages logged by this application'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717717207875843699)
,p_name=>'CA.ADMIN.PAGE.PERFORMANCE'
,p_message_text=>'Page Performance'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717719105964859008)
,p_name=>'CA.ADMIN.PAGE.PERFORMANCE.DESC'
,p_message_text=>'Report of activity and performance by application page'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717719385461860347)
,p_name=>'CA.ADMIN.PAGE.VIEWS'
,p_message_text=>'Page Views'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717719758392867742)
,p_name=>'CA.ADMIN.PAGE.VIEWS.DESC'
,p_message_text=>'Report of each page view by user including date of access and elapsed time'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717721161023872634)
,p_name=>'CA.ADMIN.READERS'
,p_message_text=>'Readers'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3310571738092096812)
,p_name=>'CA.ADMIN.SEND.EMAIL'
,p_message_text=>'Send Email'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3310572131363099669)
,p_name=>'CA.ADMIN.SEND.EMAIL.DESC'
,p_message_text=>'Send template based email from this application'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717555596528834943)
,p_name=>'CA.ADMIN.TOP.USERS'
,p_message_text=>'Top Users'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717555811498837126)
,p_name=>'CA.ADMIN.TOP.USERS.DESC'
,p_message_text=>'Report of page views aggregated by user'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717720726482871503)
,p_name=>'CA.ADMIN.USERS'
,p_message_text=>'Users'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717723231890882455)
,p_name=>'CA.ADMIN.USERS.DESC'
,p_message_text=>'Set level of access for authenticated users of this application'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717726827352924308)
,p_name=>'CA.ADMIN.VIEW.LOG'
,p_message_text=>'Email Log'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717727766757934617)
,p_name=>'CA.ADMIN.VIEW.LOG.DESC'
,p_message_text=>'View log of emails sent by this application'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(110372878183239212)
,p_name=>'CA.ADVANCED'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
' <li><strong>Advanced</strong> - Expand to see advanced options.',
'    <ul>',
'      <li><strong>Set as Home Page</strong> - Make this page the home page for the application.<br>',
'      &nbsp;&nbsp;&nbsp;Any page previously defined as the home page will be updated.</li>',
'      <li><strong>Set as Administration Page</strong> - Add this page under Administration, rather than as a normal page in the application. Access by clicking Administration in the main menu and then selecting it the Application Administration list.'
||'<br>',
'        <em><strong>Note:</strong> A page cannot be both a Home page and a page under Administration.</em></li>',
'      &nbsp;<br>',
'      <li><strong>Page Help</strong> - Enter text to be added to the Help Text for the page.</li>',
'    </ul>',
'  </li>',
'</ul>'))
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(64584832806113113)
,p_name=>'CA.ADVANCED.PAGE_HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
' <li><strong>Advanced</strong> - Expand to see advanced options.',
'    <ul>',
'      <li><strong>Page Help</strong> - Enter text to be added to the Help Text for the page.</li>',
'    </ul>',
'  </li>',
'</ul>'))
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3052392383106533190)
,p_name=>'CA.ADVANCED.SETTINGS'
,p_message_text=>'Advanced Settings'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3052392567103548693)
,p_name=>'CA.ADVANCED.SETTINGS.DETAIL'
,p_message_text=>'<p>Set additional definition, security and globalization settings.  These settings can be applied when creating the application, and can also be edited post application creation.</p>'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3092808948029652851)
,p_name=>'CA.ADVANCED.SETTINGS.PAGE'
,p_message_text=>'<p>Read the item help ( <span class="fa fa-question-circle" aria-hidden="true"></span> ) for each setting for more information.</p>'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3320760499135365754)
,p_name=>'CA.AFTER.ROWS'
,p_message_text=>'After Rows'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922443838328813787)
,p_name=>'CA.AFTER.ROWS.HTML'
,p_message_text=>'After Rows HTML'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2928144744429905785)
,p_name=>'CA.ALL.COLS'
,p_message_text=>'All Columns'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922438636653760184)
,p_name=>'CA.ALLOW.OPT.OUT'
,p_message_text=>'Allow Opt Out'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184691704616764705)
,p_name=>'CA.ALLOW.RUNS.IN.RESTRICTED.MODE'
,p_message_text=>'Allow Runs in Restricted Mode'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921453849792975963)
,p_name=>'CA.APP.ERROR.LOG'
,p_message_text=>'Application Error Log'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921400527629957834)
,p_name=>'CA.APP.NAME'
,p_message_text=>'Application Name'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(233821681918498873)
,p_name=>'CA.APP.SETTING.ACL_ENABLED.DESC'
,p_message_text=>'Whether access control is turned on or not'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(233821822833504115)
,p_name=>'CA.APP.SETTING.ACL_SCOPE.DESC'
,p_message_text=>'The default access level given to authenticated users who are not in the access control list'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921401775764976317)
,p_name=>'CA.APP.SETTINGS.UPDATED'
,p_message_text=>'Application settings updated.'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921400908323967781)
,p_name=>'CA.APP.SUBTITLE'
,p_message_text=>'Short Description'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921401599826971628)
,p_name=>'CA.APP.SUBTITLE.HELP'
,p_message_text=>'The text entered here is displayed under the application name on the home page of the application.'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2731729267645868096)
,p_name=>'CA.APPEARANCE'
,p_message_text=>'Appearance'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2731729722265875812)
,p_name=>'CA.APPEARANCE.DESC'
,p_message_text=>'<p>Define the default application color scheme (theme style), where the navigation is located, and the icon used for the application.</p>'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922385481311487392)
,p_name=>'CA.APPLICATION'
,p_message_text=>'Application'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921186348271773302)
,p_name=>'CA.APPLICATION.APPEARANCE'
,p_message_text=>'Application Appearance'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2731730776907899030)
,p_name=>'CA.APPLICATION.ICON'
,p_message_text=>'Application Icon'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2731730993846908989)
,p_name=>'CA.APPLICATION.ICON.DETAIL'
,p_message_text=>'<p>Click <strong>Choose New Icon</strong> to select the icon color and one of the available icons. Your selection displays on the home page of the application.</p>'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2731732224492951587)
,p_name=>'CA.APPLICATION.ID'
,p_message_text=>'Application ID'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2731732489462955168)
,p_name=>'CA.APPLICATION.ID.DETAIL'
,p_message_text=>'<p>Enter a unique, numeric identifier for your application. This field contains an automatically generated identifier by default.</p>'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922429791141503646)
,p_name=>'CA.APPLICATION.PAGE'
,p_message_text=>'Application Page'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921423639339335319)
,p_name=>'CA.APPLICATION.SESSIONS'
,p_message_text=>'Application Sessions'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2645716370102357080)
,p_name=>'CA.APPLICATION.SETTINGS'
,p_message_text=>'Application Settings'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2621227754822543935)
,p_name=>'CA.APPLICATION.SETTINGS.DESC'
,p_message_text=>'Set application name and short description'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2645718519823378422)
,p_name=>'CA.APPLICATION.SETTINGS.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Allow application administrators to update various settings such as the application name and a description, default time zone and so forth.</p>',
'<p>Includes the following components:',
'<ul>',
'<li>Administrative page list entry and form</li>',
'<li>Ability to set application name</li>',
'<li>Ability to set home page hero region subtitle</li>',
'<li>Ability to set feedback recipients if using feedback</li>',
'<li>Ability to set application default time zone</li>',
'</ul>',
'</p>'))
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390027690448893810)
,p_name=>'CA.APPLICATIONITEM'
,p_message_text=>'Application Item'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3408615440855126793)
,p_name=>'CA.APPLY'
,p_message_text=>'Apply'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3624523424892738244)
,p_name=>'CA.APPLY.APP.DEFAULTS'
,p_message_text=>'Applying application defaults'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2920367821485526287)
,p_name=>'CA.APPLY.CHANGES'
,p_message_text=>'Apply Changes'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3405575241848661420)
,p_name=>'CA.APPLY.FILTERS'
,p_message_text=>'Apply Filters'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(304994381923568234)
,p_name=>'CA.APP_BANNER'
,p_message_text=>'Application created from create application wizard %0.'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(305939287495202897)
,p_name=>'CA.APP_SETTING.SAVE'
,p_message_text=>'Save Setting'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3803963485747413355)
,p_name=>'CA.ATTACHMENT'
,p_message_text=>'Attachment'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(129922908435085660)
,p_name=>'CA.ATTACHMENT.COUNT'
,p_message_text=>'Attachment Count'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3804208091347651202)
,p_name=>'CA.ATTACHMENT.NAME'
,p_message_text=>'Attachment Name'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(129922795760084322)
,p_name=>'CA.ATTACHMENT.SIZE'
,p_message_text=>'Attachment Size'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3414637955199571242)
,p_name=>'CA.ATTR.DEFAULT.DUPLICATE'
,p_message_text=>'Attribute Defaults already defined for this %0.'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921926912899196438)
,p_name=>'CA.AUTH.USER.MAY.ACCESS'
,p_message_text=>'Any authenticated user may access this application'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2731733847212007055)
,p_name=>'CA.AUTHENTICATION'
,p_message_text=>'Authentication'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2731734047687010010)
,p_name=>'CA.AUTHENTICATION.DETAIL'
,p_message_text=>'<p>Select how you want users to authenticate into your application.</p>'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184700898371810810)
,p_name=>'CA.AUTO.DROP'
,p_message_text=>'Auto Drop'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(729550481316258092)
,p_name=>'CA.AUTOMATION_EXECUTION'
,p_message_text=>'Automation Execution'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921449510700926462)
,p_name=>'CA.AVG.ELAPSED'
,p_message_text=>'Avg Elapsed'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(230792902824132322)
,p_name=>'CA.BACK.TO.JOBS.REPORT'
,p_message_text=>'Back to Jobs Report'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(129924690458096670)
,p_name=>'CA.BCC'
,p_message_text=>'BCC'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3320760221853364271)
,p_name=>'CA.BEFORE.ROWS'
,p_message_text=>'Before Rows'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922443528620807726)
,p_name=>'CA.BEFORE.ROWS.HTML'
,p_message_text=>'Before Rows HTML'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922456491173956711)
,p_name=>'CA.BEGIN.ROW.TEMPLATE'
,p_message_text=>'Before Rows Content'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2720804498703514355)
,p_name=>'CA.BLANK'
,p_message_text=>'Add Blank Page'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2720808457568539034)
,p_name=>'CA.BLANK.DETAILS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Create a blank page as a placeholder. Once you create the application, you can readily create regions on the page from Page Designer.</p>',
'<p>Enter the following attributes:</p>',
'<ul>',
'  <li><strong>Page Name</strong> (Mandatory) - Enter a name for this page.</li>',
'  <li><strong>Set Icon</strong> - Select an icon to display in the navigation menu for this page.</li>',
'<!--  <li><strong>Include Page Navigation</strong> - Check this option to display a card list of all other pages defined in your application.<br>',
'      &nbsp;&nbsp;&nbsp;This option is typically used on your application home page.</li>',
'-->',
'</ul>'))
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3021697125256794594)
,p_name=>'CA.BLUEPRINT'
,p_message_text=>'Application Blueprint'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3021697330957833605)
,p_name=>'CA.BLUEPRINT.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>The blueprint lists the application definition in JSON format.</p>',
'<p>When first entering this screen, the current application definition is transformed into a JSON document and displayed. You can edit the document to update application properties, and then click <strong>Apply Blueprint</strong> to change the curren'
||'t application details.</p>',
'<p>&nbsp;</p>',
'<p>If you need to create a large number of similar pages, copying the relevant JSON code for one page and pasting numerous times, and making small adjustments to the JSON, is significantly quicker than manually using the <strong>Add Page</strong> for'
||' each page.</p>',
'<p>Click <strong>Load a Previous Blueprint</strong> to replace the blueprint with the definition from a previously generated application. In this way you can very easily iterate an application design by adding additional pages, changing the features,'
||' or tweaking the settings, before generating the application again.</p>',
''))
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922437002669748757)
,p_name=>'CA.BODY1.TEXT'
,p_message_text=>'Body1 Text'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922438006633753421)
,p_name=>'CA.BODY2.TEXT'
,p_message_text=>'Body2 Text'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3350902159699397964)
,p_name=>'CA.BOTH'
,p_message_text=>'Both'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921193976387893274)
,p_name=>'CA.BRANCH.TO.ADMIN'
,p_message_text=>'Branch to Admin Page'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(109844703095809152)
,p_name=>'CA.BUTTON.BAR'
,p_message_text=>'Button Bar'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921187467439787711)
,p_name=>'CA.BUTTONS'
,p_message_text=>'Buttons'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2722694106915896175)
,p_name=>'CA.CALENDAR'
,p_message_text=>'Add Calendar Page'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2722694311431897355)
,p_name=>'CA.CALENDAR.DETAILS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Create a page which displays a calendar.</p>',
'<p>Enter the following attributes:</p>',
'<ul>',
'  <li><strong>Page Name</strong> (Mandatory) - Enter a name for this page.</li>',
'  <li><strong>Set Icon</strong> - Select an icon to display in the navigation menu for this page.</li>',
'  <li><strong>Table or View</strong> (Mandatory) - Select the database object for the calendar.</li>',
'  <li><strong>Display Column</strong> (Mandatory) - Select the column from the table or view to display in the calendar events.</li>',
'  <li><strong>Start Date Column</strong> (Mandatory) - Select the date column from the table or view to use as the start date for calendar events.</li>',
'  <li><strong>End Date Column</strong> - Select the date column from the table or view to use as the end date for calendar events.<br>',
'      &nbsp;&nbsp;&nbsp;If End Date is specified then duration based events will be displayed. </li>',
'  <li><strong>Show Time</strong> - Select <strong>Yes</strong> to show the time portion for events and also enable the Weekly and Daily calendar views. Select <strong>No</strong> to only show the dates for events.</li>',
'  </ul>'))
,p_version_scn=>14498668
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2920367133497520875)
,p_name=>'CA.CANCEL'
,p_message_text=>'Cancel'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921195282534923399)
,p_name=>'CA.CANCEL.DIALOG'
,p_message_text=>'Cancel Dialog'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(106119627586788824)
,p_name=>'CA.CANCEL.MODAL'
,p_message_text=>'Cancel Modal'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922005558903296781)
,p_name=>'CA.CANNOT.REMOVE.ADMIN.RIGHTS'
,p_message_text=>'You cannot remove administration rights from your own record.'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3471170273687779427)
,p_name=>'CA.CARD'
,p_message_text=>'Add Card Page'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3471170009562777626)
,p_name=>'CA.CARD.DETAILS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Create a page which displays cards.</p>',
'<p>Enter the following attributes:</p>',
'<ul>',
'  <li><strong>Page Name</strong> (Mandatory) - Enter a name for this page.</li>',
'  <li><strong>Set Icon</strong> - Select an icon to display in the navigation menu for this page.</li>',
'  <li><strong>Table or View</strong> (Mandatory) - Select the database object for the card.</li>',
'  <li><strong>Card Title</strong> (Mandatory) - Select the column from the table or view to use as the title for the card.</li>',
'  <li><strong>Description Column</strong> (Mandatory) - Select the column from the table or view to use as the description for the card.</li>',
'  <li><strong>Additional Text Column</strong> - Select the column from the table or view to use as the secondary description for the card.</li>',
'</ul>'))
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3404904849331246267)
,p_name=>'CA.CARDS'
,p_message_text=>'Cards'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3405070856175412381)
,p_name=>'CA.CARDS.VIEW'
,p_message_text=>'Cards View'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(129924807358097534)
,p_name=>'CA.CC'
,p_message_text=>'CC'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(305933134724073997)
,p_name=>'CA.CHANGE_FILTERS'
,p_message_text=>'Change Filters'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2720772664103393591)
,p_name=>'CA.CHART'
,p_message_text=>'Add Chart Page'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2720792603908461083)
,p_name=>'CA.CHART.DETAILS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Create a page which displays either an area, bar, line, or pie chart.</p>',
'<p>Enter the following attributes:</p>',
'<ul>',
'  <li><strong>Page Name</strong> (Mandatory) - Enter a name for this page.</li>',
'  <li><strong>Set Icon</strong> - Select an icon to display in the navigation menu for this page.</li>',
'  <li><strong>Chart Type</strong> - Select the type of chart to display [<strong>Area</strong>, <strong>Bar</strong>, <strong>Line</strong>, <strong>Pie</strong>].</li>',
'  <li><strong>Table or View</strong> (Mandatory) - Select the database object for the chart.</li>',
'  <li><strong>Label Column</strong> (Mandatory) - Select the column from the table or view to use as the label for the chart.</li>',
'  <li><strong>Value Aggregation</strong> - Select how the value column should be displayed or aggregated<br>',
'      &nbsp;&nbsp;&nbsp;[Column Value, Sum, Count].</li>',
'  <li><strong>Value Column</strong> (Mandatory) - Select a numeric column from the table or view which is used to calculate the chart values displayed.</li>',
'</ul>'))
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2722683176199660378)
,p_name=>'CA.CHART.EXAMPLES'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<h3>Examples</h3>',
'<p>Review the examples for how to utilize the different <strong>Summarization</strong> types:</p>',
'<p><strong>Example 1:</strong> Display a chart on Employees with the manager''s employee number for each employee.',
'<code><ul>',
'  <li>Table or View - Select EMP.</li>',
'  <li>Label Column - Select ENAME.</li>',
'  <li>Summarization - Select <u><strong>Column Value</strong></u>.</li>',
'  <li>Value Column - Select MGR.</li>',
'</ul></code>',
'</p>',
'<p><strong>Example 2:</strong> Display a chart on Employees with the total salary for each job.',
'<code><ul>',
'  <li>Table or View - Select EMP.</li>',
'  <li>Label Column - Select JOB.</li>',
'  <li>Summarization - Select <u><strong>Sum</strong></u>.</li>',
'  <li>Value Column - Select SAL.</li>',
'</ul></code>',
'</p>',
'<p><strong>Example 3:</strong> Display a chart on Employees with the number of employees in each department.',
'<code><ul>',
'  <li>Table or View - Select EMP.</li>',
'  <li>Label Column - Select DEPTNO.</li>',
'  <li>Summarization - Select <u><strong>Count</strong></u>.</li>',
'  <li>Value Column - Select EMPNO.</li>',
'</ul></code>',
'</p>'))
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184711409013830011)
,p_name=>'CA.CLIENT.ID'
,p_message_text=>'Client ID'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3931848816964656859)
,p_name=>'CA.CLOSE'
,p_message_text=>'Close'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(51097114481854864)
,p_name=>'CA.CLOSED'
,p_message_text=>'Closed'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3628834624970853082)
,p_name=>'CA.COLUMN'
,p_message_text=>'Column'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2935898713692867147)
,p_name=>'CA.COLUMN.1'
,p_message_text=>'Column 1'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2935898929609870618)
,p_name=>'CA.COLUMN.2'
,p_message_text=>'Column 2'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921451907304958627)
,p_name=>'CA.COLUMN.ALIAS'
,p_message_text=>'Column Alias'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390026801759883432)
,p_name=>'CA.COMMENTS'
,p_message_text=>'Comments'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921418031609203832)
,p_name=>'CA.COMPONENT.NAME'
,p_message_text=>'Component Name'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921861447729181071)
,p_name=>'CA.CONFIG.ACCESS.CONTROL'
,p_message_text=>'Configure Access Control'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921189270060793987)
,p_name=>'CA.CONFIG.APPEARANCE'
,p_message_text=>'Configure Appearance'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921191411900800568)
,p_name=>'CA.CONFIG.APPEARANCE.DESC'
,p_message_text=>'<p>The appearance of your application is defined by the Theme Style.</p>'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921397652305911899)
,p_name=>'CA.CONFIG.OPTION.UPDATED'
,p_message_text=>'Configuration Options updated. '
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2646825012651935509)
,p_name=>'CA.CONFIGURATION.SETTINGS'
,p_message_text=>'Configuration Options'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2621234057644591678)
,p_name=>'CA.CONFIGURATION.SETTINGS.DESC'
,p_message_text=>'Enable or disable application features'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2646825268230950532)
,p_name=>'CA.CONFIGURATION.SETTINGS.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Enables application administrators to enable or disable specific functionality within the application. This feature is useful if you select features that need additional development effort before they can be used by end users.<br>',
'This feature can also be expanded to application-specific features. If developers define additional build options and associate them with specific functionality throughout the application, then they can be added to the configuration settings for admi'
||'nistrators. For example, within the Customer Tracker App administrators can turn on or off such features as Contacts, Data Loading, Geography, and more.',
'</p>',
'<p>Includes the following components:',
'<ul>',
'<li>Allows application functionality to be enabled and disabled</li>',
'<li>Use feature to allow selective functionality per deployment</li>',
'<li>Supports the grouping of related application settings</li>',
'<li>Enables application developers to control components using build options</li>',
'<li>Available from Administration page</li>',
'</ul>',
'</p>'))
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184690340593757039)
,p_name=>'CA.CONNECT.CREDENTIAL.NAME'
,p_message_text=>'Connect Credential Name'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184690646599758844)
,p_name=>'CA.CONNECT.CREDENTIAL.OWNER'
,p_message_text=>'Connect Credential Owner'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(670893901978008019)
,p_name=>'CA.CONTEXT'
,p_message_text=>'Context'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921935063428206817)
,p_name=>'CA.CONTRIBUTOR'
,p_message_text=>'Contributor'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184718650637850656)
,p_name=>'CA.CPU.USED'
,p_message_text=>'CPU Used'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2935878295891721656)
,p_name=>'CA.CREATE'
,p_message_text=>'Create'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2975429714523414709)
,p_name=>'CA.CREATE.ADMIN.PAGE'
,p_message_text=>'Creating administration page'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2974175639516293722)
,p_name=>'CA.CREATE.APP'
,p_message_text=>'Creating application'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2974911565411389030)
,p_name=>'CA.CREATE.APP.COMP'
,p_message_text=>'Creating application computations'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2974178012038343010)
,p_name=>'CA.CREATE.APP.ICON'
,p_message_text=>'Creating application icon'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2974911332271387043)
,p_name=>'CA.CREATE.APP.ITEM'
,p_message_text=>'Creating application items'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2975289900755390741)
,p_name=>'CA.CREATE.APP.PROCESS'
,p_message_text=>'Creating application processes'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(710418805308096201)
,p_name=>'CA.CREATE.APP.SETTING'
,p_message_text=>'Creating application settings'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3108274879338177214)
,p_name=>'CA.CREATE.APPLICATION'
,p_message_text=>'Create an Application'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(232262836269801979)
,p_name=>'CA.CREATE.APP_ROLES'
,p_message_text=>'Creating application roles'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2974178433477347065)
,p_name=>'CA.CREATE.AUTH.SCHEME'
,p_message_text=>'Creating authorization schemes'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2975427059359396482)
,p_name=>'CA.CREATE.BLANK.PAGE'
,p_message_text=>'Creating blank page'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2974178217743344570)
,p_name=>'CA.CREATE.BUILD.OPT'
,p_message_text=>'Creating build options'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2975427949754402872)
,p_name=>'CA.CREATE.CALENDAR.PAGE'
,p_message_text=>'Creating calendar page'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3363922963561060287)
,p_name=>'CA.CREATE.CARDS.PAGE'
,p_message_text=>'Creating cards page'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2975427510302400084)
,p_name=>'CA.CREATE.CHART.PAGE'
,p_message_text=>'Creating chart page'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2975429183583407386)
,p_name=>'CA.CREATE.CR.PAGE'
,p_message_text=>'Creating classic report page'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2975427797806401473)
,p_name=>'CA.CREATE.DASHBOARD.PAGE'
,p_message_text=>'Creating dashboard page'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2974175247369286615)
,p_name=>'CA.CREATE.END'
,p_message_text=>'Finishing up'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3624518963432702473)
,p_name=>'CA.CREATE.FACETED_SEARCH.PAGE'
,p_message_text=>'Creating faceted search page'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2978204717848121381)
,p_name=>'CA.CREATE.FEATURES'
,p_message_text=>'Creating features'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3391781818698593736)
,p_name=>'CA.CREATE.FILTERED.CONTENT.PAGE'
,p_message_text=>'Creating Filtered Content Page'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2975427233148397916)
,p_name=>'CA.CREATE.FORM.PAGE'
,p_message_text=>'Creating form page'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2974175893097295268)
,p_name=>'CA.CREATE.GLOBAL.PAGE'
,p_message_text=>'Creating global page'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2975429577697413153)
,p_name=>'CA.CREATE.HOMEPAGE.NAV.LIST'
,p_message_text=>'Creating home page navigation list'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2975429335893410783)
,p_name=>'CA.CREATE.IG.PAGE'
,p_message_text=>'Creating interactive grid page'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2975428717007405619)
,p_name=>'CA.CREATE.IR.PAGE'
,p_message_text=>'Creating interactive report page'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5002398058201500)
,p_name=>'CA.CREATE.MAP.PAGE'
,p_message_text=>'Creating map page'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3093502464147626788)
,p_name=>'CA.CREATE.MD.PAGE'
,p_message_text=>'Creating master detail pages'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2974178899770352749)
,p_name=>'CA.CREATE.NAV.BAR'
,p_message_text=>'Creating navigation bars'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3034950084088983278)
,p_name=>'CA.CREATE.PAGE.GROUP'
,p_message_text=>'Creating page group'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2978068722766114663)
,p_name=>'CA.CREATE.PERFORM.TRANSLATION'
,p_message_text=>'Performing translation'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2978065590085061858)
,p_name=>'CA.CREATE.PERFORM.TRANSLATION.V'
,p_message_text=>'Performing translation for %0'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2975428532600404337)
,p_name=>'CA.CREATE.REPORT.FORM.PAGE'
,p_message_text=>'Creating report and form page'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3096937512007065559)
,p_name=>'CA.CREATE.SAVE_BLUE.PRINT'
,p_message_text=>'Saving blueprint'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2974179033665354309)
,p_name=>'CA.CREATE.SHORT.CUT'
,p_message_text=>'Creating shortcut'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2975290481439394542)
,p_name=>'CA.CREATE.SIGN.IN.PAGE'
,p_message_text=>'Creating sign in page'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4892141173869998)
,p_name=>'CA.CREATE.SMART_FILTERS.PAGE'
,p_message_text=>'Creating Smart Filters page'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2974174255912266882)
,p_name=>'CA.CREATE.START'
,p_message_text=>'Start'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2974176094563300536)
,p_name=>'CA.CREATE.SUP.OBJ.SCRIPTS'
,p_message_text=>'Creating supporting object scripts'
,p_version_scn=>37165770887499
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2974178651312351338)
,p_name=>'CA.CREATE.TEXT.MSG'
,p_message_text=>'Creating text messages'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3385748405957524703)
,p_name=>'CA.CREATE.TIMELINE.PAGE'
,p_message_text=>'Creating timeline page'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3624523825618755124)
,p_name=>'CA.CREATE.WIZARD.PAGE'
,p_message_text=>'Creating wizard page'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921392704693750112)
,p_name=>'CA.CREATED'
,p_message_text=>'Created'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921392990109752323)
,p_name=>'CA.CREATED.BY'
,p_message_text=>'Created By'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2717730367415961728)
,p_name=>'CA.CREATING.APPLICATION'
,p_message_text=>'Creating Application ...'
,p_is_js_message=>true
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184692957177788983)
,p_name=>'CA.CREDENTIAL.NAME'
,p_message_text=>'Credential Name'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184717867125849687)
,p_name=>'CA.CREDENTIAL.OWNER'
,p_message_text=>'Credential Owner'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921396834686900329)
,p_name=>'CA.CURRENT.STATUS'
,p_message_text=>'Current Status'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2984816748850813136)
,p_name=>'CA.CUSTOM.QRY'
,p_message_text=>'Custom Query'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(257378415276681194)
,p_name=>'CA.CUSTOM.THEME'
,p_message_text=>'Use Custom Theme'
,p_version_scn=>37165770887500
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(257672159768690707)
,p_name=>'CA.CUSTOM.THEME.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Switch the wizard to use a custom theme instead of the Universal Theme.</p>',
'',
'<p>Select a Workspace Theme for the application. If the theme supports Theme Styles, then the style can also be selected.</p>'))
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(106076891433259654)
,p_name=>'CA.CUSTOM_THEME'
,p_message_text=>'Custom Theme'
,p_is_js_message=>true
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3021097598749298066)
,p_name=>'CA.DASHBOARD'
,p_message_text=>'Add Dashboard Page'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(657370579407842769)
,p_name=>'CA.DASHBOARD.CHART.N'
,p_message_text=>'Chart %0'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3021097738613299739)
,p_name=>'CA.DASHBOARD.DETAILS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Create a dashboard page with multiple charts.</p>',
'<p>Enter the following attributes:</p>',
'<ul>',
'  <li><strong>Page Name</strong> (Mandatory) - Enter a name for this page.</li>',
'  <li><strong>Set Icon</strong> - Select an icon to display in the navigation menu for this page.</li>',
'</ul>',
'&nbsp;<br>',
'<p>Each chart (Chart 1, Chart 2, Chart 3, and Chart 4) defaults to different chart types and is based on <em>Sample Data</em>. ',
'  As such you do not need to enter any further details to add this page.',
'  However, you can customize each chart be replacing the default values with your own selections.<br>',
'  To customize a chart enter the following attributes:</p>',
'<ul>',
'  <li><strong>Chart Name</strong> (Mandatory) - Enter the name for the chart.</li>',
'  <li><strong>Chart Type</strong> - Select the type of chart to display [<strong>Area</strong>, <strong>Bar</strong>, <strong>Line</strong>, <strong>Pie</strong>].</li>',
'  <li><strong>Table or View</strong> (Mandatory) - Select the database object for the chart.</li>',
'  <li><strong>Label Column</strong> (Mandatory) - Select the column from the table or view to use as the label for the chart.</li>',
'  <li><strong>Value Aggregation</strong> - Select how the value column should be displayed or aggregated<br>',
'      &nbsp;&nbsp;&nbsp;[Column Value, Sum, Count].</li>',
'  <li><strong>Value Column</strong> (Mandatory) - Select a numeric column from the table or view which is used to calculate the chart values displayed.</li>',
'</ul>'))
,p_version_scn=>14499014
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390018403696804042)
,p_name=>'CA.DATATYPE'
,p_message_text=>'Data Type'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390023045002834607)
,p_name=>'CA.DATEFORMATMASK'
,p_message_text=>'Date Format Mask'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921410575114006885)
,p_name=>'CA.DEFAULT.TIME.ZONE'
,p_message_text=>'Default Time Zone'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921412991886040815)
,p_name=>'CA.DEFAULT.TIME.ZONE.UPDATED'
,p_message_text=>'Default time zone updated.'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3052392075133524538)
,p_name=>'CA.DEFAULTS'
,p_message_text=>'Application Attribute Defaults'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3052393369990606396)
,p_name=>'CA.DEFAULTS.DETAIL'
,p_message_text=>'This JSON document allows for fine grain control over the generation of report and form columns names, format masks etc.  You can also define lists of values and other shared components. '
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3503659197691398606)
,p_name=>'CA.DEFAULTS.LOV'
,p_message_text=>'List of Values Attributes'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3503659329568401157)
,p_name=>'CA.DEFAULTS.LOV.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Add a list of values (LOV) attribute. LOVs can be used in table column definitions.</p>',
'<p>Enter the following attributes:',
'  <ul>',
'    <li><strong>Name</strong> (Mandatory) - Enter the name for the list of values.</li>',
'    <li><strong>Type</strong> - Select the list of values type [Structured, Dynamic, Static].<br>',
'      For Type of <u>Structured</u> - ',
'      <ul>',
'          <li><strong>Table</strong> (Mandatory) - Select the table or view to base the list of values on.</li>',
'          <li><strong>Display Column</strong> (Mandatory) - Select the column to display to end users.</li>',
'          <li><strong>Key Column</strong> (Mandatory) - Select the column value to return. This is generally the primary key for the table.</li>',
'      </ul>',
'      &nbsp;<br>',
'      For Type of <u>Dynamic</u> -',
'      <ul>',
'          <li><strong>SQL Query</strong> (Mandatory) - Enter a valid SQL select statement that returns two values (display value and return value).</li>',
'      </ul>',
'      &nbsp;<br>',
'      For Type of <u>Static</u> -',
'      <ul>',
'          <li><strong>Static List of Values</strong> (Mandatory) - Enter a valid static list of the form:',
'          <ul>',
'            <li><code>STATIC2:Display1;Value1,Display2;Value2,...</code><br>List displayed in the order entered</li>',
'            <li><code>STATIC:Display1;Value1,Display2;Value2,...</code><br>List ordered alphabetically</li>',
'            <li><code>STATIC2|STATIC:Value1,Value2,...</code><br>Display value and return value the same</li>',
'          </ul>',
'      </ul>',
'    </li>',
'  </ul>',
'</p>',
''))
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3639060884968310767)
,p_name=>'CA.DEFAULTS.REPORT'
,p_message_text=>'Report Attributes'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3639061093818312202)
,p_name=>'CA.DEFAULTS.REPORT.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Edit the attributes for all reports.</p>',
'<p>Enter the following attributes:',
'  <ul>',
'    <li><strong>Rows Per Page</strong> - Enter the number of report rows to display by default.</li>',
'    <li><strong>Pagination Method</strong> - Select how report pagination will be displayed.</li>',
'    <li><strong>Numeric Format Mask</strong> - Enter the format mask to apply to number columns and items.</li>',
'    <li><strong>Date Format Mask</strong> - Enter the format mask to apply to date columns and items.</li>',
'  </ul>',
'</p>',
''))
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3636987998735639033)
,p_name=>'CA.DEFAULTS.TABLE'
,p_message_text=>'Table Attributes'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3635989190637543353)
,p_name=>'CA.DEFAULTS.TABLE.COLUMN'
,p_message_text=>'Table Column Attributes'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3635994429757612321)
,p_name=>'CA.DEFAULTS.TABLE.COLUMN.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Edit the attributes for the selected table column.</p>',
'<p>Enter the following attributes:',
'  <ul>',
'    <li><strong>Table</strong> (Display Only) - The associated table.</li>',
'    <li><strong>Column</strong> (Display Only) - The column that the attributes are defined against.</li>',
'    <li><strong>Label</strong> - Enter the label to use in report headings and form labels.</li>',
'    <li><strong>Form Control</strong> - Select the item type to use on forms.</li>',
'    <li><strong>List of Values</strong> - Select an existing List of Values to use to display user friendly names as appropriate.</li>',
'    <li><strong>Format Mask</strong> - Enter an appropriate format mask based on the column type (text, number, date, and so forth).</li>',
'    <li><strong>Static Default Value</strong> - Enter a text default value for the column.</li>',
'    <li><strong>Include on Forms</strong> - Click Yes if the column should be included on forms.</li>',
'    <li><strong>Include on Reports</strong> - Click Yes if the column should be included on reports.</li>',
'    <li><strong>Required</strong> - Click Yes if data must be entered into this column on forms.</li>',
'    <li><strong>Help</strong> - Enter help text that is added to the item help attribute.</li>',
'  </ul>',
'</p>'))
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3636988189411640116)
,p_name=>'CA.DEFAULTS.TABLE.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Edit the attributes for the selected table.</p>',
'<p>Enter the following attributes:',
'  <ul>',
'    <li><strong>Table</strong> (Display Only) - The associated table.</li>',
'    <li><strong>Label, Singular</strong> (Mandatory) - Enter the label to use on form pages.</li>',
'    <li><strong>Label, Plural</strong> (Mandatory) - Enter the label to use in region headings and page names.</li>',
'    <li><strong>Primary Display Column</strong> - Select the first column to display, for example in card regions.</li>',
'    <li><strong>Secondary Display Column</strong> - Select the second column to display, for example in card regions.</li>',
'    <li><strong>Primary Key Column</strong> - Select the unique primary key column for the table.</li>',
'    <li><strong>Description</strong> - Enter a description for the table.</li>',
'  </ul>',
'</p>',
''))
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184691961294765624)
,p_name=>'CA.DEFERRED.DROP'
,p_message_text=>'Deferred Drop'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390024443305853537)
,p_name=>'CA.DEFINITION'
,p_message_text=>'Definition'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2939102544288551506)
,p_name=>'CA.DEINSTALL.COMPLETE'
,p_message_text=>'Deinstallation complete.'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921243510178096153)
,p_name=>'CA.DELETE'
,p_message_text=>'Delete'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2939100809220509997)
,p_name=>'CA.DELETE.CONFIRM'
,p_message_text=>'Would you like to perform this delete action?'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2647192229855853394)
,p_name=>'CA.DELETE.PAGE.CONFIRM.MSG'
,p_message_text=>'Are you sure you want to delete this page?'
,p_is_js_message=>true
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922145937187621898)
,p_name=>'CA.DELETE.PHOTO'
,p_message_text=>'Delete Photo'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921315510019364314)
,p_name=>'CA.DESCRIPTION'
,p_message_text=>'Description'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2935891867249795744)
,p_name=>'CA.DESKTOP.NAVIGATION.BAR'
,p_message_text=>'Navigation Bar'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2935890832413787232)
,p_name=>'CA.DESKTOP.NAVIGATION.MENU'
,p_message_text=>'Navigation Menu'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921194181113900856)
,p_name=>'CA.DESKTOP.THEME.STYLE'
,p_message_text=>'Desktop Theme Style'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921194344438905421)
,p_name=>'CA.DESKTOP.THEME.STYLE.DESC'
,p_message_text=>'The default Theme Style applies to all users.'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184693322210790821)
,p_name=>'CA.DESTINATION'
,p_message_text=>'Destination'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184693528489791916)
,p_name=>'CA.DESTINATION.OWNER'
,p_message_text=>'Destination Owner'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(106119013745756930)
,p_name=>'CA.DIALOG.BUTTONS'
,p_message_text=>'Dialog Buttons'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922446556500839801)
,p_name=>'CA.DISPATCH.EMAILS'
,p_message_text=>'Dispatch Emails'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3352231935537078117)
,p_name=>'CA.DISPATCH.EMAILS.HELP'
,p_message_text=>'Determines whether emails should be sent out from the Email Framework.'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921269318491672617)
,p_name=>'CA.DISPLAY.FROM'
,p_message_text=>'Display From'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921269156969666950)
,p_name=>'CA.DISPLAY.SEQUENCE'
,p_message_text=>'Display Sequence'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921269572902675399)
,p_name=>'CA.DISPLAY.UNTIL'
,p_message_text=>'Display Until'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390018865083807380)
,p_name=>'CA.DISPLAYCOLUMN'
,p_message_text=>'Display Column'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921423432814333455)
,p_name=>'CA.DISTINCT .USERS'
,p_message_text=>'Distinct Users'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2935881616764748047)
,p_name=>'CA.DOWNLOAD'
,p_message_text=>'Download'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3035873878412250184)
,p_name=>'CA.DRAG.TO.REORDER'
,p_message_text=>'Drag to reorder page'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(110394392780365303)
,p_name=>'CA.DRILL.DOWN.LINK'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
'  <li><strong>Drill Down Link</strong> - Expand to see attributes for defining a drill down link.',
'&nbsp;<br>',
'    <em><strong>Note:</strong> Drill Down Link only appears if the current page is based on a table or view and has a report type of Interactive Report, and you have defined a report (Interactive Report) or a master detail (Master Detail) page.</em>',
'  <ul>',
'    <li><strong>Link Column</strong> - Select the column to change to a link column in the report.</li>',
'    <li><strong>Link Key</strong> - Select the link key (foreign key) column used to identify the specific record in the page being linked to.</li>',
'    <li><strong>Link to Page</strong> - Select the report or form page that the link navigates to.</li>',
'    <li><strong>Target Key</strong> - Select the target key (primary key) column from the table that the report page, that the link navigates to and is based on.',
'  </ul>',
'</ul>',
''))
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921417470815198164)
,p_name=>'CA.ELAPSED'
,p_message_text=>'Elapsed'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2671540709864246637)
,p_name=>'CA.EMAIL'
,p_message_text=>'Email Framework'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3350901500303395171)
,p_name=>'CA.EMAIL.ADDRESSES'
,p_message_text=>'Email Addresses'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3739449055677845738)
,p_name=>'CA.EMAIL.DEFAULT'
,p_message_text=>'Default'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2671540444507243498)
,p_name=>'CA.EMAIL.DESC'
,p_message_text=>'Add ability to configure and send emails'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2671540976528256725)
,p_name=>'CA.EMAIL.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Include the ability to send emails from your application. Using the example email template, send professional looking emails to users. The emails sent are logged so that administrators can keep track of email activity.</p>',
'<p>Includes the following components:',
'<ul>',
'<li>Extensible HTML Email template system</li>',
'<li>PL/SQL package for sending mail via APEX packages</li>',
'<li>Logging of email activity and status</li>',
'<li>Administrative UI to manage templates</li>',
'<li>Administrative UI to view email logs</li>',
'<li>Administrative UI to send emails</li>',
'</ul>',
'</p>',
'<p><em>Note: This feature will be enabled when Feedback is selected</em></p>'))
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390859682915675372)
,p_name=>'CA.EMAIL.FROM'
,p_message_text=>'Email From'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922439519597770694)
,p_name=>'CA.EMAIL.LOG'
,p_message_text=>'Email Log'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3767022200183606826)
,p_name=>'CA.EMAIL.P10940.EMAIL.DETAILS.REQUIRED'
,p_message_text=>'Email setting details required.'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3760905119087160301)
,p_name=>'CA.EMAIL.P10940.EMAILS.FROM.INVALID'
,p_message_text=>'From Address is not a valid email.'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3388520364122380768)
,p_name=>'CA.EMAIL.P11030.EMAILS.FROM.INVALID'
,p_message_text=>'From Address is not a valid email.'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3353767397093620646)
,p_name=>'CA.EMAIL.PROCESSED'
,p_message_text=>'Email processed.'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(129926256783106143)
,p_name=>'CA.EMAIL.REPORTING'
,p_message_text=>'Email Reporting'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(234215567763914736)
,p_name=>'CA.EMAIL.REPORTING.DESC'
,p_message_text=>'Report of all email queued to be sent and those already sent'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922446340050833283)
,p_name=>'CA.EMAIL.SETTINGS'
,p_message_text=>'Email Settings'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922454998629926366)
,p_name=>'CA.EMAIL.SETTINGS.UPDATED'
,p_message_text=>'Email settings updated.'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3400496899899092919)
,p_name=>'CA.EMAIL.STATUS'
,p_message_text=>'Email Status'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922455213995930769)
,p_name=>'CA.EMAIL.TEMPLATE.DETAILS'
,p_message_text=>'Email Template Details'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(481856201298619432)
,p_name=>'CA.EMAIL.TEMPLATE.SUBJECT_EXAMPLE.SO'
,p_message_text=>'Scheduled Outage for #SERVICE_NAME#'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(262724643767207906)
,p_name=>'CA.EMAIL2'
,p_message_text=>'Email'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922439326309766645)
,p_name=>'CA.EMAILS.SENT'
,p_message_text=>'Emails Sent'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3760906388661232426)
,p_name=>'CA.ENABLE.ATTACHMENTS'
,p_message_text=>'Enable Attachments'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184713248642837561)
,p_name=>'CA.ENABLED'
,p_message_text=>'Enabled'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184701022555811514)
,p_name=>'CA.END.DATE'
,p_message_text=>'End Date'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922456858628964211)
,p_name=>'CA.END.ROW.TEMPLATE'
,p_message_text=>'After Rows Content'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(729547271811161451)
,p_name=>'CA.ENDED'
,p_message_text=>'Ended'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3207347751119292418)
,p_name=>'CA.ENTER.USERNAME'
,p_message_text=>'Enter usernames here'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921418733860210549)
,p_name=>'CA.ERROR'
,p_message_text=>'Error'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921453065781966085)
,p_name=>'CA.ERROR.BACKTRACE'
,p_message_text=>'Error Backtrace'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921452866471962209)
,p_name=>'CA.ERROR.CODE'
,p_message_text=>'Error Code'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921450342033943642)
,p_name=>'CA.ERROR.MESSAGE'
,p_message_text=>'Error Message'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184723655639857031)
,p_name=>'CA.ERROR.NUMBER'
,p_message_text=>'Error Number'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184714990123843872)
,p_name=>'CA.ERRORS'
,p_message_text=>'Errors'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(729548279136170455)
,p_name=>'CA.ERROR_ROWS'
,p_message_text=>'Error Rows'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184706076858815927)
,p_name=>'CA.EVENT.CONDITION'
,p_message_text=>'Event Condition'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184707255429817260)
,p_name=>'CA.EVENT.QUEUE.AGENT'
,p_message_text=>'Event Queue Agent'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184707449591818273)
,p_name=>'CA.EVENT.QUEUE.NAME'
,p_message_text=>'Event Queue Name'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184707695219819290)
,p_name=>'CA.EVENT.QUEUE.OWNER'
,p_message_text=>'Event Queue Owner'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184705747231815059)
,p_name=>'CA.EVENT.RULE'
,p_message_text=>'Event Rule'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3207348597027306223)
,p_name=>'CA.EXCEPTIONS'
,p_message_text=>'Exceptions'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3966760498355221622)
,p_name=>'CA.EXPERIENCE'
,p_message_text=>'Experience'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184712688908835181)
,p_name=>'CA.FAILURE.COUNT'
,p_message_text=>'Failure Count'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921395473639888511)
,p_name=>'CA.FEATURE'
,p_message_text=>'Feature'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(561195827579186579)
,p_name=>'CA.FEATURE.ABOUT_PAGE.APP_VERSION'
,p_message_text=>'Application Version'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(561196076362226278)
,p_name=>'CA.FEATURE.ABOUT_PAGE.PAGES'
,p_message_text=>'Pages'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(305936502942156065)
,p_name=>'CA.FEATURE.ACL.ADD_USERS_TO_ACL'
,p_message_text=>'Add Users to Access Control List'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(305934807138124786)
,p_name=>'CA.FEATURE.ACL.MULTIPLE_USER.ADD.NEXT'
,p_message_text=>'Go To Next Step'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(305935959311136574)
,p_name=>'CA.FEATURE.ACL.MULTIPLE_USER.CREATE_COLLECTIONS'
,p_message_text=>'Create Collections'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(305933494274094984)
,p_name=>'CA.FEATURE.ACL.USER.EDIT.CANNOT_CHANGE_LAST_ADMIN'
,p_message_text=>'Cannot change the last administrator'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(561194921446129497)
,p_name=>'CA.FEATURE.ACTIVITY_REPORT.LAST_ACTIVITY'
,p_message_text=>'Last Activity'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(305932508063063298)
,p_name=>'CA.FEATURE.ACTIVITY_REPORT.NO_ACTIVITY_FOUND'
,p_message_text=>'No activities found'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(561195648695158233)
,p_name=>'CA.FEATURE.EXCEPTION.REASON'
,p_message_text=>'Reason'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(305937462914177580)
,p_name=>'CA.FEATURE.FEEDBACK.AT_LEAST_ONE_REQUIRED'
,p_message_text=>'At least One Feedback Required'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(306083508867274967)
,p_name=>'CA.FEATURE.FEEDBACK.GET_FILE_ID'
,p_message_text=>'Get File ID'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(305007294530755768)
,p_name=>'CA.FEATURE.THEME_STYLE.SAVE'
,p_message_text=>'Save Theme Style'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(305007428270760100)
,p_name=>'CA.FEATURE.THEME_STYLE.SAVE_USER_PREF'
,p_message_text=>'Save End User Style Preference'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(561195176647134446)
,p_name=>'CA.FEATURE.USERNAME'
,p_message_text=>'Username'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2720709756240298547)
,p_name=>'CA.FEATURES'
,p_message_text=>'Features'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2720710407905304212)
,p_name=>'CA.FEATURES.DESC'
,p_message_text=>'Features provide application-level functionality and are typically added once per application. Choose features to include with your application.'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2646824705764929499)
,p_name=>'CA.FEEDBACK'
,p_message_text=>'Feedback'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2621228749364562962)
,p_name=>'CA.FEEDBACK.DESC'
,p_message_text=>'Allow users to provide feedback'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2646821110719623802)
,p_name=>'CA.FEEDBACK.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Provide a mechanism for end users to post general comments back to the application administrators and developers. The posts include useful session state information to help determine where the end user sent the feedback from. Providing such an eas'
||'y feedback loop enhances communication between the user community and the application owners, which leads to greatly improved end user satisfaction.</p>',
'<p>Includes the following components:',
'<ul>',
'<li>Ability for end users to leave feedback by clicking on a navigation bar icon</li>',
'<li>Administrative report for viewing and updating feedback</li>',
'<li>Feedback will capture the user, date and time, and user agent information</li>',
'</ul>',
'</p>'))
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3966762365367350420)
,p_name=>'CA.FEEDBACK.OR_EXPERIENCE'
,p_message_text=>'Please provide feedback or your experience.'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3761377816500363838)
,p_name=>'CA.FEEDBACK.RECIPIENTS'
,p_message_text=>'Send To'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3739423828750477590)
,p_name=>'CA.FEEDBACK.SETTINGS'
,p_message_text=>'Feedback Settings'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922385185869439518)
,p_name=>'CA.FEEDBACK.SETTINGS.UPDATED'
,p_message_text=>'Feedback settings updated.'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3785661030236089620)
,p_name=>'CA.FEEDBACK.SUBMITTED.SUCCESS'
,p_message_text=>'Feedback Submitted'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184704061824812867)
,p_name=>'CA.FILE.WATCHER.NAME'
,p_message_text=>'File Watcher Name'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184704728813814393)
,p_name=>'CA.FILE.WATCHER.OWNER'
,p_message_text=>'File Watcher Owner'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(63498757191799437)
,p_name=>'CA.FILED'
,p_message_text=>'Filed'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(63498989612801416)
,p_name=>'CA.FILED.BY'
,p_message_text=>'Filed By'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3404904320926232993)
,p_name=>'CA.FILTER.REPORT'
,p_message_text=>'Filter Report'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922457869659993430)
,p_name=>'CA.FILTERS'
,p_message_text=>'Filters'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3628792688080383632)
,p_name=>'CA.FINISH'
,p_message_text=>'Finish'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922146699005630764)
,p_name=>'CA.FIRST.NAME'
,p_message_text=>'First Name'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184691347946762229)
,p_name=>'CA.FLAGS'
,p_message_text=>'Flags'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2722695911234992491)
,p_name=>'CA.FORM'
,p_message_text=>'Add Form Page'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2722695767589991082)
,p_name=>'CA.FORM.DETAILS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Create a page which displays a form page to enable end users to maintain data.</p>',
'<p>Enter the following attributes:</p>',
'<ul>',
'  <li><strong>Page Name</strong> (Mandatory) - Enter a name for this page.</li>',
'  <li><strong>Set Icon</strong> - Select an icon to display in the navigation menu for this page.</li>',
'  <li><strong>Table</strong> (Mandatory) - Select the table for the form.</li>',
'<li><strong>Include Report</strong> (Mandatory) - Select this option to create a report and form. The first page is an interactive report. Each row provides a link to a form where users can update the record. </li>',
'  &nbsp;<br>',
'<li><strong>Advanced</strong> - Expand to see advanced options.',
'     <ul>',
'      <li><strong>Page Help</strong> - Enter text to be added to the Help Text for the page.</li>',
'      </ul>',
'</li>',
'</ul>'))
,p_version_scn=>14510670
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(109862772238948209)
,p_name=>'CA.FORM.ITEM.REGION'
,p_message_text=>'Form Items Region'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2935888332193771559)
,p_name=>'CA.FORM.ON'
,p_message_text=>'Form on %0'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3206409487718057694)
,p_name=>'CA.FORM.TYPE.NOT.VALID'
,p_message_text=>'The form type is not a valid type'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390025418889861472)
,p_name=>'CA.FORMATMASK'
,p_message_text=>'Format Mask'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390023206494838483)
,p_name=>'CA.FORMCONTROL'
,p_message_text=>'Form Control'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921392351593745165)
,p_name=>'CA.FROM'
,p_message_text=>'From'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922446820735842211)
,p_name=>'CA.FROM.ADDRESS'
,p_message_text=>'From Address'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390858037266661839)
,p_name=>'CA.FROM.ADDRESS.EMAIL.SETTING'
,p_message_text=>'"From Address" Email Setting'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3387540893130642366)
,p_name=>'CA.FROM.EMAIL'
,p_message_text=>'From Email'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3387540699161641470)
,p_name=>'CA.FROM.WHO'
,p_message_text=>'From Who'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(567275634790675126)
,p_name=>'CA.FS.SEARCH.TABLE_NAME'
,p_message_text=>'%0 Search'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921449149049921504)
,p_name=>'CA.FULL.PAGE.VIEWS'
,p_message_text=>'Full Page Views'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922442837744801280)
,p_name=>'CA.FULL.TEMPLATE.HTML'
,p_message_text=>'Full Template HTML'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390022169332822845)
,p_name=>'CA.FUNCTION'
,p_message_text=>'Function'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2646825640139962257)
,p_name=>'CA.GLOBAL.SEARCH'
,p_message_text=>'Global Search'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2621233646828586613)
,p_name=>'CA.GLOBAL.SEARCH.DESC'
,p_message_text=>'Provide application search capability'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2646825422944960553)
,p_name=>'CA.GLOBAL.SEARCH.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Allow end users to search for text across key tables or views within the application. The advanced search page includes filters to make it simple for end users to narrow down the results.<br>',
'This very powerful feature does require some development effort to define the SQL (based on provided examples).</p>',
'<p>Includes the following components:',
'<ul>',
'<li>Displays a search icon in the header bar</li>',
'<li>Includes a detail search results page with side bar filter</li>',
'<li>Requires developer implement the SQL to define the App search</li>',
'<li>Includes sample data for illustration</li>',
'</ul>',
'</p>'))
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184711224596829124)
,p_name=>'CA.GLOBAL.UID'
,p_message_text=>'Global Unique ID'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(304941654983395022)
,p_name=>'CA.GLOBAL_PAGE.NAME'
,p_message_text=>'Global Page - Desktop'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(106119350254774772)
,p_name=>'CA.GO.TO.ADMIN.PAGE'
,p_message_text=>'Go To Admin Page'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2722692398960864407)
,p_name=>'CA.GRID'
,p_message_text=>'Add Interactive Grid Page'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2722692521388865538)
,p_name=>'CA.GRID.DETAILS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Create a page which displays as an interactive grid which is similar to a spreadsheet. When editable, users can edit multiple rows directly on the page (that is, when Allow Editing is enabled).</p>',
'<p>Enter the following attributes:</p>',
'<ul>',
'  <li><strong>Page Name</strong> (Mandatory) - Enter a name for this page.</li>',
'  <li><strong>Set Icon</strong> - Select an icon to display in the navigation menu for this page.</li>',
'  <li><strong>Query Type</strong> - Select the source for the report [<strong>Table or View</strong> or <strong>SQL Query</strong>].<br>',
'    <strong>Table or View</strong>:',
'    <ul>',
'      <li><strong>Table or View</strong> (Mandatory) - Select the database object for the grid.</li>',
'    </ul>',
'    <strong>SQL Query</strong>:',
'    <ul>',
'      <li><strong>SQL Query</strong> (Mandatory) - Enter a valid SQL statement which returns distinct columns.</li>',
'    </ul>',
'  </li>',
'  <li><strong>Grid Type</strong> - Select if users can edit the rows in the grid [<strong>Allow Editing</strong> or <strong>Read Only</strong>]. To enable editing, select <strong>Allow Editing</strong>.</li>',
'  &nbsp;<br>',
'  <em><strong>Warning:</strong> If you select a Query Type of <strong>SQL Query</strong> plus a Grid Type of <strong>Allow Editing</strong> and your query joins two or more tables, then the interactive grid generated will fail when users try and upda'
||'te records.',
'Also, if you select Grid Type of <strong>Allow Editing</strong> and the query (or selected Table or View) uses a view that is not updateable, then the Interactive Grid generated will fail when users try and update records.</em><br>',
'</ul>',
''))
,p_version_scn=>14510879
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922460172950046745)
,p_name=>'CA.HELP'
,p_message_text=>'Help'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(729545221887138195)
,p_name=>'CA.HELP.ACTIVITY.REPORTING.AUTOMATIONS.LOG'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>This page provides an interactive report of the automations log.</p>',
'<p>Review logged information about previous automation executions. The log contains start and end timestamps as well as details about processed rows (successful and with errors). Drill down into Messages to see individual messages for processed rows.'
||'</p>',
''))
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921934660894202889)
,p_name=>'CA.HELP.ALLOW.OTHER.USERS'
,p_message_text=>'Choose <strong>No</strong> if all users are defined in the access control list. Choose <strong>Yes</strong> if authenticated users not in the access control list may also use this application.'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921400789661964062)
,p_name=>'CA.HELP.APP.NAME'
,p_message_text=>'The text entered here is used throughout the application, most notably, in the upper left-hand corner of every page. The change will take effect immediately for the administrator making the change, but other users will only see the change when they g'
||'et a new session (e.g. at next login).'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2885894799020330828)
,p_name=>'CA.HELP.HOME.FEEDBACK'
,p_message_text=>'<p>Click the feedback icon ( <span class="fa fa-comment-o" aria-hidden="true"></span> ) in the navigation bar, from any page in the application, to leave feedback for the application administrators.</p>'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2885894141152310496)
,p_name=>'CA.HELP.HOME.MAIN.SIDE.MENU'
,p_message_text=>'<p>This is the home page of the application. Click on the cards to access different pages in the application, or use the navigation menu on the side of the page.</p>'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2885894503977315342)
,p_name=>'CA.HELP.HOME.MAIN.TOP.MENU'
,p_message_text=>'<p>This is the home page of the application. Click on the cards to access different pages in the application, or use the navigation menu at the top of the page.</p>'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2885894911225351459)
,p_name=>'CA.HELP.HOME.SEARCH'
,p_message_text=>'<p>Enter a search term in to the <strong>Search Application</strong> field on this page, or click the search icon ( <span class="fa fa-search" aria-hidden="true"></span> ) in the navigation bar from any page, to search for the term within your applic'
||'ation.</p>'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2885895784447393918)
,p_name=>'CA.HELP.HOME.SIGN.OUT'
,p_message_text=>'<p>Click your name dropdown in the navigation bar to sign out of the application.</p>'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2885895335593384290)
,p_name=>'CA.HELP.HOME.TIME'
,p_message_text=>'<p>Click the user menu ( <span class="fa fa-user" aria-hidden="true"></span> ) in the navigation bar to update your time zone preference, and sign out of the application.</p>'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2885894331206312070)
,p_name=>'CA.HELP.HOME.TITLE'
,p_message_text=>'Home Page'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2885896091182396660)
,p_name=>'CA.HELP.HOME.USER'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Click the user menu ( <span class="fa fa-user" aria-hidden="true"></span> ) in the navigation bar (top right of the page) to access your user profile, and sign out of the application.<br>',
'If you click <strong>View My Profile</strong> you can then click <strong>Update Profile</strong> to enter your personal details and upload a photo or avatar.</p>'))
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2885895157473382298)
,p_name=>'CA.HELP.HOME.USER.TIME'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Click the user menu ( <span class="fa fa-user" aria-hidden="true"></span> ) in the navigation bar to access your user profile, update your time zone preference, and sign out of the application.<br>',
'If you click <strong>View My Profile</strong> you can then click <strong>Update Profile</strong> to enter your personal details and upload a photo or avatar.</p>'))
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2986105093693789094)
,p_name=>'CA.HELP.IG.PAGE.READONLY'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>To find data enter a search term into the search dialog, or click on the column headings to limit the records returned.</p>',
'',
'<p>You can perform numerous functions by clicking the <strong>Actions</strong> button. This includes selecting the columns that are displayed / hidden and their display sequence, plus numerous data and format functions.  You can also define an additi'
||'onal view of the data using the chart option.</p>',
'',
'<p>If you want to save your customizations select report, or click download to unload the data.<p>',
'<br>',
'<p>For additional information click Help at the bottom of the Actions menu.</p> ',
'',
'<p>Click the <strong>Reset</strong> button to reset the interactive report back to the default settings.</p>',
''))
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2985284595924932808)
,p_name=>'CA.HELP.IG.PAGE.UPDATABLE'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>You can insert, update, and delete data directly within this interactive grid.<br>',
'  Insert a new row by clicking the Add Row button.<br>',
'  Double click into a cell, or click the <strong>Edit</strong> button to update data values, similar to editing data in a spreadsheet.</p>',
'',
'<p>Use the Row Actions menu ( <span class="fa fa-bars" aria-hidden="true"></span> ) at the top of the report to duplicate, delete, refresh or revert selected rows.<br> ',
'  Use the Row Actions menu on individual rows to also access the single row view or add a new row.</p>',
'',
'<p>To find data enter a search term into the search dialog, or click on the column headings to limit the records returned.</p>',
'',
'<p>You can perform numerous functions by clicking the <strong>Actions</strong> button. This includes selecting the columns that are displayed / hidden and their display sequence, plus numerous data and format functions.  You can also define an additi'
||'onal view of the data using the chart option.</p>',
'',
'<p>If you want to save your customizations select report, or click download to unload the data.<p>',
'',
'<p>For additional information click Help at the bottom of the Actions menu.</p> ',
'',
'<p>Click the <strong>Reset</strong> button to reset the interactive grid back to the default settings.</p>'))
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2885093087026229212)
,p_name=>'CA.HELP.IR.PAGE'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>To find data enter a search term into the search dialog, or click on the column headings to limit the records returned.</p>',
'',
'<p>You can perform numerous functions by clicking the <strong>Actions</strong> button. This includes selecting the columns that are displayed / hidden and their display sequence, plus numerous data and format functions.  You can also define additiona'
||'l views of the data using the chart, group by, and pivot options.</p>',
'',
'<p>If you want to save your customizations select report, or click download to unload the data. Enter you email address and time frame under subscription to be sent the data on a regular basis.<p>',
'',
'<p>For additional information click Help at the bottom of the Actions menu.</p> ',
'',
'<p>Click the <strong>Reset</strong> button to reset the interactive report back to the default settings.</p>'))
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3209928781454624792)
,p_name=>'CA.HELP.MD.PAGE'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>This report page displays primary records in a selector on the side of the page. ',
'  Select a record to see the master record and any detail records defined.<br> ',
'  Click the edit icon ( <span class="fa fa-pencil-square-o" aria-hidden="true"></span> ) to edit the master record.',
'  For detail records, click the pencil, at the beginning of each row, to edit that record.</p>',
'<p>To limit the data displayed in the selector enter a search term into the search dialog.</p>',
'',
'<p>To add a new master record click <strong>Create</strong> at the top of the page.',
'  For detail records, click the plus icon ( + ) at the top of the detail region to add a detail record.</p>',
'',
'<p>Click <strong>Reset</strong> at the top of the page to reset the page back to the default settings, removing any search term previously defined.</p>'))
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2815566880196749620)
,p_name=>'CA.HELP.P10000.ADMINISTRATION.PAGE'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>The administration page allows application owners (Administrators) to configure the application and maintain common data used across the application.',
'By selecting one of the available settings, administrators can potentially change how the application is displayed and/or features available to the end users.</p>',
'<p>Access to this page should be limited to Administrators only.</p>'))
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2826976181712610040)
,p_name=>'CA.HELP.P10100.ACCESS.CONTROL.CONFIGURE'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Select the appropriate choice for any authenticated users.<br> ',
'Selecting <strong>No</strong> makes the application more secure as only specified users can access the application. ',
'However, if your application has a large user community then maintaining users may be onerous, and you may prefer to choose <strong>Yes</strong> and only enter application Administrators, and possibly Contributors.<br>',
'If you select <strong>Yes</strong> then you must also select how users not included in the users list are treated.</p>',
'<p>Select between requiring email addresses and any alphanumeric value for Usernames.<br>',
'Generally, you should set this setting to <strong>E-mail Address</strong> if your application uses (or will be configured to use) a centralized authentication scheme such as Oracle Access Manager, or SSO.</p>',
'<p><em><strong>Note:</strong> This application supports the following 3 access levels: Reader, Contributor, and Administrator.',
'<ul>',
'  <li><strong>Readers</strong> have read-only access to all information and can also view reports.</li>',
'  <li><strong>Contributors</strong> can create, edit and delete information and view reports.</li>',
'  <li><strong>Administrators</strong>, in addition to Contributors capability, can also perform configuration of the application by accessing the Administration section of the application.</li>',
'</ul>',
'</em></p>'))
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2826976581162615244)
,p_name=>'CA.HELP.P10100.ACCESS.CONTROL.USERS.FORM'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Use this form to enter users, their email address and set their access level. ',
'The settings defined under <em>Configure Access Control</em> will determine whether the username must be their email address or can be any alphanumeric entry.</p>',
'<p>This application supports the following 3 access levels: Reader, Contributor, and Administrator.</p>',
'<ul>',
'  <li><strong>Readers</strong> have read-only access to all information and can also view reports.</li>',
'  <li><strong>Contributors</strong> can create, edit and delete information and view reports.</li>',
'  <li><strong>Administrators</strong>, in addition to Contributors capability, can also perform configuration of the application by accessing the Administration section of the application.</li>',
'</ul>',
'<p>When editing an existing user you can lock their account which will prevent them from accessing the application.</p>',
'<p><em><strong>Note:</strong>   If using Oracle APEX accounts then users entered here must also be defined as end users by a Workspace Administrator, who can also set their password.</em></p>'))
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2826976342638612479)
,p_name=>'CA.HELP.P10110.ACCESS.CONTROL.USERS.REPORT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>This page shows a report of the application users and the access level granted.</p>',
'<p>Click on the column headings to sort and filter data, or click on the <strong>Actions</strong> button to customize column display and many additional advanced features.<br>',
'Click the <strong>Reset</strong> button to reset the interactive report back to the default settings.</p>',
'<p>Click the edit icon (yellow pencil) to edit the user details and access level, or to delete the user.</p>',
'<p>Click <strong>Add User</strong>, at the top of the report, to add a new user and their access level.</p>'))
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922004835723286611)
,p_name=>'CA.HELP.P10120.ACCESS.ROLE'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>When Access Control is enabled, Administrators have the ability to restrict access to certain application features for authenticated users. This application supports the following 3 roles: Reader, Contributor, and Administrator.<p>',
'<ul>',
'  <li><strong>Readers</strong> have read-only access to all information and can also view reports.</li>',
'  <li><strong>Contributors</strong> can create,edit and delete information and view reports.</li>',
'  <li><strong>Administrators</strong>,in addition to Contributors capability,can also perform configuration of the application.</li>',
'</ul>'))
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3207347434988285326)
,p_name=>'CA.HELP.P10140_PRELIM_USERS'
,p_message_text=>'Enter usernames separated by commas, semicolons, or whitespace. Existing or duplicate usernames will automatically be ignored.'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2825367579878446008)
,p_name=>'CA.HELP.P10200.CONFIGURATION.SETTINGS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Configuration settings allow you to make specific functionality either available (enabled) or unavailable (disabled) to end users.</p>',
'<p>If a specific function is not 100% ready, or needs to be temporarily removed, click <strong>Disabled</strong>. ',
'Once it should be made available, simply click <strong>Enabled</strong>.</p>',
'<p><em><strong>Note:</strong> Changes made here will not be reflected for individual end users currently running the application. Once the end user signs out and then signs back in the revised feature settings will be invoked.</em></p>'))
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2826423433179501985)
,p_name=>'CA.HELP.P10300.THEME.SELECTOR'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Select the default color scheme used to display the application.</p>',
'<p>If <strong>Allow End Users to choose Theme Style</strong> is checked, then each end user can select from the available theme styles by clicking the <em>Customize</em> link in the bottom left corner of the Home page.</p>'))
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2826830998694577812)
,p_name=>'CA.HELP.P10400.ACTIVITY.REPORTING.ERROR.LOG'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>This page provides an interactive report of all unexpected errors logged by this application.</p>',
'<p>Click on the column headings to sort and filter data, or click on the <strong>Actions</strong> button to customize column display and many additional advanced features. Click the <strong>Reset</strong> button to reset the interactive report back t'
||'o the default settings.</p>'))
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2826830096634558140)
,p_name=>'CA.HELP.P10500.ACTIVITY.REPORTING.TOP.USERS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Use this report and chart to see the users with the most page views for the specified timeframe.</p>',
'<p>Select the reporting timeframe (Default = 1 day) and choose between the report and chart icons at the top of the page.</p>',
'<p>For the interactive report, use the search field, or select the <strong>User</strong> column heading, to select a specific user. You can perform numerous functions by clicking the <strong>Actions</strong> button, such as columns displayed / hidden'
||', rows per page, filter, and so forth. Click the <strong>Reset</strong> button to reset the interactive report back to the default settings.</p>'))
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2826831104027582004)
,p_name=>'CA.HELP.P10510.ACTIVITY.REPORTING.PERFORMANCE'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>This page provides an interactive report of the page performance and popularity. The report is ordered by <strong>Weighted Performance</strong> which is calculated by multiplying the Median Elapsed time and number of Page Views.</p>',
'<p>Select the reporting timeframe (Default = 1 day) at the top of the page as necessary.<br>',
'Click on the column headings to sort and filter data, or click on the <strong>Actions</strong> button to customize column display and many additional advanced features. Click the <strong>Reset</strong> button to reset the interactive report back to t'
||'he default settings.</p>'))
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2826831322945585747)
,p_name=>'CA.HELP.P10520.ACTIVITY.REPORTING.VIEWS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>This page provides an interactive report of the most recent page views.</p>',
'<p>Select the reporting timeframe (Default = 1 day) at the top of the page as necessary.<br>',
'Click on the column headings to sort and filter data, or click on the <strong>Actions</strong> button to customize column display and many additional advanced features. Click the <strong>Reset</strong> button to reset the interactive report back to t'
||'he default settings.</p>'))
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2825217243422439757)
,p_name=>'CA.HELP.P10600.NOTIFICATION'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Notifications are displayed on the home page when active.</p>',
'<p>This report shows the notifications defined and the time period when they are displayed.</p>',
'<p>Click the edit icon (yellow pencil) to edit an existing notification or click <strong>Add Notification</strong> to insert a new notification.</p>'))
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2826423921463504398)
,p_name=>'CA.HELP.P10700.APPLICATION.SETTINGS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Enter the application name and short description for the application.</p>',
'<p>The application name is displayed on home page. The short description is displayed below the application name.</p>'))
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2826826501142523824)
,p_name=>'CA.HELP.P10920.FEEDBACK.REPORT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Feedback can be entered by end users from any normal page within the application.</p>',
'<p>This report shows the feedback entered, any response enter by administrators, and the status of the feedback.</p>',
'<p>Click the edit icon (yellow pencil) to enter a response or update the feedback status.</p>',
'<p><em><strong>Note:</strong> If feedback recipients have been defined then feedback submissions will also be emailed to the email addresses in the feedback recipients list.</em></p>'))
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922384937268434693)
,p_name=>'CA.HELP.P10940.COMMA.SEP.EMAIL'
,p_message_text=>'Provide a comma-separated list of the email addresses.'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2826827842013539431)
,p_name=>'CA.HELP.P10940.FEEDBACK.SETTINGS'
,p_message_text=>'<p><strong>Enable Attachments</strong> - If yes, users will be able to upload an attachment in support of their feedback.</p>'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2827122248767651394)
,p_name=>'CA.HELP.P11000.EMAIL.TEMPLATES.REPORT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>This page lists the email templates defined and how many times the template has been referenced in emails sent.</p>',
''))
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2827121313728645843)
,p_name=>'CA.HELP.P11010.EMAIL.LOG'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>This page lists the emails sent.</p>',
'<p>Click the Magnifying Glass icon to view more details on the emails sent.</p>',
''))
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2827121708983648776)
,p_name=>'CA.HELP.P11020.EMAIL.TEMPLATES.FORM.EDIT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Enter the following fields to define an email template:</p>',
'<ul>',
'  <li><strong>Template Name</strong> (Mandatory) - Enter a meaningful name for the template.</li>',
'  <li><strong>HTML Template</strong> (Mandatory) - Enter the HTML code used to construct the email sent to recipients that allow the delivery of HTML-based emails.',
'    Substitution values include:',
'    <ul>',
'        <li><strong>#APP_NAME#</strong> - will be replaced by the name of the application</li>',
'        <li><strong>#BODY1#</strong> - will be replaced by the value passed in as p_body1_text</li> ',
'        <li><strong>#TABLE#</strong> - will be replaced by the value passed in as p_table_content, using the Table Open HTML, Table Row HTML and Table Close HTML</li> ',
'        <li><strong>#BODY2#</strong> - will be replaced by the value passed in as p_body2_text</li> ',
'        <li><strong>#ACTION#</strong> - will be replaced by the value passed in as p_action_label and p_action_link, using the Action Link template</li>',
'     </ul></li>',
'  <li><strong>Plain Text Template</strong> (Mandatory) - Enter the plain text used to construct the email sent to recipients that do not accept HTML-based emails.  This uses the same substitutions as the HTML Template except the #TABLE# and #ACTION# '
||'will be rendered as plain text.</li>',
'</ul>',
'<p>Additional HTML Templates allow for more advanced emails.  These items include:</p>',
'<ul>',
'  <li><strong>Before Rows</strong> - Enter HTML to replace #TABLE# in the HTML Template.  Only used if p_table_content is passed.</li>',
'  <li><strong>Row Template</strong> - Enter HTML to render each row of the table.  This includes the row open/close and data open/close using the #LABEL# and #VALUE# substitutions.    Only used if p_table_content is passed.</li>',
'  <li><strong>After Rows</strong> - Enter HTML to close the table or div.  Only used if p_table_content is passed.</li>',
'  <li><strong>Action Link HTML</strong> - Enter HTML to replace #ACTION# in the HTML Template.  It should contain #ACTION_LINK# and #ACTION_TEXT#.  Only used if p_action_label and p_action_link are passed.</li>',
'</ul>',
'<p><em><strong>Note:</strong> Use the entries within the <strong>default template</strong> as an example for developing your own template. The default template uses all of the substitution variables which you may or may not want to include within you'
||'r own email template.</em></p>'))
,p_version_scn=>14511008
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2827122660400653788)
,p_name=>'CA.HELP.P11030.EMAIL.SETTINGS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Enable or disable the sending of emails by selecting one of the <strong>Dispatch Emails</strong> options.</p>',
'<p>Enter the <strong>Emails Sent From</strong> using the email address of the primary contact for application issues.  This value can be used or overwritten when using the email feature.</p>',
''))
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922447627444850849)
,p_name=>'CA.HELP.P11030.EMAILS.FROM'
,p_message_text=>'This is the from address that will be used to send emails. It can be overwritten when using the email feature.'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3310998165895557234)
,p_name=>'CA.HELP.P11060.SEND.EMAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Populate the following items and click [Send Email].  All emails sent are logged in the Email Log.',
'    <ul>',
'        <li><strong>From</strong> - If a "From Address" is set within Email Settings, that email address will be an option to send from.  If this application uses Email Addresses as username, you can select to send emails from your email.  Lastly, yo'
||'u can always have the Send From be the same as the Send To.</li>',
'        <li><strong>Send To</strong> - If this application uses Email Addresses as username, you can select to send emails to Email Addresses and/or Users.</li>',
'        <li><strong>Email Addresses</strong> - Comma separated list of email addresses to receive the email. Those found to be invalid, will not be included.</li>',
'        <li><strong>Role</strong> - Send email to all users of a selected role or to all defined users.  Select list includes a list of roles and the count of users within that role.</li>',
'        <li><strong>Template</strong> - Select the email template to use to create the body of the email.</li>',
'        <li><strong>Subject</strong> - The subject of the email.</li>',
'        <li><strong>Email Body</strong> - Text to be included as the body of the email.</li>',
'        <li><strong>Allow Opt Out</strong> - Some emails should be sent regardless of the user opting out of receiving emails. These include outage messages, etc. This flag identifies if this email should be allowed to be opted out of or if it should'
||' be sent regardless of the user''s preference.</li>',
'</ul>',
'</p>'))
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3362798694332746063)
,p_name=>'CA.HELP.P11060.SEND.EMAIL.NO.ACL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Populate the following items and click [Send Email].  All emails sent are logged in the Email Log.',
'    <ul>',
'        <li><strong>From</strong> - If a "From Address" is set within Email Settings, that email address will be an option to send from.  Otherwise, you can always have the Send From be the same as the Send To.</li>',
'        <li><strong>Email Addresses</strong> - Comma separated list of email addresses to receive the email. Those found to be invalid, will not be included.</li>',
'        <li><strong>Template</strong> - Select the email template to use to create the body of the email.</li>',
'        <li><strong>Subject</strong> - The subject of the email.</li>',
'        <li><strong>Email Body</strong> - Text to be included as the body of the email.</li>',
'        <li><strong>Allow Opt Out</strong> - Some emails should be sent regardless of the user opting out of receiving emails. These include outage messages, etc. This flag identifies if this email should be allowed to be opted out of or if it should'
||' be sent regardless of the user''s preference.</li>',
'</ul>',
'</p>'))
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2826825625683510454)
,p_name=>'CA.HELP.P12000.TIME.ZONE.SUPPORT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Select the default time zone for all users of this application.</p>',
'<p>Individual users can override this setting by clicking their user name (top right) and selecting <strong>Preferences</strong>. Alternatively, they can click the time zone link displayed at the bottom of the home page.</p>'))
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922151157122767119)
,p_name=>'CA.HELP.P2000.PROFILE.PHOTO.DOWNLOAD'
,p_message_text=>'This page is not accessible directly through the UI. It is used to facilitate profile photo downloading.'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922148619304676217)
,p_name=>'CA.HELP.P20000.USER.PROFILE'
,p_message_text=>'The User Profile Page allows you to see relevant information about a user in one easy to use screen.'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922147937487653460)
,p_name=>'CA.HELP.P20030.PHOTO.UPLOAD'
,p_message_text=>'Please upload a photo with a square aspect ratio otherwise it may be distorted. The preferred image size is 250x250 pixels.'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2845154884735575084)
,p_name=>'CA.HELP.P20200.USER.PROFILE.MODAL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>This form allows you to update your personal details and upload a photo or avatar.</p>',
'<p>To upload an image, click <strong>Browse</strong> or drag and drop the image over the button.<br>',
'Please upload a photo with a square aspect ratio otherwise it may be distorted. The preferred image size is 250x250 pixels.</p>',
'<p>Click <strong>Delete Photo</strong> to remove the image.</p>',
''))
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922460710567062320)
,p_name=>'CA.HELP.P20210.ABOUT'
,p_message_text=>'All application help text can be accessed from this page. The links in the "Documentation" region give a much more in-depth explanation of the application''s features and functionality.'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2919482571627912253)
,p_name=>'CA.HELP.P20400.APP.PREF'
,p_message_text=>'You can set application preferences for your account from this page. The preferences can affect several aspects of the application such as time zone. Click the item-level help icons to learn what each preference does.'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(129926839055109215)
,p_name=>'CA.HELP.P20500.EMAIL.REPORTING'
,p_message_text=>'<p>This report shows all email queued to be sent and those already sent.</p>'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184690119298754624)
,p_name=>'CA.HELP.P20600.JOB.REPORTING'
,p_message_text=>'<p>This report includes all the jobs selected to be monitored by this application.  More details of each job can be viewed by clicking on the job name.</p>'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184714203018842404)
,p_name=>'CA.HELP.P20610.JOB.RUN.DETAILS'
,p_message_text=>'<p>This report includes the run details about the jobs selected to be monitored by this application.</p>'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2621228429576558138)
,p_name=>'CA.HELP.PAGE.DESC'
,p_message_text=>'Add about this application page'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2920780735107596548)
,p_name=>'CA.HELP.RECEIVE.EMAILS'
,p_message_text=>'Set this option to No if you do not want to receive emails from this application.'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3214738171028737188)
,p_name=>'CA.HELP.SEARCH.PAGE'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Enter a search term into the search dialog and click <strong>Search</strong>.<br>',
'Click on any of the result headings to navigate to that specific record.</p>',
'<p>To limit the search uncheck one or more Sources, which removes that report from the search results.</p>',
'<p>Click <strong>Reset</strong> to remove the current search term and check all Sources.</p> '))
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2920779829770579930)
,p_name=>'CA.HELP.TIME.ZONE'
,p_message_text=>'Set your preferred time zone for use throughout the application.'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(109929974733353866)
,p_name=>'CA.HIDDEN.ITEMS'
,p_message_text=>'Hidden Items'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2935892872459804960)
,p_name=>'CA.HOME'
,p_message_text=>'Home'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3035873643356247183)
,p_name=>'CA.HOME.PAGE'
,p_message_text=>'Home Page'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3431138501538994244)
,p_name=>'CA.HOURLY.PAGE.EVENTS'
,p_message_text=>'Hourly Page Events'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(129923857503088605)
,p_name=>'CA.HTML.BODY.SIZE'
,p_message_text=>'HTML Body Size'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922455608816950097)
,p_name=>'CA.HTML.TEMPLATE'
,p_message_text=>'HTML Template'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922403438085948059)
,p_name=>'CA.IN.PROGRESS'
,p_message_text=>'In Progress'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390023617312842111)
,p_name=>'CA.INCLUDEONFORMS'
,p_message_text=>'Include on Forms'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390023464598840999)
,p_name=>'CA.INCLUDEONREPORTS'
,p_message_text=>'Include on Reports'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2974177521902325138)
,p_name=>'CA.INSTALL.SUP.OBJ.SCRIPTS'
,p_message_text=>'Installing supporting object scripts'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184692122033767485)
,p_name=>'CA.INSTANCE.ID'
,p_message_text=>'Instance ID'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184695173855799041)
,p_name=>'CA.INSTANCE.STICKINESS'
,p_message_text=>'Instance Stickiness'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2762518213840408889)
,p_name=>'CA.INTRO.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Welcome to this cloud-only preview of a new and improved way to create a more fully-featured application. The standard Create Application Wizard only allows you to select pages to generate, while this wizard also allows you to quickly pre-load a n'
||'umber of additional features into your application.</p>',
'<p>Applications generated using this wizard will be fully supported and may also include Supporting Objects for selected features, such as Access Control, Email Framework, Feedback, and more.</p>',
''))
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2762781533965438228)
,p_name=>'CA.INTRO.HOWTO.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Start by entering an application name. Next add one or more pages to your application. Check the features you want included. Make choices about the application appearance and then review the settings.<br>',
'That is it - Click <strong>Create Application</strong> and you are away!</p>',
'<p>Click on <strong>View Blueprint</strong> to reuse the model from a previously generated application or to quickly replicate pages.</p>',
'<p><em><strong>Note:</strong> Each section and each ''Add Page'' includes detailed help to assist you further.</em></p>',
''))
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2762518563345411939)
,p_name=>'CA.INTRO.HOWTO.TITLE'
,p_message_text=>'How To Use This Wizard'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3123825716879847807)
,p_name=>'CA.INTRO.KNOWN.ISSUES.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Significant issues at the time of release are listed below:',
'<ol>',
'  <li>The Create Application from Blueprint Wizard is not translated.</li>',
'  <li>Translated applications generated with this wizard are only partially translated.</li>',
'  <li>Report Drill Down only allows one drill down column.</li>',
'  <li>Filter report pages can not be generated.</li>',
'  <li>Email feature provides the low level API, but does not yet include higher level email features.</li>',
'  <li>Generating an application from a Blueprint that references missing tables will fail ungracefully.</li>',
'  <li>Advanced Settings - Date Formats are not applied to the generated application.</li>',
'</ol>',
'</p>'))
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3123823976605830310)
,p_name=>'CA.INTRO.KNOWN.ISSUES.TITLE'
,p_message_text=>'Known Issues'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2762782109910444519)
,p_name=>'CA.INTRO.RELEASE.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Released %0.</p>',
'',
''))
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2762781751817439821)
,p_name=>'CA.INTRO.RELEASE.TITLE'
,p_message_text=>'Release Details'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2762108118828369911)
,p_name=>'CA.INTRO.TITLE'
,p_message_text=>'Create Application from a Blueprint Wizard {Cloud-Only Preview}'
,p_version_scn=>37165770887501
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921451320341951949)
,p_name=>'CA.IP.ADDRESS'
,p_message_text=>'IP Address'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921418434810209193)
,p_name=>'CA.IR.SEARCH'
,p_message_text=>'IR Search'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921455137119030743)
,p_name=>'CA.IR.SEARCHES'
,p_message_text=>'IR Searches'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390018003835801799)
,p_name=>'CA.ITEMNAME'
,p_message_text=>'Item Name'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184709829957825012)
,p_name=>'CA.JOB.ACTION'
,p_message_text=>'Job Action'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184713488151838482)
,p_name=>'CA.JOB.CLASS'
,p_message_text=>'Job Class'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184711641220830824)
,p_name=>'CA.JOB.CREATOR'
,p_message_text=>'Job Creator'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184713852932840370)
,p_name=>'CA.JOB.NAME'
,p_message_text=>'Job Name'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184699372032808033)
,p_name=>'CA.JOB.PRIORITY'
,p_message_text=>'Job Priority'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184689941217752204)
,p_name=>'CA.JOB.REPORTING'
,p_message_text=>'Job Reporting'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(218155149841501964)
,p_name=>'CA.JOB.REPORTING.DESC'
,p_message_text=>'View status and run details of jobs supporting this application'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184714091500841721)
,p_name=>'CA.JOB.RUN.DETAILS'
,p_message_text=>'Job Run Details'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184711817021831828)
,p_name=>'CA.JOB.STYLE'
,p_message_text=>'Job Style'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184712090408832630)
,p_name=>'CA.JOB.SUBNAME'
,p_message_text=>'Job Subname'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184710133093825908)
,p_name=>'CA.JOB.TYPE'
,p_message_text=>'Job Type'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184694387399796291)
,p_name=>'CA.JOB.WEIGHT'
,p_message_text=>'Job Weight'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390020401533811054)
,p_name=>'CA.KEYCOLUMN'
,p_message_text=>'Key Column'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390025200674859796)
,p_name=>'CA.LABEL'
,p_message_text=>'Label'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390021044358816377)
,p_name=>'CA.LABELCOLUMN'
,p_message_text=>'Label Column'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390025684829862973)
,p_name=>'CA.LABELPLURAL'
,p_message_text=>'Label Plural'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390025024442858169)
,p_name=>'CA.LABELSINGULAR'
,p_message_text=>'Label Singular'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2731732681309956661)
,p_name=>'CA.LANGUAGE'
,p_message_text=>'Language'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2731732870762978363)
,p_name=>'CA.LANGUAGE.DETAIL'
,p_message_text=>'Select the primary language for this application.'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3096535189070950803)
,p_name=>'CA.LANGUAGE.PAGE'
,p_message_text=>'<p>The primary language dictates the language used to display the pages and components generated in the App Builder. Selecting multiple translations will provide choices for your end users as to what language the runtime application is rendered using'
||'.</p>'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(304974196731546192)
,p_name=>'CA.LANGUAGE_SELECTOR'
,p_message_text=>'Language Selector'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922146882170633130)
,p_name=>'CA.LAST.NAME'
,p_message_text=>'Last Name'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184712213357833565)
,p_name=>'CA.LAST.RUN.DURATION'
,p_message_text=>'Last Run Duration'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184712494729834384)
,p_name=>'CA.LAST.START.DATE'
,p_message_text=>'Last Start Date'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3431139308858001384)
,p_name=>'CA.LATEST.ACTIVITY'
,p_message_text=>'Latest Activity'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390023818625843976)
,p_name=>'CA.LISTOFVALUES'
,p_message_text=>'List of Values'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3213478521559499976)
,p_name=>'CA.LOAD.BLUEPRINT'
,p_message_text=>'Load Blueprint'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184724822262861368)
,p_name=>'CA.LOG.DATE'
,p_message_text=>'Log Date'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184725241717862425)
,p_name=>'CA.LOG.ID'
,p_message_text=>'Log ID'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184696288660801521)
,p_name=>'CA.LOGGING.LEVEL'
,p_message_text=>'Logging Level'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(730217506078555409)
,p_name=>'CA.LOG_MESSAGES'
,p_message_text=>'Log Messages'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922445733354828314)
,p_name=>'CA.MANAGE.EMAIL.TEMPLATES'
,p_message_text=>'Manage Email Templates'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922430379075523813)
,p_name=>'CA.MANAGE.FEEDBACK'
,p_message_text=>'Manage Feedback'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921459552802091145)
,p_name=>'CA.MANAGE.USER.ACCESS'
,p_message_text=>'Manage User Access'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3471280999731244121)
,p_name=>'CA.MASTER'
,p_message_text=>'Add Master Detail Page'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3471288414436303902)
,p_name=>'CA.MASTER.DETAILS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Create a page which displays a master-detail page to enable end users to view and maintain data.<br>',
'&nbsp;</p>',
'<p>Enter the following attributes:</p>',
'<ul>',
'  <li><strong>Page Name</strong> (Mandatory) - Enter a name for this page.</li>',
'  <li><strong>Set Icon</strong> - Select an icon to display in the navigation menu for this page.</li>',
'  <li><strong>Page Type</strong> - Select the type of page [Side by Side, Stacked].<br></li>',
'    <strong>Side by Side</strong>: <br>',
'<em>A single page master-detail utilizing side by side layout and report regions with modal edit windows.</em>',
'    <ul>',
'      <li><strong>Table</strong> (Mandatory) - Select the master table for the page.</li>',
'      <li><strong>Primary Display Column</strong> (Mandatory) - Select the column to display in the list of master records.</li>',
'      <li><strong>Secondary Display Column</strong> (Mandatory) - Select the descriptive column to display in the list of master records, under the Primary Display Column.</li>',
'      <li><strong>Detail Table 1</strong> (Mandatory) - Select the first detail table for the page.</li>',
'      <li><strong>Detail Table 2</strong> - Select the second detail table for the page.</li>',
'      <li><strong>Detail Table 3</strong> - Select the third detail table for the page.</li>',
'      <li><strong>Detail Table 4</strong> - Select the forth detail table for the page.</li>',
'    </ul>',
'   <strong>Stacked</strong>: <br>',
'<em>A single page master-detail utilizing editable Interactive Grids.</em>',
'    <ul>',
'      <li><strong>Table</strong> (Mandatory) - Select the master table for the editable interactive grid.</li>',
'      <li><strong>Detail Table</strong> (Mandatory) - Select the detail table for the page.</li>',
'      <em><strong>Note:</strong> Only one detail table (editable interactive grid) can be added using the wizard. Additional detail tables can easily be added post-generation.</em>',
'    </ul>',
'</ul>'))
,p_version_scn=>14511157
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(304973226369525794)
,p_name=>'CA.MASTER_RECORDS'
,p_message_text=>'Master Records'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921424035363339579)
,p_name=>'CA.MAX.ELAPSED'
,p_message_text=>'Max Elapsed'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184698972208806077)
,p_name=>'CA.MAX.FAILURES'
,p_message_text=>'Maximum Failures'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184697284873802829)
,p_name=>'CA.MAX.RUN.DURATION'
,p_message_text=>'Maximum Run Duration'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184699122360806963)
,p_name=>'CA.MAX.RUNS'
,p_message_text=>'Maximum Runs'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390020826046814187)
,p_name=>'CA.MAXIMUMROWS'
,p_message_text=>'Maximum Rows'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390698185596533926)
,p_name=>'CA.MAXIMUMWIDTH'
,p_message_text=>'Maximum Width'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3126181581180824016)
,p_name=>'CA.MD.ADD.FILTER'
,p_message_text=>'Add Filter'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3126183593259837085)
,p_name=>'CA.MD.ADD.ROW'
,p_message_text=>'Add %0'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3126180843980820882)
,p_name=>'CA.MD.APPLY.FILTERS'
,p_message_text=>'Apply Filters'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3126412896618976531)
,p_name=>'CA.MD.DATE.VALUE'
,p_message_text=>'Date Value'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3126413378707980665)
,p_name=>'CA.MD.DATE.VALUE.2'
,p_message_text=>'Date Value 2'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3126181945758825467)
,p_name=>'CA.MD.EDIT'
,p_message_text=>'Edit'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3126178240841813052)
,p_name=>'CA.MD.FILTER'
,p_message_text=>'Filter'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3126178059153811617)
,p_name=>'CA.MD.FILTERS'
,p_message_text=>'Filters'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3126183758217839342)
,p_name=>'CA.MD.NO.FILTERS'
,p_message_text=>'No Filters'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3126179509905818776)
,p_name=>'CA.MD.NO.RECORD.SELECTED'
,p_message_text=>'No Record Selected'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3126178976405816668)
,p_name=>'CA.MD.NO.RECORDS.FOUND'
,p_message_text=>'No Records Found'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3126183137366832711)
,p_name=>'CA.MD.ROWS.DELETED'
,p_message_text=>'%0 deleted'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3126182568075829043)
,p_name=>'CA.MD.ROWS.UPDATED'
,p_message_text=>'%0 updated'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3126178493426813829)
,p_name=>'CA.MD.SEARCH'
,p_message_text=>'Search'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3126183974645840770)
,p_name=>'CA.MD.VALUE'
,p_message_text=>'Value'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3126184169832841956)
,p_name=>'CA.MD.VALUE.2'
,p_message_text=>'Value 2'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921423074548329461)
,p_name=>'CA.MEDIAN.ELAPSED'
,p_message_text=>'Median Elapsed'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922438936143762653)
,p_name=>'CA.MESSAGE'
,p_message_text=>'Message'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(729554545077431629)
,p_name=>'CA.MESSAGE_TYPE'
,p_message_text=>'Message Type'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390027217290886941)
,p_name=>'CA.METRIC'
,p_message_text=>'Metric'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921449350927924856)
,p_name=>'CA.MIN.ELAPSED'
,p_message_text=>'Min Elapsed'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921458107697077121)
,p_name=>'CA.MOBILE.PHONE'
,p_message_text=>'Mobile Phone'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921417804849202115)
,p_name=>'CA.MODE'
,p_message_text=>'Mode'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2928846548085702402)
,p_name=>'CA.MORE'
,p_message_text=>'More'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921455368325032970)
,p_name=>'CA.MOST RECENT'
,p_message_text=>'Most_Recent'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3431138963487998239)
,p_name=>'CA.MOST.ACTIVE.PAGES'
,p_message_text=>'Most Active Pages'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(110399486977448504)
,p_name=>'CA.MULTIPLE.REPORTS'
,p_message_text=>'Multiple Reports'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(110399647658472955)
,p_name=>'CA.MULTIPLE.REPORTS.DETAILS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Check one or more table or view names. Alternatively, click the check box in the header to select or deselect all the database objects listed.</p>',
'<p>A page with an interactive report will be added for each checked database object.</p>'))
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921386496226526275)
,p_name=>'CA.MUST.BE.VALID.TIMESTAMP'
,p_message_text=>'#LABEL# must be a valid timestamp.'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390026603542880599)
,p_name=>'CA.NAME'
,p_message_text=>'Name'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2731730321516892380)
,p_name=>'CA.NAVIGATION'
,p_message_text=>'Navigation'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2731730586046897188)
,p_name=>'CA.NAVIGATION.DETAIL'
,p_message_text=>'<p>Select if the menu displays on the side of the application or across the top of the application.</p>'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3966761056345225423)
,p_name=>'CA.NEGATIVE'
,p_message_text=>'Negative'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3966760844908224457)
,p_name=>'CA.NEUTRAL'
,p_message_text=>'Neutral'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3197576405458479166)
,p_name=>'CA.NEXT'
,p_message_text=>'Next'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184697835825804376)
,p_name=>'CA.NEXT.RUN.DATE'
,p_message_text=>'Next Run Date'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184694197799795488)
,p_name=>'CA.NLS.ENV'
,p_message_text=>'NLS Environment'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(259441579847037601)
,p_name=>'CA.NO'
,p_message_text=>'No'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922403644428949108)
,p_name=>'CA.NO.ACTION'
,p_message_text=>'No Action'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2987455550476259206)
,p_name=>'CA.NO.HELP.AVAILABLE'
,p_message_text=>'No help is available for this page.'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(109933953007368985)
,p_name=>'CA.NO.VALID.USER.EXIST.PAGEINFO'
,p_message_text=>'No Valid Users Exist - Page Info'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3207348955022315319)
,p_name=>'CA.NO.VALID.USER.FOUND'
,p_message_text=>'No valid new users found'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3093033482716995036)
,p_name=>'CA.NONE'
,p_message_text=>'None'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921458734477080901)
,p_name=>'CA.NOTE'
,p_message_text=>'Note'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2646817348406583711)
,p_name=>'CA.NOTIFICATION'
,p_message_text=>'Notifications'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2621233833044589005)
,p_name=>'CA.NOTIFICATION.DESC'
,p_message_text=>'Display notifications on the home page'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2646818500323599480)
,p_name=>'CA.NOTIFICATION.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Enables application administrators to specify either alerts (yellow) or errors (red) that display to all end users on the application home page. This feature is useful for relaying important information to your end user community.</p>',
'<p>Includes the following components:<ul>',
'<li>Ability to define notifications</li>',
'<li>Display of notification on application home page</li>',
'<li>Ability control the time window of notification display</li>',
'<li>Support for color coding of notifications by type</li>',
'</ul>',
'</p>'))
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921244095427102267)
,p_name=>'CA.NOTIFICATION.NAME'
,p_message_text=>'Name'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921418279248207207)
,p_name=>'CA.NUM.ROWS'
,p_message_text=>'Num Rows'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184709632159824117)
,p_name=>'CA.NUMBER.OF.ARGUMENTS'
,p_message_text=>'Number of Arguments'
,p_version_scn=>37165899652287
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184693717345792827)
,p_name=>'CA.NUMBER.OF.DESTINATIONS'
,p_message_text=>'Number of Destinations'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390022812404832999)
,p_name=>'CA.NUMBERFORMATMASK'
,p_message_text=>'Number Format Mask'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921449947643933379)
,p_name=>'CA.OCCURRENCE'
,p_message_text=>'Occurrence'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4055153107580160784)
,p_name=>'CA.ONE.ADMIN.REQUIRED'
,p_message_text=>'You cannot perform this action unless there is another administrator.'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922404223592955005)
,p_name=>'CA.OPEN'
,p_message_text=>'Open'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2647111031373283020)
,p_name=>'CA.ORGANIZING.PAGES'
,p_message_text=>'Organizing Pages'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2647114832697344347)
,p_name=>'CA.ORGANIZING.PAGES.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Arrange the pages in the order that you want them to appear in your application. <br>',
'To reorder pages in the list, click and hold the <em>Drag to reorder page</em> icon ( <span class="fa fa-bars" aria-hidden="true"></span> ) at the end of each page listing, and then drag and drop that page up or down.</p>',
'<p>The Home page always displays first and cannot be reordered.<br>',
'Administrative pages always display at the bottom of the list and the order dictates the order they appear in the Application Administration list on the Administration page.</p>'))
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184714613184843219)
,p_name=>'CA.OUTPUT'
,p_message_text=>'Output'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184724638770860473)
,p_name=>'CA.OWNER'
,p_message_text=>'Owner'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921417645579199082)
,p_name=>'CA.PAGE'
,p_message_text=>'Page'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921454613194022715)
,p_name=>'CA.PAGE.EVENTS'
,p_message_text=>'Page Events'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2938835944705259860)
,p_name=>'CA.PAGE.HELP'
,p_message_text=>'Page Help'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921451503098955061)
,p_name=>'CA.PAGE.ITEM'
,p_message_text=>'Page Item'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(306084580369305986)
,p_name=>'CA.PAGE.MD.EDIT_MASTER'
,p_message_text=>'Edit Master Record'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(306085151364316004)
,p_name=>'CA.PAGE.MD.PERFORM_SEARCH'
,p_message_text=>'Perform Search'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921416824294189829)
,p_name=>'CA.PAGE.NAME'
,p_message_text=>'Page Name'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2935898000767860540)
,p_name=>'CA.PAGE.NAVIGATION'
,p_message_text=>'Page Navigation'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921449719036928183)
,p_name=>'CA.PAGE.PERFORMANCE'
,p_message_text=>'Page Performance'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3206408857016053819)
,p_name=>'CA.PAGE.TYPE.NOT.VALID'
,p_message_text=>'The page type "%0" is not a valid type'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921423836679337395)
,p_name=>'CA.PAGE.VIEWS'
,p_message_text=>'Page Views'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2647122505941384402)
,p_name=>'CA.PAGES'
,p_message_text=>'Pages'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2647124679145403885)
,p_name=>'CA.PAGES.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Define page(s) to include in your initial application. You must define at least one page before you can create your application.</p>',
'<p>You can stub out your application by creating any number of pages using this wizard. After you create your application, use the Create Page Wizard to add more pages.</p>',
''))
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921448964769917006)
,p_name=>'CA.PARTIAL.PAGE.VIEWS'
,p_message_text=>'Partial Page Views'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922148130990659903)
,p_name=>'CA.PHOTO'
,p_message_text=>'Photo'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922161316240161037)
,p_name=>'CA.PHOTO.DELETED'
,p_message_text=>'Photo deleted.'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922148318819662307)
,p_name=>'CA.PHOTO.NAME'
,p_message_text=>'Photo Name'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922147703988645764)
,p_name=>'CA.PHOTO.UPLOAD'
,p_message_text=>'Photo Upload'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(729555122900439590)
,p_name=>'CA.PK_VALUE'
,p_message_text=>'Primary Key Value'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922456249113954248)
,p_name=>'CA.PLAIN.TEXT.TEMPLATE'
,p_message_text=>'Plain Text Template'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3966760656261222915)
,p_name=>'CA.POSITIVE'
,p_message_text=>'Positive'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2920379632736563641)
,p_name=>'CA.PREFERENCES'
,p_message_text=>'Preferences'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3628792320592380959)
,p_name=>'CA.PREVIOUS'
,p_message_text=>'Previous'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390024006095846922)
,p_name=>'CA.PRIMARYDISPLAYCOLUMN'
,p_message_text=>'Primary Display Column'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390026050362867650)
,p_name=>'CA.PRIMARYKEYCOLUMN'
,p_message_text=>'Primary Key Column'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390026294670870095)
,p_name=>'CA.PRIMARYPARENTTABLE'
,p_message_text=>'Primary Parent Table'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921450107191942687)
,p_name=>'CA.PROCEDURE'
,p_message_text=>'Procedure'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921186111635760269)
,p_name=>'CA.PROCESS.EMAIL.SUCCESS'
,p_message_text=>'Email preference updated.'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(306081884568225546)
,p_name=>'CA.PROCESS.FETCH_ROW'
,p_message_text=>'Fetch Row'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(730884159655757356)
,p_name=>'CA.PROCESS.GET_LOG_DETAIL'
,p_message_text=>'Get Log Detail'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921196362084932673)
,p_name=>'CA.PROCESS.THEME.PREFERENCE.SUCCESS'
,p_message_text=>'Application Appearance Settings Saved.'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921184726999736101)
,p_name=>'CA.PROCESS.TIME.ZONE.SUCCESS'
,p_message_text=>'Time zone preference updated.'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922150930242763343)
,p_name=>'CA.PROFILE.PHOTO.DOWNLOAD'
,p_message_text=>'Profile Photo Download'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184710544504827181)
,p_name=>'CA.PROGRAM.NAME'
,p_message_text=>'Program Name'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184711049660828195)
,p_name=>'CA.PROGRAM.OWNER'
,p_message_text=>'Program Owner'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(8400704891022574)
,p_name=>'CA.PUSH_NOTIFICATIONS'
,p_message_text=>'Push Notifications'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1802204012551267)
,p_name=>'CA.PUSH_NOTIFICATIONS.DESC'
,p_message_text=>'Allow users to receive push notifications'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(8400950437056990)
,p_name=>'CA.PUSH_NOTIFICATIONS.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Web push notifications are a way for web apps to send notifications to a user''s device even when the user is not currently on the website. These notifications can be sent to a user''s desktop or mobile device, and can be used to alert the user to n'
||'ew content or events on the website, or to re-engage the user with the website.</p>',
'<p>Enabling this option will:</p>',
'<ul>',
'<li>Add a new navigation bar entry: User Settings.</li>',
'<li>Allow users to subscribe and unsubscribe to push notifications.</li>',
'<li>When subscribed, allow users to receive push notifications from the APEX app.</li>',
'</ul>',
'<p><p/>'))
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(8303470570504542)
,p_name=>'CA.PWA'
,p_message_text=>'Install Progressive Web App'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(8303126569420677)
,p_name=>'CA.PWA.DESC'
,p_message_text=>'Give your app the ability to be installed'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(8303569104504543)
,p_name=>'CA.PWA.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Progressive Web Apps are web applications designed to be capable, reliable, and installable. A Progressive Web App feels like a platform-specific application.</p>',
'<p>Enabling this option will:</p>',
'<ul>',
'<li>Add a new navigation bar entry: Install App</li>',
'<li>Allow users to install this APEX app on devices</li>',
'</ul>',
'<p><p/>',
'<p>If Persistent Authentication is enabled for this instance, the Login Page will display a "Remember me" checkbox, which when selected, allows end users to stay signed in to their Progressive Web App.</p>',
'<p><p/>'))
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390024824586855924)
,p_name=>'CA.QUERY'
,p_message_text=>'Query'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184694772184797913)
,p_name=>'CA.RAISE.EVENTS'
,p_message_text=>'Raise Events'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(51353868030904935)
,p_name=>'CA.RATING'
,p_message_text=>'Rating'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921934855677205460)
,p_name=>'CA.READERS'
,p_message_text=>'Readers'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2920780137439587848)
,p_name=>'CA.RECEIVE.EMAILS'
,p_message_text=>'Receive Emails'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3431139186824999439)
,p_name=>'CA.RECENT.ERRORS'
,p_message_text=>'Recent Errors'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(561194524277112528)
,p_name=>'CA.RECENT.ERRORS.LABEL'
,p_message_text=>'Label'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(561194741717116834)
,p_name=>'CA.RECENT.ERRORS.VALUE'
,p_message_text=>'Value'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921244536718109466)
,p_name=>'CA.RED'
,p_message_text=>'Red'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922444587124818185)
,p_name=>'CA.REFERENCED'
,p_message_text=>'Referenced'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(305931329303042545)
,p_name=>'CA.REFRESH.ADMIN_PAGE'
,p_message_text=>'Refresh Admin Page'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(106496011282431005)
,p_name=>'CA.REFRESH.ON.DIALOG.CLOSE'
,p_message_text=>'Refresh on Dialog Close'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(306084859968311072)
,p_name=>'CA.REFRESH_REPORT'
,p_message_text=>'Refresh Report'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921242785371085147)
,p_name=>'CA.REGION.BUTTONS'
,p_message_text=>'Buttons Region'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921242506708082584)
,p_name=>'CA.REGION.FORM.ITEMS'
,p_message_text=>'Form Items Region'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921451787738957119)
,p_name=>'CA.REGION.ID'
,p_message_text=>'Region ID'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2935889526988777728)
,p_name=>'CA.RELEASE'
,p_message_text=>'Release %0'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2647112026204284365)
,p_name=>'CA.REMOVING.PAGES'
,p_message_text=>'Removing Pages'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2647113862303314729)
,p_name=>'CA.REMOVING.PAGES.DETAIL'
,p_message_text=>'<p>Click <strong>Edit</strong> to select the page, then click <strong>Delete Page</strong> to remove a page from your application.</p>'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184713690066839655)
,p_name=>'CA.REPEAT.INTERVAL'
,p_message_text=>'Repeat Interval'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(129925254742099427)
,p_name=>'CA.REPLY.TO'
,p_message_text=>'Reply To'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2722690195303784669)
,p_name=>'CA.REPORT'
,p_message_text=>'Add Report Page'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2722689894579782954)
,p_name=>'CA.REPORT.DETAILS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Create a page which displays either as an interactive report or a classic report.</p>',
'<p>Enter the following attributes:</p>',
'<ul>',
'  <li><strong>Page Name</strong> (Mandatory) - Enter a name for this page.</li>',
'  <li><strong>Set Icon</strong> - Select an icon to display in the navigation menu for this page.</li>',
'  <li><strong>Query Type</strong> - Select the source for the report [<strong>Table or View</strong> or <strong>SQL Query</strong>]:<br>',
'    <strong>Table or View</strong>:',
'    <ul>',
'      <li>Table or View (Mandatory) - Select the database object for the report.</li>',
'      <li>Include Form - Select to include a linked form page to enable users to maintain the table values.</li>',
'    </ul>',
'    <strong>SQL Query</strong>:',
'    <ul>',
'      <li>SQL Query (Mandatory) - Enter a valid SQL statement which returns distinct columns.</li>',
'    </ul>',
'  </li>',
'  <li><strong>Report Type</strong> - Select the type of report (<strong>Interactive Report</strong> or <strong>Classic Report</strong>).</li>',
'</ul>'))
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2639505674780625869)
,p_name=>'CA.REPORT.N.WITH.FORM'
,p_message_text=>'%0 with Form'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(626527526045993891)
,p_name=>'CA.REPORT.TABLE_NAME'
,p_message_text=>'%0 Report'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3405071059508413435)
,p_name=>'CA.REPORT.VIEW'
,p_message_text=>'Report View'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390028597888900267)
,p_name=>'CA.REPORTS'
,p_message_text=>'Reports'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184723207341856267)
,p_name=>'CA.REQ.START.DATE'
,p_message_text=>'Requested Start Date'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390697972613532537)
,p_name=>'CA.REQUIRED'
,p_message_text=>'Required'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922458096978996863)
,p_name=>'CA.RESET'
,p_message_text=>'Reset'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922403834124950043)
,p_name=>'CA.RESOLVED'
,p_message_text=>'Resolved'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922403192123945882)
,p_name=>'CA.RESPONSE'
,p_message_text=>'Response'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184699991090809019)
,p_name=>'CA.RESTART.ON.FAILURE'
,p_message_text=>'Restart on Failure'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184700217011810026)
,p_name=>'CA.RESTART.ON.RECOVERY'
,p_message_text=>'Restart on Recovery'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184691195850760870)
,p_name=>'CA.RESTARTABLE'
,p_message_text=>'Restartable'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184698734822805108)
,p_name=>'CA.RETRY.COUNT'
,p_message_text=>'Retry Count'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3351725351649654702)
,p_name=>'CA.ROLE'
,p_message_text=>'Role'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921452624642961195)
,p_name=>'CA.ROW.NUMBER'
,p_message_text=>'Row Number'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922456676511960168)
,p_name=>'CA.ROW.TEMPLATE'
,p_message_text=>'Row Template'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3320295483017269069)
,p_name=>'CA.ROW.TEMPLATE.HTML'
,p_message_text=>'Row Template HTML'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3358847878805966412)
,p_name=>'CA.ROWS.CONTENT'
,p_message_text=>'Rows Content'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921454937448029010)
,p_name=>'CA.ROWS.FETCHED'
,p_message_text=>'Rows Fetched'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390022382213828818)
,p_name=>'CA.ROWSPERPAGE'
,p_message_text=>'Rows Per Page'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184712836848835869)
,p_name=>'CA.RUN.COUNT'
,p_message_text=>'Run Count'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184720942320854525)
,p_name=>'CA.RUN.DURATION'
,p_message_text=>'Run Duration'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184697604379803639)
,p_name=>'CA.SCHEDULE.LIMIT'
,p_message_text=>'Schedule Limit'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184709079948822077)
,p_name=>'CA.SCHEDULE.NAME'
,p_message_text=>'Schedule Name'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184709439332823002)
,p_name=>'CA.SCHEDULE.OWNER'
,p_message_text=>'Schedule Owner'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184708472719820986)
,p_name=>'CA.SCHEDULE.TYPE'
,p_message_text=>'Schedule Type'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2731733063481980184)
,p_name=>'CA.SCHEMA'
,p_message_text=>'Schema'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2731733228397992154)
,p_name=>'CA.SCHEMA.DETAIL'
,p_message_text=>'<p>Select the database schema which stores the database objects you want to use in this application.</p>'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390018252112802925)
,p_name=>'CA.SCOPE'
,p_message_text=>'Scope'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922458366526000876)
,p_name=>'CA.SEARCH'
,p_message_text=>'Search'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922458581105002968)
,p_name=>'CA.SEARCH.APPLICATION'
,p_message_text=>'Search Application'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922458795420013267)
,p_name=>'CA.SEARCH.DIALOG'
,p_message_text=>'Search Dialog'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3407190128711818051)
,p_name=>'CA.SEARCH.FILTERS'
,p_message_text=>'Search Filters'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2979318503405336246)
,p_name=>'CA.SEARCH.HIDDEN.HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'This page is driven off of the Shared Component list called Searched Tables.',
'',
'Any Interactive Report pages initially generated from the Create Application wizard will automatically be added to the list. ',
'To add your own tables to the list then navigate to Shared Components, select Lists, and then click on Searched Tables.',
'  Enter the following attributes:',
'    Entry: List Entry Label - enter the display name for the table.',
'    Target: Page - select the appropriate page to navigate to (preferably an Interactive Report)',
'    Target: Clear Cache - enter any pages that need to be cleared (generally the same number as entered under Page).',
'       If navigating to an Interactive Report page then add CIR,RIR to clear any existing filters, and so forth.',
'    Target: Set these items - select (or enter) the appropriate page item to be populated.',
'       If navigating to an Interactive Report page then enter IR_[COLUMN_NAME].',
'    Target: With these values - enter =PK=',
'    User Defined Attributes: 1 - enter the table name to search in upper case.',
'    User Defined Attributes: 2 - enter the primary column name in upper case.',
'    User Defined Attributes: 3 (Optional) -  comma separated list of columns to search.',
'       If no columns are specified then all text (varchar2) and character large object (clob) columns are searched.',
'',
'Note: A list of available tables to search will only be displayed to users if more than one table is listed.'))
,p_version_scn=>37165899671117
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922457606955990007)
,p_name=>'CA.SEARCH.RESULTS'
,p_message_text=>'Search Results'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390025862465865497)
,p_name=>'CA.SECONDARYDISPLAYCOLUMN'
,p_message_text=>'Secondary Display Column'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922435318931719505)
,p_name=>'CA.SELECTED.TEMPLATE'
,p_message_text=>'Selected Template'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(129923640465087400)
,p_name=>'CA.SEND.BEGIN'
,p_message_text=>'Send Begin'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(129924419500094269)
,p_name=>'CA.SEND.COUNT'
,p_message_text=>'Send Count'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(129923113039086608)
,p_name=>'CA.SEND.END'
,p_message_text=>'Send End'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(129924204648093248)
,p_name=>'CA.SEND.ERROR'
,p_message_text=>'Send Error'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3760906540923234721)
,p_name=>'CA.SEND.FEEDBACK.EMAILS'
,p_message_text=>'Send Emails'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3761376521066295477)
,p_name=>'CA.SEND.FEEDBACK.EMAILS.HELP'
,p_message_text=>'Determines whether emails should be sent out when new feedback is received.'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3414689778981199651)
,p_name=>'CA.SEND.FROM'
,p_message_text=>'Send From'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3313145483929833340)
,p_name=>'CA.SEND.TO'
,p_message_text=>'Send To'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2935882209558754856)
,p_name=>'CA.SERIES'
,p_message_text=>'Series %0'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184720323546852349)
,p_name=>'CA.SESSION.ID'
,p_message_text=>'Session ID'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390018621208805615)
,p_name=>'CA.SESSIONSTATEPROTECTION'
,p_message_text=>'Session State Protection'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2731731806713947526)
,p_name=>'CA.SETTINGS'
,p_message_text=>'Settings'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2731732040025949725)
,p_name=>'CA.SETTINGS.DESC'
,p_message_text=>'<p>Specify the settings used in the generation of the application.</p>'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2928846372034701001)
,p_name=>'CA.SHOW.ALL'
,p_message_text=>'Show All'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(106120380074794251)
,p_name=>'CA.SHOW.HIDE.SCOPE'
,p_message_text=>'Show/Hide Scope'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2935896827679836189)
,p_name=>'CA.SHOW.TIMEZONE'
,p_message_text=>'Show Timezone'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2935892113919800507)
,p_name=>'CA.SIGN.IN'
,p_message_text=>'Sign In'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2939100174148497967)
,p_name=>'CA.SIGN.OUT'
,p_message_text=>'Sign Out'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184719716051851508)
,p_name=>'CA.SLAVE.PID'
,p_message_text=>'Slave PID'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184693965233793882)
,p_name=>'CA.SOURCE'
,p_message_text=>'Source'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3206409269930056506)
,p_name=>'CA.SOURCE.TYPE.NOT.VALID'
,p_message_text=>'The source type is not a valid type'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2979319378053356626)
,p_name=>'CA.SOURCES'
,p_message_text=>'Sources'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184708229509820188)
,p_name=>'CA.START.DATE'
,p_message_text=>'Start Date'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(729546580814157996)
,p_name=>'CA.STARTED'
,p_message_text=>'Started'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184713038749836550)
,p_name=>'CA.STATE'
,p_message_text=>'State'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390697770980531635)
,p_name=>'CA.STATICDEFAULT'
,p_message_text=>'Static Default'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921396060126891486)
,p_name=>'CA.STATUS'
,p_message_text=>'Status'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184695682815799995)
,p_name=>'CA.STOP.ON.WINDOW.CLOSE'
,p_message_text=>'Stop on Window Close'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184696057595800681)
,p_name=>'CA.STORE.OUTPUT'
,p_message_text=>'Store Output'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922436841225744965)
,p_name=>'CA.SUBJECT'
,p_message_text=>'Subject'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922162868348185141)
,p_name=>'CA.SUBMIT.FEEDBACK'
,p_message_text=>'Submit Feedback'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(729547977336167046)
,p_name=>'CA.SUCCESSFUL_ROWS'
,p_message_text=>'Successful Rows'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390020645932812421)
,p_name=>'CA.SUGGESTEDVISULIZATION'
,p_message_text=>'Suggested Visualization'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3092809477868655287)
,p_name=>'CA.SUPPORTING.OBJECTS'
,p_message_text=>'Supporting Objects'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3092810345861672837)
,p_name=>'CA.SUPPORTING.OBJECTS.DETAIL'
,p_message_text=>'<p>Enter code into the installation script, generally to create or manipulate database objects, or perform inserts / updates / deletes on existing records. Enter code into deinstallation, generally to remove (drop) database objects. These scripts wil'
||'l be incorporated into the Supporting Objects so that when you export the application it will perform these same updates in your test and production environments.</p>'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3092815282060745232)
,p_name=>'CA.SUPPORTING.OBJECTS.PAGE'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Enter valid SQL and/or PL/SQL statements into Installation Script which are run when the application is imported.</p>',
'<p>If you want these statements also run in the current environment, and not just when the application is imported into another environment, click <strong>Run when creating application</strong>.</p>',
'<p>Enter valid SQL and/or PL/SQL statements into Deinstallation Script which are run when the application is deleted from App Builder.</p>',
''))
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184694588562797200)
,p_name=>'CA.SYSTEM'
,p_message_text=>'System'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390024649542854875)
,p_name=>'CA.TABLE'
,p_message_text=>'Table'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2731733474202994238)
,p_name=>'CA.TABLE.PREFIX'
,p_message_text=>'Framework Object Prefix'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2731733627770005594)
,p_name=>'CA.TABLE.PREFIX.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Enter an object prefix for use by the application. Some features add this prefix to database objects that they create (including packages and tables).</p>',
'<p>Warning: Ensure you enter a unique prefix that is not used by other applications. If not unique, the application may raise errors when being created and not function correctly.</p>'))
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390026492417877892)
,p_name=>'CA.TABLECOLUMN'
,p_message_text=>'Table Column'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3313145601333834668)
,p_name=>'CA.TEMPLATE'
,p_message_text=>'Template'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922457454361978717)
,p_name=>'CA.TEMPLATE.EXISTS'
,p_message_text=>'This template name is already being used.'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922436605700742409)
,p_name=>'CA.TEMPLATE.NAME'
,p_message_text=>'Template Name'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921391954075741175)
,p_name=>'CA.TEXT'
,p_message_text=>'Text'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(129924099151089768)
,p_name=>'CA.TEXT.BODY.SIZE'
,p_message_text=>'Text Body Size'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922443385126804940)
,p_name=>'CA.TEXT.TEMPLATE'
,p_message_text=>'Text Template'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921194528874912239)
,p_name=>'CA.THEME.PREFERENCE'
,p_message_text=>'End User Theme Preference'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921195095555919908)
,p_name=>'CA.THEME.PREFERENCE.HELP'
,p_message_text=>'If checked, end users may choose their own Theme Style using the Customize link.'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921194874305916813)
,p_name=>'CA.THEME.PREFERENCE.LOV'
,p_message_text=>'Allow End Users to choose Theme Style'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2646819143387604543)
,p_name=>'CA.THEME.SELECTOR'
,p_message_text=>'Theme Style Selection'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2621229113321566682)
,p_name=>'CA.THEME.SELECTOR.DESC'
,p_message_text=>'Update default application look and feel'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2646819960845612088)
,p_name=>'CA.THEME.SELECTOR.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Enables administrators to select a default color scheme (theme style) for the application. Administrators can also choose to allow end users to choose their own theme style. End users can simply click on the <em>Customize</em> button at the bottom'
||' of the home page, and select from the available theme styles. For example, users with visual impairment may prefer to utilize the <em>Vista</em> theme style which has a much higher color contrast.</p>',
'<p>Includes the following components:',
'<ul>',
'<li>Allows administrators can define the default theme style</li>',
'<li>Enables end users to select various theme styles</li>',
'</ul>',
'</p>'))
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2731729942366878282)
,p_name=>'CA.THEME.STYLE'
,p_message_text=>'Theme Style'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2731730121275890778)
,p_name=>'CA.THEME.STYLE.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Select the default theme style used to display the application.</p>',
'<p>The style can readily be changed to another pre-defined style, or modified post generation. To change the style run the application and then click <strong>Theme Roller</strong> in the Developer toolbar.</p>'))
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921453283701967288)
,p_name=>'CA.TIME'
,p_message_text=>'Time'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2920380645020574978)
,p_name=>'CA.TIME.ZONE'
,p_message_text=>'Time Zone'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2646826518738991527)
,p_name=>'CA.TIME.ZONE.SUPPORT'
,p_message_text=>'Time Zone Support'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2621227560179541334)
,p_name=>'CA.TIME.ZONE.SUPPORT.DESC'
,p_message_text=>'Set default and user time zones'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2646825849153970053)
,p_name=>'CA.TIME.ZONE.SUPPORT.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Allow end users to set their local time zone. This is important if your application tables utilize time zone aware date types (such as Timestamp with Local Time Zone) so that the reports and data entry reflect where end users are located.</p>',
'<p>Includes the following components:',
'<ul>',
'<li>Allow administrators to set the default time zone</li>',
'<li>Allow end users to select their time zone preference</li>',
'</ul>',
'</p>'))
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3431140134673030776)
,p_name=>'CA.TIMEFRAME'
,p_message_text=>'Timeframe'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3471198075494170547)
,p_name=>'CA.TIMELINE'
,p_message_text=>'Add Timeline Page'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3471263289412222102)
,p_name=>'CA.TIMELINE.DETAILS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Create a page which displays a timeline which is especially useful for displaying updates.</p>',
'<p>Enter the following attributes:</p>',
'<ul>',
'  <li><strong>Page Name</strong> (Mandatory) - Enter a name for this page.</li>',
'  <li><strong>Set Icon</strong> - Select an icon to display in the navigation menu for this page.</li>',
'  <li><strong>Table or View</strong> (Mandatory) - Select the database object for the timeline.</li>',
'  <li><strong>User Name</strong> (Mandatory) - Select the column from the table or view to use as the user displayed for the timeline entries.</li>',
'  <li><strong>Date</strong> (Mandatory) - Select the column from the table or view to use as the date for the timeline entries.</li>',
'  <li><strong>Event Name</strong> (Mandatory) - Select the column from the table or view to use as the title for the timeline entries.</li>',
'  <li><strong>Description</strong> - Select the column from the table or view to use as the description for the timeline entries.</li>',
'</ul>'))
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921417259937197070)
,p_name=>'CA.TIMESTAMP'
,p_message_text=>'Timestamp'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921458393197078619)
,p_name=>'CA.TITLE'
,p_message_text=>'Title'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(129925677711102175)
,p_name=>'CA.TO'
,p_message_text=>'To'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921455540828037265)
,p_name=>'CA.TOP.USERS'
,p_message_text=>'Top Users'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921455762663042343)
,p_name=>'CA.TOP.USERS.CHART'
,p_message_text=>'Top Users Chart'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921448735460914737)
,p_name=>'CA.TOTAL.ROWS'
,p_message_text=>'Total Rows'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921935562871212226)
,p_name=>'CA.TREAT.AUTH.USERS.NO.IN.ACL.AS'
,p_message_text=>'Default role for users not in access control list:'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921392107428743788)
,p_name=>'CA.TYPE'
,p_message_text=>'Type'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(257374300535647357)
,p_name=>'CA.UI.DEFAULTS'
,p_message_text=>'UI Defaults'
,p_version_scn=>117498983
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(257375130198663952)
,p_name=>'CA.UI.DEFAULTS.DETAIL'
,p_message_text=>'Set defaults for user interface settings, such as rows per page, and add list of values definitions. These settings are used when generating components within the application. '
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921392548960746848)
,p_name=>'CA.UNTIL'
,p_message_text=>'Until'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(305009607760777247)
,p_name=>'CA.UPDATE'
,p_message_text=>'Update'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922150790998731722)
,p_name=>'CA.UPDATE.PROFILE'
,p_message_text=>'Update Profile'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921393275486754997)
,p_name=>'CA.UPDATED'
,p_message_text=>'Updated'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921393414512757711)
,p_name=>'CA.UPDATED.BY'
,p_message_text=>'Updated By'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921417094747195980)
,p_name=>'CA.USER'
,p_message_text=>'User'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3195379971078958197)
,p_name=>'CA.USER.ADD_MULTIPLE_1'
,p_message_text=>'Add Multiple Users - Step 1'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3195380265360959518)
,p_name=>'CA.USER.ADD_MULTIPLE_2'
,p_message_text=>'Add Multiple Users - Step 2'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3195380600243961060)
,p_name=>'CA.USER.ADD_MULTIPLE_USERS'
,p_message_text=>'Add Multiple Users'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921451161914950682)
,p_name=>'CA.USER.AGENT'
,p_message_text=>'User Agent'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2936351423782899523)
,p_name=>'CA.USER.COUNTS.REPORT'
,p_message_text=>'User Counts Report'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921457046707065611)
,p_name=>'CA.USER.NAME'
,p_message_text=>'Username'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922144971884615710)
,p_name=>'CA.USER.PROFILE'
,p_message_text=>'User Profile'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2646826254388983218)
,p_name=>'CA.USER.PROFILES'
,p_message_text=>'User Profiles'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2621225210234534185)
,p_name=>'CA.USER.PROFILES.DESC'
,p_message_text=>'Allow users to update their profile'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2646826025625981905)
,p_name=>'CA.USER.PROFILES.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Allow end users to enter in additional information about themselves, including a picture or avatar, to personalize their account.</p>',
'<p>Includes the following components:',
'<ul>',
'<li>Setting page for end users to set their profile</li>',
'<li>Ability to upload photo / avatar</li>',
'</ul>',
'</p>'))
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922146356654627051)
,p_name=>'CA.USERNAME'
,p_message_text=>'Username'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921936309585217163)
,p_name=>'CA.USERNAME.FORMAT'
,p_message_text=>'Username format'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3207348034031295734)
,p_name=>'CA.USERNAMES'
,p_message_text=>'Usernames'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(262698262181125779)
,p_name=>'CA.USERNAME_FORMAT'
,p_message_text=>'Username Format'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3207350632665341464)
,p_name=>'CA.USERS.ADDED'
,p_message_text=>'User(s) added.'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3350901784067397175)
,p_name=>'CA.USERS.BY.ROLE'
,p_message_text=>'Users by Role'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922439174861764791)
,p_name=>'CA.USERS.INCLUDED'
,p_message_text=>'Users Included'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3207348797143310587)
,p_name=>'CA.USERS.TO.ADD'
,p_message_text=>'Users to Add'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922003303237247880)
,p_name=>'CA.USRENAME.FORMAT.UPDATED'
,p_message_text=>'Username format updated.'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(109886988000332582)
,p_name=>'CA.VALID.USER.EXIST.PAGEINFO'
,p_message_text=>'Valid Users Exist - Page Info'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3056992948347852373)
,p_name=>'CA.VALIDATION.APP.ID'
,p_message_text=>'Application ID already exists, or is reserved for another application.'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(225738885909472966)
,p_name=>'CA.VALIDATION.APP.NAME.NOT.NULL'
,p_message_text=>'Application name must be specified.'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3353766588815615887)
,p_name=>'CA.VALIDATION.EMAIL.REQUIRED'
,p_message_text=>'Must provide email addresses to send your email to.'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3353765604996603820)
,p_name=>'CA.VALIDATION.EMAIL.ROLE.REQUIRED'
,p_message_text=>'Must provide email addresses or select a set of users to send your email to.'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3353766169610610955)
,p_name=>'CA.VALIDATION.ROLE.REQUIRED'
,p_message_text=>'Must select a set of users to send your email to.'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3057526203131860182)
,p_name=>'CA.VALIDATION.TABLE.PREFIX'
,p_message_text=>'Table prefix must not be greater than six characters, must start with a letter, and only contain letters, numbers, and underscores.'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3057936114198871699)
,p_name=>'CA.VALIDATION.TABLE.PREFIX.USED'
,p_message_text=>'Please enter a different Table Prefix. The following Database Objects already exist: %0'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922005918770308922)
,p_name=>'CA.VERIFY.EMAIL.ERROR'
,p_message_text=>'Username is not in a valid email address format. Please note the application''''s username format below.'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2922005735362304681)
,p_name=>'CA.VERIFY.EMAIL.FORMAT'
,p_message_text=>'Verify Email Format'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921456602216051989)
,p_name=>'CA.VIEW.AS'
,p_message_text=>'View As'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3108275020233179174)
,p_name=>'CA.VIEW.BLUEPRINT'
,p_message_text=>'View Blueprint'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2928846164943698203)
,p_name=>'CA.VIEW.DETAILS'
,p_message_text=>'View Details'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3354911907549227891)
,p_name=>'CA.VIEW.EMAIL'
,p_message_text=>'View Email'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2938962816876268130)
,p_name=>'CA.VIEW.MY.PROFILE'
,p_message_text=>'View My Profile'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921423268594331404)
,p_name=>'CA.WEIGHTED.PERFORMANCE'
,p_message_text=>'Weighted Performance'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3390698320925534642)
,p_name=>'CA.WIDTH'
,p_message_text=>'Width'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3649990863111799259)
,p_name=>'CA.WIZARD'
,p_message_text=>'Create Wizard Pages'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(109885017554270299)
,p_name=>'CA.WIZARD.CONTAINER'
,p_message_text=>'Wizard Container'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3649996196165836832)
,p_name=>'CA.WIZARD.DETAILS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Create a collection of pages to be used as a wizard. Generally wizards are used for entering data across multiple steps.</p>',
'<p>Enter the following attributes:</p>',
'<ul>',
'  <li><strong>Wizard Name</strong> (Mandatory) - Enter a name for this page.</li>',
'  <li><strong>Set Icon</strong> - Select an icon to display in the navigation menu for this page.</li>',
'  <li><strong>Page Mode</strong> (Mandatory) - Select whether the wizard steps display as normal page, modal dialog or drawer. Select <strong>Normal Page</strong>, <strong>Modal Dialog</strong> or <strong>Drawer</strong>.</li>',
'  <li><strong>Step 1 ... 8</strong> - Enter the page name for the steps of the wizard.<br><em><strong>Note:</strong> Steps 5 - 8 are displayed as a name is entered for each previous step.</em></li>',
'</ul>'))
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921457975337075480)
,p_name=>'CA.WORK.PHONE'
,p_message_text=>'Work phone'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2921244318988109066)
,p_name=>'CA.YELLOW'
,p_message_text=>'Yellow'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(259432601146036795)
,p_name=>'CA.YES'
,p_message_text=>'Yes'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(51319200328373190)
,p_name=>'CACHED'
,p_message_text=>'Cached'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(18836621004672418)
,p_name=>'CACHE_CREATED'
,p_message_text=>'Cache Created'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(13865615425766823)
,p_name=>'CALENDAR.CHECK.AJAX_DELETE_NOT_ENABLED'
,p_message_text=>'Delete Data functionality is disabled.'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(9010606424108252)
,p_name=>'CALENDAR.CHECK.AJAX_INSERT_NOT_ENABLED'
,p_message_text=>'Add data functionality is disabled.'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(9010817506111448)
,p_name=>'CALENDAR.CHECK.AJAX_UPDATE_NOT_ENABLED'
,p_message_text=>'Update data functionality is disabled.'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(73699120857866662)
,p_name=>'CALENDAR.NEXT'
,p_message_text=>'Next'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(73697304580861976)
,p_name=>'CALENDAR.PREVIOUS'
,p_message_text=>'Previous'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(21777513516626683)
,p_name=>'CALENDAR_EASY_TYPE'
,p_message_text=>'Easy Calendar'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(599926506288337367)
,p_name=>'CALENDAR_ENTRY_EDIT_PAGE'
,p_message_text=>'Edit Calendar Entry'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4305321288245834)
,p_name=>'CALENDAR_POPUP'
,p_message_text=>'Calendar pop-up for %0'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(47221208998715794)
,p_name=>'CALENDAR_SUCCESS_MSG'
,p_message_text=>'The calendar has been created successfully.'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(200695312104715640)
,p_name=>'CALENDAR_TEMPLATE'
,p_message_text=>'Legacy Calendar Template'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(21776104512624097)
,p_name=>'CALENDAR_TYPE'
,p_message_text=>'Calendar'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(138974622964506611)
,p_name=>'CAL_TEMPLATE_NOT_FOUND'
,p_message_text=>'No calendar templates found when attempting to copy template ID %1'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(202296720265917598)
,p_name=>'CANCEL'
,p_message_text=>'Cancel'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(6253014660797937)
,p_name=>'CARD_ACTIONS'
,p_message_text=>'Card Actions'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(455022416486968962)
,p_name=>'CASCADING STYLE SHEETS'
,p_message_text=>'Cascading Style Sheets'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(293195619978388103)
,p_name=>'CHANGES'
,p_message_text=>'Changes'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(740659070554031061)
,p_name=>'CHANGE_AUTHENTICATION'
,p_message_text=>'Change Authentication'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(195800222275030115)
,p_name=>'CHANGE_DATABASE_SIZE'
,p_message_text=>'Change Database Size'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(195796420020991565)
,p_name=>'CHANGE_REQUEST'
,p_message_text=>'Change Request'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(389072450102661347)
,p_name=>'CHANGE_WORKSPACE'
,p_message_text=>'Change Workspace'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184527231000483165)
,p_name=>'CHARACTER_SET_COLUMN'
,p_message_text=>'Character Set Column'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(88140824815817440)
,p_name=>'CHART'
,p_message_text=>'chart'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2958109427171268)
,p_name=>'CHART.CHART_QUERY_SYNTAX_INVALID'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Invalid chart query: %0<br><br>',
'Use the following syntax:',
'<pre>',
'SELECT LINK, LABEL, VALUE',
'FROM   ...',
'</pre>',
'<table class="instructiontext">',
'<tr><td>LINK</td><td>URL</td></tr>',
'<tr><td>LABEL</td><td>Text that goes with the bar</td></tr>',
'<tr><td>VALUE</td><td>Numeric column that defines bar size</td></tr>',
'</table>',
''))
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(69504705708239462)
,p_name=>'CHART.DIAL_CHART_QUERY_SYNTAX_INVALID'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Invalid chart query.<br /><br /> Use the following syntax: <pre> SELECT VALUE, MAX, (LOW), (HIGH) VALUE FROM ... </pre>',
'<table class="instructiontext">',
'<tr>',
'<td>VALUE</td>',
'<td>Numeric column that defines dial value.</td>',
'</tr>',
'<tr>',
'<td>MAX</td>',
'<td>Numeric column that defines Maximum dial value.</td>',
'</tr>',
'<tr>',
'<td>LOW (optional)</td>',
'<td>Numeric column that defines Minimum previous dial value.</td>',
'</tr>',
'<tr>',
'<td>HIGH (optional)</td>',
'<td>Numeric column that defines Maximum previous dial value.</td>',
'</tr>',
'</table>'))
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(91347420304253520)
,p_name=>'CHART.INVALID_CHART_TYPE_ERR'
,p_message_text=>'Invalid chart type.'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2953401799093358)
,p_name=>'CHART.INVALID_QUERY'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Failed to parse SQL query!',
'<p>%0</p>',
'Certain queries can only be executed when running your application, if your query appears syntactically correct, you can save your query without validation (see options below query source).'))
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1142980177132061296)
,p_name=>'CHART_DEGREES'
,p_message_text=>'degrees'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(175290602904159247)
,p_name=>'CHART_PAGE'
,p_message_text=>'%0 Chart'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(14515306749524246)
,p_name=>'CHART_SERIES'
,p_message_text=>'Chart Series'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(193582863065333859)
,p_name=>'CHART_SERIES_ERROR'
,p_message_text=>'Chart series error %0 for %1.'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(44579130448227170)
,p_name=>'CHART_SUCCESS_MSG'
,p_message_text=>'The chart has been created successfully.'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(179146631742550328)
,p_name=>'CHECKSUM_REQUIRED_APPLICATION'
,p_message_text=>'Checksum Required - Application Level'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(114385932590813391)
,p_name=>'CHECKSUM_REQUIRED_SESSION'
,p_message_text=>'Checksum Required - Session Level'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(114385521854810236)
,p_name=>'CHECKSUM_REQUIRED_USER'
,p_message_text=>'Checksum Required - User Level'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(114385122416800939)
,p_name=>'CHECKSUM_REQUIRED_WORKSPACE'
,p_message_text=>'Checksum Required - Application Level'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1198925881914331852)
,p_name=>'CHECK_ALL'
,p_message_text=>'Check All'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(170067226467546740)
,p_name=>'CLASSIC_CALENDAR'
,p_message_text=>'Classic Calendar'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(171347196809995472)
,p_name=>'CLASSIC_REPORT'
,p_message_text=>'Classic Report'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(68338261711239053)
,p_name=>'CLASSIC_REPORT_COLUMNS'
,p_message_text=>'Classic Report Columns'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(170214869730857302)
,p_name=>'CLASSIC_TREE'
,p_message_text=>'Classic Tree'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(169454129488056891)
,p_name=>'CLEAN_UP'
,p_message_text=>'Clean Up Page'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(12272112996747369)
,p_name=>'CLEAR_COMMAND'
,p_message_text=>'Clear Command'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(173214002327361890)
,p_name=>'CLOSED'
,p_message_text=>'Closed'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(192598428012185091)
,p_name=>'CLOSED_LAST_7_DAYS'
,p_message_text=>'Closed Last 7 Days'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(108366527719365876)
,p_name=>'CLOSE_WINDOW'
,p_message_text=>'Close Window'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(569810570021911617)
,p_name=>'CODE_EDITOR.ACCESSIBILITY_MODE'
,p_message_text=>'Accessibility Mode'
,p_is_js_message=>true
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1601539083859649)
,p_name=>'CODE_EDITOR.BRACKET_PAIR_COLORIZATION'
,p_message_text=>'Bracket Pair Colorization'
,p_is_js_message=>true
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1942172821221687)
,p_name=>'CODE_EDITOR.CHAT.AI_DEBUG_MESSAGE'
,p_message_text=>'Let me find out if I can help you with this problem...'
,p_is_js_message=>true
,p_version_scn=>127322887
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2067065080673299)
,p_name=>'CODE_EDITOR.CHAT.APEX_ASSISTANT'
,p_message_text=>'APEX Assistant'
,p_is_js_message=>true
,p_version_scn=>128942990
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1615042601007557)
,p_name=>'CODE_EDITOR.CHAT.CLEAR_CHAT'
,p_message_text=>'Clear chat'
,p_is_js_message=>true
,p_version_scn=>126766172
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1944059314005008)
,p_name=>'CODE_EDITOR.CHAT.CONTENT_TOO_LONG'
,p_message_text=>'The content is too long, please select the relevant code snippet before proceeding.'
,p_is_js_message=>true
,p_version_scn=>126894751
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1615223326268556)
,p_name=>'CODE_EDITOR.CHAT.DEBUG_HELP_LABEL'
,p_message_text=>'Help me fix this'
,p_is_js_message=>true
,p_version_scn=>126926706
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1943882299992240)
,p_name=>'CODE_EDITOR.CHAT.DEBUG_MESSAGE'
,p_message_text=>'Given your latest suggested code, and based on your role''s expertise, analyze the code. Your objective is to find, give an explanation and a solution of any semantic and syntactic errors found in the code.'
,p_is_js_message=>true
,p_version_scn=>128400207
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1614636815927683)
,p_name=>'CODE_EDITOR.CHAT.DISCLAIMER'
,p_message_text=>'Please note that AI-generated code may contain errors or security risks. Always review and validate all code before use.'
,p_is_js_message=>true
,p_version_scn=>127360209
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1944433659031093)
,p_name=>'CODE_EDITOR.CHAT.ERROR_CODE_MESSAGE'
,p_message_text=>'I have the following error: %0'
,p_is_js_message=>true
,p_version_scn=>128881709
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1613188788786998)
,p_name=>'CODE_EDITOR.CHAT.EXPLAIN'
,p_message_text=>'Explain'
,p_is_js_message=>true
,p_version_scn=>126847928
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1612811905774561)
,p_name=>'CODE_EDITOR.CHAT.EXPLAIN_MSG'
,p_message_text=>'I''m having trouble understanding this code block. Can you please explain it to me?'
,p_is_js_message=>true
,p_version_scn=>128399987
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1612644059769040)
,p_name=>'CODE_EDITOR.CHAT.EXPLAIN_SELECTION'
,p_message_text=>'Explain selection'
,p_is_js_message=>true
,p_version_scn=>126847992
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1614253069888170)
,p_name=>'CODE_EDITOR.CHAT.GENERAL_ASSISTANCE'
,p_message_text=>'General Assistance'
,p_is_js_message=>true
,p_version_scn=>126847848
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1613366697820601)
,p_name=>'CODE_EDITOR.CHAT.GENERAL_WELCOME'
,p_message_text=>'How may I assist you?'
,p_is_js_message=>true
,p_version_scn=>126847801
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1612020351746619)
,p_name=>'CODE_EDITOR.CHAT.IMPROVE'
,p_message_text=>'Improve'
,p_is_js_message=>true
,p_version_scn=>126848012
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1612479003763071)
,p_name=>'CODE_EDITOR.CHAT.IMPROVE_MSG'
,p_message_text=>'Help me improve the quality, efficiency, and security of this code block.'
,p_is_js_message=>true
,p_version_scn=>128400022
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1612219867756283)
,p_name=>'CODE_EDITOR.CHAT.IMPROVE_SELECTION'
,p_message_text=>'Improve selection'
,p_is_js_message=>true
,p_version_scn=>126848083
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1613819322856075)
,p_name=>'CODE_EDITOR.CHAT.INSERT'
,p_message_text=>'Insert'
,p_is_js_message=>true
,p_version_scn=>126761288
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1614061807857011)
,p_name=>'CODE_EDITOR.CHAT.INSERTED'
,p_message_text=>'Inserted'
,p_is_js_message=>true
,p_version_scn=>126761331
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2031104478693631)
,p_name=>'CODE_EDITOR.CHAT.NEW_CONVERSATION'
,p_message_text=>'New conversation started'
,p_is_js_message=>true
,p_version_scn=>128664057
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1614456618891715)
,p_name=>'CODE_EDITOR.CHAT.QUERY_BUILDER'
,p_message_text=>'Query Builder'
,p_is_js_message=>true
,p_version_scn=>126847871
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1613554265825796)
,p_name=>'CODE_EDITOR.CHAT.QUERY_BUILDER_WELCOME'
,p_message_text=>'Hi there, I can help you author SQL based on tables and views in your current schema. What can I help you query?'
,p_is_js_message=>true
,p_version_scn=>126847825
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1943412843950167)
,p_name=>'CODE_EDITOR.CHAT.QUICK_ACTION_QUESTION'
,p_message_text=>'I see you have selected some code. How can I assist you with it?'
,p_is_js_message=>true
,p_version_scn=>126894118
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1614801631959183)
,p_name=>'CODE_EDITOR.CHAT.USE_SELECTION'
,p_message_text=>'Use selection'
,p_is_js_message=>true
,p_version_scn=>126848107
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1943601007975573)
,p_name=>'CODE_EDITOR.CHAT.USE_THIS_WARNING'
,p_message_text=>'You need to select something in the editor first.'
,p_is_js_message=>true
,p_version_scn=>126894404
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1944641166035154)
,p_name=>'CODE_EDITOR.CHAT.WARNING_CODE_MESSAGE'
,p_message_text=>'I have the following warning: %0'
,p_is_js_message=>true
,p_version_scn=>128882367
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3070519427711217189)
,p_name=>'CODE_EDITOR.CLOSE'
,p_message_text=>'Close Notification'
,p_is_js_message=>true
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3070522899432239079)
,p_name=>'CODE_EDITOR.FIND'
,p_message_text=>'Find'
,p_is_js_message=>true
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3070522074151233947)
,p_name=>'CODE_EDITOR.HINT'
,p_message_text=>'Auto Complete'
,p_is_js_message=>true
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(612168158276666759)
,p_name=>'CODE_EDITOR.INDENTATION'
,p_message_text=>'Indentation'
,p_is_js_message=>true
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3070520692065225426)
,p_name=>'CODE_EDITOR.INDENT_SIZE'
,p_message_text=>'Indent Size'
,p_is_js_message=>true
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3070521006143228002)
,p_name=>'CODE_EDITOR.INDENT_WITH_TABS'
,p_message_text=>'Tab Inserts Spaces'
,p_is_js_message=>true
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(569810790574912980)
,p_name=>'CODE_EDITOR.ITEM_DOES_NOT_EXIST'
,p_message_text=>'Item %0 does not exist'
,p_is_js_message=>true
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(569814199996924865)
,p_name=>'CODE_EDITOR.MINIMAP'
,p_message_text=>'Minimap'
,p_is_js_message=>true
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(569813589575923845)
,p_name=>'CODE_EDITOR.MINIMAP_CONDITIONAL'
,p_message_text=>'Only when >100 lines'
,p_is_js_message=>true
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5704521977081437)
,p_name=>'CODE_EDITOR.NEXT_CHANGE'
,p_message_text=>'Next Change'
,p_is_js_message=>true
,p_version_scn=>42339255
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5705022020086340)
,p_name=>'CODE_EDITOR.PREVIOUS_CHANGE'
,p_message_text=>'Previous Change'
,p_is_js_message=>true
,p_version_scn=>42339255
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3128836128978446134)
,p_name=>'CODE_EDITOR.QUERY_BUILDER'
,p_message_text=>'Query Builder'
,p_is_js_message=>true
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3070523095943240568)
,p_name=>'CODE_EDITOR.REDO'
,p_message_text=>'Redo'
,p_is_js_message=>true
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(24283554067250207)
,p_name=>'CODE_EDITOR.ROLE_DESCRIPTION'
,p_message_text=>'editor'
,p_is_js_message=>true
,p_version_scn=>37165770887603
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(24283752625251254)
,p_name=>'CODE_EDITOR.ROLE_DESCRIPTION_READONLY'
,p_message_text=>'read only editor'
,p_is_js_message=>true
,p_version_scn=>37165770887603
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3070521611692231539)
,p_name=>'CODE_EDITOR.SETTINGS'
,p_message_text=>'Settings'
,p_is_js_message=>true
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3070521269331229061)
,p_name=>'CODE_EDITOR.SHOW_LINE_NUMBERS'
,p_message_text=>'Show Line Numbers'
,p_is_js_message=>true
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3070520035602220881)
,p_name=>'CODE_EDITOR.SHOW_RULER'
,p_message_text=>'Show Ruler'
,p_is_js_message=>true
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(569813320397922772)
,p_name=>'CODE_EDITOR.SUGGESTIONS'
,p_message_text=>'Show Suggestions'
,p_is_js_message=>true
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3070520878632226491)
,p_name=>'CODE_EDITOR.TAB_SIZE'
,p_message_text=>'Tab Size'
,p_is_js_message=>true
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3070520470054223867)
,p_name=>'CODE_EDITOR.THEMES'
,p_message_text=>'Theme'
,p_is_js_message=>true
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(569813196385921866)
,p_name=>'CODE_EDITOR.THEME_AUTOMATIC'
,p_message_text=>'Automatic'
,p_is_js_message=>true
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(569812586543921002)
,p_name=>'CODE_EDITOR.THEME_DARK'
,p_message_text=>'Dark'
,p_is_js_message=>true
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(569812117518919233)
,p_name=>'CODE_EDITOR.THEME_HIGH_CONTRAST_DARK'
,p_message_text=>'High Contrast Dark'
,p_is_js_message=>true
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(569812322936920041)
,p_name=>'CODE_EDITOR.THEME_LIGHT'
,p_message_text=>'Light'
,p_is_js_message=>true
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(569811505815917246)
,p_name=>'CODE_EDITOR.TRANSFORM_CODE_CASE'
,p_message_text=>'Transform Code Case'
,p_is_js_message=>true
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3070523290278241609)
,p_name=>'CODE_EDITOR.UNDO'
,p_message_text=>'Undo'
,p_is_js_message=>true
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(569811108660915040)
,p_name=>'CODE_EDITOR.UTIL_OFF'
,p_message_text=>'Off'
,p_is_js_message=>true
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(569811353619915622)
,p_name=>'CODE_EDITOR.UTIL_ON'
,p_message_text=>'On'
,p_is_js_message=>true
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3070521842786232830)
,p_name=>'CODE_EDITOR.VALIDATE'
,p_message_text=>'Validate'
,p_is_js_message=>true
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3070523400641242424)
,p_name=>'CODE_EDITOR.VALIDATION_SUCCESS'
,p_message_text=>'Validation successful'
,p_is_js_message=>true
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(569810967931914225)
,p_name=>'CODE_EDITOR.WHITESPACE'
,p_message_text=>'Show Whitespace'
,p_is_js_message=>true
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(146148925494206871)
,p_name=>'COLLAPSE'
,p_message_text=>'Collapse '
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15772413581087385)
,p_name=>'COLOR_PALETTE'
,p_message_text=>'Color Palette'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(89774508950852044)
,p_name=>'COLOR_PALETTE_ANALOGIC'
,p_message_text=>'Analogic'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(89772822887837167)
,p_name=>'COLOR_PALETTE_COMPLEMENTARY'
,p_message_text=>'Complementary'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(89780016578929941)
,p_name=>'COLOR_PALETTE_COMPLEMENTARY_COLORS'
,p_message_text=>'Complementary Colors'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(89774922456855939)
,p_name=>'COLOR_PALETTE_MONOTONE'
,p_message_text=>'Monotone'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(89773231544839616)
,p_name=>'COLOR_PALETTE_SPLIT_COMPLEMENTARY'
,p_message_text=>'Split complementary'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(89774118516845404)
,p_name=>'COLOR_PALETTE_TETRADE'
,p_message_text=>'Tetrade'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(89773606395841873)
,p_name=>'COLOR_PALETTE_TRIADE'
,p_message_text=>'Triad'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1034586128171471312)
,p_name=>'COLUMN_DISPLAY_NAME_LABEL'
,p_message_text=>'Display Name: %0'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145364716519189011)
,p_name=>'COLUMN_NAME'
,p_message_text=>'Column Name'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(261398804665946972)
,p_name=>'COM.ORACLE.APEX.ACL_ALL_USERS'
,p_message_text=>'All authenticated users can access this application'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(261399021093949653)
,p_name=>'COM.ORACLE.APEX.ACL_ONLY'
,p_message_text=>'Only users defined in the application access control list may access this application'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(261400110339952687)
,p_name=>'COM.ORACLE.APEX.ACL_SETTING_VALUE_INVALID'
,p_message_text=>'Unexpected Access Control Setting Value: %0'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(14634122985676876)
,p_name=>'COMING_SOON'
,p_message_text=>'Coming Soon'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145411825832238970)
,p_name=>'COMMENT'
,p_message_text=>'Comment'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(108970405030089481)
,p_name=>'COMPILE_FAILURE'
,p_message_text=>'Compilation failed,line <a href="javascript:goToLine(''%0'')">%0</a> (%2)<br />%1'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(277637601187810539)
,p_name=>'COMPILE_FAILURE_TRIGGER'
,p_message_text=>'Compilation failed, line %0 (%2) The line numbers associated with compilation errors are relative to the first BEGIN statement. This only affects the compilation of database triggers.<br />%1'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(108963117188045685)
,p_name=>'COMPILE_SUCCESS'
,p_message_text=>'PL/SQL code successfully compiled (%0)'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(172549003438857500)
,p_name=>'COMPLETE'
,p_message_text=>'Complete'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(176657008786028133)
,p_name=>'COMPLETED'
,p_message_text=>'Completed'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(180834903635975007)
,p_name=>'COMPLETE_NO_ISSUES'
,p_message_text=>'Complete / No issues'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(192600716855276486)
,p_name=>'COMPONENT'
,p_message_text=>'Component'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(336418909105289891)
,p_name=>'COMPONENT_NAME_LABEL'
,p_message_text=>'Component Name: %0'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(503109925131716571)
,p_name=>'COMPONENT_NOT_ENABLED'
,p_message_text=>'Component not enabled'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(45312630174882950)
,p_name=>'COMPONENT_SUCCESS_MSG'
,p_message_text=>'The component has been successfully created.'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(973696800733323792)
,p_name=>'COMPONENT_SUMMARY'
,p_message_text=>'Component Summary'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2160074111401563)
,p_name=>'COMPONENT_TYPE.AI_CONFIG'
,p_message_text=>'Generative AI Configuration'
,p_version_scn=>181599784
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3601001492839738)
,p_name=>'COMPONENT_TYPE.APP_ACL'
,p_message_text=>'Application Access Control Role'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3800214997860962)
,p_name=>'COMPONENT_TYPE.APP_COMPUTATION'
,p_message_text=>'Application Computation'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3800481017861988)
,p_name=>'COMPONENT_TYPE.APP_ITEM'
,p_message_text=>'Application Item'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3800694384862896)
,p_name=>'COMPONENT_TYPE.APP_PROCESS'
,p_message_text=>'Application Process'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3800871612863823)
,p_name=>'COMPONENT_TYPE.APP_SETTING'
,p_message_text=>'Application Setting'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3801083600865030)
,p_name=>'COMPONENT_TYPE.APP_STATIC_FILE'
,p_message_text=>'Application Static File'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3801274565865963)
,p_name=>'COMPONENT_TYPE.AUTHENTICATION'
,p_message_text=>'Authentication Scheme'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3807498567899636)
,p_name=>'COMPONENT_TYPE.AUTHORIZATION'
,p_message_text=>'Authorization Scheme'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3801420317866978)
,p_name=>'COMPONENT_TYPE.AUTOMATION'
,p_message_text=>'Automation'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3801642955868043)
,p_name=>'COMPONENT_TYPE.BREADCRUMB'
,p_message_text=>'Breadcrumb'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3802096797870070)
,p_name=>'COMPONENT_TYPE.BREADCRUMB_ENTRY'
,p_message_text=>'Breadcrumb Entry'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3801892605869095)
,p_name=>'COMPONENT_TYPE.BREADCRUMB_TEMPLATE'
,p_message_text=>'Breadcrumb Template'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3802426941872550)
,p_name=>'COMPONENT_TYPE.BUILD_OPTION'
,p_message_text=>'Build Option'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3802275313871380)
,p_name=>'COMPONENT_TYPE.BUILD_OPTION_STATUS'
,p_message_text=>'Build Option Status'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3802610033873691)
,p_name=>'COMPONENT_TYPE.BUTTON_TEMPLATE'
,p_message_text=>'Button Template'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3802887822874899)
,p_name=>'COMPONENT_TYPE.CALENDAR_TEMPLATE'
,p_message_text=>'Calendar Template'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5005762962232922)
,p_name=>'COMPONENT_TYPE.COMPONENT_GROUP'
,p_message_text=>'Component Group'
,p_version_scn=>15089495
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3803019024876030)
,p_name=>'COMPONENT_TYPE.CREDENTIAL'
,p_message_text=>'Credential'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3803406838878318)
,p_name=>'COMPONENT_TYPE.DATA_LOAD'
,p_message_text=>'Data Load'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3803621115879489)
,p_name=>'COMPONENT_TYPE.DATA_PROFILE'
,p_message_text=>'Data Profile'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3928560331448300)
,p_name=>'COMPONENT_TYPE.DUALITY_VIEW'
,p_message_text=>'Duality View'
,p_version_scn=>23494577
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2718621502374496)
,p_name=>'COMPONENT_TYPE.DYNAMIC_TRANSLATION'
,p_message_text=>'Dynamic Translation'
,p_version_scn=>9787507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3803853694880455)
,p_name=>'COMPONENT_TYPE.EMAIL_TEMPLATE'
,p_message_text=>'Email Template'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3928371628447360)
,p_name=>'COMPONENT_TYPE.JSON_SOURCE'
,p_message_text=>'JSON Source'
,p_version_scn=>23494408
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3804098990881460)
,p_name=>'COMPONENT_TYPE.LABEL_TEMPLATE'
,p_message_text=>'Label Template'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3803228452877372)
,p_name=>'COMPONENT_TYPE.LEGACY_DATA_LOAD'
,p_message_text=>'Data Load ( Legacy )'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3804432132883491)
,p_name=>'COMPONENT_TYPE.LIST'
,p_message_text=>'List'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2975027830389462)
,p_name=>'COMPONENT_TYPE.LIST_ENTRY'
,p_message_text=>'List Entry'
,p_version_scn=>51523235
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3804236136882472)
,p_name=>'COMPONENT_TYPE.LIST_TEMPLATE'
,p_message_text=>'List Template'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3804668478884754)
,p_name=>'COMPONENT_TYPE.LOV'
,p_message_text=>'List of Values'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1397990198384583)
,p_name=>'COMPONENT_TYPE.MAP_BACKGROUND'
,p_message_text=>'Map Background'
,p_version_scn=>37165881964536
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3804866310885930)
,p_name=>'COMPONENT_TYPE.MESSAGE'
,p_message_text=>'Text Message'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3805031220886956)
,p_name=>'COMPONENT_TYPE.NAVBAR'
,p_message_text=>'Navigation Bar Entry'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3805471348889102)
,p_name=>'COMPONENT_TYPE.PAGE'
,p_message_text=>'Page'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3805620193890414)
,p_name=>'COMPONENT_TYPE.PAGE_GROUP'
,p_message_text=>'Page Group'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3805232572888041)
,p_name=>'COMPONENT_TYPE.PAGE_TEMPLATE'
,p_message_text=>'Page Template'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3805850809891477)
,p_name=>'COMPONENT_TYPE.PARENT_TAB'
,p_message_text=>'Parent Tab'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3806030217892418)
,p_name=>'COMPONENT_TYPE.PLUGIN'
,p_message_text=>'Plug-in'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3806236877893450)
,p_name=>'COMPONENT_TYPE.PLUGIN_SETTINGS'
,p_message_text=>'Plug-in Settings'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3806417419894507)
,p_name=>'COMPONENT_TYPE.POPUP_LOV_TEMPLATE'
,p_message_text=>'Popup List of Values Template'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3809451544909666)
,p_name=>'COMPONENT_TYPE.PWA_SCREENSHOT'
,p_message_text=>'PWA Screenshot'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3809295250908628)
,p_name=>'COMPONENT_TYPE.PWA_SHORTCUT'
,p_message_text=>'PWA Shortcut'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3806694299895496)
,p_name=>'COMPONENT_TYPE.REGION_TEMPLATE'
,p_message_text=>'Region Template'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3806843909896576)
,p_name=>'COMPONENT_TYPE.REMOTE_SERVER'
,p_message_text=>'Remote Server'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3807052100897550)
,p_name=>'COMPONENT_TYPE.REPORT_LAYOUT'
,p_message_text=>'Report Layout'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3807652956900795)
,p_name=>'COMPONENT_TYPE.REPORT_QUERY'
,p_message_text=>'Report Query'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3807208169898542)
,p_name=>'COMPONENT_TYPE.REPORT_TEMPLATE'
,p_message_text=>'Report Template'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3808025892902570)
,p_name=>'COMPONENT_TYPE.SEARCH_CONFIG'
,p_message_text=>'Search Configuration'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3807841333901628)
,p_name=>'COMPONENT_TYPE.SHORTCUT'
,p_message_text=>'Shortcut'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3808252487903451)
,p_name=>'COMPONENT_TYPE.TAB'
,p_message_text=>'Tab'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3808423226904405)
,p_name=>'COMPONENT_TYPE.TASK_DEFINITION'
,p_message_text=>'Task Definition'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3201066258335556)
,p_name=>'COMPONENT_TYPE.TEMPLATE_COMPONENT'
,p_message_text=>'Template Component'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3808654210905348)
,p_name=>'COMPONENT_TYPE.TREE'
,p_message_text=>'Tree'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3808819742906399)
,p_name=>'COMPONENT_TYPE.WEB_SERVICE'
,p_message_text=>'Web Service'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3809053947907500)
,p_name=>'COMPONENT_TYPE.WEB_SOURCE'
,p_message_text=>'REST Data Source'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(132491971547266883)
,p_name=>'COMPONENT_TYPE.WORKFLOW'
,p_message_text=>'Workflow'
,p_version_scn=>37165874167242
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3809698134910588)
,p_name=>'COMPONENT_TYPE.WS_STATIC_FILE'
,p_message_text=>'Workspace Static File'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(26573222107305330)
,p_name=>'COMPUTATIONS'
,p_message_text=>'Computations'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(9382390952401323)
,p_name=>'COMP_GRP.DATA_LOAD_CANT_BE_REPLACED'
,p_message_text=>'Data Load Definition <strong>%0</strong> can''t be replaced in application %1. Please rename the component and try again.'
,p_version_scn=>80537153
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4313452895847515)
,p_name=>'COMP_GRP.DUALITY_VIEW_CANT_BE_REPLACED'
,p_message_text=>'Duality View <strong>%0</strong> can''t be replaced in application %1. Please rename the component and try again.'
,p_version_scn=>23971250
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4313612254850540)
,p_name=>'COMP_GRP.JSON_SOURCE_CANT_BE_REPLACED'
,p_message_text=>'JSON Source <strong>%0</strong> can''t be replaced in application %1. Please rename the component and try again.'
,p_version_scn=>23971590
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2201499517996605)
,p_name=>'COMP_GRP.MULTIPLE_COMPS_TO_SAME_COMP'
,p_message_text=>'Multiple components from <strong>application %0</strong> map to the same component <strong>%1</strong> in <strong>application %2</strong>. This can occur when a master component is renamed and a new component is created using the old name. To fix thi'
||'s issue, first publish the renamed master component and then try again.'
,p_version_scn=>80537154
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2200402402931257)
,p_name=>'COMP_GRP.PAGE_CANT_BE_REPLACED'
,p_message_text=>'Existing pages can''t be replaced. Please delete the page <strong>%0</strong> in application %1 and try again.'
,p_version_scn=>80537154
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(10176742276094315)
,p_name=>'COMP_GRP.REST_LOV_MASTER'
,p_message_text=>'LOV <strong>%0</strong> cannot be replaced in application %1 as the master LOV is based on a REST Data Source.'
,p_version_scn=>86675077
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(10176148308065028)
,p_name=>'COMP_GRP.REST_SEARCH_CONFIG_MASTER'
,p_message_text=>'Search Configuration <strong>%0</strong> cannot be replaced in application %1 as the master search configuration is based on a REST Data Source.'
,p_version_scn=>86675374
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1602203286310716)
,p_name=>'COMP_GRP.THEME_MUST_BE_SAME'
,p_message_text=>'Application %0 should use the same theme as Application %1.'
,p_version_scn=>80537154
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1602725890327957)
,p_name=>'COMP_GRP.THEME_VERSION_MUST_BE_SAME'
,p_message_text=>'The theme version of Application %0 should match the theme version of Application %1.'
,p_version_scn=>80537154
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(9381923388997097)
,p_name=>'COMP_GRP.WEB_SOURCE_CANT_BE_REPLACED'
,p_message_text=>'REST Data Source <strong>%0</strong> can''t be replaced in application %1. Please rename the component and try again.'
,p_version_scn=>80537154
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(219338505351768650)
,p_name=>'COMP_SUCCESS_MSG'
,p_message_text=>'Application components successfully installed.'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(109160603009082215)
,p_name=>'CONDITIONAL'
,p_message_text=>'Conditional'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(137153030635601954)
,p_name=>'CONDITIONS_POPUP_LOV'
,p_message_text=>'popup list of values'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(167846322494167848)
,p_name=>'CONDITIONS_SHORTCUT_ALWAYS'
,p_message_text=>'always'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(85091907321893783)
,p_name=>'CONDITIONS_SHORTCUT_EXISTS'
,p_message_text=>'exists'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(85053030944806028)
,p_name=>'CONDITIONS_SHORTCUT_EXPRESSION'
,p_message_text=>'Expression'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(85072900647835157)
,p_name=>'CONDITIONS_SHORTCUT_ITEM_E_VAL'
,p_message_text=>'item / column=value'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(85074028352843071)
,p_name=>'CONDITIONS_SHORTCUT_ITEM_NOT_NULL'
,p_message_text=>'item / column not null'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(572077911133276296)
,p_name=>'CONDITIONS_SHORTCUT_ITEM_NULL'
,p_message_text=>'item / column null'
,p_version_scn=>37165770887502
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(85094624290898694)
,p_name=>'CONDITIONS_SHORTCUT_NEVER'
,p_message_text=>'never'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(85097002603901871)
,p_name=>'CONDITIONS_SHORTCUT_NONE'
,p_message_text=>'none'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(85085927837880849)
,p_name=>'CONDITIONS_SHORTCUT_PAGE_IN'
,p_message_text=>'page in'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(85090223120888950)
,p_name=>'CONDITIONS_SHORTCUT_PAGE_NOT_IN'
,p_message_text=>'page not in'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(85075315669848918)
,p_name=>'CONDITIONS_SHORTCUT_REQ_E_E1'
,p_message_text=>'request=e1'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86865826552763427)
,p_name=>'CONDITION_TYPE'
,p_message_text=>'Condition Type'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(150820922375135385)
,p_name=>'CONFIRM'
,p_message_text=>'Confirm'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1819119104278786)
,p_name=>'CONFIRM.2_PAGE_MASTER_DETAIL'
,p_message_text=>'Two page master detail'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1818612871276983)
,p_name=>'CONFIRM.3_PAGE_MASTER_DETAIL'
,p_message_text=>'Three page master detail'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83741621054145676)
,p_name=>'CONFIRM.ACTUAL_NAME'
,p_message_text=>'Actual Name'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(172150321712797363)
,p_name=>'CONFIRM.AGG_COLS'
,p_message_text=>'Aggregate by Columns'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(172153114009814070)
,p_name=>'CONFIRM.AGG_FUNCTION'
,p_message_text=>'Aggregate Functions to Use'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83629211143452101)
,p_name=>'CONFIRM.APPLICATION'
,p_message_text=>'Application'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84960224553217479)
,p_name=>'CONFIRM.APPLICATION_ALIAS'
,p_message_text=>'Alias'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84960619143225429)
,p_name=>'CONFIRM.APPLICATION_DEFAULT_LANG'
,p_message_text=>'Default Language'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84959603774211504)
,p_name=>'CONFIRM.APPLICATION_NAME'
,p_message_text=>'Name'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(30326603162445855)
,p_name=>'CONFIRM.ARRAY'
,p_message_text=>'Result Tree to Report On'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(30327010434447956)
,p_name=>'CONFIRM.ARRAY_PARMS'
,p_message_text=>'Result Parameters to Report On'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84962917542234410)
,p_name=>'CONFIRM.AUTHENTICATION'
,p_message_text=>'Authentication'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(326398824931494617)
,p_name=>'CONFIRM.BRANCH_TO'
,p_message_text=>'Branch to Page'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(140245428775019902)
,p_name=>'CONFIRM.BREAK_COLUMNS'
,p_message_text=>'Break Columns'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83716430002044177)
,p_name=>'CONFIRM.BUTTON_BRANCH'
,p_message_text=>'%0 Button Branch'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83715032641035557)
,p_name=>'CONFIRM.BUTTON_TEXT'
,p_message_text=>'%0 Button Display Text'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(7012400231928635)
,p_name=>'CONFIRM.CALENDAR_ENABLE_AJAX_DATA_ADD'
,p_message_text=>'Enable Adding Data'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(7012215768904715)
,p_name=>'CONFIRM.CALENDAR_ENABLE_DRAG_AND_DROP'
,p_message_text=>'Enable Drag and Drop'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(261944706055469953)
,p_name=>'CONFIRM.CANCEL_BRANCH'
,p_message_text=>'Cancel Branch'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(326330706923489354)
,p_name=>'CONFIRM.CANCEL_LABEL'
,p_message_text=>'Cancel Button Label'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(297298419264914724)
,p_name=>'CONFIRM.CASE_SENSITIVE'
,p_message_text=>'Case Sensitive'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(108082004628024380)
,p_name=>'CONFIRM.CHANGE_INTERACTIVE_RPT_REGION'
,p_message_text=>'You have requested to change the Interactive Report query. If you removed any columns from the query, it will disable existing filters, highlight rules, and other report settings referencing those columns. Please confirm your request.'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83890404206424749)
,p_name=>'CONFIRM.CHART_AXIS'
,p_message_text=>'Chart Axis'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(203473409705410233)
,p_name=>'CONFIRM.CHART_DIAL'
,p_message_text=>'Dial'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(203474817324412439)
,p_name=>'CONFIRM.CHART_DIALSWEEP'
,p_message_text=>'Dial (Sweep)'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83959621325590507)
,p_name=>'CONFIRM.CHART_HORIZONTAL_BAR'
,p_message_text=>'Horizontal Bar'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83961310028596692)
,p_name=>'CONFIRM.CHART_LINE'
,p_message_text=>'Line'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83898511263436179)
,p_name=>'CONFIRM.CHART_NUMBER_MASK'
,p_message_text=>'Number Mask'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83960431021593278)
,p_name=>'CONFIRM.CHART_PIE'
,p_message_text=>'Pie'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83885909270416759)
,p_name=>'CONFIRM.CHART_QUERY'
,p_message_text=>'Chart Query'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83894412864427252)
,p_name=>'CONFIRM.CHART_SCALE'
,p_message_text=>'Scale'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83964025611601184)
,p_name=>'CONFIRM.CHART_SCATTER'
,p_message_text=>'Scatter'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83947427380554416)
,p_name=>'CONFIRM.CHART_SIZE'
,p_message_text=>'Chart Size'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83946611104549672)
,p_name=>'CONFIRM.CHART_TITLE'
,p_message_text=>'Chart Title'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83945731059546010)
,p_name=>'CONFIRM.CHART_TYPE'
,p_message_text=>'Chart Type'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83952810327568385)
,p_name=>'CONFIRM.CHART_VERTICAL_BAR'
,p_message_text=>'Vertical Bar'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(30342710322589858)
,p_name=>'CONFIRM.COLLECTION'
,p_message_text=>'Temporary Result Set Name'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83637803318535041)
,p_name=>'CONFIRM.COLUMNS'
,p_message_text=>'Columns'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(140179508287559813)
,p_name=>'CONFIRM.COLUMN_HEADING'
,p_message_text=>'Column Headings'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(240029700019433381)
,p_name=>'CONFIRM.COLUMN_NAME'
,p_message_text=>'Column Name'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(261994626271485277)
,p_name=>'CONFIRM.COLUMN_NAMES'
,p_message_text=>'Column Name(s)'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84312222269584337)
,p_name=>'CONFIRM.COL_HEAD_SORTING'
,p_message_text=>'Use Column Heading Sorting'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(115383228802117267)
,p_name=>'CONFIRM.COPY_APPLICATION'
,p_message_text=>'You have requested to copy an application with the following attributes. Please confirm your selections.'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84220229111255163)
,p_name=>'CONFIRM.COPY_PAGE'
,p_message_text=>'You have requested to copy a page with the following attributes.  Please confirm your selections.'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83681504750913953)
,p_name=>'CONFIRM.CREATE.NEW.TABSET'
,p_message_text=>'A new tab set "%0" will be created and used by this page.'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84958832256200806)
,p_name=>'CONFIRM.CREATE_APPLICATION'
,p_message_text=>'You have requested to create an application with the following attributes.  Please confirm your selections.'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84032115287777986)
,p_name=>'CONFIRM.CREATE_CALENDAR'
,p_message_text=>'You have requested to create a calendar page with the following attributes.   Please confirm your selections.'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84155707575069111)
,p_name=>'CONFIRM.CREATE_DRILL_DOWN'
,p_message_text=>'You have requested to create a drill down report page with the following attributes.   Please confirm your selections.'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(93460706616689925)
,p_name=>'CONFIRM.CREATE_DYNAMIC_QUERY'
,p_message_text=>'You have requested to create an Interactive Report page with the following attributes. Please confirm your selections.'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84279810401524144)
,p_name=>'CONFIRM.CREATE_EASY_REPORT'
,p_message_text=>'You have requested to create a report page with the following attributes.   Please confirm your selections.'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(852521928585935732)
,p_name=>'CONFIRM.CREATE_FLOW_APP_TEMPLATE'
,p_message_text=>'You have requested to create an application using the same ID as an existing application in the current workspace. The existing application will be deleted and then replaced by the new application. Please confirm your selections. '
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(236526520020512770)
,p_name=>'CONFIRM.CREATE_FORM_AND_LIST_VIEW'
,p_message_text=>'You have requested to create form and list view pages with the following attributes. Please confirm your selections.'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(172121326589675702)
,p_name=>'CONFIRM.CREATE_FORM_AND_REPORT_WITH_ANALYSIS'
,p_message_text=>'You have requested to create a form and a report page with analysis pages. Please confirm your selections.'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84013706452737578)
,p_name=>'CONFIRM.CREATE_FORM_ON_QUERY'
,p_message_text=>'You have requested to create a form on SQL query with the following attributes.   Please confirm your selections.'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84012121212732461)
,p_name=>'CONFIRM.CREATE_FORM_ON_SP'
,p_message_text=>'You have requested to create a form on stored procedure with the following attributes.   Please confirm your selections.'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84009924198723832)
,p_name=>'CONFIRM.CREATE_FORM_ON_TABLE'
,p_message_text=>'You have requested to create a form on a table page with the following attributes.   Please confirm your selections.'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(22395309050346102)
,p_name=>'CONFIRM.CREATE_FORM_ON_WS'
,p_message_text=>'You have requested to create a form on a Web service reference page with the following attributes.   Please confirm your selections.'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(38956009470728152)
,p_name=>'CONFIRM.CREATE_FORM_ON_WS_RPT'
,p_message_text=>'You have requested to create a form and report on a Web service reference page with the following attributes.   Please confirm your selections.'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184230915971057577)
,p_name=>'CONFIRM.CREATE_MAP'
,p_message_text=>'You have requested to create a Map page with the following attributes. Please confirm your selections.'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1807521688165980)
,p_name=>'CONFIRM.CREATE_MASTER_DETAIL'
,p_message_text=>'You have requested to create master detail pages with the following attributes. Please confirm your selections.'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84064716513891867)
,p_name=>'CONFIRM.CREATE_MENU'
,p_message_text=>'You have requested to create a breadcrumb region and breadcrumb option with the following attributes.  Please confirm your selections.'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(175431427677330268)
,p_name=>'CONFIRM.CREATE_MODE'
,p_message_text=>'Create Mode'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83996527399705856)
,p_name=>'CONFIRM.CREATE_PAGE'
,p_message_text=>'You have requested to create a page with the following attributes.  Please confirm your selections.'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1728744384958605947)
,p_name=>'CONFIRM.CREATE_PAGE_ID'
,p_message_text=>'Create Page'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1728745182668609740)
,p_name=>'CONFIRM.CREATE_PAGE_NAME'
,p_message_text=>'Create Page Name'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84110608342974700)
,p_name=>'CONFIRM.CREATE_QUERY_AND_UPDATE'
,p_message_text=>'You have requested to create form and report pages with the following attributes.  Please confirm your selections.'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(819414604293905684)
,p_name=>'CONFIRM.CREATE_REGION_PLUGIN_PAGE'
,p_message_text=>'You have requested to create a page with the following attributes. Please confirm your selections.'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84229312367316547)
,p_name=>'CONFIRM.CREATE_REPORT_PAGE'
,p_message_text=>'You have requested to create a report page with the following attributes.  Please confirm your selections.'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84015121343741885)
,p_name=>'CONFIRM.CREATE_SIMPLE_CHART'
,p_message_text=>'You have requested to create an HTML Bar Chart Page with the following attributes.  Please confirm your selections.'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84210505862220035)
,p_name=>'CONFIRM.CREATE_SUMMARY_PAGE'
,p_message_text=>'You have requested to create a summary page with the following attributes.  Press the "Add More" button to add additional items from other pages and/or regions. Press "Finish" to create the summary items.'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84022417665750334)
,p_name=>'CONFIRM.CREATE_SVG_CHART'
,p_message_text=>'You have requested to create a SVG chart page with the following attributes.  Please confirm your selections.'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83993721381694591)
,p_name=>'CONFIRM.CREATE_TABULAR_FORM'
,p_message_text=>'You have requested to create a tabular form page with the following attributes.   Please confirm your selections.'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84043324815818579)
,p_name=>'CONFIRM.CREATE_TREE'
,p_message_text=>'You have requested to create a tree page with the following attributes. Please confirm your selections.'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83997719911713164)
,p_name=>'CONFIRM.CREATE_WIZARD'
,p_message_text=>'You have requested to create a wizard with the following attributes.  Please confirm your selections.'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(138426605418559284)
,p_name=>'CONFIRM.CSV_TEXT'
,p_message_text=>'Link Label'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(615639618994709511)
,p_name=>'CONFIRM.DATA_LOAD_NAME'
,p_message_text=>'Data Load Definition Name'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(902243418172050374)
,p_name=>'CONFIRM.DATA_LOAD_NAME_EXISTS'
,p_message_text=>'This Data Load Definition will be recreated with the existing table lookups and transformation rules.'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(297302425498916480)
,p_name=>'CONFIRM.DATA_LOAD_PAGE'
,p_message_text=>'Page Number'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84032629271791502)
,p_name=>'CONFIRM.DATE_COLUMN'
,p_message_text=>'Date Column'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(175991709779651307)
,p_name=>'CONFIRM.DEFAULT_AUTH_SCHEME'
,p_message_text=>'Default Authentication Scheme'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83974520248637528)
,p_name=>'CONFIRM.DELETE_PROCESS'
,p_message_text=>'Delete'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84198211094174194)
,p_name=>'CONFIRM.DETAIL_DISPLAY_COLS'
,p_message_text=>'Detail %0 Display Columns'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1821022698289204)
,p_name=>'CONFIRM.DETAIL_DISPLAY_COLUMNS'
,p_message_text=>'Detail Display Column(s)'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84206614257203482)
,p_name=>'CONFIRM.DETAIL_MENU_COL'
,p_message_text=>'Detail Breadcrumb Column'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84201925770187894)
,p_name=>'CONFIRM.DETAIL_ORDER_BY'
,p_message_text=>'Detail Table %0 Order By'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84186212994136871)
,p_name=>'CONFIRM.DETAIL_PAGE'
,p_message_text=>'Detail Page %0'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1820614733286910)
,p_name=>'CONFIRM.DETAIL_TABLE'
,p_message_text=>'Detail Table'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84195110963164711)
,p_name=>'CONFIRM.DETAIL_TABLE_NAME'
,p_message_text=>'Detail Table Name %0'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84190831825151808)
,p_name=>'CONFIRM.DETAIL_TAB_LABEL'
,p_message_text=>'Detail Tab Label %0'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(262006612550490724)
,p_name=>'CONFIRM.DISPLAY_COLUMN'
,p_message_text=>'Upload Column'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83806217048305430)
,p_name=>'CONFIRM.DISPLAY_COLUMNS'
,p_message_text=>'Display Columns'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(239986813742259852)
,p_name=>'CONFIRM.DISPLAY_COLUMN_2'
,p_message_text=>'Upload Column 2'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(239987010938261114)
,p_name=>'CONFIRM.DISPLAY_COLUMN_3'
,p_message_text=>'Upload Column 3'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1859452456201370626)
,p_name=>'CONFIRM.EDIT_PAGE'
,p_message_text=>'Edit Page'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1859453093801372063)
,p_name=>'CONFIRM.EDIT_PAGE_NAME'
,p_message_text=>'Edit Page Name'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(135403411593346752)
,p_name=>'CONFIRM.ENABLE_CSV_OUTPUT'
,p_message_text=>'CSV Output'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(135411721280973906)
,p_name=>'CONFIRM.ENABLE_PRINT_OUTPUT'
,p_message_text=>'Print Output'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(135417522066030987)
,p_name=>'CONFIRM.ENABLE_SORTING'
,p_message_text=>'Enable Column Heading Sorting'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(150950888417606320)
,p_name=>'CONFIRM.EXISTING_PAGE'
,p_message_text=>'A region will be added to the existing Administration Page:'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(261948711249471482)
,p_name=>'CONFIRM.FINISH_BRANCH'
,p_message_text=>'Finish Branch'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84127322588007244)
,p_name=>'CONFIRM.FORM_PAGE'
,p_message_text=>'Form Page'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84127802979011040)
,p_name=>'CONFIRM.FORM_PAGE_NAME'
,p_message_text=>'Form Page Name'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84131125143017377)
,p_name=>'CONFIRM.FORM_PAGE_TAB_LABEL'
,p_message_text=>'Form Page Tab Label'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84130613022013946)
,p_name=>'CONFIRM.FORM_PAGE_TAB_SET'
,p_message_text=>'Form Page Tab Set'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(176126223883648900)
,p_name=>'CONFIRM.IMPORT_SHARED_COMPONENTS_FROM'
,p_message_text=>'Import Shared Components From'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(497202016211813883)
,p_name=>'CONFIRM.INCLUDE_CUSTOM_CALENDAR'
,p_message_text=>'Include Custom Calendar'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1821807592294307)
,p_name=>'CONFIRM.INCLUDE_MASTER_REPORT'
,p_message_text=>'Include master report?'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84204814126194016)
,p_name=>'CONFIRM.INC_BREAD_CRUMB'
,p_message_text=>'Include a Breadcrumb'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83712923160023286)
,p_name=>'CONFIRM.INFORMATION_TEMPLATE'
,p_message_text=>'Information Template'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83714207361028258)
,p_name=>'CONFIRM.INFORMATION_TEXT'
,p_message_text=>'Information Default Text'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(22397929884456194)
,p_name=>'CONFIRM.INPUT_ITEMS'
,p_message_text=>'Form Items'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(30345527815632745)
,p_name=>'CONFIRM.INPUT_REGION_TEMPLATE'
,p_message_text=>'Form Region Template'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(30344620542630727)
,p_name=>'CONFIRM.INPUT_REGION_TITLE'
,p_message_text=>'Form Region Title'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83972424965629402)
,p_name=>'CONFIRM.INSERT_PROCESS'
,p_message_text=>'Insert'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83701300173007240)
,p_name=>'CONFIRM.ITEMS'
,p_message_text=>'Items'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(262002604239488343)
,p_name=>'CONFIRM.KEY_COLUMN'
,p_message_text=>'Return Column'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(261859323014399107)
,p_name=>'CONFIRM.KEY_COLUMN_1'
,p_message_text=>'Lookup Key Column 1'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(261863529248400974)
,p_name=>'CONFIRM.KEY_COLUMN_2'
,p_message_text=>'Key Column 2'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(261867500636402127)
,p_name=>'CONFIRM.KEY_COLUMN_3'
,p_message_text=>'Key Column 3'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84035014164796574)
,p_name=>'CONFIRM.LABEL_COLUMN'
,p_message_text=>'Label Column'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(239994016865395131)
,p_name=>'CONFIRM.LOOKUP_OWNER'
,p_message_text=>'Lookup Owner'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(261998631812486824)
,p_name=>'CONFIRM.LOOKUP_TABLE'
,p_message_text=>'Lookup Table'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1822214518296327)
,p_name=>'CONFIRM.MASTER_DETAIL_LAYOUT'
,p_message_text=>'Master Detail Layout'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1820208846285276)
,p_name=>'CONFIRM.MASTER_DISPLAY_COLUMNS'
,p_message_text=>'Master Display Column(s)'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1821400320292291)
,p_name=>'CONFIRM.MASTER_SORT'
,p_message_text=>'Navigate master record by'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1819830532282011)
,p_name=>'CONFIRM.MASTER_TABLE'
,p_message_text=>'Master Table'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(140201620240601092)
,p_name=>'CONFIRM.MAXIMUM_COLUMNS'
,p_message_text=>'Maximum Number of Columns'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(138409209802536157)
,p_name=>'CONFIRM.MAX_ROWS'
,p_message_text=>'Rows Per Page'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(101146608951668706)
,p_name=>'CONFIRM.MENU'
,p_message_text=>'Breadcrumb'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84078523140922214)
,p_name=>'CONFIRM.MENU_LINK'
,p_message_text=>'Breadcrumb Link'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84205224169196952)
,p_name=>'CONFIRM.MENU_ROOT'
,p_message_text=>'Breadcrumb Root'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84076825779913529)
,p_name=>'CONFIRM.MENU_TEMPLATE'
,p_message_text=>'Breadcrumb Template'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84081702839925828)
,p_name=>'CONFIRM.MENU_TEXT'
,p_message_text=>'Breadcrumb Text'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(23172706604083715)
,p_name=>'CONFIRM.MIGRATE_HTML_TO_HTML5'
,p_message_text=>'You have requested to upgrade the HTML chart to a new HTML5 chart. Please confirm your request.'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(945251552534553999)
,p_name=>'CONFIRM.MIGRATE_JSTREE_TO_APEXTREE'
,p_message_text=>'You have requested to upgrade the jsTree to a new Tree. Please confirm your request.'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(73484029469295415)
,p_name=>'CONFIRM.MIGRATE_SVG_RESTRICTION'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'SVG chart will be upgraded with the following restrictions:  ',
'<ul>',
'<li>',
'Only number formats defined in axis format strings will be migrated.  Date and time formats will be ignored.',
'</li>',
'<li>',
'Number format elements containing the following will be migrated:',
'<br />',
'0,9,D,G,, (comma),. (period),$,C,L,FM',
'</li>',
'<li>',
'The label for each series in the Flash chart will be derived from each series'' column alias.  ',
'This differs from SVG charts, where the label for each series was derived from the Series Name attribute.',
'</li>',
'<li>',
'Flash Dial charts display actual values instead of percentages.',
'</li>',
'</ul>'))
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(46897809780048121)
,p_name=>'CONFIRM.MIGRATE_SVG_TO_HTML5'
,p_message_text=>'You have requested to upgrade the SVG chart to a HTML5 chart.  Please confirm your request.'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(818412717795920577)
,p_name=>'CONFIRM.NAVIGATION'
,p_message_text=>'Navigation'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84964129232256696)
,p_name=>'CONFIRM.NAV_BAR'
,p_message_text=>'Navigation Bar'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(486936856312805010)
,p_name=>'CONFIRM.NAV_LIST'
,p_message_text=>'Navigation Menu List'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(183300219613419824)
,p_name=>'CONFIRM.NEW_ADMIN_PAGE'
,p_message_text=>'A new Administration page will be added, Page:'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(108086300603032691)
,p_name=>'CONFIRM.NEW_COLUMNS'
,p_message_text=>'New Columns'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83743214259153187)
,p_name=>'CONFIRM.NEW_TEMPLATE'
,p_message_text=>'New Template'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(326296424454484962)
,p_name=>'CONFIRM.NEXT_LABEL'
,p_message_text=>'Next Button label'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83681105658904732)
,p_name=>'CONFIRM.NO.TABSET.SELECTED'
,p_message_text=>'No tab set has been selected for this page.'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83697102466998390)
,p_name=>'CONFIRM.NO_TEMPLATE'
,p_message_text=>'No Template'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(22398303004457852)
,p_name=>'CONFIRM.OUTPUT_ITEMS'
,p_message_text=>'Output Items'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83830823459345159)
,p_name=>'CONFIRM.OWNER'
,p_message_text=>'Owner'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83630915907472398)
,p_name=>'CONFIRM.PAGE'
,p_message_text=>'Page'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84963301528248741)
,p_name=>'CONFIRM.PAGES'
,p_message_text=>'Pages'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83631600108477324)
,p_name=>'CONFIRM.PAGE_NAME'
,p_message_text=>'Page Name'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83680707604895771)
,p_name=>'CONFIRM.PAGE_TITLE'
,p_message_text=>'Page Title'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84197231048170548)
,p_name=>'CONFIRM.PARENT_DISPLAY_COLS'
,p_message_text=>'Parent Display Columns'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84083520501930905)
,p_name=>'CONFIRM.PARENT_MENU'
,p_message_text=>'Parent Breadcrumb'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84205803176200356)
,p_name=>'CONFIRM.PARENT_MENU_COL'
,p_message_text=>'Parent Breadcrumb Column'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84199705684182098)
,p_name=>'CONFIRM.PARENT_ORDER_BY'
,p_message_text=>'Parent Table Order By'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84185527408131648)
,p_name=>'CONFIRM.PARENT_PAGE'
,p_message_text=>'Parent Page'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84194218450157460)
,p_name=>'CONFIRM.PARENT_TABLE_NAME'
,p_message_text=>'Parent Table Name'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83683732501950333)
,p_name=>'CONFIRM.PARENT_TAB_LABEL'
,p_message_text=>'Parent Tab Label'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83682916224945610)
,p_name=>'CONFIRM.PARENT_TAB_SET'
,p_message_text=>'Parent Tab Set'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(108037800020416014)
,p_name=>'CONFIRM.PARSING_SCHEMA'
,p_message_text=>'Parsing Schema'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113109016577114145)
,p_name=>'CONFIRM.PARTIAL_REFRESH_CALENDAR'
,p_message_text=>'Partial Page Refresh'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(326300431034486939)
,p_name=>'CONFIRM.PREVIOUS_LABEL'
,p_message_text=>'Previous Button label'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83639108990546076)
,p_name=>'CONFIRM.PRIMARY_KEY'
,p_message_text=>'Primary Key Column %0'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84134515924024248)
,p_name=>'CONFIRM.PRIMARY_KEY_COLUMN'
,p_message_text=>'Primary Key Column'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(138427015115562017)
,p_name=>'CONFIRM.PRINT_FORMAT'
,p_message_text=>'Output Format'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(140263022260197709)
,p_name=>'CONFIRM.PRINT_LABEL'
,p_message_text=>'Print Link Label'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(138432405212644324)
,p_name=>'CONFIRM.PRINT_OUTPUT'
,p_message_text=>'Report Printing'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83810010945313161)
,p_name=>'CONFIRM.PROCESS_OPTIONS'
,p_message_text=>'Process Options'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(138411310541564744)
,p_name=>'CONFIRM.REGION_COLUMN'
,p_message_text=>'Region Column'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83706502382017360)
,p_name=>'CONFIRM.REGION_TEMPLATE'
,p_message_text=>'Region Template'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83634724050512649)
,p_name=>'CONFIRM.REGION_TITLE'
,p_message_text=>'Region Title'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84070419415902174)
,p_name=>'CONFIRM.REGION_TYPE'
,p_message_text=>'Region Type'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(108084024021029996)
,p_name=>'CONFIRM.REMOVED_COLUMNS'
,p_message_text=>'Removed Columns'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(146155504163285903)
,p_name=>'CONFIRM.REPORT_IMPLEMENTATION'
,p_message_text=>'Report Implementation'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84122401678991717)
,p_name=>'CONFIRM.REPORT_PAGE'
,p_message_text=>'Report Page'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84123216223995906)
,p_name=>'CONFIRM.REPORT_PAGE_NAME'
,p_message_text=>'Report Page Name'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84126911852004107)
,p_name=>'CONFIRM.REPORT_PAGE_TAB_LABEL'
,p_message_text=>'Report Page Tab Label'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84125830768000098)
,p_name=>'CONFIRM.REPORT_PAGE_TAB_SET'
,p_message_text=>'Report Page Tab Set'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(30346630024642892)
,p_name=>'CONFIRM.REPORT_REGION_TEMPLATE'
,p_message_text=>'Report Region Template'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(30346223790641127)
,p_name=>'CONFIRM.REPORT_REGION_TITLE'
,p_message_text=>'Report Region Title'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84290214818544312)
,p_name=>'CONFIRM.REPORT_TEMPLATE'
,p_message_text=>'Report Template'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(32197317394970783)
,p_name=>'CONFIRM.ROW_VERSION_COLUMN'
,p_message_text=>'Row Version Column'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84295815296553924)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME1'
,p_message_text=>'default: HTML (standard)'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84300617505563987)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME11'
,p_message_text=>'default: Look 1'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84303328240567119)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME12'
,p_message_text=>'default: Look 2'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(107705726948742483)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME13'
,p_message_text=>'default: Look 3'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(107707500760744404)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME14'
,p_message_text=>'default: Look 4'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(31532527800826069)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME15'
,p_message_text=>'default: Look 5'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84297930533558343)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME2'
,p_message_text=>'default: vertical report'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84305108285570856)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME21'
,p_message_text=>'export: CSV'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84306817636573518)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME22'
,p_message_text=>'export: XML'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84299206769560958)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME3'
,p_message_text=>'default: vertical report, look 1 (include null columns)'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(107696406385727073)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME4'
,p_message_text=>'default: vertical report, look 2 (exclude null columns)'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(107703919330740339)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME5'
,p_message_text=>'default: vertical report, look 2 (include null columns)'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(262104926880504309)
,p_name=>'CONFIRM.RULE_NAME'
,p_message_text=>'Rule Name'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(262128900345506131)
,p_name=>'CONFIRM.RULE_SEQUENCE'
,p_message_text=>'Sequence'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(262132904847507404)
,p_name=>'CONFIRM.RULE_TYPE'
,p_message_text=>'Rule Type'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(14409918408338346)
,p_name=>'CONFIRM.RUN_SCRIPT'
,p_message_text=>'You have requested to run the following script.  Please confirm your request.'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84077510673918613)
,p_name=>'CONFIRM.SEQUENCE'
,p_message_text=>'Sequence'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84073108810908627)
,p_name=>'CONFIRM.SLOT'
,p_message_text=>'Slot'
,p_version_scn=>37165770887503
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84293027285547888)
,p_name=>'CONFIRM.SORT_OPTION'
,p_message_text=>'Sort Option'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83866207707378452)
,p_name=>'CONFIRM.SQL_QUERY'
,p_message_text=>'SQL Query'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113107824411106963)
,p_name=>'CONFIRM.STANDARD_CALENDAR'
,p_message_text=>'Standard'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(150744926557143983)
,p_name=>'CONFIRM.STARTING_PAGE'
,p_message_text=>'Multiple pages will be created, starting with Page:'
,p_version_scn=>37165770887506
);
end;
/
begin
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83837400041347840)
,p_name=>'CONFIRM.STORED_PROCEDURE_NAME'
,p_message_text=>'Stored Procedure Name'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(108747129005840662)
,p_name=>'CONFIRM.STORED_PROCEDURE_OWNER'
,p_message_text=>'Stored Procedure Owner'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(326383316273492066)
,p_name=>'CONFIRM.SUBMIT_LABEL'
,p_message_text=>'Finish Button Label'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(926588757347489760)
,p_name=>'CONFIRM.SUBSCRIBE_THEME'
,p_message_text=>'Subscribe Theme'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83739605816141345)
,p_name=>'CONFIRM.SUGGESTED_NAME'
,p_message_text=>'Suggested Name'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(172146718334777420)
,p_name=>'CONFIRM.TABLE'
,p_message_text=>'Table / View'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(172147430454780949)
,p_name=>'CONFIRM.TABLE_COLS'
,p_message_text=>'Summarize By Column'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(355173116897830984)
,p_name=>'CONFIRM.TABLE_LOOKUPS'
,p_message_text=>'Table Lookups'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83636820502530530)
,p_name=>'CONFIRM.TABLE_NAME'
,p_message_text=>'Table Name'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83635906650526508)
,p_name=>'CONFIRM.TABLE_OWNER'
,p_message_text=>'Table Owner'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(438030407548222259)
,p_name=>'CONFIRM.TABLE_RULE'
,p_message_text=>'Transformation Rule'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(262136920431511936)
,p_name=>'CONFIRM.TABLE_RULES'
,p_message_text=>'Transformation Rules'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(108113313936798447)
,p_name=>'CONFIRM.TABLE_VIEW_NAME'
,p_message_text=>'Table / View Name'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(108112908049796749)
,p_name=>'CONFIRM.TABLE_VIEW_OWNER'
,p_message_text=>'Table / View Owner'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84963718151253552)
,p_name=>'CONFIRM.TABS'
,p_message_text=>'Tabs'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83682414708935691)
,p_name=>'CONFIRM.TABSET.INCOMPLETE'
,p_message_text=>'Warning, tabset information is incomplete.'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83635525566522484)
,p_name=>'CONFIRM.TAB_LABEL'
,p_message_text=>'Tab Label'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84231926696330131)
,p_name=>'CONFIRM.TAB_NAME'
,p_message_text=>'Tab Name'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83635112060518636)
,p_name=>'CONFIRM.TAB_SET'
,p_message_text=>'Tab Set'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84308130103577082)
,p_name=>'CONFIRM.TEMPLATE'
,p_message_text=>'template:'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84056714735863028)
,p_name=>'CONFIRM.TREE_LOV'
,p_message_text=>'Based on new item with popup list of values'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84054528672848151)
,p_name=>'CONFIRM.TREE_MAX_LEVEL'
,p_message_text=>'Max Levels'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84048902221830992)
,p_name=>'CONFIRM.TREE_NAME'
,p_message_text=>'Tree Name'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84055323954856200)
,p_name=>'CONFIRM.TREE_QUERY'
,p_message_text=>'Tree Query'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84057626856866535)
,p_name=>'CONFIRM.TREE_SQL'
,p_message_text=>'Based on a SQL Query'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84054911141852527)
,p_name=>'CONFIRM.TREE_START'
,p_message_text=>'Start Tree'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84058207940870527)
,p_name=>'CONFIRM.TREE_STATIC'
,p_message_text=>'Static value'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84050018151835644)
,p_name=>'CONFIRM.TREE_TYPE'
,p_message_text=>'Tree Type'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84964508239260082)
,p_name=>'CONFIRM.UI_THEME'
,p_message_text=>'Theme'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84964904214268381)
,p_name=>'CONFIRM.UI_THEME1'
,p_message_text=>'Blue and Tan'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84965424300274208)
,p_name=>'CONFIRM.UI_THEME2'
,p_message_text=>'Red'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84965830880276110)
,p_name=>'CONFIRM.UI_THEME4'
,p_message_text=>'Navy and Gray'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84966203306277655)
,p_name=>'CONFIRM.UI_THEME5'
,p_message_text=>'Olive'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84966608501279118)
,p_name=>'CONFIRM.UI_THEME6'
,p_message_text=>'Maroon'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84967013349280524)
,p_name=>'CONFIRM.UI_THEME7'
,p_message_text=>'Simple Blue and Tan'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84967421660282932)
,p_name=>'CONFIRM.UI_THEME8'
,p_message_text=>'Blue'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84967827894284732)
,p_name=>'CONFIRM.UI_THEME_NONE'
,p_message_text=>'None'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83638722019540369)
,p_name=>'CONFIRM.UPDATEABLE_COLUMNS'
,p_message_text=>'Updateable Columns'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83973806050633440)
,p_name=>'CONFIRM.UPDATE_PROCESS'
,p_message_text=>'Update'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(83681906612923875)
,p_name=>'CONFIRM.USE.EXISTING.TABSET'
,p_message_text=>'This page will use the existing tab set "%0".'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(22396020094396573)
,p_name=>'CONFIRM.WEB_SERVICE_REF'
,p_message_text=>'Web Service Reference, Operation'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84141114454042698)
,p_name=>'CONFIRM.WHERE_CLAUSE'
,p_message_text=>'Where Clause'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(166873618268598741)
,p_name=>'CONFIRMATION_ICON'
,p_message_text=>'Confirmation Icon'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(172716023045270728)
,p_name=>'CONFIRMED'
,p_message_text=>'Confirmed'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(172716804476274747)
,p_name=>'CONFIRMED_BY_QA'
,p_message_text=>'Confirmed by QA'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(138433303265653176)
,p_name=>'CONFIRM_BREAK_COLUMN'
,p_message_text=>'Break Columns'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(138432816987647720)
,p_name=>'CONFIRM_PRINT_FORMAT'
,p_message_text=>'Print Format'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2404616616773834)
,p_name=>'CONSTRAINT.PLUGIN_ATTR_GROUP_UK'
,p_message_text=>'Title is already in use.'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2404464983771917)
,p_name=>'CONSTRAINT.WWV_FLOW_PLUGIN_EVNT_UK'
,p_message_text=>'Internal event name is already in use.'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184527530092492358)
,p_name=>'CONTENT_DISPOSITION'
,p_message_text=>'View File As'
,p_version_scn=>5717867
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(203709630611302300)
,p_name=>'CONTENT_SERVED_IN_KBYTES'
,p_message_text=>'Content Served'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3302267252408311822)
,p_name=>'CONTRIBUTORS'
,p_message_text=>'Contributors'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1066442187509685842)
,p_name=>'COPY.PAGE.NEW_STATIC_ID'
,p_message_text=>'New Static ID'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(107621953694815859)
,p_name=>'COPY_ACTION'
,p_message_text=>'Copy Action'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(46517020668056138)
,p_name=>'COPY_APP_SUCCESS_MSG'
,p_message_text=>'Your application has been copied.'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(102720203089575632)
,p_name=>'COPY_BUTTON.EXECUTION_ERR'
,p_message_text=>'Error during execution of copy_button: %0 >> %1'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(115671112908765514)
,p_name=>'COPY_DEPLOYMENT'
,p_message_text=>'Copy Object Definition Attributes'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(40669212803910647)
,p_name=>'COPY_EXISTING_APP'
,p_message_text=>'Copy Application'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(236701410487836285)
,p_name=>'COPY_FEATURE'
,p_message_text=>'Copy Feature: %0'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(115665011607746282)
,p_name=>'COPY_FROM_APPLICATION'
,p_message_text=>'Copy From Application'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(377458612114590405)
,p_name=>'COPY_FROM_APP_TEMPLATE'
,p_message_text=>'Based on Template Application'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(115665825460750295)
,p_name=>'COPY_FROM_NAME'
,p_message_text=>'Copy from Name'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(47542815619438356)
,p_name=>'COPY_LIST_ENTRY'
,p_message_text=>'Copy List Entry'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(102751817942627200)
,p_name=>'COPY_NAMED_LOV.EXECUTION_ERR'
,p_message_text=>'Error during execution of copy_named_lov: %0'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(102747529932621210)
,p_name=>'COPY_NAMED_LOV.NOT_FOUND_ERR'
,p_message_text=>'List of Values ID "%0" not found.'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(102741206383614374)
,p_name=>'COPY_NAMED_LOV.NUMERIC_ERR'
,p_message_text=>'List of Values ID "%0" is not numeric.'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(210014620633797439)
,p_name=>'COPY_PAGE.COPY_FROM_PAGE'
,p_message_text=>'Copy From Page'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(210015401371801385)
,p_name=>'COPY_PAGE.COPY_TO_PAGE'
,p_message_text=>'Copy To Page'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(208515000750011720)
,p_name=>'COPY_PAGE.SELECT_AUTHORIZATION'
,p_message_text=>'- Select Authorization-'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(208498619909875377)
,p_name=>'COPY_PAGE.SELECT_LIST'
,p_message_text=>'- Select List -'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(208331327285592030)
,p_name=>'COPY_PAGE.SELECT_NAMED_LOV'
,p_message_text=>'- Select List of Values -'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(270368600686936356)
,p_name=>'COPY_TABLE'
,p_message_text=>'Copy %0 to table %1'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(115666500657752567)
,p_name=>'COPY_TO_APPLICATION'
,p_message_text=>'Copy To Application'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(115669012777756014)
,p_name=>'COPY_TO_NAME'
,p_message_text=>'Copy to Name'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(88198422380441257)
,p_name=>'CORE'
,p_message_text=>'core'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(359347306899198143)
,p_name=>'CREATE APPLICATION'
,p_message_text=>'Create Application'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(359353919067230028)
,p_name=>'CREATE OBJECT'
,p_message_text=>'Create Object'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(236544221265573001)
,p_name=>'CREATED_LAST_7_DAYS'
,p_message_text=>'Created last 7 days'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(40669423885913852)
,p_name=>'CREATE_APP_FROM_TEMPLATE'
,p_message_text=>'From an application template'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(618908211023219939)
,p_name=>'CREATE_APP_WIZ.CANDLE_CHARTS'
,p_message_text=>'Candlestick Charts'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(618907814355211391)
,p_name=>'CREATE_APP_WIZ.COL_CHARTS'
,p_message_text=>'2D and 3D Column, Bar and Stacked Charts'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(618915511772324226)
,p_name=>'CREATE_APP_WIZ.GAUGE_CHARTS'
,p_message_text=>'Dial and Dial (Percent) Charts'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(618908025437214669)
,p_name=>'CREATE_APP_WIZ.PIE_CHARTS'
,p_message_text=>'2D and 3D Pie and Doughnut Charts'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(618910226738233977)
,p_name=>'CREATE_APP_WIZ.PROJECTGANTT_CHARTS'
,p_message_text=>'Project Gantt Charts'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(618915202422321555)
,p_name=>'CREATE_APP_WIZ.RANGE_CHARTS'
,p_message_text=>'2D and 3D Range Charts'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(618910903320236649)
,p_name=>'CREATE_APP_WIZ.RESOURCEGANTT_CHARTS'
,p_message_text=>'Resource Gantt Charts'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(618908802497226975)
,p_name=>'CREATE_APP_WIZ.SCATTER_CHARTS'
,p_message_text=>'Scatter Marker Charts'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(87880010753981624)
,p_name=>'CREATE_CONDITION.AND'
,p_message_text=>'AND'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(87879208544971469)
,p_name=>'CREATE_CONDITION.ARROW_DOWN'
,p_message_text=>'Arrow Down'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(87879626552976677)
,p_name=>'CREATE_CONDITION.ARROW_RIGHT'
,p_message_text=>'Arrow Right'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(87878327197948501)
,p_name=>'CREATE_CONDITION.COLUMNS'
,p_message_text=>'Columns'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(87878820056955889)
,p_name=>'CREATE_CONDITION.CONDITIONS'
,p_message_text=>'Conditions'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(87880424951985732)
,p_name=>'CREATE_CONDITION.OR'
,p_message_text=>'OR'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(87881504089998606)
,p_name=>'CREATE_CONDITION.PREVIEW'
,p_message_text=>'Preview Condition'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(236985217260207312)
,p_name=>'CREATE_DEMO_APP.GRANT'
,p_message_text=>'Click on the Grant Privileges button below to grant these privileges now to %0.'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(236982701330202732)
,p_name=>'CREATE_DEMO_APP.NO_CREATE_PRIV'
,p_message_text=>'%0 does not have CREATE TABLE, CREATE VIEW, CREATE TRIGGER, CREATE SEQUENCE or CREATE PROCEDURE privilege and will not be able to install the demonstration application.'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(236984208948204945)
,p_name=>'CREATE_DEMO_APP.NO_EXEC_PRIV'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'%0 does not have execute privilege on CTX_DOC and CTX_DDL and will not be able to install the President''s Inaugural demonstration.  Perform the following grants as a privileged user: ',
'<pre>',
'GRANT EXECUTE ON CTXSYS.CTX_DDL TO %0; ',
'GRANT EXECUTE ON CTXSYS.CTX_DOC TO %0;',
'</pre>'))
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(481306458436268516)
,p_name=>'CREATE_DIALOG_CLOSED_DA'
,p_message_text=>'Create Button - Dialog Closed'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(12822302047712450)
,p_name=>'CREATE_DYNAMIC_LIST'
,p_message_text=>'Create Dynamic List'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(108620632556503516)
,p_name=>'CREATE_DYNAMIC_LOV'
,p_message_text=>'Create Dynamic List of Values'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5020515591120823)
,p_name=>'CREATE_FLOW.CLOUD_IDM'
,p_message_text=>'Oracle Cloud Identity Management'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(19313909795983710)
,p_name=>'CREATE_FLOW.DBACCOUNT'
,p_message_text=>'Database Account'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(361689301600139463)
,p_name=>'CREATE_FLOW.HTMLDB_AUTH'
,p_message_text=>'Oracle APEX Authentication'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(238410706844459393)
,p_name=>'CREATE_FLOW.LDAP'
,p_message_text=>'LDAP'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(818415061995974022)
,p_name=>'CREATE_FLOW.NAVIGATION_LIST'
,p_message_text=>'Navigation Menu List'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(361689915106143338)
,p_name=>'CREATE_FLOW.NO_AUTH'
,p_message_text=>'No Authentication'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(361686817259049333)
,p_name=>'CREATE_FLOW.NO_TABS'
,p_message_text=>'No Tabs'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(361687330765053241)
,p_name=>'CREATE_FLOW.ONE_LEVEL_TABS'
,p_message_text=>'One Level of Tabs'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(238413104204468005)
,p_name=>'CREATE_FLOW.SSO'
,p_message_text=>'Single Sign On (SSO)'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(361687810810056919)
,p_name=>'CREATE_FLOW.TWO_LEVEL_TABS'
,p_message_text=>'Two Levels of Tabs'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(40669031373906620)
,p_name=>'CREATE_FROM_SPREADSHEET'
,p_message_text=>'From a spreadsheet'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3267030017882614)
,p_name=>'CREATE_GLOBAL_PAGE'
,p_message_text=>'Global page components are displayed on all pages if their region''s slot is contained within the selected page template.  Conditional Display attributes can be used to suppress display.'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(96878610610811768)
,p_name=>'CREATE_INDEX'
,p_message_text=>'Create Index'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(146974531694708406)
,p_name=>'CREATE_ITEM_WIZ.NO_REGION'
,p_message_text=>'no region associated'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(88192610381371516)
,p_name=>'CREATE_NEW_LOGIN_PAGE'
,p_message_text=>'Create new login page.'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(87906532513233934)
,p_name=>'CREATE_PACKAGE.BACK'
,p_message_text=>'Back to Create Table Wizard'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(87903006147197894)
,p_name=>'CREATE_PACKAGE.BROWSE'
,p_message_text=>'Browse Package'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(87902231166186180)
,p_name=>'CREATE_PACKAGE.CREATED'
,p_message_text=>'The package "%0" has been created in the "%1" schema.'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(87908128751261177)
,p_name=>'CREATE_PACKAGE.FAILED'
,p_message_text=>'Creating table "%0" failed.'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(87904608141217443)
,p_name=>'CREATE_PACKAGE.HOME'
,p_message_text=>'Home'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(87903804547206903)
,p_name=>'CREATE_PACKAGE.RETURN_TO'
,p_message_text=>'Return to'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(87904223940212505)
,p_name=>'CREATE_PACKAGE.SQL_WORKSHOP'
,p_message_text=>'SQL&nbsp;Workshop'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(87903418614201542)
,p_name=>'CREATE_PACKAGE.SQL_WORKSHOP_HOME'
,p_message_text=>'SQL Workshop Home'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(87126316003224021)
,p_name=>'CREATE_PAGE_ITEM.NO_ITEM_FOUND'
,p_message_text=>'No items found'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(87120925438207806)
,p_name=>'CREATE_PAGE_ITEM.PAGE_ITEMS'
,p_message_text=>'Page Items'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(87125001805219905)
,p_name=>'CREATE_PAGE_ITEM.PROMPT'
,p_message_text=>'Prompt'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(87122506522211862)
,p_name=>'CREATE_PAGE_ITEM.REGION'
,p_message_text=>'Region'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(87123920721215917)
,p_name=>'CREATE_PAGE_ITEM.SET_REGION'
,p_message_text=>'click to set region'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(87075818708044990)
,p_name=>'CREATE_PROCESS.PAGE_ITEMS'
,p_message_text=>'Page Items'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(87077500485049266)
,p_name=>'CREATE_PROCESS.REGION'
,p_message_text=>'Region'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(87899628002156915)
,p_name=>'CREATE_TABLE.HOME'
,p_message_text=>'Home'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(87898129256147797)
,p_name=>'CREATE_TABLE.RETURN_TO'
,p_message_text=>'Return to'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(87897407785141651)
,p_name=>'CREATE_TABLE.RUN_SCRIPT'
,p_message_text=>'Run Script'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(87894509255123107)
,p_name=>'CREATE_TABLE.SCRIPT_CREATED'
,p_message_text=>'The create table script for table %0 has been created in the SQL script repository.'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(87895703499130887)
,p_name=>'CREATE_TABLE.SCRIPT_REPOSITORY'
,p_message_text=>'Go to Script Repository'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(87899117959154028)
,p_name=>'CREATE_TABLE.SQL_WORKSHOP'
,p_message_text=>'SQL&nbsp;Workshop'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(87896421853136195)
,p_name=>'CREATE_TABLE.SQL_WORKSHOP_HOME'
,p_message_text=>'SQL Workshop Home'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(328774415577711156)
,p_name=>'CREATE_TABULAR_FORM'
,p_message_text=>'Tabular Form'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(932215187057657001)
,p_name=>'CREATE_TO_DO'
,p_message_text=>'Create To Do'
,p_is_js_message=>true
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184693178038789934)
,p_name=>'CREDENTIAL.OWNER'
,p_message_text=>'Credential Owner'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(170067083232545137)
,p_name=>'CSS_CALENDAR'
,p_message_text=>'Calendar'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(136638301939904394)
,p_name=>'CURRENT'
,p_message_text=>'Current'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(166135932213196828)
,p_name=>'CURRENT ENTRY'
,p_message_text=>'Current Entry'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(166097702412036871)
,p_name=>'CURRENT FORM ELEMENT'
,p_message_text=>'Current form element'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(90151232732051153)
,p_name=>'CURRENT ITEM HELP TEXT'
,p_message_text=>'Current Item Help Text'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(166098106222037924)
,p_name=>'CURRENT ITEM IDENTIFICATION NUMBER'
,p_message_text=>'Current Item Identification Number'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(166098819381041767)
,p_name=>'CURRENT ITEM LABEL NAME'
,p_message_text=>'Current Item Label Name'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(190185901636881615)
,p_name=>'CURRENT TAB'
,p_message_text=>'Current Tab'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86583305232217917)
,p_name=>'CURRENT_APPLICATION'
,p_message_text=>'Current Application'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86861115339750755)
,p_name=>'CURRENT_IMAGE'
,p_message_text=>'Current Image'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(390643202413553513)
,p_name=>'CURRENT_ITEM_CONTAINER_ID'
,p_message_text=>'ID that can be used on a container element that wraps the current field, in the Before Label and Item attribute.'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(955847408211879160)
,p_name=>'CURRENT_ITEM_HELP_LABEL'
,p_message_text=>'Current Item Help Label'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(69205826774176619)
,p_name=>'CURRENT_MILESTONE'
,p_message_text=>'Current Milestone'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86841910313711400)
,p_name=>'CURRENT_PAGE'
,p_message_text=>'Current Page'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(179939314231236701)
,p_name=>'CURRENT_PAGE_CONTAINS_NO_ITEMS'
,p_message_text=>'Current Page Contains No Items.'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(162226704929487232)
,p_name=>'CUSTOMIZE LINK'
,p_message_text=>'Customize Link'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(573712549030153071)
,p_name=>'CUSTOM_APPLICATIONS'
,p_message_text=>'Custom Applications'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(12749202396995794)
,p_name=>'CUSTOM_AUTH_SCHEME_DESC'
,p_message_text=>'Developer Defined'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(100935527759955492)
,p_name=>'CUSTOM_AUTH_SSO_GENERIC_ERR'
,p_message_text=>'Error in %0'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(69336821132118100)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_1'
,p_message_text=>'Enter any string to be used as your user identifier for this session.'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(69337502909122300)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_2'
,p_message_text=>'Enter your %0 username and password.'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(69338606157132723)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_3'
,p_message_text=>'Enter your username and password for verification by LDAP host: %0.'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(69354024782232780)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_4'
,p_message_text=>'Enter your database schema username and password.'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(497765815001951590)
,p_name=>'CUSTOM_CALENDAR'
,p_message_text=>'Reload'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(500101730575457743)
,p_name=>'CUSTOM_CALENDAR.END_DATE'
,p_message_text=>'End Date'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(500101522610455453)
,p_name=>'CUSTOM_CALENDAR.START_DATE'
,p_message_text=>'Start Date'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(272511924560338779)
,p_name=>'DA.SET_VALUE.SQL.HELP_MSG'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>When the True Action is Set Value with a Set Type of SQL Statement, you need to define the Affected Elements in the same order as the column order of your SQL statement. The SQL Statement you defined was:</p>',
'<pre>%0</pre>'))
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145056710932458773)
,p_name=>'DATA'
,p_message_text=>'Data'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(359249325983156343)
,p_name=>'DATA WORKSHOP'
,p_message_text=>'Data Workshop'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(105840611346370368)
,p_name=>'DATA.LOAD.ALL_COL_MAPPED'
,p_message_text=>'All %0 columns have been automatically mapped to the %1 table.'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(105991816286974911)
,p_name=>'DATA.LOAD.APPEND_INCOMPLETE'
,p_message_text=>'Data in table <code>%0</code> appended with <b id="incompl_success_row_count"></b> new rows. <b class="u-danger-text" id="incompl_fail_row_count"></b> rows rejected.'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(105985239488554324)
,p_name=>'DATA.LOAD.APPEND_SUCCESS'
,p_message_text=>'Data in table <code>%0</code> appended with <b id="success_row_count"></b> new rows!'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(105987278022579060)
,p_name=>'DATA.LOAD.APPEND_WARNING'
,p_message_text=>'Data in table <code>%0</code> appended with <b id="err_success_row_count"></b> new rows. <b class="u-danger-text" id="err_fail_row_count"></b> rows rejected.'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3781904745619163)
,p_name=>'DATA.LOAD.CHOOSE_FILE'
,p_message_text=>'Choose File'
,p_is_js_message=>true
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2501027814382386)
,p_name=>'DATA.LOAD.COLUMN_MAPPING_REQUIRED'
,p_message_text=>'Column mapping must be specified.'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(17030734026113679)
,p_name=>'DATA.LOAD.CONFIGURATION_SAVED'
,p_message_text=>'Configuration Saved!'
,p_is_js_message=>true
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3709908511167509)
,p_name=>'DATA.LOAD.DATA_PROFILE'
,p_message_text=>'Data Profile'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3710175905169204)
,p_name=>'DATA.LOAD.DATA_PROFILE_COLS'
,p_message_text=>'Data Profile Columns'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3600538591907637)
,p_name=>'DATA.LOAD.DATA_SOURCE'
,p_message_text=>'Data Source'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(105842173837380473)
,p_name=>'DATA.LOAD.DEFINE_COL_MAPPING'
,p_message_text=>'Please define the column mapping in order to load this data into the %0 table.'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3709762281165426)
,p_name=>'DATA.LOAD.DEFINITION'
,p_message_text=>'Data Load Definition'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3781631818614078)
,p_name=>'DATA.LOAD.DRAG_DROP_FILE_HERE'
,p_message_text=>'Drag and drop file here or'
,p_is_js_message=>true
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3781056923595660)
,p_name=>'DATA.LOAD.FILE_FORMATS'
,p_message_text=>'Supported formats csv, xlsx, txt, xml, json'
,p_is_js_message=>true
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(358297367813091201)
,p_name=>'DATA.LOAD.JOB_INTERMITTENTLY_FAILED'
,p_message_text=>'Data Loading job execution stopped unexpectedly.'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(284069980792277983)
,p_name=>'DATA.LOAD.JOB_NAME'
,p_message_text=>'Data Loading Job in Workspace %0: Load into Table %1'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3601265764953688)
,p_name=>'DATA.LOAD.LOADED_FILE'
,p_message_text=>'Loaded File'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(105842359685390468)
,p_name=>'DATA.LOAD.MAP_REMAINING_COLS'
,p_message_text=>'%0 out of %1 columns have been automatically mapped to the %2 table. Please configure the remaining %3 columns.'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(319504465141049485)
,p_name=>'DATA.LOAD.PASTED_DATA'
,p_message_text=>'Pasted Data'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(105992381678977349)
,p_name=>'DATA.LOAD.REPLACE_INCOMPLETE'
,p_message_text=>'Data in table <code>%0</code> replaced with <b id="incompl_success_row_count"></b> new rows. <b class="u-danger-text" id="incompl_fail_row_count"></b> rows rejected.'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(105985431991555679)
,p_name=>'DATA.LOAD.REPLACE_SUCCESS'
,p_message_text=>'Data in table <code>%0</code> replaced with <b id="success_row_count"></b> new rows!'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(105987494697581361)
,p_name=>'DATA.LOAD.REPLACE_WARNING'
,p_message_text=>'Data in table <code>%0</code> replaced with <b id="err_success_row_count"></b> new rows. <b class="u-danger-text" id="err_fail_row_count"></b> rows rejected.'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(105842513595401913)
,p_name=>'DATA.LOAD.SELECT_COLS'
,p_message_text=>'Please select the columns to load.'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1443541124456055)
,p_name=>'DATA.LOAD.SUPPORTED_FORMATS_N'
,p_message_text=>'Supported formats %0'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3600847441945692)
,p_name=>'DATA.LOAD.UPLOAD_A_FILE'
,p_message_text=>'Upload a File'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3601748233963090)
,p_name=>'DATA.LOAD.XLSX_WORKSHEET'
,p_message_text=>'XLSX Worksheet'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(910329911394909439)
,p_name=>'DATABASE'
,p_message_text=>'Database'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(359354426685232224)
,p_name=>'DATABASE BROWSER'
,p_message_text=>'Database Browser'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(910662500275953503)
,p_name=>'DATABASE_APPLICATION'
,p_message_text=>'Application'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(20146512622163987)
,p_name=>'DATABASE_APPLICATIONS'
,p_message_text=>'Applications'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(24283832499156801)
,p_name=>'DATABASE_APPS'
,p_message_text=>'Applications'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(219194119339534265)
,p_name=>'DATABASE_APP_SUCCESS_MSG'
,p_message_text=>'Application <strong>%0</strong> successfully installed.'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(154784408351737294)
,p_name=>'DATABASE_LINK'
,p_message_text=>'Database Link'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184168709502897083)
,p_name=>'DATABASE_OBJECT_COUNTS_BY_TYPE'
,p_message_text=>'Database Object Counts by Object Type'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184183131665253510)
,p_name=>'DATABASE_ROLE_PRIVILEGES'
,p_message_text=>'Database Role Privileges'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(23063210655713253)
,p_name=>'DATABASE_USERS'
,p_message_text=>'Database'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(262591928380410954)
,p_name=>'DATA_GRID'
,p_message_text=>'Data Grid'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(623896725654598603)
,p_name=>'DATA_GRIDS'
,p_message_text=>'Data Grids'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(623902205054630439)
,p_name=>'DATA_GRID_DATA'
,p_message_text=>'Data Grid Data'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(600627792229524564)
,p_name=>'DATA_LOAD.ADVANCED_SETTINGS_REGION'
,p_message_text=>'Data Load Advanced Settings'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(48760530208123501)
,p_name=>'DATA_LOAD.APP_DATE_FORMAT'
,p_message_text=>'Date / Number Formats to use'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(48760808858133339)
,p_name=>'DATA_LOAD.APP_DATE_FORMAT_HELP'
,p_message_text=>'Choose whether to provide custom or to use standard format masks'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(23680003820515412)
,p_name=>'DATA_LOAD.CHARSET'
,p_message_text=>'File Character Set'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(352821406088222317)
,p_name=>'DATA_LOAD.COLUMN_NAMES'
,p_message_text=>'Column Names'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(217696968023180455)
,p_name=>'DATA_LOAD.COLUMN_NAME_ALIASES'
,p_message_text=>'Column Names Aliases'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(472561420018638399)
,p_name=>'DATA_LOAD.CONFIRM'
,p_message_text=>'The data has been successfully uploaded to your table.'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(483373612463447211)
,p_name=>'DATA_LOAD.COPY_PASTE'
,p_message_text=>'Copy and Paste'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(467703824232343283)
,p_name=>'DATA_LOAD.COPY_PASTE_TEXTAREA'
,p_message_text=>'Copy and Paste Delimited Data'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(681885100754374518)
,p_name=>'DATA_LOAD.CURRENCY_ITEM'
,p_message_text=>'Currency Symbol'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(681908532530402583)
,p_name=>'DATA_LOAD.CURRENCY_ITEM_HELP'
,p_message_text=>'If your data contains international currency symbol, enter it here. For example, if your data has "&euro;1,234.56" or "&yen;1,234.56", enter "&euro;" or "&yen;".  Otherwise the data will not load correctly.'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(24810990922019773)
,p_name=>'DATA_LOAD.DATA_LOADING'
,p_message_text=>'Data Loading'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(600628629324535918)
,p_name=>'DATA_LOAD.DATE_FORMAT_APP'
,p_message_text=>'Use application standard format masks'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(600628881994537859)
,p_name=>'DATA_LOAD.DATE_FORMAT_CUSTOM'
,p_message_text=>'Provide custom formats for uploaded columns'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(682792718612568932)
,p_name=>'DATA_LOAD.DECIMAL_CHARACTER_HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>The decimal character separates the integer and decimal parts of a number.</p>',
'<p> Any character can be the decimal character. The character specified must be single-byte, and the decimal character must be different from group separator. The character can be a space, but cannot be any numeric character or any of the following c'
||'haracters:</p>',
'<ul class="noIndent">',
'<li>plus (+)</li>',
'<li>hyphen (-)</li> ',
'<li>less than sign (<)</li>',
'<li>greater than sign (>)</li> ',
'</ul>'))
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(682080417648474055)
,p_name=>'DATA_LOAD.DECIMAL_CHARACTER_ITEM'
,p_message_text=>'Decimal Character'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(72724786024377767)
,p_name=>'DATA_LOAD.DECIMAL_CHAR_REQUIRED'
,p_message_text=>'Decimal character is required if group separator is defined for the %0 table column.'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(217697333751184030)
,p_name=>'DATA_LOAD.DISPLAY'
,p_message_text=>'Display'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(285743495507728472)
,p_name=>'DATA_LOAD.DUPLICATE_MAPPING'
,p_message_text=>'Multiple source columns are mapped to the %0 table column.'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(520162010741385667)
,p_name=>'DATA_LOAD.FAILED_COUNT'
,p_message_text=>'Failed Row(s):'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(635274905916505129)
,p_name=>'DATA_LOAD.FAILED_RECORD'
,p_message_text=>'Failed Records'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(681387730293165407)
,p_name=>'DATA_LOAD.FILE_NAME_ITEM'
,p_message_text=>'Name of the file to upload'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(477689322403086759)
,p_name=>'DATA_LOAD.FIRST_ROW'
,p_message_text=>'First Row has Column Names'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(681539003075242760)
,p_name=>'DATA_LOAD.FIRST_ROW_HELP'
,p_message_text=>'Select this box if your data contains column names in the first row.'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(681726426203344026)
,p_name=>'DATA_LOAD.GLOBALIZATION_REGION'
,p_message_text=>'Globalization'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(682038212191453463)
,p_name=>'DATA_LOAD.GROUP_SEPARATOR_HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>A group separator is a character that separates integer groups, for example to show thousands and millions.</p>',
'<p>Any character can be the group separator. The character specified must be single-byte, and the group separator must be different from any other decimal character. The character can be a space, but cannot be a numeric character or any of the follow'
||'ing:</p>',
'<ul class="noIndent">',
'<li>plus (+)</li>',
'<li>hyphen (-)</li> ',
'<li>less than sign (<)</li>',
'<li>greater than sign (>)</li> ',
'</ul>'))
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(681957409374424333)
,p_name=>'DATA_LOAD.GROUP_SEPARATOR_ITEM'
,p_message_text=>'Group Separator'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(520154029310381614)
,p_name=>'DATA_LOAD.INSERTED_COUNT'
,p_message_text=>'Inserted Row(s):'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(672741732280358756)
,p_name=>'DATA_LOAD.IR_MAX_ROW_COUNT'
,p_message_text=>'This query returns more than #MAX_ROW_COUNT# rows, please filter your data to ensure complete results.'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(212988505490822595)
,p_name=>'DATA_LOAD.JUSTCHANGED_RECORD'
,p_message_text=>'Records Changed by Another User.'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(61681511868525395)
,p_name=>'DATA_LOAD.LABEL_CASE_SENSITIVE'
,p_message_text=>'Case Sensitive'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(61681162300520983)
,p_name=>'DATA_LOAD.LABEL_UNIQUE_COLUMN'
,p_message_text=>'Unique Column'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(453900718524261345)
,p_name=>'DATA_LOAD.LOAD_DATA_PROCESS_ERROR'
,p_message_text=>'Data Loading Failed'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(453969811729268858)
,p_name=>'DATA_LOAD.LOAD_DATA_PROCESS_SUCCESS'
,p_message_text=>'Action Processed'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(462491823887292821)
,p_name=>'DATA_LOAD.LOAD_TO'
,p_message_text=>'Import From'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(261883123670446611)
,p_name=>'DATA_LOAD.MAPPING_PAGE'
,p_message_text=>'Step 2 - Page Name'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1013410410856554995)
,p_name=>'DATA_LOAD.NO_PREVIEW'
,p_message_text=>'No file preview available'
,p_is_js_message=>true
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(679228403862599545)
,p_name=>'DATA_LOAD.OPTIONAL_ENCLOSE_ITEM'
,p_message_text=>'Optionally Enclosed By'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(609913253811028253)
,p_name=>'DATA_LOAD.PROGRESS_TITLE'
,p_message_text=>'Data Load Wizard Progress'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(261933530165467476)
,p_name=>'DATA_LOAD.RESULTS_PAGE'
,p_message_text=>'Step 4 - Page Name'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(217697116091181686)
,p_name=>'DATA_LOAD.RETURN'
,p_message_text=>'Return'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(212028923407671941)
,p_name=>'DATA_LOAD.REVIEW_COUNT'
,p_message_text=>'To be Reviewed Row(s):'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(338393819195613097)
,p_name=>'DATA_LOAD.RULES_PLSQL_EXPRESSION_EXAMPLES'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<pre>',
'to_char(sysdate)',
'',
'my_func (',
'    p_1 => :SAL,',
'    p_2 => :COMM)',
'',
'where SAL and COMM are column names of the uploaded data',
'and my_func is the function that returns the value which will be the new value',
'for the column for which this transformation rule is defined.',
'</pre>'))
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(338404200420637003)
,p_name=>'DATA_LOAD.RULES_PLSQL_FUNCTION_EXAMPLES'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<pre>',
'declare',
'    l_result number;',
'begin',
'    l_result := :SAL * :COMM;',
'    return l_result;',
'end;',
'',
'The returned result will be the new value of the column for which this transformation rule is defined.',
'',
':SAL and :COMM refer to the SAL and COMM column names of the uploaded data.',
'</pre>'))
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(338404005812634447)
,p_name=>'DATA_LOAD.RULES_SQL_QUERY_EXAMPLES'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<pre>',
'select deptno',
' from dept',
'where dname = :DEPTNAME',
'  and loc   = :LOC',
'',
'where :DEPTNAME and :LOC refer to DEPTNAME and LOC columns names of the uploaded data.',
'</pre>'))
,p_version_scn=>70279024
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(81749122770461523)
,p_name=>'DATA_LOAD.SAME_GROUP_DECIMAL_CHARS'
,p_message_text=>'In the %0 table column, the same character cannot be defined as both the group separator and decimal character. Please enter different characters.'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(678828814411489009)
,p_name=>'DATA_LOAD.SEPARATOR_ITEM_HELP'
,p_message_text=>'Identify a column separator character. Use <code>\t</code> for tab separators.'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(678851330125503058)
,p_name=>'DATA_LOAD.SEPARATOR_ITEM_LABEL'
,p_message_text=>'Separator'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(217697508301185501)
,p_name=>'DATA_LOAD.SEQUENCE'
,p_message_text=>'Sequence'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(600627395300521656)
,p_name=>'DATA_LOAD.SHOW_ADVANCED_SETTINGS'
,p_message_text=>'Use Advanced Settings'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(600627505257523102)
,p_name=>'DATA_LOAD.SHOW_ADVANCED_SETTINGS_HELP'
,p_message_text=>'Display advanced settings for data loading: Currency Symbol, Decimal Characters, File Encoding or Date Formats'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(485545329169133312)
,p_name=>'DATA_LOAD.SOURCE'
,p_message_text=>'Data Load Source'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(261879115358444253)
,p_name=>'DATA_LOAD.SOURCE_PAGE'
,p_message_text=>'Step 1 - Page Name'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(914275118591356269)
,p_name=>'DATA_LOAD.TAB_SEPARTOR_NOTE'
,p_message_text=>'(\t for tab)'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(676794115993978533)
,p_name=>'DATA_LOAD.UNIQUE_COLUMN'
,p_message_text=>'Unique Column %0'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(520158004854383976)
,p_name=>'DATA_LOAD.UPDATED_COUNT'
,p_message_text=>'Updated Row(s):'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1793617060337370917)
,p_name=>'DATA_LOAD.UPLOADED_NULL_VALUE'
,p_message_text=>'Null value was uploaded.'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(483293503328435147)
,p_name=>'DATA_LOAD.UPLOAD_FILE'
,p_message_text=>'Upload file, comma separated (*.csv) or tab delimited'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(485583620774149853)
,p_name=>'DATA_LOAD.UPLOAD_RESULTS'
,p_message_text=>'Data Load Results'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(485575713155147603)
,p_name=>'DATA_LOAD.VALIDATION'
,p_message_text=>'Data Validation'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(261887130942448730)
,p_name=>'DATA_LOAD.VALIDATION_PAGE'
,p_message_text=>'Step 3 - Page Name'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(264373716326245308)
,p_name=>'DATA_LOAD_WIZARD_CREATED_SUCCESSFULLY'
,p_message_text=>'The data load wizard pages have been created successfully.'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(454005026620273118)
,p_name=>'DATA_SAVE.LOAD_DATA_PROCESS_ERROR'
,p_message_text=>'Data / Table Mapping Failed'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(454012800086274968)
,p_name=>'DATA_SAVE.LOAD_DATA_PROCESS_SUCCESS'
,p_message_text=>'Action Processed'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(171085145560947445)
,p_name=>'DATA_UPLOAD_COLUMN_MAPPING'
,p_message_text=>'Data Upload Column Mapping'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(84357624215581507)
,p_name=>'DATA_WORKSHOP.CONFIGURE.COLUMN_TYPE'
,p_message_text=>'Column Type: Column %0'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(20602250024359075)
,p_name=>'DATA_WORKSHOP.CONFIGURE.DECIMAL_CHARACTER'
,p_message_text=>'Decimal Character: Column %0'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(20602658544361576)
,p_name=>'DATA_WORKSHOP.CONFIGURE.FORMAT_MASK'
,p_message_text=>'Format Mask: Column %0'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(20602461103360372)
,p_name=>'DATA_WORKSHOP.CONFIGURE.GROUP_SEPARATOR'
,p_message_text=>'Group Separator: Column %0'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(20603035624363579)
,p_name=>'DATA_WORKSHOP.CONFIGURE.MAP_TO_COLUMN'
,p_message_text=>'Map To: Column %0'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(94755079153779391)
,p_name=>'DATA_WORKSHOP.CONFIGURE.MAX_LENGTH'
,p_message_text=>'Maximum Length: Column %0'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(20602863292362570)
,p_name=>'DATA_WORKSHOP.CONFIGURE.UNMAPPED'
,p_message_text=>'- Unmapped Column -'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(256038129446617484)
,p_name=>'DATEPICKER.DEFAULT_DATE_INVALID'
,p_message_text=>'Entered Highlighted Date attribute value %0 for item %1 does not match %2 format.'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(261691912045958964)
,p_name=>'DATEPICKER.DEFAULT_DATE_INVALID_RELATIVE'
,p_message_text=>'Entered Highlighted Date attribute value %0 for item %1 is not a relative date.'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(256038704082629114)
,p_name=>'DATEPICKER.MAX_DATE_INVALID'
,p_message_text=>'Entered Maximum Date attribute value %0 for item %1 does not match %2 format.'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(261692512176968453)
,p_name=>'DATEPICKER.MAX_DATE_INVALID_RELATIVE'
,p_message_text=>'Entered Maximum Date attribute value %0 for item %1 is not a relative date.'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3200814904890353)
,p_name=>'DATEPICKER.MAX_STATIC_INVALID'
,p_message_text=>'Entered Maximum Static attribute value %0 for item %1 does not match %2 format.'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(256038419188623995)
,p_name=>'DATEPICKER.MIN_DATE_INVALID'
,p_message_text=>'Entered Minimum Date attribute value %0 for item %1 does not match %2 format.'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(261692201786965402)
,p_name=>'DATEPICKER.MIN_DATE_INVALID_RELATIVE'
,p_message_text=>'Entered Minimum Date attribute value %0 for item %1 is not a relative date.'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3200659198888941)
,p_name=>'DATEPICKER.MIN_STATIC_INVALID'
,p_message_text=>'Entered Minimum Static attribute value %0 for item %1 does not match %2 format.'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(367650718087522898)
,p_name=>'DATE_ADDED'
,p_message_text=>'Date Added'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(620843423495516542)
,p_name=>'DATE_OF_LAST_RUN'
,p_message_text=>'Oracle APEX database jobs with time of last run'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(191632027649118825)
,p_name=>'DAYS_BEFORE_FINAL_MILESTONE'
,p_message_text=>'to final milestone'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(191632830550129092)
,p_name=>'DAYS_BEFORE_FINAL_MILESTONE_OF_RELASE'
,p_message_text=>'to final milestone of release %0'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(261342003959605902)
,p_name=>'DA_NAME.NATIVE_ADD_CLASS'
,p_message_text=>'Add Class'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(626835418833839278)
,p_name=>'DA_NAME.NATIVE_ALERT'
,p_message_text=>'Alert'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(626382321884216912)
,p_name=>'DA_NAME.NATIVE_CANCEL_EVENT'
,p_message_text=>'Cancel Event'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(626835803380844283)
,p_name=>'DA_NAME.NATIVE_CLEAR'
,p_message_text=>'Clear'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(626835628876842210)
,p_name=>'DA_NAME.NATIVE_CONFIRM'
,p_message_text=>'Confirm'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3734450541724)
,p_name=>'DA_NAME.NATIVE_DIALOG_CANCEL'
,p_message_text=>'Cancel Dialog'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3734453545253)
,p_name=>'DA_NAME.NATIVE_DIALOG_CLOSE'
,p_message_text=>'Close Dialog'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(46427217426725881)
,p_name=>'DA_NAME.NATIVE_DISABLE'
,p_message_text=>'Disable'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(46427011539724180)
,p_name=>'DA_NAME.NATIVE_ENABLE'
,p_message_text=>'Enable'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(616985332312478260)
,p_name=>'DA_NAME.NATIVE_EXECUTE_PLSQL_CODE'
,p_message_text=>'Execute PL/SQL Code'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(46426628377719504)
,p_name=>'DA_NAME.NATIVE_HIDE'
,p_message_text=>'Hide'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(187267306245892988)
,p_name=>'DA_NAME.NATIVE_JAVASCRIPT_CODE'
,p_message_text=>'Execute JavaScript Code'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(457604812163620493)
,p_name=>'DA_NAME.NATIVE_REFRESH'
,p_message_text=>'Refresh'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(261353428565764316)
,p_name=>'DA_NAME.NATIVE_REMOVE_CLASS'
,p_message_text=>'Remove Class'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(261353731682765225)
,p_name=>'DA_NAME.NATIVE_SET_CSS'
,p_message_text=>'Set Style'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(427397516319148902)
,p_name=>'DA_NAME.NATIVE_SET_FOCUS'
,p_message_text=>'Set Focus'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(187267031740890834)
,p_name=>'DA_NAME.NATIVE_SET_VALUE'
,p_message_text=>'Set Value'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(46426320758717324)
,p_name=>'DA_NAME.NATIVE_SHOW'
,p_message_text=>'Show'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(427397820475150050)
,p_name=>'DA_NAME.NATIVE_SUBMIT_PAGE'
,p_message_text=>'Submit Page'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(388636357727758698)
,p_name=>'DA_NAME.NATIVE_TREE_COLLAPSE'
,p_message_text=>'Collapse Tree'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(388636132255757718)
,p_name=>'DA_NAME.NATIVE_TREE_EXPAND'
,p_message_text=>'Expand Tree'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(13168625276730447)
,p_name=>'DBACCOUNT_AUTH_SCHEME_DESC'
,p_message_text=>'Database Account'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184824631064713110)
,p_name=>'DB_COLS_CASE_SEN'
,p_message_text=>'Database table and column names are case sensitive'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(290111727752564563)
,p_name=>'DB_OBJECT_CREATION_EXCEPTION'
,p_message_text=>'db object creation exception'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(18826730502410402)
,p_name=>'DB_PRODUCT_NAME'
,p_message_text=>'Oracle Database'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(834494811225784137)
,p_name=>'DB_SERVICES_ALIAS'
,p_message_text=>'Alias'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(808752222882635106)
,p_name=>'DB_SERVICES_ALL_MIMES'
,p_message_text=>'All Mimes'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(833299123196626797)
,p_name=>'DB_SERVICES_CREATE_HANDLER'
,p_message_text=>'Create Handler'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(808768400503638047)
,p_name=>'DB_SERVICES_CREATE_METHOD'
,p_message_text=>'Create Method'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(808760227038636224)
,p_name=>'DB_SERVICES_CREATE_PARAMETER'
,p_message_text=>'Create Parameter'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(808764329808637094)
,p_name=>'DB_SERVICES_CREATE_TEMPLATE'
,p_message_text=>'Create Template'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(860747615097133487)
,p_name=>'DB_SERVICES_DB_SERVICES_MODULE'
,p_message_text=>'RESTful Service Module'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(833053106096612430)
,p_name=>'DB_SERVICES_HANDLER'
,p_message_text=>'Handler'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(870162814936297257)
,p_name=>'DB_SERVICES_HANDLER_BIND_VARIABLE'
,p_message_text=>'Handler Bind Variable'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(696578318379108703)
,p_name=>'DB_SERVICES_HANDLER_METHOD'
,p_message_text=>'Handler Method'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(870718429228358187)
,p_name=>'DB_SERVICES_HANDLER_SOURCE'
,p_message_text=>'Handler Source'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(696578605312111849)
,p_name=>'DB_SERVICES_HANDLER_SRC_TYPE'
,p_message_text=>'Handler Source Type'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(808744016995633348)
,p_name=>'DB_SERVICES_METHOD'
,p_message_text=>'Method'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(860774119252134704)
,p_name=>'DB_SERVICES_MODULE_NAME'
,p_message_text=>'Module Name'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(870555215114335219)
,p_name=>'DB_SERVICES_MODULE_URI'
,p_message_text=>'Module URI Prefix'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(808772503274638831)
,p_name=>'DB_SERVICES_NO_SOURCE'
,p_message_text=>'No Source'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(808739914225632553)
,p_name=>'DB_SERVICES_PARAMETER'
,p_message_text=>'Parameter'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(867090327207111610)
,p_name=>'DB_SERVICES_RESTFUL_SERVICES'
,p_message_text=>'RESTful Services'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(808748119766634193)
,p_name=>'DB_SERVICES_TEMPLATE'
,p_message_text=>'Template'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(870585832083340069)
,p_name=>'DB_SERVICES_TEMPLATE_URI'
,p_message_text=>'URI Template'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(696576048769091661)
,p_name=>'DB_SERVICES_URI'
,p_message_text=>'Uniform Resource Identifier (URI)'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(860641311503122959)
,p_name=>'DB_SERVICES_URI_PRIFIX'
,p_message_text=>'URI Prefix'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(860686619814125421)
,p_name=>'DB_SERVICES_URI_TEMPLATE'
,p_message_text=>'URI Template'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(696578939566114715)
,p_name=>'DB_SERVICE_QUERY_ONE_ROW'
,p_message_text=>'Query One Row'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(148729725448916262)
,p_name=>'DEBUG'
,p_message_text=>'Debug'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(195676708098077056)
,p_name=>'DECLINED'
,p_message_text=>'Declined'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1614996593681258700)
,p_name=>'DEFAULT_DIALOGBTNR_TEMPLATE'
,p_message_text=>'Default Dialog Button Region Template'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1614996349518256716)
,p_name=>'DEFAULT_DIALOGR_TEMPLATE'
,p_message_text=>'Default Dialog Content Region Template'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(454925418312976152)
,p_name=>'DEFAULT_PAGE'
,p_message_text=>'Default Page'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145392019551208775)
,p_name=>'DEFAULT_TABLESPACE'
,p_message_text=>'default tablespace'
,p_version_scn=>37165770887504
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145568814637377715)
,p_name=>'DEFAULT_TABLESPACE_INIT'
,p_message_text=>'Default Tablespace'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(345031628101716386)
,p_name=>'DEFAULT_TEMPLATE'
,p_message_text=>'Default Template'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(11582712872251962)
,p_name=>'DEFINED_BY_DA'
,p_message_text=>'Defined by Dynamic Action'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(492149208444795988)
,p_name=>'DEFINED_TABS'
,p_message_text=>'This application has %0 tabs organized into %1 tab sets, and has defined %2 parent tabs.'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(108559622945131752)
,p_name=>'DEFINE_LOV'
,p_message_text=>'Define List of Values'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(163582030440385864)
,p_name=>'DEFINITION'
,p_message_text=>'Definition'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(282818412512204797)
,p_name=>'DEINSTALLATION_SCRIPT'
,p_message_text=>'Deinstallation Script'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(42403117645694538)
,p_name=>'DELETED'
,p_message_text=>'Deleted'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(623895004006554445)
,p_name=>'DELETE_APPLICATION'
,p_message_text=>'Delete Application'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(330209506788980954)
,p_name=>'DELETE_LABEL'
,p_message_text=>'Delete: %0'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(305245848343039293)
,p_name=>'DELETE_LINK_TEXT'
,p_message_text=>'Delete %0'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25831504818551543)
,p_name=>'DEMO.SAMPLE.APP'
,p_message_text=>'Sample Application'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25831920055555978)
,p_name=>'DEMO.SAMPLE.APP.DESCR'
,p_message_text=>'Product Portal is a sample application that highlights common design concepts. It includes dedicated pages for customers, products, and orders as well as demonstrates the use of reports, charts, calendar, map, and tree.'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(174644812235660365)
,p_name=>'DEMONSTRABLE'
,p_message_text=>'Demonstrable'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86639518073448693)
,p_name=>'DEMO_APPLICATION.ABOUT_BUSINESS_LOOK'
,p_message_text=>'Examples of robust reports and pagination concepts.'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86633502920425421)
,p_name=>'DEMO_APPLICATION.ABOUT_PETSTORE'
,p_message_text=>'Example of on-line store built using %0.'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86647610978484497)
,p_name=>'DEMO_APPLICATION.ABOUT_PRESIDENTIAL'
,p_message_text=>'Learn about using Oracle Text with %0.'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86653513318504148)
,p_name=>'DEMO_APPLICATION.ABOUT_PROJ_TRACKING'
,p_message_text=>'Example of project status tracking application built with %0.'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86642316257467134)
,p_name=>'DEMO_APPLICATION.ABOUT_WEBSERVICES'
,p_message_text=>'Learn to use webservices with %0.'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86623500533377424)
,p_name=>'DEMO_APPLICATION.ACTION'
,p_message_text=>'Action'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86525609238058166)
,p_name=>'DEMO_APPLICATION.APPLICATION'
,p_message_text=>'Application'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86521617764051253)
,p_name=>'DEMO_APPLICATION.BASIC_LEXER'
,p_message_text=>'BASIC_LEXER'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86638504913444896)
,p_name=>'DEMO_APPLICATION.BUSINESS_LOOK'
,p_message_text=>'Business Look'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86624401010387021)
,p_name=>'DEMO_APPLICATION.COLLECTION_SHOWCASE'
,p_message_text=>'Collection Showcase'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86522827461054037)
,p_name=>'DEMO_APPLICATION.CONTEXT_INDEX'
,p_message_text=>'CONTEXT INDEX'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86510714124012310)
,p_name=>'DEMO_APPLICATION.CREATE_BASIC'
,p_message_text=>'You are about to create Basic Examples Demo Application.'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86100731729913303)
,p_name=>'DEMO_APPLICATION.CREATE_BUSINESS_LOOK'
,p_message_text=>'You are about to (re)create business look Demo Application.'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86512630746017160)
,p_name=>'DEMO_APPLICATION.CREATE_COLLECTION_SHOWCASE'
,p_message_text=>'You are about to create the Collections Showcase Demo Application.'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86515319927032940)
,p_name=>'DEMO_APPLICATION.CREATE_OR_RECREATE'
,p_message_text=>'create or recreate in schema %0'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86097707488906306)
,p_name=>'DEMO_APPLICATION.CREATE_WEB_SERVICES'
,p_message_text=>'Create an example application to demonstrate web services.'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86102321471919779)
,p_name=>'DEMO_APPLICATION.CREATE_WORLDCUP_MANIA'
,p_message_text=>'You are about to create WorldCup Mania Demo Application.'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15092706680478500)
,p_name=>'DEMO_APPLICATION.DEINSTALL'
,p_message_text=>'Remove'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86622409060370419)
,p_name=>'DEMO_APPLICATION.DEMO_APP'
,p_message_text=>'Demo Application'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86535014910069267)
,p_name=>'DEMO_APPLICATION.FREE_SPACE'
,p_message_text=>'You have about %0 MB free.'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86628122743412220)
,p_name=>'DEMO_APPLICATION.INSTALL'
,p_message_text=>'Install'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86625514647400427)
,p_name=>'DEMO_APPLICATION.INSTALLED'
,p_message_text=>'Installed'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(122982709993673959)
,p_name=>'DEMO_APPLICATION.INSTALL_DEMO_APP'
,p_message_text=>'You are about to install the Sample Application, which demonstrates the key features of %0.'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86637510323437040)
,p_name=>'DEMO_APPLICATION.INSTALL_NOW'
,p_message_text=>'Install Now'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86624920403392658)
,p_name=>'DEMO_APPLICATION.LEARN_ABOUT'
,p_message_text=>'Learn about %0 shopping cart concepts.'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(313624608662862080)
,p_name=>'DEMO_APPLICATION.LOCKED'
,p_message_text=>'Locked'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86531228977063909)
,p_name=>'DEMO_APPLICATION.NEED_7M'
,p_message_text=>'The Presidential Inaugural Address Demonstration requires about 7 MB of free disk space and may take up to two minutes to install in your schema.'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(122831228619423792)
,p_name=>'DEMO_APPLICATION.NOT_ENOUGH_SPACE_ERR'
,p_message_text=>'There was not enough space to create this demonstration.  Request additional storage by going to the administration page, go to provisioning services and click the link to request additional storage. %0'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86627209584408409)
,p_name=>'DEMO_APPLICATION.NOT_INSTALLED'
,p_message_text=>'Not Installed'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86484212645955102)
,p_name=>'DEMO_APPLICATION.OBJECT_EXIST'
,p_message_text=>'Exist'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86096209088897267)
,p_name=>'DEMO_APPLICATION.OBJECT_EXISTS'
,p_message_text=>'exists'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86473730175950682)
,p_name=>'DEMO_APPLICATION.OBJECT_NAME'
,p_message_text=>'Name'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86517915902041262)
,p_name=>'DEMO_APPLICATION.OBJECT_NAME2'
,p_message_text=>'Object Name'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86096825711902091)
,p_name=>'DEMO_APPLICATION.OBJECT_NOT_EXISTS'
,p_message_text=>'not exists'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86467506711925047)
,p_name=>'DEMO_APPLICATION.OBJECT_RECREATE'
,p_message_text=>'The following database objects will be recreated if they exist'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86472916323946682)
,p_name=>'DEMO_APPLICATION.OBJECT_TYPE'
,p_message_text=>'Object Type'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86507026806006531)
,p_name=>'DEMO_APPLICATION.PACKAGE'
,p_message_text=>'Package'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86631413870419120)
,p_name=>'DEMO_APPLICATION.PETSTORE'
,p_message_text=>'Pet store'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86646724353478911)
,p_name=>'DEMO_APPLICATION.PRESIDENTIAL'
,p_message_text=>'Presidential Inaugural Addresses'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86652229463499345)
,p_name=>'DEMO_APPLICATION.PROJECT_TRACKING'
,p_message_text=>'Project Tracking'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145933418006022093)
,p_name=>'DEMO_APPLICATION.RE_INSTALL'
,p_message_text=>'Re-install'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86626029192404645)
,p_name=>'DEMO_APPLICATION.RUN'
,p_message_text=>'Run'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86468720217928959)
,p_name=>'DEMO_APPLICATION.SCHEMA'
,p_message_text=>'Schema'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86503729445997814)
,p_name=>'DEMO_APPLICATION.SEQUENCE'
,p_message_text=>'Sequence'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86622922219374241)
,p_name=>'DEMO_APPLICATION.STATUS'
,p_message_text=>'Status'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86492611391964173)
,p_name=>'DEMO_APPLICATION.TABLE'
,p_message_text=>'Table'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86620423127364980)
,p_name=>'DEMO_APPLICATION.TABLE_SUMMARY'
,p_message_text=>'Demonstration Application Install Status Report'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86505108452001239)
,p_name=>'DEMO_APPLICATION.TRIGGER'
,p_message_text=>'Trigger'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(313676104908502024)
,p_name=>'DEMO_APPLICATION.UNLOCKED'
,p_message_text=>'Unlocked'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(23242703577590357)
,p_name=>'DEMO_APPLICATION.UPDATE_AVAILABLE'
,p_message_text=>'Update Available'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86640725476460289)
,p_name=>'DEMO_APPLICATION.WEB_SERVICES'
,p_message_text=>'Web Services'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86537630971083428)
,p_name=>'DEMO_APPLICATION.WILL_ERROR'
,p_message_text=>'You may experience an error if you are not recreating this demonstration.'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(50836014165298463)
,p_name=>'DEMO_FLOW.CREATED_ERROR'
,p_message_text=>'There was not enough space to create this demonstration.  Request additional storage by going to the administration page, and clicking on the "Request Changes to Current Service" link.'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(50835403776295415)
,p_name=>'DEMO_FLOW.CREATED_SUCCESS'
,p_message_text=>'The %0 demonstration application was created.'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(113010344867769977)
,p_name=>'DEP.ERROR_COUNT'
,p_message_text=>'Errors (%0)'
,p_version_scn=>21809203
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(66356624476285811)
,p_name=>'DEP.ERROR_PLURAL'
,p_message_text=>'Errors'
,p_version_scn=>14195046
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25943181372483495)
,p_name=>'DEP.FETCHING'
,p_message_text=>'Fetching application metadata'
,p_version_scn=>57463118
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25943744192502419)
,p_name=>'DEP.FINISHED'
,p_message_text=>'Finished'
,p_version_scn=>57464396
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25943509379498778)
,p_name=>'DEP.FINISHING'
,p_message_text=>'Finishing'
,p_version_scn=>57464307
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(65785376510138085)
,p_name=>'DEP.FUNCTION_PLURAL'
,p_message_text=>'Functions'
,p_version_scn=>13986740
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25942972540398637)
,p_name=>'DEP.INITIALIZING'
,p_message_text=>'Initializing'
,p_version_scn=>57456217
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5367324105658257)
,p_name=>'DEP.LIBRARY_PLURAL'
,p_message_text=>'Libraries'
,p_version_scn=>66072842
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(75830556551783212)
,p_name=>'DEP.MVIEW_PLURAL'
,p_message_text=>'Materialized Views'
,p_version_scn=>16609769
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(129986708938540566)
,p_name=>'DEP.NESTED_TABLE_PLURAL'
,p_message_text=>'Nested Tables'
,p_version_scn=>22475170
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(9444692212662861)
,p_name=>'DEP.NO_DEPENDENCIES'
,p_message_text=>'Scan completed successfully, but no dependencies or errors were found.'
,p_version_scn=>104474426
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(9444493891660676)
,p_name=>'DEP.NO_DEPENDENCIES_PAGE'
,p_message_text=>'Scan completed successfully, but no dependencies or errors were found on Page %0.'
,p_version_scn=>104474340
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(9444274452656865)
,p_name=>'DEP.NO_ERRORS'
,p_message_text=>'Scan completed successfully, but no errors were found.'
,p_version_scn=>104474278
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(9444061979654407)
,p_name=>'DEP.NO_ERRORS_PAGE'
,p_message_text=>'Scan completed successfully, but no errors were found on Page %0.'
,p_version_scn=>104474554
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5366891760552699)
,p_name=>'DEP.OPERATOR_PLURAL'
,p_message_text=>'Operators'
,p_version_scn=>66066638
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(65784156715126784)
,p_name=>'DEP.PACKAGE_PLURAL'
,p_message_text=>'Packages'
,p_version_scn=>13986366
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5626656727107446)
,p_name=>'DEP.PAGE'
,p_message_text=>'Page %0'
,p_version_scn=>63758619
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(65785525498139548)
,p_name=>'DEP.PROCEDURE_PLURAL'
,p_message_text=>'Procedures'
,p_version_scn=>13986820
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25943366707489858)
,p_name=>'DEP.SCANNING'
,p_message_text=>'Scanning %0'
,p_version_scn=>57463185
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(65784396124129576)
,p_name=>'DEP.SCHEMA_PLURAL'
,p_message_text=>'Schemas'
,p_version_scn=>13986419
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(73872298892209873)
,p_name=>'DEP.SEQUENCE_PLURAL'
,p_message_text=>'Sequences'
,p_version_scn=>15752700
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(65784568964131449)
,p_name=>'DEP.SYNONYM_PLURAL'
,p_message_text=>'Synonyms'
,p_version_scn=>13986467
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(100142233396037624)
,p_name=>'DEP.SYSTEM_DEPENDENCY_PLURAL'
,p_message_text=>'System Dependencies'
,p_version_scn=>20565144
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(65784757485132731)
,p_name=>'DEP.TABLE_PLURAL'
,p_message_text=>'Tables'
,p_version_scn=>13986565
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(65784935775134072)
,p_name=>'DEP.TYPE_PLURAL'
,p_message_text=>'Types'
,p_version_scn=>13986599
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(65785188986136773)
,p_name=>'DEP.VIEW_PLURAL'
,p_message_text=>'Views'
,p_version_scn=>13986712
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(480758127693408050)
,p_name=>'DEPRECATED'
,p_message_text=>'Deprecated'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(36720023900411452)
,p_name=>'DERIVED$'
,p_message_text=>'derived column'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(174644425610654818)
,p_name=>'DESIRABLE'
,p_message_text=>'Desirable'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(228702619717448415)
,p_name=>'DETAIL'
,p_message_text=>'Detail'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(277486928313626173)
,p_name=>'DETAILS_FOR_ALT_TAG'
,p_message_text=>'Details'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(228739531108499058)
,p_name=>'DETAIL_2'
,p_message_text=>'Detail 2'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(17810404748954428)
,p_name=>'DEVELOPER'
,p_message_text=>'Developer'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(293190322524322629)
,p_name=>'DEVELOPERS'
,p_message_text=>'Developers'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184172513415030584)
,p_name=>'DEVELOPER_ACTIVITY_SUMMARY'
,p_message_text=>'Developer Activity Summary'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(192133732493924765)
,p_name=>'DEVELOPER_SUMMARY'
,p_message_text=>'Developer Summary'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2702015186464033)
,p_name=>'DEVELOPER_TOOLBAR_APPLICATION'
,p_message_text=>'App %0'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(186261000404476007)
,p_name=>'DEVELOPER_TOOLBAR_APP_CUSTOMIZATION'
,p_message_text=>'App Customization'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(360140386507888882)
,p_name=>'DEVELOPER_TOOLBAR_CLEAR'
,p_message_text=>'Clear'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(360140125773885528)
,p_name=>'DEVELOPER_TOOLBAR_COPY'
,p_message_text=>'Copy'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(575493681141328292)
,p_name=>'DEVELOPER_TOOLBAR_CUSTOMIZE'
,p_message_text=>'Customize'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(366642448785309569)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LABEL'
,p_message_text=>'Debug (%0)'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(366641626667300575)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LEVEL'
,p_message_text=>'Default Debug Level'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(366641861195302368)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LEVEL4'
,p_message_text=>'Info (default)'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(366642012920304246)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LEVEL6'
,p_message_text=>'App Trace'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(366642200394306469)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LEVEL9'
,p_message_text=>'Full Trace'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2800360693488448)
,p_name=>'DEVELOPER_TOOLBAR_EDIT_PAGE'
,p_message_text=>'Page %0'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(353746132583436489)
,p_name=>'DEVELOPER_TOOLBAR_ERRORS'
,p_message_text=>'One or more errors have occurred since the page loaded. Open the Browser''s JavaScript console to see the errors.'
,p_is_js_message=>true
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(355175192670438833)
,p_name=>'DEVELOPER_TOOLBAR_ERRORS_BTN'
,p_message_text=>'JavaScript Errors'
,p_is_js_message=>true
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(575493935590328293)
,p_name=>'DEVELOPER_TOOLBAR_LOGO_EDITOR'
,p_message_text=>'Edit Logo'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(386897861761240703)
,p_name=>'DEVELOPER_TOOLBAR_NO_BUILDER'
,p_message_text=>'This functionality requires the Oracle APEX App Builder window to be open. Do you want to open the Builder in this window?'
,p_is_js_message=>true
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(381273200466580477)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS'
,p_message_text=>'Developer Toolbar Options'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(384555059549864274)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_AUTO_HIDE'
,p_message_text=>'Auto Hide'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(384555419711870333)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_DISPLAY'
,p_message_text=>'Display Position'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(384555291942867299)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_ICONS_ONLY'
,p_message_text=>'Show Icons Only'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(384555814973874379)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_POS_BOTTOM'
,p_message_text=>'Bottom'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(384555656409872765)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_POS_LEFT'
,p_message_text=>'Left'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(384556064886876117)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_POS_RIGHT'
,p_message_text=>'Right'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(385761552293309631)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_POS_TOP'
,p_message_text=>'Top'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(355989664736465271)
,p_name=>'DEVELOPER_TOOLBAR_PAGE_INFO'
,p_message_text=>'Info'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(356002468951508889)
,p_name=>'DEVELOPER_TOOLBAR_PERF_TITLE'
,p_message_text=>'Page Performance Timing'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(381358960615424454)
,p_name=>'DEVELOPER_TOOLBAR_QUICK_EDIT'
,p_message_text=>'Quick Edit'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3900992399487999)
,p_name=>'DEVELOPER_TOOLBAR_SESSION_OVERRIDES_ADDITIONAL_FILES'
,p_message_text=>'Additional Files'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3901118067487999)
,p_name=>'DEVELOPER_TOOLBAR_SESSION_OVERRIDES_ADDITIONAL_FILES_CSS'
,p_message_text=>'CSS URLs'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3901028693487999)
,p_name=>'DEVELOPER_TOOLBAR_SESSION_OVERRIDES_ADDITIONAL_FILES_JS'
,p_message_text=>'JavaScript URLs'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3900140972409553)
,p_name=>'DEVELOPER_TOOLBAR_SESSION_OVERRIDES_CURRENT_DEBUG_LEVEL'
,p_message_text=>'Current Debug Level'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3900326253409570)
,p_name=>'DEVELOPER_TOOLBAR_SESSION_OVERRIDES_CURRENT_DEBUG_LEVEL_TITLE'
,p_message_text=>'level %0'
,p_version_scn=>129947735
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3800907511350892)
,p_name=>'DEVELOPER_TOOLBAR_SESSION_OVERRIDES_DISABLED'
,p_message_text=>'Overrides Off'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3800838028350892)
,p_name=>'DEVELOPER_TOOLBAR_SESSION_OVERRIDES_ENABLED'
,p_message_text=>'Overrides On'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3900246900409569)
,p_name=>'DEVELOPER_TOOLBAR_SESSION_OVERRIDES_ENABLE_DEBUG'
,p_message_text=>'Enable Debug'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3900470346487997)
,p_name=>'DEVELOPER_TOOLBAR_SESSION_OVERRIDES_FILE_PATH'
,p_message_text=>'File Paths'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3900587883487997)
,p_name=>'DEVELOPER_TOOLBAR_SESSION_OVERRIDES_FILE_PATH_APEX'
,p_message_text=>'APEX Files<p><small><em>#APEX_FILES#</em></small></p>'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3900672405487998)
,p_name=>'DEVELOPER_TOOLBAR_SESSION_OVERRIDES_FILE_PATH_APP'
,p_message_text=>'Application Files<p><small><em>#APP_FILES#</em></small></p>'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3900895558487998)
,p_name=>'DEVELOPER_TOOLBAR_SESSION_OVERRIDES_FILE_PATH_THEME'
,p_message_text=>'Theme Files<p><small><em>#THEME_FILES#</em></small></p>'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3900709826487998)
,p_name=>'DEVELOPER_TOOLBAR_SESSION_OVERRIDES_FILE_PATH_WORKSPACE'
,p_message_text=>'Workspace Files<p><small><em>#WORKSPACE_FILES#</em></small></p>'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3901259815488000)
,p_name=>'DEVELOPER_TOOLBAR_SESSION_OVERRIDES_GLOBALIZATION'
,p_message_text=>'Globalization'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3901417908488001)
,p_name=>'DEVELOPER_TOOLBAR_SESSION_OVERRIDES_GLOBALIZATION_DIRECTION'
,p_message_text=>'Document Direction'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3901521354488001)
,p_name=>'DEVELOPER_TOOLBAR_SESSION_OVERRIDES_GLOBALIZATION_DIRECTION_LTR'
,p_message_text=>'Left to Right'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3901610660488001)
,p_name=>'DEVELOPER_TOOLBAR_SESSION_OVERRIDES_GLOBALIZATION_DIRECTION_RTL'
,p_message_text=>'Right to Left'
,p_version_scn=>37165770887505
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3901347854488000)
,p_name=>'DEVELOPER_TOOLBAR_SESSION_OVERRIDES_GLOBALIZATION_LANGUAGE'
,p_message_text=>'Application Language'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3901724237488002)
,p_name=>'DEVELOPER_TOOLBAR_SESSION_OVERRIDES_GLOBALIZATION_TIMEZONE'
,p_message_text=>'Timezone'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3800759155350891)
,p_name=>'DEVELOPER_TOOLBAR_SESSION_OVERRIDES_TITLE'
,p_message_text=>'Session Overrides %0'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(355999028492503322)
,p_name=>'DEVELOPER_TOOLBAR_SHOW_PERF'
,p_message_text=>'Show Page Timing'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1204379270876804968)
,p_name=>'DEVELOPER_TOOLBAR_THEME_ROLLER'
,p_message_text=>'Theme Roller'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(382663032436820803)
,p_name=>'DEVELOPER_TOOLBAR_TITLE'
,p_message_text=>'Developer Toolbar'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(267547537217734558)
,p_name=>'DEVELOPER_TOOLBAR_UL_LABEL'
,p_message_text=>'Developer'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3800545119314967)
,p_name=>'DEVELOPER_TOOLBAR_VIEW_SESSION'
,p_message_text=>'View Session State'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(171867412470876722)
,p_name=>'DEVELOPMENT_TASK'
,p_message_text=>'Development Task'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(296084422964260258)
,p_name=>'DIAL_CHART_ALERT_VALUE'
,p_message_text=>'Alert'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(296083516385258328)
,p_name=>'DIAL_CHART_HIGH_VALUE'
,p_message_text=>'High'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(296083010497256643)
,p_name=>'DIAL_CHART_LOW_VALUE'
,p_message_text=>'Low Value'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1282446584658956)
,p_name=>'DICTIONARY.APEX_APPL_PAGE_ITEM_GROUPS'
,p_message_text=>'Page Item Groups'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25298122802560928)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATIONS'
,p_message_text=>'Applications'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25303424842608773)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_AUTH'
,p_message_text=>'Authentication Schemes'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25303600732611242)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_AUTHORIZATION'
,p_message_text=>'Authorization Schemes'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25301813283595956)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_BC_ENTRIES'
,p_message_text=>'Entries'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25301607742594383)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_BREADCRUMBS'
,p_message_text=>'Breadcrumbs'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1980048219402510376)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_BUILD_OPTIONS'
,p_message_text=>'Build Options'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25300910035585579)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_COMPUTATIONS'
,p_message_text=>'Application Computations'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25301403240593082)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_ITEMS'
,p_message_text=>'Application Items'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25302018824597563)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LISTS'
,p_message_text=>'Lists'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25302223672598958)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LIST_ENTRIES'
,p_message_text=>'Entries'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25302430252600892)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LOVS'
,p_message_text=>'List of Values'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(9202606977180731)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LOV_COLS'
,p_message_text=>'List of Value Columns'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25302603025602424)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LOV_ENTRIES'
,p_message_text=>'Entries'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25302808566604098)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_NAV_BAR'
,p_message_text=>'Navigation Bars'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25298327650562264)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGES'
,p_message_text=>'Pages'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25300700685582832)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_BRANCHES'
,p_message_text=>'Branches'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25299121201569922)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_BUTTONS'
,p_message_text=>'Buttons'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(153864276128707774)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_CHARTS'
,p_message_text=>'Charts'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(153864632540710785)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_CHART_A'
,p_message_text=>'Axes'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(153864490797709415)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_CHART_S'
,p_message_text=>'Series'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25300116830578077)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_COMP'
,p_message_text=>'Computations'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(40262323537603241)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_DA'
,p_message_text=>'Dynamic Actions'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(40262510855609094)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_DA_ACTS'
,p_message_text=>'Dynamic Action - Actions'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25299705402574756)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_IR'
,p_message_text=>'IR Regions'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25299911982576690)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_IR_COL'
,p_message_text=>'Report Columns'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25298709080566394)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_ITEMS'
,p_message_text=>'Page Items'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25300528258581348)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_PROC'
,p_message_text=>'Processes'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25298500077563817)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_REGIONS'
,p_message_text=>'Regions'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(573536325941511679)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_REG_COLS'
,p_message_text=>'Columns'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25298916007568367)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_RPT_COLS'
,p_message_text=>'Report Columns'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(803509317745097730)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_TREES'
,p_message_text=>'Trees'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25300322025579558)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_VAL'
,p_message_text=>'Validations'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25303014799605856)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PARENT_TABS'
,p_message_text=>'Parent Tabs'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25301122502589172)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PROCESSES'
,p_message_text=>'Application Processes'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(972898512937938103)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_RPT_LAYOUTS'
,p_message_text=>'Report Layouts'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(978742247507281708)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_RPT_QRY_STMTS'
,p_message_text=>'Report Query SQL Statements'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(972898399932936898)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_RPT_QUERIES'
,p_message_text=>'Report Queries'
,p_version_scn=>37165770887506
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(659977078006490487)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SETTINGS'
,p_message_text=>'Application Settings'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25303806273612922)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SHORTCUTS'
,p_message_text=>'Shortcuts'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(24585407027078375)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_STATIC_FILES'
,p_message_text=>'Application Files'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25306831122638922)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUBSTITUTIONS'
,p_message_text=>'Substitutions'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1980047693313506828)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUPP_OBJECTS'
,p_message_text=>'Supporting Objects'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1980047862409507939)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUPP_OBJ_BOPT'
,p_message_text=>'Supporting Objects-Build Options'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25306420387635911)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUPP_OBJ_CHCK'
,p_message_text=>'Supporting Objects-Validations'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25306626274637532)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUPP_OBJ_SCR'
,p_message_text=>'Supporting Objects-Scripts'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25303219301607190)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TABS'
,p_message_text=>'Tabs'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25304629475619537)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_BC'
,p_message_text=>'Breadcrumb Templates'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25304801902621117)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_BUTTON'
,p_message_text=>'Button Templates'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25305012291624108)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_CALENDAR'
,p_message_text=>'Calendar Templates'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(46096213775712442)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_GRID'
,p_message_text=>'Grid Templates'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25305217139625509)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_LABEL'
,p_message_text=>'Label Templates'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25305422334626928)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_LIST'
,p_message_text=>'List Templates'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25305626836628302)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_PAGE'
,p_message_text=>'Page Templates'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25305832723630018)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_POPUPLOV'
,p_message_text=>'Popup LOV Templates'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25306007573632140)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_REGION'
,p_message_text=>'Region Templates'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25306213807633997)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_REPORT'
,p_message_text=>'Report Templates'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25304423588617828)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_THEMES'
,p_message_text=>'Themes'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(22471918393334546)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_THEME_FILES'
,p_message_text=>'Theme Files'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4404910736916502)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_THEME_STYLES'
,p_message_text=>'Theme Styles'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184622614836817675)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TRANSLATIONS'
,p_message_text=>'Text Messages'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(20700923873719648)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TRANS_DYNAMIC'
,p_message_text=>'Dynamic Translations'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(20701132184722136)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TRANS_REPOS'
,p_message_text=>'Translatable Text'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25304218047616285)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TREES'
,p_message_text=>'Trees'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25304012506614625)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_WEB_SERVICES'
,p_message_text=>'Web Services'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(726145854627236327)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_ACL_ROLES'
,p_message_text=>'Access Control Roles'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(726167576938240101)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_ACL_USERS'
,p_message_text=>'Access Control Users'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(213698187815497496)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_ACL_USER_ROLES'
,p_message_text=>'Access Control User Role Assignment'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1919629577199890)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_AI_CONFIGS'
,p_message_text=>'AI Configurations'
,p_version_scn=>177699786
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1919810555202466)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_AI_CONFIG_RAG_SRCS'
,p_message_text=>'RAG Sources'
,p_version_scn=>184477028
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2000571616049705)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_AUTOMATIONS'
,p_message_text=>'Automations'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2000854631053745)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_AUTOMATION_ACTIONS'
,p_message_text=>'Automation - Actions'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3236853974485426)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_COMPONENT_GROUPS'
,p_message_text=>'Component Groups'
,p_version_scn=>16214233
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1018712666401555678)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_CONCATENATED_FILES'
,p_message_text=>'Concatenated Files'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(10100419105481796)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_DATA_LOADS'
,p_message_text=>'Data Loads'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(160793077882317301)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_DATA_PROFILES'
,p_message_text=>'Data Parsing Profiles'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(160793203513318786)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_DATA_PROFILE_COLS'
,p_message_text=>'Data Parsing Profile Columns'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1412618625300025145)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_DEVELOPER_COMMENTS'
,p_message_text=>'Developer Comments'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4930115472526319)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_DUALITY_VIEWS'
,p_message_text=>'Duality Views'
,p_version_scn=>38439052
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(839979139605711982)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_EMAIL_TEMPLATES'
,p_message_text=>'Email Templates'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4001340008302656)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_INVOKE_API_PARAMS'
,p_message_text=>'Component Invoke API Parameters'
,p_version_scn=>38788295
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4929946505524744)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_JSON_SOURCES'
,p_message_text=>'JSON Sources'
,p_version_scn=>38438906
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(438005425079217783)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_LOAD_TABLE'
,p_message_text=>'Data Load Table'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(431147405285707613)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_LOAD_TABLES'
,p_message_text=>'Data Load Tables'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(431207111519709450)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_LOAD_TABLE_LOOKUPS'
,p_message_text=>'Data Load Table Lookups'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(431254819137711646)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_LOAD_TABLE_RULES'
,p_message_text=>'Data Load Table Transformation Rules'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(176043454647666081)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_MAP_BACKGROUNDS'
,p_message_text=>'Map Backgrounds'
,p_version_scn=>37165925786973
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2000112083714237)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_BG_PROC_STATUS'
,p_message_text=>'Page Process Background Executions'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(6355510169032202)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_CALENDARS'
,p_message_text=>'Calendar Pages'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(6001991272157846)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_CARDS'
,p_message_text=>'Cards'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(6002114482160226)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_CARD_ACTIONS'
,p_message_text=>'Card Actions'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2024122226676626)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_COMP_ACTIONS'
,p_message_text=>'Actions'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(382292046190893480)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_IGS'
,p_message_text=>'Interactive Grid Regions'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(382292212545898262)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_IG_COLUMNS'
,p_message_text=>'Report Columns'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(382292498099900066)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_IG_COL_GROUPS'
,p_message_text=>'Column Groups'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1700174255909188)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_MAPS'
,p_message_text=>'Maps'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1700221275920742)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_MAP_LAYERS'
,p_message_text=>'Map Layers'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2024300948680400)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_MENU_ENTRIES'
,p_message_text=>'Menu Entries'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2040222599089119)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_META_TAGS'
,p_message_text=>'Page Meta Tags'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2001379581913805)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_SEARCH_SOURCES'
,p_message_text=>'Search Region Sources'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(28180907816420685)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGINS'
,p_message_text=>'Plug-ins'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2024710175687432)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_ACT_POSITIONS'
,p_message_text=>'Action Positions'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2024563832685262)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_ACT_TEMPLATES'
,p_message_text=>'Action Templates'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(28181119244423990)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_ATTRIBUTES'
,p_message_text=>'Attributes'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1712370435413546)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_ATTR_GROUPS'
,p_message_text=>'Attribute Groups'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184246512825879782)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_ATTR_VALUES'
,p_message_text=>'Values'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(48607312036937762)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_EVENTS'
,p_message_text=>'Events'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(29914022361373053)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_FILES'
,p_message_text=>'Files'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(229787870621608090)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_ITEM_FILTERS'
,p_message_text=>'Filter Operators'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1980048074915509101)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_SETTINGS'
,p_message_text=>'Component Settings'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1601730316803940)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_SLOTS'
,p_message_text=>'Slots'
,p_version_scn=>98916146
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(835956048613350616)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_STD_ATTRS'
,p_message_text=>'Plug-In Standard Attribute Meta Data'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2040041401087668)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PWA_SCREENSHOTS'
,p_message_text=>'PWA Screenshots'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2039590151080826)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PWA_SHORTCUTS'
,p_message_text=>'PWA Shortcuts'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(160792862016313926)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_REMOTE_SQL'
,p_message_text=>'REST Enabled SQL Servers'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1812179768280218)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_SEARCH_CONFIGS'
,p_message_text=>'Search Configurations'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1645112173180942)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TASKDEFS'
,p_message_text=>'Human Task Definitions'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1645373164184524)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TASKDEF_ACTIONS'
,p_message_text=>'Task Definition Actions'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1646052567231242)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TASKDEF_COMP_PARAMS'
,p_message_text=>'Component Task Definition Parameters'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1645550886187404)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TASKDEF_PARAMS'
,p_message_text=>'Task Definition Parameters'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1645717435192457)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TASKDEF_PARTICIPANTS'
,p_message_text=>'Task Definition Participants'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(573146723726150452)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMPLATE_OPTIONS'
,p_message_text=>'Template Options'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1980047452063505090)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMPLATE_OPT_GROUPS'
,p_message_text=>'Template Option Groups'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(686997998172447583)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMPLATE_OPT_GRP'
,p_message_text=>'Template Option Group'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1133443428743194825)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMP_PAGE_DP'
,p_message_text=>'Positions'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1133443614551196137)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMP_REGION_DP'
,p_message_text=>'Positions'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(47715223352407140)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_THEME_DISPLAY_POINTS'
,p_message_text=>'Theme Display Points'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(160794298871328000)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_COMP_PARAMS'
,p_message_text=>'Component REST Source Parameters'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(160793662266322576)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_MODULES'
,p_message_text=>'REST Data Sources'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(160793812375324171)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_OPERATIONS'
,p_message_text=>'REST Source Operations'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(160794059255325819)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_PARAMETERS'
,p_message_text=>'REST Source Parameters'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(160793463285320890)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_SERVERS'
,p_message_text=>'REST Source Remote Servers'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2001340608456881)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_SYNC_STEPS'
,p_message_text=>'REST Synchronization Steps'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1601490683254545)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WORKFLOWS'
,p_message_text=>'Workflow Definitions'
,p_version_scn=>38788295
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1601861366264057)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WORKFLOW_ACTIVITIES'
,p_message_text=>'Workflow Activity Definitions'
,p_version_scn=>38788295
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1602650448290114)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WORKFLOW_ACT_VARS'
,p_message_text=>'Workflow Activity Variable Definitions'
,p_version_scn=>38788295
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(162997916462965922)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WORKFLOW_BRANCHES'
,p_message_text=>'Workflow Branch Definitions'
,p_version_scn=>64098310
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1602895238294999)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WORKFLOW_COMP_PARAMS'
,p_message_text=>'Workflow Component Parameters'
,p_version_scn=>38788295
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1602453112286576)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WORKFLOW_PARAMS'
,p_message_text=>'Workflow Parameter Definitions'
,p_version_scn=>38788295
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1603070153297912)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WORKFLOW_PARTICIPANT'
,p_message_text=>'Workflow Participant Definitions'
,p_version_scn=>38788295
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1602005639281738)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WORKFLOW_TRANSITIONS'
,p_message_text=>'Workflow Transition Definitions'
,p_version_scn=>38788295
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1602209178284256)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WORKFLOW_VARIABLES'
,p_message_text=>'Workflow Variable Definitions'
,p_version_scn=>38788295
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1601633909259613)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WORKFLOW_VERSIONS'
,p_message_text=>'Workflow Definition Versions'
,p_version_scn=>38788295
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2001263883077977)
,p_name=>'DICTIONARY_VIEW.APEX_AUTOMATION_LOG'
,p_message_text=>'Automation Log'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2001414699079870)
,p_name=>'DICTIONARY_VIEW.APEX_AUTOMATION_MSG_LOG'
,p_message_text=>'Automation Message Log'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1644185701830774)
,p_name=>'DICTIONARY_VIEW.APEX_TASKS'
,p_message_text=>'Human Tasks'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1644519962838558)
,p_name=>'DICTIONARY_VIEW.APEX_TASK_COMMENTS'
,p_message_text=>'Human Task Comments'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1644361045835609)
,p_name=>'DICTIONARY_VIEW.APEX_TASK_HISTORY'
,p_message_text=>'Human Task History'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1644980816843295)
,p_name=>'DICTIONARY_VIEW.APEX_TASK_PARAMETERS'
,p_message_text=>'Human Task Parameters'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1644740126841766)
,p_name=>'DICTIONARY_VIEW.APEX_TASK_PARTICIPANTS'
,p_message_text=>'Human Task Participants'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2400960509828160)
,p_name=>'DICTIONARY_VIEW.APEX_WORKFLOWS'
,p_message_text=>'Workflows'
,p_version_scn=>38788295
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2401109353829793)
,p_name=>'DICTIONARY_VIEW.APEX_WORKFLOW_ACTIVITIES'
,p_message_text=>'Workflow Activities'
,p_version_scn=>38788295
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2401721186839085)
,p_name=>'DICTIONARY_VIEW.APEX_WORKFLOW_ACTIVITY_VARS'
,p_message_text=>'Workflow Activity Variables'
,p_version_scn=>38788295
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2402161095844054)
,p_name=>'DICTIONARY_VIEW.APEX_WORKFLOW_AUDIT'
,p_message_text=>'Workflow Audit'
,p_version_scn=>38788295
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2401575580832867)
,p_name=>'DICTIONARY_VIEW.APEX_WORKFLOW_PARAMETERS'
,p_message_text=>'Workflow Parameters'
,p_version_scn=>38788295
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2401975739842640)
,p_name=>'DICTIONARY_VIEW.APEX_WORKFLOW_PARTICIPANTS'
,p_message_text=>'Workflow Participants'
,p_version_scn=>38788295
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2401397492831523)
,p_name=>'DICTIONARY_VIEW.APEX_WORKFLOW_VARIABLES'
,p_message_text=>'Workflow Variables'
,p_version_scn=>38788295
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(856780615481386063)
,p_name=>'DISABLED_NEXT_BUTTON'
,p_message_text=>'Disabled Next Button'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(856768711672384969)
,p_name=>'DISABLED_PREVIOUS_BUTTON'
,p_message_text=>'Disabled Previous Button'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86865117548760809)
,p_name=>'DISPLAY_CONDITION'
,p_message_text=>'Display Condition'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86866805212766707)
,p_name=>'DISPLAY_CONDITION_TEXT'
,p_message_text=>'Display Condition Text'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(330745710183192592)
,p_name=>'DISPLAY_ORDER_LABEL'
,p_message_text=>'Display Order: %0'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(32496506841842752)
,p_name=>'DISPLAY_TYPE'
,p_message_text=>'Display Type'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1959701514123060257)
,p_name=>'DISPLAY_VALUE.N'
,p_message_text=>'Display Value: %0'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(820473830149557306)
,p_name=>'DISTINCT_PAGES'
,p_message_text=>'Distinct Pages'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(820474114696562256)
,p_name=>'DISTINCT_USERS'
,p_message_text=>'Distinct Users'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(9200522165667512)
,p_name=>'DML_FORM'
,p_message_text=>'DML Form'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(114391602227012711)
,p_name=>'DO NOT UPDATE PAGE ITEMS'
,p_message_text=>'DO_NOT_UPDATE_PAGE_ITEMS'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(183994729169597113)
,p_name=>'DOC_IMPACT'
,p_message_text=>'Documentation Impact'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(183998807744619317)
,p_name=>'DOC_STATUS'
,p_message_text=>'Documentation Status'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(183999415709621603)
,p_name=>'DOC_WRITER'
,p_message_text=>'Documentation Writer'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(131525828309214179)
,p_name=>'DOWN'
,p_message_text=>'Down'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184528229792520693)
,p_name=>'DOWNLOAD_LINK_TEXT'
,p_message_text=>'Download Link Text'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(114388432440002543)
,p_name=>'DO_NOT_UPDATE_APPLICATION_ITEMS'
,p_message_text=>'Do not update application items'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(114390109714005492)
,p_name=>'DO_NOT_UPDATE_DATA_ENTRY_ITEMS'
,p_message_text=>'Do not update data entry items'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(114391022528009163)
,p_name=>'DO_NOT_UPDATE_DISPLAY_ONLY_ITEMS'
,p_message_text=>'Do not update display-only items'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(114387304950985129)
,p_name=>'DO_NOT_UPDATE_PAGES'
,p_message_text=>'Do not update pages'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(114499007559840034)
,p_name=>'DO_NOT_UPDATE_PAGE_ITEMS'
,p_message_text=>'Do not update page items'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(77645421757592088)
,p_name=>'DRAG_AND_DROP'
,p_message_text=>'Drag and Drop'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(26822732038167865)
,p_name=>'DRILLDOWN'
,p_message_text=>'Drill Down'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(26822328574166869)
,p_name=>'DRILLUP'
,p_message_text=>'Drill Up'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(88171105019057676)
,p_name=>'DRIVEN'
,p_message_text=>'driven'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(270362200161898315)
,p_name=>'DROP_COLUMN'
,p_message_text=>'Drop Column %0'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(418847524033673598)
,p_name=>'DS_ACCESS_METHOD'
,p_message_text=>'Access Method'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(418819928057665325)
,p_name=>'DS_BIND_VARIABLE_NAME'
,p_message_text=>'Bind Variable Name'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(418893519662681756)
,p_name=>'DS_HANDLER'
,p_message_text=>'Handler'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(419019521655701272)
,p_name=>'DS_ITEMS_PER_PAGE'
,p_message_text=>'Items Per Page'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(418976600877695258)
,p_name=>'DS_MIME_TYPES_ALLOWED'
,p_message_text=>'MIME Types Allowed'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(419007813690698969)
,p_name=>'DS_ORIGINS_ALLOWED'
,p_message_text=>'Origins Allowed'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(418855400615676314)
,p_name=>'DS_PARAMETER_TYPE'
,p_message_text=>'Parameter Type'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(419027432391704379)
,p_name=>'DS_SECURITY_CONSTRAINT'
,p_message_text=>'Security Constraint'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(418839615375671058)
,p_name=>'DS_SOURCE'
,p_message_text=>'Source'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(418926904555686898)
,p_name=>'DS_SOURCE_TYPE'
,p_message_text=>'Source Type'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(419039413821708472)
,p_name=>'DS_URI_PREFIX'
,p_message_text=>'URI Prefix'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(418738202300648453)
,p_name=>'DS_URI_TEMPLATE'
,p_message_text=>'URI Template'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2755777427768627)
,p_name=>'DUALITY_VIEW_PLURAL'
,p_message_text=>'Duality Views'
,p_version_scn=>21943572
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2755557355767590)
,p_name=>'DUALITY_VIEW_SINGULAR'
,p_message_text=>'Duality View'
,p_version_scn=>21942871
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(980680785332625341)
,p_name=>'DUE'
,p_message_text=>'Due'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(183998228738615949)
,p_name=>'DUE_DATE'
,p_message_text=>'Due Date'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(172717500236292467)
,p_name=>'DUPLICATE'
,p_message_text=>'Duplicate'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(829735346009007045)
,p_name=>'DUPLICATE_USER'
,p_message_text=>'Duplicate user in list'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4521519772939447)
,p_name=>'DYNAMIC ACTION'
,p_message_text=>'Dynamic Action'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(4521314577937997)
,p_name=>'DYNAMIC ACTIONS'
,p_message_text=>'Dynamic Actions'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(8483313274523015)
,p_name=>'DYNAMIC_FORM'
,p_message_text=>'Dynamic Form'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(42485347173711860)
,p_name=>'DYNAMIC_HTML'
,p_message_text=>'Dynamic HTML'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(75583618448331157)
,p_name=>'DYNAMIC_QUERY'
,p_message_text=>'Interactive Report'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2482320333924478)
,p_name=>'DYNAMIC_REFERENCE'
,p_message_text=>'Dynamic Reference'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(107656122999656198)
,p_name=>'EASY_REPORT.INVALID_CONDITION'
,p_message_text=>'The condition you are adding has caused the query to be invalid.'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5961703297676406)
,p_name=>'EDIT PAGE GROUP'
,p_message_text=>'Edit Page Group'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(203707602014515361)
,p_name=>'EDITOR_EXIT'
,p_message_text=>'You will loose unsaved changes if you choose OK.'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(17524809329912576)
,p_name=>'EDIT_ALL'
,p_message_text=>'Edit All'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(108520607008660982)
,p_name=>'EDIT_ALL_PAGE_DEFINITION_ATTRIBUTES'
,p_message_text=>'Edit all page definition attributes'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(196571121853984806)
,p_name=>'EDIT_ALL_REGION'
,p_message_text=>'Edit all items in this region'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(165849123481033944)
,p_name=>'EDIT_APPLICATION'
,p_message_text=>'Edit Application'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(227298415750327626)
,p_name=>'EDIT_ATTRIBUTE'
,p_message_text=>'Edit Attribute'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(623896109116574858)
,p_name=>'EDIT_AUTHENTICATION'
,p_message_text=>'Edit Authentication'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(209279114711024779)
,p_name=>'EDIT_COMPONENT'
,p_message_text=>'Edit Component'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(227304624024377369)
,p_name=>'EDIT_COMPONENT_DEF'
,p_message_text=>'Edit Component Definition'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(304860839623544861)
,p_name=>'EDIT_LINK_TEXT'
,p_message_text=>'Edit %0'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(227290119035290700)
,p_name=>'EDIT_LIST_DEV'
,p_message_text=>'Edit List Definition'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(926816628335129335)
,p_name=>'EDIT_LOCK'
,p_message_text=>'Edit Lock'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(148724424971906642)
,p_name=>'EDIT_PAGE'
,p_message_text=>'Edit Page'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(109823904326721164)
,p_name=>'EDIT_PAGE_ATTRIBUTES'
,p_message_text=>'Edit page attributes'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(485854150589995875)
,p_name=>'EDIT_PROFILE'
,p_message_text=>'Edit Profile'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(495340620321711192)
,p_name=>'EDIT_PROFILE.USER_NO_PRIV_ERR'
,p_message_text=>'User 0% has no privileges to update the information for another user.'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(209252912352853733)
,p_name=>'EDIT_REGION'
,p_message_text=>'Edit Region'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(295258003666132616)
,p_name=>'EDIT_REPORTING_TIMEFRAME'
,p_message_text=>'Edit Reporting Timeframe'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(209256117678864784)
,p_name=>'EDIT_REPORT_COLS'
,p_message_text=>'Edit Report Columns'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(481306729733270553)
,p_name=>'EDIT_REPORT_DIALOG_CLOSED_DA'
,p_message_text=>'Edit Report - Dialog Closed'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(195816020534303963)
,p_name=>'EDIT_SYSTEM_MESSAGE'
,p_message_text=>'Edit System Message'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(454859202056072704)
,p_name=>'EDIT_TAB'
,p_message_text=>'Edit Tab'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(228986309599775173)
,p_name=>'EDIT_THIS_ATTRIBUTE'
,p_message_text=>'Edit this attribute'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145151519309641028)
,p_name=>'ELAPSED_TIME'
,p_message_text=>'Elapsed Time'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(177293525864118220)
,p_name=>'EMAIL.TEMPLATE.FOOTER_EXAMPLE'
,p_message_text=>'<a rel="noopener noreferrer" href="#MY_APPLICATION_LINK#">Visit My Application and manage your email preferences</a>.'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(182816204436193767)
,p_name=>'EMAIL.TEMPLATE.HEADER_EXAMPLE'
,p_message_text=>'<b style="font-size: 24px;">My Application</b>'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(270605954832606075)
,p_name=>'EMAIL.TEMPLATE.HTML_BODY_EXAMPLE.EV'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<strong>Hello #INVITEE#,</strong><br>',
'<br>',
'This is a reminder of an upcoming event you have been invited to.  Please see the event details below:<br>',
'<br>',
'<table width="100%">',
'  <tr>',
'    <th align="left">Organizer</th>',
'    <td>#ORGANIZER#</td>',
'  </tr>',
'  <tr>',
'    <th align="left">Event Date</th>',
'    <td>#EVENT_DATE#</td>',
'  </tr>',
'  <tr>',
'    <th align="left">Start Time</th>',
'    <td>#START_TIME#</td>',
'  </tr>',
'  <tr>',
'    <th align="left">Duration</th>',
'    <td>#DURATION#</td>',
'  </tr>',
'  <tr>',
'    <th align="left" valign="top">Location</th>',
'    <td>#LOCATION#</td>',
'  </tr>',
'  <tr>',
'    <th align="left">URL</th>',
'    <td><a href="#URL_LINK#">#URL_NAME#</a></td>',
'  </tr>',
'  <tr>',
'    <th align="left" valign="top">Notes</th>',
'    <td>#NOTES#</td>',
'  </tr>',
'</table>'))
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(177292894284112303)
,p_name=>'EMAIL.TEMPLATE.HTML_BODY_EXAMPLE.OD'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<strong>Hello #CUSTOMER_NAME#</strong>,<br>',
'<br>',
'Thank you for placing your order!<br>',
'<br>',
'<strong>Order Details</strong><br>',
'<br>',
'<table width="100%">',
'  <tr>',
'    <th align="left">Order Date</th>',
'    <td>#ORDER_DATE#</td>',
'  </tr>',
'  <tr>',
'    <th align="left">Order Number</th>',
'    <td>#ORDER_NUMBER#</td>',
'  </tr>',
'  <tr>',
'    <th align="left">Ship To</th>',
'    <td>#SHIP_TO#</td>',
'  </tr>',
'  <tr>',
'    <th align="left" valign="top">Shipping Address</th>',
'    <td>',
'      #SHIPPING_ADDRESS_LINE_1#<br>',
'      #SHIPPING_ADDRESS_LINE_2#',
'    </td>',
'  </tr>',
'  <tr>',
'    <th align="left" valign="top">Items Ordered</th>',
'    <td>#ITEMS_ORDERED#</td>',
'  </tr>',
'  <tr>',
'    <th align="left">Order Total</th>',
'    <td>#ORDER_TOTAL#</td>',
'  </tr>',
'</table>',
'<br>',
'<br>',
'Need to make a change to your order? <a href="#ORDER_URL#">Manage your order #ORDER_NUMBER# here.</a>'))
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(481899083519669572)
,p_name=>'EMAIL.TEMPLATE.HTML_BODY_EXAMPLE.SO'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Hello #SERVICE_USER#,<br>',
'<br>',
'Please be aware that your service #SERVICE_NAME# has an upcoming scheduled outage.<br>',
'The outage is scheduled to begin at #OUTAGE_START# and is planned to be unavailable for #OUTAGE_DURATION# #OUTAGE_TIMEFRAME#.<br>',
'<br>',
'The following will be performed during this scheduled outage:<br>',
'#OUTAGE_REASON#<br>',
'<br>',
'<br>',
'For any issues relating to this outage please contact #OUTAGE_CONTACT#.<br>',
'<br>',
'Thank you for your understanding,<br>',
'#SERVICE_TEAM#'))
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(481191972391345551)
,p_name=>'EMAIL.TEMPLATE.SUBJECT_EXAMPLE.EV'
,p_message_text=>'Event Reminder: #EVENT_NAME#'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(481192170701355144)
,p_name=>'EMAIL.TEMPLATE.SUBJECT_EXAMPLE.OD'
,p_message_text=>'Order (#ORDER_NUMBER#) Confirmed!'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(270669368302907263)
,p_name=>'EMAIL.TEMPLATE.TEXT_BODY_EXAMPLE.EV'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Hello #INVITEE#,',
'',
'This email is to remind you of an upcoming event you are associated with.',
'',
'Event Date: #EVENT_DATE#',
'Start Time: #START_TIME#',
'Duration:   #DURATION#',
'Organizer:  #ORGANIZER#',
'Location:   #LOCATION#',
'URL:        #URL_NAME# (#URL_LINK#)',
'Notes:      #NOTES#',
'',
'View additional event details here: #EVENT_LINK#'))
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(270653521379861150)
,p_name=>'EMAIL.TEMPLATE.TEXT_BODY_EXAMPLE.OD'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Hello #CUSTOMER_NAME#,',
'',
'Thank you for placing your order!',
'',
'Order Details',
'--------------------------------------------------------------------------------',
'  Order Date:       #ORDER_DATE#',
'  Order Number:     #ORDER_NUMBER#',
'  Ship To:          #SHIP_TO#',
'  Shipping Address: #SHIPPING_ADDRESS_LINE_1#',
'                    #SHIPPING_ADDRESS_LINE_2#',
'  Items Ordered:    #ITEMS_ORDERED#',
'  Order Total:      #ORDER_TOTAL#',
'--------------------------------------------------------------------------------',
'',
'Need to make a change to your order? Manage your order #ORDER_NUMBER# here: #ORDER_URL#'))
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(481898621288667766)
,p_name=>'EMAIL.TEMPLATE.TEXT_BODY_EXAMPLE.SO'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Hello #SERVICE_USER#,',
'',
'Please be aware that your service #SERVICE_NAME# has an upcoming scheduled outage.',
'The outage is scheduled to begin at #OUTAGE_START# and is planned to be unavailable for #OUTAGE_DURATION# #OUTAGE_TIMEFRAME#.',
'',
'The following will be performed during this scheduled outage:',
'#OUTAGE_REASON#',
'',
'For any issues relating to this outage please contact #OUTAGE_CONTACT#.',
'',
'Thank you for your understanding,',
'#SERVICE_TEAM#',
''))
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(201793625095426060)
,p_name=>'ENABLE_DEBUGGING'
,p_message_text=>'Enable Debugging Yes or No'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(18886617136177889)
,p_name=>'ENCRYPTION_INPUT_TOO_LONG'
,p_message_text=>'Length of value to be encrypted may not exceed 4000 bytes.'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(17810808211955434)
,p_name=>'END_USER'
,p_message_text=>'End User'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(171861228091833861)
,p_name=>'ENHANCEMENT_REQUEST'
,p_message_text=>'Enhancement Request'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(496735014367238388)
,p_name=>'ENHANCEMENT_REQUEST_DASH'
,p_message_text=>'Enhancement Requests: %1 of %0 closed'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(172715819582269695)
,p_name=>'ENTERED'
,p_message_text=>'Entered'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(166184219961533935)
,p_name=>'ENTRY LINK'
,p_message_text=>'Entry Link'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(166183715459532695)
,p_name=>'ENTRY TEXT'
,p_message_text=>'Entry Text'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(190189622892897230)
,p_name=>'ERROR PAGE TEMPLATE'
,p_message_text=>'Error Page Template'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(123652919513837836)
,p_name=>'ERRORPAGE'
,p_message_text=>'On Error Page'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(198245516383523130)
,p_name=>'ERRORS'
,p_message_text=>'Errors'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(166305326513104029)
,p_name=>'ERROR_ICON'
,p_message_text=>'Error Icon'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(955846819150853709)
,p_name=>'ERROR_MESSAGE'
,p_message_text=>'Error Message'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(161111212984184120)
,p_name=>'ESCAPED_COL_TOO_LARGE'
,p_message_text=>'<br><strong>Escaped Data exceeds allowed limit, results trimmed to 32k</strong>'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(88141602698839382)
,p_name=>'ESCAPE_SC'
,p_message_text=>'escape special characters'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(184003428654634768)
,p_name=>'ESTIMATED_EFFORT_IN_HOURS'
,p_message_text=>'Estimated Effort in Hours'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(418761822732654339)
,p_name=>'ETAG_QUERY'
,p_message_text=>'ETAG Query'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(418753915459652239)
,p_name=>'ETAG_TYPE'
,p_message_text=>'ETAG Type'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(171868306368884342)
,p_name=>'EVENT'
,p_message_text=>'Event'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(484995317511352603)
,p_name=>'EVENT.APEX.APEXAFTERREFRESH'
,p_message_text=>'After Refresh'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(485076930987879656)
,p_name=>'EVENT.APEX.APEXBEFOREPAGESUBMIT'
,p_message_text=>'Before Page Submit'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(484995113356351362)
,p_name=>'EVENT.APEX.APEXBEFOREREFRESH'
,p_message_text=>'Before Refresh'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(487346700888842532)
,p_name=>'EVENT.BROWSER'
,p_message_text=>'Browser Events'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(107041629257271653)
,p_name=>'EVENT.BROWSER.APEXDOUBLETAP'
,p_message_text=>'Double Tap'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(107042007054274843)
,p_name=>'EVENT.BROWSER.APEXPAN'
,p_message_text=>'Pan'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(107041864275273550)
,p_name=>'EVENT.BROWSER.APEXPRESS'
,p_message_text=>'Press'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(107042283230276155)
,p_name=>'EVENT.BROWSER.APEXSWIPE'
,p_message_text=>'Swipe'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(107041495807269483)
,p_name=>'EVENT.BROWSER.APEXTAP'
,p_message_text=>'Tap'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(484993411147341273)
,p_name=>'EVENT.BROWSER.CHANGE'
,p_message_text=>'Change'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(484992011362331854)
,p_name=>'EVENT.BROWSER.CLICK'
,p_message_text=>'Click'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(484992216557333343)
,p_name=>'EVENT.BROWSER.DBLCLICK'
,p_message_text=>'Double Click'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(484991025083326382)
,p_name=>'EVENT.BROWSER.FOCUSIN'
,p_message_text=>'Get Focus'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(484990210538322163)
,p_name=>'EVENT.BROWSER.FOCUSOUT'
,p_message_text=>'Lose Focus'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1601214705018515)
,p_name=>'EVENT.BROWSER.INPUT'
,p_message_text=>'Input'
,p_version_scn=>132225377
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(484994021882344390)
,p_name=>'EVENT.BROWSER.KEYDOWN'
,p_message_text=>'Key Down'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(484994702966348336)
,p_name=>'EVENT.BROWSER.KEYPRESS'
,p_message_text=>'Key Press'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(484994906083349294)
,p_name=>'EVENT.BROWSER.KEYUP'
,p_message_text=>'Key Release'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(484991228200327247)
,p_name=>'EVENT.BROWSER.LOAD'
,p_message_text=>'Resource Load'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(484992422098334933)
,p_name=>'EVENT.BROWSER.MOUSEDOWN'
,p_message_text=>'Mouse Button Press'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(484993002489338794)
,p_name=>'EVENT.BROWSER.MOUSEENTER'
,p_message_text=>'Mouse Enter'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(484993207684340316)
,p_name=>'EVENT.BROWSER.MOUSELEAVE'
,p_message_text=>'Mouse Leave'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(484992831448337683)
,p_name=>'EVENT.BROWSER.MOUSEMOVE'
,p_message_text=>'Mouse Move'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(484992626946336349)
,p_name=>'EVENT.BROWSER.MOUSEUP'
,p_message_text=>'Mouse Button Release'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5281515968954667)
,p_name=>'EVENT.BROWSER.ORIENTATIONCHANGE'
,p_message_text=>'Orientation Change'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(488323623842199026)
,p_name=>'EVENT.BROWSER.READY'
,p_message_text=>'Page Load'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(484991431317328187)
,p_name=>'EVENT.BROWSER.RESIZE'
,p_message_text=>'Resize'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(484991602012329168)
,p_name=>'EVENT.BROWSER.SCROLL'
,p_message_text=>'Scroll'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5281720470956028)
,p_name=>'EVENT.BROWSER.SCROLLSTART'
,p_message_text=>'Scroll Start'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5281923240956833)
,p_name=>'EVENT.BROWSER.SCROLLSTOP'
,p_message_text=>'Scroll Stop'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(484993613917342070)
,p_name=>'EVENT.BROWSER.SELECT'
,p_message_text=>'Select'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5279908565943120)
,p_name=>'EVENT.BROWSER.SWIPE'
,p_message_text=>'Swipe'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5280113067944340)
,p_name=>'EVENT.BROWSER.SWIPELEFT'
,p_message_text=>'Swipe Left'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5280316876945479)
,p_name=>'EVENT.BROWSER.SWIPERIGHT'
,p_message_text=>'Swipe Right'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5279530251939881)
,p_name=>'EVENT.BROWSER.TAP'
,p_message_text=>'Tap'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5279703024941527)
,p_name=>'EVENT.BROWSER.TAPHOLD'
,p_message_text=>'Tap and Hold'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(484991805821330322)
,p_name=>'EVENT.BROWSER.UNLOAD'
,p_message_text=>'Page Unload'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5281106618951950)
,p_name=>'EVENT.BROWSER.VCLICK'
,p_message_text=>'Virtual Click'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5281311466953400)
,p_name=>'EVENT.BROWSER.VMOUSECANCEL'
,p_message_text=>'Touch Cancel'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5280525880948113)
,p_name=>'EVENT.BROWSER.VMOUSEDOWN'
,p_message_text=>'Touch Start'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5280730036949270)
,p_name=>'EVENT.BROWSER.VMOUSEMOVE'
,p_message_text=>'Touch Move'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5280901770950630)
,p_name=>'EVENT.BROWSER.VMOUSEUP'
,p_message_text=>'Touch End'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(487347110238845223)
,p_name=>'EVENT.COMPONENT'
,p_message_text=>'Component Events'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1805896572298034)
,p_name=>'EVENT.COMPONENT.APEXSELECTIONCHANGE'
,p_message_text=>'Selection Change [Region]'
,p_version_scn=>8216292
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3782325278158105)
,p_name=>'EVENT.CUSTOM'
,p_message_text=>'Custom Event'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3782529434159334)
,p_name=>'EVENT.CUSTOM.CUSTOM'
,p_message_text=>'Custom'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(487346905390843830)
,p_name=>'EVENT.FRAMEWORK'
,p_message_text=>'Framework Events'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(136499668765818784)
,p_name=>'EVENT.FRAMEWORK.APEXAFTERCLOSECANCELDIALOG'
,p_message_text=>'Dialog Closed or Canceled'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(208944027692720500)
,p_name=>'EVENT.FRAMEWORK.APEXAFTERCLOSEDIALOG'
,p_message_text=>'Dialog Closed'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1083319309501404155)
,p_name=>'EVENT.FRAMEWORK.APEXAFTERREFRESH'
,p_message_text=>'After Refresh'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1083323413657405386)
,p_name=>'EVENT.FRAMEWORK.APEXBEFOREPAGESUBMIT'
,p_message_text=>'Before Page Submit'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1083309305345403011)
,p_name=>'EVENT.FRAMEWORK.APEXBEFOREREFRESH'
,p_message_text=>'Before Refresh'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(163582301828387091)
,p_name=>'EVENTS'
,p_message_text=>'Events'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(183998503589618131)
,p_name=>'EVENT_ID'
,p_message_text=>'Milestone Number'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(204379610360758976)
,p_name=>'EXACT_SUBS'
,p_message_text=>'Exact Substitutions'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(327980106735075998)
,p_name=>'EXAMPLE_1'
,p_message_text=>'Example 1'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(327995209506076788)
,p_name=>'EXAMPLE_2'
,p_message_text=>'Example 2'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(628864827214314488)
,p_name=>'EXAMPLE_OF_XML_COLUMN'
,p_message_text=>'This is an example of the data contained within an XML database column.'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(826875932566730545)
,p_name=>'EXAMPLE_URI'
,p_message_text=>'Example URI'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(272959522903959120)
,p_name=>'EXCLUDE'
,p_message_text=>'Exclude'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(246234331235507934)
,p_name=>'EXISTING_SCHEMA_NAME'
,p_message_text=>'Existing Schema Name'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(194470031998589246)
,p_name=>'EXISTS'
,p_message_text=>'Exists'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25594709605436753)
,p_name=>'EXISTS_SQL_QUERY'
,p_message_text=>'EXISTS SQL Query'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(471700213058088753)
,p_name=>'EXPANDED'
,p_message_text=>'Expanded'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(799702405779687700)
,p_name=>'EXPAND_ALL'
,p_message_text=>'Expand All'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(51596623304413900)
,p_name=>'EXPIRED'
,p_message_text=>'Expired'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(165989729388391701)
,p_name=>'EXPLAIN PLAN'
,p_message_text=>'Explain Plan'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(163584313949390509)
,p_name=>'EXPORT'
,p_message_text=>'Export'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(455023324582980796)
,p_name=>'EXPORT REPOSITORY'
,p_message_text=>'Export Repository'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(209771217779765237)
,p_name=>'EXPORTED_FROM_ANOTHER_WORKSPACE'
,p_message_text=>'Exported from another workspace or application.'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(209771622628766627)
,p_name=>'EXPORTED_FROM_CURRENT_WORKSPACE'
,p_message_text=>'Exported from current workspace.'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(282817829765196826)
,p_name=>'EXPORT_APPLICATION'
,p_message_text=>'Export Application'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(294712132733705328)
,p_name=>'EXPORT_PKG_APP_FOR_DEPLOYMENT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Use these links to download this application and its corresponding database supporting objects for deployment in a different Oracle APEX installation.  The downloaded files will be SQL Scripts that can be run from SQL*Plus, SQL Developer or SQL Scrip'
||'ts within Oracle APEX.',
''))
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(282818018119202181)
,p_name=>'EXPORT_SUPPORTING_OBJECTS'
,p_message_text=>'Export Supporting Objects'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(164662110029806941)
,p_name=>'EXPORT_TYPES.APP_EXPORT'
,p_message_text=>'Application Export  '
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(164662929422812474)
,p_name=>'EXPORT_TYPES.CSS_EXPORT'
,p_message_text=>'Cascading Style Sheets Export'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(164663712238817049)
,p_name=>'EXPORT_TYPES.FILE_EXPORT'
,p_message_text=>'Static File Export'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(164663305658815160)
,p_name=>'EXPORT_TYPES.IMAGE_EXPORT'
,p_message_text=>'Image Export'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(164662516609808862)
,p_name=>'EXPORT_TYPES.PAGE_EXPORT'
,p_message_text=>'Page Export'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(164664118818818925)
,p_name=>'EXPORT_TYPES.SCRIPT_FILE_EXPORT'
,p_message_text=>'Script File Export'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(160761125861699548)
,p_name=>'EXPORT_TYPES.UI_DEFAULTS'
,p_message_text=>'UI Defaults'
,p_version_scn=>117499000
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(135413608989368289)
,p_name=>'F4000.APPLICATION_COMPUTATION'
,p_message_text=>'Application Computation'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(134836429599062018)
,p_name=>'F4000.APPLICATION_ITEM'
,p_message_text=>'Application Item'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(135411426173363818)
,p_name=>'F4000.APPLICATION_PROCESS'
,p_message_text=>'Application Process'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86495111868973829)
,p_name=>'F4000.APPLICATION_RESERVED'
,p_message_text=>'Application ID''s 3000 through 8999 are reserved.'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25626813971569587)
,p_name=>'F4000.APP_EXPORT_CURR_WS'
,p_message_text=>'This application was exported from the current workspace.'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25627206137576727)
,p_name=>'F4000.APP_EXPORT_NON_CURR_WS'
,p_message_text=>'This application was exported from another workspace.'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(573900032205919046)
,p_name=>'F4000.APP_PRINT_CREDENTIALS'
,p_message_text=>'Application %0 Remote Print Server Credentials'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(573894419184828839)
,p_name=>'F4000.APP_REMOTE_PRINT_SERVER'
,p_message_text=>'Application %0 Remote Print Server'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(135410214053360310)
,p_name=>'F4000.BRANCH'
,p_message_text=>'Branch'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(141818720379119145)
,p_name=>'F4000.BRANCH_FROM_PAGE'
,p_message_text=>'Branch from page'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(141820528475130880)
,p_name=>'F4000.BRANCH_TO_PAGE'
,p_message_text=>'Branch to page'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(135404306649348711)
,p_name=>'F4000.BUTTON'
,p_message_text=>'Button'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(193801311939283265)
,p_name=>'F4000.BUTTON.ITEM'
,p_message_text=>'Button Item'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(45554027073404674)
,p_name=>'F4000.CALENDAR'
,p_message_text=>'Calendar'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(106621422382604572)
,p_name=>'F4000.CALENDAR_COLUMN'
,p_message_text=>'Calendar column.'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(142828325976224854)
,p_name=>'F4000.COLUMN_ATTRIBUTES'
,p_message_text=>'Column Attributes'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(646544751779955187)
,p_name=>'F4000.COLUMN_NAME_RESERVED_WORD'
,p_message_text=>'The identified column name is an Oracle reserved word.  Please choose another name.'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1453625237124072)
,p_name=>'F4000.COMPONENT_ACTION'
,p_message_text=>'Template Component Action'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(194891218104921825)
,p_name=>'F4000.COPY_LIST_ENTRY_X'
,p_message_text=>'Copy list entry: %0'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145989127122232867)
,p_name=>'F4000.DYNAMIC'
,p_message_text=>'Dynamic'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(34968010896570877)
,p_name=>'F4000.DYNAMIC ACTION'
,p_message_text=>'Dynamic Action'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(25624919110466918)
,p_name=>'F4000.EXPORT'
,p_message_text=>'Export'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(146312323752706572)
,p_name=>'F4000.FIX_ME'
,p_message_text=>'Fix Me'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145925525101986300)
,p_name=>'F4000.FOR_USER'
,p_message_text=>'For User'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145924317136984010)
,p_name=>'F4000.FOR_USER_SESSION'
,p_message_text=>'For User Session'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(141821031938131926)
,p_name=>'F4000.FROM'
,p_message_text=>'from'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3791272266079910)
,p_name=>'F4000.GENERATIVE_AI_CREDENTIALS'
,p_message_text=>'Generative AI Service Credentials'
,p_version_scn=>1409118629
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86524303351056557)
,p_name=>'F4000.HEADER_VALIDATION1'
,p_message_text=>'Header must contain <strong> &lt;head&gt;</strong> and <strong>&lt;/head&gt;</strong> tags.'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86532909715067781)
,p_name=>'F4000.HEADER_VALIDATION2'
,p_message_text=>'<strong>#HEAD#</strong> substitution string must appear between the <strong> &lt;head&gt;</strong> and <strong>&lt;/head&gt;</strong> tags.'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(170819532610079591)
,p_name=>'F4000.INVALID_FILE_TYPE'
,p_message_text=>'File "%0" is of invalid type.'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(24019747525798165)
,p_name=>'F4000.ITEM'
,p_message_text=>'Item'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(135393920586333770)
,p_name=>'F4000.ITEM_DISPLAY'
,p_message_text=>'Item Display'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(135398623141343968)
,p_name=>'F4000.ITEM_READ_ONLY'
,p_message_text=>'Item Read-only'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(10901814504383528)
,p_name=>'F4000.LEGACY_SQL'
,p_message_text=>'Legacy SQL'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(232345120989008657)
,p_name=>'F4000.LINK_COLUMN'
,p_message_text=>'Link Column'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(146365627176455163)
,p_name=>'F4000.LIST_INITCAP'
,p_message_text=>'List'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(135417011675388059)
,p_name=>'F4000.LIST_ITEM'
,p_message_text=>'List Item'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(10901630852381990)
,p_name=>'F4000.LOCAL'
,p_message_text=>'Local'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(135420311937406967)
,p_name=>'F4000.LOV_ENTRY'
,p_message_text=>'List of Values Entry'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(141823628952140566)
,p_name=>'F4000.MENU'
,p_message_text=>'Breadcrumb'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1453852652125363)
,p_name=>'F4000.MENU_ENTRY'
,p_message_text=>'Menu Entry'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(135417523103391279)
,p_name=>'F4000.MENU_OPTION'
,p_message_text=>'Breadcrumb Entry'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(150692517959064941)
,p_name=>'F4000.MUST_SELECT_AT_LEAST_ONE_TO_COPY'
,p_message_text=>'Must select at least one to copy or subscribe.'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(114115418066509874)
,p_name=>'F4000.NAVIGATION_BAR_ICON'
,p_message_text=>'Navigation&nbsp;Bar&nbsp;Icon'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(134491109598687258)
,p_name=>'F4000.NO'
,p_message_text=>'No'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145989606128236359)
,p_name=>'F4000.NOT_REFERENCED'
,p_message_text=>'Not Referenced'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(139984404907972703)
,p_name=>'F4000.NO_DATA_FOUND'
,p_message_text=>'No data found.'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1020631059651763715)
,p_name=>'F4000.P1.APP_DOES_NOT_EXIST'
,p_message_text=>'Application %0 does not exist in the current workspace.'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(493069300808102739)
,p_name=>'F4000.P1000.UPDATE_CHECK_DISABLED'
,p_message_text=>'Update Check disabled'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149230005333451280)
,p_name=>'F4000.P104.PARENT_TAB_NAME'
,p_message_text=>'Parent Tab Name'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(26435015781196447)
,p_name=>'F4000.P111.CANCEL_BUTTON_BRANCH'
,p_message_text=>'Cancel Button Branch'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(26432930710153401)
,p_name=>'F4000.P111.CANCEL_BUTTON_TEXT'
,p_message_text=>'Cancel Button Display Text'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(26435510718204416)
,p_name=>'F4000.P111.FINISH_BUTTON_BRANCH'
,p_message_text=>'Finish Button Branch'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(26433415388167940)
,p_name=>'F4000.P111.FINISH_BUTTON_TEXT'
,p_message_text=>'Finish Button Display Text'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(26434516343187176)
,p_name=>'F4000.P111.NEXT_BUTTON_TEXT'
,p_message_text=>'Next Button Display Text'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(26433829241171919)
,p_name=>'F4000.P111.PREVIOUS_BUTTON_TEXT'
,p_message_text=>'Previous Button Display Text'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149233800401468822)
,p_name=>'F4000.P112.TREE_PAGE'
,p_message_text=>'Tree Page'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149240430661487065)
,p_name=>'F4000.P119.GO'
,p_message_text=>'Go'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149249501271506953)
,p_name=>'F4000.P130.USING_SAME_TEMPLATE'
,p_message_text=>'Using the same templates as an existing application.'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1040898274196574090)
,p_name=>'F4000.P135.COPY'
,p_message_text=>'Copy %0'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(150848527560411361)
,p_name=>'F4000.P158.COPY_OF'
,p_message_text=>'Copy of %0'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1040435196889019226)
,p_name=>'F4000.P1701.LOOKUP_DEFINITION'
,p_message_text=>'Lookup Definition'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1029863567640079754)
,p_name=>'F4000.P1704.REGION_NAME'
,p_message_text=>'Region Name'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86515621658033438)
,p_name=>'F4000.P19.VALIDATION'
,p_message_text=>'Must specify at least one item to create not null validation.'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(609359051139062041)
,p_name=>'F4000.P1935.NAME'
,p_message_text=>'App %0 Print Server'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(508402824680318750)
,p_name=>'F4000.P2.UPDATE_EXPORT_SETTINGS'
,p_message_text=>'Update default export settings'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(561325578825071719)
,p_name=>'F4000.P203.ACTION='
,p_message_text=>'action='
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2001194728708208)
,p_name=>'F4000.P203.ACTIVITY='
,p_message_text=>'activity='
,p_version_scn=>38788295
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1454075680126956)
,p_name=>'F4000.P203.COLUMN='
,p_message_text=>'Column='
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(167455724744518449)
,p_name=>'F4000.P203.COMMENT='
,p_message_text=>'comment='
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(166938900897839755)
,p_name=>'F4000.P203.COMP.MSG'
,p_message_text=>'Used to run computation'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1289127918514452972)
,p_name=>'F4000.P203.CONCATENATED_FILE'
,p_message_text=>'Concatenated File'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2001391861711152)
,p_name=>'F4000.P203.CONDITION='
,p_message_text=>'condition='
,p_version_scn=>38788295
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(167101902712171368)
,p_name=>'F4000.P203.DISPVAL='
,p_message_text=>'display value='
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1289127654267446487)
,p_name=>'F4000.P203.FILE='
,p_message_text=>'file='
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(166956827618951511)
,p_name=>'F4000.P203.ICONBAR'
,p_message_text=>'Icon Bar'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(167110015656184621)
,p_name=>'F4000.P203.LOV='
,p_message_text=>'List of Values='
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(167098431193160737)
,p_name=>'F4000.P203.LOVDATA'
,p_message_text=>'List of Values Data'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(167077602272114512)
,p_name=>'F4000.P203.NAME='
,p_message_text=>'name='
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(166926719766807309)
,p_name=>'F4000.P203.PAGE.MSG'
,p_message_text=>'Used to display page'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(167425213653439494)
,p_name=>'F4000.P203.PAGEBRANCH'
,p_message_text=>'Page Branch'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(167129103021218788)
,p_name=>'F4000.P203.PGTEMP'
,p_message_text=>'Page Template'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(166947509648899048)
,p_name=>'F4000.P203.PROC.MSG'
,p_message_text=>'Used to run process'
,p_version_scn=>37165770887509
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(166944719990873578)
,p_name=>'F4000.P203.PROCESSING'
,p_message_text=>'Processing'
,p_version_scn=>37165770887510
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(167107825222177930)
,p_name=>'F4000.P203.RETVAL='
,p_message_text=>'return value='
,p_version_scn=>37165770887510
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2000980802706259)
,p_name=>'F4000.P203.VERSION='
,p_message_text=>'version='
,p_version_scn=>38788295
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1080731868950026785)
,p_name=>'F4000.P2222.REPARENT_LIST_ENTRY'
,p_message_text=>'Reparent List Entry'
,p_version_scn=>37165770887510
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(106605231530080434)
,p_name=>'F4000.P254.VALIDATION'
,p_message_text=>'Must specify at least one region to create.'
,p_version_scn=>37165770887510
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(134484504919647981)
,p_name=>'F4000.P277.WORKSPACE_NOT_CREATED_ALREADY_EXISTS'
,p_message_text=>'Workspace will not be created because it already exists.'
,p_version_scn=>37165770887510
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(134484919117652104)
,p_name=>'F4000.P277.WORKSPACE_WILL_BE_CREATED'
,p_message_text=>'Workspace will be created.'
,p_version_scn=>37165770887510
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1127352654100000526)
,p_name=>'F4000.P291.VIEW_LOCK'
,p_message_text=>'View Lock'
,p_version_scn=>37165770887510
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(106605707420082902)
,p_name=>'F4000.P295.VALIDATION'
,p_message_text=>'Must specify at least one page to create.'
,p_version_scn=>37165770887510
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1127569218931270327)
,p_name=>'F4000.P337.PAGE_UNLOCKED'
,p_message_text=>'This page is currently unlocked.'
,p_version_scn=>37165770887510
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(468676428466077911)
,p_name=>'F4000.P371.POPUP_LOV'
,p_message_text=>'Popup LOV'
,p_version_scn=>37165770887510
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149505327392725640)
,p_name=>'F4000.P374.POS.1'
,p_message_text=>'Pos.1'
,p_version_scn=>37165770887510
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149506512979730884)
,p_name=>'F4000.P374.POS.2'
,p_message_text=>'Pos.2'
,p_version_scn=>37165770887510
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149507032372736471)
,p_name=>'F4000.P374.POS.3'
,p_message_text=>'Pos.3'
,p_version_scn=>37165770887510
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149508511378739875)
,p_name=>'F4000.P374.POS.4'
,p_message_text=>'Pos.4'
,p_version_scn=>37165770887510
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(7839310130588292)
,p_name=>'F4000.P374.POS.5'
,p_message_text=>'Pos.5'
,p_version_scn=>37165770887510
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(255932528799792494)
,p_name=>'F4000.P374.POS.6'
,p_message_text=>'Pos.6'
,p_version_scn=>37165770887510
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(255972625348794093)
,p_name=>'F4000.P374.POS.7'
,p_message_text=>'Pos.7'
,p_version_scn=>37165770887510
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(255972823408794978)
,p_name=>'F4000.P374.POS.8'
,p_message_text=>'Pos.8'
,p_version_scn=>37165770887510
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149510900212755588)
,p_name=>'F4000.P381_XBUTTON_HELP'
,p_message_text=>'DML and pagination buttons require specific button names, reference help text.'
,p_version_scn=>37165770887510
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1041684749433736848)
,p_name=>'F4000.P386.CLASS_MATCHES'
,p_message_text=>'%0 (Class Matches)'
,p_version_scn=>37165770887510
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149518811902777873)
,p_name=>'F4000.P4001.AUTH_HOME'
,p_message_text=>'manage'
,p_version_scn=>37165770887510
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1289357884789314569)
,p_name=>'F4000.P4001.ORIGINAL_VALUE'
,p_message_text=>'Original Value'
,p_version_scn=>37165770887510
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149523324500791042)
,p_name=>'F4000.P4001.SUBSTITUTION_STR'
,p_message_text=>'Substitution String'
,p_version_scn=>37165770887510
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149528111256806092)
,p_name=>'F4000.P4001.SUBSTITUTION_VALUE'
,p_message_text=>'Substitution Value'
,p_version_scn=>37165770887510
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(139954013622729248)
,p_name=>'F4000.P4017.HELP_REGION_SOURCE'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<font class="instructiontext">This region will display page and item help for the current page when called using following syntax:<br>',
'<pre><escape sc>f?p=&AMP;APP_ID.:Page:Session:&APP_PAGE_ID.</pre></font>'))
,p_version_scn=>37165770887510
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149536101653860162)
,p_name=>'F4000.P4039.FORM_ON'
,p_message_text=>'Form on %0'
,p_version_scn=>37165770887510
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149541611958882055)
,p_name=>'F4000.P404.VALUES'
,p_message_text=>'Values'
,p_version_scn=>37165770887510
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(146336912716081944)
,p_name=>'F4000.P4045.ICON_SUBTEXT='
,p_message_text=>'Icon Subtext='
,p_version_scn=>37165770887510
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(146336506136080033)
,p_name=>'F4000.P4045.IMAGE='
,p_message_text=>'Image='
,p_version_scn=>37165770887510
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(146346315505234156)
,p_name=>'F4000.P4045.ITEM='
,p_message_text=>'Item='
,p_version_scn=>37165770887510
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(146341400090191825)
,p_name=>'F4000.P4045.LIST='
,p_message_text=>'List='
,p_version_scn=>37165770887510
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(146344205678221776)
,p_name=>'F4000.P4045.PAGE='
,p_message_text=>'Page='
,p_version_scn=>37165770887510
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(14567428133299857)
,p_name=>'F4000.P4045.REGION='
,p_message_text=>'Region='
,p_version_scn=>37165770887510
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(146348915983243760)
,p_name=>'F4000.P4045.TAB_SET='
,p_message_text=>'Tab Set='
,p_version_scn=>37165770887510
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(146341804246193034)
,p_name=>'F4000.P4045.TEXT='
,p_message_text=>'Text='
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1800725186659316)
,p_name=>'F4000.P4050.LIST_ENTRY_APP_PAGE'
,p_message_text=>'App %0, Page %1'
,p_comment=>'Used on 4000:4050 for formatted list entry target'
,p_version_scn=>126942743
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1800954903568108)
,p_name=>'F4000.P4050.LIST_ENTRY_PAGE'
,p_message_text=>'Page %0'
,p_comment=>'Used on 4000:4050 for list entry formatted target'
,p_version_scn=>126942847
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149738521316010734)
,p_name=>'F4000.P420.CSV_EXPORT'
,p_message_text=>'Download'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149742009720045217)
,p_name=>'F4000.P420.CVS'
,p_message_text=>'CSV'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149736631790994858)
,p_name=>'F4000.P420.DEFAULT_LOOK1'
,p_message_text=>'Default Look 1'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149737314259999238)
,p_name=>'F4000.P420.DEFAULT_LOOK2'
,p_message_text=>'Default Look 2'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149737728804003390)
,p_name=>'F4000.P420.DEFAULT_LOOK3'
,p_message_text=>'Default Look 3'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149738109196007207)
,p_name=>'F4000.P420.DEFAULT_LOOK4'
,p_message_text=>'Default Look 4'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149724227016898855)
,p_name=>'F4000.P420.EXTERNAL_PAGINATION'
,p_message_text=>'Use externally created pagination buttons'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149735608110978485)
,p_name=>'F4000.P420.HTML_STD'
,p_message_text=>'HTML standard look'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149740227812031526)
,p_name=>'F4000.P420.LOOK1'
,p_message_text=>'Look 1'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149740719285038548)
,p_name=>'F4000.P420.LOOK2'
,p_message_text=>'Look 2'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149741123441039740)
,p_name=>'F4000.P420.LOOK3'
,p_message_text=>'Look 3'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149741527597040876)
,p_name=>'F4000.P420.LOOK4'
,p_message_text=>'Look 4'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149728923254926132)
,p_name=>'F4000.P420.ROWS_X_TO_Y'
,p_message_text=>'Rows X to Y'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149727506500911832)
,p_name=>'F4000.P420.ROW_RANGE'
,p_message_text=>'Row Ranges 1-15 16-30 in select list'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149730606547940228)
,p_name=>'F4000.P420.SEARCH_ENGINE'
,p_message_text=>'Search Engine'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149727919660915626)
,p_name=>'F4000.P420.SEARCH_ENGINE_123'
,p_message_text=>'Search Engine 1,2,3,4 (set based pagination)'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149729512303932421)
,p_name=>'F4000.P420.SELECT_LIST'
,p_message_text=>'Select List'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149717203543797450)
,p_name=>'F4000.P420.SET_DEFAULTS'
,p_message_text=>'set defaults'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149723518920887018)
,p_name=>'F4000.P420.TURN_OFF_PAGINATION'
,p_message_text=>'turn off pagination'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149728508709921939)
,p_name=>'F4000.P420.USE_PAGINATION'
,p_message_text=>'Use pagination buttons'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149742524611049547)
,p_name=>'F4000.P420.XML'
,p_message_text=>'XML'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149739006556015915)
,p_name=>'F4000.P420.XML_EXPORT'
,p_message_text=>'XML Export'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149936809432979586)
,p_name=>'F4000.P422.GEN_LINK'
,p_message_text=>'Generate Link'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149726518490905829)
,p_name=>'F4000.P429.ROWS_X_TO_Y'
,p_message_text=>'Row Ranges X to Y (with next and previous links)'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1755110288040792178)
,p_name=>'F4000.P4311.P371.ALWAYS_NULL'
,p_message_text=>'Null'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(228670025726383922)
,p_name=>'F4000.P4311.P371.DB_COLUMN'
,p_message_text=>'DB Column'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(228676627720403406)
,p_name=>'F4000.P4311.P371.PLSQL_EXP'
,p_message_text=>'PL/SQL expression'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(228688627289422265)
,p_name=>'F4000.P4311.P371.PLSQL_FUNC_BODY'
,p_message_text=>'PL/SQL function body'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(228673321009392089)
,p_name=>'F4000.P4311.P371.SQL_QUERY'
,p_message_text=>'SQL Query'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(228664318669372478)
,p_name=>'F4000.P4311.P371.STATIC_TEXT'
,p_message_text=>'static text'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149952704864148621)
,p_name=>'F4000.P4314_XBUTTON_HELP'
,p_message_text=>'DML buttons require specific button names, reference help text.'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(30529711806817998)
,p_name=>'F4000.P4450.ACTION_CREATE'
,p_message_text=>'New plug-in will be created in application %0.'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(30529302802815350)
,p_name=>'F4000.P4450.ACTION_REPLACE'
,p_message_text=>'Existing plug-in in application %0 will be replaced.'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149965911809302066)
,p_name=>'F4000.P4651.HTML_W_SHORTCUTS'
,p_message_text=>'HTML w/shortcuts'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149967128562316298)
,p_name=>'F4000.P4651.PLSQL'
,p_message_text=>'PLSQL'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(146364809168449931)
,p_name=>'F4000.P4656.DEFAULT_BUTTON_TEMPLATE'
,p_message_text=>'Default Button Template'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(45552716768382833)
,p_name=>'F4000.P4656.DEFAULT_CALENDAR_TEMPLATE'
,p_message_text=>'Default Calendar Template'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1593341632279897777)
,p_name=>'F4000.P4656.DEFAULT_CHART_TEMPLATE'
,p_message_text=>'Default Chart Region Template'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(45362930554309485)
,p_name=>'F4000.P4656.DEFAULT_DIALOG_TEMPLATE'
,p_message_text=>'Default Dialog Page Template'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1593341848341898777)
,p_name=>'F4000.P4656.DEFAULT_FORM_TEMPLATE'
,p_message_text=>'Default Form Region Template'
,p_version_scn=>37165770887507
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1593342642256904297)
,p_name=>'F4000.P4656.DEFAULT_IRR_TEMPLATE'
,p_message_text=>'Default Interactive Report Region Template'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(146364431894446989)
,p_name=>'F4000.P4656.DEFAULT_LABEL_TEMPLATE'
,p_message_text=>'Default Label Template'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1593342049589900227)
,p_name=>'F4000.P4656.DEFAULT_LISTR_TEMPLATE'
,p_message_text=>'Default List Region Template'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(146364024621444875)
,p_name=>'F4000.P4656.DEFAULT_LIST_TEMPLATE'
,p_message_text=>'Default List Template'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1593343215016907111)
,p_name=>'F4000.P4656.DEFAULT_MENUR_TEMPLATE'
,p_message_text=>'Default Breadcrumb Region Template'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(146365217133452230)
,p_name=>'F4000.P4656.DEFAULT_MENU_TEMPLATE'
,p_message_text=>'Default Breadcrumb Template'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1593245256645659962)
,p_name=>'F4000.P4656.DEFAULT_NAV_BAR_LIST_TEMPLATE'
,p_message_text=>'Default Navigation Bar List Template'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1593244678295655997)
,p_name=>'F4000.P4656.DEFAULT_NAV_LIST_TEMPLATE'
,p_message_text=>'Default Navigation Menu List Template'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1593108425581398352)
,p_name=>'F4000.P4656.DEFAULT_OPTION_LABEL'
,p_message_text=>'Default Optional Label Template'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(146362026914436109)
,p_name=>'F4000.P4656.DEFAULT_PAGE_TEMPLATE'
,p_message_text=>'Default Page Template'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(146362432109437626)
,p_name=>'F4000.P4656.DEFAULT_REGION_TEMPLATE'
,p_message_text=>'Default Region Template'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1593342237419901266)
,p_name=>'F4000.P4656.DEFAULT_REPORTR_TEMPLATE'
,p_message_text=>'Default Report Region Template'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(146363616656442610)
,p_name=>'F4000.P4656.DEFAULT_REPORT_TEMPLATE'
,p_message_text=>'Default Report Template'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1593108645137399815)
,p_name=>'F4000.P4656.DEFAULT_REQUIRED_LABEL'
,p_message_text=>'Default Required Label Template'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1593245086817658499)
,p_name=>'F4000.P4656.DEFAULT_SIDE_NAV_LIST_TEMPLATE'
,p_message_text=>'Default Side Navigation Menu List Template'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1593342442356902776)
,p_name=>'F4000.P4656.DEFAULT_TABFORM_TEMPLATE'
,p_message_text=>'Default Tabular Form Region Template'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1593244806041657610)
,p_name=>'F4000.P4656.DEFAULT_TOP_NAV_LIST_TEMPLATE'
,p_message_text=>'Default Top Navigation Menu List Template'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1593342830241905787)
,p_name=>'F4000.P4656.DEFAULT_WIZARD_TEMPLATE'
,p_message_text=>'Default Wizard Region Template'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(146361621720434569)
,p_name=>'F4000.P4656.ERROR_PAGE_TEMPLATE'
,p_message_text=>'Default Error Page Template'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1593261710164753148)
,p_name=>'F4000.P4656.LOGIN_PAGE_TEMPLATE'
,p_message_text=>'Default Login Page Template'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(146361214101432431)
,p_name=>'F4000.P4656.PRINT_MODE_PAGE_TEMPLATE'
,p_message_text=>'Default Print Mode Page Template'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149544215552892476)
,p_name=>'F4000.P4703.REPORT_ON'
,p_message_text=>'Report on %0'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(148347221649290645)
,p_name=>'F4000.P4717.ALERT_INFO'
,p_message_text=>'alert information'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(148362209453381735)
,p_name=>'F4000.P4717.NEW_REGION'
,p_message_text=>'new region'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(148339400393274977)
,p_name=>'F4000.P4717.REGION_MUST_EXIST'
,p_message_text=>'You must create at least one region before you can create a page item.'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(148348525243301165)
,p_name=>'F4000.P4717.USE_WIZARD'
,p_message_text=>'Use a wizard to create a new region'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(148772917932046521)
,p_name=>'F4000.P4719.ALPHABETIC_SORT'
,p_message_text=>'will be sorted alphabetically'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(148774425682058235)
,p_name=>'F4000.P4719.BIND_VAR_LOV'
,p_message_text=>'Example 4: List of values with bind variable'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(148774009752053598)
,p_name=>'F4000.P4719.CREATION_SORT'
,p_message_text=>'sorted in order of creation'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(148769121480028654)
,p_name=>'F4000.P4719.D_R_LOV'
,p_message_text=>'Example 2: List of values with same display and return value'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(185570731231446623)
,p_name=>'F4000.P4719.INLINE'
,p_message_text=>'Example 5: Query contains in-line query, must ensure first FROM clause in the SQL statement is not part of the in-line query'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(148767928275021129)
,p_name=>'F4000.P4719.SQL_QUERY_LOV'
,p_message_text=>'Example 1: List of values based on SQL query'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(148771529229040279)
,p_name=>'F4000.P4719.STATIC_LOV'
,p_message_text=>'Example 3: Static list examples'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(148770411221035114)
,p_name=>'F4000.P4719.USE_ALIAS'
,p_message_text=>'When selecting the same column for both the display and return values use a column alias.'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(29880115309879630)
,p_name=>'F4000.P4719.YN'
,p_message_text=>'show Yes / No, return Y and N'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149984926980476737)
,p_name=>'F4000.P4728.AFTER_PROCESSING'
,p_message_text=>'After Processing'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149981712304463018)
,p_name=>'F4000.P4728.BEFORE_COMPUTATIONS'
,p_message_text=>'Before Computations'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149984414513473075)
,p_name=>'F4000.P4728.BEFORE_PROCESSING'
,p_message_text=>'Before Processing'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149983901354469348)
,p_name=>'F4000.P4728.BEFORE_VALIDATIONS'
,p_message_text=>'Before Validations'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(37390900837540334)
,p_name=>'F4000.P4731.ADD'
,p_message_text=>'Add Row'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149988123349513502)
,p_name=>'F4000.P4731.APPLY'
,p_message_text=>'Apply'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(32126726517376064)
,p_name=>'F4000.P4731.DELETE'
,p_message_text=>'Delete'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149990018763531084)
,p_name=>'F4000.P4731.FINISH'
,p_message_text=>'Finish'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149989419324521804)
,p_name=>'F4000.P4731.SUBMIT'
,p_message_text=>'Submit'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(150001112145576532)
,p_name=>'F4000.P4735_RP_ALL'
,p_message_text=>'Pagination will be reset for all pages in this application when this procedure runs.'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(151070807826999856)
,p_name=>'F4000.P4738.REGEXP_WARNING'
,p_message_text=>'WARNING: You have chosen a validation of type Regular Expression, however your version of the database does not support them.  This validation will always return true.'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(694731901671470687)
,p_name=>'F4000.P4761.TRANSLATIONS_NOT_USED'
,p_message_text=>'Translations for this application are currently not enabled. See <em>Application Language Derived From</em> setting in <a href="%0">Globalization Attributes</a>.'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1447898339712914164)
,p_name=>'F4000.P509.INSTANCE_MAX_SESSION_IDLE_SEC'
,p_message_text=>'When Maximum Session Idle Time is not set, the workspace level or instance level value will be used (currently, %0 seconds).'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1448056361887120303)
,p_name=>'F4000.P509.INSTANCE_MAX_SESSION_LENGTH_SEC'
,p_message_text=>'When Maximum Session Length is not set, the workspace level or instance level value will be used (currently, %0 seconds).'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1137633130163109359)
,p_name=>'F4000.P593.NEW_BRANCH'
,p_message_text=>'New Branch'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(210925907127579087)
,p_name=>'F4000.P598.EXPORTED_FROM_ANOTHER_APP_OR_WORKSPACE'
,p_message_text=>'These components were exported from a different application or from an application in a different workspace. The components cannot be installed in this application.'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(218892327152677275)
,p_name=>'F4000.P612.EXPORTED_FROM_ANOTHER_WORKSPACE'
,p_message_text=>'These files were exported from a different workspace. The files cannot be installed in this workspace.'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1137639903389218635)
,p_name=>'F4000.P622.TO_TEMPLATE'
,p_message_text=>'To Template'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1155933732255449972)
,p_name=>'F4000.P623.COPY_OPTION'
,p_message_text=>'Copy Option: %0'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1155933920906451468)
,p_name=>'F4000.P623.EXISTING_LOV'
,p_message_text=>'Existing List of Values: %0'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(176939516372005878)
,p_name=>'F4000.P67.EXPORTED_FROM_ANOTHER_APP_OR_WORKSPACE'
,p_message_text=>'This page was exported from a different application.'
,p_version_scn=>155114822
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(134002813305555778)
,p_name=>'F4000.P67.EXPORTED_FROM_ANOTHER_WORKSPACE'
,p_message_text=>'This page was exported from an application in another workspace.'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(134002220793548534)
,p_name=>'F4000.P67.EXPORTED_FROM_CURRENT_WORKSPACE'
,p_message_text=>'This page was exported from an application in the current workspace.'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(479778329505464176)
,p_name=>'F4000.P67.PAGE_LOCKED'
,p_message_text=>'This page is currently locked.  You cannot import over a locked page.  Please unlock the page and then install.'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1080734751826151865)
,p_name=>'F4000.P712.CLEAR_PARENT_ENTRY'
,p_message_text=>'Clear Parent Entry'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1146536660443540035)
,p_name=>'F4000.P765.SELECT_PARAM'
,p_message_text=>'Select Parameter %0'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86538323137090640)
,p_name=>'F4000.P818.VALIDATION'
,p_message_text=>'Must select at least one scheme to be copied.'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3346979597882557)
,p_name=>'F4000.P818.VALIDATION.NO_DUPLICATE_NAMES'
,p_message_text=>'There exists an authentication scheme with the same name: %0.'
,p_version_scn=>76607614
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(3346708718909220)
,p_name=>'F4000.P818.VALIDATION.NO_DUPLICATE_SUBSCRIPTION'
,p_message_text=>'There exists an authentication scheme which is subscribed to the same master authentication scheme: %0.'
,p_version_scn=>76603057
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1146562096651816614)
,p_name=>'F4000.P875.HTTP_HEADER_VAL'
,p_message_text=>'Value for HTTP Header %0'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1146560263847762174)
,p_name=>'F4000.P875.INPUT_PARAM_VAL'
,p_message_text=>'Value for Input Parameter %0'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1146738627667596028)
,p_name=>'F4000.P876.DELETE_HEADER'
,p_message_text=>'Delete Header'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1146735277742558688)
,p_name=>'F4000.P876.DELETE_PARAM'
,p_message_text=>'Delete Parameter: %0'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(150805707213036461)
,p_name=>'F4000.P904.REQUIRED_STYLE_SHEET'
,p_message_text=>'Required Style Sheet'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(141775604963076853)
,p_name=>'F4000.PAGE'
,p_message_text=>'Page'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(146036105342529459)
,p_name=>'F4000.PAGE_BUTTON'
,p_message_text=>'Page Button'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(135406121887353083)
,p_name=>'F4000.PAGE_COMPUTATION'
,p_message_text=>'Page Computation'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(46902724637541315)
,p_name=>'F4000.PAGE_DYNAMIC_ACTION'
,p_message_text=>'Page Dynamic Action'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2000732909495596)
,p_name=>'F4000.PAGE_DYNAMIC_ACTION_ACTION'
,p_message_text=>'Page Dynamic Action - Action'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(134837703065063771)
,p_name=>'F4000.PAGE_ITEM'
,p_message_text=>'Page Item'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2200685392212779)
,p_name=>'F4000.PAGE_ITEM_GROUP'
,p_message_text=>'Page Item Group'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(146366009299459372)
,p_name=>'F4000.PAGE_MAYBE_PLURAL'
,p_message_text=>'page(s)'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(13142322962515734)
,p_name=>'F4000.PAGE_META_TAG'
,p_message_text=>'Page Meta Tag'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(141779320894081452)
,p_name=>'F4000.PAGE_NAME'
,p_message_text=>'Page Name'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(135408332622356237)
,p_name=>'F4000.PAGE_PROCESS'
,p_message_text=>'Page Process'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(146035627028526237)
,p_name=>'F4000.PAGE_REGION'
,p_message_text=>'Page Region'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(146037732485546724)
,p_name=>'F4000.PAGE_VALIDATION'
,p_message_text=>'Page Validation'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(135416601632385149)
,p_name=>'F4000.PARENT_TAB'
,p_message_text=>'Parent Tab'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(142982813471268544)
,p_name=>'F4000.POPUP_LOV_TEMPLATE'
,p_message_text=>'Popup List of Values template'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(573899837554916324)
,p_name=>'F4000.PRINT_CREDENTIALS'
,p_message_text=>'Remote Print Server Credentials'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(143419401285016250)
,p_name=>'F4000.PUBLISH'
,p_message_text=>'Publish'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2001315230582138)
,p_name=>'F4000.PWA_PUSH_CREDENTIALS'
,p_message_text=>'PWA Push Notifications Credentials'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(13142169407514745)
,p_name=>'F4000.PWA_SCREENSHOT'
,p_message_text=>'PWA Screenshot'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(13141961116511676)
,p_name=>'F4000.PWA_SHORTCUT'
,p_message_text=>'PWA Shortcut'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(135391130497327247)
,p_name=>'F4000.REGION'
,p_message_text=>'Region'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(573545839995573569)
,p_name=>'F4000.REGION_COLUMNS'
,p_message_text=>'Region Column'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(141780228166083471)
,p_name=>'F4000.RELATED_PAGES_AND_COMPONENTS'
,p_message_text=>'Related Page(s) and Components'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(573901516543940452)
,p_name=>'F4000.REMOTE_DATABASE'
,p_message_text=>'REST Enabled SQL'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(185377920813253892)
,p_name=>'F4000.REPORT_COLUMN'
,p_message_text=>'Report Column'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(10902036710385063)
,p_name=>'F4000.REST_ENABLED_SQL'
,p_message_text=>'REST Enabled SQL'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1431441923389870)
,p_name=>'F4000.SEC_SCHEME_NAME_ALREADY_EXISTS'
,p_message_text=>'Authorization Scheme Name(s) %0 already exists.  Enter a new name.'
,p_version_scn=>16116982
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(1431242421386901)
,p_name=>'F4000.SEC_SCHEME_SUBSCRIPTION_ALREADY_EXISTS'
,p_message_text=>'Authorization scheme subscriptions(s) %0 already exists.  Choose a different authorization scheme.'
,p_version_scn=>16117032
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(143418725049013645)
,p_name=>'F4000.SEED'
,p_message_text=>'Seed'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(135416223319381907)
,p_name=>'F4000.STANDARD_TAB'
,p_message_text=>'Standard Tab'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145988612924228808)
,p_name=>'F4000.STATIC'
,p_message_text=>'Static'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(141824409690144388)
,p_name=>'F4000.TAB'
,p_message_text=>'Tab'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(143022808632342861)
,p_name=>'F4000.TEMPLATE'
,p_message_text=>'Template'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(5007329143011604)
,p_name=>'F4000.TEMPLATE_COMPONENT'
,p_message_text=>'Template Component'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(93404031792355486)
,p_name=>'F4000.TEMPLATE_NAME_ALREADY_EXISTS'
,p_message_text=>'Template Name(s) %0 already exists.  Enter a new name.'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86544517989117530)
,p_name=>'F4000.TEMPLATE_NAME_MAND'
,p_message_text=>'Template Name must be specified.'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(143385830084036014)
,p_name=>'F4000.THEME_IMPORT_CREATE'
,p_message_text=>'New theme will be created in application %0.'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(143386508051039115)
,p_name=>'F4000.THEME_IMPORT_REPLACE'
,p_message_text=>'Existing theme in application %0 will be replaced.'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(141819305965124455)
,p_name=>'F4000.TO'
,p_message_text=>'to'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(135421219902409341)
,p_name=>'F4000.UNKNOWN_APPLICATION_ELEMENT'
,p_message_text=>'Unknown Application Element'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(143422611290066454)
,p_name=>'F4000.UPDATEABLE_COLUMN'
,p_message_text=>'Updateable Column'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(193724713542174017)
,p_name=>'F4000.UTILITIES.INFO'
,p_message_text=>'Take actions or access reports across pages within the selected application.'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(135409204702357576)
,p_name=>'F4000.VALIDATION'
,p_message_text=>'Validation'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(10902201050386055)
,p_name=>'F4000.WEB_SOURCE'
,p_message_text=>'REST Data Source'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(573902319277950727)
,p_name=>'F4000.WEB_SRC_MODULE'
,p_message_text=>'REST Data Source'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(134489925744682388)
,p_name=>'F4000.YES'
,p_message_text=>'Yes'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(165249714489706664)
,p_name=>'F4000_4738_DATE_MMDDYYY'
,p_message_text=>'Date MMDDYYYY'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(293191102915326473)
,p_name=>'F4000_APPLICATIONS'
,p_message_text=>'Applications'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(62016702554585619)
,p_name=>'F4000_AS_APP_ON_EXIST_TABLE'
,p_message_text=>'As an application on a database table'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(147088014969938712)
,p_name=>'F4000_AS_APP_ON_EXIST_TABLES'
,p_message_text=>'As an application on database tables'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(150808127645042322)
,p_name=>'F4000_BUTTON_POS_NOT_IN_REGION'
,p_message_text=>'This button position is not in your region template'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(651618085775482117)
,p_name=>'F4000_CHART'
,p_message_text=>'Chart'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(150822203721158394)
,p_name=>'F4000_CLOSE'
,p_message_text=>'Close'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(153549405181508295)
,p_name=>'F4000_COPY_AND_SUBSCRIBE'
,p_message_text=>'Copy and Subscribe'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(150859819567532022)
,p_name=>'F4000_DATE_NOT_REC'
,p_message_text=>'Date format not recognized.'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(37271124481000772)
,p_name=>'F4000_F1500_LOCKED'
,p_message_text=>'Locked'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(196125709113497656)
,p_name=>'F4000_HELP_TEXT'
,p_message_text=>'Help Text'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(291143926462938285)
,p_name=>'F4000_LOV_NAME_EXISTS'
,p_message_text=>'List of Values Name(s) %0 already exists. Enter a new name.'
,p_version_scn=>70568158
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2617986382169395)
,p_name=>'F4000_LOV_NAME_EXISTS_SUBSCRIPTION'
,p_message_text=>'List of Values can not be copied. List of Values Name(s) %0 already exists.'
,p_version_scn=>70568292
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(2613062077237331)
,p_name=>'F4000_LOV_SUBSCRIPTIONS_EXISTS'
,p_message_text=>'List of Values subscriptions(s) %0 already exists. Choose a different List of Values.'
,p_version_scn=>70566054
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(156325827764888435)
,p_name=>'F4000_NONE_SELECTED'
,p_message_text=>'None Selected'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(145735912185499985)
,p_name=>'F4000_NO_APP_ASSOC'
,p_message_text=>'No Application Associated'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15607427552526611)
,p_name=>'F4000_OFF'
,p_message_text=>'Off'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(15607022704525241)
,p_name=>'F4000_ON'
,p_message_text=>'On'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(38660710153584840)
,p_name=>'F4000_P122_CAL_TEMPL'
,p_message_text=>'Calendar templates referencing this, template'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(177585711524722102)
,p_name=>'F4000_P128.VIEW_PAGES'
,p_message_text=>'view pages of this type'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86879717249789116)
,p_name=>'F4000_P173_NO_HELP'
,p_message_text=>'no help exists for this item'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86594326618242992)
,p_name=>'F4000_P1_AUTHENTICATION_HOME'
,p_message_text=>'authentication home'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(86593321078241432)
,p_name=>'F4000_P1_EDIT_THIS_TEMPLATE'
,p_message_text=>'Edit this template'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(87403413025738167)
,p_name=>'F4000_P232_RESET_CSS'
,p_message_text=>'Reset CSS'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(493109316682353244)
,p_name=>'F4000_P295_PAGE_EXISTS'
,p_message_text=>'Page already exists in this application.'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(37546123750494308)
,p_name=>'F4000_P295_PAGE_MUST_BE_NUMERIC'
,p_message_text=>'Page must be numeric.'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(37576114661510664)
,p_name=>'F4000_P295_PAGE_MUST_BE_POSITIVE'
,p_message_text=>'Page must be positive numbers.'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(37578007866518198)
,p_name=>'F4000_P295_PAGE_MUST_BE_WHOLE_NUMBER'
,p_message_text=>'Page must be whole numbers.'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(199283731134650209)
,p_name=>'F4000_P3005.IMPORT_AUTHORIZATION SCHEME'
,p_message_text=>'Import Authorization Scheme(s)'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(176127115356655918)
,p_name=>'F4000_P3005.IMPORT_AUTH_SCHEME'
,p_message_text=>'Import Authentication Scheme(s)'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(199285221568656902)
,p_name=>'F4000_P3005.IMPORT_NAVBAR'
,p_message_text=>'Import Navigation Bar(s)'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(176128100596661105)
,p_name=>'F4000_P3005.IMPORT_THEME'
,p_message_text=>'Import Theme'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(150024016787662983)
,p_name=>'F4000_P33_REGION_TITLE'
,p_message_text=>'Tabular Form'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(165127624242113325)
,p_name=>'F4000_P3890_AUTHENTICATED'
,p_message_text=>'Authenticated!'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(165129712599119454)
,p_name=>'F4000_P3890_AUTH_FAILED'
,p_message_text=>'Authentication failed!'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(155993209664776110)
,p_name=>'F4000_P395_NO_COLUMN'
,p_message_text=>'No Column'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(150902908689494047)
,p_name=>'F4000_P4001_UNAVAIL'
,p_message_text=>'This application is currently unavailable at this time.'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(78815025925985832)
,p_name=>'F4000_P430_DATE'
,p_message_text=>'Date: %0'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(78815409087990462)
,p_name=>'F4000_P430_DATE2'
,p_message_text=>'Date, flexible: %0 with any separator'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(78819131428034683)
,p_name=>'F4000_P430_DATE2_ERR'
,p_message_text=>'Date format not recognized'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(78818708226028033)
,p_name=>'F4000_P430_DATE_ERR'
,p_message_text=>'Date must be in the form %0'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(78813004622941846)
,p_name=>'F4000_P430_IP'
,p_message_text=>'IP Address'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(78816821685003558)
,p_name=>'F4000_P430_IP_ERR'
,p_message_text=>'Invalid IP Address'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(78813422284946942)
,p_name=>'F4000_P430_PHONE'
,p_message_text=>'Phone Number, US: %0'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(78813810425962453)
,p_name=>'F4000_P430_PHONE2'
,p_message_text=>'Phone Number, US flexible: 999.999.9999, (999)-999-9999, 999 999 9999, etc...'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(78817929781015296)
,p_name=>'F4000_P430_PHONE2_ERR'
,p_message_text=>'Phone number format not recognized'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(78817210388009717)
,p_name=>'F4000_P430_PHONE_ERR'
,p_message_text=>'Phone number must be in the form %0'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(78812622499937542)
,p_name=>'F4000_P430_URL'
,p_message_text=>'URL: http(s)://domain/path/doc.(pdf)(html)(etc...)'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(78816106794999238)
,p_name=>'F4000_P430_URL_ERR'
,p_message_text=>'Invalid URL'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(78814215405973269)
,p_name=>'F4000_P430_ZIP'
,p_message_text=>'ZIP Code: 99999'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(78814602030978955)
,p_name=>'F4000_P430_ZIP2'
,p_message_text=>'ZIP + 4: 99999-9999'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(78818323678023037)
,p_name=>'F4000_P430_ZIP_ERR'
,p_message_text=>'ZIP code must be in the form %0'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(39886304819402862)
,p_name=>'F4000_P4495.COPIED_FROM'
,p_message_text=>'Subscribed to Authentication'
,p_version_scn=>73092456
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(39886714515405621)
,p_name=>'F4000_P4495.MASTER'
,p_message_text=>'This is the "master" copy of this authentication scheme.'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(39887530792410336)
,p_name=>'F4000_P4495.NO_SUBSCRIPTION'
,p_message_text=>'There are no subscribers to this authentication scheme.'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(39887124904408640)
,p_name=>'F4000_P4495.REFERENCE'
,p_message_text=>'Applications subscribing to this Authentication Scheme'
,p_version_scn=>34185680
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(65386729108453214)
,p_name=>'F4000_P4495_LOV_NO_SCHEME'
,p_message_text=>'- no scheme -'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149969411509330281)
,p_name=>'F4000_P4701_PAGE_NAME'
,p_message_text=>'Report 1'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(150905031246528923)
,p_name=>'F4000_P4705_FORM_ON_A_PROC'
,p_message_text=>'Form on Stored Procedure'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149974304499347243)
,p_name=>'F4000_P4710_PAGE_NAME'
,p_message_text=>'Chart 1'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(150890108147954553)
,p_name=>'F4000_P4717_DISPLAY'
,p_message_text=>'Display Only'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(150889802953953043)
,p_name=>'F4000_P4717_HIDDEN'
,p_message_text=>'Hidden'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(150886413248899195)
,p_name=>'F4000_P4734_CLEAR_ITEMS'
,p_message_text=>'Clear Item(s) Cache'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(150886001474895803)
,p_name=>'F4000_P4734_CLEAR_PAGE'
,p_message_text=>'Clear Page(s) Cache'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(157352628773779755)
,p_name=>'F4000_P4734_RESET_PAG'
,p_message_text=>'Reset Pagination'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(150887300912905126)
,p_name=>'F4000_P4734_SET_ITEM'
,p_message_text=>'Set Item using PL/SQL function body'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(150886824330902446)
,p_name=>'F4000_P4734_STATIC_ITEM'
,p_message_text=>'Static Item Assignment'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(149995323311560818)
,p_name=>'F4000_P4735_INITIALIZE'
,p_message_text=>'All page items that are not cached in the current application will be initialized to null.'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(150893117656193812)
,p_name=>'F4000_P4737_EXISTS'
,p_message_text=>'Exists'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(150892218564184591)
,p_name=>'F4000_P4737_ITEM_NOT_NULL'
,p_message_text=>'Item Not Null'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(150892528261187430)
,p_name=>'F4000_P4737_ITEM_NOT_ZERO'
,p_message_text=>'Item Not Zero'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(150892809345191433)
,p_name=>'F4000_P4737_PLSQL_EXP'
,p_message_text=>'PL/SQL Expression'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(165258818906726794)
,p_name=>'F4000_P4738_DATE_DDMMYYYY'
,p_message_text=>'Date DDMMYYYY'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(165254621546718068)
,p_name=>'F4000_P4738_PHONE_NUM'
,p_message_text=>'Phone Number'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(818285481791031268)
,p_name=>'F4000_P473_DATABASE_OBJECT'
,p_message_text=>'Database Object'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(150010202411621032)
,p_name=>'F4000_P4759_VIEW'
,p_message_text=>'In Browser'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(150012031501629445)
,p_name=>'F4000_P4785_REGION_NAME'
,p_message_text=>'Calendar 1'
,p_version_scn=>37165770887508
);
wwv_flow_imp_shared.create_message(
 p_id=>wwv_flow_imp.id(65785219203598803)
,p_name=>'F4000_P4790_DATE_TIMESTAMP_NOTE'
,p_message_text=>'(containing Date 