import { type TestElement } from '../UNSAFE_driver';
interface ElementLocator {
    css: string;
}
export interface TestIdLocator extends ElementLocator {
}
/**
 * Create a locator that targets an element by its testId
 * @param testId
 * @returns The ElementLocator for the given testId
 */
export declare function getByTestId(testId: string): TestIdLocator;
/**
 * Perform an element search on the driver using the given ElementLocator
 * @param locator
 * @returns
 */
export declare function getElement(locator: ElementLocator): Promise<TestElement>;
export {};
