"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SeleniumDriver = void 0;
const selenium_webdriver_1 = require("selenium-webdriver");
class SeleniumDriver {
    constructor(driver) {
        this.driver = driver;
    }
    executeScript(script, ...args) {
        return this.driver.executeScript(script, ...args);
    }
    findElement(query) {
        return this.driver.findElement(selenium_webdriver_1.By.css(query)).then(wrapElement);
    }
    findElements(query) {
        return this.driver.findElements(selenium_webdriver_1.By.css(query)).then((els) => els.map(wrapElement));
    }
    sendKeys(element, text) {
        return element.el.sendKeys(text);
    }
    click(element) {
        return element.el.click();
    }
}
exports.SeleniumDriver = SeleniumDriver;
function wrapElement(element) {
    return new ElementWrapper(element);
}
class ElementWrapper {
    constructor(element) {
        this.el = element;
    }
    findElement(query) {
        return this.el.findElement(selenium_webdriver_1.By.css(query)).then(wrapElement);
    }
    findElements(query) {
        return this.el.findElements(selenium_webdriver_1.By.css(query)).then((els) => els.map(wrapElement));
    }
}
